"""Generated from mgga_x_mbrxh_bg.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  mbrxh_a1 = 0.23432

  mbrxh_a2 = 0.089

  mbrxh_a3 = 0.0053

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: mbrxh_a1 * (2 * t) - K_FACTOR_C + mbrxh_a2 * x ** 2 + mbrxh_a3 * x ** 4

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  mbrxh_a1 = 0.23432

  mbrxh_a2 = 0.089

  mbrxh_a3 = 0.0053

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: mbrxh_a1 * (2 * t) - K_FACTOR_C + mbrxh_a2 * x ** 2 + mbrxh_a3 * x ** 4

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  mbrxh_a1 = 0.23432

  mbrxh_a2 = 0.089

  mbrxh_a3 = 0.0053

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: mbrxh_a1 * (2 * t) - K_FACTOR_C + mbrxh_a2 * x ** 2 + mbrxh_a3 * x ** 4

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t21 * t22 * t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = r0 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = 0.1e1 / t30 / r0
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = jnp.pi ** 2
  t38 = t37 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t41 = 0.3e1 / 0.10e2 * t36 * t39
  t42 = r0 ** 2
  t44 = 0.1e1 / t30 / t42
  t47 = s0 ** 2
  t48 = t42 ** 2
  t51 = 0.1e1 / t29 / t48 / r0
  t54 = 0.46864e0 * tau0 * t32 - t41 + 0.89e-1 * s0 * t44 + 0.53e-2 * t47 * t51
  t55 = abs(t54)
  t56 = t55 < 0.50e-12
  t57 = 0.0e0 < t54
  t58 = f.my_piecewise3(t57, 0.50e-12, -0.50e-12)
  t59 = f.my_piecewise3(t56, t58, t54)
  t60 = br89_x(t59)
  t62 = jnp.exp(t60 / 0.3e1)
  t63 = t28 * t62
  t64 = jnp.exp(-t60)
  t67 = t64 * (0.1e1 + t60 / 0.2e1)
  t68 = 0.1e1 - t67
  t69 = 0.1e1 / t60
  t70 = t68 * t69
  t71 = t63 * t70
  t74 = f.my_piecewise3(t1, 0, -t27 * t71 / 0.4e1)
  t75 = r1 <= f.p.dens_threshold
  t76 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t77 = 0.1e1 + t76
  t78 = t77 <= f.p.zeta_threshold
  t79 = t77 ** (0.1e1 / 0.3e1)
  t81 = f.my_piecewise3(t78, t18, t79 * t77)
  t83 = t81 * t22 * t26
  t84 = r1 ** (0.1e1 / 0.3e1)
  t85 = t84 ** 2
  t87 = 0.1e1 / t85 / r1
  t90 = r1 ** 2
  t92 = 0.1e1 / t85 / t90
  t95 = s2 ** 2
  t96 = t90 ** 2
  t99 = 0.1e1 / t84 / t96 / r1
  t102 = 0.46864e0 * tau1 * t87 - t41 + 0.89e-1 * s2 * t92 + 0.53e-2 * t95 * t99
  t103 = abs(t102)
  t104 = t103 < 0.50e-12
  t105 = 0.0e0 < t102
  t106 = f.my_piecewise3(t105, 0.50e-12, -0.50e-12)
  t107 = f.my_piecewise3(t104, t106, t102)
  t108 = br89_x(t107)
  t110 = jnp.exp(t108 / 0.3e1)
  t111 = t28 * t110
  t112 = jnp.exp(-t108)
  t115 = t112 * (0.1e1 + t108 / 0.2e1)
  t116 = 0.1e1 - t115
  t117 = 0.1e1 / t108
  t118 = t116 * t117
  t119 = t111 * t118
  t122 = f.my_piecewise3(t75, 0, -t83 * t119 / 0.4e1)
  t123 = t2 ** 2
  t125 = t12 / t123
  t126 = t3 - t125
  t127 = f.my_piecewise5(t6, 0, t10, 0, t126)
  t130 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t127)
  t135 = t22 ** 2
  t136 = 0.1e1 / t135
  t140 = t21 * t136 * t26 * t71 / 0.12e2
  t141 = jnp.pi ** (0.1e1 / 0.3e1)
  t142 = t141 ** 2
  t143 = t28 * t142
  t144 = f.my_piecewise3(t57, 0, 0)
  t158 = f.my_piecewise3(t56, t144, -0.78106666666666666666666666666666666666666666666667e0 * tau0 * t44 - 0.23733333333333333333333333333333333333333333333333e0 * s0 / t30 / t42 / r0 - 0.28266666666666666666666666666666666666666666666667e-1 * t47 / t29 / t48 / t42)
  t161 = t59 ** 2
  t162 = 0.1e1 / t161
  t164 = jnp.exp(-0.2e1 / 0.3e1 * t60)
  t165 = 0.1e1 / t164
  t166 = t162 * t165
  t167 = t60 ** 2
  t170 = 0.1e1 / (t167 - 0.2e1 * t60 + 0.3e1)
  t173 = (t60 - 0.2e1) ** 2
  t176 = t166 * t170 * t173 * t62 * t70
  t179 = t142 * t158
  t181 = t170 * t173
  t182 = t181 * t67
  t187 = t165 * t170 * t173 * t64
  t196 = t27 * t63 * t68
  t198 = 0.1e1 / t167 * t142
  t200 = t166 * t181
  t205 = f.my_piecewise3(t1, 0, -t130 * t22 * t26 * t71 / 0.4e1 - t140 - t27 * t143 * t158 * t176 / 0.12e2 - t27 * t63 * (t179 * t166 * t182 - t179 * t162 * t187 / 0.2e1) * t69 / 0.4e1 + t196 * t198 * t158 * t200 / 0.4e1)
  t207 = f.my_piecewise5(t10, 0, t6, 0, -t126)
  t210 = f.my_piecewise3(t78, 0, 0.4e1 / 0.3e1 * t79 * t207)
  t218 = t81 * t136 * t26 * t119 / 0.12e2
  t220 = f.my_piecewise3(t75, 0, -t210 * t22 * t26 * t119 / 0.4e1 - t218)
  vrho_0_ = t74 + t122 + t2 * (t205 + t220)
  t223 = -t3 - t125
  t224 = f.my_piecewise5(t6, 0, t10, 0, t223)
  t227 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t224)
  t233 = f.my_piecewise3(t1, 0, -t227 * t22 * t26 * t71 / 0.4e1 - t140)
  t235 = f.my_piecewise5(t10, 0, t6, 0, -t223)
  t238 = f.my_piecewise3(t78, 0, 0.4e1 / 0.3e1 * t79 * t235)
  t243 = f.my_piecewise3(t105, 0, 0)
  t257 = f.my_piecewise3(t104, t243, -0.78106666666666666666666666666666666666666666666667e0 * tau1 * t92 - 0.23733333333333333333333333333333333333333333333333e0 * s2 / t85 / t90 / r1 - 0.28266666666666666666666666666666666666666666666667e-1 * t95 / t84 / t96 / t90)
  t260 = t107 ** 2
  t261 = 0.1e1 / t260
  t263 = jnp.exp(-0.2e1 / 0.3e1 * t108)
  t264 = 0.1e1 / t263
  t265 = t261 * t264
  t266 = t108 ** 2
  t269 = 0.1e1 / (t266 - 0.2e1 * t108 + 0.3e1)
  t272 = (t108 - 0.2e1) ** 2
  t275 = t265 * t269 * t272 * t110 * t118
  t278 = t142 * t257
  t280 = t269 * t272
  t281 = t280 * t115
  t286 = t264 * t269 * t272 * t112
  t295 = t83 * t111 * t116
  t297 = 0.1e1 / t266 * t142
  t299 = t265 * t280
  t304 = f.my_piecewise3(t75, 0, -t238 * t22 * t26 * t119 / 0.4e1 - t218 - t83 * t143 * t257 * t275 / 0.12e2 - t83 * t111 * (t278 * t265 * t281 - t278 * t261 * t286 / 0.2e1) * t117 / 0.4e1 + t295 * t297 * t257 * t299 / 0.4e1)
  vrho_1_ = t74 + t122 + t2 * (t233 + t304)
  t311 = f.my_piecewise3(t56, t144, 0.89e-1 * t44 + 0.106e-1 * s0 * t51)
  t316 = t142 * t311
  t332 = f.my_piecewise3(t1, 0, -t27 * t143 * t311 * t176 / 0.12e2 - t27 * t63 * (t316 * t166 * t182 - t316 * t162 * t187 / 0.2e1) * t69 / 0.4e1 + t196 * t198 * t311 * t200 / 0.4e1)
  vsigma_0_ = t2 * t332
  vsigma_1_ = 0.0e0
  t337 = f.my_piecewise3(t104, t243, 0.89e-1 * t92 + 0.106e-1 * s2 * t99)
  t342 = t142 * t337
  t358 = f.my_piecewise3(t75, 0, -t83 * t143 * t337 * t275 / 0.12e2 - t83 * t111 * (t342 * t265 * t281 - t342 * t261 * t286 / 0.2e1) * t117 / 0.4e1 + t295 * t297 * t337 * t299 / 0.4e1)
  vsigma_2_ = t2 * t358
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t360 = f.my_piecewise3(t56, t144, 0.46864e0 * t32)
  t365 = t142 * t360
  t381 = f.my_piecewise3(t1, 0, -t27 * t143 * t360 * t176 / 0.12e2 - t27 * t63 * (t365 * t166 * t182 - t365 * t162 * t187 / 0.2e1) * t69 / 0.4e1 + t196 * t198 * t360 * t200 / 0.4e1)
  vtau_0_ = t2 * t381
  t383 = f.my_piecewise3(t104, t243, 0.46864e0 * t87)
  t388 = t142 * t383
  t404 = f.my_piecewise3(t75, 0, -t83 * t143 * t383 * t275 / 0.12e2 - t83 * t111 * (t388 * t265 * t281 - t388 * t261 * t286 / 0.2e1) * t117 / 0.4e1 + t295 * t297 * t383 * t299 / 0.4e1)
  vtau_1_ = t2 * t404
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  mbrxh_a1 = 0.23432

  mbrxh_a2 = 0.089

  mbrxh_a3 = 0.0053

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: mbrxh_a1 * (2 * t) - K_FACTOR_C + mbrxh_a2 * x ** 2 + mbrxh_a3 * x ** 4

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t13 * t14 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = 2 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = tau0 * t22
  t24 = t14 ** 2
  t26 = 0.1e1 / t24 / r0
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t36 = s0 * t22
  t37 = r0 ** 2
  t39 = 0.1e1 / t24 / t37
  t42 = s0 ** 2
  t43 = t42 * t21
  t44 = t37 ** 2
  t47 = 0.1e1 / t14 / t44 / r0
  t50 = 0.46864e0 * t23 * t26 - 0.3e1 / 0.10e2 * t30 * t33 + 0.89e-1 * t36 * t39 + 0.106e-1 * t43 * t47
  t51 = abs(t50)
  t52 = t51 < 0.50e-12
  t53 = 0.0e0 < t50
  t54 = f.my_piecewise3(t53, 0.50e-12, -0.50e-12)
  t55 = f.my_piecewise3(t52, t54, t50)
  t56 = br89_x(t55)
  t58 = jnp.exp(t56 / 0.3e1)
  t59 = t20 * t58
  t60 = jnp.exp(-t56)
  t63 = t60 * (0.1e1 + t56 / 0.2e1)
  t64 = 0.1e1 - t63
  t65 = 0.1e1 / t56
  t66 = t64 * t65
  t67 = t59 * t66
  t70 = f.my_piecewise3(t2, 0, -t19 * t67 / 0.4e1)
  t76 = jnp.pi ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t78 = t20 * t77
  t79 = f.my_piecewise3(t53, 0, 0)
  t93 = f.my_piecewise3(t52, t79, -0.78106666666666666666666666666666666666666666666667e0 * t23 * t39 - 0.23733333333333333333333333333333333333333333333333e0 * t36 / t24 / t37 / r0 - 0.56533333333333333333333333333333333333333333333333e-1 * t43 / t14 / t44 / t37)
  t96 = t55 ** 2
  t97 = 0.1e1 / t96
  t99 = jnp.exp(-0.2e1 / 0.3e1 * t56)
  t100 = 0.1e1 / t99
  t101 = t97 * t100
  t102 = t56 ** 2
  t105 = 0.1e1 / (t102 - 0.2e1 * t56 + 0.3e1)
  t108 = (t56 - 0.2e1) ** 2
  t111 = t101 * t105 * t108 * t58 * t66
  t114 = t77 * t93
  t116 = t105 * t108
  t117 = t116 * t63
  t122 = t100 * t105 * t108 * t60
  t131 = t19 * t59 * t64
  t133 = 0.1e1 / t102 * t77
  t135 = t101 * t116
  t140 = f.my_piecewise3(t2, 0, -t13 / t24 * t18 * t67 / 0.12e2 - t19 * t78 * t93 * t111 / 0.12e2 - t19 * t59 * (t114 * t101 * t117 - t114 * t97 * t122 / 0.2e1) * t65 / 0.4e1 + t131 * t133 * t93 * t135 / 0.4e1)
  vrho_0_ = 0.2e1 * r0 * t140 + 0.2e1 * t70
  t149 = f.my_piecewise3(t52, t79, 0.89e-1 * t22 * t39 + 0.212e-1 * s0 * t21 * t47)
  t154 = t77 * t149
  t170 = f.my_piecewise3(t2, 0, -t19 * t78 * t149 * t111 / 0.12e2 - t19 * t59 * (t154 * t101 * t117 - t154 * t97 * t122 / 0.2e1) * t65 / 0.4e1 + t131 * t133 * t149 * t135 / 0.4e1)
  vsigma_0_ = 0.2e1 * r0 * t170
  vlapl_0_ = 0.0e0
  t174 = f.my_piecewise3(t52, t79, 0.46864e0 * t22 * t26)
  t179 = t77 * t174
  t195 = f.my_piecewise3(t2, 0, -t19 * t78 * t174 * t111 / 0.12e2 - t19 * t59 * (t179 * t101 * t117 - t179 * t97 * t122 / 0.2e1) * t65 / 0.4e1 + t131 * t133 * t174 * t135 / 0.4e1)
  vtau_0_ = 0.2e1 * r0 * t195
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t19 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / t19
  t21 = t13 / t15 * t20
  t22 = 4 ** (0.1e1 / 0.3e1)
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = tau0 * t24
  t27 = 0.1e1 / t15 / r0
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t37 = s0 * t24
  t38 = r0 ** 2
  t40 = 0.1e1 / t15 / t38
  t43 = s0 ** 2
  t44 = t43 * t23
  t45 = t38 ** 2
  t51 = 0.46864e0 * t25 * t27 - 0.3e1 / 0.10e2 * t31 * t34 + 0.89e-1 * t37 * t40 + 0.106e-1 * t44 / t14 / t45 / r0
  t52 = abs(t51)
  t53 = t52 < 0.50e-12
  t54 = 0.0e0 < t51
  t55 = f.my_piecewise3(t54, 0.50e-12, -0.50e-12)
  t56 = f.my_piecewise3(t53, t55, t51)
  t57 = br89_x(t56)
  t59 = jnp.exp(t57 / 0.3e1)
  t60 = t22 * t59
  t61 = jnp.exp(-t57)
  t64 = t61 * (0.1e1 + t57 / 0.2e1)
  t65 = 0.1e1 - t64
  t66 = 0.1e1 / t57
  t67 = t65 * t66
  t68 = t60 * t67
  t72 = t13 * t14 * t20
  t73 = jnp.pi ** (0.1e1 / 0.3e1)
  t74 = t73 ** 2
  t75 = t22 * t74
  t76 = f.my_piecewise3(t54, 0, 0)
  t79 = t38 * r0
  t81 = 0.1e1 / t15 / t79
  t90 = f.my_piecewise3(t53, t76, -0.78106666666666666666666666666666666666666666666667e0 * t25 * t40 - 0.23733333333333333333333333333333333333333333333333e0 * t37 * t81 - 0.56533333333333333333333333333333333333333333333333e-1 * t44 / t14 / t45 / t38)
  t91 = t75 * t90
  t92 = t72 * t91
  t93 = t56 ** 2
  t94 = 0.1e1 / t93
  t96 = jnp.exp(-0.2e1 / 0.3e1 * t57)
  t97 = 0.1e1 / t96
  t98 = t94 * t97
  t99 = t57 ** 2
  t101 = t99 - 0.2e1 * t57 + 0.3e1
  t102 = 0.1e1 / t101
  t103 = t98 * t102
  t104 = t57 - 0.2e1
  t105 = t104 ** 2
  t106 = t105 * t59
  t107 = t106 * t67
  t108 = t103 * t107
  t111 = t74 * t90
  t112 = t111 * t98
  t113 = t102 * t105
  t114 = t113 * t64
  t116 = t111 * t94
  t117 = t97 * t102
  t119 = t117 * t105 * t61
  t122 = t112 * t114 - t116 * t119 / 0.2e1
  t123 = t122 * t66
  t124 = t60 * t123
  t127 = t60 * t65
  t128 = t72 * t127
  t129 = 0.1e1 / t99
  t130 = t129 * t74
  t132 = t98 * t113
  t133 = t130 * t90 * t132
  t137 = f.my_piecewise3(t2, 0, -t21 * t68 / 0.12e2 - t92 * t108 / 0.12e2 - t72 * t124 / 0.4e1 + t128 * t133 / 0.4e1)
  t163 = f.my_piecewise3(t53, t76, 0.20828444444444444444444444444444444444444444444445e1 * t25 * t81 + 0.87022222222222222222222222222222222222222222222221e0 * t37 / t15 / t45 + 0.35804444444444444444444444444444444444444444444444e0 * t44 / t14 / t45 / t79)
  t168 = t90 ** 2
  t172 = 0.1e1 / t93 / t56
  t173 = t172 * t97
  t178 = t73 * jnp.pi
  t181 = t72 * t22 * t178 * t168
  t182 = t93 ** 2
  t183 = 0.1e1 / t182
  t184 = t96 ** 2
  t185 = 0.1e1 / t184
  t186 = t183 * t185
  t187 = t101 ** 2
  t188 = 0.1e1 / t187
  t189 = t186 * t188
  t190 = t105 ** 2
  t191 = t190 * t59
  t199 = t97 * t188
  t208 = 0.2e1 * t57 * t74 * t90 * t132 - 0.2e1 * t116 * t117 * t105
  t214 = t105 * t104
  t224 = t65 * t129
  t229 = t74 * t163
  t232 = t74 * t168
  t236 = t178 * t168
  t237 = t236 * t186
  t238 = t188 * t190
  t242 = t188 * t105
  t246 = t188 * t214
  t250 = t236 * t183
  t251 = t185 * t188
  t307 = t13 * t27 * t20 * t68 / 0.18e2 - t21 * t91 * t108 / 0.18e2 - t21 * t124 / 0.6e1 + t21 * t127 * t133 / 0.6e1 - t72 * t75 * t163 * t108 / 0.12e2 + t72 * t75 * t168 * t173 * t102 * t107 / 0.6e1 - t181 * t189 * t191 * t67 / 0.12e2 + t72 * t75 * t90 * t94 * t199 * t105 * t59 * t65 * t66 * t208 / 0.12e2 - t181 * t189 * t214 * t59 * t67 / 0.6e1 - t92 * t103 * t106 * t123 / 0.6e1 + t181 * t189 * t191 * t224 / 0.3e1 - t72 * t60 * (t229 * t98 * t114 - 0.2e1 * t232 * t173 * t114 - t237 * t238 * t64 / 0.3e1 - t112 * t242 * t64 * t208 + 0.2e1 * t237 * t246 * t64 + 0.2e1 / 0.3e1 * t250 * t251 * t190 * t61 - t229 * t94 * t119 / 0.2e1 + t232 * t172 * t119 + t112 * t242 * t61 * t208 / 0.2e1 - t250 * t251 * t214 * t61) * t66 / 0.4e1 + t72 * t60 * t122 * t133 / 0.2e1 - t128 / t99 / t57 * t178 * t168 * t186 * t238 / 0.2e1 + t128 * t130 * t163 * t132 / 0.4e1 - t128 * t130 * t168 * t173 * t113 / 0.2e1 - t72 * t60 * t224 * t116 * t199 * t105 * t208 / 0.4e1 + t128 * t129 * t178 * t168 * t186 * t246 / 0.2e1
  t308 = f.my_piecewise3(t2, 0, t307)
  v2rho2_0_ = 0.2e1 * r0 * t308 + 0.4e1 * t137
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = 0.1e1 / t15 / r0
  t20 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / t20
  t22 = t13 * t17 * t21
  t23 = 4 ** (0.1e1 / 0.3e1)
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = tau0 * t25
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t36 = s0 * t25
  t37 = r0 ** 2
  t39 = 0.1e1 / t15 / t37
  t42 = s0 ** 2
  t43 = t42 * t24
  t44 = t37 ** 2
  t45 = t44 * r0
  t50 = 0.46864e0 * t26 * t17 - 0.3e1 / 0.10e2 * t30 * t33 + 0.89e-1 * t36 * t39 + 0.106e-1 * t43 / t14 / t45
  t51 = abs(t50)
  t52 = t51 < 0.50e-12
  t53 = 0.0e0 < t50
  t54 = f.my_piecewise3(t53, 0.50e-12, -0.50e-12)
  t55 = f.my_piecewise3(t52, t54, t50)
  t56 = br89_x(t55)
  t58 = jnp.exp(t56 / 0.3e1)
  t59 = t23 * t58
  t60 = jnp.exp(-t56)
  t63 = t60 * (0.1e1 + t56 / 0.2e1)
  t64 = 0.1e1 - t63
  t65 = 0.1e1 / t56
  t66 = t64 * t65
  t67 = t59 * t66
  t72 = t13 / t15 * t21
  t73 = jnp.pi ** (0.1e1 / 0.3e1)
  t74 = t73 ** 2
  t75 = t23 * t74
  t76 = f.my_piecewise3(t53, 0, 0)
  t79 = t37 * r0
  t81 = 0.1e1 / t15 / t79
  t90 = f.my_piecewise3(t52, t76, -0.78106666666666666666666666666666666666666666666667e0 * t26 * t39 - 0.23733333333333333333333333333333333333333333333333e0 * t36 * t81 - 0.56533333333333333333333333333333333333333333333333e-1 * t43 / t14 / t44 / t37)
  t91 = t75 * t90
  t92 = t72 * t91
  t93 = t55 ** 2
  t94 = 0.1e1 / t93
  t96 = jnp.exp(-0.2e1 / 0.3e1 * t56)
  t97 = 0.1e1 / t96
  t98 = t94 * t97
  t99 = t56 ** 2
  t101 = t99 - 0.2e1 * t56 + 0.3e1
  t102 = 0.1e1 / t101
  t103 = t98 * t102
  t104 = t56 - 0.2e1
  t105 = t104 ** 2
  t106 = t105 * t58
  t107 = t106 * t66
  t108 = t103 * t107
  t111 = t74 * t90
  t112 = t111 * t98
  t113 = t102 * t105
  t114 = t113 * t63
  t116 = t111 * t94
  t117 = t97 * t102
  t119 = t117 * t105 * t60
  t122 = t112 * t114 - t116 * t119 / 0.2e1
  t123 = t122 * t65
  t124 = t59 * t123
  t127 = t59 * t64
  t128 = t72 * t127
  t129 = 0.1e1 / t99
  t130 = t129 * t74
  t132 = t98 * t113
  t133 = t130 * t90 * t132
  t137 = t13 * t14 * t21
  t141 = 0.1e1 / t15 / t44
  t150 = f.my_piecewise3(t52, t76, 0.20828444444444444444444444444444444444444444444445e1 * t26 * t81 + 0.87022222222222222222222222222222222222222222222221e0 * t36 * t141 + 0.35804444444444444444444444444444444444444444444444e0 * t43 / t14 / t44 / t79)
  t151 = t75 * t150
  t152 = t137 * t151
  t155 = t90 ** 2
  t156 = t75 * t155
  t157 = t137 * t156
  t159 = 0.1e1 / t93 / t55
  t160 = t159 * t97
  t161 = t160 * t102
  t162 = t161 * t107
  t165 = t73 * jnp.pi
  t166 = t23 * t165
  t167 = t166 * t155
  t168 = t137 * t167
  t169 = t93 ** 2
  t170 = 0.1e1 / t169
  t171 = t96 ** 2
  t172 = 0.1e1 / t171
  t173 = t170 * t172
  t174 = t101 ** 2
  t175 = 0.1e1 / t174
  t176 = t173 * t175
  t177 = t105 ** 2
  t178 = t177 * t58
  t179 = t178 * t66
  t180 = t176 * t179
  t183 = t90 * t94
  t184 = t75 * t183
  t185 = t137 * t184
  t186 = t97 * t175
  t187 = t186 * t105
  t188 = t58 * t64
  t189 = t56 * t74
  t192 = t117 * t105
  t195 = 0.2e1 * t189 * t90 * t132 - 0.2e1 * t116 * t192
  t196 = t65 * t195
  t197 = t188 * t196
  t198 = t187 * t197
  t201 = t105 * t104
  t202 = t201 * t58
  t203 = t202 * t66
  t204 = t176 * t203
  t207 = t137 * t91
  t208 = t106 * t123
  t209 = t103 * t208
  t212 = t64 * t129
  t213 = t178 * t212
  t214 = t176 * t213
  t217 = t74 * t150
  t218 = t217 * t98
  t220 = t74 * t155
  t221 = t220 * t160
  t224 = t165 * t155
  t225 = t224 * t173
  t226 = t175 * t177
  t227 = t226 * t63
  t230 = t175 * t105
  t231 = t63 * t195
  t232 = t230 * t231
  t234 = t175 * t201
  t235 = t234 * t63
  t238 = t224 * t170
  t239 = t172 * t175
  t240 = t177 * t60
  t241 = t239 * t240
  t244 = t217 * t94
  t247 = t220 * t159
  t249 = t60 * t195
  t250 = t230 * t249
  t254 = t239 * t201 * t60
  t256 = t218 * t114 - 0.2e1 * t221 * t114 - t225 * t227 / 0.3e1 - t112 * t232 + 0.2e1 * t225 * t235 + 0.2e1 / 0.3e1 * t238 * t241 - t244 * t119 / 0.2e1 + t247 * t119 + t112 * t250 / 0.2e1 - t238 * t254
  t257 = t256 * t65
  t258 = t59 * t257
  t261 = t59 * t122
  t262 = t137 * t261
  t265 = t137 * t127
  t267 = 0.1e1 / t99 / t56
  t268 = t267 * t165
  t270 = t173 * t226
  t271 = t268 * t155 * t270
  t275 = t130 * t150 * t132
  t279 = t160 * t113
  t280 = t130 * t155 * t279
  t283 = t59 * t212
  t284 = t137 * t283
  t286 = t186 * t105 * t195
  t287 = t116 * t286
  t290 = t129 * t165
  t292 = t173 * t234
  t293 = t290 * t155 * t292
  t296 = t22 * t67 / 0.18e2 - t92 * t108 / 0.18e2 - t72 * t124 / 0.6e1 + t128 * t133 / 0.6e1 - t152 * t108 / 0.12e2 + t157 * t162 / 0.6e1 - t168 * t180 / 0.12e2 + t185 * t198 / 0.12e2 - t168 * t204 / 0.6e1 - t207 * t209 / 0.6e1 + t168 * t214 / 0.3e1 - t137 * t258 / 0.4e1 + t262 * t133 / 0.2e1 - t265 * t271 / 0.2e1 + t265 * t275 / 0.4e1 - t265 * t280 / 0.2e1 - t284 * t287 / 0.4e1 + t265 * t293 / 0.2e1
  t297 = f.my_piecewise3(t2, 0, t296)
  t299 = t122 * t129
  t303 = t72 * t167
  t312 = t155 * t90
  t314 = t170 * t97
  t334 = 0.1e1 / t169 / t55
  t335 = t334 * t172
  t346 = t44 ** 2
  t352 = f.my_piecewise3(t52, t76, -0.76370962962962962962962962962962962962962962962965e1 * t26 * t141 - 0.40610370370370370370370370370370370370370370370370e1 * t36 / t15 / t45 - 0.26256592592592592592592592592592592592592592592592e1 * t43 / t14 / t346)
  t365 = t137 * t23 * t31 * t312
  t367 = 0.1e1 / t169 / t93
  t369 = 0.1e1 / t171 / t96
  t370 = t367 * t369
  t372 = 0.1e1 / t174 / t101
  t373 = t370 * t372
  t374 = t177 * t104
  t375 = t374 * t58
  t387 = t168 * t176 * t178 * t299 - t303 * t204 / 0.6e1 + t303 * t214 / 0.3e1 - t128 * t271 / 0.2e1 + t128 * t293 / 0.2e1 + 0.3e1 / 0.2e1 * t265 * t130 * t312 * t314 * t113 + t72 * t156 * t162 / 0.6e1 - t128 * t280 / 0.2e1 - t137 * t75 * t312 * t314 * t102 * t107 / 0.2e1 - 0.3e1 / 0.2e1 * t262 * t280 + 0.3e1 * t265 * t268 * t312 * t335 * t226 + t265 * t130 * t352 * t132 / 0.4e1 + 0.3e1 / 0.4e1 * t137 * t59 * t256 * t133 + 0.3e1 / 0.4e1 * t262 * t275 + 0.7e1 / 0.3e1 * t365 * t373 * t375 * t212 - t207 * t103 * t106 * t257 / 0.4e1 + t157 * t161 * t208 / 0.2e1
  t389 = t137 * t166 * t312
  t390 = t335 * t175
  t398 = t177 * t105
  t399 = t398 * t58
  t439 = t372 * t177
  t444 = t64 * t267
  t453 = t389 * t390 * t179 / 0.2e1 - t168 * t176 * t178 * t123 / 0.4e1 - 0.5e1 / 0.36e2 * t365 * t373 * t399 * t66 - t168 * t176 * t202 * t123 / 0.2e1 + t72 * t261 * t133 / 0.2e1 + t128 * t275 / 0.4e1 - t137 * t75 * t352 * t108 / 0.12e2 - t152 * t209 / 0.4e1 + t22 * t91 * t108 / 0.18e2 - t22 * t127 * t133 / 0.6e1 - t72 * t151 * t108 / 0.12e2 - t92 * t209 / 0.6e1 - t303 * t180 / 0.12e2 - 0.3e1 * t265 * t290 * t312 * t335 * t234 + 0.3e1 / 0.2e1 * t265 * t129 * t31 * t312 * t370 * t439 - 0.3e1 / 0.2e1 * t365 * t373 * t399 * t444 - 0.3e1 / 0.2e1 * t262 * t271 + 0.3e1 / 0.2e1 * t262 * t293
  t455 = t99 ** 2
  t459 = t372 * t398
  t466 = t372 * t374
  t488 = t137 * t59 * t444
  t489 = t172 * t372
  t500 = t97 * t372
  t501 = t195 ** 2
  t513 = t165 * t150
  t522 = t137 * t166 * t150 * t170
  t523 = t239 * t201
  t525 = t188 * t65 * t90
  t529 = t239 * t177
  t536 = t137 * t166 * t155 * t170
  t537 = t489 * t177
  t555 = t56 * t165 * t155
  t570 = 0.2e1 / 0.3e1 * t238 * t529 + 0.2e1 * t189 * t150 * t132 - 0.4e1 * t189 * t155 * t279 + 0.4e1 / 0.3e1 * t555 * t270 - 0.2e1 * t189 * t183 * t286 + 0.4e1 * t555 * t292 - 0.2e1 * t244 * t192 + 0.4e1 * t247 * t192 + 0.2e1 * t287 - 0.4e1 * t238 * t523
  t576 = 0.3e1 / 0.2e1 * t265 / t455 * t31 * t312 * t370 * t459 - 0.3e1 * t265 * t267 * t31 * t312 * t370 * t466 + t389 * t390 * t203 - 0.2e1 * t389 * t390 * t213 - 0.11e2 / 0.18e2 * t365 * t373 * t375 * t66 + 0.23e2 / 0.36e2 * t365 * t373 * t399 * t212 - t365 * t373 * t179 / 0.2e1 + 0.3e1 / 0.2e1 * t488 * t238 * t489 * t177 * t195 - 0.3e1 / 0.2e1 * t284 * t238 * t489 * t201 * t195 + t284 * t116 * t500 * t105 * t501 / 0.2e1 - t185 * t500 * t105 * t188 * t65 * t501 / 0.6e1 + 0.3e1 / 0.2e1 * t284 * t513 * t170 * t239 * t201 * t90 - t522 * t523 * t525 / 0.2e1 + t522 * t529 * t188 * t129 * t90 - t536 * t537 * t188 * t129 * t195 + t536 * t489 * t201 * t197 / 0.2e1 + t185 * t187 * t188 * t65 * t570 / 0.12e2
  t637 = t513 * t173
  t638 = t60 * t90
  t642 = t165 * t312
  t643 = t642 * t335
  t646 = t31 * t312
  t647 = t646 * t370
  t654 = t74 * t352
  t665 = t372 * t201
  t669 = t372 * t105
  t673 = t74 * t312
  t686 = t217 * t160
  t691 = 0.2e1 * t637 * t226 * t638 + 0.2e1 * t643 * t227 - t647 * t459 * t63 / 0.9e1 - 0.2e1 * t225 * t439 * t249 + t654 * t98 * t114 - 0.12e2 * t643 * t235 - 0.2e1 / 0.3e1 * t647 * t466 * t63 + 0.6e1 * t647 * t439 * t63 + 0.3e1 * t225 * t665 * t249 - t112 * t669 * t60 * t501 + 0.6e1 * t673 * t314 * t114 - 0.3e1 * t637 * t234 * t638 - 0.2e1 * t221 * t250 + t112 * t230 * t60 * t570 / 0.2e1 + 0.3e1 * t686 * t113 * t638 + t218 * t250
  t692 = t63 * t90
  t717 = t642 * t334
  t720 = t646 * t367
  t721 = t369 * t372
  t741 = -t637 * t226 * t692 + 0.4e1 * t221 * t232 + t225 * t439 * t231 + 0.2e1 * t112 * t669 * t63 * t501 + 0.6e1 * t637 * t234 * t692 - 0.6e1 * t225 * t665 * t231 - t112 * t230 * t63 * t570 - 0.6e1 * t686 * t113 * t692 - 0.2e1 * t218 * t232 + 0.6e1 * t717 * t254 - 0.3e1 * t720 * t721 * t240 + 0.10e2 / 0.3e1 * t720 * t721 * t374 * t60 - t654 * t94 * t119 / 0.2e1 + t720 * t721 * t398 * t60 / 0.18e2 - 0.4e1 * t717 * t241 - 0.3e1 * t673 * t170 * t119
  t755 = -0.3e1 / 0.4e1 * t137 * t59 * t299 * t287 - 0.3e1 / 0.2e1 * t488 * t165 * t90 * t170 * t239 * t177 * t150 - 0.3e1 / 0.2e1 * t284 * t217 * t159 * t117 * t105 * t90 - t284 * t244 * t286 / 0.2e1 + t284 * t247 * t286 - t284 * t116 * t186 * t105 * t570 / 0.4e1 + t72 * t184 * t198 / 0.12e2 - t72 * t283 * t287 / 0.4e1 + t137 * t75 * t150 * t159 * t192 * t525 / 0.2e1 + t137 * t75 * t150 * t94 * t198 / 0.6e1 - t522 * t529 * t525 / 0.4e1 - t137 * t75 * t155 * t159 * t198 / 0.3e1 + t536 * t537 * t197 / 0.4e1 + t185 * t187 * t58 * t122 * t196 / 0.4e1 - t137 * t59 * (t691 + t741) * t65 / 0.4e1 - t72 * t258 / 0.4e1 + t22 * t124 / 0.6e1 - 0.5e1 / 0.54e2 * t13 * t39 * t21 * t67
  t758 = f.my_piecewise3(t2, 0, t387 + t453 + t576 + t755)
  v3rho3_0_ = 0.2e1 * r0 * t758 + 0.6e1 * t297

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t13 * t14 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = 2 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = tau0 * t22
  t24 = t14 ** 2
  t26 = 0.1e1 / t24 / r0
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t36 = s0 * t22
  t37 = r0 ** 2
  t39 = 0.1e1 / t24 / t37
  t42 = s0 ** 2
  t43 = t42 * t21
  t44 = t37 ** 2
  t45 = t44 * r0
  t50 = 0.46864e0 * t23 * t26 - 0.3e1 / 0.10e2 * t30 * t33 + 0.89e-1 * t36 * t39 + 0.106e-1 * t43 / t14 / t45
  t51 = abs(t50)
  t52 = t51 < 0.50e-12
  t53 = 0.0e0 < t50
  t54 = f.my_piecewise3(t53, 0.50e-12, -0.50e-12)
  t55 = f.my_piecewise3(t52, t54, t50)
  t56 = br89_x(t55)
  t58 = jnp.exp(t56 / 0.3e1)
  t59 = t20 * t58
  t60 = jnp.exp(-t56)
  t62 = 0.1e1 + t56 / 0.2e1
  t63 = t60 * t62
  t64 = 0.1e1 - t63
  t65 = t59 * t64
  t66 = t19 * t65
  t67 = t56 ** 2
  t68 = 0.1e1 / t67
  t69 = jnp.pi ** (0.1e1 / 0.3e1)
  t70 = t69 * jnp.pi
  t71 = t68 * t70
  t72 = f.my_piecewise3(t53, 0, 0)
  t75 = t37 * r0
  t77 = 0.1e1 / t24 / t75
  t80 = t44 * t37
  t86 = f.my_piecewise3(t52, t72, -0.78106666666666666666666666666666666666666666666667e0 * t23 * t39 - 0.23733333333333333333333333333333333333333333333333e0 * t36 * t77 - 0.56533333333333333333333333333333333333333333333333e-1 * t43 / t14 / t80)
  t87 = t86 ** 2
  t88 = t87 * t86
  t90 = t55 ** 2
  t91 = t90 ** 2
  t93 = 0.1e1 / t91 / t55
  t95 = jnp.exp(-0.2e1 / 0.3e1 * t56)
  t96 = t95 ** 2
  t97 = 0.1e1 / t96
  t98 = t93 * t97
  t100 = t67 - 0.2e1 * t56 + 0.3e1
  t101 = t100 ** 2
  t102 = 0.1e1 / t101
  t103 = t56 - 0.2e1
  t104 = t103 ** 2
  t105 = t104 * t103
  t106 = t102 * t105
  t107 = t98 * t106
  t108 = t71 * t88 * t107
  t111 = t68 * t31
  t114 = 0.1e1 / t91 / t90
  t116 = 0.1e1 / t96 / t95
  t117 = t114 * t116
  t119 = 0.1e1 / t101 / t100
  t120 = t104 ** 2
  t121 = t119 * t120
  t122 = t117 * t121
  t123 = t111 * t88 * t122
  t126 = t20 * t70
  t127 = t126 * t87
  t128 = t19 * t127
  t129 = 0.1e1 / t91
  t130 = t129 * t97
  t131 = t130 * t102
  t132 = t120 * t58
  t133 = t69 ** 2
  t134 = t133 * t86
  t135 = 0.1e1 / t90
  t136 = 0.1e1 / t95
  t137 = t135 * t136
  t138 = t134 * t137
  t139 = 0.1e1 / t100
  t140 = t139 * t104
  t141 = t140 * t63
  t143 = t134 * t135
  t144 = t136 * t139
  t145 = t104 * t60
  t146 = t144 * t145
  t149 = t138 * t141 - t143 * t146 / 0.2e1
  t150 = t149 * t68
  t151 = t132 * t150
  t152 = t131 * t151
  t154 = t20 * t31
  t155 = t154 * t88
  t156 = t19 * t155
  t157 = t117 * t119
  t158 = t120 * t104
  t159 = t158 * t58
  t161 = 0.1e1 / t67 / t56
  t162 = t64 * t161
  t163 = t159 * t162
  t164 = t157 * t163
  t167 = t59 * t149
  t168 = t19 * t167
  t169 = t161 * t70
  t171 = t102 * t120
  t172 = t130 * t171
  t173 = t169 * t87 * t172
  t177 = t130 * t106
  t178 = t71 * t87 * t177
  t181 = t67 ** 2
  t182 = 0.1e1 / t181
  t183 = t182 * t31
  t185 = t119 * t158
  t186 = t117 * t185
  t187 = t183 * t88 * t186
  t190 = t161 * t31
  t192 = t120 * t103
  t193 = t119 * t192
  t194 = t117 * t193
  t195 = t190 * t88 * t194
  t198 = t126 * t88
  t199 = t19 * t198
  t200 = t98 * t102
  t201 = t105 * t58
  t202 = 0.1e1 / t56
  t203 = t64 * t202
  t204 = t201 * t203
  t205 = t200 * t204
  t207 = t20 * t133
  t208 = t207 * t87
  t209 = t19 * t208
  t210 = t90 * t55
  t211 = 0.1e1 / t210
  t212 = t211 * t136
  t213 = t212 * t139
  t214 = t104 * t58
  t215 = t149 * t202
  t216 = t214 * t215
  t217 = t213 * t216
  t220 = t132 * t203
  t221 = t200 * t220
  t224 = t132 * t215
  t225 = t131 * t224
  t228 = t159 * t203
  t229 = t157 * t228
  t232 = t201 * t215
  t233 = t131 * t232
  t238 = t13 / t24 * t18
  t239 = t238 * t167
  t240 = t68 * t133
  t242 = t137 * t140
  t243 = t240 * t86 * t242
  t246 = t238 * t65
  t250 = 0.1e1 / t24 / t44
  t259 = f.my_piecewise3(t52, t72, 0.20828444444444444444444444444444444444444444444445e1 * t23 * t77 + 0.87022222222222222222222222222222222222222222222221e0 * t36 * t250 + 0.35804444444444444444444444444444444444444444444444e0 * t43 / t14 / t44 / t75)
  t261 = t240 * t259 * t242
  t264 = t87 * t211
  t265 = t207 * t264
  t266 = t19 * t265
  t267 = t136 * t102
  t268 = t267 * t104
  t269 = t58 * t64
  t270 = t56 * t133
  t273 = t144 * t104
  t276 = 0.2e1 * t270 * t86 * t242 - 0.2e1 * t143 * t273
  t277 = t202 * t276
  t278 = t269 * t277
  t279 = t268 * t278
  t282 = -0.3e1 * t66 * t108 + 0.3e1 / 0.2e1 * t66 * t123 + t128 * t152 - 0.3e1 / 0.2e1 * t156 * t164 - 0.3e1 / 0.2e1 * t168 * t173 + 0.3e1 / 0.2e1 * t168 * t178 + 0.3e1 / 0.2e1 * t66 * t187 - 0.3e1 * t66 * t195 + t199 * t205 + t209 * t217 / 0.2e1 + t199 * t221 / 0.2e1 - t128 * t225 / 0.4e1 - 0.5e1 / 0.36e2 * t156 * t229 - t128 * t233 / 0.2e1 + t239 * t243 / 0.2e1 + t246 * t261 / 0.4e1 - t266 * t279 / 0.3e1
  t283 = t87 * t129
  t284 = t126 * t283
  t285 = t19 * t284
  t286 = t97 * t119
  t287 = t286 * t120
  t288 = t287 * t278
  t291 = t86 * t135
  t292 = t207 * t291
  t293 = t19 * t292
  t294 = t58 * t149
  t295 = t294 * t277
  t296 = t268 * t295
  t299 = t70 * t87
  t300 = t299 * t129
  t301 = t97 * t102
  t302 = t301 * t120
  t309 = t212 * t140
  t312 = t56 * t70
  t313 = t312 * t87
  t316 = t270 * t291
  t318 = t267 * t104 * t276
  t323 = t133 * t259
  t324 = t323 * t135
  t327 = t133 * t87
  t328 = t327 * t211
  t331 = t143 * t318
  t333 = t301 * t105
  t336 = 0.2e1 / 0.3e1 * t300 * t302 + 0.2e1 * t270 * t259 * t242 - 0.4e1 * t270 * t87 * t309 + 0.4e1 / 0.3e1 * t313 * t172 - 0.2e1 * t316 * t318 + 0.4e1 * t313 * t177 - 0.2e1 * t324 * t273 + 0.4e1 * t328 * t273 + 0.2e1 * t331 - 0.4e1 * t300 * t333
  t337 = t202 * t336
  t338 = t269 * t337
  t339 = t268 * t338
  t342 = t59 * t150
  t343 = t19 * t342
  t346 = t59 * t162
  t347 = t19 * t346
  t348 = t70 * t86
  t350 = t120 * t259
  t351 = t301 * t350
  t352 = t348 * t129 * t351
  t355 = t120 * t276
  t356 = t286 * t355
  t357 = t300 * t356
  t360 = t64 * t68
  t361 = t59 * t360
  t362 = t19 * t361
  t364 = t286 * t105 * t276
  t365 = t300 * t364
  t368 = t136 * t119
  t369 = t276 ** 2
  t371 = t368 * t104 * t369
  t372 = t143 * t371
  t375 = t368 * t104
  t376 = t202 * t369
  t377 = t269 * t376
  t378 = t375 * t377
  t381 = t70 * t259
  t384 = t301 * t105 * t86
  t385 = t381 * t129 * t384
  t388 = t259 * t129
  t390 = t19 * t126 * t388
  t392 = t269 * t202 * t86
  t393 = t333 * t392
  t396 = t68 * t86
  t398 = t302 * t269 * t396
  t400 = t68 * t276
  t401 = t269 * t400
  t402 = t287 * t401
  t404 = t286 * t105
  t405 = t404 * t278
  t410 = t144 * t104 * t86
  t411 = t323 * t211 * t410
  t414 = t324 * t318
  t417 = t328 * t318
  t420 = t267 * t104 * t336
  t421 = t143 * t420
  t424 = t285 * t288 / 0.4e1 + t293 * t296 / 0.4e1 + t293 * t339 / 0.12e2 - 0.3e1 / 0.4e1 * t343 * t331 - 0.3e1 / 0.2e1 * t347 * t352 + 0.3e1 / 0.2e1 * t347 * t357 - 0.3e1 / 0.2e1 * t362 * t365 + t362 * t372 / 0.2e1 - t293 * t378 / 0.6e1 + 0.3e1 / 0.2e1 * t362 * t385 - t390 * t393 / 0.2e1 + t390 * t398 - t285 * t402 + t285 * t405 / 0.2e1 - 0.3e1 / 0.2e1 * t362 * t411 - t362 * t414 / 0.2e1 + t362 * t417 - t362 * t421 / 0.4e1
  t426 = t238 * t292
  t429 = t238 * t361
  t432 = t259 * t211
  t434 = t19 * t207 * t432
  t435 = t273 * t392
  t438 = t259 * t135
  t439 = t207 * t438
  t440 = t19 * t439
  t443 = t302 * t392
  t449 = 0.1e1 / t24 / t45
  t452 = t44 ** 2
  t458 = f.my_piecewise3(t52, t72, -0.76370962962962962962962962962962962962962962962965e1 * t23 * t250 - 0.40610370370370370370370370370370370370370370370370e1 * t36 * t449 - 0.26256592592592592592592592592592592592592592592592e1 * t43 / t14 / t452)
  t459 = t207 * t458
  t460 = t19 * t459
  t461 = t137 * t139
  t462 = t214 * t203
  t463 = t461 * t462
  t466 = t207 * t259
  t467 = t19 * t466
  t468 = t461 * t216
  t472 = t13 * t26 * t18
  t473 = t207 * t86
  t474 = t472 * t473
  t477 = t132 * t360
  t478 = t200 * t477
  t481 = t192 * t58
  t482 = t481 * t203
  t483 = t157 * t482
  t486 = t159 * t360
  t487 = t157 * t486
  t490 = t157 * t220
  t493 = t481 * t360
  t494 = t157 * t493
  t498 = t240 * t458 * t242
  t501 = t323 * t137
  t503 = t327 * t212
  t506 = t299 * t130
  t507 = t171 * t63
  t510 = t102 * t104
  t511 = t63 * t276
  t512 = t510 * t511
  t514 = t106 * t63
  t517 = t120 * t60
  t518 = t301 * t517
  t524 = t60 * t276
  t525 = t510 * t524
  t528 = t105 * t60
  t529 = t301 * t528
  t531 = t501 * t141 - 0.2e1 * t503 * t141 - t506 * t507 / 0.3e1 - t138 * t512 + 0.2e1 * t506 * t514 + 0.2e1 / 0.3e1 * t300 * t518 - t324 * t146 / 0.2e1 + t328 * t146 + t138 * t525 / 0.2e1 - t300 * t529
  t532 = t59 * t531
  t533 = t19 * t532
  t538 = t19 * t473
  t539 = t531 * t202
  t540 = t214 * t539
  t541 = t461 * t540
  t544 = t426 * t279 / 0.12e2 - t429 * t331 / 0.4e1 + t434 * t435 / 0.2e1 + t440 * t279 / 0.6e1 - t390 * t443 / 0.4e1 - t460 * t463 / 0.12e2 - t467 * t468 / 0.4e1 + t474 * t463 / 0.18e2 - 0.2e1 * t199 * t478 - 0.11e2 / 0.18e2 * t156 * t483 + 0.23e2 / 0.36e2 * t156 * t487 - t156 * t490 / 0.2e1 + 0.7e1 / 0.3e1 * t156 * t494 + t66 * t498 / 0.4e1 + 0.3e1 / 0.4e1 * t533 * t243 + 0.3e1 / 0.4e1 * t168 * t261 - t538 * t541 / 0.4e1
  t545 = t238 * t127
  t546 = t131 * t204
  t549 = t131 * t477
  t557 = t129 * t136
  t558 = t557 * t140
  t559 = t240 * t88 * t558
  t562 = t238 * t208
  t563 = t213 * t462
  t567 = t240 * t87 * t309
  t570 = t207 * t88
  t571 = t19 * t570
  t572 = t557 * t139
  t573 = t572 * t462
  t579 = t98 * t171
  t580 = t169 * t88 * t579
  t583 = t472 * t65
  t586 = t238 * t466
  t589 = t238 * t473
  t592 = t131 * t220
  t595 = t119 * t105
  t596 = t595 * t511
  t599 = t63 * t336
  t600 = t510 * t599
  t602 = t323 * t212
  t603 = t63 * t86
  t604 = t140 * t603
  t609 = t31 * t88
  t610 = t609 * t117
  t611 = t121 * t63
  t614 = t595 * t524
  t617 = t119 * t104
  t618 = t60 * t369
  t619 = t617 * t618
  t621 = t133 * t88
  t622 = t621 * t557
  t625 = t381 * t130
  t626 = t60 * t86
  t627 = t106 * t626
  t632 = t60 * t336
  t633 = t510 * t632
  t636 = t140 * t626
  t640 = t70 * t88
  t641 = t640 * t98
  t644 = t185 * t63
  t647 = t121 * t524
  t650 = -0.6e1 * t506 * t596 - t138 * t600 - 0.6e1 * t602 * t604 - 0.2e1 * t501 * t512 + 0.6e1 * t610 * t611 + 0.3e1 * t506 * t614 - t138 * t619 + 0.6e1 * t622 * t141 - 0.3e1 * t625 * t627 - 0.2e1 * t503 * t525 + t138 * t633 / 0.2e1 + 0.3e1 * t602 * t636 + t501 * t525 + 0.2e1 * t641 * t507 - t610 * t644 / 0.9e1 - 0.2e1 * t506 * t647
  t651 = t133 * t458
  t652 = t651 * t137
  t654 = t171 * t626
  t659 = t193 * t63
  t662 = t171 * t603
  t666 = t121 * t511
  t668 = t63 * t369
  t669 = t617 * t668
  t672 = t106 * t603
  t675 = t640 * t93
  t678 = t609 * t114
  t679 = t116 * t119
  t680 = t679 * t517
  t683 = t192 * t60
  t684 = t679 * t683
  t687 = t651 * t135
  t690 = t158 * t60
  t691 = t679 * t690
  t696 = t621 * t129
  t699 = t652 * t141 + 0.2e1 * t625 * t654 - 0.12e2 * t641 * t514 - 0.2e1 / 0.3e1 * t610 * t659 - t625 * t662 + 0.4e1 * t503 * t512 + t506 * t666 + 0.2e1 * t138 * t669 + 0.6e1 * t625 * t672 + 0.6e1 * t675 * t529 - 0.3e1 * t678 * t680 + 0.10e2 / 0.3e1 * t678 * t684 - t687 * t146 / 0.2e1 + t678 * t691 / 0.18e2 - 0.4e1 * t675 * t518 - 0.3e1 * t696 * t146
  t700 = t650 + t699
  t701 = t700 * t202
  t702 = t59 * t701
  t705 = t59 * t539
  t708 = t59 * t215
  t712 = t13 * t39 * t18
  t713 = t59 * t203
  t716 = -t545 * t546 / 0.6e1 + t545 * t549 / 0.3e1 - t246 * t173 / 0.2e1 + t246 * t178 / 0.2e1 + 0.3e1 / 0.2e1 * t66 * t559 + t562 * t563 / 0.6e1 - t246 * t567 / 0.2e1 - t571 * t573 / 0.2e1 - 0.3e1 / 0.2e1 * t168 * t567 + 0.3e1 * t66 * t580 - t583 * t243 / 0.6e1 - t586 * t463 / 0.12e2 - t589 * t468 / 0.6e1 - t545 * t592 / 0.12e2 - t19 * t702 / 0.4e1 - t238 * t705 / 0.4e1 + t472 * t708 / 0.6e1 - 0.5e1 / 0.54e2 * t712 * t713
  t719 = f.my_piecewise3(t2, 0, t282 + t424 + t544 + t716)
  t729 = t19 * t154 * t87 * t114
  t730 = t679 * t158
  t736 = t31 * t87
  t737 = t736 * t114
  t742 = t101 ** 2
  t743 = 0.1e1 / t742
  t744 = t116 * t743
  t753 = t202 * t259
  t754 = t269 * t753
  t755 = t273 * t754
  t764 = t126 * t86 * t129
  t765 = t238 * t764
  t766 = t302 * t754
  t769 = t238 * t284
  t772 = t299 * t93
  t786 = t19 * t126 * t458 * t129
  t789 = 0.4e1 * t343 * t417 - 0.4e1 * t285 * t287 * t294 * t400 - 0.9e1 * t729 * t730 * t269 * t161 * t259 + 0.9e1 * t362 * t737 * t679 * t350 - 0.9e1 * t362 * t678 * t744 * t355 + 0.4e1 / 0.3e1 * t429 * t417 - 0.3e1 * t19 * t207 * t283 * t755 + 0.3e1 / 0.2e1 * t19 * t207 * t88 * t129 * t279 - t765 * t766 / 0.3e1 + t769 * t288 / 0.3e1 - 0.18e2 * t362 * t772 * t301 * t105 * t259 + 0.14e2 * t362 * t675 * t364 - t472 * t292 * t279 / 0.9e1 - t786 * t443 / 0.3e1
  t799 = t381 * t98
  t800 = t60 * t87
  t804 = t87 ** 2
  t805 = t31 * t804
  t807 = 0.1e1 / t91 / t210
  t808 = t807 * t116
  t809 = t805 * t808
  t812 = t133 * t31
  t813 = t812 * t804
  t814 = t91 ** 2
  t815 = 0.1e1 / t814
  t816 = t96 ** 2
  t817 = 0.1e1 / t816
  t818 = t815 * t817
  t819 = t813 * t818
  t820 = t120 * t105
  t821 = t743 * t820
  t825 = t743 * t192
  t829 = t70 * t458
  t830 = t829 * t130
  t833 = t743 * t158
  t849 = f.my_piecewise3(t52, t72, 0.35639782716049382716049382716049382716049382716050e2 * t23 * t449 + 0.23012543209876543209876543209876543209876543209876e2 * t36 / t24 / t80 + 0.21880493827160493827160493827160493827160493827160e2 * t43 / t14 / t452 / r0)
  t850 = t133 * t849
  t856 = t31 * t259 * t117
  t870 = t805 * t807
  t873 = t133 * t804
  t877 = t70 * t804
  t878 = t877 * t114
  t883 = t813 * t815
  t884 = t817 * t743
  t888 = t736 * t117
  t889 = t63 * t259
  t893 = t743 * t120
  t897 = t524 * t86
  t901 = 0.4e1 / 0.3e1 * t809 * t644 - 0.18e2 * t323 * t557 * t140 * t800 - t850 * t135 * t146 / 0.2e1 - 0.2e1 / 0.3e1 * t870 * t691 + 0.12e2 * t873 * t93 * t146 - 0.36e2 * t878 * t529 + 0.36e2 * t870 * t680 - 0.12e2 * t883 * t884 * t683 + 0.36e2 * t888 * t121 * t889 - 0.36e2 * t610 * t893 * t511 - 0.28e2 / 0.3e1 * t625 * t121 * t897
  t903 = t299 * t98
  t928 = t743 * t105
  t934 = t651 * t212
  t937 = 0.12e2 * t903 * t171 * t889 - 0.28e2 / 0.3e1 * t641 * t666 - 0.2e1 / 0.3e1 * t888 * t185 * t889 + 0.2e1 / 0.3e1 * t610 * t833 * t511 - 0.3e1 * t138 * t617 * t632 * t276 + 0.36e2 * t327 * t557 * t140 * t889 - 0.18e2 * t622 * t512 - 0.9e1 * t602 * t510 * t897 + 0.22e2 * t506 * t928 * t668 - 0.3e1 * t501 * t600 - 0.8e1 * t934 * t604
  t960 = t62 * t86 * t276
  t965 = t381 * t130 * t119
  t975 = t312 * t388
  t977 = t301 * t120 * t86
  t983 = t312 * t283
  t1002 = t56 * t31 * t88
  t1008 = t312 * t88
  t1011 = -0.4e1 * t270 * t438 * t318 + 0.4e1 * t975 * t977 + 0.8e1 * t270 * t264 * t318 - 0.4e1 * t983 * t356 + 0.12e2 * t975 * t384 + 0.4e1 * t316 * t371 - 0.12e2 * t983 * t364 - 0.2e1 * t316 * t420 - 0.12e2 * t270 * t432 * t410 + 0.2e1 * t421 + 0.12e2 * t411 + 0.4e1 * t414 - 0.8e1 * t417 + 0.16e2 / 0.9e1 * t1002 * t186 + 0.12e2 * t270 * t88 * t558 - 0.24e2 * t1008 * t107
  t1030 = t679 * t192
  t1035 = t679 * t120
  t1042 = 0.32e2 / 0.3e1 * t1002 * t194 + 0.12e2 * t1002 * t122 + 0.12e2 * t365 - 0.12e2 * t385 + 0.2e1 * t352 - 0.2e1 * t357 + 0.2e1 * t270 * t458 * t242 - 0.8e1 * t1008 * t579 - 0.4e1 * t372 - 0.12e2 * t696 * t273 + 0.20e2 / 0.9e1 * t678 * t730 + 0.4e1 / 0.3e1 * t678 * t1030 + 0.24e2 * t675 * t333 - 0.12e2 * t678 * t1035 - 0.4e1 * t675 * t302 - 0.2e1 * t687 * t273
  t1043 = t1011 + t1042
  t1049 = -0.3e1 * t652 * t512 - 0.4e1 / 0.3e1 * t830 * t662 - 0.72e2 * t903 * t106 * t889 + 0.56e2 * t641 * t596 - 0.8e1 * t506 * t595 * t599 + 0.6e1 * t134 * t137 * t119 * t145 * t62 * t276 * t336 + 0.18e2 * t323 * t212 * t102 * t145 * t960 + 0.14e2 / 0.3e1 * t965 * t517 * t960 - 0.28e2 * t965 * t528 * t960 - t138 * t510 * t63 * t1043 + 0.6e1 * t503 * t600
  t1055 = t743 * t104
  t1056 = t369 * t276
  t1072 = t259 ** 2
  t1073 = t70 * t1072
  t1074 = t1073 * t130
  t1088 = 0.4e1 / 0.3e1 * t506 * t121 * t599 - 0.6e1 * t138 * t1055 * t63 * t1056 - 0.12e2 * t503 * t669 - 0.11e2 / 0.3e1 * t506 * t893 * t668 + 0.6e1 * t501 * t669 + t138 * t510 * t60 * t1043 / 0.2e1 + 0.6e1 * t1074 * t514 + 0.20e2 * t856 * t193 * t800 - 0.72e2 * t809 * t611 + 0.8e1 / 0.3e1 * t819 * t833 * t63 + 0.24e2 * t819 * t825 * t63
  t1108 = t120 ** 2
  t1109 = t743 * t1108
  t1121 = 0.18e2 * t610 * t893 * t524 - 0.18e2 * t856 * t121 * t800 + 0.14e2 * t625 * t595 * t897 + 0.8e1 * t830 * t672 - 0.4e1 * t888 * t193 * t889 + 0.4e1 * t610 * t825 * t511 - 0.3e1 * t501 * t619 - t819 * t1109 * t63 / 0.9e1 - 0.8e1 / 0.3e1 * t506 * t121 * t632 + 0.4e1 * t934 * t636 - 0.24e2 * t799 * t171 * t800
  t1135 = t1073 * t129
  t1140 = t133 * t1072
  t1150 = 0.3e1 / 0.2e1 * t652 * t525 + 0.3e1 / 0.2e1 * t501 * t633 + 0.24e2 * t878 * t518 - 0.40e2 * t870 * t684 + 0.10e2 / 0.3e1 * t883 * t884 * t820 * t60 - 0.3e1 * t1135 * t529 + 0.2e1 * t1135 * t518 + 0.3e1 * t1140 * t211 * t146 + 0.50e2 / 0.3e1 * t883 * t884 * t690 - t1074 * t507 + 0.56e2 / 0.3e1 * t641 * t647
  t1154 = t114 * t97
  t1155 = t877 * t1154
  t1173 = t93 * t136
  t1182 = 0.22e2 / 0.3e1 * t506 * t893 * t618 + 0.72e2 * t1155 * t514 - 0.28e2 * t641 * t614 - 0.11e2 * t506 * t928 * t618 - 0.12e2 * t1155 * t507 - 0.3e1 * t503 * t633 + 0.6e1 * t503 * t619 + 0.3e1 * t138 * t1055 * t60 * t1056 - 0.24e2 * t873 * t1173 * t141 + 0.9e1 * t622 * t525 - 0.6e1 * t1140 * t212 * t141
  t1197 = t269 * t68 * t259
  t1203 = t19 * t154 * t88 * t114
  t1204 = t744 * t158
  t1218 = t744 * t192
  t1229 = t149 * t161
  t1231 = t19 * t59 * t1229
  t1234 = 0.2e1 / 0.3e1 * t440 * t296 - 0.2e1 * t429 * t411 - 0.2e1 / 0.3e1 * t429 * t414 - t19 * t59 * (0.4e1 * t506 * t595 * t632 + 0.36e2 * t799 * t106 * t800 + 0.8e1 * t809 * t659 - 0.4e1 / 0.3e1 * t819 * t821 * t63 - 0.20e2 * t610 * t825 * t524 - 0.4e1 * t830 * t627 - t610 * t833 * t524 / 0.3e1 + t850 * t137 * t141 + 0.8e1 / 0.3e1 * t830 * t654 + t856 * t185 * t800 / 0.3e1 + t901 + t937 + t1049 + t1088 + t1121 + t1150 + t1182) * t202 / 0.4e1 + 0.20e2 / 0.81e2 * t13 * t77 * t18 * t713 - 0.10e2 / 0.27e2 * t712 * t708 + 0.23e2 / 0.6e1 * t729 * t730 * t1197 - 0.23e2 / 0.6e1 * t1203 * t1204 * t401 - 0.3e1 * t729 * t1035 * t754 + 0.3e1 * t1203 * t744 * t120 * t278 + 0.14e2 * t729 * t1030 * t1197 - 0.14e2 * t1203 * t1218 * t401 - 0.2e1 * t362 * t651 * t211 * t410 - 0.3e1 / 0.4e1 * t362 * t687 * t318 + 0.6e1 * t1231 * t357
  t1240 = t64 * t182
  t1242 = t19 * t59 * t1240
  t1265 = t19 * t126 * t87 * t93
  t1266 = t333 * t754
  t1271 = t19 * t126 * t88 * t93
  t1274 = t302 * t1197
  t1289 = 0.6e1 * t343 * t385 - 0.6e1 * t343 * t365 + 0.9e1 * t1242 * t737 * t679 * t158 * t259 - 0.9e1 * t1242 * t678 * t744 * t158 * t276 - 0.18e2 * t347 * t737 * t679 * t192 * t259 + 0.18e2 * t347 * t678 * t744 * t192 * t276 + 0.6e1 * t1265 * t1266 - 0.14e2 / 0.3e1 * t1271 * t405 - 0.12e2 * t1265 * t1274 + 0.28e2 / 0.3e1 * t1271 * t402 - 0.11e2 / 0.3e1 * t729 * t1030 * t754 + 0.11e2 / 0.3e1 * t1203 * t1218 * t278 - 0.6e1 * t343 * t411 - 0.2e1 * t343 * t414
  t1292 = t531 * t68
  t1298 = t207 * t86 * t211
  t1340 = t97 * t743
  t1341 = t1340 * t120
  t1345 = -0.2e1 / 0.3e1 * t765 * t1266 - 0.3e1 / 0.2e1 * t19 * t59 * t1292 * t331 + 0.2e1 / 0.3e1 * t238 * t1298 * t755 - 0.4e1 / 0.9e1 * t238 * t265 * t279 + 0.2e1 / 0.9e1 * t238 * t439 * t279 + 0.3e1 / 0.2e1 * t362 * t328 * t420 - t362 * t143 * t267 * t104 * t1043 / 0.4e1 - 0.3e1 / 0.4e1 * t362 * t324 * t420 + 0.9e1 * t1203 * t1204 * t269 * t161 * t276 - 0.6e1 * t1231 * t352 + t440 * t339 / 0.4e1 + t293 * t268 * t269 * t202 * t1043 / 0.12e2 + 0.2e1 * t347 * t300 * t286 * t120 * t336 - t440 * t378 / 0.2e1 - 0.11e2 / 0.12e2 * t285 * t1341 * t377
  t1383 = 0.18e2 * t347 * t772 * t351 - 0.14e2 * t347 * t675 * t356 + t285 * t287 * t338 / 0.3e1 + 0.2e1 / 0.3e1 * t769 * t405 - t545 * t225 / 0.3e1 + 0.2e1 / 0.3e1 * t562 * t217 - 0.2e1 * t571 * t572 * t216 - t589 * t541 / 0.3e1 + t209 * t213 * t540 - 0.3e1 * t533 * t567 - 0.2e1 / 0.3e1 * t238 * t570 * t573 + 0.2e1 / 0.3e1 * t583 * t567 - 0.3e1 / 0.2e1 * t66 * t240 * t1072 * t309 - 0.12e2 * t168 * t108
  t1392 = t86 * t276
  t1407 = t19 * t20 * t812 * t804
  t1408 = t818 * t743
  t1409 = t1108 * t58
  t1420 = t19 * t154 * t804
  t1421 = t808 * t119
  t1431 = t19 * t126 * t1072
  t1441 = -0.6e1 * t66 / t181 / t56 * t812 * t804 * t818 * t1109 + 0.9e1 / 0.2e1 * t362 * t602 * t510 * t1392 - t586 * t468 / 0.3e1 - t19 * t207 * t849 * t463 / 0.12e2 - t460 * t468 / 0.3e1 - 0.35e2 / 0.108e3 * t1407 * t1408 * t1409 * t203 + t238 * t532 * t243 + 0.2e1 * t199 * t200 * t224 + 0.5e1 / 0.3e1 * t1420 * t1421 * t228 + t168 * t498 + t66 * t240 * t849 * t242 / 0.4e1 - t1431 * t592 / 0.4e1 + t1431 * t549 + 0.3e1 / 0.2e1 * t66 * t71 * t1072 * t177 - t1431 * t546 / 0.2e1
  t1465 = t829 * t129
  t1472 = t238 * t346
  t1481 = 0.2e1 * t343 * t372 - 0.2e1 / 0.3e1 * t293 * t375 * t294 * t376 + t426 * t339 / 0.9e1 - t266 * t339 / 0.2e1 - t343 * t421 - 0.2e1 * t429 * t365 + 0.9e1 * t362 * t327 * t129 * t144 * t104 * t259 - 0.9e1 / 0.2e1 * t362 * t696 * t318 - 0.2e1 * t347 * t1465 * t977 + 0.2e1 * t362 * t1465 * t384 + 0.2e1 * t1472 * t357 + t426 * t296 / 0.3e1 - 0.2e1 * t1472 * t352 + 0.2e1 * t429 * t385
  t1536 = -0.2e1 / 0.3e1 * t786 * t393 + 0.4e1 / 0.3e1 * t786 * t398 + 0.4e1 * t390 * t302 * t294 * t396 - 0.5e1 / 0.9e1 * t156 * t157 * t159 * t215 - t128 * t131 * t132 * t539 / 0.2e1 - t467 * t541 / 0.2e1 - t538 * t461 * t214 * t701 / 0.3e1 - 0.4e1 / 0.3e1 * t769 * t402 + t472 * t361 * t331 / 0.3e1 - 0.2e1 * t362 * t300 * t286 * t105 * t336 - 0.11e2 / 0.6e1 * t285 * t1340 * t105 * t377 + 0.11e2 / 0.3e1 * t285 * t1341 * t269 * t68 * t369 + 0.2e1 / 0.3e1 * t285 * t404 * t338 - 0.4e1 / 0.3e1 * t285 * t287 * t269 * t68 * t336 + 0.11e2 / 0.2e1 * t362 * t300 * t1340 * t105 * t369
  t1540 = t136 * t743
  t1582 = -0.3e1 / 0.2e1 * t362 * t143 * t1540 * t104 * t1056 + 0.2e1 / 0.3e1 * t429 * t372 - 0.3e1 * t362 * t328 * t371 - t429 * t421 / 0.3e1 + 0.3e1 / 0.2e1 * t362 * t324 * t371 - 0.11e2 / 0.2e1 * t347 * t300 * t1340 * t120 * t369 - 0.2e1 / 0.9e1 * t426 * t378 + t266 * t378 + t293 * t1540 * t104 * t269 * t202 * t1056 / 0.2e1 + 0.3e1 * t533 * t178 - 0.43e2 / 0.9e1 * t1407 * t1408 * t1409 * t162 - 0.3e1 * t533 * t173 - 0.2e1 * t239 * t173 + 0.2e1 * t239 * t178
  t1595 = t238 * t155
  t1634 = -0.8e1 * t199 * t200 * t151 + 0.22e2 / 0.3e1 * t1420 * t1421 * t482 - 0.23e2 / 0.3e1 * t1420 * t1421 * t486 + 0.4e1 * t199 * t200 * t232 - 0.2e1 * t1595 * t164 + 0.18e2 * t1420 * t1421 * t163 + 0.2e1 * t246 * t123 + 0.2e1 * t19 * t207 * t804 * t1173 * t139 * t462 - 0.4e1 * t246 * t108 + 0.18e2 * t66 * t71 * t804 * t1154 * t106 - 0.10e2 / 0.81e2 * t712 * t473 * t463 - 0.2e1 / 0.9e1 * t472 * t208 * t563 + 0.4e1 / 0.3e1 * t765 * t1274 + 0.2e1 / 0.3e1 * t19 * t207 * t458 * t211 * t435 + t19 * t207 * t458 * t135 * t279 / 0.4e1
  t1638 = t19 * t764
  t1639 = t294 * t753
  t1675 = t472 * t127
  t1678 = -t238 * t342 * t331 - 0.2e1 * t1638 * t333 * t1639 + 0.2e1 * t285 * t404 * t295 + t285 * t287 * t295 - 0.5e1 / 0.6e1 * t729 * t730 * t754 + 0.5e1 / 0.6e1 * t1203 * t1204 * t278 + 0.3e1 * t1265 * t766 - 0.7e1 / 0.3e1 * t1271 * t288 - t1638 * t302 * t1639 + 0.2e1 * t19 * t1298 * t273 * t1639 - 0.4e1 / 0.3e1 * t266 * t296 + t293 * t268 * t58 * t531 * t277 / 0.2e1 + t293 * t268 * t294 * t337 / 0.3e1 + 0.2e1 / 0.9e1 * t1675 * t546
  t1726 = -0.4e1 / 0.9e1 * t1675 * t549 - 0.22e2 / 0.27e2 * t1595 * t483 - 0.18e2 * t66 * t111 * t804 * t808 * t121 - 0.18e2 * t66 * t161 * t812 * t804 * t818 * t833 + 0.6e1 * t66 * t68 * t812 * t804 * t818 * t825 + 0.2e1 / 0.3e1 * t583 * t173 + 0.4e1 * t246 * t580 + 0.23e2 / 0.27e2 * t1595 * t487 + 0.36e2 * t66 * t190 * t804 * t808 * t193 + 0.6e1 * t168 * t559 + t472 * t466 * t463 / 0.9e1 + 0.2e1 / 0.9e1 * t474 * t468 - 0.2e1 / 0.3e1 * t583 * t178 + 0.3e1 / 0.2e1 * t533 * t261 - 0.3e1 / 0.2e1 * t66 * t169 * t1072 * t172
  t1762 = t19 * t126 * t804
  t1763 = t1154 * t102
  t1767 = t238 * t198
  t1773 = 0.2e1 * t246 * t559 - 0.6e1 * t66 * t240 * t804 * t1173 * t140 - 0.18e2 * t66 * t169 * t804 * t1154 * t171 - 0.2e1 * t1407 * t1408 * t482 + 0.6e1 * t1420 * t1421 * t220 + t1675 * t592 / 0.9e1 + t239 * t261 + 0.4e1 / 0.3e1 * t545 * t152 + t246 * t498 / 0.3e1 + t19 * t207 * t1072 * t563 / 0.2e1 + t19 * t59 * t700 * t243 - 0.6e1 * t1762 * t1763 * t204 - 0.8e1 / 0.3e1 * t1767 * t478 + 0.12e2 * t1762 * t1763 * t477
  t1784 = t820 * t58
  t1821 = -0.2e1 / 0.3e1 * t1595 * t490 + 0.28e2 / 0.9e1 * t1595 * t494 - t238 * t459 * t463 / 0.9e1 - 0.38e2 / 0.9e1 * t1407 * t1408 * t228 + 0.89e2 / 0.9e1 * t1407 * t1408 * t1784 * t360 - 0.6e1 * t156 * t157 * t159 * t1229 - 0.62e2 / 0.3e1 * t1407 * t1408 * t1784 * t162 + 0.8e1 * t1407 * t1408 * t1409 * t1240 + 0.6e1 * t168 * t187 - 0.12e2 * t168 * t195 + 0.4e1 / 0.3e1 * t1767 * t205 - 0.18e2 * t66 * t183 * t804 * t808 * t185 - 0.4e1 * t246 * t195 + 0.10e2 / 0.27e2 * t712 * t65 * t243 - 0.22e2 / 0.9e1 * t156 * t157 * t481 * t215
  t1867 = 0.23e2 / 0.9e1 * t156 * t157 * t159 * t150 - 0.61e2 / 0.27e2 * t1407 * t1408 * t1784 * t203 + 0.44e2 / 0.27e2 * t1407 * t1408 * t1409 * t360 - 0.2e1 * t156 * t157 * t224 + 0.28e2 / 0.3e1 * t156 * t157 * t481 * t150 - t128 * t131 * t201 * t539 + 0.2e1 * t128 * t131 * t132 * t1292 - 0.2e1 / 0.3e1 * t472 * t167 * t243 - 0.2e1 * t239 * t567 - t583 * t261 / 0.3e1 - 0.2e1 / 0.3e1 * t545 * t233 - 0.5e1 / 0.27e2 * t1595 * t229 + 0.2e1 / 0.3e1 * t1767 * t221 - 0.3e1 * t1762 * t1763 * t220 - t238 * t702 / 0.3e1
  t1887 = t203 * t1392
  t1891 = t286 * t132
  t1907 = t336 * t276
  t1925 = 0.18e2 * t66 * t182 * t812 * t804 * t818 * t821 - 0.28e2 * t1420 * t1421 * t493 + 0.6e1 * t168 * t123 + 0.47e2 / 0.3e1 * t1407 * t1408 * t486 + 0.12e2 * t168 * t580 + 0.2e1 * t246 * t187 + 0.7e1 / 0.3e1 * t390 * t286 * t201 * t1887 - 0.14e2 / 0.3e1 * t390 * t1891 * t360 * t1392 - 0.7e1 * t362 * t625 * t595 * t1392 + 0.7e1 * t347 * t348 * t130 * t121 * t259 * t276 - t293 * t368 * t214 * t203 * t1907 / 0.2e1 + 0.7e1 / 0.6e1 * t390 * t1891 * t1887 - 0.3e1 / 0.2e1 * t434 * t267 * t214 * t1887 + 0.3e1 / 0.2e1 * t362 * t138 * t617 * t1907 + t472 * t705 / 0.3e1
  t1930 = f.my_piecewise3(t2, 0, t789 + t1234 + t1289 + t1345 + t1383 + t1441 + t1481 + t1536 + t1582 + t1634 + t1678 + t1726 + t1773 + t1821 + t1867 + t1925)
  v4rho4_0_ = 0.2e1 * r0 * t1930 + 0.8e1 * t719

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = t2 ** 2
  t19 = 0.1e1 / t18
  t20 = t12 * t19
  t21 = t3 - t20
  t22 = f.my_piecewise5(t6, 0, t10, 0, t21)
  t25 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t22)
  t26 = t2 ** (0.1e1 / 0.3e1)
  t29 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = t25 * t26 * t30
  t32 = 4 ** (0.1e1 / 0.3e1)
  t33 = r0 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t45 = 0.3e1 / 0.10e2 * t40 * t43
  t46 = r0 ** 2
  t48 = 0.1e1 / t34 / t46
  t51 = s0 ** 2
  t52 = t46 ** 2
  t58 = 0.46864e0 * tau0 / t34 / r0 - t45 + 0.89e-1 * s0 * t48 + 0.53e-2 * t51 / t33 / t52 / r0
  t59 = abs(t58)
  t60 = t59 < 0.50e-12
  t61 = 0.0e0 < t58
  t62 = f.my_piecewise3(t61, 0.50e-12, -0.50e-12)
  t63 = f.my_piecewise3(t60, t62, t58)
  t64 = br89_x(t63)
  t66 = jnp.exp(t64 / 0.3e1)
  t67 = t32 * t66
  t68 = jnp.exp(-t64)
  t71 = t68 * (0.1e1 + t64 / 0.2e1)
  t72 = 0.1e1 - t71
  t73 = 0.1e1 / t64
  t74 = t72 * t73
  t75 = t67 * t74
  t78 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t79 = t78 * f.p.zeta_threshold
  t81 = f.my_piecewise3(t16, t79, t17 * t15)
  t82 = t26 ** 2
  t83 = 0.1e1 / t82
  t85 = t81 * t83 * t30
  t87 = t85 * t75 / 0.12e2
  t89 = t81 * t26 * t30
  t90 = jnp.pi ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t92 = t32 * t91
  t93 = f.my_piecewise3(t61, 0, 0)
  t96 = t46 * r0
  t98 = 0.1e1 / t34 / t96
  t107 = f.my_piecewise3(t60, t93, -0.78106666666666666666666666666666666666666666666667e0 * tau0 * t48 - 0.23733333333333333333333333333333333333333333333333e0 * s0 * t98 - 0.28266666666666666666666666666666666666666666666667e-1 * t51 / t33 / t52 / t46)
  t108 = t92 * t107
  t109 = t89 * t108
  t110 = t63 ** 2
  t111 = 0.1e1 / t110
  t113 = jnp.exp(-0.2e1 / 0.3e1 * t64)
  t114 = 0.1e1 / t113
  t115 = t111 * t114
  t116 = t64 ** 2
  t118 = t116 - 0.2e1 * t64 + 0.3e1
  t119 = 0.1e1 / t118
  t120 = t115 * t119
  t121 = t64 - 0.2e1
  t122 = t121 ** 2
  t123 = t122 * t66
  t124 = t123 * t74
  t125 = t120 * t124
  t128 = t91 * t107
  t129 = t128 * t115
  t130 = t119 * t122
  t131 = t130 * t71
  t133 = t128 * t111
  t134 = t114 * t119
  t136 = t134 * t122 * t68
  t139 = t129 * t131 - t133 * t136 / 0.2e1
  t140 = t139 * t73
  t141 = t67 * t140
  t144 = t67 * t72
  t145 = t89 * t144
  t146 = 0.1e1 / t116
  t147 = t146 * t91
  t149 = t115 * t130
  t150 = t147 * t107 * t149
  t154 = f.my_piecewise3(t1, 0, -t31 * t75 / 0.4e1 - t87 - t109 * t125 / 0.12e2 - t89 * t141 / 0.4e1 + t145 * t150 / 0.4e1)
  t156 = r1 <= f.p.dens_threshold
  t157 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t158 = 0.1e1 + t157
  t159 = t158 <= f.p.zeta_threshold
  t160 = t158 ** (0.1e1 / 0.3e1)
  t162 = f.my_piecewise5(t10, 0, t6, 0, -t21)
  t165 = f.my_piecewise3(t159, 0, 0.4e1 / 0.3e1 * t160 * t162)
  t167 = t165 * t26 * t30
  t168 = r1 ** (0.1e1 / 0.3e1)
  t169 = t168 ** 2
  t174 = r1 ** 2
  t176 = 0.1e1 / t169 / t174
  t179 = s2 ** 2
  t180 = t174 ** 2
  t186 = 0.46864e0 * tau1 / t169 / r1 - t45 + 0.89e-1 * s2 * t176 + 0.53e-2 * t179 / t168 / t180 / r1
  t187 = abs(t186)
  t188 = t187 < 0.50e-12
  t189 = 0.0e0 < t186
  t190 = f.my_piecewise3(t189, 0.50e-12, -0.50e-12)
  t191 = f.my_piecewise3(t188, t190, t186)
  t192 = br89_x(t191)
  t194 = jnp.exp(t192 / 0.3e1)
  t195 = t32 * t194
  t196 = jnp.exp(-t192)
  t199 = t196 * (0.1e1 + t192 / 0.2e1)
  t200 = 0.1e1 - t199
  t201 = 0.1e1 / t192
  t202 = t200 * t201
  t203 = t195 * t202
  t207 = f.my_piecewise3(t159, t79, t160 * t158)
  t209 = t207 * t83 * t30
  t211 = t209 * t203 / 0.12e2
  t213 = f.my_piecewise3(t156, 0, -t167 * t203 / 0.4e1 - t211)
  t227 = f.my_piecewise3(t60, t93, 0.20828444444444444444444444444444444444444444444445e1 * tau0 * t98 + 0.87022222222222222222222222222222222222222222222221e0 * s0 / t34 / t52 + 0.17902222222222222222222222222222222222222222222222e0 * t51 / t33 / t52 / t96)
  t236 = t90 * jnp.pi
  t237 = t32 * t236
  t238 = t107 ** 2
  t240 = t89 * t237 * t238
  t241 = t110 ** 2
  t242 = 0.1e1 / t241
  t243 = t113 ** 2
  t244 = 0.1e1 / t243
  t245 = t242 * t244
  t246 = t118 ** 2
  t247 = 0.1e1 / t246
  t248 = t245 * t247
  t249 = t122 ** 2
  t250 = t249 * t66
  t264 = 0.1e1 / t82 / t2
  t268 = t81 * t264 * t30 * t75 / 0.18e2
  t271 = t25 * t83 * t30 * t75
  t273 = t91 * t227
  t276 = t91 * t238
  t278 = 0.1e1 / t110 / t63
  t279 = t278 * t114
  t283 = t236 * t238
  t284 = t283 * t245
  t285 = t247 * t249
  t289 = t247 * t122
  t296 = 0.2e1 * t64 * t91 * t107 * t149 - 0.2e1 * t133 * t134 * t122
  t300 = t122 * t121
  t301 = t247 * t300
  t305 = t283 * t242
  t306 = t244 * t247
  t328 = t17 ** 2
  t329 = 0.1e1 / t328
  t330 = t22 ** 2
  t335 = t12 / t18 / t2
  t337 = -0.2e1 * t19 + 0.2e1 * t335
  t338 = f.my_piecewise5(t6, 0, t10, 0, t337)
  t342 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t329 * t330 + 0.4e1 / 0.3e1 * t17 * t338)
  t349 = t85 * t141
  t351 = -t89 * t92 * t227 * t125 / 0.12e2 - t109 * t120 * t123 * t140 / 0.6e1 - t240 * t248 * t250 * t74 / 0.12e2 + t89 * t67 * t139 * t150 / 0.2e1 + t145 * t147 * t227 * t149 / 0.4e1 + t268 - t271 / 0.6e1 - t89 * t67 * (t273 * t115 * t131 - 0.2e1 * t276 * t279 * t131 - t284 * t285 * t71 / 0.3e1 - t129 * t289 * t71 * t296 + 0.2e1 * t284 * t301 * t71 + 0.2e1 / 0.3e1 * t305 * t306 * t249 * t68 - t273 * t111 * t136 / 0.2e1 + t276 * t278 * t136 + t129 * t289 * t68 * t296 / 0.2e1 - t305 * t306 * t300 * t68) * t73 / 0.4e1 - t342 * t26 * t30 * t75 / 0.4e1 - t31 * t141 / 0.2e1 - t349 / 0.6e1
  t353 = t85 * t108 * t125
  t356 = t85 * t144 * t150
  t369 = t72 * t146
  t397 = t114 * t247
  t417 = -t353 / 0.18e2 + t356 / 0.6e1 - t31 * t108 * t125 / 0.6e1 + t31 * t144 * t150 / 0.2e1 - t240 * t248 * t300 * t66 * t74 / 0.6e1 + t240 * t248 * t250 * t369 / 0.3e1 - t145 / t116 / t64 * t236 * t238 * t245 * t285 / 0.2e1 + t145 * t146 * t236 * t238 * t245 * t301 / 0.2e1 + t89 * t92 * t238 * t279 * t119 * t124 / 0.6e1 + t89 * t92 * t107 * t111 * t397 * t122 * t66 * t72 * t73 * t296 / 0.12e2 - t145 * t147 * t238 * t279 * t130 / 0.2e1 - t89 * t67 * t369 * t133 * t397 * t122 * t296 / 0.4e1
  t419 = f.my_piecewise3(t1, 0, t351 + t417)
  t420 = t160 ** 2
  t421 = 0.1e1 / t420
  t422 = t162 ** 2
  t426 = f.my_piecewise5(t10, 0, t6, 0, -t337)
  t430 = f.my_piecewise3(t159, 0, 0.4e1 / 0.9e1 * t421 * t422 + 0.4e1 / 0.3e1 * t160 * t426)
  t437 = t165 * t83 * t30 * t203
  t442 = t207 * t264 * t30 * t203 / 0.18e2
  t444 = f.my_piecewise3(t156, 0, -t430 * t26 * t30 * t203 / 0.4e1 - t437 / 0.6e1 + t442)
  d11 = 0.2e1 * t154 + 0.2e1 * t213 + t2 * (t419 + t444)
  t447 = -t3 - t20
  t448 = f.my_piecewise5(t6, 0, t10, 0, t447)
  t451 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t448)
  t453 = t451 * t26 * t30
  t457 = f.my_piecewise3(t1, 0, -t453 * t75 / 0.4e1 - t87)
  t459 = f.my_piecewise5(t10, 0, t6, 0, -t447)
  t462 = f.my_piecewise3(t159, 0, 0.4e1 / 0.3e1 * t160 * t459)
  t464 = t462 * t26 * t30
  t468 = t207 * t26 * t30
  t469 = f.my_piecewise3(t189, 0, 0)
  t472 = t174 * r1
  t474 = 0.1e1 / t169 / t472
  t483 = f.my_piecewise3(t188, t469, -0.78106666666666666666666666666666666666666666666667e0 * tau1 * t176 - 0.23733333333333333333333333333333333333333333333333e0 * s2 * t474 - 0.28266666666666666666666666666666666666666666666667e-1 * t179 / t168 / t180 / t174)
  t484 = t92 * t483
  t485 = t468 * t484
  t486 = t191 ** 2
  t487 = 0.1e1 / t486
  t489 = jnp.exp(-0.2e1 / 0.3e1 * t192)
  t490 = 0.1e1 / t489
  t491 = t487 * t490
  t492 = t192 ** 2
  t494 = t492 - 0.2e1 * t192 + 0.3e1
  t495 = 0.1e1 / t494
  t496 = t491 * t495
  t497 = t192 - 0.2e1
  t498 = t497 ** 2
  t499 = t498 * t194
  t500 = t499 * t202
  t501 = t496 * t500
  t504 = t91 * t483
  t505 = t504 * t491
  t506 = t495 * t498
  t507 = t506 * t199
  t509 = t504 * t487
  t510 = t490 * t495
  t512 = t510 * t498 * t196
  t515 = t505 * t507 - t509 * t512 / 0.2e1
  t516 = t515 * t201
  t517 = t195 * t516
  t520 = t195 * t200
  t521 = t468 * t520
  t522 = 0.1e1 / t492
  t523 = t522 * t91
  t525 = t491 * t506
  t526 = t523 * t483 * t525
  t530 = f.my_piecewise3(t156, 0, -t464 * t203 / 0.4e1 - t211 - t485 * t501 / 0.12e2 - t468 * t517 / 0.4e1 + t521 * t526 / 0.4e1)
  t534 = 0.2e1 * t335
  t535 = f.my_piecewise5(t6, 0, t10, 0, t534)
  t539 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t329 * t448 * t22 + 0.4e1 / 0.3e1 * t17 * t535)
  t546 = t451 * t83 * t30 * t75
  t561 = f.my_piecewise3(t1, 0, -t539 * t26 * t30 * t75 / 0.4e1 - t546 / 0.12e2 - t453 * t108 * t125 / 0.12e2 - t453 * t141 / 0.4e1 + t453 * t144 * t150 / 0.4e1 - t271 / 0.12e2 + t268 - t353 / 0.36e2 - t349 / 0.12e2 + t356 / 0.12e2)
  t565 = f.my_piecewise5(t10, 0, t6, 0, -t534)
  t569 = f.my_piecewise3(t159, 0, 0.4e1 / 0.9e1 * t421 * t459 * t162 + 0.4e1 / 0.3e1 * t160 * t565)
  t576 = t462 * t83 * t30 * t203
  t583 = t209 * t484 * t501
  t587 = t209 * t517
  t593 = t209 * t520 * t526
  t596 = f.my_piecewise3(t156, 0, -t569 * t26 * t30 * t203 / 0.4e1 - t576 / 0.12e2 - t437 / 0.12e2 + t442 - t167 * t484 * t501 / 0.12e2 - t583 / 0.36e2 - t167 * t517 / 0.4e1 - t587 / 0.12e2 + t167 * t520 * t526 / 0.4e1 + t593 / 0.12e2)
  d12 = t154 + t213 + t457 + t530 + t2 * (t561 + t596)
  t601 = t448 ** 2
  t605 = 0.2e1 * t19 + 0.2e1 * t335
  t606 = f.my_piecewise5(t6, 0, t10, 0, t605)
  t610 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t329 * t601 + 0.4e1 / 0.3e1 * t17 * t606)
  t617 = f.my_piecewise3(t1, 0, -t610 * t26 * t30 * t75 / 0.4e1 - t546 / 0.6e1 + t268)
  t632 = f.my_piecewise3(t188, t469, 0.20828444444444444444444444444444444444444444444445e1 * tau1 * t474 + 0.87022222222222222222222222222222222222222222222221e0 * s2 / t169 / t180 + 0.17902222222222222222222222222222222222222222222222e0 * t179 / t168 / t180 / t472)
  t641 = t483 ** 2
  t643 = t468 * t237 * t641
  t644 = t486 ** 2
  t645 = 0.1e1 / t644
  t646 = t489 ** 2
  t647 = 0.1e1 / t646
  t648 = t645 * t647
  t649 = t494 ** 2
  t650 = 0.1e1 / t649
  t651 = t648 * t650
  t652 = t498 ** 2
  t653 = t652 * t194
  t672 = t91 * t632
  t675 = t91 * t641
  t677 = 0.1e1 / t486 / t191
  t678 = t677 * t490
  t682 = t236 * t641
  t683 = t682 * t648
  t684 = t650 * t652
  t688 = t650 * t498
  t695 = 0.2e1 * t192 * t91 * t483 * t525 - 0.2e1 * t509 * t510 * t498
  t699 = t498 * t497
  t700 = t650 * t699
  t704 = t682 * t645
  t705 = t647 * t650
  t727 = t459 ** 2
  t731 = f.my_piecewise5(t10, 0, t6, 0, -t605)
  t735 = f.my_piecewise3(t159, 0, 0.4e1 / 0.9e1 * t421 * t727 + 0.4e1 / 0.3e1 * t160 * t731)
  t740 = -t583 / 0.18e2 + t593 / 0.6e1 - t468 * t92 * t632 * t501 / 0.12e2 - t485 * t496 * t499 * t516 / 0.6e1 - t643 * t651 * t653 * t202 / 0.12e2 + t468 * t195 * t515 * t526 / 0.2e1 + t521 * t523 * t632 * t525 / 0.4e1 - t464 * t484 * t501 / 0.6e1 + t464 * t520 * t526 / 0.2e1 - t468 * t195 * (t672 * t491 * t507 - 0.2e1 * t675 * t678 * t507 - t683 * t684 * t199 / 0.3e1 - t505 * t688 * t199 * t695 + 0.2e1 * t683 * t700 * t199 + 0.2e1 / 0.3e1 * t704 * t705 * t652 * t196 - t672 * t487 * t512 / 0.2e1 + t675 * t677 * t512 + t505 * t688 * t196 * t695 / 0.2e1 - t704 * t705 * t699 * t196) * t201 / 0.4e1 - t735 * t26 * t30 * t203 / 0.4e1
  t749 = t200 * t522
  t778 = t490 * t650
  t798 = -t464 * t517 / 0.2e1 - t587 / 0.6e1 - t643 * t651 * t699 * t194 * t202 / 0.6e1 + t643 * t651 * t653 * t749 / 0.3e1 - t521 / t492 / t192 * t236 * t641 * t648 * t684 / 0.2e1 + t521 * t522 * t236 * t641 * t648 * t700 / 0.2e1 - t576 / 0.6e1 + t442 + t468 * t92 * t641 * t678 * t495 * t500 / 0.6e1 + t468 * t92 * t483 * t487 * t778 * t498 * t194 * t200 * t201 * t695 / 0.12e2 - t521 * t523 * t641 * t678 * t506 / 0.2e1 - t468 * t195 * t749 * t509 * t778 * t498 * t695 / 0.4e1
  t800 = f.my_piecewise3(t156, 0, t740 + t798)
  d22 = 0.2e1 * t457 + 0.2e1 * t530 + t2 * (t617 + t800)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t21 * t22 * t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = t28 * t30
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t44 = 0.3e1 / 0.10e2 * t39 * t42
  t45 = r0 ** 2
  t47 = 0.1e1 / t33 / t45
  t50 = s0 ** 2
  t51 = t45 ** 2
  t52 = t51 * r0
  t57 = 0.46864e0 * tau0 / t33 / r0 - t44 + 0.89e-1 * s0 * t47 + 0.53e-2 * t50 / t32 / t52
  t58 = abs(t57)
  t59 = t58 < 0.50e-12
  t60 = 0.0e0 < t57
  t61 = f.my_piecewise3(t60, 0, 0)
  t62 = t45 * r0
  t64 = 0.1e1 / t33 / t62
  t68 = 0.1e1 / t33 / t51
  t77 = f.my_piecewise3(t59, t61, 0.20828444444444444444444444444444444444444444444445e1 * tau0 * t64 + 0.87022222222222222222222222222222222222222222222221e0 * s0 * t68 + 0.17902222222222222222222222222222222222222222222222e0 * t50 / t32 / t51 / t62)
  t78 = t31 * t77
  t79 = t27 * t78
  t80 = f.my_piecewise3(t60, 0.50e-12, -0.50e-12)
  t81 = f.my_piecewise3(t59, t80, t57)
  t82 = t81 ** 2
  t83 = 0.1e1 / t82
  t84 = br89_x(t81)
  t86 = jnp.exp(-0.2e1 / 0.3e1 * t84)
  t87 = 0.1e1 / t86
  t88 = t83 * t87
  t89 = t84 ** 2
  t91 = t89 - 0.2e1 * t84 + 0.3e1
  t92 = 0.1e1 / t91
  t93 = t88 * t92
  t94 = t84 - 0.2e1
  t95 = t94 ** 2
  t97 = jnp.exp(t84 / 0.3e1)
  t98 = t95 * t97
  t99 = jnp.exp(-t84)
  t102 = t99 * (0.1e1 + t84 / 0.2e1)
  t103 = 0.1e1 - t102
  t104 = 0.1e1 / t84
  t105 = t103 * t104
  t106 = t98 * t105
  t107 = t93 * t106
  t120 = f.my_piecewise3(t59, t61, -0.78106666666666666666666666666666666666666666666667e0 * tau0 * t47 - 0.23733333333333333333333333333333333333333333333333e0 * s0 * t64 - 0.28266666666666666666666666666666666666666666666667e-1 * t50 / t32 / t51 / t45)
  t121 = t31 * t120
  t122 = t27 * t121
  t123 = t30 * t120
  t124 = t123 * t88
  t125 = t92 * t95
  t126 = t125 * t102
  t128 = t123 * t83
  t129 = t87 * t92
  t131 = t129 * t95 * t99
  t134 = t124 * t126 - t128 * t131 / 0.2e1
  t135 = t134 * t104
  t136 = t98 * t135
  t137 = t93 * t136
  t140 = t29 * jnp.pi
  t141 = t28 * t140
  t142 = t120 ** 2
  t143 = t141 * t142
  t144 = t27 * t143
  t145 = t82 ** 2
  t146 = 0.1e1 / t145
  t147 = t86 ** 2
  t148 = 0.1e1 / t147
  t149 = t146 * t148
  t150 = t91 ** 2
  t151 = 0.1e1 / t150
  t152 = t149 * t151
  t153 = t95 ** 2
  t154 = t153 * t97
  t155 = t154 * t105
  t156 = t152 * t155
  t159 = t28 * t97
  t160 = t159 * t134
  t161 = t27 * t160
  t162 = 0.1e1 / t89
  t163 = t162 * t30
  t165 = t88 * t125
  t166 = t163 * t120 * t165
  t169 = t159 * t103
  t170 = t27 * t169
  t172 = t163 * t77 * t165
  t175 = t2 ** 2
  t176 = 0.1e1 / t175
  t178 = -t12 * t176 + t3
  t179 = f.my_piecewise5(t6, 0, t10, 0, t178)
  t182 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t179)
  t183 = t22 ** 2
  t184 = 0.1e1 / t183
  t186 = t182 * t184 * t26
  t187 = t159 * t105
  t191 = 0.1e1 / t183 / t2
  t193 = t21 * t191 * t26
  t196 = t30 * t77
  t197 = t196 * t88
  t199 = t30 * t142
  t201 = 0.1e1 / t82 / t81
  t202 = t201 * t87
  t203 = t199 * t202
  t206 = t140 * t142
  t207 = t206 * t149
  t208 = t151 * t153
  t209 = t208 * t102
  t212 = t151 * t95
  t213 = t84 * t30
  t216 = t129 * t95
  t219 = 0.2e1 * t213 * t120 * t165 - 0.2e1 * t128 * t216
  t220 = t102 * t219
  t221 = t212 * t220
  t223 = t95 * t94
  t224 = t151 * t223
  t225 = t224 * t102
  t228 = t206 * t146
  t229 = t148 * t151
  t230 = t153 * t99
  t231 = t229 * t230
  t234 = t196 * t83
  t237 = t199 * t201
  t239 = t99 * t219
  t240 = t212 * t239
  t244 = t229 * t223 * t99
  t246 = t197 * t126 - 0.2e1 * t203 * t126 - t207 * t209 / 0.3e1 - t124 * t221 + 0.2e1 * t207 * t225 + 0.2e1 / 0.3e1 * t228 * t231 - t234 * t131 / 0.2e1 + t237 * t131 + t124 * t240 / 0.2e1 - t228 * t244
  t247 = t246 * t104
  t248 = t159 * t247
  t251 = t19 ** 2
  t252 = 0.1e1 / t251
  t253 = t179 ** 2
  t257 = 0.1e1 / t175 / t2
  t260 = 0.2e1 * t12 * t257 - 0.2e1 * t176
  t261 = f.my_piecewise5(t6, 0, t10, 0, t260)
  t265 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t252 * t253 + 0.4e1 / 0.3e1 * t19 * t261)
  t267 = t265 * t22 * t26
  t271 = t182 * t22 * t26
  t272 = t159 * t135
  t276 = t21 * t184 * t26
  t279 = -t79 * t107 / 0.12e2 - t122 * t137 / 0.6e1 - t144 * t156 / 0.12e2 + t161 * t166 / 0.2e1 + t170 * t172 / 0.4e1 - t186 * t187 / 0.6e1 + t193 * t187 / 0.18e2 - t27 * t248 / 0.4e1 - t267 * t187 / 0.4e1 - t271 * t272 / 0.2e1 - t276 * t272 / 0.6e1
  t280 = t276 * t121
  t283 = t276 * t169
  t286 = t271 * t121
  t289 = t271 * t169
  t292 = t223 * t97
  t293 = t292 * t105
  t294 = t152 * t293
  t297 = t103 * t162
  t298 = t154 * t297
  t299 = t152 * t298
  t303 = 0.1e1 / t89 / t84
  t304 = t303 * t140
  t306 = t149 * t208
  t307 = t304 * t142 * t306
  t310 = t162 * t140
  t312 = t149 * t224
  t313 = t310 * t142 * t312
  t316 = t31 * t142
  t317 = t27 * t316
  t318 = t202 * t92
  t319 = t318 * t106
  t322 = t120 * t83
  t323 = t31 * t322
  t324 = t27 * t323
  t325 = t87 * t151
  t326 = t325 * t95
  t327 = t97 * t103
  t328 = t104 * t219
  t329 = t327 * t328
  t330 = t326 * t329
  t334 = t202 * t125
  t335 = t163 * t142 * t334
  t338 = t159 * t297
  t339 = t27 * t338
  t341 = t325 * t95 * t219
  t342 = t128 * t341
  t345 = -t280 * t107 / 0.18e2 + t283 * t166 / 0.6e1 - t286 * t107 / 0.6e1 + t289 * t166 / 0.2e1 - t144 * t294 / 0.6e1 + t144 * t299 / 0.3e1 - t170 * t307 / 0.2e1 + t170 * t313 / 0.2e1 + t317 * t319 / 0.6e1 + t324 * t330 / 0.12e2 - t170 * t335 / 0.2e1 - t339 * t342 / 0.4e1
  t347 = f.my_piecewise3(t1, 0, t279 + t345)
  t349 = r1 <= f.p.dens_threshold
  t350 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t351 = 0.1e1 + t350
  t352 = t351 <= f.p.zeta_threshold
  t353 = t351 ** (0.1e1 / 0.3e1)
  t354 = t353 ** 2
  t355 = 0.1e1 / t354
  t357 = f.my_piecewise5(t10, 0, t6, 0, -t178)
  t358 = t357 ** 2
  t362 = f.my_piecewise5(t10, 0, t6, 0, -t260)
  t366 = f.my_piecewise3(t352, 0, 0.4e1 / 0.9e1 * t355 * t358 + 0.4e1 / 0.3e1 * t353 * t362)
  t369 = r1 ** (0.1e1 / 0.3e1)
  t370 = t369 ** 2
  t375 = r1 ** 2
  t380 = s2 ** 2
  t381 = t375 ** 2
  t387 = 0.46864e0 * tau1 / t370 / r1 - t44 + 0.89e-1 * s2 / t370 / t375 + 0.53e-2 * t380 / t369 / t381 / r1
  t388 = abs(t387)
  t391 = f.my_piecewise3(0.0e0 < t387, 0.50e-12, -0.50e-12)
  t392 = f.my_piecewise3(t388 < 0.50e-12, t391, t387)
  t393 = br89_x(t392)
  t395 = jnp.exp(t393 / 0.3e1)
  t397 = jnp.exp(-t393)
  t404 = t28 * t395 * (0.1e1 - t397 * (0.1e1 + t393 / 0.2e1)) / t393
  t409 = f.my_piecewise3(t352, 0, 0.4e1 / 0.3e1 * t353 * t357)
  t415 = f.my_piecewise3(t352, t18, t353 * t351)
  t421 = f.my_piecewise3(t349, 0, -t366 * t22 * t26 * t404 / 0.4e1 - t409 * t184 * t26 * t404 / 0.6e1 + t415 * t191 * t26 * t404 / 0.18e2)
  t431 = t142 * t120
  t432 = t30 * t431
  t436 = t40 * t431
  t438 = 0.1e1 / t145 / t82
  t439 = t436 * t438
  t441 = 0.1e1 / t147 / t86
  t443 = 0.1e1 / t150 / t91
  t444 = t441 * t443
  t445 = t153 * t94
  t456 = t51 ** 2
  t462 = f.my_piecewise3(t59, t61, -0.76370962962962962962962962962962962962962962962965e1 * tau0 * t68 - 0.40610370370370370370370370370370370370370370370370e1 * s0 / t33 / t52 - 0.13128296296296296296296296296296296296296296296296e1 * t50 / t32 / t456)
  t463 = t30 * t462
  t467 = t140 * t431
  t469 = 0.1e1 / t145 / t81
  t470 = t467 * t469
  t473 = t153 * t95
  t483 = t229 * t153
  t493 = t84 * t140 * t142
  t506 = t229 * t223
  t509 = 0.2e1 / 0.3e1 * t228 * t483 + 0.2e1 * t213 * t77 * t165 - 0.4e1 * t213 * t142 * t334 + 0.4e1 / 0.3e1 * t493 * t306 - 0.2e1 * t213 * t322 * t341 + 0.4e1 * t493 * t312 - 0.2e1 * t234 * t216 + 0.4e1 * t237 * t216 + 0.2e1 * t342 - 0.4e1 * t228 * t506
  t514 = t196 * t202
  t515 = t99 * t120
  t522 = t469 * t148
  t523 = t467 * t522
  t526 = t438 * t441
  t527 = t436 * t526
  t528 = t443 * t473
  t532 = t443 * t153
  t538 = t140 * t77
  t539 = t538 * t149
  t543 = -0.3e1 * t432 * t146 * t131 + 0.10e2 / 0.3e1 * t439 * t444 * t445 * t99 - t463 * t83 * t131 / 0.2e1 - 0.4e1 * t470 * t231 + t439 * t444 * t473 * t99 / 0.18e2 + 0.6e1 * t470 * t244 - 0.3e1 * t439 * t444 * t230 + t124 * t212 * t99 * t509 / 0.2e1 + 0.3e1 * t514 * t125 * t515 + t197 * t240 - 0.2e1 * t203 * t240 + 0.2e1 * t523 * t209 - t527 * t528 * t102 / 0.9e1 - 0.2e1 * t207 * t532 * t239 + t463 * t88 * t126 + 0.2e1 * t539 * t208 * t515
  t544 = t146 * t87
  t548 = t443 * t95
  t549 = t219 ** 2
  t555 = t443 * t445
  t562 = t443 * t223
  t576 = t102 * t120
  t594 = 0.6e1 * t432 * t544 * t126 - t124 * t548 * t99 * t549 - 0.12e2 * t523 * t225 - 0.2e1 / 0.3e1 * t527 * t555 * t102 + 0.6e1 * t527 * t532 * t102 + 0.3e1 * t207 * t562 * t239 - 0.3e1 * t539 * t224 * t515 - 0.6e1 * t207 * t562 * t220 + 0.2e1 * t124 * t548 * t102 * t549 - 0.6e1 * t514 * t125 * t576 - 0.2e1 * t197 * t221 - t539 * t208 * t576 + 0.4e1 * t203 * t221 + t207 * t532 * t220 - t124 * t212 * t102 * t509 + 0.6e1 * t539 * t224 * t576
  t614 = t175 ** 2
  t618 = 0.6e1 * t257 - 0.6e1 * t12 / t614
  t619 = f.my_piecewise5(t6, 0, t10, 0, t618)
  t623 = f.my_piecewise3(t16, 0, -0.8e1 / 0.27e2 / t251 / t15 * t253 * t179 + 0.4e1 / 0.3e1 * t252 * t179 * t261 + 0.4e1 / 0.3e1 * t19 * t619)
  t631 = 0.1e1 / t183 / t175
  t641 = -t276 * t248 / 0.4e1 + t182 * t191 * t26 * t187 / 0.6e1 + t193 * t272 / 0.6e1 - t27 * t159 * (t543 + t594) * t104 / 0.4e1 - t265 * t184 * t26 * t187 / 0.4e1 - t186 * t272 / 0.2e1 - t623 * t22 * t26 * t187 / 0.4e1 - 0.3e1 / 0.4e1 * t267 * t272 - 0.5e1 / 0.54e2 * t21 * t631 * t26 * t187 - 0.3e1 / 0.4e1 * t271 * t248 - t276 * t338 * t342 / 0.4e1
  t647 = t27 * t141 * t142 * t146
  t648 = t148 * t443
  t653 = t648 * t153
  t658 = t103 * t303
  t660 = t27 * t159 * t658
  t692 = t327 * t104 * t120
  t703 = t27 * t141 * t77 * t146
  t707 = t271 * t323 * t330 / 0.4e1 + t647 * t648 * t223 * t329 / 0.2e1 - t647 * t653 * t327 * t162 * t219 + 0.3e1 / 0.2e1 * t660 * t228 * t648 * t153 * t219 - 0.3e1 / 0.2e1 * t339 * t228 * t648 * t223 * t219 - t27 * t31 * t142 * t201 * t330 / 0.3e1 + t324 * t326 * t327 * t104 * t509 / 0.12e2 + t339 * t237 * t341 - t339 * t128 * t325 * t95 * t509 / 0.4e1 + t27 * t31 * t77 * t201 * t216 * t692 / 0.2e1 + t27 * t31 * t77 * t83 * t330 / 0.6e1 - t703 * t483 * t692 / 0.4e1
  t717 = t134 * t162
  t734 = t538 * t146
  t745 = t87 * t443
  t760 = t324 * t326 * t97 * t134 * t328 / 0.4e1 + t647 * t653 * t329 / 0.4e1 - 0.3e1 / 0.4e1 * t27 * t159 * t717 * t342 - 0.3e1 / 0.2e1 * t339 * t196 * t201 * t129 * t95 * t120 - t339 * t234 * t341 / 0.2e1 + t276 * t323 * t330 / 0.12e2 - 0.3e1 / 0.2e1 * t660 * t734 * t229 * t153 * t120 + 0.3e1 / 0.2e1 * t339 * t734 * t229 * t223 * t120 + t339 * t128 * t745 * t95 * t549 / 0.2e1 - t324 * t745 * t95 * t327 * t104 * t549 / 0.6e1 - 0.3e1 / 0.4e1 * t271 * t338 * t342
  t777 = t276 * t143
  t796 = -t703 * t506 * t692 / 0.2e1 + t703 * t483 * t327 * t162 * t120 + t271 * t316 * t319 / 0.2e1 - 0.3e1 / 0.2e1 * t289 * t335 - 0.3e1 / 0.2e1 * t161 * t307 + 0.3e1 / 0.2e1 * t161 * t313 - t777 * t294 / 0.6e1 + t777 * t299 / 0.3e1 - t283 * t307 / 0.2e1 - t144 * t152 * t292 * t135 / 0.2e1 + t144 * t152 * t154 * t717 + 0.3e1 / 0.2e1 * t170 * t163 * t431 * t544 * t125
  t810 = t27 * t141 * t431
  t811 = t522 * t151
  t827 = t271 * t143
  t832 = t27 * t28 * t40 * t431
  t833 = t526 * t443
  t834 = t473 * t97
  t839 = -t276 * t78 * t107 / 0.12e2 - t280 * t137 / 0.6e1 + t317 * t318 * t136 / 0.2e1 - t777 * t156 / 0.12e2 + t810 * t811 * t155 / 0.2e1 - t79 * t137 / 0.4e1 - t286 * t137 / 0.2e1 - t122 * t93 * t98 * t247 / 0.4e1 - t144 * t152 * t154 * t135 / 0.4e1 - t827 * t156 / 0.4e1 - 0.3e1 / 0.2e1 * t832 * t833 * t834 * t658
  t840 = t89 ** 2
  t867 = t445 * t97
  t880 = 0.3e1 / 0.2e1 * t170 / t840 * t40 * t431 * t526 * t528 + t276 * t160 * t166 / 0.2e1 - 0.3e1 / 0.2e1 * t161 * t335 + t283 * t172 / 0.4e1 + t276 * t316 * t319 / 0.6e1 - t283 * t335 / 0.2e1 - 0.3e1 / 0.2e1 * t289 * t307 + 0.3e1 / 0.2e1 * t289 * t313 - t832 * t833 * t155 / 0.2e1 + 0.7e1 / 0.3e1 * t832 * t833 * t867 * t297 - 0.11e2 / 0.18e2 * t832 * t833 * t867 * t105 + 0.23e2 / 0.36e2 * t832 * t833 * t834 * t297
  t925 = -t267 * t121 * t107 / 0.4e1 + 0.3e1 / 0.4e1 * t267 * t169 * t166 - t186 * t121 * t107 / 0.6e1 + t186 * t169 * t166 / 0.2e1 + t193 * t121 * t107 / 0.18e2 - t193 * t169 * t166 / 0.6e1 - 0.5e1 / 0.36e2 * t832 * t833 * t834 * t105 + t810 * t811 * t293 - 0.2e1 * t810 * t811 * t298 + 0.3e1 * t170 * t304 * t431 * t522 * t208 - 0.3e1 * t170 * t310 * t431 * t522 * t224 - t27 * t31 * t431 * t544 * t92 * t106 / 0.2e1
  t965 = 0.3e1 / 0.2e1 * t271 * t160 * t166 + 0.3e1 / 0.4e1 * t27 * t159 * t246 * t166 + 0.3e1 / 0.4e1 * t161 * t172 + 0.3e1 / 0.4e1 * t289 * t172 + t170 * t163 * t462 * t165 / 0.4e1 - t271 * t78 * t107 / 0.4e1 - t27 * t31 * t462 * t107 / 0.12e2 - 0.3e1 * t170 * t303 * t40 * t431 * t526 * t555 + 0.3e1 / 0.2e1 * t170 * t162 * t40 * t431 * t526 * t532 + t283 * t313 / 0.2e1 - t827 * t294 / 0.2e1 + t827 * t299
  t969 = f.my_piecewise3(t1, 0, t641 + t707 + t760 + t796 + t839 + t880 + t925 + t965)
  t979 = f.my_piecewise5(t10, 0, t6, 0, -t618)
  t983 = f.my_piecewise3(t352, 0, -0.8e1 / 0.27e2 / t354 / t351 * t358 * t357 + 0.4e1 / 0.3e1 * t355 * t357 * t362 + 0.4e1 / 0.3e1 * t353 * t979)
  t1001 = f.my_piecewise3(t349, 0, -t983 * t22 * t26 * t404 / 0.4e1 - t366 * t184 * t26 * t404 / 0.4e1 + t409 * t191 * t26 * t404 / 0.6e1 - 0.5e1 / 0.54e2 * t415 * t631 * t26 * t404)
  d111 = 0.3e1 * t347 + 0.3e1 * t421 + t2 * (t969 + t1001)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t21 * t22 * t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = r0 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = jnp.pi ** 2
  t38 = t37 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t41 = 0.3e1 / 0.10e2 * t36 * t39
  t42 = r0 ** 2
  t44 = 0.1e1 / t30 / t42
  t47 = s0 ** 2
  t48 = t42 ** 2
  t49 = t48 * r0
  t54 = 0.46864e0 * tau0 / t30 / r0 - t41 + 0.89e-1 * s0 * t44 + 0.53e-2 * t47 / t29 / t49
  t55 = abs(t54)
  t56 = t55 < 0.50e-12
  t57 = 0.0e0 < t54
  t58 = f.my_piecewise3(t57, 0.50e-12, -0.50e-12)
  t59 = f.my_piecewise3(t56, t58, t54)
  t60 = br89_x(t59)
  t62 = jnp.exp(t60 / 0.3e1)
  t63 = t28 * t62
  t64 = jnp.exp(-t60)
  t66 = 0.1e1 + t60 / 0.2e1
  t67 = t64 * t66
  t68 = 0.1e1 - t67
  t69 = t60 ** 2
  t70 = 0.1e1 / t69
  t71 = t68 * t70
  t72 = t63 * t71
  t73 = t27 * t72
  t74 = jnp.pi ** (0.1e1 / 0.3e1)
  t75 = t74 * jnp.pi
  t76 = f.my_piecewise3(t57, 0, 0)
  t79 = t42 * r0
  t81 = 0.1e1 / t30 / t79
  t84 = t48 * t42
  t90 = f.my_piecewise3(t56, t76, -0.78106666666666666666666666666666666666666666666667e0 * tau0 * t44 - 0.23733333333333333333333333333333333333333333333333e0 * s0 * t81 - 0.28266666666666666666666666666666666666666666666667e-1 * t47 / t29 / t84)
  t91 = t90 ** 2
  t92 = t75 * t91
  t93 = t59 ** 2
  t94 = t93 ** 2
  t95 = 0.1e1 / t94
  t96 = t92 * t95
  t98 = jnp.exp(-0.2e1 / 0.3e1 * t60)
  t99 = t98 ** 2
  t100 = 0.1e1 / t99
  t102 = t69 - 0.2e1 * t60 + 0.3e1
  t103 = t102 ** 2
  t105 = 0.1e1 / t103 / t102
  t106 = t100 * t105
  t107 = t60 - 0.2e1
  t108 = t107 ** 2
  t109 = t108 * t107
  t110 = t74 ** 2
  t111 = t60 * t110
  t113 = 0.1e1 / t93
  t114 = 0.1e1 / t98
  t115 = t113 * t114
  t116 = 0.1e1 / t102
  t117 = t116 * t108
  t118 = t115 * t117
  t120 = t110 * t90
  t121 = t120 * t113
  t122 = t114 * t116
  t123 = t122 * t108
  t126 = 0.2e1 * t111 * t90 * t118 - 0.2e1 * t121 * t123
  t128 = t106 * t109 * t126
  t129 = t96 * t128
  t132 = t28 * t110
  t133 = t93 * t59
  t134 = 0.1e1 / t133
  t135 = t91 * t134
  t136 = t132 * t135
  t137 = t27 * t136
  t138 = 0.1e1 / t103
  t139 = t114 * t138
  t140 = t139 * t108
  t141 = t62 * t68
  t142 = 0.1e1 / t60
  t143 = t142 * t126
  t144 = t141 * t143
  t145 = t140 * t144
  t148 = t90 * t113
  t149 = t132 * t148
  t150 = t27 * t149
  t151 = t100 * t138
  t152 = t108 ** 2
  t153 = t151 * t152
  t159 = 0.1e1 / t30 / t48
  t168 = f.my_piecewise3(t56, t76, 0.20828444444444444444444444444444444444444444444445e1 * tau0 * t81 + 0.87022222222222222222222222222222222222222222222221e0 * s0 * t159 + 0.17902222222222222222222222222222222222222222222222e0 * t47 / t29 / t48 / t79)
  t173 = t134 * t114
  t174 = t173 * t117
  t177 = t60 * t75
  t178 = t177 * t91
  t179 = t95 * t100
  t180 = t138 * t152
  t181 = t179 * t180
  t184 = t111 * t148
  t186 = t139 * t108 * t126
  t189 = t138 * t109
  t190 = t179 * t189
  t193 = t110 * t168
  t194 = t193 * t113
  t197 = t110 * t91
  t198 = t197 * t134
  t201 = t121 * t186
  t203 = t151 * t109
  t206 = 0.2e1 / 0.3e1 * t96 * t153 + 0.2e1 * t111 * t168 * t118 - 0.4e1 * t111 * t91 * t174 + 0.4e1 / 0.3e1 * t178 * t181 - 0.2e1 * t184 * t186 + 0.4e1 * t178 * t190 - 0.2e1 * t194 * t123 + 0.4e1 * t198 * t123 + 0.2e1 * t201 - 0.4e1 * t96 * t203
  t207 = t142 * t206
  t208 = t141 * t207
  t209 = t140 * t208
  t212 = t198 * t186
  t215 = t139 * t108 * t206
  t216 = t121 * t215
  t219 = t168 * t134
  t220 = t132 * t219
  t222 = t142 * t90
  t223 = t141 * t222
  t224 = t123 * t223
  t227 = t168 * t113
  t228 = t132 * t227
  t229 = t27 * t228
  t232 = t28 * t75
  t233 = t168 * t95
  t234 = t232 * t233
  t235 = t27 * t234
  t236 = t153 * t223
  t239 = t120 * t115
  t240 = t117 * t67
  t242 = t108 * t64
  t243 = t122 * t242
  t246 = t239 * t240 - t121 * t243 / 0.2e1
  t247 = t62 * t246
  t248 = t247 * t143
  t249 = t140 * t248
  t252 = t91 * t95
  t253 = t232 * t252
  t254 = t27 * t253
  t255 = t106 * t152
  t256 = t255 * t144
  t259 = t246 * t70
  t260 = t63 * t259
  t261 = t27 * t260
  t264 = -0.3e1 / 0.2e1 * t73 * t129 - t137 * t145 / 0.3e1 + t150 * t209 / 0.12e2 + t73 * t212 - t73 * t216 / 0.4e1 + t27 * t220 * t224 / 0.2e1 + t229 * t145 / 0.6e1 - t235 * t236 / 0.4e1 + t150 * t249 / 0.4e1 + t254 * t256 / 0.4e1 - 0.3e1 / 0.4e1 * t261 * t201
  t267 = t122 * t108 * t90
  t268 = t193 * t134 * t267
  t271 = t194 * t186
  t274 = t22 ** 2
  t275 = 0.1e1 / t274
  t277 = t21 * t275 * t26
  t278 = t277 * t149
  t281 = t232 * t91
  t282 = t277 * t281
  t283 = t179 * t138
  t284 = t152 * t62
  t285 = t284 * t71
  t286 = t283 * t285
  t289 = t63 * t68
  t290 = t277 * t289
  t292 = 0.1e1 / t69 / t60
  t293 = t292 * t75
  t295 = t293 * t91 * t181
  t298 = t27 * t281
  t299 = t109 * t62
  t300 = t246 * t142
  t301 = t299 * t300
  t302 = t283 * t301
  t305 = t284 * t259
  t306 = t283 * t305
  t308 = t2 ** 2
  t309 = 0.1e1 / t308
  t311 = -t12 * t309 + t3
  t312 = f.my_piecewise5(t6, 0, t10, 0, t311)
  t315 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t312)
  t317 = t315 * t22 * t26
  t318 = t63 * t246
  t319 = t317 * t318
  t320 = t70 * t110
  t322 = t320 * t90 * t118
  t325 = t193 * t115
  t327 = t197 * t173
  t330 = t92 * t179
  t331 = t180 * t67
  t334 = t138 * t108
  t335 = t67 * t126
  t336 = t334 * t335
  t338 = t189 * t67
  t341 = t152 * t64
  t342 = t151 * t341
  t348 = t64 * t126
  t349 = t334 * t348
  t352 = t109 * t64
  t353 = t151 * t352
  t355 = t325 * t240 - 0.2e1 * t327 * t240 - t330 * t331 / 0.3e1 - t239 * t336 + 0.2e1 * t330 * t338 + 0.2e1 / 0.3e1 * t96 * t342 - t194 * t243 / 0.2e1 + t198 * t243 + t239 * t349 / 0.2e1 - t96 * t353
  t356 = t63 * t355
  t357 = t27 * t356
  t360 = t27 * t318
  t362 = t320 * t168 * t118
  t365 = t317 * t289
  t368 = t27 * t289
  t372 = 0.1e1 / t30 / t49
  t375 = t48 ** 2
  t381 = f.my_piecewise3(t56, t76, -0.76370962962962962962962962962962962962962962962965e1 * tau0 * t159 - 0.40610370370370370370370370370370370370370370370370e1 * s0 * t372 - 0.13128296296296296296296296296296296296296296296296e1 * t47 / t29 / t375)
  t383 = t320 * t381 * t118
  t386 = -0.3e1 / 0.2e1 * t73 * t268 - t73 * t271 / 0.2e1 + t278 * t145 / 0.12e2 + t282 * t286 / 0.3e1 - t290 * t295 / 0.2e1 - t298 * t302 / 0.2e1 + t298 * t306 + 0.3e1 / 0.2e1 * t319 * t322 + 0.3e1 / 0.4e1 * t357 * t322 + 0.3e1 / 0.4e1 * t360 * t362 + 0.3e1 / 0.4e1 * t365 * t362 + t368 * t383 / 0.4e1
  t388 = t132 * t168
  t389 = t317 * t388
  t390 = t115 * t116
  t391 = t108 * t62
  t392 = t68 * t142
  t393 = t391 * t392
  t394 = t390 * t393
  t397 = t132 * t381
  t398 = t27 * t397
  t401 = t292 * t37
  t402 = t91 * t90
  t405 = 0.1e1 / t94 / t93
  t407 = 0.1e1 / t99 / t98
  t408 = t405 * t407
  t409 = t152 * t107
  t410 = t105 * t409
  t411 = t408 * t410
  t412 = t401 * t402 * t411
  t415 = t70 * t37
  t417 = t105 * t152
  t418 = t408 * t417
  t419 = t415 * t402 * t418
  t422 = t70 * t75
  t424 = t422 * t91 * t190
  t427 = t317 * t281
  t428 = t299 * t392
  t429 = t283 * t428
  t433 = t232 * t402
  t434 = t27 * t433
  t436 = 0.1e1 / t94 / t59
  t437 = t436 * t100
  t438 = t437 * t138
  t439 = t284 * t392
  t440 = t438 * t439
  t443 = t277 * t318
  t447 = t320 * t91 * t174
  t452 = -t389 * t394 / 0.4e1 - t398 * t394 / 0.12e2 - 0.3e1 * t368 * t412 + 0.3e1 / 0.2e1 * t368 * t419 + t290 * t424 / 0.2e1 - t427 * t429 / 0.2e1 + t427 * t286 + t434 * t440 / 0.2e1 + t443 * t322 / 0.2e1 - 0.3e1 / 0.2e1 * t360 * t447 + t290 * t362 / 0.4e1
  t453 = t132 * t91
  t454 = t277 * t453
  t455 = t173 * t116
  t456 = t455 * t393
  t461 = t317 * t453
  t470 = t283 * t439
  t473 = t27 * t388
  t474 = t391 * t300
  t475 = t390 * t474
  t478 = t132 * t90
  t479 = t317 * t478
  t482 = t27 * t478
  t483 = t355 * t142
  t484 = t391 * t483
  t485 = t390 * t484
  t488 = t284 * t300
  t489 = t283 * t488
  t494 = t454 * t456 / 0.6e1 - t290 * t447 / 0.2e1 + t461 * t456 / 0.2e1 - 0.3e1 / 0.2e1 * t360 * t295 + 0.3e1 / 0.2e1 * t360 * t424 - t282 * t429 / 0.6e1 - t282 * t470 / 0.12e2 - t473 * t475 / 0.4e1 - t479 * t475 / 0.2e1 - t482 * t485 / 0.4e1 - t298 * t489 / 0.4e1 - t427 * t470 / 0.4e1
  t497 = t28 * t37
  t498 = t497 * t402
  t499 = t27 * t498
  t500 = t408 * t105
  t501 = t152 * t108
  t502 = t501 * t62
  t503 = t68 * t292
  t504 = t502 * t503
  t505 = t500 * t504
  t508 = t69 ** 2
  t509 = 0.1e1 / t508
  t510 = t509 * t37
  t512 = t105 * t501
  t513 = t408 * t512
  t514 = t510 * t402 * t513
  t517 = t438 * t428
  t519 = t438 * t285
  t523 = t437 * t180
  t524 = t293 * t402 * t523
  t528 = t437 * t189
  t529 = t422 * t402 * t528
  t532 = t132 * t402
  t533 = t27 * t532
  t534 = t95 * t114
  t535 = t534 * t116
  t536 = t535 * t393
  t540 = t534 * t117
  t541 = t320 * t402 * t540
  t544 = t277 * t388
  t547 = t277 * t478
  t550 = t27 * t453
  t551 = t455 * t474
  t554 = -0.3e1 / 0.2e1 * t499 * t505 + 0.3e1 / 0.2e1 * t368 * t514 + t434 * t517 - 0.2e1 * t434 * t519 + 0.3e1 * t368 * t524 - 0.3e1 * t368 * t529 - t533 * t536 / 0.2e1 + 0.3e1 / 0.2e1 * t368 * t541 - t544 * t394 / 0.12e2 - t547 * t475 / 0.6e1 + t550 * t551 / 0.2e1
  t555 = t277 * t72
  t558 = t317 * t149
  t561 = t63 * t503
  t562 = t27 * t561
  t563 = t75 * t90
  t565 = t152 * t168
  t566 = t151 * t565
  t567 = t563 * t95 * t566
  t570 = t75 * t168
  t573 = t151 * t109 * t90
  t574 = t570 * t95 * t573
  t577 = t114 * t105
  t578 = t126 ** 2
  t580 = t577 * t108 * t578
  t581 = t121 * t580
  t584 = t577 * t108
  t585 = t142 * t578
  t586 = t141 * t585
  t587 = t584 * t586
  t590 = t203 * t223
  t595 = t153 * t141 * t70 * t90
  t597 = t317 * t72
  t600 = t106 * t109
  t601 = t600 * t144
  t604 = t70 * t126
  t605 = t141 * t604
  t606 = t255 * t605
  t608 = t152 * t126
  t609 = t106 * t608
  t610 = t96 * t609
  t613 = -t555 * t201 / 0.4e1 + t558 * t145 / 0.4e1 - 0.3e1 / 0.2e1 * t562 * t567 + 0.3e1 / 0.2e1 * t73 * t574 + t73 * t581 / 0.2e1 - t150 * t587 / 0.6e1 - t235 * t590 / 0.2e1 + t235 * t595 - 0.3e1 / 0.4e1 * t597 * t201 + t254 * t601 / 0.2e1 - t254 * t606 + 0.3e1 / 0.2e1 * t562 * t610
  t619 = t500 * t439
  t622 = t409 * t62
  t623 = t622 * t71
  t624 = t500 * t623
  t627 = t622 * t392
  t628 = t500 * t627
  t631 = t502 * t71
  t632 = t500 * t631
  t635 = t19 ** 2
  t636 = 0.1e1 / t635
  t637 = t312 ** 2
  t640 = t308 * t2
  t641 = 0.1e1 / t640
  t644 = 0.2e1 * t12 * t641 - 0.2e1 * t309
  t645 = f.my_piecewise5(t6, 0, t10, 0, t644)
  t649 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t636 * t637 + 0.4e1 / 0.3e1 * t19 * t645)
  t651 = t649 * t22 * t26
  t652 = t651 * t478
  t655 = t651 * t289
  t659 = t315 * t275 * t26
  t660 = t659 * t478
  t663 = t659 * t289
  t667 = 0.1e1 / t274 / t2
  t669 = t21 * t667 * t26
  t670 = t669 * t478
  t673 = t669 * t289
  t676 = -0.3e1 / 0.2e1 * t365 * t295 + 0.3e1 / 0.2e1 * t365 * t424 - t499 * t619 / 0.2e1 + 0.7e1 / 0.3e1 * t499 * t624 - 0.11e2 / 0.18e2 * t499 * t628 + 0.23e2 / 0.36e2 * t499 * t632 - t652 * t394 / 0.4e1 + 0.3e1 / 0.4e1 * t655 * t322 - t660 * t394 / 0.6e1 + t663 * t322 / 0.2e1 + t670 * t394 / 0.18e2 - t673 * t322 / 0.6e1
  t677 = t502 * t392
  t678 = t500 * t677
  t683 = t110 * t381
  t684 = t683 * t115
  t686 = t570 * t179
  t687 = t64 * t90
  t688 = t180 * t687
  t691 = t75 * t402
  t692 = t691 * t437
  t695 = t110 * t402
  t696 = t695 * t534
  t699 = t105 * t108
  t700 = t64 * t578
  t701 = t699 * t700
  t705 = t37 * t402
  t706 = t705 * t408
  t707 = t410 * t67
  t710 = t417 * t67
  t713 = t105 * t109
  t714 = t713 * t348
  t717 = t189 * t687
  t720 = t193 * t173
  t721 = t117 * t687
  t727 = t64 * t206
  t728 = t334 * t727
  t731 = t512 * t67
  t734 = t417 * t348
  t737 = t684 * t240 + 0.2e1 * t686 * t688 + 0.2e1 * t692 * t331 + 0.6e1 * t696 * t240 - t239 * t701 - 0.12e2 * t692 * t338 - 0.2e1 / 0.3e1 * t706 * t707 + 0.6e1 * t706 * t710 + 0.3e1 * t330 * t714 - 0.3e1 * t686 * t717 + 0.3e1 * t720 * t721 + t325 * t349 - 0.2e1 * t327 * t349 + t239 * t728 / 0.2e1 - t706 * t731 / 0.9e1 - 0.2e1 * t330 * t734
  t738 = t713 * t335
  t741 = t67 * t578
  t742 = t699 * t741
  t745 = t67 * t90
  t746 = t117 * t745
  t751 = t180 * t745
  t755 = t417 * t335
  t757 = t67 * t206
  t758 = t334 * t757
  t760 = t189 * t745
  t763 = t705 * t405
  t764 = t407 * t105
  t765 = t501 * t64
  t766 = t764 * t765
  t769 = t691 * t436
  t772 = t764 * t341
  t775 = t695 * t95
  t778 = t409 * t64
  t779 = t764 * t778
  t782 = t683 * t113
  t787 = -0.6e1 * t330 * t738 + 0.2e1 * t239 * t742 - 0.6e1 * t720 * t746 - 0.2e1 * t325 * t336 - t686 * t751 + 0.4e1 * t327 * t336 + t330 * t755 - t239 * t758 + 0.6e1 * t686 * t760 + t763 * t766 / 0.18e2 + 0.6e1 * t769 * t353 - 0.3e1 * t763 * t772 - 0.3e1 * t775 * t243 + 0.10e2 / 0.3e1 * t763 * t779 - t782 * t243 / 0.2e1 - 0.4e1 * t769 * t342
  t788 = t737 + t787
  t789 = t788 * t142
  t790 = t63 * t789
  t793 = t63 * t483
  t797 = t315 * t667 * t26
  t798 = t63 * t392
  t801 = t63 * t300
  t807 = t649 * t275 * t26
  t813 = 0.1e1 / t635 / t15
  t817 = t636 * t312
  t820 = t308 ** 2
  t821 = 0.1e1 / t820
  t824 = -0.6e1 * t12 * t821 + 0.6e1 * t641
  t825 = f.my_piecewise5(t6, 0, t10, 0, t824)
  t829 = f.my_piecewise3(t16, 0, -0.8e1 / 0.27e2 * t813 * t637 * t312 + 0.4e1 / 0.3e1 * t817 * t645 + 0.4e1 / 0.3e1 * t19 * t825)
  t831 = t829 * t22 * t26
  t837 = 0.1e1 / t274 / t308
  t839 = t21 * t837 * t26
  t842 = -0.5e1 / 0.36e2 * t499 * t678 - 0.3e1 / 0.2e1 * t365 * t447 - t27 * t790 / 0.4e1 - t277 * t793 / 0.4e1 + t797 * t798 / 0.6e1 + t669 * t801 / 0.6e1 - 0.3e1 / 0.4e1 * t317 * t793 - t807 * t798 / 0.4e1 - t659 * t801 / 0.2e1 - t831 * t798 / 0.4e1 - 0.3e1 / 0.4e1 * t651 * t801 - 0.5e1 / 0.54e2 * t839 * t798
  t846 = f.my_piecewise3(t1, 0, t264 + t386 + t452 + t494 + t554 + t613 + t676 + t842)
  t848 = r1 <= f.p.dens_threshold
  t849 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t850 = 0.1e1 + t849
  t851 = t850 <= f.p.zeta_threshold
  t852 = t850 ** (0.1e1 / 0.3e1)
  t853 = t852 ** 2
  t855 = 0.1e1 / t853 / t850
  t857 = f.my_piecewise5(t10, 0, t6, 0, -t311)
  t858 = t857 ** 2
  t862 = 0.1e1 / t853
  t863 = t862 * t857
  t865 = f.my_piecewise5(t10, 0, t6, 0, -t644)
  t869 = f.my_piecewise5(t10, 0, t6, 0, -t824)
  t873 = f.my_piecewise3(t851, 0, -0.8e1 / 0.27e2 * t855 * t858 * t857 + 0.4e1 / 0.3e1 * t863 * t865 + 0.4e1 / 0.3e1 * t852 * t869)
  t876 = r1 ** (0.1e1 / 0.3e1)
  t877 = t876 ** 2
  t882 = r1 ** 2
  t887 = s2 ** 2
  t888 = t882 ** 2
  t894 = 0.46864e0 * tau1 / t877 / r1 - t41 + 0.89e-1 * s2 / t877 / t882 + 0.53e-2 * t887 / t876 / t888 / r1
  t895 = abs(t894)
  t898 = f.my_piecewise3(0.0e0 < t894, 0.50e-12, -0.50e-12)
  t899 = f.my_piecewise3(t895 < 0.50e-12, t898, t894)
  t900 = br89_x(t899)
  t902 = jnp.exp(t900 / 0.3e1)
  t904 = jnp.exp(-t900)
  t911 = t28 * t902 * (0.1e1 - t904 * (0.1e1 + t900 / 0.2e1)) / t900
  t919 = f.my_piecewise3(t851, 0, 0.4e1 / 0.9e1 * t862 * t858 + 0.4e1 / 0.3e1 * t852 * t865)
  t926 = f.my_piecewise3(t851, 0, 0.4e1 / 0.3e1 * t852 * t857)
  t932 = f.my_piecewise3(t851, t18, t852 * t850)
  t938 = f.my_piecewise3(t848, 0, -t873 * t22 * t26 * t911 / 0.4e1 - t919 * t275 * t26 * t911 / 0.4e1 + t926 * t667 * t26 * t911 / 0.6e1 - 0.5e1 / 0.54e2 * t932 * t837 * t26 * t911)
  t949 = 0.1e1 / t274 / t640
  t956 = t91 ** 2
  t958 = t405 * t100
  t968 = t436 * t114
  t974 = t27 * t497 * t956
  t976 = 0.1e1 / t94 / t133
  t977 = t976 * t407
  t978 = t977 * t105
  t984 = t277 * t498
  t997 = t651 * t281
  t1000 = t317 * t498
  t1007 = -t277 * t790 / 0.3e1 - t829 * t275 * t26 * t798 / 0.3e1 - t807 * t801 - t659 * t793 + 0.20e2 / 0.81e2 * t21 * t949 * t26 * t798 + 0.4e1 / 0.3e1 * t282 * t306 + 0.18e2 * t368 * t422 * t956 * t958 * t189 - 0.2e1 / 0.3e1 * t277 * t532 * t536 + 0.2e1 * t27 * t132 * t956 * t968 * t116 * t393 + 0.22e2 / 0.3e1 * t974 * t978 * t627 - 0.12e2 * t365 * t529 - 0.2e1 / 0.3e1 * t984 * t619 + 0.6e1 * t974 * t978 * t439 + 0.12e2 * t360 * t524 - 0.12e2 * t360 * t529 - 0.2e1 * t317 * t532 * t536 + 0.2e1 * t997 * t286 + 0.23e2 / 0.9e1 * t1000 * t632 - 0.3e1 * t655 * t295 + 0.3e1 * t655 * t424
  t1008 = t168 ** 2
  t1018 = t27 * t232 * t1008
  t1026 = t110 * t37
  t1029 = t27 * t28 * t1026 * t956
  t1030 = t94 ** 2
  t1031 = 0.1e1 / t1030
  t1032 = t99 ** 2
  t1033 = 0.1e1 / t1032
  t1034 = t1031 * t1033
  t1035 = t103 ** 2
  t1036 = 0.1e1 / t1035
  t1037 = t1034 * t1036
  t1038 = t152 ** 2
  t1039 = t1038 * t62
  t1040 = t68 * t509
  t1049 = t1036 * t1038
  t1079 = -0.3e1 / 0.2e1 * t368 * t293 * t1008 * t181 + 0.3e1 / 0.2e1 * t368 * t422 * t1008 * t190 - t1018 * t429 / 0.2e1 + 0.23e2 / 0.27e2 * t984 * t632 + t663 * t362 + t290 * t383 / 0.3e1 + 0.8e1 * t1029 * t1037 * t1039 * t1040 - 0.6e1 * t368 / t508 / t60 * t1026 * t956 * t1034 * t1049 - 0.2e1 * t443 * t295 - t298 * t283 * t299 * t483 - 0.2e1 / 0.3e1 * t282 * t302 + t365 * t383 + 0.4e1 * t434 * t438 * t301 + 0.47e2 / 0.3e1 * t1029 * t1037 * t631 + 0.2e1 * t663 * t424 + 0.2e1 * t443 * t424 + 0.28e2 / 0.9e1 * t984 * t624 - t997 * t429 - 0.2e1 * t427 * t302 - 0.22e2 / 0.9e1 * t1000 * t628
  t1081 = t152 * t109
  t1082 = t1081 * t62
  t1103 = t669 * t281
  t1114 = t659 * t281
  t1145 = 0.89e2 / 0.9e1 * t1029 * t1037 * t1082 * t71 - 0.22e2 / 0.9e1 * t499 * t500 * t622 * t300 - 0.61e2 / 0.27e2 * t1029 * t1037 * t1082 * t392 + 0.18e2 * t974 * t978 * t504 - 0.18e2 * t368 * t510 * t956 * t977 * t512 + 0.2e1 / 0.9e1 * t1103 * t429 - 0.4e1 / 0.9e1 * t1103 * t286 - 0.35e2 / 0.108e3 * t1029 * t1037 * t1039 * t392 - 0.2e1 / 0.3e1 * t660 * t475 - t1114 * t470 / 0.3e1 + t669 * t388 * t394 / 0.9e1 + 0.23e2 / 0.9e1 * t499 * t500 * t502 * t259 + 0.44e2 / 0.27e2 * t1029 * t1037 * t1039 * t71 - t831 * t478 * t394 / 0.3e1 - t652 * t475 - t997 * t470 / 0.2e1 + t831 * t289 * t322 - 0.18e2 * t368 * t293 * t956 * t958 * t180 - 0.2e1 * t663 * t295 + 0.12e2 * t365 * t524
  t1148 = t277 * t433
  t1157 = t246 * t292
  t1186 = t27 * t232 * t956
  t1187 = t958 * t138
  t1201 = t355 * t70
  t1206 = -0.4e1 * t290 * t412 - 0.6e1 * t319 * t295 + 0.6e1 * t319 * t424 - 0.3e1 * t357 * t295 - 0.2e1 * t533 * t535 * t474 - 0.3e1 * t1186 * t1187 * t439 + t651 * t453 * t456 + t807 * t289 * t322 - 0.3e1 * t655 * t447 + t27 * t132 * t1008 * t456 / 0.2e1 + 0.2e1 * t298 * t283 * t284 * t1201
  t1232 = f.my_piecewise3(t56, t76, 0.35639782716049382716049382716049382716049382716050e2 * tau0 * t372 + 0.23012543209876543209876543209876543209876543209876e2 * s0 / t30 / t84 + 0.10940246913580246913580246913580246913580246913580e2 * t47 / t29 / t375 / r0)
  t1254 = t1036 * t1081
  t1261 = t1036 * t501
  t1268 = t1036 * t409
  t1279 = t37 * t91
  t1280 = t1279 * t405
  t1286 = t407 * t1036
  t1292 = t360 * t383 + 0.3e1 / 0.2e1 * t655 * t362 - t651 * t388 * t394 / 0.2e1 - t317 * t397 * t394 / 0.3e1 - t389 * t475 - t27 * t132 * t1232 * t394 / 0.12e2 - t398 * t475 / 0.3e1 - 0.12e2 * t365 * t412 - 0.12e2 * t360 * t412 - 0.62e2 / 0.3e1 * t1029 * t1037 * t1082 * t503 - 0.28e2 * t974 * t978 * t623 - 0.22e2 / 0.27e2 * t984 * t628 + 0.18e2 * t368 * t509 * t1026 * t956 * t1034 * t1254 - 0.18e2 * t368 * t292 * t1026 * t956 * t1034 * t1261 + 0.6e1 * t368 * t70 * t1026 * t956 * t1034 * t1268 + 0.3e1 * t357 * t424 + 0.2e1 * t555 * t574 - 0.2e1 * t555 * t129 - 0.18e2 * t562 * t1280 * t764 * t409 * t168 + 0.18e2 * t562 * t763 * t1286 * t409 * t126
  t1308 = t277 * t253
  t1313 = t27 * t132 * t90 * t134
  t1314 = t142 * t168
  t1324 = t277 * t234
  t1330 = t106 * t284
  t1331 = t90 * t126
  t1337 = t126 * t206
  t1343 = t392 * t1331
  t1363 = t126 * t168
  t1373 = t317 * t234
  t1375 = t100 * t1036
  t1381 = -0.14e2 / 0.3e1 * t235 * t1330 * t71 * t1331 - t150 * t577 * t391 * t392 * t1337 / 0.2e1 + 0.7e1 / 0.3e1 * t235 * t106 * t299 * t1343 + 0.3e1 / 0.2e1 * t73 * t239 * t699 * t1337 + 0.7e1 * t562 * t686 * t417 * t1331 - 0.7e1 * t73 * t686 * t713 * t1331 + 0.7e1 / 0.6e1 * t235 * t1330 * t1343 + 0.9e1 / 0.2e1 * t73 * t120 * t173 * t334 * t1363 - 0.3e1 / 0.2e1 * t1313 * t139 * t391 * t392 * t1363 - t1373 * t236 - 0.11e2 / 0.2e1 * t562 * t96 * t1375 * t152 * t578
  t1384 = t317 * t253
  t1388 = t27 * t63 * t1157
  t1395 = t27 * t232 * t381 * t95
  t1398 = t92 * t436
  t1404 = t317 * t561
  t1409 = t75 * t381
  t1410 = t1409 * t95
  t1412 = t151 * t152 * t90
  t1441 = t232 * t90 * t95
  t1442 = t27 * t1441
  t1456 = -0.4e1 * t1384 * t606 - 0.6e1 * t1388 * t567 + t254 * t255 * t248 - 0.2e1 / 0.3e1 * t1395 * t590 + 0.18e2 * t562 * t1398 * t566 + 0.6e1 * t261 * t574 - 0.6e1 * t1404 * t567 + 0.6e1 * t597 * t574 - 0.2e1 * t562 * t1410 * t1412 + 0.2e1 * t73 * t1410 * t573 - 0.2e1 * t1373 * t590 + 0.2e1 / 0.3e1 * t27 * t132 * t381 * t134 * t224 + t27 * t132 * t381 * t113 * t145 / 0.4e1 - t1395 * t236 / 0.3e1 - 0.2e1 * t73 * t683 * t134 * t267 - 0.3e1 / 0.4e1 * t73 * t782 * t186 + 0.4e1 / 0.3e1 * t1442 * t153 * t141 * t70 * t381 + 0.2e1 * t317 * t220 * t224 + 0.2e1 / 0.3e1 * t317 * t228 * t145 + 0.4e1 * t261 * t212
  t1461 = t1375 * t152
  t1480 = t27 * t497 * t402 * t405
  t1481 = t1286 * t409
  t1487 = t27 * t497 * t91 * t405
  t1488 = t764 * t501
  t1489 = t70 * t168
  t1490 = t141 * t1489
  t1494 = t1286 * t501
  t1502 = t15 ** 2
  t1505 = t637 ** 2
  t1511 = t645 ** 2
  t1520 = -0.24e2 * t821 + 0.24e2 * t12 / t820 / t2
  t1521 = f.my_piecewise5(t6, 0, t10, 0, t1520)
  t1525 = f.my_piecewise3(t16, 0, 0.40e2 / 0.81e2 / t635 / t1502 * t1505 - 0.16e2 / 0.9e1 * t813 * t637 * t645 + 0.4e1 / 0.3e1 * t636 * t1511 + 0.16e2 / 0.9e1 * t817 * t825 + 0.4e1 / 0.3e1 * t19 * t1521)
  t1533 = t317 * t433
  t1552 = -0.4e1 / 0.9e1 * t277 * t136 * t145 - t1525 * t22 * t26 * t798 / 0.4e1 - t831 * t801 - 0.3e1 / 0.2e1 * t651 * t793 + 0.4e1 * t1533 * t517 + 0.4e1 / 0.3e1 * t1114 * t286 - 0.23e2 / 0.3e1 * t974 * t978 * t631 - t807 * t478 * t394 / 0.3e1 - 0.2e1 * t663 * t447 - 0.10e2 / 0.81e2 * t839 * t478 * t394 - 0.2e1 / 0.9e1 * t669 * t453 * t456
  t1603 = 0.10e2 / 0.27e2 * t839 * t289 * t322 + 0.2e1 / 0.9e1 * t797 * t478 * t394 - t1018 * t470 / 0.4e1 - 0.3e1 * t357 * t447 - 0.6e1 * t319 * t447 + t277 * t356 * t322 + 0.2e1 * t659 * t318 * t322 + 0.2e1 / 0.3e1 * t1148 * t440 + 0.2e1 / 0.3e1 * t454 * t551 - 0.2e1 * t1000 * t619 + 0.28e2 / 0.3e1 * t1000 * t624 - 0.6e1 * t1000 * t505 + 0.6e1 * t365 * t514 - 0.2e1 * t1029 * t1037 * t627 + 0.2e1 / 0.3e1 * t659 * t453 * t456 - 0.2e1 / 0.3e1 * t797 * t289 * t322 - t298 * t283 * t284 * t483 / 0.2e1 - t473 * t485 / 0.2e1 - t479 * t485 - t427 * t489
  t1660 = -t482 * t390 * t391 * t789 / 0.3e1 - 0.2e1 * t443 * t447 + 0.2e1 * t290 * t514 - t659 * t388 * t394 / 0.3e1 + 0.2e1 * t461 * t551 + t550 * t455 * t484 + 0.2e1 * t434 * t438 * t488 + 0.6e1 * t365 * t419 + 0.6e1 * t360 * t419 - 0.6e1 * t368 * t320 * t956 * t968 * t117 + 0.2e1 / 0.9e1 * t670 * t475 + t1103 * t470 / 0.9e1 - 0.2e1 / 0.3e1 * t669 * t318 * t322 - t673 * t362 / 0.3e1 - 0.5e1 / 0.9e1 * t1000 * t678 - 0.5e1 / 0.9e1 * t499 * t500 * t502 * t300 + 0.2e1 / 0.3e1 * t673 * t295 - 0.43e2 / 0.9e1 * t1029 * t1037 * t1039 * t503 + t368 * t320 * t1232 * t118 / 0.4e1 + t649 * t667 * t26 * t798 / 0.3e1
  t1679 = t177 * t402
  t1687 = t60 * t37 * t402
  t1698 = t177 * t233
  t1704 = t177 * t252
  t1707 = 0.2e1 * t216 - 0.4e1 * t581 + 0.2e1 * t567 - 0.2e1 * t610 + 0.2e1 * t111 * t381 * t118 - 0.8e1 * t1679 * t523 - 0.12e2 * t574 + 0.12e2 * t111 * t402 * t540 + 0.16e2 / 0.9e1 * t1687 * t513 + 0.12e2 * t1687 * t418 + 0.12e2 * t129 - 0.24e2 * t1679 * t528 - 0.4e1 * t111 * t227 * t186 + 0.4e1 * t1698 * t1412 + 0.8e1 * t111 * t135 * t186 - 0.4e1 * t1704 * t609
  t1725 = t764 * t409
  t1730 = t764 * t152
  t1740 = -0.2e1 * t184 * t215 + 0.12e2 * t1698 * t573 + 0.4e1 * t184 * t580 - 0.12e2 * t1704 * t128 - 0.12e2 * t111 * t219 * t267 - 0.4e1 * t769 * t153 - 0.2e1 * t782 * t123 - 0.12e2 * t775 * t123 + 0.4e1 / 0.3e1 * t763 * t1725 + 0.24e2 * t769 * t203 - 0.12e2 * t763 * t1730 + 0.20e2 / 0.9e1 * t763 * t1488 + 0.32e2 / 0.3e1 * t1687 * t411 + 0.12e2 * t268 + 0.4e1 * t271 - 0.8e1 * t212
  t1741 = t1707 + t1740
  t1755 = t27 * t232 * t91 * t436
  t1756 = t141 * t1314
  t1762 = t27 * t232 * t402 * t436
  t1765 = t153 * t1490
  t1791 = 0.2e1 / 0.3e1 * t797 * t801 + t558 * t209 / 0.3e1 + t229 * t209 / 0.4e1 + t150 * t140 * t247 * t207 / 0.3e1 + t150 * t140 * t141 * t142 * t1741 / 0.12e2 + t254 * t255 * t208 / 0.3e1 + 0.3e1 / 0.2e1 * t73 * t198 * t215 + 0.6e1 * t1755 * t203 * t1756 - 0.14e2 / 0.3e1 * t1762 * t601 - 0.12e2 * t1755 * t1765 + 0.28e2 / 0.3e1 * t1762 * t606 - t659 * t72 * t201 - t669 * t149 * t145 / 0.9e1 - 0.14e2 * t562 * t769 * t609 + 0.6e1 * t1404 * t610 + 0.2e1 * t597 * t581 + 0.2e1 * t261 * t581 + 0.3e1 / 0.2e1 * t73 * t194 * t580 - 0.6e1 * t261 * t268 - 0.2e1 * t261 * t271
  t1805 = t1409 * t179
  t1808 = t92 * t437
  t1809 = t67 * t168
  t1815 = t197 * t534
  t1821 = t1279 * t408
  t1825 = t1026 * t956
  t1826 = t1825 * t1031
  t1827 = t1033 * t1036
  t1831 = t75 * t956
  t1832 = t1831 * t405
  t1835 = t110 * t956
  t1840 = t75 * t1008
  t1841 = t1840 * t95
  t1846 = t110 * t1008
  t1850 = t37 * t956
  t1851 = t1850 * t976
  t1860 = t110 * t1232
  t1874 = 0.2e1 * t1841 * t342 - 0.3e1 * t1841 * t353 + 0.3e1 * t1846 * t134 * t243 - 0.40e2 * t1851 * t779 + 0.24e2 * t1832 * t342 + 0.10e2 / 0.3e1 * t1826 * t1827 * t1081 * t64 - t1860 * t113 * t243 / 0.2e1 - 0.2e1 / 0.3e1 * t1851 * t766 - 0.72e2 * t1808 * t189 * t1809 + 0.56e2 * t692 * t738 - 0.4e1 * t1821 * t410 * t1809
  t1884 = t1036 * t152
  t1896 = t563 * t179
  t1897 = t348 * t168
  t1911 = 0.4e1 * t706 * t1268 * t335 - 0.8e1 * t330 * t713 * t757 + 0.6e1 * t325 * t742 - 0.11e2 / 0.3e1 * t330 * t1884 * t741 + 0.8e1 * t1805 * t760 + 0.36e2 * t1821 * t417 * t1809 - 0.36e2 * t706 * t1884 * t335 + 0.14e2 * t1896 * t713 * t1897 - 0.9e1 * t720 * t334 * t687 * t126 + 0.2e1 / 0.3e1 * t706 * t1261 * t335 - 0.28e2 / 0.3e1 * t1896 * t417 * t1897
  t1912 = t683 * t173
  t1915 = t1036 * t108
  t1916 = t578 * t126
  t1921 = t1036 * t109
  t1946 = -0.8e1 * t1912 * t746 - 0.6e1 * t239 * t1915 * t67 * t1916 + 0.22e2 * t330 * t1921 * t741 - 0.12e2 * t327 * t742 + 0.4e1 / 0.3e1 * t330 * t417 * t757 - t239 * t334 * t67 * t1741 - 0.3e1 * t325 * t758 + 0.6e1 * t327 * t758 - 0.3e1 * t239 * t699 * t348 * t206 + 0.50e2 / 0.3e1 * t1826 * t1827 * t765 + 0.36e2 * t1851 * t772
  t1949 = t179 * t105
  t1951 = t66 * t126
  t1952 = t1951 * t90
  t1976 = t64 * t168
  t1985 = t1825 * t1034
  t1992 = 0.14e2 / 0.3e1 * t570 * t1949 * t341 * t1952 - 0.28e2 * t563 * t1949 * t352 * t1951 * t168 + 0.6e1 * t120 * t115 * t105 * t242 * t1951 * t206 + 0.18e2 * t193 * t173 * t138 * t242 * t1952 + 0.3e1 / 0.2e1 * t684 * t349 + 0.8e1 / 0.3e1 * t1805 * t688 - 0.24e2 * t1808 * t180 * t1976 + 0.56e2 / 0.3e1 * t692 * t734 + t1821 * t512 * t1976 / 0.3e1 - t1985 * t1049 * t67 / 0.9e1 - 0.8e1 / 0.3e1 * t330 * t417 * t727
  t1995 = t1831 * t958
  t2001 = t1850 * t977
  t2022 = t1860 * t115 * t240 - 0.12e2 * t1995 * t331 - 0.24e2 * t1835 * t968 * t240 + 0.4e1 / 0.3e1 * t2001 * t731 + 0.24e2 * t1985 * t1268 * t67 + t239 * t334 * t64 * t1741 / 0.2e1 - 0.3e1 * t327 * t728 + 0.8e1 * t2001 * t707 + 0.72e2 * t1995 * t338 - 0.11e2 * t330 * t1921 * t700 - 0.72e2 * t2001 * t710
  t2027 = t1840 * t179
  t2055 = 0.8e1 / 0.3e1 * t1985 * t1261 * t67 + 0.6e1 * t2027 * t338 - t706 * t1261 * t348 / 0.3e1 + 0.36e2 * t1808 * t189 * t1976 - 0.28e2 * t692 * t714 - 0.18e2 * t1821 * t417 * t1976 + 0.18e2 * t706 * t1884 * t348 - 0.18e2 * t1815 * t117 * t1976 + 0.9e1 * t696 * t349 + 0.20e2 * t1821 * t410 * t1976 - 0.20e2 * t706 * t1268 * t348
  t2083 = 0.4e1 * t1912 * t721 + 0.22e2 / 0.3e1 * t330 * t1884 * t700 - 0.4e1 * t1805 * t717 - 0.6e1 * t1846 * t173 * t240 - t2027 * t331 + 0.4e1 * t330 * t713 * t727 + 0.6e1 * t327 * t701 + 0.3e1 * t239 * t1915 * t64 * t1916 - 0.3e1 * t325 * t701 - 0.4e1 / 0.3e1 * t1985 * t1254 * t67 + 0.3e1 / 0.2e1 * t325 * t728
  t2140 = 0.2e1 / 0.3e1 * t254 * t600 * t208 - 0.4e1 / 0.3e1 * t254 * t255 * t141 * t70 * t206 - 0.2e1 / 0.9e1 * t278 * t587 + t137 * t587 + 0.2e1 / 0.3e1 * t555 * t581 + 0.11e2 / 0.2e1 * t73 * t96 * t1375 * t109 * t578 - 0.11e2 / 0.6e1 * t254 * t1375 * t109 * t586 + 0.9e1 * t73 * t197 * t95 * t122 * t108 * t168 - 0.9e1 / 0.2e1 * t73 * t775 * t186 + 0.2e1 / 0.3e1 * t277 * t220 * t224 + 0.4e1 * t597 * t212
  t2200 = t669 * t72 * t201 / 0.3e1 - 0.5e1 / 0.6e1 * t1487 * t1488 * t1756 + 0.5e1 / 0.6e1 * t1480 * t1494 * t144 - t597 * t216 - 0.18e2 * t73 * t1398 * t151 * t109 * t168 + 0.14e2 * t73 * t769 * t128 - 0.3e1 * t27 * t132 * t252 * t123 * t1756 + 0.3e1 / 0.2e1 * t27 * t132 * t402 * t95 * t145 + 0.2e1 * t1533 * t440 - 0.2e1 * t984 * t505 - 0.2e1 * t499 * t500 * t488 - 0.38e2 / 0.9e1 * t1029 * t1037 * t677 + 0.28e2 / 0.3e1 * t499 * t500 * t622 * t259 - 0.5e1 / 0.27e2 * t984 * t678 + 0.5e1 / 0.3e1 * t974 * t978 * t677 + 0.6e1 * t360 * t541 - t544 * t475 / 0.3e1 - t547 * t485 / 0.3e1 - t282 * t489 / 0.3e1 + t1018 * t286
  t2218 = t27 * t63 * t1040
  t2261 = t277 * t561
  t2267 = 0.4e1 / 0.3e1 * t555 * t212 - 0.4e1 / 0.3e1 * t317 * t136 * t145 + t651 * t149 * t145 / 0.2e1 - 0.3e1 / 0.2e1 * t651 * t72 * t201 - t261 * t216 - 0.3e1 / 0.4e1 * t73 * t194 * t215 - t73 * t121 * t139 * t108 * t1741 / 0.4e1 + 0.2e1 * t254 * t600 * t248 - 0.4e1 * t254 * t255 * t247 * t604 + 0.2e1 * t2261 * t610 + t659 * t149 * t145 / 0.3e1
  t2278 = t247 * t222
  t2329 = t558 * t249 + t150 * t140 * t62 * t355 * t143 / 0.2e1 + 0.2e1 / 0.3e1 * t229 * t249 - t235 * t153 * t2278 + 0.2e1 * t562 * t96 * t106 * t152 * t206 - 0.2e1 * t73 * t96 * t106 * t109 * t206 - 0.8e1 * t1533 * t519 - 0.2e1 / 0.3e1 * t673 * t424 - 0.4e1 * t290 * t529 - 0.2e1 / 0.3e1 * t1114 * t429 + 0.36e2 * t368 * t401 * t956 * t977 * t410 + 0.2e1 * t290 * t419 - 0.18e2 * t368 * t415 * t956 * t977 * t417 + 0.3e1 * t319 * t362 + 0.4e1 * t427 * t306 + t27 * t63 * t788 * t322 + t443 * t362 - 0.8e1 * t434 * t438 * t305 - 0.3e1 / 0.2e1 * t368 * t320 * t1008 * t174 - 0.6e1 * t1186 * t1187 * t428
  t2376 = t114 * t1036
  t2391 = -0.2e1 * t597 * t271 + 0.4e1 * t317 * t1441 * t1765 - 0.2e1 * t2261 * t567 - 0.2e1 * t235 * t203 * t2278 - 0.2e1 / 0.3e1 * t1324 * t590 + 0.4e1 / 0.3e1 * t1324 * t595 - t555 * t216 / 0.3e1 + t278 * t209 / 0.9e1 + t150 * t2376 * t108 * t141 * t142 * t1916 / 0.2e1 - 0.3e1 * t73 * t198 * t580 - 0.3e1 / 0.2e1 * t73 * t121 * t2376 * t108 * t1916
  t2397 = f.my_piecewise3(t1, 0, t1381 + t1079 + t2140 + t1791 + t2329 + 0.3e1 * t651 * t318 * t322 + 0.3e1 * t317 * t356 * t322 - t277 * t397 * t394 / 0.9e1 + t1552 - t27 * t63 * (-0.3e1 * t684 * t336 - 0.4e1 / 0.3e1 * t1805 * t751 + 0.12e2 * t1808 * t180 * t1809 - 0.28e2 / 0.3e1 * t692 * t755 + 0.36e2 * t1815 * t117 * t1809 - 0.18e2 * t696 * t336 - 0.2e1 / 0.3e1 * t1821 * t512 * t1809 - 0.12e2 * t1826 * t1827 * t778 - 0.36e2 * t1832 * t353 + 0.12e2 * t1835 * t436 * t243 + t1874 + t1911 + t1946 + t1992 + t2022 + t2055 + t2083) * t142 / 0.4e1 - 0.10e2 / 0.27e2 * t315 * t837 * t26 * t798 + 0.3e1 * t1480 * t1286 * t152 * t144 - 0.6e1 * t499 * t500 * t502 * t1157 + 0.9e1 * t73 * t1280 * t764 * t565 - 0.9e1 * t73 * t763 * t1286 * t608 - 0.3e1 / 0.2e1 * t27 * t63 * t1201 * t201 + 0.2e1 * t1313 * t123 * t247 * t1314 - 0.2e1 / 0.3e1 * t150 * t584 * t247 * t585 + t2267 + 0.11e2 / 0.3e1 * t254 * t1461 * t141 * t70 * t578 - 0.9e1 * t1487 * t1488 * t141 * t292 * t168 + 0.9e1 * t1480 * t1494 * t141 * t292 * t126 + 0.9e1 * t2218 * t1280 * t764 * t501 * t168 - 0.9e1 * t2218 * t763 * t1286 * t501 * t126 + 0.4e1 * t1442 * t153 * t247 * t1489 + t1206 + t2391 + t1145 + t1660 + t1007 + t2200 - 0.7e1 / 0.3e1 * t1762 * t256 - 0.10e2 / 0.27e2 * t839 * t801 + 0.2e1 / 0.3e1 * t1308 * t601 - 0.4e1 / 0.3e1 * t1308 * t606 - 0.6e1 * t261 * t129 - 0.2e1 * t555 * t268 - 0.2e1 / 0.3e1 * t555 * t271 - 0.2e1 / 0.3e1 * t558 * t587 - t229 * t587 / 0.2e1 + t1292 - 0.6e1 * t597 * t129 + 0.6e1 * t1388 * t610 - 0.6e1 * t597 * t268 + 0.3e1 / 0.2e1 * t357 * t362 - 0.4e1 / 0.3e1 * t137 * t249 - t1324 * t236 / 0.3e1 + t278 * t249 / 0.3e1 - 0.8e1 / 0.3e1 * t1148 * t519 + 0.2e1 * t1384 * t601 + t669 * t793 / 0.3e1 + t1308 * t256 / 0.3e1 + t1384 * t256 - t317 * t790 + 0.6e1 * t365 * t541 + 0.4e1 / 0.3e1 * t1148 * t517 + 0.2e1 / 0.3e1 * t673 * t447 + 0.6e1 * t360 * t514 + 0.2e1 * t290 * t541 + 0.4e1 * t290 * t524 - t137 * t209 / 0.2e1 + t1456 - t277 * t260 * t201 + 0.3e1 * t1755 * t153 * t1756 + 0.12e2 * t1186 * t1187 * t285 + 0.14e2 * t1487 * t1725 * t1490 - 0.14e2 * t1480 * t1481 * t605 - 0.11e2 / 0.3e1 * t1487 * t1725 * t1756 - 0.3e1 * t1487 * t1730 * t1756 - 0.3e1 * t317 * t260 * t201 + 0.2e1 / 0.9e1 * t277 * t228 * t145 - 0.11e2 / 0.12e2 * t254 * t1461 * t586 + 0.11e2 / 0.3e1 * t1480 * t1481 * t144 + 0.23e2 / 0.6e1 * t1487 * t1488 * t1490 - 0.23e2 / 0.6e1 * t1480 * t1494 * t605 + t1603)
  t2398 = t850 ** 2
  t2401 = t858 ** 2
  t2407 = t865 ** 2
  t2413 = f.my_piecewise5(t10, 0, t6, 0, -t1520)
  t2417 = f.my_piecewise3(t851, 0, 0.40e2 / 0.81e2 / t853 / t2398 * t2401 - 0.16e2 / 0.9e1 * t855 * t858 * t865 + 0.4e1 / 0.3e1 * t862 * t2407 + 0.16e2 / 0.9e1 * t863 * t869 + 0.4e1 / 0.3e1 * t852 * t2413)
  t2439 = f.my_piecewise3(t848, 0, -t2417 * t22 * t26 * t911 / 0.4e1 - t873 * t275 * t26 * t911 / 0.3e1 + t919 * t667 * t26 * t911 / 0.3e1 - 0.10e2 / 0.27e2 * t926 * t837 * t26 * t911 + 0.20e2 / 0.81e2 * t932 * t949 * t26 * t911)
  d1111 = 0.4e1 * t846 + 0.4e1 * t938 + t2 * (t2397 + t2439)

  res = {'v4rho4': d1111}
  return res
