"""Generated from mgga_x_mcml.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.067841267592822, -0.158722422825204, -0.2372737447003859, 0.002558752743285125, 0.006748483298726394, 0.001199436228162263, 0.001552846614645878, 0.000584892206996479], dtype=np.float64), np.array([np.nan, 0.2032399091383024, 0.1179363564823021, -0.01437960658302686, -0.01030571429426108, 0.01683215086686233, -0.000257733338272708, 0.002334616776649133, 0.0003837976998664341], dtype=np.float64), np.array([np.nan, -0.0006952718706718514, 0.00179463855686441, -0.001153807045825489, -0.0007090296813211244, 0.000137028863545747, 0.006670848599065867, -0.005498112922165805, 0.001421391023843761], dtype=np.float64), np.array([np.nan, -0.002565692477269114, 0.002125332357775206, -0.0009641371299507833, 0.003712786171321043, 0.001282471852770764, 0.0002262886186270548, -0.006510071882485726, 0.01243327883803539], dtype=np.float64), np.array([np.nan, -0.002170152177993684, 0.002915285520983635, -0.001863882881010248, -0.002494950550547465, 0.0004187827907710905, -0.001009981263546227, 0.0004230264400260503, 0.00245752591853626], dtype=np.float64), np.array([np.nan, -0.002723387704355568, 0.002007295399058147, -0.001189668304951413, 0.0001672905908063297, -0.0002721968500889238, -0.0005869916483960576, 0.001136485825094485, 0.001522474179598972], dtype=np.float64), np.array([np.nan, -0.00197760721561336, 0.001491587478361034, -0.001288306127279617, -0.0006058496834176058, 0.0002776060240069905, -0.001622621390953226, 0.0004260858412001439, -0.0003682519432462936], dtype=np.float64), np.array([np.nan, -0.002516160322803815, 0.001940164714223896, -0.001175614476758423, 0.0004312411759243052, 3.212943141118693e-06, -0.0002202759704065197, 0.0003807158595350892, -0.0003695503801501715], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.067841267592822, -0.158722422825204, -0.2372737447003859, 0.002558752743285125, 0.006748483298726394, 0.001199436228162263, 0.001552846614645878, 0.000584892206996479], dtype=np.float64), np.array([np.nan, 0.2032399091383024, 0.1179363564823021, -0.01437960658302686, -0.01030571429426108, 0.01683215086686233, -0.000257733338272708, 0.002334616776649133, 0.0003837976998664341], dtype=np.float64), np.array([np.nan, -0.0006952718706718514, 0.00179463855686441, -0.001153807045825489, -0.0007090296813211244, 0.000137028863545747, 0.006670848599065867, -0.005498112922165805, 0.001421391023843761], dtype=np.float64), np.array([np.nan, -0.002565692477269114, 0.002125332357775206, -0.0009641371299507833, 0.003712786171321043, 0.001282471852770764, 0.0002262886186270548, -0.006510071882485726, 0.01243327883803539], dtype=np.float64), np.array([np.nan, -0.002170152177993684, 0.002915285520983635, -0.001863882881010248, -0.002494950550547465, 0.0004187827907710905, -0.001009981263546227, 0.0004230264400260503, 0.00245752591853626], dtype=np.float64), np.array([np.nan, -0.002723387704355568, 0.002007295399058147, -0.001189668304951413, 0.0001672905908063297, -0.0002721968500889238, -0.0005869916483960576, 0.001136485825094485, 0.001522474179598972], dtype=np.float64), np.array([np.nan, -0.00197760721561336, 0.001491587478361034, -0.001288306127279617, -0.0006058496834176058, 0.0002776060240069905, -0.001622621390953226, 0.0004260858412001439, -0.0003682519432462936], dtype=np.float64), np.array([np.nan, -0.002516160322803815, 0.001940164714223896, -0.001175614476758423, 0.0004312411759243052, 3.212943141118693e-06, -0.0002202759704065197, 0.0003807158595350892, -0.0003695503801501715], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.067841267592822, -0.158722422825204, -0.2372737447003859, 0.002558752743285125, 0.006748483298726394, 0.001199436228162263, 0.001552846614645878, 0.000584892206996479], dtype=np.float64), np.array([np.nan, 0.2032399091383024, 0.1179363564823021, -0.01437960658302686, -0.01030571429426108, 0.01683215086686233, -0.000257733338272708, 0.002334616776649133, 0.0003837976998664341], dtype=np.float64), np.array([np.nan, -0.0006952718706718514, 0.00179463855686441, -0.001153807045825489, -0.0007090296813211244, 0.000137028863545747, 0.006670848599065867, -0.005498112922165805, 0.001421391023843761], dtype=np.float64), np.array([np.nan, -0.002565692477269114, 0.002125332357775206, -0.0009641371299507833, 0.003712786171321043, 0.001282471852770764, 0.0002262886186270548, -0.006510071882485726, 0.01243327883803539], dtype=np.float64), np.array([np.nan, -0.002170152177993684, 0.002915285520983635, -0.001863882881010248, -0.002494950550547465, 0.0004187827907710905, -0.001009981263546227, 0.0004230264400260503, 0.00245752591853626], dtype=np.float64), np.array([np.nan, -0.002723387704355568, 0.002007295399058147, -0.001189668304951413, 0.0001672905908063297, -0.0002721968500889238, -0.0005869916483960576, 0.001136485825094485, 0.001522474179598972], dtype=np.float64), np.array([np.nan, -0.00197760721561336, 0.001491587478361034, -0.001288306127279617, -0.0006058496834176058, 0.0002776060240069905, -0.001622621390953226, 0.0004260858412001439, -0.0003682519432462936], dtype=np.float64), np.array([np.nan, -0.002516160322803815, 0.001940164714223896, -0.001175614476758423, 0.0004312411759243052, 3.212943141118693e-06, -0.0002202759704065197, 0.0003807158595350892, -0.0003695503801501715], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = r0 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.1e1 / t29 / r0
  t33 = r0 ** 2
  t35 = 0.1e1 / t29 / t33
  t36 = s0 * t35
  t39 = 6 ** (0.1e1 / 0.3e1)
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t46 = 0.5e1 / 0.9e1 * (tau0 * t31 - t36 / 0.8e1) * t39 * t44
  t47 = 0.1e5 <= t46
  t48 = 0.1e5 < t46
  t49 = f.my_piecewise3(t48, t46, 0.1e5)
  t50 = t49 ** 2
  t54 = 0.1e1 / t50 / t49
  t56 = t50 ** 2
  t57 = 0.1e1 / t56
  t60 = f.my_piecewise3(t48, 0.1e5, t46)
  t61 = t60 ** 2
  t62 = 0.1e1 - t61
  t63 = t62 ** 2
  t64 = t63 * t62
  t65 = t61 * t60
  t67 = 0.1e1 + 0.4e1 * t65
  t69 = t65 * t67 + 0.1e1
  t70 = 0.1e1 / t69
  t72 = f.my_piecewise3(t47, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t50 + t54 / 0.16e2 - 0.3e1 / 0.4e1 * t57, t64 * t70)
  t73 = t72 ** 2
  t74 = t73 * t72
  t75 = t73 ** 2
  t76 = t75 * t74
  t78 = t39 * t44
  t81 = 0.65124e1 + t78 * t36 / 0.24e2
  t82 = 0.1e1 / t81
  t84 = t78 * t36 * t82
  t86 = t84 / 0.12e2 - 0.1e1
  t87 = t86 ** 2
  t88 = t87 ** 2
  t89 = t88 * t87
  t92 = t87 * t86
  t93 = t88 * t92
  t95 = t88 * t86
  t99 = 0.98280297068585083333333333333333333333333333333333e-2 * t84 - 0.1179363564823021e0
  t102 = 0.14955321307203416666666666666666666666666666666667e-3 * t84 - 0.1794638556864410e-2
  t104 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t73
  t107 = 0.17711102981460050000000000000000000000000000000000e-3 * t84 - 0.2125332357775206e-2
  t110 = 0.5e1 / 0.2e1 * t74 - 0.3e1 / 0.2e1 * t72
  t114 = -0.17725742033028110000000000000000000000000000000000e-2 * t92 + 0.88628710165140550000000000000000000000000000000000e-4 * t84 - 0.10635445219816866000000000000000000000000000000000e-2
  t118 = -0.25764285735652700000000000000000000000000000000000e-1 * t92 + 0.12882142867826350000000000000000000000000000000000e-2 * t84 - 0.15458571441391620000000000000000000000000000000000e-1
  t121 = 0.58780723837921150000000000000000000000000000000000e-3 - 0.17634217151376345000000000000000000000000000000000e-2 * t87
  t123 = t75 * t72
  t127 = 0.429e3 / 0.16e2 * t76 - 0.693e3 / 0.16e2 * t123 + 0.315e3 / 0.16e2 * t74 - 0.35e2 / 0.16e2 * t72
  t130 = 0.64415306363980850000000000000000000000000000000000e-3 - 0.19324591909194255000000000000000000000000000000000e-2 * t87
  t131 = t75 * t73
  t135 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t131 - 0.315e3 / 0.16e2 * t75 + 0.105e3 / 0.16e2 * t73
  t138 = 0.59483415247570650000000000000000000000000000000000e-3 - 0.17845024574271195000000000000000000000000000000000e-2 * t87
  t142 = 0.63e2 / 0.8e1 * t123 - 0.35e2 / 0.4e1 * t74 + 0.15e2 / 0.8e1 * t72
  t145 = 0.93194144050512400000000000000000000000000000000000e-3 - 0.27958243215153720000000000000000000000000000000000e-2 * t87
  t148 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t75 - 0.15e2 / 0.4e1 * t73
  t151 = 0.48206856497539165000000000000000000000000000000000e-3 - 0.14462056949261749500000000000000000000000000000000e-2 * t87
  t153 = -0.67464548655177289687500000000000000000000000000000e-1 * t76 + 0.22419222998949863625000000000000000000000000000000e-1 * t89 - 0.1047053293912749375000000000000000000000000000000e-2 * t88 + 0.15682422300093093187500000000000000000000000000000e-1 * t93 - 0.15887583418757175562500000000000000000000000000000e-1 * t95 + 0.74168801870361915625000000000000000000000000000000e-2 * t92 + t99 * t72 + t102 * t104 + t107 * t110 + t114 * t104 + t118 * t72 + t121 * t127 + t130 * t135 + t138 * t142 + t145 * t148 + t151 * t110
  t155 = 0.57690352291274450000000000000000000000000000000000e-3 - 0.17307105687382335000000000000000000000000000000000e-2 * t87
  t158 = 0.71898032915134300000000000000000000000000000000000e-2 - 0.21569409874540290000000000000000000000000000000000e-1 * t87
  t161 = 0.16168039285199133333333333333333333333333333333333e-3 * t84 - 0.1940164714223896e-2
  t164 = 0.12429895653008616666666666666666666666666666666667e-3 * t84 - 0.1491587478361034e-2
  t167 = 0.16727461658817891666666666666666666666666666666667e-3 * t84 - 0.2007295399058147e-2
  t170 = 0.24294046008196958333333333333333333333333333333333e-3 * t84 - 0.2915285520983635e-2
  t174 = 0.10410225900262143750000000000000000000000000000000e-3 + 0.12145263550305834375000000000000000000000000000000e-2 * t88 - 0.10410225900262143750000000000000000000000000000000e-2 * t87
  t178 = -0.10207381878334642500000000000000000000000000000000e-3 - 0.11908612191390416250000000000000000000000000000000e-2 * t88 + 0.10207381878334642500000000000000000000000000000000e-2 * t87
  t182 = 0.15704354653915893750000000000000000000000000000000e-3 + 0.18321747096235209375000000000000000000000000000000e-2 * t88 - 0.15704354653915893750000000000000000000000000000000e-2 * t87
  t186 = 0.48092694478903650000000000000000000000000000000000e-3 + 0.56108143558720925000000000000000000000000000000000e-2 * t88 - 0.48092694478903650000000000000000000000000000000000e-2 * t87
  t190 = 0.51385823829655125000000000000000000000000000000000e-4 + 0.59950127801264312500000000000000000000000000000000e-3 * t88 - 0.51385823829655125000000000000000000000000000000000e-3 * t87
  t194 = 0.63120565750733737500000000000000000000000000000000e-2 + 0.73640660042522693750000000000000000000000000000000e-1 * t88 - 0.63120565750733737500000000000000000000000000000000e-1 * t87
  t198 = 0.10781029398107630000000000000000000000000000000000e-2 * t92 - 0.53905146990538150000000000000000000000000000000000e-4 * t84 + 0.64686176388645780000000000000000000000000000000000e-3
  t202 = -0.15146242085440145000000000000000000000000000000000e-2 * t92 + 0.75731210427200725000000000000000000000000000000000e-4 * t84 - 0.90877452512640870000000000000000000000000000000000e-3
  t206 = 0.41822647701582425000000000000000000000000000000000e-3 * t92 - 0.20911323850791212500000000000000000000000000000000e-4 * t84 + 0.25093588620949455000000000000000000000000000000000e-3
  t210 = -0.62373763763686625000000000000000000000000000000000e-2 * t92 + 0.31186881881843312500000000000000000000000000000000e-3 * t84 - 0.37424258258211975000000000000000000000000000000000e-2
  t212 = t155 * t104 + t190 * t104 + t186 * t110 + t161 * t127 + t198 * t127 + t164 * t135 + t174 * t135 + t202 * t135 + t167 * t142 + t178 * t142 + t206 * t142 + t170 * t148 + t182 * t148 + t210 * t148 + t158 * t72 + t194 * t72
  t216 = 0.92819654283026075000000000000000000000000000000000e-2 * t92 - 0.46409827141513037500000000000000000000000000000000e-3 * t84 + 0.55691792569815645000000000000000000000000000000000e-2
  t221 = -0.72956774270285406250000000000000000000000000000000e-3 + 0.33706029712871857687500000000000000000000000000000e-1 * t89 - 0.45962767790279805937500000000000000000000000000000e-1 * t88 + 0.15320922596759935312500000000000000000000000000000e-1 * t87
  t226 = -0.17346732669513426375000000000000000000000000000000e-2 * t95 + 0.19274147410570473750000000000000000000000000000000e-2 * t92 - 0.34418120376018703125000000000000000000000000000000e-4 * t84 + 0.41301744451222443750000000000000000000000000000000e-3
  t231 = -0.12778143453756654750000000000000000000000000000000e-1 * t95 + 0.14197937170840727500000000000000000000000000000000e-1 * t92 - 0.25353459233644156250000000000000000000000000000000e-3 * t84 + 0.30424151080372987500000000000000000000000000000000e-2
  t236 = -0.46225592311189536000000000000000000000000000000000e-2 * t95 + 0.51361769234655040000000000000000000000000000000000e-2 * t92 - 0.91717445061884000000000000000000000000000000000000e-4 * t84 + 0.11006093407426080000000000000000000000000000000000e-2
  t241 = -0.79536024504265376250000000000000000000000000000000e-2 * t95 + 0.88373360560294862500000000000000000000000000000000e-2 * t92 - 0.15780957242909796875000000000000000000000000000000e-3 * t84 + 0.18937148691491756250000000000000000000000000000000e-2
  t246 = 0.17820228716880565500000000000000000000000000000000e-2 * t95 - 0.19800254129867295000000000000000000000000000000000e-2 * t92 + 0.35357596660477312500000000000000000000000000000000e-4 * t84 - 0.42429115992572775000000000000000000000000000000000e-3
  t251 = 0.52532932717643702625000000000000000000000000000000e-1 * t95 - 0.58369925241826336250000000000000000000000000000000e-1 * t92 + 0.10423200936040417187500000000000000000000000000000e-2 * t84 - 0.12507841123248500625000000000000000000000000000000e-1
  t256 = -0.20296500388975755000000000000000000000000000000000e-2 * t95 + 0.22551667098861950000000000000000000000000000000000e-2 * t92 - 0.40270834105110625000000000000000000000000000000000e-4 * t84 + 0.48325000926132750000000000000000000000000000000000e-3
  t260 = 0.12048536779195098750000000000000000000000000000000e-5 + 0.14056626242394281875000000000000000000000000000000e-4 * t88 - 0.12048536779195098750000000000000000000000000000000e-4 * t87
  t266 = 0.10290575827668764306250000000000000000000000000000e-1 * t93 - 0.16623237875464926956250000000000000000000000000000e-1 * t95 + 0.75560172161204213437500000000000000000000000000000e-2 * t92 - 0.69963122371485382812500000000000000000000000000000e-4 * t84 + 0.83955746845782459375000000000000000000000000000000e-3
  t271 = -0.11897370610471537500000000000000000000000000000000e-3 + 0.54965852220378503250000000000000000000000000000000e-2 * t89 - 0.74953434845970686250000000000000000000000000000000e-2 * t88 + 0.24984478281990228750000000000000000000000000000000e-2 * t87
  t276 = -0.13315182537504496875000000000000000000000000000000e-3 + 0.61516143323270775562500000000000000000000000000000e-2 * t89 - 0.83885649986278330312500000000000000000000000000000e-2 * t88 + 0.27961883328759443437500000000000000000000000000000e-2 * t87
  t281 = -0.35515182034202656250000000000000000000000000000000e-3 + 0.16408014099801627187500000000000000000000000000000e-1 * t89 - 0.22374564681547673437500000000000000000000000000000e-1 * t88 + 0.74581882271825578125000000000000000000000000000000e-2 * t87
  t286 = -0.13219576250814071875000000000000000000000000000000e-3 + 0.61074442278761012062500000000000000000000000000000e-2 * t89 - 0.83283330380128652812500000000000000000000000000000e-2 * t88 + 0.27761110126709550937500000000000000000000000000000e-2 * t87
  t291 = 0.20343974632767893750000000000000000000000000000000e-2 - 0.93989162803387669125000000000000000000000000000000e-1 * t89 + 0.12816704018643773062500000000000000000000000000000e0 * t88 - 0.42722346728812576875000000000000000000000000000000e-1 * t87
  t293 = t251 * t104 + t216 * t110 + t246 * t110 + t291 * t110 + t226 * t127 + t260 * t127 + t271 * t127 + t231 * t135 + t276 * t135 + t236 * t142 + t281 * t142 + t241 * t148 + t286 * t148 + t221 * t72 + t256 * t72 + t266 * t72
  t297 = 0.17181602881768140625000000000000000000000000000000e-2 - 0.79379005313768809687500000000000000000000000000000e-1 * t89 + 0.10824409815513928593750000000000000000000000000000e0 * t88 - 0.36081366051713095312500000000000000000000000000000e-1 * t87
  t303 = -0.99085695677764733437500000000000000000000000000000e-2 * t93 + 0.16006150840254303093750000000000000000000000000000e-1 * t95 - 0.72755231092065014062500000000000000000000000000000e-2 * t92 + 0.67365954714875013020833333333333333333333333333333e-4 * t84 - 0.80839145657850015625000000000000000000000000000000e-3
  t309 = -0.98737552282912471500000000000000000000000000000000e-2 * t93 + 0.15949912291855091550000000000000000000000000000000e-1 * t95 - 0.72499601326614052500000000000000000000000000000000e-2 * t92 + 0.67129260487605604166666666666666666666666666666667e-4 * t84 - 0.80555112585126725000000000000000000000000000000000e-3
  t315 = 0.40821338940497436750000000000000000000000000000000e-1 * t93 - 0.65942162903880474750000000000000000000000000000000e-1 * t95 + 0.29973710410854761250000000000000000000000000000000e-1 * t92 - 0.27753435565606260416666666666666666666666666666667e-3 * t84 + 0.33304122678727512500000000000000000000000000000000e-2
  t321 = 0.65892413690753471250000000000000000000000000000000e-1 * t93 - 0.10644159134660176125000000000000000000000000000000e0 * t95 + 0.48382541521182618750000000000000000000000000000000e-1 * t92 - 0.44798649556650572916666666666666666666666666666667e-3 * t84 + 0.53758379467980687500000000000000000000000000000000e-2
  t327 = 0.33336728884482389437500000000000000000000000000000e0 * t93 - 0.53851638967240782937500000000000000000000000000000e0 * t95 + 0.24478017712382174062500000000000000000000000000000e0 * t92 - 0.22664831215168679687500000000000000000000000000000e-2 * t84 + 0.27197797458202415625000000000000000000000000000000e-1
  t333 = 0.38111046826810841812500000000000000000000000000000e-1 * t93 - 0.61563998720232898312500000000000000000000000000000e-1 * t95 + 0.27983635781924044687500000000000000000000000000000e-1 * t92 - 0.25910773872151893229166666666666666666666666666667e-3 * t84 + 0.31092928646582271875000000000000000000000000000000e-2
  t343 = 0.13502664484515602222625000000000000000000000000000e1 + t297 * t104 + t303 * t127 + t309 * t135 + t315 * t142 + t321 * t148 + t327 * t110 + t333 * t104 - 0.28551704175417885000000000000000000000000000000000e-1 * t131 + 0.29439726278665657500000000000000000000000000000000e-1 * t75 - 0.58828844909941371000000000000000000000000000000000e-2 * t73 + 0.20748619661467272631250000000000000000000000000000e0 * t72 + 0.87534515809640139187500000000000000000000000000000e-1 * t123 - 0.32121495135261672812500000000000000000000000000000e-1 * t74 - 0.37102687351218925312500000000000000000000000000000e0 * t87 - 0.13465921726261020182291666666666666666666666666667e-1 * t84
  t345 = t153 + t212 + t293 + t343
  t349 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t345)
  t350 = r1 <= f.p.dens_threshold
  t351 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t352 = 0.1e1 + t351
  t353 = t352 <= f.p.zeta_threshold
  t354 = t352 ** (0.1e1 / 0.3e1)
  t356 = f.my_piecewise3(t353, t22, t354 * t352)
  t357 = t356 * t26
  t358 = r1 ** 2
  t359 = r1 ** (0.1e1 / 0.3e1)
  t360 = t359 ** 2
  t362 = 0.1e1 / t360 / t358
  t363 = s2 * t362
  t366 = 0.65124e1 + t78 * t363 / 0.24e2
  t367 = 0.1e1 / t366
  t369 = t78 * t363 * t367
  t371 = t369 / 0.12e2 - 0.1e1
  t372 = t371 ** 2
  t373 = t372 ** 2
  t374 = t373 * t372
  t378 = 0.71898032915134300000000000000000000000000000000000e-2 - 0.21569409874540290000000000000000000000000000000000e-1 * t372
  t380 = 0.1e1 / t360 / r1
  t386 = 0.5e1 / 0.9e1 * (tau1 * t380 - t363 / 0.8e1) * t39 * t44
  t387 = 0.1e5 <= t386
  t388 = 0.1e5 < t386
  t389 = f.my_piecewise3(t388, t386, 0.1e5)
  t390 = t389 ** 2
  t394 = 0.1e1 / t390 / t389
  t396 = t390 ** 2
  t397 = 0.1e1 / t396
  t400 = f.my_piecewise3(t388, 0.1e5, t386)
  t401 = t400 ** 2
  t402 = 0.1e1 - t401
  t403 = t402 ** 2
  t404 = t403 * t402
  t405 = t401 * t400
  t407 = 0.1e1 + 0.4e1 * t405
  t409 = t405 * t407 + 0.1e1
  t410 = 0.1e1 / t409
  t412 = f.my_piecewise3(t387, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t390 + t394 / 0.16e2 - 0.3e1 / 0.4e1 * t397, t404 * t410)
  t415 = 0.16168039285199133333333333333333333333333333333333e-3 * t369 - 0.1940164714223896e-2
  t416 = t412 ** 2
  t417 = t416 * t412
  t418 = t416 ** 2
  t419 = t418 * t417
  t421 = t418 * t412
  t425 = 0.429e3 / 0.16e2 * t419 - 0.693e3 / 0.16e2 * t421 + 0.315e3 / 0.16e2 * t417 - 0.35e2 / 0.16e2 * t412
  t428 = 0.12429895653008616666666666666666666666666666666667e-3 * t369 - 0.1491587478361034e-2
  t429 = t418 * t416
  t433 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t429 - 0.315e3 / 0.16e2 * t418 + 0.105e3 / 0.16e2 * t416
  t436 = 0.16727461658817891666666666666666666666666666666667e-3 * t369 - 0.2007295399058147e-2
  t440 = 0.63e2 / 0.8e1 * t421 - 0.35e2 / 0.4e1 * t417 + 0.15e2 / 0.8e1 * t412
  t443 = 0.24294046008196958333333333333333333333333333333333e-3 * t369 - 0.2915285520983635e-2
  t446 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t418 - 0.15e2 / 0.4e1 * t416
  t449 = 0.17711102981460050000000000000000000000000000000000e-3 * t369 - 0.2125332357775206e-2
  t452 = 0.5e1 / 0.2e1 * t417 - 0.3e1 / 0.2e1 * t412
  t455 = 0.14955321307203416666666666666666666666666666666667e-3 * t369 - 0.1794638556864410e-2
  t457 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t416
  t460 = 0.98280297068585083333333333333333333333333333333333e-2 * t369 - 0.1179363564823021e0
  t462 = t372 * t371
  t465 = -0.15146242085440145000000000000000000000000000000000e-2 * t462 + 0.75731210427200725000000000000000000000000000000000e-4 * t369 - 0.90877452512640870000000000000000000000000000000000e-3
  t469 = 0.41822647701582425000000000000000000000000000000000e-3 * t462 - 0.20911323850791212500000000000000000000000000000000e-4 * t369 + 0.25093588620949455000000000000000000000000000000000e-3
  t473 = -0.62373763763686625000000000000000000000000000000000e-2 * t462 + 0.31186881881843312500000000000000000000000000000000e-3 * t369 - 0.37424258258211975000000000000000000000000000000000e-2
  t477 = 0.92819654283026075000000000000000000000000000000000e-2 * t462 - 0.46409827141513037500000000000000000000000000000000e-3 * t369 + 0.55691792569815645000000000000000000000000000000000e-2
  t481 = -0.17725742033028110000000000000000000000000000000000e-2 * t462 + 0.88628710165140550000000000000000000000000000000000e-4 * t369 - 0.10635445219816866000000000000000000000000000000000e-2
  t485 = -0.25764285735652700000000000000000000000000000000000e-1 * t462 + 0.12882142867826350000000000000000000000000000000000e-2 * t369 - 0.15458571441391620000000000000000000000000000000000e-1
  t487 = 0.22419222998949863625000000000000000000000000000000e-1 * t374 - 0.1047053293912749375000000000000000000000000000000e-2 * t373 + t378 * t412 + t415 * t425 + t428 * t433 + t436 * t440 + t443 * t446 + t449 * t452 + t455 * t457 + t460 * t412 + t465 * t433 + t469 * t440 + t473 * t446 + t477 * t452 + t481 * t457 + t485 * t412
  t489 = 0.58780723837921150000000000000000000000000000000000e-3 - 0.17634217151376345000000000000000000000000000000000e-2 * t372
  t492 = 0.64415306363980850000000000000000000000000000000000e-3 - 0.19324591909194255000000000000000000000000000000000e-2 * t372
  t495 = 0.59483415247570650000000000000000000000000000000000e-3 - 0.17845024574271195000000000000000000000000000000000e-2 * t372
  t498 = 0.93194144050512400000000000000000000000000000000000e-3 - 0.27958243215153720000000000000000000000000000000000e-2 * t372
  t501 = 0.48206856497539165000000000000000000000000000000000e-3 - 0.14462056949261749500000000000000000000000000000000e-2 * t372
  t504 = 0.57690352291274450000000000000000000000000000000000e-3 - 0.17307105687382335000000000000000000000000000000000e-2 * t372
  t506 = t373 * t371
  t510 = 0.52532932717643702625000000000000000000000000000000e-1 * t506 - 0.58369925241826336250000000000000000000000000000000e-1 * t462 + 0.10423200936040417187500000000000000000000000000000e-2 * t369 - 0.12507841123248500625000000000000000000000000000000e-1
  t515 = -0.20296500388975755000000000000000000000000000000000e-2 * t506 + 0.22551667098861950000000000000000000000000000000000e-2 * t462 - 0.40270834105110625000000000000000000000000000000000e-4 * t369 + 0.48325000926132750000000000000000000000000000000000e-3
  t519 = 0.12048536779195098750000000000000000000000000000000e-5 + 0.14056626242394281875000000000000000000000000000000e-4 * t373 - 0.12048536779195098750000000000000000000000000000000e-4 * t372
  t523 = 0.10410225900262143750000000000000000000000000000000e-3 + 0.12145263550305834375000000000000000000000000000000e-2 * t373 - 0.10410225900262143750000000000000000000000000000000e-2 * t372
  t527 = -0.10207381878334642500000000000000000000000000000000e-3 - 0.11908612191390416250000000000000000000000000000000e-2 * t373 + 0.10207381878334642500000000000000000000000000000000e-2 * t372
  t531 = 0.15704354653915893750000000000000000000000000000000e-3 + 0.18321747096235209375000000000000000000000000000000e-2 * t373 - 0.15704354653915893750000000000000000000000000000000e-2 * t372
  t535 = 0.48092694478903650000000000000000000000000000000000e-3 + 0.56108143558720925000000000000000000000000000000000e-2 * t373 - 0.48092694478903650000000000000000000000000000000000e-2 * t372
  t539 = 0.51385823829655125000000000000000000000000000000000e-4 + 0.59950127801264312500000000000000000000000000000000e-3 * t373 - 0.51385823829655125000000000000000000000000000000000e-3 * t372
  t543 = 0.63120565750733737500000000000000000000000000000000e-2 + 0.73640660042522693750000000000000000000000000000000e-1 * t373 - 0.63120565750733737500000000000000000000000000000000e-1 * t372
  t547 = 0.10781029398107630000000000000000000000000000000000e-2 * t462 - 0.53905146990538150000000000000000000000000000000000e-4 * t369 + 0.64686176388645780000000000000000000000000000000000e-3
  t549 = t515 * t412 + t543 * t412 + t489 * t425 + t519 * t425 + t547 * t425 + t492 * t433 + t523 * t433 + t495 * t440 + t527 * t440 + t498 * t446 + t531 * t446 + t501 * t452 + t535 * t452 + t504 * t457 + t510 * t457 + t539 * t457
  t554 = -0.13219576250814071875000000000000000000000000000000e-3 + 0.61074442278761012062500000000000000000000000000000e-2 * t374 - 0.83283330380128652812500000000000000000000000000000e-2 * t373 + 0.27761110126709550937500000000000000000000000000000e-2 * t372
  t559 = 0.20343974632767893750000000000000000000000000000000e-2 - 0.93989162803387669125000000000000000000000000000000e-1 * t374 + 0.12816704018643773062500000000000000000000000000000e0 * t373 - 0.42722346728812576875000000000000000000000000000000e-1 * t372
  t564 = 0.17181602881768140625000000000000000000000000000000e-2 - 0.79379005313768809687500000000000000000000000000000e-1 * t374 + 0.10824409815513928593750000000000000000000000000000e0 * t373 - 0.36081366051713095312500000000000000000000000000000e-1 * t372
  t569 = -0.72956774270285406250000000000000000000000000000000e-3 + 0.33706029712871857687500000000000000000000000000000e-1 * t374 - 0.45962767790279805937500000000000000000000000000000e-1 * t373 + 0.15320922596759935312500000000000000000000000000000e-1 * t372
  t574 = -0.17346732669513426375000000000000000000000000000000e-2 * t506 + 0.19274147410570473750000000000000000000000000000000e-2 * t462 - 0.34418120376018703125000000000000000000000000000000e-4 * t369 + 0.41301744451222443750000000000000000000000000000000e-3
  t579 = -0.12778143453756654750000000000000000000000000000000e-1 * t506 + 0.14197937170840727500000000000000000000000000000000e-1 * t462 - 0.25353459233644156250000000000000000000000000000000e-3 * t369 + 0.30424151080372987500000000000000000000000000000000e-2
  t584 = -0.46225592311189536000000000000000000000000000000000e-2 * t506 + 0.51361769234655040000000000000000000000000000000000e-2 * t462 - 0.91717445061884000000000000000000000000000000000000e-4 * t369 + 0.11006093407426080000000000000000000000000000000000e-2
  t589 = -0.79536024504265376250000000000000000000000000000000e-2 * t506 + 0.88373360560294862500000000000000000000000000000000e-2 * t462 - 0.15780957242909796875000000000000000000000000000000e-3 * t369 + 0.18937148691491756250000000000000000000000000000000e-2
  t594 = 0.17820228716880565500000000000000000000000000000000e-2 * t506 - 0.19800254129867295000000000000000000000000000000000e-2 * t462 + 0.35357596660477312500000000000000000000000000000000e-4 * t369 - 0.42429115992572775000000000000000000000000000000000e-3
  t596 = t373 * t462
  t601 = 0.65892413690753471250000000000000000000000000000000e-1 * t596 - 0.10644159134660176125000000000000000000000000000000e0 * t506 + 0.48382541521182618750000000000000000000000000000000e-1 * t462 - 0.44798649556650572916666666666666666666666666666667e-3 * t369 + 0.53758379467980687500000000000000000000000000000000e-2
  t607 = 0.33336728884482389437500000000000000000000000000000e0 * t596 - 0.53851638967240782937500000000000000000000000000000e0 * t506 + 0.24478017712382174062500000000000000000000000000000e0 * t462 - 0.22664831215168679687500000000000000000000000000000e-2 * t369 + 0.27197797458202415625000000000000000000000000000000e-1
  t613 = 0.38111046826810841812500000000000000000000000000000e-1 * t596 - 0.61563998720232898312500000000000000000000000000000e-1 * t506 + 0.27983635781924044687500000000000000000000000000000e-1 * t462 - 0.25910773872151893229166666666666666666666666666667e-3 * t369 + 0.31092928646582271875000000000000000000000000000000e-2
  t619 = 0.10290575827668764306250000000000000000000000000000e-1 * t596 - 0.16623237875464926956250000000000000000000000000000e-1 * t506 + 0.75560172161204213437500000000000000000000000000000e-2 * t462 - 0.69963122371485382812500000000000000000000000000000e-4 * t369 + 0.83955746845782459375000000000000000000000000000000e-3
  t624 = -0.11897370610471537500000000000000000000000000000000e-3 + 0.54965852220378503250000000000000000000000000000000e-2 * t374 - 0.74953434845970686250000000000000000000000000000000e-2 * t373 + 0.24984478281990228750000000000000000000000000000000e-2 * t372
  t629 = -0.13315182537504496875000000000000000000000000000000e-3 + 0.61516143323270775562500000000000000000000000000000e-2 * t374 - 0.83885649986278330312500000000000000000000000000000e-2 * t373 + 0.27961883328759443437500000000000000000000000000000e-2 * t372
  t634 = -0.35515182034202656250000000000000000000000000000000e-3 + 0.16408014099801627187500000000000000000000000000000e-1 * t374 - 0.22374564681547673437500000000000000000000000000000e-1 * t373 + 0.74581882271825578125000000000000000000000000000000e-2 * t372
  t636 = t569 * t412 + t619 * t412 + t574 * t425 + t624 * t425 + t579 * t433 + t629 * t433 + t584 * t440 + t634 * t440 + t554 * t446 + t589 * t446 + t601 * t446 + t559 * t452 + t594 * t452 + t607 * t452 + t564 * t457 + t613 * t457
  t641 = -0.99085695677764733437500000000000000000000000000000e-2 * t596 + 0.16006150840254303093750000000000000000000000000000e-1 * t506 - 0.72755231092065014062500000000000000000000000000000e-2 * t462 + 0.67365954714875013020833333333333333333333333333333e-4 * t369 - 0.80839145657850015625000000000000000000000000000000e-3
  t647 = -0.98737552282912471500000000000000000000000000000000e-2 * t596 + 0.15949912291855091550000000000000000000000000000000e-1 * t506 - 0.72499601326614052500000000000000000000000000000000e-2 * t462 + 0.67129260487605604166666666666666666666666666666667e-4 * t369 - 0.80555112585126725000000000000000000000000000000000e-3
  t653 = 0.40821338940497436750000000000000000000000000000000e-1 * t596 - 0.65942162903880474750000000000000000000000000000000e-1 * t506 + 0.29973710410854761250000000000000000000000000000000e-1 * t462 - 0.27753435565606260416666666666666666666666666666667e-3 * t369 + 0.33304122678727512500000000000000000000000000000000e-2
  t667 = 0.13502664484515602222625000000000000000000000000000e1 + t641 * t425 + t647 * t433 + t653 * t440 - 0.28551704175417885000000000000000000000000000000000e-1 * t429 + 0.29439726278665657500000000000000000000000000000000e-1 * t418 - 0.58828844909941371000000000000000000000000000000000e-2 * t416 - 0.13465921726261020182291666666666666666666666666667e-1 * t369 + 0.15682422300093093187500000000000000000000000000000e-1 * t596 - 0.15887583418757175562500000000000000000000000000000e-1 * t506 + 0.74168801870361915625000000000000000000000000000000e-2 * t462 + 0.20748619661467272631250000000000000000000000000000e0 * t412 + 0.87534515809640139187500000000000000000000000000000e-1 * t421 - 0.32121495135261672812500000000000000000000000000000e-1 * t417 - 0.67464548655177289687500000000000000000000000000000e-1 * t419 - 0.37102687351218925312500000000000000000000000000000e0 * t372
  t669 = t487 + t549 + t636 + t667
  t673 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t357 * t669)
  t674 = t6 ** 2
  t676 = t16 / t674
  t677 = t7 - t676
  t678 = f.my_piecewise5(t10, 0, t14, 0, t677)
  t681 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t678)
  t686 = t26 ** 2
  t687 = 0.1e1 / t686
  t691 = t5 * t25 * t687 * t345 / 0.8e1
  t697 = s0 / t29 / t33 / r0
  t702 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t35 + t697 / 0.3e1) * t39 * t44
  t703 = f.my_piecewise3(t48, t702, 0)
  t709 = 0.1e1 / t56 / t49
  t713 = t63 * t70
  t714 = f.my_piecewise3(t48, 0, t702)
  t718 = t69 ** 2
  t720 = t64 / t718
  t721 = t61 * t67
  t724 = t61 ** 2
  t725 = t724 * t60
  t731 = f.my_piecewise3(t47, -0.3e1 / 0.2e1 * t54 * t703 - 0.3e1 / 0.16e2 * t57 * t703 + 0.3e1 * t709 * t703, -0.6e1 * t713 * t60 * t714 - t720 * (0.3e1 * t721 * t714 + 0.12e2 * t725 * t714))
  t732 = t131 * t731
  t734 = t75 * t731
  t736 = t73 * t731
  t739 = 0.3003e4 / 0.16e2 * t732 - 0.3465e4 / 0.16e2 * t734 + 0.945e3 / 0.16e2 * t736 - 0.35e2 / 0.16e2 * t731
  t742 = t78 * t697 * t82
  t744 = t39 ** 2
  t747 = t744 / t42 / t41
  t748 = s0 ** 2
  t749 = t33 ** 2
  t754 = t81 ** 2
  t755 = 0.1e1 / t754
  t757 = t747 * t748 / t28 / t749 / t33 * t755
  t759 = -0.2e1 / 0.9e1 * t742 + t757 / 0.108e3
  t760 = t89 * t759
  t762 = t88 * t759
  t764 = t87 * t759
  t773 = 0.315e3 / 0.8e1 * t734 - 0.105e3 / 0.4e1 * t736 + 0.15e2 / 0.8e1 * t731
  t782 = t123 * t731
  t784 = t74 * t731
  t786 = t72 * t731
  t788 = 0.693e3 / 0.8e1 * t782 - 0.315e3 / 0.4e1 * t784 + 0.105e3 / 0.8e1 * t786
  t797 = t95 * t759
  t799 = t92 * t759
  t801 = t86 * t759
  t814 = 0.35e2 / 0.2e1 * t784 - 0.15e2 / 0.2e1 * t786
  t825 = 0.15e2 / 0.2e1 * t736 - 0.3e1 / 0.2e1 * t731
  t840 = t303 * t739 + (0.28574937258348205725000000000000000000000000000000e0 * t760 - 0.32971081451940237375000000000000000000000000000000e0 * t762 + 0.89921131232564283750000000000000000000000000000000e-1 * t764 + 0.74009161508283361111111111111111111111111111111112e-3 * t742 - 0.30837150628451400462962962962962962962962962962963e-4 * t757) * t142 + t315 * t773 + (-0.69116286598038730050000000000000000000000000000000e-1 * t760 + 0.79749561459275457750000000000000000000000000000000e-1 * t762 - 0.21749880397984215750000000000000000000000000000000e-1 * t764 - 0.17901136130028161111111111111111111111111111111111e-3 * t742 + 0.74588067208450671296296296296296296296296296296297e-5 * t757) * t135 + t309 * t788 + (-0.69359986974435313406250000000000000000000000000000e-1 * t760 + 0.80030754201271515468750000000000000000000000000000e-1 * t762 - 0.21826569327619504218750000000000000000000000000000e-1 * t764 - 0.17964254590633336805555555555555555555555555555555e-3 * t742 + 0.74851060794305570023148148148148148148148148148148e-5 * t757) * t127 + (0.32979511332227101950000000000000000000000000000000e-1 * t797 - 0.29981373938388274500000000000000000000000000000000e-1 * t799 + 0.49968956563980457500000000000000000000000000000000e-2 * t801) * t127 + (0.46124689583527429875000000000000000000000000000000e0 * t760 - 0.53220795673300880625000000000000000000000000000000e0 * t762 + 0.14514762456354785625000000000000000000000000000000e0 * t764 + 0.11946306548440152777777777777777777777777777777778e-2 * t742 - 0.49776277285167303240740740740740740740740740740741e-4 * t757) * t148 + t321 * t814 + (0.23335710219137672606250000000000000000000000000000e1 * t760 - 0.26925819483620391468750000000000000000000000000000e1 * t762 + 0.73434053137146522187500000000000000000000000000000e0 * t764 + 0.60439549907116479166666666666666666666666666666667e-2 * t742 - 0.25183145794631866319444444444444444444444444444444e-3 * t757) * t110 + t327 * t825 + t271 * t739 + (0.36909685993962465337500000000000000000000000000000e-1 * t797 - 0.33554259994511332125000000000000000000000000000000e-1 * t799 + 0.55923766657518886875000000000000000000000000000000e-2 * t801) * t135 + (0.26677732778767589268750000000000000000000000000000e0 * t760 - 0.30781999360116449156250000000000000000000000000000e0 * t762 + 0.83950907345772134062500000000000000000000000000000e-1 * t764 + 0.69095396992405048611111111111111111111111111111112e-3 * t742 - 0.28789748746835436921296296296296296296296296296297e-4 * t757) * t104
  t882 = 0.10977695610065165231250000000000000000000000000000e0 * t760 + (0.72034030793681350143750000000000000000000000000000e-1 * t760 - 0.83116189377324634781250000000000000000000000000000e-1 * t762 + 0.22668051648361264031250000000000000000000000000000e-1 * t764 + 0.18656832632396102083333333333333333333333333333333e-3 * t742 - 0.77736802634983758680555555555555555555555555555556e-5 * t757) * t72 + t266 * t731 + t286 * t814 + (-0.56393497682032601475000000000000000000000000000000e0 * t797 + 0.51266816074575092250000000000000000000000000000000e0 * t799 - 0.85444693457625153750000000000000000000000000000000e-1 * t801) * t110 + t276 * t788 + (0.98448084598809763125000000000000000000000000000000e-1 * t797 - 0.89498258726190693750000000000000000000000000000000e-1 * t799 + 0.14916376454365115625000000000000000000000000000000e-1 * t801) * t142 + t281 * t773 + (-0.86733663347567131875000000000000000000000000000000e-2 * t762 + 0.57822442231711421250000000000000000000000000000000e-2 * t764 + 0.91781654336049875000000000000000000000000000000000e-4 * t742 - 0.38242355973354114583333333333333333333333333333333e-5 * t757) * t127 + t226 * t739 + t291 * t825 + (-0.47627403188261285812500000000000000000000000000000e0 * t797 + 0.43297639262055714375000000000000000000000000000000e0 * t799 - 0.72162732103426190625000000000000000000000000000000e-1 * t801) * t104 + 0.13451533799369918175000000000000000000000000000000e0 * t797 + (0.20223617827723114612500000000000000000000000000000e0 * t797 - 0.18385107116111922375000000000000000000000000000000e0 * t799 + 0.30641845193519870625000000000000000000000000000000e-1 * t801) * t72
  t925 = (0.36644665367256607237500000000000000000000000000000e-1 * t797 - 0.33313332152051461125000000000000000000000000000000e-1 * t799 + 0.55522220253419101875000000000000000000000000000000e-2 * t801) * t148 + t221 * t731 + t256 * t731 + (-0.39768012252132688125000000000000000000000000000000e-1 * t762 + 0.26512008168088458750000000000000000000000000000000e-1 * t764 + 0.42082552647759458333333333333333333333333333333333e-3 * t742 - 0.17534396936566440972222222222222222222222222222222e-4 * t757) * t148 + t241 * t814 + (-0.63890717268783273750000000000000000000000000000000e-1 * t762 + 0.42593811512522182500000000000000000000000000000000e-1 * t764 + 0.67609224623051083333333333333333333333333333333333e-3 * t742 - 0.28170510259604618055555555555555555555555555555556e-4 * t757) * t135 + t231 * t788 + (-0.23112796155594768000000000000000000000000000000000e-1 * t762 + 0.15408530770396512000000000000000000000000000000000e-1 * t764 + 0.24457985349835733333333333333333333333333333333333e-3 * t742 - 0.10190827229098222222222222222222222222222222222222e-4 * t757) * t142 + t236 * t773 + t178 * t773 + (0.56226504969577127500000000000000000000000000000000e-4 * t799 - 0.24097073558390197500000000000000000000000000000000e-4 * t801) * t127 + t260 * t739 + (0.89101143584402827500000000000000000000000000000000e-2 * t762 - 0.59400762389601885000000000000000000000000000000000e-2 * t764 - 0.94286924427939500000000000000000000000000000000000e-4 * t742 + 0.39286218511641458333333333333333333333333333333333e-5 * t757) * t110 - 0.79437917093785877812500000000000000000000000000000e-1 * t762
  t970 = t246 * t825 + (0.26266466358821851312500000000000000000000000000000e0 * t762 - 0.17510977572547900875000000000000000000000000000000e0 * t764 - 0.27795202496107779166666666666666666666666666666667e-2 * t742 + 0.11581334373378241319444444444444444444444444444444e-3 * t757) * t104 + (-0.10148250194487877500000000000000000000000000000000e-1 * t762 + 0.67655001296585850000000000000000000000000000000000e-2 * t764 + 0.10738889094696166666666666666666666666666666666667e-3 * t742 - 0.44745371227900694444444444444444444444444444444444e-5 * t757) * t72 + t194 * t731 + (0.73286988384940837500000000000000000000000000000000e-2 * t799 - 0.31408709307831787500000000000000000000000000000000e-2 * t801) * t148 + t182 * t814 + (0.22443257423488370000000000000000000000000000000000e-1 * t799 - 0.96185388957807300000000000000000000000000000000000e-2 * t801) * t110 + (0.48581054201223337500000000000000000000000000000000e-2 * t799 - 0.20820451800524287500000000000000000000000000000000e-2 * t801) * t135 + t174 * t788 + (-0.47634448765561665000000000000000000000000000000000e-2 * t799 + 0.20414763756669285000000000000000000000000000000000e-2 * t801) * t142 + (-0.45438726256320435000000000000000000000000000000000e-2 * t764 - 0.20194989447253526666666666666666666666666666666667e-3 * t742 + 0.84145789363556361111111111111111111111111111111111e-5 * t757) * t135 + t202 * t788 + (0.12546794310474727500000000000000000000000000000000e-2 * t764 + 0.55763530268776566666666666666666666666666666666667e-4 * t742 - 0.23234804278656902777777777777777777777777777777778e-5 * t757) * t142 + t206 * t773
  t1005 = (0.32343088194322890000000000000000000000000000000000e-2 * t764 + 0.14374705864143506666666666666666666666666666666667e-3 * t742 - 0.59894607767264611111111111111111111111111111111111e-5 * t757) * t127 + t198 * t739 + t186 * t825 + (0.23980051120505725000000000000000000000000000000000e-2 * t799 - 0.10277164765931025000000000000000000000000000000000e-2 * t801) * t104 - 0.4188213175650997500000000000000000000000000000000e-2 * t799 - 0.74205374702437850625000000000000000000000000000000e0 * t801 + (0.29456264017009077500000000000000000000000000000000e0 * t799 - 0.12624113150146747500000000000000000000000000000000e0 * t801) * t72 + t151 * t825 + t138 * t773 + t130 * t788 + (-0.53177226099084330000000000000000000000000000000000e-2 * t764 - 0.23634322710704146666666666666666666666666666666667e-3 * t742 + 0.98476344627933944444444444444444444444444444444444e-5 * t757) * t104 + 0.22250640561108574687500000000000000000000000000000e-1 * t764 + (-0.77292857206958100000000000000000000000000000000000e-1 * t764 - 0.34352380980870266666666666666666666666666666666667e-2 * t742 + 0.14313492075362611111111111111111111111111111111111e-3 * t757) * t72 + t118 * t731
  t1037 = t121 * t739 + (-0.18712129129105987500000000000000000000000000000000e-1 * t764 - 0.83165018351582166666666666666666666666666666666667e-3 * t742 + 0.34652090979825902777777777777777777777777777777778e-4 * t757) * t148 + t210 * t814 + (0.27845896284907822500000000000000000000000000000000e-1 * t764 + 0.12375953904403476666666666666666666666666666666667e-2 * t742 - 0.51566474601681152777777777777777777777777777777778e-4 * t757) * t110 + t216 * t825 - 0.96364485405785018437500000000000000000000000000000e-1 * t736 + (-0.26208079218289355555555555555555555555555555555555e-1 * t742 + 0.10920033007620564814814814814814814814814814814815e-2 * t757) * t72 + t99 * t731 + (-0.44606564423514377777777777777777777777777777777779e-3 * t742 + 0.18586068509797657407407407407407407407407407407408e-4 * t757) * t142 + t167 * t773 + 0.43767257904820069593750000000000000000000000000000e0 * t734 + (-0.64784122688525222222222222222222222222222222222221e-3 * t742 + 0.26993384453552175925925925925925925925925925925926e-4 * t757) * t148 + t170 * t814 + 0.11775890511466263000000000000000000000000000000000e0 * t784
  t1065 = -0.11765768981988274200000000000000000000000000000000e-1 * t786 + (-0.33146388408022977777777777777777777777777777777779e-3 * t742 + 0.13810995170009574074074074074074074074074074074074e-4 * t757) * t135 + t164 * t788 - 0.17131022505250731000000000000000000000000000000000e0 * t782 + t158 * t731 + (-0.43114771427197688888888888888888888888888888888888e-3 * t742 + 0.17964488094665703703703703703703703703703703703703e-4 * t757) * t127 + t161 * t739 - 0.47225184058624102781250000000000000000000000000000e0 * t732 + t145 * t814 + (-0.39880856819209111111111111111111111111111111111112e-3 * t742 + 0.16617023674670462962962962962962962962962962962963e-4 * t757) * t104 + (-0.47229607950560133333333333333333333333333333333333e-3 * t742 + 0.19679003312733388888888888888888888888888888888889e-4 * t757) * t110 + t107 * t825 + 0.35909124603362720486111111111111111111111111111112e-1 * t742 - 0.14962135251401133535879629629629629629629629629630e-2 * t757
  t1067 = t102 * t72
  t1074 = t155 * t72
  t1087 = t114 * t72
  t1090 = t190 * t72
  t1093 = t251 * t72
  t1096 = t297 * t72
  t1099 = t333 * t72
  t1102 = 0.20748619661467272631250000000000000000000000000000e0 * t731 + 0.3e1 * t1067 * t731 - 0.28924113898523499000000000000000000000000000000000e-2 * t801 * t110 - 0.34614211374764670000000000000000000000000000000000e-2 * t801 * t104 + 0.3e1 * t1074 * t731 - 0.43138819749080580000000000000000000000000000000000e-1 * t801 * t72 - 0.35268434302752690000000000000000000000000000000000e-2 * t801 * t127 - 0.38649183818388510000000000000000000000000000000000e-2 * t801 * t135 - 0.35690049148542390000000000000000000000000000000000e-2 * t801 * t142 - 0.55916486430307440000000000000000000000000000000000e-2 * t801 * t148 + 0.3e1 * t1087 * t731 + 0.3e1 * t1090 * t731 + 0.3e1 * t1093 * t731 + 0.3e1 * t1096 * t731 + 0.3e1 * t1099 * t731
  t1110 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t681 * t26 * t345 - t691 - 0.3e1 / 0.8e1 * t5 * t27 * (t840 + t882 + t925 + t970 + t1005 + t1037 + t1065 + t1102))
  t1112 = f.my_piecewise5(t14, 0, t10, 0, -t677)
  t1115 = f.my_piecewise3(t353, 0, 0.4e1 / 0.3e1 * t354 * t1112)
  t1123 = t5 * t356 * t687 * t669 / 0.8e1
  t1125 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t1115 * t26 * t669 - t1123)
  vrho_0_ = t349 + t673 + t6 * (t1110 + t1125)
  t1128 = -t7 - t676
  t1129 = f.my_piecewise5(t10, 0, t14, 0, t1128)
  t1132 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t1129)
  t1138 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1132 * t26 * t345 - t691)
  t1140 = f.my_piecewise5(t14, 0, t10, 0, -t1128)
  t1143 = f.my_piecewise3(t353, 0, 0.4e1 / 0.3e1 * t354 * t1140)
  t1151 = s2 / t360 / t358 / r1
  t1153 = t78 * t1151 * t367
  t1155 = s2 ** 2
  t1156 = t358 ** 2
  t1161 = t366 ** 2
  t1162 = 0.1e1 / t1161
  t1164 = t747 * t1155 / t359 / t1156 / t358 * t1162
  t1178 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau1 * t362 + t1151 / 0.3e1) * t39 * t44
  t1179 = f.my_piecewise3(t388, t1178, 0)
  t1185 = 0.1e1 / t396 / t389
  t1189 = t403 * t410
  t1190 = f.my_piecewise3(t388, 0, t1178)
  t1194 = t409 ** 2
  t1196 = t404 / t1194
  t1197 = t401 * t407
  t1200 = t401 ** 2
  t1201 = t1200 * t400
  t1207 = f.my_piecewise3(t387, -0.3e1 / 0.2e1 * t394 * t1179 - 0.3e1 / 0.16e2 * t397 * t1179 + 0.3e1 * t1185 * t1179, -0.6e1 * t1189 * t400 * t1190 - t1196 * (0.3e1 * t1197 * t1190 + 0.12e2 * t1201 * t1190))
  t1213 = t417 * t1207
  t1215 = t412 * t1207
  t1217 = 0.35e2 / 0.2e1 * t1213 - 0.15e2 / 0.2e1 * t1215
  t1225 = t416 * t1207
  t1228 = 0.15e2 / 0.2e1 * t1225 - 0.3e1 / 0.2e1 * t1207
  t1235 = t421 * t1207
  t1239 = 0.693e3 / 0.8e1 * t1235 - 0.315e3 / 0.4e1 * t1213 + 0.105e3 / 0.8e1 * t1215
  t1246 = (-0.39880856819209111111111111111111111111111111111112e-3 * t1153 + 0.16617023674670462962962962962962962962962962962963e-4 * t1164) * t457 + (-0.26208079218289355555555555555555555555555555555555e-1 * t1153 + 0.10920033007620564814814814814814814814814814814815e-2 * t1164) * t412 + t460 * t1207 + (-0.64784122688525222222222222222222222222222222222221e-3 * t1153 + 0.26993384453552175925925925925925925925925925925926e-4 * t1164) * t446 + t443 * t1217 + 0.11775890511466263000000000000000000000000000000000e0 * t1213 - 0.11765768981988274200000000000000000000000000000000e-1 * t1215 + (-0.47229607950560133333333333333333333333333333333333e-3 * t1153 + 0.19679003312733388888888888888888888888888888888889e-4 * t1164) * t452 + t449 * t1228 - 0.96364485405785018437500000000000000000000000000000e-1 * t1225 + (-0.33146388408022977777777777777777777777777777777779e-3 * t1153 + 0.13810995170009574074074074074074074074074074074074e-4 * t1164) * t433 + t428 * t1239 - 0.17131022505250731000000000000000000000000000000000e0 * t1235 + (-0.44606564423514377777777777777777777777777777777779e-3 * t1153 + 0.18586068509797657407407407407407407407407407407408e-4 * t1164) * t440
  t1247 = t418 * t1207
  t1251 = 0.315e3 / 0.8e1 * t1247 - 0.105e3 / 0.4e1 * t1225 + 0.15e2 / 0.8e1 * t1207
  t1258 = t429 * t1207
  t1263 = 0.3003e4 / 0.16e2 * t1258 - 0.3465e4 / 0.16e2 * t1247 + 0.945e3 / 0.16e2 * t1225 - 0.35e2 / 0.16e2 * t1207
  t1273 = -0.2e1 / 0.9e1 * t1153 + t1164 / 0.108e3
  t1274 = t372 * t1273
  t1283 = t436 * t1251 + 0.43767257904820069593750000000000000000000000000000e0 * t1247 + (-0.43114771427197688888888888888888888888888888888888e-3 * t1153 + 0.17964488094665703703703703703703703703703703703703e-4 * t1164) * t425 + t415 * t1263 - 0.47225184058624102781250000000000000000000000000000e0 * t1258 + t501 * t1228 + t378 * t1207 + t498 * t1217 + t492 * t1239 + t495 * t1251 + (-0.77292857206958100000000000000000000000000000000000e-1 * t1274 - 0.34352380980870266666666666666666666666666666666667e-2 * t1153 + 0.14313492075362611111111111111111111111111111111111e-3 * t1164) * t412 + 0.22250640561108574687500000000000000000000000000000e-1 * t1274 + t485 * t1207 + t489 * t1263
  t1314 = t462 * t1273
  t1316 = t371 * t1273
  t1328 = (0.27845896284907822500000000000000000000000000000000e-1 * t1274 + 0.12375953904403476666666666666666666666666666666667e-2 * t1153 - 0.51566474601681152777777777777777777777777777777778e-4 * t1164) * t452 + t477 * t1228 + (-0.53177226099084330000000000000000000000000000000000e-2 * t1274 - 0.23634322710704146666666666666666666666666666666667e-3 * t1153 + 0.98476344627933944444444444444444444444444444444444e-5 * t1164) * t457 + (0.12546794310474727500000000000000000000000000000000e-2 * t1274 + 0.55763530268776566666666666666666666666666666666667e-4 * t1153 - 0.23234804278656902777777777777777777777777777777778e-5 * t1164) * t440 + t469 * t1251 + (-0.18712129129105987500000000000000000000000000000000e-1 * t1274 - 0.83165018351582166666666666666666666666666666666667e-3 * t1153 + 0.34652090979825902777777777777777777777777777777778e-4 * t1164) * t446 + t473 * t1217 + (-0.45438726256320435000000000000000000000000000000000e-2 * t1274 - 0.20194989447253526666666666666666666666666666666667e-3 * t1153 + 0.84145789363556361111111111111111111111111111111111e-5 * t1164) * t433 + t465 * t1239 + (0.29456264017009077500000000000000000000000000000000e0 * t1314 - 0.12624113150146747500000000000000000000000000000000e0 * t1316) * t412 - 0.4188213175650997500000000000000000000000000000000e-2 * t1314 - 0.74205374702437850625000000000000000000000000000000e0 * t1316 + t543 * t1207 + (0.32343088194322890000000000000000000000000000000000e-2 * t1274 + 0.14374705864143506666666666666666666666666666666667e-3 * t1153 - 0.59894607767264611111111111111111111111111111111111e-5 * t1164) * t425
  t1354 = t373 * t1273
  t1367 = t547 * t1263 + t531 * t1217 + (0.22443257423488370000000000000000000000000000000000e-1 * t1314 - 0.96185388957807300000000000000000000000000000000000e-2 * t1316) * t452 + t535 * t1228 + (0.23980051120505725000000000000000000000000000000000e-2 * t1314 - 0.10277164765931025000000000000000000000000000000000e-2 * t1316) * t457 + (-0.47634448765561665000000000000000000000000000000000e-2 * t1314 + 0.20414763756669285000000000000000000000000000000000e-2 * t1316) * t440 + t527 * t1251 + (0.73286988384940837500000000000000000000000000000000e-2 * t1314 - 0.31408709307831787500000000000000000000000000000000e-2 * t1316) * t446 + (0.48581054201223337500000000000000000000000000000000e-2 * t1314 - 0.20820451800524287500000000000000000000000000000000e-2 * t1316) * t433 + t523 * t1239 + (-0.10148250194487877500000000000000000000000000000000e-1 * t1354 + 0.67655001296585850000000000000000000000000000000000e-2 * t1274 + 0.10738889094696166666666666666666666666666666666667e-3 * t1153 - 0.44745371227900694444444444444444444444444444444444e-5 * t1164) * t412 - 0.79437917093785877812500000000000000000000000000000e-1 * t1354 + t515 * t1207 + (0.56226504969577127500000000000000000000000000000000e-4 * t1314 - 0.24097073558390197500000000000000000000000000000000e-4 * t1316) * t425
  t1405 = t506 * t1273
  t1419 = t519 * t1263 + t589 * t1217 + (0.89101143584402827500000000000000000000000000000000e-2 * t1354 - 0.59400762389601885000000000000000000000000000000000e-2 * t1274 - 0.94286924427939500000000000000000000000000000000000e-4 * t1153 + 0.39286218511641458333333333333333333333333333333333e-5 * t1164) * t452 + t594 * t1228 + (0.26266466358821851312500000000000000000000000000000e0 * t1354 - 0.17510977572547900875000000000000000000000000000000e0 * t1274 - 0.27795202496107779166666666666666666666666666666667e-2 * t1153 + 0.11581334373378241319444444444444444444444444444444e-3 * t1164) * t457 + (-0.23112796155594768000000000000000000000000000000000e-1 * t1354 + 0.15408530770396512000000000000000000000000000000000e-1 * t1274 + 0.24457985349835733333333333333333333333333333333333e-3 * t1153 - 0.10190827229098222222222222222222222222222222222222e-4 * t1164) * t440 + t584 * t1251 + (-0.39768012252132688125000000000000000000000000000000e-1 * t1354 + 0.26512008168088458750000000000000000000000000000000e-1 * t1274 + 0.42082552647759458333333333333333333333333333333333e-3 * t1153 - 0.17534396936566440972222222222222222222222222222222e-4 * t1164) * t446 + (-0.63890717268783273750000000000000000000000000000000e-1 * t1354 + 0.42593811512522182500000000000000000000000000000000e-1 * t1274 + 0.67609224623051083333333333333333333333333333333333e-3 * t1153 - 0.28170510259604618055555555555555555555555555555556e-4 * t1164) * t433 + t579 * t1239 + (0.20223617827723114612500000000000000000000000000000e0 * t1405 - 0.18385107116111922375000000000000000000000000000000e0 * t1314 + 0.30641845193519870625000000000000000000000000000000e-1 * t1316) * t412 + 0.13451533799369918175000000000000000000000000000000e0 * t1405 + t569 * t1207 + (-0.86733663347567131875000000000000000000000000000000e-2 * t1354 + 0.57822442231711421250000000000000000000000000000000e-2 * t1274 + 0.91781654336049875000000000000000000000000000000000e-4 * t1153 - 0.38242355973354114583333333333333333333333333333333e-5 * t1164) * t425
  t1450 = t374 * t1273
  t1465 = t574 * t1263 + (-0.56393497682032601475000000000000000000000000000000e0 * t1405 + 0.51266816074575092250000000000000000000000000000000e0 * t1314 - 0.85444693457625153750000000000000000000000000000000e-1 * t1316) * t452 + t559 * t1228 + (-0.47627403188261285812500000000000000000000000000000e0 * t1405 + 0.43297639262055714375000000000000000000000000000000e0 * t1314 - 0.72162732103426190625000000000000000000000000000000e-1 * t1316) * t457 + (0.98448084598809763125000000000000000000000000000000e-1 * t1405 - 0.89498258726190693750000000000000000000000000000000e-1 * t1314 + 0.14916376454365115625000000000000000000000000000000e-1 * t1316) * t440 + t634 * t1251 + (0.36644665367256607237500000000000000000000000000000e-1 * t1405 - 0.33313332152051461125000000000000000000000000000000e-1 * t1314 + 0.55522220253419101875000000000000000000000000000000e-2 * t1316) * t446 + t554 * t1217 + (0.36909685993962465337500000000000000000000000000000e-1 * t1405 - 0.33554259994511332125000000000000000000000000000000e-1 * t1314 + 0.55923766657518886875000000000000000000000000000000e-2 * t1316) * t433 + t629 * t1239 + (0.72034030793681350143750000000000000000000000000000e-1 * t1450 - 0.83116189377324634781250000000000000000000000000000e-1 * t1354 + 0.22668051648361264031250000000000000000000000000000e-1 * t1274 + 0.18656832632396102083333333333333333333333333333333e-3 * t1153 - 0.77736802634983758680555555555555555555555555555556e-5 * t1164) * t412 + 0.10977695610065165231250000000000000000000000000000e0 * t1450 + t619 * t1207 + (0.32979511332227101950000000000000000000000000000000e-1 * t1405 - 0.29981373938388274500000000000000000000000000000000e-1 * t1314 + 0.49968956563980457500000000000000000000000000000000e-2 * t1316) * t425
  t1507 = t455 * t412
  t1516 = t624 * t1263 + (0.23335710219137672606250000000000000000000000000000e1 * t1450 - 0.26925819483620391468750000000000000000000000000000e1 * t1354 + 0.73434053137146522187500000000000000000000000000000e0 * t1274 + 0.60439549907116479166666666666666666666666666666667e-2 * t1153 - 0.25183145794631866319444444444444444444444444444444e-3 * t1164) * t452 + t607 * t1228 + (0.26677732778767589268750000000000000000000000000000e0 * t1450 - 0.30781999360116449156250000000000000000000000000000e0 * t1354 + 0.83950907345772134062500000000000000000000000000000e-1 * t1274 + 0.69095396992405048611111111111111111111111111111112e-3 * t1153 - 0.28789748746835436921296296296296296296296296296297e-4 * t1164) * t457 + (0.46124689583527429875000000000000000000000000000000e0 * t1450 - 0.53220795673300880625000000000000000000000000000000e0 * t1354 + 0.14514762456354785625000000000000000000000000000000e0 * t1274 + 0.11946306548440152777777777777777777777777777777778e-2 * t1153 - 0.49776277285167303240740740740740740740740740740741e-4 * t1164) * t446 + t601 * t1217 + t647 * t1239 + (0.28574937258348205725000000000000000000000000000000e0 * t1450 - 0.32971081451940237375000000000000000000000000000000e0 * t1354 + 0.89921131232564283750000000000000000000000000000000e-1 * t1274 + 0.74009161508283361111111111111111111111111111111112e-3 * t1153 - 0.30837150628451400462962962962962962962962962962963e-4 * t1164) * t440 + t653 * t1251 + (-0.69359986974435313406250000000000000000000000000000e-1 * t1450 + 0.80030754201271515468750000000000000000000000000000e-1 * t1354 - 0.21826569327619504218750000000000000000000000000000e-1 * t1274 - 0.17964254590633336805555555555555555555555555555555e-3 * t1153 + 0.74851060794305570023148148148148148148148148148148e-5 * t1164) * t425 + 0.3e1 * t1507 * t1207 - 0.43138819749080580000000000000000000000000000000000e-1 * t1316 * t412 - 0.35268434302752690000000000000000000000000000000000e-2 * t1316 * t425 - 0.38649183818388510000000000000000000000000000000000e-2 * t1316 * t433
  t1525 = t504 * t412
  t1528 = t481 * t412
  t1531 = t539 * t412
  t1534 = t510 * t412
  t1537 = t564 * t412
  t1540 = t613 * t412
  t1554 = -0.35690049148542390000000000000000000000000000000000e-2 * t1316 * t440 - 0.55916486430307440000000000000000000000000000000000e-2 * t1316 * t446 - 0.28924113898523499000000000000000000000000000000000e-2 * t1316 * t452 - 0.34614211374764670000000000000000000000000000000000e-2 * t1316 * t457 + 0.3e1 * t1525 * t1207 + 0.3e1 * t1528 * t1207 + 0.3e1 * t1531 * t1207 + 0.3e1 * t1534 * t1207 + 0.3e1 * t1537 * t1207 + 0.3e1 * t1540 * t1207 + 0.20748619661467272631250000000000000000000000000000e0 * t1207 + 0.35909124603362720486111111111111111111111111111112e-1 * t1153 - 0.14962135251401133535879629629629629629629629629630e-2 * t1164 + t641 * t1263 + (-0.69116286598038730050000000000000000000000000000000e-1 * t1450 + 0.79749561459275457750000000000000000000000000000000e-1 * t1354 - 0.21749880397984215750000000000000000000000000000000e-1 * t1274 - 0.17901136130028161111111111111111111111111111111111e-3 * t1153 + 0.74588067208450671296296296296296296296296296296297e-5 * t1164) * t433
  t1562 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t1143 * t26 * t669 - t1123 - 0.3e1 / 0.8e1 * t5 * t357 * (t1246 + t1283 + t1328 + t1367 + t1419 + t1465 + t1516 + t1554))
  vrho_1_ = t349 + t673 + t6 * (t1138 + t1562)
  t1566 = 0.5e1 / 0.72e2 * t78 * t35
  t1567 = f.my_piecewise3(t48, -t1566, 0)
  t1575 = f.my_piecewise3(t48, 0, -t1566)
  t1586 = f.my_piecewise3(t47, -0.3e1 / 0.2e1 * t54 * t1567 - 0.3e1 / 0.16e2 * t57 * t1567 + 0.3e1 * t709 * t1567, -0.6e1 * t713 * t60 * t1575 - t720 * (0.3e1 * t721 * t1575 + 0.12e2 * t725 * t1575))
  t1590 = t78 * t35 * t82
  t1597 = t747 * s0 / t28 / t749 / r0 * t755
  t1599 = t1590 / 0.12e2 - t1597 / 0.288e3
  t1600 = t89 * t1599
  t1602 = t88 * t1599
  t1604 = t87 * t1599
  t1618 = t74 * t1586
  t1620 = t72 * t1586
  t1622 = 0.35e2 / 0.2e1 * t1618 - 0.15e2 / 0.2e1 * t1620
  t1631 = t73 * t1586
  t1634 = 0.15e2 / 0.2e1 * t1631 - 0.3e1 / 0.2e1 * t1586
  t1643 = t75 * t1586
  t1647 = 0.315e3 / 0.8e1 * t1643 - 0.105e3 / 0.4e1 * t1631 + 0.15e2 / 0.8e1 * t1586
  t1649 = t131 * t1586
  t1654 = 0.3003e4 / 0.16e2 * t1649 - 0.3465e4 / 0.16e2 * t1643 + 0.945e3 / 0.16e2 * t1631 - 0.35e2 / 0.16e2 * t1586
  t1663 = t123 * t1586
  t1667 = 0.693e3 / 0.8e1 * t1663 - 0.315e3 / 0.4e1 * t1618 + 0.105e3 / 0.8e1 * t1620
  t1680 = 0.3e1 * t1099 * t1586 + (0.72034030793681350143750000000000000000000000000000e-1 * t1600 - 0.83116189377324634781250000000000000000000000000000e-1 * t1602 + 0.22668051648361264031250000000000000000000000000000e-1 * t1604 - 0.69963122371485382812500000000000000000000000000000e-4 * t1590 + 0.29151300988118909505208333333333333333333333333333e-5 * t1597) * t72 + t266 * t1586 + (0.46124689583527429875000000000000000000000000000000e0 * t1600 - 0.53220795673300880625000000000000000000000000000000e0 * t1602 + 0.14514762456354785625000000000000000000000000000000e0 * t1604 - 0.44798649556650572916666666666666666666666666666667e-3 * t1590 + 0.18666103981937738715277777777777777777777777777778e-4 * t1597) * t148 + t321 * t1622 + (0.23335710219137672606250000000000000000000000000000e1 * t1600 - 0.26925819483620391468750000000000000000000000000000e1 * t1602 + 0.73434053137146522187500000000000000000000000000000e0 * t1604 - 0.22664831215168679687500000000000000000000000000000e-2 * t1590 + 0.94436796729869498697916666666666666666666666666667e-4 * t1597) * t110 + t327 * t1634 + (0.28574937258348205725000000000000000000000000000000e0 * t1600 - 0.32971081451940237375000000000000000000000000000000e0 * t1602 + 0.89921131232564283750000000000000000000000000000000e-1 * t1604 - 0.27753435565606260416666666666666666666666666666667e-3 * t1590 + 0.11563931485669275173611111111111111111111111111111e-4 * t1597) * t142 + t315 * t1647 + t303 * t1654 + (-0.69116286598038730050000000000000000000000000000000e-1 * t1600 + 0.79749561459275457750000000000000000000000000000000e-1 * t1602 - 0.21749880397984215750000000000000000000000000000000e-1 * t1604 + 0.67129260487605604166666666666666666666666666666667e-4 * t1590 - 0.27970525203169001736111111111111111111111111111111e-5 * t1597) * t135 + t309 * t1667 + (-0.69359986974435313406250000000000000000000000000000e-1 * t1600 + 0.80030754201271515468750000000000000000000000000000e-1 * t1602 - 0.21826569327619504218750000000000000000000000000000e-1 * t1604 + 0.67365954714875013020833333333333333333333333333333e-4 * t1590 - 0.28069147797864588758680555555555555555555555555555e-5 * t1597) * t127 + (0.98280297068585083333333333333333333333333333333333e-2 * t1590 - 0.40950123778577118055555555555555555555555555555555e-3 * t1597) * t72
  t1713 = t99 * t1586 + (0.14955321307203416666666666666666666666666666666667e-3 * t1590 - 0.62313838780014236111111111111111111111111111111113e-5 * t1597) * t104 + (0.17711102981460050000000000000000000000000000000000e-3 * t1590 - 0.73796262422750208333333333333333333333333333333333e-5 * t1597) * t110 + t107 * t1634 + (0.16727461658817891666666666666666666666666666666667e-3 * t1590 - 0.69697756911741215277777777777777777777777777777779e-5 * t1597) * t142 + t167 * t1647 + (0.24294046008196958333333333333333333333333333333333e-3 * t1590 - 0.10122519170082065972222222222222222222222222222222e-4 * t1597) * t148 + t170 * t1622 + (0.12429895653008616666666666666666666666666666666667e-3 * t1590 - 0.51791231887535902777777777777777777777777777777779e-5 * t1597) * t135 + t164 * t1667 + t158 * t1586 + (0.16168039285199133333333333333333333333333333333333e-3 * t1590 - 0.67366830354996388888888888888888888888888888888888e-5 * t1597) * t127 + t161 * t1654 + t178 * t1647
  t1723 = t92 * t1599
  t1725 = t86 * t1599
  t1758 = (-0.10148250194487877500000000000000000000000000000000e-1 * t1602 + 0.67655001296585850000000000000000000000000000000000e-2 * t1604 - 0.40270834105110625000000000000000000000000000000000e-4 * t1590 + 0.16779514210462760416666666666666666666666666666667e-5 * t1597) * t72 - 0.79437917093785877812500000000000000000000000000000e-1 * t1602 + t256 * t1586 + (0.56226504969577127500000000000000000000000000000000e-4 * t1723 - 0.24097073558390197500000000000000000000000000000000e-4 * t1725) * t127 + t260 * t1654 + (0.89101143584402827500000000000000000000000000000000e-2 * t1602 - 0.59400762389601885000000000000000000000000000000000e-2 * t1604 + 0.35357596660477312500000000000000000000000000000000e-4 * t1590 - 0.14732331941865546875000000000000000000000000000000e-5 * t1597) * t110 + t246 * t1634 + (0.26266466358821851312500000000000000000000000000000e0 * t1602 - 0.17510977572547900875000000000000000000000000000000e0 * t1604 + 0.10423200936040417187500000000000000000000000000000e-2 * t1590 - 0.43430003900168404947916666666666666666666666666667e-4 * t1597) * t104 + (0.29456264017009077500000000000000000000000000000000e0 * t1723 - 0.12624113150146747500000000000000000000000000000000e0 * t1725) * t72 + t194 * t1586 + (0.73286988384940837500000000000000000000000000000000e-2 * t1723 - 0.31408709307831787500000000000000000000000000000000e-2 * t1725) * t148 + t182 * t1622 + (0.48581054201223337500000000000000000000000000000000e-2 * t1723 - 0.20820451800524287500000000000000000000000000000000e-2 * t1725) * t135 + t174 * t1667
  t1794 = (-0.47634448765561665000000000000000000000000000000000e-2 * t1723 + 0.20414763756669285000000000000000000000000000000000e-2 * t1725) * t142 + (-0.45438726256320435000000000000000000000000000000000e-2 * t1604 + 0.75731210427200725000000000000000000000000000000000e-4 * t1590 - 0.31554671011333635416666666666666666666666666666667e-5 * t1597) * t135 + t202 * t1667 + (0.12546794310474727500000000000000000000000000000000e-2 * t1604 - 0.20911323850791212500000000000000000000000000000000e-4 * t1590 + 0.87130516044963385416666666666666666666666666666667e-6 * t1597) * t142 + t206 * t1647 + (0.32343088194322890000000000000000000000000000000000e-2 * t1604 - 0.53905146990538150000000000000000000000000000000000e-4 * t1590 + 0.22460477912724229166666666666666666666666666666667e-5 * t1597) * t127 + t198 * t1654 + (0.22443257423488370000000000000000000000000000000000e-1 * t1723 - 0.96185388957807300000000000000000000000000000000000e-2 * t1725) * t110 - 0.4188213175650997500000000000000000000000000000000e-2 * t1723 - 0.74205374702437850625000000000000000000000000000000e0 * t1725 + t186 * t1634 + (0.23980051120505725000000000000000000000000000000000e-2 * t1723 - 0.10277164765931025000000000000000000000000000000000e-2 * t1725) * t104 + 0.11775890511466263000000000000000000000000000000000e0 * t1618 - 0.11765768981988274200000000000000000000000000000000e-1 * t1620
  t1823 = t151 * t1634 - 0.96364485405785018437500000000000000000000000000000e-1 * t1631 + t138 * t1647 + 0.43767257904820069593750000000000000000000000000000e0 * t1643 + t130 * t1667 - 0.17131022505250731000000000000000000000000000000000e0 * t1663 + (-0.53177226099084330000000000000000000000000000000000e-2 * t1604 + 0.88628710165140550000000000000000000000000000000000e-4 * t1590 - 0.36928629235475229166666666666666666666666666666667e-5 * t1597) * t104 + 0.22250640561108574687500000000000000000000000000000e-1 * t1604 + (-0.77292857206958100000000000000000000000000000000000e-1 * t1604 + 0.12882142867826350000000000000000000000000000000000e-2 * t1590 - 0.53675595282609791666666666666666666666666666666667e-4 * t1597) * t72 + t118 * t1586 + t121 * t1654 - 0.47225184058624102781250000000000000000000000000000e0 * t1649 + (-0.18712129129105987500000000000000000000000000000000e-1 * t1604 + 0.31186881881843312500000000000000000000000000000000e-3 * t1590 - 0.12994534117434713541666666666666666666666666666667e-4 * t1597) * t148 + t210 * t1622
  t1835 = t95 * t1599
  t1861 = (0.27845896284907822500000000000000000000000000000000e-1 * t1604 - 0.46409827141513037500000000000000000000000000000000e-3 * t1590 + 0.19337427975630432291666666666666666666666666666667e-4 * t1597) * t110 + t216 * t1634 + t145 * t1622 + 0.20748619661467272631250000000000000000000000000000e0 * t1586 + 0.56108007192754250759548611111111111111111111111113e-3 * t1597 - 0.13465921726261020182291666666666666666666666666667e-1 * t1590 + t281 * t1647 + (0.32979511332227101950000000000000000000000000000000e-1 * t1835 - 0.29981373938388274500000000000000000000000000000000e-1 * t1723 + 0.49968956563980457500000000000000000000000000000000e-2 * t1725) * t127 + t271 * t1654 + (0.26677732778767589268750000000000000000000000000000e0 * t1600 - 0.30781999360116449156250000000000000000000000000000e0 * t1602 + 0.83950907345772134062500000000000000000000000000000e-1 * t1604 - 0.25910773872151893229166666666666666666666666666667e-3 * t1590 + 0.10796155780063288845486111111111111111111111111111e-4 * t1597) * t104 + 0.10977695610065165231250000000000000000000000000000e0 * t1600 + (0.36644665367256607237500000000000000000000000000000e-1 * t1835 - 0.33313332152051461125000000000000000000000000000000e-1 * t1723 + 0.55522220253419101875000000000000000000000000000000e-2 * t1725) * t148 + t286 * t1622 + (0.36909685993962465337500000000000000000000000000000e-1 * t1835 - 0.33554259994511332125000000000000000000000000000000e-1 * t1723 + 0.55923766657518886875000000000000000000000000000000e-2 * t1725) * t135
  t1899 = t276 * t1667 + (0.98448084598809763125000000000000000000000000000000e-1 * t1835 - 0.89498258726190693750000000000000000000000000000000e-1 * t1723 + 0.14916376454365115625000000000000000000000000000000e-1 * t1725) * t142 + 0.13451533799369918175000000000000000000000000000000e0 * t1835 + t221 * t1586 + (-0.86733663347567131875000000000000000000000000000000e-2 * t1602 + 0.57822442231711421250000000000000000000000000000000e-2 * t1604 - 0.34418120376018703125000000000000000000000000000000e-4 * t1590 + 0.14340883490007792968750000000000000000000000000000e-5 * t1597) * t127 + t226 * t1654 + (-0.56393497682032601475000000000000000000000000000000e0 * t1835 + 0.51266816074575092250000000000000000000000000000000e0 * t1723 - 0.85444693457625153750000000000000000000000000000000e-1 * t1725) * t110 + t291 * t1634 + (-0.47627403188261285812500000000000000000000000000000e0 * t1835 + 0.43297639262055714375000000000000000000000000000000e0 * t1723 - 0.72162732103426190625000000000000000000000000000000e-1 * t1725) * t104 + 0.3e1 * t1067 * t1586 - 0.28924113898523499000000000000000000000000000000000e-2 * t1725 * t110 - 0.34614211374764670000000000000000000000000000000000e-2 * t1725 * t104 + 0.3e1 * t1074 * t1586 - 0.43138819749080580000000000000000000000000000000000e-1 * t1725 * t72
  t1942 = -0.35268434302752690000000000000000000000000000000000e-2 * t1725 * t127 - 0.38649183818388510000000000000000000000000000000000e-2 * t1725 * t135 - 0.35690049148542390000000000000000000000000000000000e-2 * t1725 * t142 - 0.55916486430307440000000000000000000000000000000000e-2 * t1725 * t148 + 0.3e1 * t1087 * t1586 + 0.3e1 * t1090 * t1586 + 0.3e1 * t1093 * t1586 + 0.3e1 * t1096 * t1586 + t236 * t1647 + (-0.39768012252132688125000000000000000000000000000000e-1 * t1602 + 0.26512008168088458750000000000000000000000000000000e-1 * t1604 - 0.15780957242909796875000000000000000000000000000000e-3 * t1590 + 0.65753988512124153645833333333333333333333333333333e-5 * t1597) * t148 + t241 * t1622 + (-0.63890717268783273750000000000000000000000000000000e-1 * t1602 + 0.42593811512522182500000000000000000000000000000000e-1 * t1604 - 0.25353459233644156250000000000000000000000000000000e-3 * t1590 + 0.10563941347351731770833333333333333333333333333333e-4 * t1597) * t135 + t231 * t1667 + (-0.23112796155594768000000000000000000000000000000000e-1 * t1602 + 0.15408530770396512000000000000000000000000000000000e-1 * t1604 - 0.91717445061884000000000000000000000000000000000000e-4 * t1590 + 0.38215602109118333333333333333333333333333333333333e-5 * t1597) * t142 + (0.20223617827723114612500000000000000000000000000000e0 * t1835 - 0.18385107116111922375000000000000000000000000000000e0 * t1723 + 0.30641845193519870625000000000000000000000000000000e-1 * t1725) * t72
  t1949 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t1680 + t1713 + t1758 + t1794 + t1823 + t1861 + t1899 + t1942))
  vsigma_0_ = t6 * t1949
  vsigma_1_ = 0.0e0
  t1951 = 0.5e1 / 0.72e2 * t78 * t362
  t1952 = f.my_piecewise3(t388, -t1951, 0)
  t1960 = f.my_piecewise3(t388, 0, -t1951)
  t1971 = f.my_piecewise3(t387, -0.3e1 / 0.2e1 * t394 * t1952 - 0.3e1 / 0.16e2 * t397 * t1952 + 0.3e1 * t1185 * t1952, -0.6e1 * t1189 * t400 * t1960 - t1196 * (0.3e1 * t1197 * t1960 + 0.12e2 * t1201 * t1960))
  t1974 = t78 * t362 * t367
  t1981 = t747 * s2 / t359 / t1156 / r1 * t1162
  t1983 = t1974 / 0.12e2 - t1981 / 0.288e3
  t1984 = t373 * t1983
  t1986 = t372 * t1983
  t2001 = t462 * t1983
  t2003 = t371 * t1983
  t2009 = t429 * t1971
  t2011 = t418 * t1971
  t2013 = t416 * t1971
  t2016 = 0.3003e4 / 0.16e2 * t2009 - 0.3465e4 / 0.16e2 * t2011 + 0.945e3 / 0.16e2 * t2013 - 0.35e2 / 0.16e2 * t1971
  t2025 = 0.20748619661467272631250000000000000000000000000000e0 * t1971 + (0.26266466358821851312500000000000000000000000000000e0 * t1984 - 0.17510977572547900875000000000000000000000000000000e0 * t1986 + 0.10423200936040417187500000000000000000000000000000e-2 * t1974 - 0.43430003900168404947916666666666666666666666666667e-4 * t1981) * t457 - 0.79437917093785877812500000000000000000000000000000e-1 * t1984 + 0.22250640561108574687500000000000000000000000000000e-1 * t1986 + (-0.10148250194487877500000000000000000000000000000000e-1 * t1984 + 0.67655001296585850000000000000000000000000000000000e-2 * t1986 - 0.40270834105110625000000000000000000000000000000000e-4 * t1974 + 0.16779514210462760416666666666666666666666666666667e-5 * t1981) * t412 + t515 * t1971 + (0.56226504969577127500000000000000000000000000000000e-4 * t2001 - 0.24097073558390197500000000000000000000000000000000e-4 * t2003) * t425 - 0.4188213175650997500000000000000000000000000000000e-2 * t2001 - 0.74205374702437850625000000000000000000000000000000e0 * t2003 + t519 * t2016 - 0.47225184058624102781250000000000000000000000000000e0 * t2009 + 0.43767257904820069593750000000000000000000000000000e0 * t2011 - 0.96364485405785018437500000000000000000000000000000e-1 * t2013 + (0.48581054201223337500000000000000000000000000000000e-2 * t2001 - 0.20820451800524287500000000000000000000000000000000e-2 * t2003) * t433
  t2026 = t421 * t1971
  t2028 = t417 * t1971
  t2030 = t412 * t1971
  t2032 = 0.693e3 / 0.8e1 * t2026 - 0.315e3 / 0.4e1 * t2028 + 0.105e3 / 0.8e1 * t2030
  t2044 = 0.315e3 / 0.8e1 * t2011 - 0.105e3 / 0.4e1 * t2013 + 0.15e2 / 0.8e1 * t1971
  t2052 = 0.35e2 / 0.2e1 * t2028 - 0.15e2 / 0.2e1 * t2030
  t2060 = 0.15e2 / 0.2e1 * t2013 - 0.3e1 / 0.2e1 * t1971
  t2076 = t523 * t2032 - 0.17131022505250731000000000000000000000000000000000e0 * t2026 + 0.11775890511466263000000000000000000000000000000000e0 * t2028 - 0.11765768981988274200000000000000000000000000000000e-1 * t2030 + (-0.47634448765561665000000000000000000000000000000000e-2 * t2001 + 0.20414763756669285000000000000000000000000000000000e-2 * t2003) * t440 + t527 * t2044 + (0.73286988384940837500000000000000000000000000000000e-2 * t2001 - 0.31408709307831787500000000000000000000000000000000e-2 * t2003) * t446 + t531 * t2052 + (0.22443257423488370000000000000000000000000000000000e-1 * t2001 - 0.96185388957807300000000000000000000000000000000000e-2 * t2003) * t452 + t535 * t2060 + (0.23980051120505725000000000000000000000000000000000e-2 * t2001 - 0.10277164765931025000000000000000000000000000000000e-2 * t2003) * t457 + (0.29456264017009077500000000000000000000000000000000e0 * t2001 - 0.12624113150146747500000000000000000000000000000000e0 * t2003) * t412 + t543 * t1971 + (0.32343088194322890000000000000000000000000000000000e-2 * t1986 - 0.53905146990538150000000000000000000000000000000000e-4 * t1974 + 0.22460477912724229166666666666666666666666666666667e-5 * t1981) * t425
  t2101 = t506 * t1983
  t2122 = t547 * t2016 - 0.13465921726261020182291666666666666666666666666667e-1 * t1974 + (-0.23112796155594768000000000000000000000000000000000e-1 * t1984 + 0.15408530770396512000000000000000000000000000000000e-1 * t1986 - 0.91717445061884000000000000000000000000000000000000e-4 * t1974 + 0.38215602109118333333333333333333333333333333333333e-5 * t1981) * t440 + t584 * t2044 + (-0.39768012252132688125000000000000000000000000000000e-1 * t1984 + 0.26512008168088458750000000000000000000000000000000e-1 * t1986 - 0.15780957242909796875000000000000000000000000000000e-3 * t1974 + 0.65753988512124153645833333333333333333333333333333e-5 * t1981) * t446 + t589 * t2052 + (0.89101143584402827500000000000000000000000000000000e-2 * t1984 - 0.59400762389601885000000000000000000000000000000000e-2 * t1986 + 0.35357596660477312500000000000000000000000000000000e-4 * t1974 - 0.14732331941865546875000000000000000000000000000000e-5 * t1981) * t452 + t594 * t2060 + (0.20223617827723114612500000000000000000000000000000e0 * t2101 - 0.18385107116111922375000000000000000000000000000000e0 * t2001 + 0.30641845193519870625000000000000000000000000000000e-1 * t2003) * t412 + t569 * t1971 + (-0.86733663347567131875000000000000000000000000000000e-2 * t1984 + 0.57822442231711421250000000000000000000000000000000e-2 * t1986 - 0.34418120376018703125000000000000000000000000000000e-4 * t1974 + 0.14340883490007792968750000000000000000000000000000e-5 * t1981) * t425 + t574 * t2016 + (-0.63890717268783273750000000000000000000000000000000e-1 * t1984 + 0.42593811512522182500000000000000000000000000000000e-1 * t1986 - 0.25353459233644156250000000000000000000000000000000e-3 * t1974 + 0.10563941347351731770833333333333333333333333333333e-4 * t1981) * t433 + t579 * t2032
  t2159 = t374 * t1983
  t2168 = t634 * t2044 + (0.36644665367256607237500000000000000000000000000000e-1 * t2101 - 0.33313332152051461125000000000000000000000000000000e-1 * t2001 + 0.55522220253419101875000000000000000000000000000000e-2 * t2003) * t446 + t554 * t2052 + (-0.56393497682032601475000000000000000000000000000000e0 * t2101 + 0.51266816074575092250000000000000000000000000000000e0 * t2001 - 0.85444693457625153750000000000000000000000000000000e-1 * t2003) * t452 + t559 * t2060 + (-0.47627403188261285812500000000000000000000000000000e0 * t2101 + 0.43297639262055714375000000000000000000000000000000e0 * t2001 - 0.72162732103426190625000000000000000000000000000000e-1 * t2003) * t457 + (0.32979511332227101950000000000000000000000000000000e-1 * t2101 - 0.29981373938388274500000000000000000000000000000000e-1 * t2001 + 0.49968956563980457500000000000000000000000000000000e-2 * t2003) * t425 + 0.13451533799369918175000000000000000000000000000000e0 * t2101 + t624 * t2016 + (0.36909685993962465337500000000000000000000000000000e-1 * t2101 - 0.33554259994511332125000000000000000000000000000000e-1 * t2001 + 0.55923766657518886875000000000000000000000000000000e-2 * t2003) * t433 + t629 * t2032 + (0.98448084598809763125000000000000000000000000000000e-1 * t2101 - 0.89498258726190693750000000000000000000000000000000e-1 * t2001 + 0.14916376454365115625000000000000000000000000000000e-1 * t2003) * t440 + (0.23335710219137672606250000000000000000000000000000e1 * t2159 - 0.26925819483620391468750000000000000000000000000000e1 * t1984 + 0.73434053137146522187500000000000000000000000000000e0 * t1986 - 0.22664831215168679687500000000000000000000000000000e-2 * t1974 + 0.94436796729869498697916666666666666666666666666667e-4 * t1981) * t452 + t607 * t2060
  t2221 = (0.26677732778767589268750000000000000000000000000000e0 * t2159 - 0.30781999360116449156250000000000000000000000000000e0 * t1984 + 0.83950907345772134062500000000000000000000000000000e-1 * t1986 - 0.25910773872151893229166666666666666666666666666667e-3 * t1974 + 0.10796155780063288845486111111111111111111111111111e-4 * t1981) * t457 + (0.72034030793681350143750000000000000000000000000000e-1 * t2159 - 0.83116189377324634781250000000000000000000000000000e-1 * t1984 + 0.22668051648361264031250000000000000000000000000000e-1 * t1986 - 0.69963122371485382812500000000000000000000000000000e-4 * t1974 + 0.29151300988118909505208333333333333333333333333333e-5 * t1981) * t412 + t619 * t1971 + 0.56108007192754250759548611111111111111111111111113e-3 * t1981 + (-0.45438726256320435000000000000000000000000000000000e-2 * t1986 + 0.75731210427200725000000000000000000000000000000000e-4 * t1974 - 0.31554671011333635416666666666666666666666666666667e-5 * t1981) * t433 + t465 * t2032 + (0.12546794310474727500000000000000000000000000000000e-2 * t1986 - 0.20911323850791212500000000000000000000000000000000e-4 * t1974 + 0.87130516044963385416666666666666666666666666666667e-6 * t1981) * t440 + t469 * t2044 + (-0.18712129129105987500000000000000000000000000000000e-1 * t1986 + 0.31186881881843312500000000000000000000000000000000e-3 * t1974 - 0.12994534117434713541666666666666666666666666666667e-4 * t1981) * t446 + t473 * t2052 + (0.27845896284907822500000000000000000000000000000000e-1 * t1986 - 0.46409827141513037500000000000000000000000000000000e-3 * t1974 + 0.19337427975630432291666666666666666666666666666667e-4 * t1981) * t452 + t477 * t2060 + (-0.53177226099084330000000000000000000000000000000000e-2 * t1986 + 0.88628710165140550000000000000000000000000000000000e-4 * t1974 - 0.36928629235475229166666666666666666666666666666667e-5 * t1981) * t457 + (-0.77292857206958100000000000000000000000000000000000e-1 * t1986 + 0.12882142867826350000000000000000000000000000000000e-2 * t1974 - 0.53675595282609791666666666666666666666666666666667e-4 * t1981) * t412
  t2248 = t485 * t1971 + t489 * t2016 + t492 * t2032 + t495 * t2044 + t498 * t2052 + t501 * t2060 + t378 * t1971 + (0.16168039285199133333333333333333333333333333333333e-3 * t1974 - 0.67366830354996388888888888888888888888888888888888e-5 * t1981) * t425 + t415 * t2016 + (0.12429895653008616666666666666666666666666666666667e-3 * t1974 - 0.51791231887535902777777777777777777777777777777779e-5 * t1981) * t433 + t428 * t2032 + (0.16727461658817891666666666666666666666666666666667e-3 * t1974 - 0.69697756911741215277777777777777777777777777777779e-5 * t1981) * t440 + t436 * t2044 + (0.24294046008196958333333333333333333333333333333333e-3 * t1974 - 0.10122519170082065972222222222222222222222222222222e-4 * t1981) * t446
  t2291 = t647 * t2032 + (0.28574937258348205725000000000000000000000000000000e0 * t2159 - 0.32971081451940237375000000000000000000000000000000e0 * t1984 + 0.89921131232564283750000000000000000000000000000000e-1 * t1986 - 0.27753435565606260416666666666666666666666666666667e-3 * t1974 + 0.11563931485669275173611111111111111111111111111111e-4 * t1981) * t440 + t653 * t2044 + (0.46124689583527429875000000000000000000000000000000e0 * t2159 - 0.53220795673300880625000000000000000000000000000000e0 * t1984 + 0.14514762456354785625000000000000000000000000000000e0 * t1986 - 0.44798649556650572916666666666666666666666666666667e-3 * t1974 + 0.18666103981937738715277777777777777777777777777778e-4 * t1981) * t446 + t601 * t2052 + t443 * t2052 + (0.17711102981460050000000000000000000000000000000000e-3 * t1974 - 0.73796262422750208333333333333333333333333333333333e-5 * t1981) * t452 + t449 * t2060 + (0.14955321307203416666666666666666666666666666666667e-3 * t1974 - 0.62313838780014236111111111111111111111111111111113e-5 * t1981) * t457 + (0.98280297068585083333333333333333333333333333333333e-2 * t1974 - 0.40950123778577118055555555555555555555555555555555e-3 * t1981) * t412 + t460 * t1971 + (-0.69359986974435313406250000000000000000000000000000e-1 * t2159 + 0.80030754201271515468750000000000000000000000000000e-1 * t1984 - 0.21826569327619504218750000000000000000000000000000e-1 * t1986 + 0.67365954714875013020833333333333333333333333333333e-4 * t1974 - 0.28069147797864588758680555555555555555555555555555e-5 * t1981) * t425 + 0.10977695610065165231250000000000000000000000000000e0 * t2159 + t641 * t2016
  t2327 = (-0.69116286598038730050000000000000000000000000000000e-1 * t2159 + 0.79749561459275457750000000000000000000000000000000e-1 * t1984 - 0.21749880397984215750000000000000000000000000000000e-1 * t1986 + 0.67129260487605604166666666666666666666666666666667e-4 * t1974 - 0.27970525203169001736111111111111111111111111111111e-5 * t1981) * t433 + 0.3e1 * t1540 * t1971 + 0.3e1 * t1537 * t1971 + 0.3e1 * t1534 * t1971 + 0.3e1 * t1531 * t1971 + 0.3e1 * t1528 * t1971 - 0.35268434302752690000000000000000000000000000000000e-2 * t2003 * t425 - 0.38649183818388510000000000000000000000000000000000e-2 * t2003 * t433 - 0.35690049148542390000000000000000000000000000000000e-2 * t2003 * t440 - 0.55916486430307440000000000000000000000000000000000e-2 * t2003 * t446 - 0.28924113898523499000000000000000000000000000000000e-2 * t2003 * t452 - 0.34614211374764670000000000000000000000000000000000e-2 * t2003 * t457 + 0.3e1 * t1525 * t1971 - 0.43138819749080580000000000000000000000000000000000e-1 * t2003 * t412 + 0.3e1 * t1507 * t1971
  t2334 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t357 * (t2025 + t2076 + t2122 + t2168 + t2221 + t2248 + t2291 + t2327))
  vsigma_2_ = t6 * t2334
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t2337 = 0.5e1 / 0.9e1 * t31 * t39 * t44
  t2338 = f.my_piecewise3(t48, t2337, 0)
  t2346 = f.my_piecewise3(t48, 0, t2337)
  t2357 = f.my_piecewise3(t47, -0.3e1 / 0.2e1 * t54 * t2338 - 0.3e1 / 0.16e2 * t57 * t2338 + 0.3e1 * t709 * t2338, -0.6e1 * t713 * t60 * t2346 - t720 * (0.3e1 * t721 * t2346 + 0.12e2 * t725 * t2346))
  t2359 = t131 * t2357
  t2361 = t75 * t2357
  t2363 = t73 * t2357
  t2366 = 0.3003e4 / 0.16e2 * t2359 - 0.3465e4 / 0.16e2 * t2361 + 0.945e3 / 0.16e2 * t2363 - 0.35e2 / 0.16e2 * t2357
  t2368 = t123 * t2357
  t2370 = t74 * t2357
  t2372 = t72 * t2357
  t2374 = 0.693e3 / 0.8e1 * t2368 - 0.315e3 / 0.4e1 * t2370 + 0.105e3 / 0.8e1 * t2372
  t2381 = 0.35e2 / 0.2e1 * t2370 - 0.15e2 / 0.2e1 * t2372
  t2385 = 0.15e2 / 0.2e1 * t2363 - 0.3e1 / 0.2e1 * t2357
  t2391 = 0.315e3 / 0.8e1 * t2361 - 0.105e3 / 0.4e1 * t2363 + 0.15e2 / 0.8e1 * t2357
  t2397 = 0.20748619661467272631250000000000000000000000000000e0 * t2357 + t198 * t2366 + t202 * t2374 + t276 * t2374 + t266 * t2357 + t271 * t2366 + t321 * t2381 + t327 * t2385 + t309 * t2374 + t315 * t2391 + t303 * t2366 + t99 * t2357 + t170 * t2381 + t164 * t2374
  t2412 = t107 * t2385 + t145 * t2381 + t151 * t2385 + t158 * t2357 + t161 * t2366 + t167 * t2391 + t206 * t2391 + t221 * t2357 + t226 * t2366 + t231 * t2374 + t236 * t2391 + t286 * t2381 + t291 * t2385 + t281 * t2391
  t2435 = 0.3e1 * t1067 * t2357 + 0.3e1 * t1074 * t2357 + 0.3e1 * t1087 * t2357 + 0.3e1 * t1090 * t2357 + 0.3e1 * t1093 * t2357 + 0.3e1 * t1096 * t2357 + 0.3e1 * t1099 * t2357 + t118 * t2357 + t121 * t2366 + t130 * t2374 + t138 * t2391 + t210 * t2381 + t216 * t2385 + t241 * t2381
  t2450 = 0.11775890511466263000000000000000000000000000000000e0 * t2370 - 0.11765768981988274200000000000000000000000000000000e-1 * t2372 + t246 * t2385 - 0.96364485405785018437500000000000000000000000000000e-1 * t2363 + t256 * t2357 + t260 * t2366 - 0.47225184058624102781250000000000000000000000000000e0 * t2359 + 0.43767257904820069593750000000000000000000000000000e0 * t2361 + t174 * t2374 - 0.17131022505250731000000000000000000000000000000000e0 * t2368 + t178 * t2391 + t182 * t2381 + t186 * t2385 + t194 * t2357
  t2456 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t2397 + t2412 + t2435 + t2450))
  vtau_0_ = t6 * t2456
  t2459 = 0.5e1 / 0.9e1 * t380 * t39 * t44
  t2460 = f.my_piecewise3(t388, t2459, 0)
  t2468 = f.my_piecewise3(t388, 0, t2459)
  t2479 = f.my_piecewise3(t387, -0.3e1 / 0.2e1 * t394 * t2460 - 0.3e1 / 0.16e2 * t397 * t2460 + 0.3e1 * t1185 * t2460, -0.6e1 * t1189 * t400 * t2468 - t1196 * (0.3e1 * t1197 * t2468 + 0.12e2 * t1201 * t2468))
  t2481 = t416 * t2479
  t2484 = 0.15e2 / 0.2e1 * t2481 - 0.3e1 / 0.2e1 * t2479
  t2488 = t418 * t2479
  t2492 = 0.315e3 / 0.8e1 * t2488 - 0.105e3 / 0.4e1 * t2481 + 0.15e2 / 0.8e1 * t2479
  t2495 = t417 * t2479
  t2497 = t412 * t2479
  t2499 = 0.35e2 / 0.2e1 * t2495 - 0.15e2 / 0.2e1 * t2497
  t2503 = t421 * t2479
  t2507 = 0.693e3 / 0.8e1 * t2503 - 0.315e3 / 0.4e1 * t2495 + 0.105e3 / 0.8e1 * t2497
  t2511 = t429 * t2479
  t2516 = 0.3003e4 / 0.16e2 * t2511 - 0.3465e4 / 0.16e2 * t2488 + 0.945e3 / 0.16e2 * t2481 - 0.35e2 / 0.16e2 * t2479
  t2519 = 0.20748619661467272631250000000000000000000000000000e0 * t2479 + t449 * t2484 - 0.96364485405785018437500000000000000000000000000000e-1 * t2481 + t460 * t2479 + t436 * t2492 + 0.43767257904820069593750000000000000000000000000000e0 * t2488 + t443 * t2499 + 0.11775890511466263000000000000000000000000000000000e0 * t2495 - 0.11765768981988274200000000000000000000000000000000e-1 * t2497 + t428 * t2507 - 0.17131022505250731000000000000000000000000000000000e0 * t2503 + t378 * t2479 + t415 * t2516 - 0.47225184058624102781250000000000000000000000000000e0 * t2511
  t2534 = t485 * t2479 + t543 * t2479 + t477 * t2484 + t501 * t2484 + t535 * t2484 + t469 * t2492 + t495 * t2492 + t473 * t2499 + t498 * t2499 + t531 * t2499 + t465 * t2507 + t492 * t2507 + t489 * t2516 + t547 * t2516
  t2550 = t515 * t2479 + t569 * t2479 + t559 * t2484 + t594 * t2484 + t527 * t2492 + t584 * t2492 + t634 * t2492 + t554 * t2499 + t589 * t2499 + t523 * t2507 + t579 * t2507 + t629 * t2507 + t519 * t2516 + t574 * t2516
  t2572 = 0.3e1 * t1507 * t2479 + 0.3e1 * t1525 * t2479 + 0.3e1 * t1528 * t2479 + 0.3e1 * t1531 * t2479 + 0.3e1 * t1534 * t2479 + 0.3e1 * t1537 * t2479 + 0.3e1 * t1540 * t2479 + t619 * t2479 + t607 * t2484 + t653 * t2492 + t601 * t2499 + t647 * t2507 + t624 * t2516 + t641 * t2516
  t2578 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t357 * (t2519 + t2534 + t2550 + t2572))
  vtau_1_ = t6 * t2578
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.067841267592822, -0.158722422825204, -0.2372737447003859, 0.002558752743285125, 0.006748483298726394, 0.001199436228162263, 0.001552846614645878, 0.000584892206996479], dtype=np.float64), np.array([np.nan, 0.2032399091383024, 0.1179363564823021, -0.01437960658302686, -0.01030571429426108, 0.01683215086686233, -0.000257733338272708, 0.002334616776649133, 0.0003837976998664341], dtype=np.float64), np.array([np.nan, -0.0006952718706718514, 0.00179463855686441, -0.001153807045825489, -0.0007090296813211244, 0.000137028863545747, 0.006670848599065867, -0.005498112922165805, 0.001421391023843761], dtype=np.float64), np.array([np.nan, -0.002565692477269114, 0.002125332357775206, -0.0009641371299507833, 0.003712786171321043, 0.001282471852770764, 0.0002262886186270548, -0.006510071882485726, 0.01243327883803539], dtype=np.float64), np.array([np.nan, -0.002170152177993684, 0.002915285520983635, -0.001863882881010248, -0.002494950550547465, 0.0004187827907710905, -0.001009981263546227, 0.0004230264400260503, 0.00245752591853626], dtype=np.float64), np.array([np.nan, -0.002723387704355568, 0.002007295399058147, -0.001189668304951413, 0.0001672905908063297, -0.0002721968500889238, -0.0005869916483960576, 0.001136485825094485, 0.001522474179598972], dtype=np.float64), np.array([np.nan, -0.00197760721561336, 0.001491587478361034, -0.001288306127279617, -0.0006058496834176058, 0.0002776060240069905, -0.001622621390953226, 0.0004260858412001439, -0.0003682519432462936], dtype=np.float64), np.array([np.nan, -0.002516160322803815, 0.001940164714223896, -0.001175614476758423, 0.0004312411759243052, 3.212943141118693e-06, -0.0002202759704065197, 0.0003807158595350892, -0.0003695503801501715], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = s0 * t28
  t35 = t34 * t32
  t38 = 0.65124e1 + t25 * t35 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t33 * t39
  t41 = t26 * t40
  t43 = tau0 * t28
  t45 = 0.1e1 / t30 / r0
  t51 = 0.5e1 / 0.9e1 * (t43 * t45 - t35 / 0.8e1) * t20 * t24
  t52 = 0.1e5 <= t51
  t53 = 0.1e5 < t51
  t54 = f.my_piecewise3(t53, t51, 0.1e5)
  t55 = t54 ** 2
  t59 = 0.1e1 / t55 / t54
  t61 = t55 ** 2
  t62 = 0.1e1 / t61
  t65 = f.my_piecewise3(t53, 0.1e5, t51)
  t66 = t65 ** 2
  t67 = 0.1e1 - t66
  t68 = t67 ** 2
  t69 = t68 * t67
  t70 = t66 * t65
  t72 = 0.1e1 + 0.4e1 * t70
  t74 = t70 * t72 + 0.1e1
  t75 = 0.1e1 / t74
  t77 = f.my_piecewise3(t52, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t55 + t59 / 0.16e2 - 0.3e1 / 0.4e1 * t62, t69 * t75)
  t79 = t77 ** 2
  t80 = t79 * t77
  t82 = t79 ** 2
  t83 = t82 * t79
  t87 = t82 * t80
  t89 = t82 * t77
  t92 = t41 / 0.12e2 - 0.1e1
  t93 = t92 ** 2
  t94 = t93 ** 2
  t95 = t94 * t92
  t97 = t93 * t92
  t99 = t94 * t97
  t103 = t94 * t93
  t106 = 0.57690352291274450000000000000000000000000000000000e-3 - 0.17307105687382335000000000000000000000000000000000e-2 * t93
  t108 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t79
  t110 = 0.13502664484515602222625000000000000000000000000000e1 - 0.13465921726261020182291666666666666666666666666667e-1 * t41 + 0.20748619661467272631250000000000000000000000000000e0 * t77 - 0.32121495135261672812500000000000000000000000000000e-1 * t80 - 0.28551704175417885000000000000000000000000000000000e-1 * t83 + 0.29439726278665657500000000000000000000000000000000e-1 * t82 - 0.58828844909941371000000000000000000000000000000000e-2 * t79 - 0.67464548655177289687500000000000000000000000000000e-1 * t87 + 0.87534515809640139187500000000000000000000000000000e-1 * t89 - 0.15887583418757175562500000000000000000000000000000e-1 * t95 + 0.74168801870361915625000000000000000000000000000000e-2 * t97 + 0.15682422300093093187500000000000000000000000000000e-1 * t99 - 0.1047053293912749375000000000000000000000000000000e-2 * t94 - 0.37102687351218925312500000000000000000000000000000e0 * t93 + 0.22419222998949863625000000000000000000000000000000e-1 * t103 + t106 * t108
  t112 = 0.71898032915134300000000000000000000000000000000000e-2 - 0.21569409874540290000000000000000000000000000000000e-1 * t93
  t115 = 0.16168039285199133333333333333333333333333333333333e-3 * t41 - 0.1940164714223896e-2
  t120 = 0.429e3 / 0.16e2 * t87 - 0.693e3 / 0.16e2 * t89 + 0.315e3 / 0.16e2 * t80 - 0.35e2 / 0.16e2 * t77
  t124 = 0.51385823829655125000000000000000000000000000000000e-4 + 0.59950127801264312500000000000000000000000000000000e-3 * t94 - 0.51385823829655125000000000000000000000000000000000e-3 * t93
  t128 = 0.63120565750733737500000000000000000000000000000000e-2 + 0.73640660042522693750000000000000000000000000000000e-1 * t94 - 0.63120565750733737500000000000000000000000000000000e-1 * t93
  t132 = 0.10781029398107630000000000000000000000000000000000e-2 * t97 - 0.53905146990538150000000000000000000000000000000000e-4 * t41 + 0.64686176388645780000000000000000000000000000000000e-3
  t136 = -0.15146242085440145000000000000000000000000000000000e-2 * t97 + 0.75731210427200725000000000000000000000000000000000e-4 * t41 - 0.90877452512640870000000000000000000000000000000000e-3
  t140 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t83 - 0.315e3 / 0.16e2 * t82 + 0.105e3 / 0.16e2 * t79
  t144 = 0.41822647701582425000000000000000000000000000000000e-3 * t97 - 0.20911323850791212500000000000000000000000000000000e-4 * t41 + 0.25093588620949455000000000000000000000000000000000e-3
  t148 = 0.63e2 / 0.8e1 * t89 - 0.35e2 / 0.4e1 * t80 + 0.15e2 / 0.8e1 * t77
  t152 = -0.62373763763686625000000000000000000000000000000000e-2 * t97 + 0.31186881881843312500000000000000000000000000000000e-3 * t41 - 0.37424258258211975000000000000000000000000000000000e-2
  t155 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t82 - 0.15e2 / 0.4e1 * t79
  t159 = 0.92819654283026075000000000000000000000000000000000e-2 * t97 - 0.46409827141513037500000000000000000000000000000000e-3 * t41 + 0.55691792569815645000000000000000000000000000000000e-2
  t162 = 0.5e1 / 0.2e1 * t80 - 0.3e1 / 0.2e1 * t77
  t166 = -0.17725742033028110000000000000000000000000000000000e-2 * t97 + 0.88628710165140550000000000000000000000000000000000e-4 * t41 - 0.10635445219816866000000000000000000000000000000000e-2
  t170 = -0.25764285735652700000000000000000000000000000000000e-1 * t97 + 0.12882142867826350000000000000000000000000000000000e-2 * t41 - 0.15458571441391620000000000000000000000000000000000e-1
  t173 = 0.58780723837921150000000000000000000000000000000000e-3 - 0.17634217151376345000000000000000000000000000000000e-2 * t93
  t176 = 0.64415306363980850000000000000000000000000000000000e-3 - 0.19324591909194255000000000000000000000000000000000e-2 * t93
  t179 = 0.59483415247570650000000000000000000000000000000000e-3 - 0.17845024574271195000000000000000000000000000000000e-2 * t93
  t182 = 0.93194144050512400000000000000000000000000000000000e-3 - 0.27958243215153720000000000000000000000000000000000e-2 * t93
  t185 = 0.48206856497539165000000000000000000000000000000000e-3 - 0.14462056949261749500000000000000000000000000000000e-2 * t93
  t187 = t124 * t108 + t166 * t108 + t112 * t77 + t115 * t120 + t132 * t120 + t173 * t120 + t128 * t77 + t136 * t140 + t176 * t140 + t144 * t148 + t179 * t148 + t152 * t155 + t182 * t155 + t159 * t162 + t185 * t162 + t170 * t77
  t192 = -0.46225592311189536000000000000000000000000000000000e-2 * t95 + 0.51361769234655040000000000000000000000000000000000e-2 * t97 - 0.91717445061884000000000000000000000000000000000000e-4 * t41 + 0.11006093407426080000000000000000000000000000000000e-2
  t197 = -0.79536024504265376250000000000000000000000000000000e-2 * t95 + 0.88373360560294862500000000000000000000000000000000e-2 * t97 - 0.15780957242909796875000000000000000000000000000000e-3 * t41 + 0.18937148691491756250000000000000000000000000000000e-2
  t202 = 0.17820228716880565500000000000000000000000000000000e-2 * t95 - 0.19800254129867295000000000000000000000000000000000e-2 * t97 + 0.35357596660477312500000000000000000000000000000000e-4 * t41 - 0.42429115992572775000000000000000000000000000000000e-3
  t207 = 0.52532932717643702625000000000000000000000000000000e-1 * t95 - 0.58369925241826336250000000000000000000000000000000e-1 * t97 + 0.10423200936040417187500000000000000000000000000000e-2 * t41 - 0.12507841123248500625000000000000000000000000000000e-1
  t212 = -0.20296500388975755000000000000000000000000000000000e-2 * t95 + 0.22551667098861950000000000000000000000000000000000e-2 * t97 - 0.40270834105110625000000000000000000000000000000000e-4 * t41 + 0.48325000926132750000000000000000000000000000000000e-3
  t216 = 0.12048536779195098750000000000000000000000000000000e-5 + 0.14056626242394281875000000000000000000000000000000e-4 * t94 - 0.12048536779195098750000000000000000000000000000000e-4 * t93
  t220 = 0.10410225900262143750000000000000000000000000000000e-3 + 0.12145263550305834375000000000000000000000000000000e-2 * t94 - 0.10410225900262143750000000000000000000000000000000e-2 * t93
  t224 = -0.10207381878334642500000000000000000000000000000000e-3 - 0.11908612191390416250000000000000000000000000000000e-2 * t94 + 0.10207381878334642500000000000000000000000000000000e-2 * t93
  t228 = 0.15704354653915893750000000000000000000000000000000e-3 + 0.18321747096235209375000000000000000000000000000000e-2 * t94 - 0.15704354653915893750000000000000000000000000000000e-2 * t93
  t232 = 0.48092694478903650000000000000000000000000000000000e-3 + 0.56108143558720925000000000000000000000000000000000e-2 * t94 - 0.48092694478903650000000000000000000000000000000000e-2 * t93
  t237 = -0.13315182537504496875000000000000000000000000000000e-3 + 0.61516143323270775562500000000000000000000000000000e-2 * t103 - 0.83885649986278330312500000000000000000000000000000e-2 * t94 + 0.27961883328759443437500000000000000000000000000000e-2 * t93
  t242 = -0.35515182034202656250000000000000000000000000000000e-3 + 0.16408014099801627187500000000000000000000000000000e-1 * t103 - 0.22374564681547673437500000000000000000000000000000e-1 * t94 + 0.74581882271825578125000000000000000000000000000000e-2 * t93
  t247 = -0.13219576250814071875000000000000000000000000000000e-3 + 0.61074442278761012062500000000000000000000000000000e-2 * t103 - 0.83283330380128652812500000000000000000000000000000e-2 * t94 + 0.27761110126709550937500000000000000000000000000000e-2 * t93
  t252 = 0.20343974632767893750000000000000000000000000000000e-2 - 0.93989162803387669125000000000000000000000000000000e-1 * t103 + 0.12816704018643773062500000000000000000000000000000e0 * t94 - 0.42722346728812576875000000000000000000000000000000e-1 * t93
  t257 = 0.17181602881768140625000000000000000000000000000000e-2 - 0.79379005313768809687500000000000000000000000000000e-1 * t103 + 0.10824409815513928593750000000000000000000000000000e0 * t94 - 0.36081366051713095312500000000000000000000000000000e-1 * t93
  t262 = -0.72956774270285406250000000000000000000000000000000e-3 + 0.33706029712871857687500000000000000000000000000000e-1 * t103 - 0.45962767790279805937500000000000000000000000000000e-1 * t94 + 0.15320922596759935312500000000000000000000000000000e-1 * t93
  t264 = t207 * t108 + t257 * t108 + t216 * t120 + t220 * t140 + t237 * t140 + t192 * t148 + t224 * t148 + t242 * t148 + t197 * t155 + t228 * t155 + t247 * t155 + t202 * t162 + t232 * t162 + t252 * t162 + t212 * t77 + t262 * t77
  t268 = -0.17346732669513426375000000000000000000000000000000e-2 * t95 + 0.19274147410570473750000000000000000000000000000000e-2 * t97 - 0.34418120376018703125000000000000000000000000000000e-4 * t41 + 0.41301744451222443750000000000000000000000000000000e-3
  t273 = -0.12778143453756654750000000000000000000000000000000e-1 * t95 + 0.14197937170840727500000000000000000000000000000000e-1 * t97 - 0.25353459233644156250000000000000000000000000000000e-3 * t41 + 0.30424151080372987500000000000000000000000000000000e-2
  t279 = -0.99085695677764733437500000000000000000000000000000e-2 * t99 + 0.16006150840254303093750000000000000000000000000000e-1 * t95 - 0.72755231092065014062500000000000000000000000000000e-2 * t97 + 0.67365954714875013020833333333333333333333333333333e-4 * t41 - 0.80839145657850015625000000000000000000000000000000e-3
  t285 = -0.98737552282912471500000000000000000000000000000000e-2 * t99 + 0.15949912291855091550000000000000000000000000000000e-1 * t95 - 0.72499601326614052500000000000000000000000000000000e-2 * t97 + 0.67129260487605604166666666666666666666666666666667e-4 * t41 - 0.80555112585126725000000000000000000000000000000000e-3
  t291 = 0.40821338940497436750000000000000000000000000000000e-1 * t99 - 0.65942162903880474750000000000000000000000000000000e-1 * t95 + 0.29973710410854761250000000000000000000000000000000e-1 * t97 - 0.27753435565606260416666666666666666666666666666667e-3 * t41 + 0.33304122678727512500000000000000000000000000000000e-2
  t297 = 0.65892413690753471250000000000000000000000000000000e-1 * t99 - 0.10644159134660176125000000000000000000000000000000e0 * t95 + 0.48382541521182618750000000000000000000000000000000e-1 * t97 - 0.44798649556650572916666666666666666666666666666667e-3 * t41 + 0.53758379467980687500000000000000000000000000000000e-2
  t303 = 0.33336728884482389437500000000000000000000000000000e0 * t99 - 0.53851638967240782937500000000000000000000000000000e0 * t95 + 0.24478017712382174062500000000000000000000000000000e0 * t97 - 0.22664831215168679687500000000000000000000000000000e-2 * t41 + 0.27197797458202415625000000000000000000000000000000e-1
  t309 = 0.38111046826810841812500000000000000000000000000000e-1 * t99 - 0.61563998720232898312500000000000000000000000000000e-1 * t95 + 0.27983635781924044687500000000000000000000000000000e-1 * t97 - 0.25910773872151893229166666666666666666666666666667e-3 * t41 + 0.31092928646582271875000000000000000000000000000000e-2
  t315 = 0.10290575827668764306250000000000000000000000000000e-1 * t99 - 0.16623237875464926956250000000000000000000000000000e-1 * t95 + 0.75560172161204213437500000000000000000000000000000e-2 * t97 - 0.69963122371485382812500000000000000000000000000000e-4 * t41 + 0.83955746845782459375000000000000000000000000000000e-3
  t320 = -0.11897370610471537500000000000000000000000000000000e-3 + 0.54965852220378503250000000000000000000000000000000e-2 * t103 - 0.74953434845970686250000000000000000000000000000000e-2 * t94 + 0.24984478281990228750000000000000000000000000000000e-2 * t93
  t323 = 0.12429895653008616666666666666666666666666666666667e-3 * t41 - 0.1491587478361034e-2
  t326 = 0.98280297068585083333333333333333333333333333333333e-2 * t41 - 0.1179363564823021e0
  t329 = 0.14955321307203416666666666666666666666666666666667e-3 * t41 - 0.1794638556864410e-2
  t332 = 0.17711102981460050000000000000000000000000000000000e-3 * t41 - 0.2125332357775206e-2
  t335 = 0.24294046008196958333333333333333333333333333333333e-3 * t41 - 0.2915285520983635e-2
  t338 = 0.16727461658817891666666666666666666666666666666667e-3 * t41 - 0.2007295399058147e-2
  t340 = t309 * t108 + t329 * t108 + t268 * t120 + t279 * t120 + t320 * t120 + t273 * t140 + t285 * t140 + t323 * t140 + t291 * t148 + t338 * t148 + t297 * t155 + t335 * t155 + t303 * t162 + t332 * t162 + t315 * t77 + t326 * t77
  t342 = t110 + t187 + t264 + t340
  t346 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t342)
  t352 = t166 * t77
  t357 = 0.1e1 / t30 / t29 / r0
  t363 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t43 * t32 + t34 * t357 / 0.3e1) * t20 * t24
  t364 = f.my_piecewise3(t53, t363, 0)
  t370 = 0.1e1 / t61 / t54
  t374 = t68 * t75
  t375 = f.my_piecewise3(t53, 0, t363)
  t379 = t74 ** 2
  t381 = t69 / t379
  t382 = t66 * t72
  t385 = t66 ** 2
  t386 = t385 * t65
  t392 = f.my_piecewise3(t52, -0.3e1 / 0.2e1 * t59 * t364 - 0.3e1 / 0.16e2 * t62 * t364 + 0.3e1 * t370 * t364, -0.6e1 * t374 * t65 * t375 - t381 * (0.3e1 * t382 * t375 + 0.12e2 * t386 * t375))
  t395 = t124 * t77
  t398 = t207 * t77
  t401 = t257 * t77
  t404 = t309 * t77
  t407 = t329 * t77
  t412 = t26 * t28 * t357 * t39
  t414 = t20 ** 2
  t417 = t414 / t22 / t21
  t418 = s0 ** 2
  t420 = t29 ** 2
  t425 = t38 ** 2
  t426 = 0.1e1 / t425
  t428 = t417 * t418 * t27 / t18 / t420 / t29 * t426
  t430 = -0.2e1 / 0.9e1 * t412 + t428 / 0.54e2
  t431 = t92 * t430
  t436 = t106 * t77
  t449 = 0.3e1 * t352 * t392 + 0.3e1 * t395 * t392 + 0.3e1 * t398 * t392 + 0.3e1 * t401 * t392 + 0.3e1 * t404 * t392 + 0.3e1 * t407 * t392 - 0.28924113898523499000000000000000000000000000000000e-2 * t431 * t162 - 0.34614211374764670000000000000000000000000000000000e-2 * t431 * t108 + 0.3e1 * t436 * t392 - 0.43138819749080580000000000000000000000000000000000e-1 * t431 * t77 - 0.35268434302752690000000000000000000000000000000000e-2 * t431 * t120 - 0.38649183818388510000000000000000000000000000000000e-2 * t431 * t140 - 0.35690049148542390000000000000000000000000000000000e-2 * t431 * t148 - 0.55916486430307440000000000000000000000000000000000e-2 * t431 * t155
  t450 = t95 * t430
  t452 = t97 * t430
  t469 = t80 * t392
  t471 = t77 * t392
  t473 = 0.35e2 / 0.2e1 * t469 - 0.15e2 / 0.2e1 * t471
  t480 = t89 * t392
  t484 = 0.693e3 / 0.8e1 * t480 - 0.315e3 / 0.4e1 * t469 + 0.105e3 / 0.8e1 * t471
  t491 = t82 * t392
  t493 = t79 * t392
  t496 = 0.315e3 / 0.8e1 * t491 - 0.105e3 / 0.4e1 * t493 + 0.15e2 / 0.8e1 * t392
  t498 = t83 * t392
  t503 = 0.3003e4 / 0.16e2 * t498 - 0.3465e4 / 0.16e2 * t491 + 0.945e3 / 0.16e2 * t493 - 0.35e2 / 0.16e2 * t392
  t510 = t103 * t430
  t512 = t94 * t430
  t514 = t93 * t430
  t521 = (-0.47627403188261285812500000000000000000000000000000e0 * t450 + 0.43297639262055714375000000000000000000000000000000e0 * t452 - 0.72162732103426190625000000000000000000000000000000e-1 * t431) * t108 + 0.13451533799369918175000000000000000000000000000000e0 * t450 + (0.20223617827723114612500000000000000000000000000000e0 * t450 - 0.18385107116111922375000000000000000000000000000000e0 * t452 + 0.30641845193519870625000000000000000000000000000000e-1 * t431) * t77 + t262 * t392 + (0.36644665367256607237500000000000000000000000000000e-1 * t450 - 0.33313332152051461125000000000000000000000000000000e-1 * t452 + 0.55522220253419101875000000000000000000000000000000e-2 * t431) * t155 + t247 * t473 + (-0.56393497682032601475000000000000000000000000000000e0 * t450 + 0.51266816074575092250000000000000000000000000000000e0 * t452 - 0.85444693457625153750000000000000000000000000000000e-1 * t431) * t162 + t237 * t484 + (0.98448084598809763125000000000000000000000000000000e-1 * t450 - 0.89498258726190693750000000000000000000000000000000e-1 * t452 + 0.14916376454365115625000000000000000000000000000000e-1 * t431) * t148 + t242 * t496 + t320 * t503 + (0.36909685993962465337500000000000000000000000000000e-1 * t450 - 0.33554259994511332125000000000000000000000000000000e-1 * t452 + 0.55923766657518886875000000000000000000000000000000e-2 * t431) * t140 + (0.26677732778767589268750000000000000000000000000000e0 * t510 - 0.30781999360116449156250000000000000000000000000000e0 * t512 + 0.83950907345772134062500000000000000000000000000000e-1 * t514 + 0.69095396992405048611111111111111111111111111111112e-3 * t412 - 0.57579497493670873842592592592592592592592592592593e-4 * t428) * t108 + 0.10977695610065165231250000000000000000000000000000e0 * t510
  t553 = 0.15e2 / 0.2e1 * t493 - 0.3e1 / 0.2e1 * t392
  t583 = (0.72034030793681350143750000000000000000000000000000e-1 * t510 - 0.83116189377324634781250000000000000000000000000000e-1 * t512 + 0.22668051648361264031250000000000000000000000000000e-1 * t514 + 0.18656832632396102083333333333333333333333333333333e-3 * t412 - 0.15547360526996751736111111111111111111111111111111e-4 * t428) * t77 + t315 * t392 + (0.32979511332227101950000000000000000000000000000000e-1 * t450 - 0.29981373938388274500000000000000000000000000000000e-1 * t452 + 0.49968956563980457500000000000000000000000000000000e-2 * t431) * t120 + (0.46124689583527429875000000000000000000000000000000e0 * t510 - 0.53220795673300880625000000000000000000000000000000e0 * t512 + 0.14514762456354785625000000000000000000000000000000e0 * t514 + 0.11946306548440152777777777777777777777777777777778e-2 * t412 - 0.99552554570334606481481481481481481481481481481482e-4 * t428) * t155 + t297 * t473 + (0.23335710219137672606250000000000000000000000000000e1 * t510 - 0.26925819483620391468750000000000000000000000000000e1 * t512 + 0.73434053137146522187500000000000000000000000000000e0 * t514 + 0.60439549907116479166666666666666666666666666666667e-2 * t412 - 0.50366291589263732638888888888888888888888888888889e-3 * t428) * t162 + t303 * t553 + (0.28574937258348205725000000000000000000000000000000e0 * t510 - 0.32971081451940237375000000000000000000000000000000e0 * t512 + 0.89921131232564283750000000000000000000000000000000e-1 * t514 + 0.74009161508283361111111111111111111111111111111112e-3 * t412 - 0.61674301256902800925925925925925925925925925925927e-4 * t428) * t148 + t291 * t496 + (-0.69116286598038730050000000000000000000000000000000e-1 * t510 + 0.79749561459275457750000000000000000000000000000000e-1 * t512 - 0.21749880397984215750000000000000000000000000000000e-1 * t514 - 0.17901136130028161111111111111111111111111111111111e-3 * t412 + 0.14917613441690134259259259259259259259259259259259e-4 * t428) * t140 + t285 * t484 + (-0.69359986974435313406250000000000000000000000000000e-1 * t510 + 0.80030754201271515468750000000000000000000000000000e-1 * t512 - 0.21826569327619504218750000000000000000000000000000e-1 * t514 - 0.17964254590633336805555555555555555555555555555555e-3 * t412 + 0.14970212158861114004629629629629629629629629629630e-4 * t428) * t120 + t279 * t503 + (-0.44606564423514377777777777777777777777777777777779e-3 * t412 + 0.37172137019595314814814814814814814814814814814816e-4 * t428) * t148
  t616 = t338 * t496 + (-0.47229607950560133333333333333333333333333333333333e-3 * t412 + 0.39358006625466777777777777777777777777777777777778e-4 * t428) * t162 + t332 * t553 + (-0.64784122688525222222222222222222222222222222222221e-3 * t412 + 0.53986768907104351851851851851851851851851851851851e-4 * t428) * t155 + t335 * t473 + (-0.26208079218289355555555555555555555555555555555555e-1 * t412 + 0.21840066015241129629629629629629629629629629629630e-2 * t428) * t77 + t326 * t392 + (-0.39880856819209111111111111111111111111111111111112e-3 * t412 + 0.33234047349340925925925925925925925925925925925927e-4 * t428) * t108 + (-0.33146388408022977777777777777777777777777777777779e-3 * t412 + 0.27621990340019148148148148148148148148148148148149e-4 * t428) * t140 + t323 * t484 + t112 * t392 + (-0.43114771427197688888888888888888888888888888888888e-3 * t412 + 0.35928976189331407407407407407407407407407407407407e-4 * t428) * t120 + t115 * t503 + t185 * t553
  t657 = t179 * t496 + t182 * t473 + t176 * t484 + (-0.53177226099084330000000000000000000000000000000000e-2 * t514 - 0.23634322710704146666666666666666666666666666666667e-3 * t412 + 0.19695268925586788888888888888888888888888888888889e-4 * t428) * t108 + (-0.77292857206958100000000000000000000000000000000000e-1 * t514 - 0.34352380980870266666666666666666666666666666666667e-2 * t412 + 0.28626984150725222222222222222222222222222222222222e-3 * t428) * t77 + t170 * t392 + t173 * t503 + (-0.18712129129105987500000000000000000000000000000000e-1 * t514 - 0.83165018351582166666666666666666666666666666666667e-3 * t412 + 0.69304181959651805555555555555555555555555555555555e-4 * t428) * t155 + t152 * t473 + (0.27845896284907822500000000000000000000000000000000e-1 * t514 + 0.12375953904403476666666666666666666666666666666667e-2 * t412 - 0.10313294920336230555555555555555555555555555555556e-3 * t428) * t162 + t159 * t553 + (0.12546794310474727500000000000000000000000000000000e-2 * t514 + 0.55763530268776566666666666666666666666666666666667e-4 * t412 - 0.46469608557313805555555555555555555555555555555556e-5 * t428) * t148 + t144 * t496 + (0.32343088194322890000000000000000000000000000000000e-2 * t514 + 0.14374705864143506666666666666666666666666666666667e-3 * t412 - 0.11978921553452922222222222222222222222222222222222e-4 * t428) * t120
  t693 = t132 * t503 + (-0.45438726256320435000000000000000000000000000000000e-2 * t514 - 0.20194989447253526666666666666666666666666666666667e-3 * t412 + 0.16829157872711272222222222222222222222222222222222e-4 * t428) * t140 + t136 * t484 + t232 * t553 + (0.23980051120505725000000000000000000000000000000000e-2 * t452 - 0.10277164765931025000000000000000000000000000000000e-2 * t431) * t108 + (0.29456264017009077500000000000000000000000000000000e0 * t452 - 0.12624113150146747500000000000000000000000000000000e0 * t431) * t77 + t128 * t392 + (0.73286988384940837500000000000000000000000000000000e-2 * t452 - 0.31408709307831787500000000000000000000000000000000e-2 * t431) * t155 + t228 * t473 + (0.22443257423488370000000000000000000000000000000000e-1 * t452 - 0.96185388957807300000000000000000000000000000000000e-2 * t431) * t162 + 0.35909124603362720486111111111111111111111111111112e-1 * t412 - 0.29924270502802267071759259259259259259259259259260e-2 * t428 + 0.20748619661467272631250000000000000000000000000000e0 * t392 + (-0.63890717268783273750000000000000000000000000000000e-1 * t512 + 0.42593811512522182500000000000000000000000000000000e-1 * t514 + 0.67609224623051083333333333333333333333333333333333e-3 * t412 - 0.56341020519209236111111111111111111111111111111111e-4 * t428) * t140
  t734 = t273 * t484 + (-0.23112796155594768000000000000000000000000000000000e-1 * t512 + 0.15408530770396512000000000000000000000000000000000e-1 * t514 + 0.24457985349835733333333333333333333333333333333333e-3 * t412 - 0.20381654458196444444444444444444444444444444444444e-4 * t428) * t148 + t192 * t496 + (-0.86733663347567131875000000000000000000000000000000e-2 * t512 + 0.57822442231711421250000000000000000000000000000000e-2 * t514 + 0.91781654336049875000000000000000000000000000000000e-4 * t412 - 0.76484711946708229166666666666666666666666666666667e-5 * t428) * t120 + t268 * t503 + t252 * t553 + t202 * t553 + (0.26266466358821851312500000000000000000000000000000e0 * t512 - 0.17510977572547900875000000000000000000000000000000e0 * t514 - 0.27795202496107779166666666666666666666666666666667e-2 * t412 + 0.23162668746756482638888888888888888888888888888889e-3 * t428) * t108 - 0.79437917093785877812500000000000000000000000000000e-1 * t512 + 0.22250640561108574687500000000000000000000000000000e-1 * t514 + (-0.10148250194487877500000000000000000000000000000000e-1 * t512 + 0.67655001296585850000000000000000000000000000000000e-2 * t514 + 0.10738889094696166666666666666666666666666666666667e-3 * t412 - 0.89490742455801388888888888888888888888888888888889e-5 * t428) * t77 + t212 * t392 + (-0.39768012252132688125000000000000000000000000000000e-1 * t512 + 0.26512008168088458750000000000000000000000000000000e-1 * t514 + 0.42082552647759458333333333333333333333333333333333e-3 * t412 - 0.35068793873132881944444444444444444444444444444444e-4 * t428) * t155 + t197 * t473
  t764 = (0.89101143584402827500000000000000000000000000000000e-2 * t512 - 0.59400762389601885000000000000000000000000000000000e-2 * t514 - 0.94286924427939500000000000000000000000000000000000e-4 * t412 + 0.78572437023282916666666666666666666666666666666667e-5 * t428) * t162 + t220 * t484 - 0.17131022505250731000000000000000000000000000000000e0 * t480 + 0.11775890511466263000000000000000000000000000000000e0 * t469 - 0.11765768981988274200000000000000000000000000000000e-1 * t471 + (-0.47634448765561665000000000000000000000000000000000e-2 * t452 + 0.20414763756669285000000000000000000000000000000000e-2 * t431) * t148 - 0.4188213175650997500000000000000000000000000000000e-2 * t452 - 0.74205374702437850625000000000000000000000000000000e0 * t431 + 0.43767257904820069593750000000000000000000000000000e0 * t491 - 0.96364485405785018437500000000000000000000000000000e-1 * t493 + t224 * t496 + (0.56226504969577127500000000000000000000000000000000e-4 * t452 - 0.24097073558390197500000000000000000000000000000000e-4 * t431) * t120 - 0.47225184058624102781250000000000000000000000000000e0 * t498 + t216 * t503 + (0.48581054201223337500000000000000000000000000000000e-2 * t452 - 0.20820451800524287500000000000000000000000000000000e-2 * t431) * t140
  t772 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t342 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t449 + t521 + t583 + t616 + t657 + t693 + t734 + t764))
  vrho_0_ = 0.2e1 * r0 * t772 + 0.2e1 * t346
  t775 = t25 * t40
  t783 = t417 * s0 * t27 / t18 / t420 / r0 * t426
  t788 = 0.5e1 / 0.72e2 * t25 * t33
  t789 = f.my_piecewise3(t53, -t788, 0)
  t797 = f.my_piecewise3(t53, 0, -t788)
  t808 = f.my_piecewise3(t52, -0.3e1 / 0.2e1 * t59 * t789 - 0.3e1 / 0.16e2 * t62 * t789 + 0.3e1 * t370 * t789, -0.6e1 * t374 * t65 * t797 - t381 * (0.3e1 * t382 * t797 + 0.12e2 * t386 * t797))
  t809 = t83 * t808
  t811 = t82 * t808
  t813 = t79 * t808
  t816 = 0.3003e4 / 0.16e2 * t809 - 0.3465e4 / 0.16e2 * t811 + 0.945e3 / 0.16e2 * t813 - 0.35e2 / 0.16e2 * t808
  t823 = 0.15e2 / 0.2e1 * t813 - 0.3e1 / 0.2e1 * t808
  t828 = 0.315e3 / 0.8e1 * t811 - 0.105e3 / 0.4e1 * t813 + 0.15e2 / 0.8e1 * t808
  t830 = t80 * t808
  t832 = t77 * t808
  t834 = 0.35e2 / 0.2e1 * t830 - 0.15e2 / 0.2e1 * t832
  t838 = t89 * t808
  t842 = 0.693e3 / 0.8e1 * t838 - 0.315e3 / 0.4e1 * t830 + 0.105e3 / 0.8e1 * t832
  t847 = t775 / 0.12e2 - t783 / 0.144e3
  t848 = t93 * t847
  t855 = (0.16168039285199133333333333333333333333333333333333e-3 * t775 - 0.13473366070999277777777777777777777777777777777777e-4 * t783) * t120 + t115 * t816 - 0.47225184058624102781250000000000000000000000000000e0 * t809 + 0.43767257904820069593750000000000000000000000000000e0 * t811 - 0.96364485405785018437500000000000000000000000000000e-1 * t813 + t185 * t823 + t179 * t828 + t182 * t834 + 0.11775890511466263000000000000000000000000000000000e0 * t830 - 0.11765768981988274200000000000000000000000000000000e-1 * t832 + t176 * t842 - 0.17131022505250731000000000000000000000000000000000e0 * t838 + (-0.77292857206958100000000000000000000000000000000000e-1 * t848 + 0.12882142867826350000000000000000000000000000000000e-2 * t775 - 0.10735119056521958333333333333333333333333333333333e-3 * t783) * t77 + 0.22250640561108574687500000000000000000000000000000e-1 * t848
  t859 = t97 * t847
  t861 = t92 * t847
  t890 = t170 * t808 + t173 * t816 + t136 * t842 + (0.23980051120505725000000000000000000000000000000000e-2 * t859 - 0.10277164765931025000000000000000000000000000000000e-2 * t861) * t108 - 0.4188213175650997500000000000000000000000000000000e-2 * t859 - 0.74205374702437850625000000000000000000000000000000e0 * t861 + (0.29456264017009077500000000000000000000000000000000e0 * t859 - 0.12624113150146747500000000000000000000000000000000e0 * t861) * t77 + t128 * t808 + (0.32343088194322890000000000000000000000000000000000e-2 * t848 - 0.53905146990538150000000000000000000000000000000000e-4 * t775 + 0.44920955825448458333333333333333333333333333333333e-5 * t783) * t120 + t132 * t816 + (-0.18712129129105987500000000000000000000000000000000e-1 * t848 + 0.31186881881843312500000000000000000000000000000000e-3 * t775 - 0.25989068234869427083333333333333333333333333333333e-4 * t783) * t155 + t152 * t834 + (0.27845896284907822500000000000000000000000000000000e-1 * t848 - 0.46409827141513037500000000000000000000000000000000e-3 * t775 + 0.38674855951260864583333333333333333333333333333333e-4 * t783) * t162 + t159 * t823
  t928 = t94 * t847
  t936 = (-0.53177226099084330000000000000000000000000000000000e-2 * t848 + 0.88628710165140550000000000000000000000000000000000e-4 * t775 - 0.73857258470950458333333333333333333333333333333333e-5 * t783) * t108 + (0.12546794310474727500000000000000000000000000000000e-2 * t848 - 0.20911323850791212500000000000000000000000000000000e-4 * t775 + 0.17426103208992677083333333333333333333333333333333e-5 * t783) * t148 + t144 * t828 + (-0.45438726256320435000000000000000000000000000000000e-2 * t848 + 0.75731210427200725000000000000000000000000000000000e-4 * t775 - 0.63109342022667270833333333333333333333333333333333e-5 * t783) * t140 + (0.73286988384940837500000000000000000000000000000000e-2 * t859 - 0.31408709307831787500000000000000000000000000000000e-2 * t861) * t155 + t228 * t834 + (0.22443257423488370000000000000000000000000000000000e-1 * t859 - 0.96185388957807300000000000000000000000000000000000e-2 * t861) * t162 + t232 * t823 + (-0.47634448765561665000000000000000000000000000000000e-2 * t859 + 0.20414763756669285000000000000000000000000000000000e-2 * t861) * t148 + t224 * t828 + (0.48581054201223337500000000000000000000000000000000e-2 * t859 - 0.20820451800524287500000000000000000000000000000000e-2 * t861) * t140 + t220 * t842 + (0.26266466358821851312500000000000000000000000000000e0 * t928 - 0.17510977572547900875000000000000000000000000000000e0 * t848 + 0.10423200936040417187500000000000000000000000000000e-2 * t775 - 0.86860007800336809895833333333333333333333333333333e-4 * t783) * t108 - 0.79437917093785877812500000000000000000000000000000e-1 * t928
  t977 = t95 * t847
  t984 = (-0.10148250194487877500000000000000000000000000000000e-1 * t928 + 0.67655001296585850000000000000000000000000000000000e-2 * t848 - 0.40270834105110625000000000000000000000000000000000e-4 * t775 + 0.33559028420925520833333333333333333333333333333333e-5 * t783) * t77 + t212 * t808 + (0.56226504969577127500000000000000000000000000000000e-4 * t859 - 0.24097073558390197500000000000000000000000000000000e-4 * t861) * t120 + t216 * t816 + (-0.39768012252132688125000000000000000000000000000000e-1 * t928 + 0.26512008168088458750000000000000000000000000000000e-1 * t848 - 0.15780957242909796875000000000000000000000000000000e-3 * t775 + 0.13150797702424830729166666666666666666666666666667e-4 * t783) * t155 + t197 * t834 + (0.89101143584402827500000000000000000000000000000000e-2 * t928 - 0.59400762389601885000000000000000000000000000000000e-2 * t848 + 0.35357596660477312500000000000000000000000000000000e-4 * t775 - 0.29464663883731093750000000000000000000000000000000e-5 * t783) * t162 + t202 * t823 + (-0.23112796155594768000000000000000000000000000000000e-1 * t928 + 0.15408530770396512000000000000000000000000000000000e-1 * t848 - 0.91717445061884000000000000000000000000000000000000e-4 * t775 + 0.76431204218236666666666666666666666666666666666667e-5 * t783) * t148 + t192 * t828 + (-0.63890717268783273750000000000000000000000000000000e-1 * t928 + 0.42593811512522182500000000000000000000000000000000e-1 * t848 - 0.25353459233644156250000000000000000000000000000000e-3 * t775 + 0.21127882694703463541666666666666666666666666666667e-4 * t783) * t140 + t273 * t842 + (-0.47627403188261285812500000000000000000000000000000e0 * t977 + 0.43297639262055714375000000000000000000000000000000e0 * t859 - 0.72162732103426190625000000000000000000000000000000e-1 * t861) * t108 + 0.13451533799369918175000000000000000000000000000000e0 * t977
  t1016 = (0.20223617827723114612500000000000000000000000000000e0 * t977 - 0.18385107116111922375000000000000000000000000000000e0 * t859 + 0.30641845193519870625000000000000000000000000000000e-1 * t861) * t77 + t262 * t808 - 0.13465921726261020182291666666666666666666666666667e-1 * t775 + 0.3e1 * t398 * t808 + 0.3e1 * t401 * t808 + 0.3e1 * t404 * t808 + 0.3e1 * t407 * t808 - 0.38649183818388510000000000000000000000000000000000e-2 * t861 * t140 - 0.35690049148542390000000000000000000000000000000000e-2 * t861 * t148 - 0.55916486430307440000000000000000000000000000000000e-2 * t861 * t155 - 0.28924113898523499000000000000000000000000000000000e-2 * t861 * t162 - 0.34614211374764670000000000000000000000000000000000e-2 * t861 * t108 + 0.3e1 * t436 * t808 - 0.43138819749080580000000000000000000000000000000000e-1 * t861 * t77
  t1054 = t103 * t847
  t1062 = 0.3e1 * t352 * t808 - 0.35268434302752690000000000000000000000000000000000e-2 * t861 * t120 + 0.3e1 * t395 * t808 + (-0.86733663347567131875000000000000000000000000000000e-2 * t928 + 0.57822442231711421250000000000000000000000000000000e-2 * t848 - 0.34418120376018703125000000000000000000000000000000e-4 * t775 + 0.28681766980015585937500000000000000000000000000000e-5 * t783) * t120 + t268 * t816 + (0.36644665367256607237500000000000000000000000000000e-1 * t977 - 0.33313332152051461125000000000000000000000000000000e-1 * t859 + 0.55522220253419101875000000000000000000000000000000e-2 * t861) * t155 + t247 * t834 + (-0.56393497682032601475000000000000000000000000000000e0 * t977 + 0.51266816074575092250000000000000000000000000000000e0 * t859 - 0.85444693457625153750000000000000000000000000000000e-1 * t861) * t162 + t252 * t823 + (0.98448084598809763125000000000000000000000000000000e-1 * t977 - 0.89498258726190693750000000000000000000000000000000e-1 * t859 + 0.14916376454365115625000000000000000000000000000000e-1 * t861) * t148 + t242 * t828 + (0.36909685993962465337500000000000000000000000000000e-1 * t977 - 0.33554259994511332125000000000000000000000000000000e-1 * t859 + 0.55923766657518886875000000000000000000000000000000e-2 * t861) * t140 + t237 * t842 + (0.72034030793681350143750000000000000000000000000000e-1 * t1054 - 0.83116189377324634781250000000000000000000000000000e-1 * t928 + 0.22668051648361264031250000000000000000000000000000e-1 * t848 - 0.69963122371485382812500000000000000000000000000000e-4 * t775 + 0.58302601976237819010416666666666666666666666666667e-5 * t783) * t77
  t1118 = 0.10977695610065165231250000000000000000000000000000e0 * t1054 + t315 * t808 + (0.32979511332227101950000000000000000000000000000000e-1 * t977 - 0.29981373938388274500000000000000000000000000000000e-1 * t859 + 0.49968956563980457500000000000000000000000000000000e-2 * t861) * t120 + t320 * t816 + (0.23335710219137672606250000000000000000000000000000e1 * t1054 - 0.26925819483620391468750000000000000000000000000000e1 * t928 + 0.73434053137146522187500000000000000000000000000000e0 * t848 - 0.22664831215168679687500000000000000000000000000000e-2 * t775 + 0.18887359345973899739583333333333333333333333333333e-3 * t783) * t162 + t303 * t823 + (0.26677732778767589268750000000000000000000000000000e0 * t1054 - 0.30781999360116449156250000000000000000000000000000e0 * t928 + 0.83950907345772134062500000000000000000000000000000e-1 * t848 - 0.25910773872151893229166666666666666666666666666667e-3 * t775 + 0.21592311560126577690972222222222222222222222222222e-4 * t783) * t108 + t291 * t828 + (0.46124689583527429875000000000000000000000000000000e0 * t1054 - 0.53220795673300880625000000000000000000000000000000e0 * t928 + 0.14514762456354785625000000000000000000000000000000e0 * t848 - 0.44798649556650572916666666666666666666666666666667e-3 * t775 + 0.37332207963875477430555555555555555555555555555556e-4 * t783) * t155 + t297 * t834 + (-0.69116286598038730050000000000000000000000000000000e-1 * t1054 + 0.79749561459275457750000000000000000000000000000000e-1 * t928 - 0.21749880397984215750000000000000000000000000000000e-1 * t848 + 0.67129260487605604166666666666666666666666666666667e-4 * t775 - 0.55941050406338003472222222222222222222222222222222e-5 * t783) * t140 + t285 * t842 + (0.28574937258348205725000000000000000000000000000000e0 * t1054 - 0.32971081451940237375000000000000000000000000000000e0 * t928 + 0.89921131232564283750000000000000000000000000000000e-1 * t848 - 0.27753435565606260416666666666666666666666666666667e-3 * t775 + 0.23127862971338550347222222222222222222222222222222e-4 * t783) * t148 + (-0.69359986974435313406250000000000000000000000000000e-1 * t1054 + 0.80030754201271515468750000000000000000000000000000e-1 * t928 - 0.21826569327619504218750000000000000000000000000000e-1 * t848 + 0.67365954714875013020833333333333333333333333333333e-4 * t775 - 0.56138295595729177517361111111111111111111111111111e-5 * t783) * t120
  t1152 = t279 * t816 + (0.16727461658817891666666666666666666666666666666667e-3 * t775 - 0.13939551382348243055555555555555555555555555555556e-4 * t783) * t148 + t338 * t828 + (0.24294046008196958333333333333333333333333333333333e-3 * t775 - 0.20245038340164131944444444444444444444444444444444e-4 * t783) * t155 + t335 * t834 + (0.98280297068585083333333333333333333333333333333333e-2 * t775 - 0.81900247557154236111111111111111111111111111111111e-3 * t783) * t77 + t326 * t808 + (0.14955321307203416666666666666666666666666666666667e-3 * t775 - 0.12462767756002847222222222222222222222222222222222e-4 * t783) * t108 + (0.17711102981460050000000000000000000000000000000000e-3 * t775 - 0.14759252484550041666666666666666666666666666666667e-4 * t783) * t162 + t332 * t823 + (0.12429895653008616666666666666666666666666666666667e-3 * t775 - 0.10358246377507180555555555555555555555555555555556e-4 * t783) * t140 + t323 * t842 + t112 * t808 + 0.20748619661467272631250000000000000000000000000000e0 * t808 + 0.11221601438550850151909722222222222222222222222222e-2 * t783
  t1159 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t855 + t890 + t936 + t984 + t1016 + t1062 + t1118 + t1152))
  vsigma_0_ = 0.2e1 * r0 * t1159
  vlapl_0_ = 0.0e0
  t1163 = 0.5e1 / 0.9e1 * t28 * t45 * t25
  t1164 = f.my_piecewise3(t53, t1163, 0)
  t1172 = f.my_piecewise3(t53, 0, t1163)
  t1183 = f.my_piecewise3(t52, -0.3e1 / 0.2e1 * t59 * t1164 - 0.3e1 / 0.16e2 * t62 * t1164 + 0.3e1 * t370 * t1164, -0.6e1 * t374 * t65 * t1172 - t381 * (0.3e1 * t382 * t1172 + 0.12e2 * t386 * t1172))
  t1199 = t79 * t1183
  t1202 = 0.15e2 / 0.2e1 * t1199 - 0.3e1 / 0.2e1 * t1183
  t1205 = t82 * t1183
  t1209 = 0.315e3 / 0.8e1 * t1205 - 0.105e3 / 0.4e1 * t1199 + 0.15e2 / 0.8e1 * t1183
  t1212 = t80 * t1183
  t1214 = t77 * t1183
  t1216 = 0.35e2 / 0.2e1 * t1212 - 0.15e2 / 0.2e1 * t1214
  t1219 = 0.20748619661467272631250000000000000000000000000000e0 * t1183 + 0.3e1 * t407 * t1183 + 0.3e1 * t436 * t1183 + 0.3e1 * t352 * t1183 + 0.3e1 * t395 * t1183 + 0.3e1 * t398 * t1183 + 0.3e1 * t404 * t1183 + 0.3e1 * t401 * t1183 + t303 * t1202 - 0.96364485405785018437500000000000000000000000000000e-1 * t1199 + t338 * t1209 + 0.43767257904820069593750000000000000000000000000000e0 * t1205 + t335 * t1216 + 0.11775890511466263000000000000000000000000000000000e0 * t1212
  t1223 = t89 * t1183
  t1227 = 0.693e3 / 0.8e1 * t1223 - 0.315e3 / 0.4e1 * t1212 + 0.105e3 / 0.8e1 * t1214
  t1231 = t83 * t1183
  t1236 = 0.3003e4 / 0.16e2 * t1231 - 0.3465e4 / 0.16e2 * t1205 + 0.945e3 / 0.16e2 * t1199 - 0.35e2 / 0.16e2 * t1183
  t1245 = -0.11765768981988274200000000000000000000000000000000e-1 * t1214 + t326 * t1183 + t332 * t1202 + t323 * t1227 - 0.17131022505250731000000000000000000000000000000000e0 * t1223 + t112 * t1183 + t115 * t1236 - 0.47225184058624102781250000000000000000000000000000e0 * t1231 + t182 * t1216 + t185 * t1202 + t179 * t1209 + t285 * t1227 + t291 * t1209 + t279 * t1236
  t1261 = t128 * t1183 + t170 * t1183 + t212 * t1183 + t159 * t1202 + t232 * t1202 + t144 * t1209 + t224 * t1209 + t152 * t1216 + t228 * t1216 + t136 * t1227 + t176 * t1227 + t220 * t1227 + t132 * t1236 + t173 * t1236
  t1276 = t262 * t1183 + t315 * t1183 + t202 * t1202 + t252 * t1202 + t192 * t1209 + t242 * t1209 + t197 * t1216 + t247 * t1216 + t297 * t1216 + t237 * t1227 + t273 * t1227 + t216 * t1236 + t268 * t1236 + t320 * t1236
  t1282 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t1219 + t1245 + t1261 + t1276))
  vtau_0_ = 0.2e1 * r0 * t1282
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.067841267592822, -0.158722422825204, -0.2372737447003859, 0.002558752743285125, 0.006748483298726394, 0.001199436228162263, 0.001552846614645878, 0.000584892206996479], dtype=np.float64), np.array([np.nan, 0.2032399091383024, 0.1179363564823021, -0.01437960658302686, -0.01030571429426108, 0.01683215086686233, -0.000257733338272708, 0.002334616776649133, 0.0003837976998664341], dtype=np.float64), np.array([np.nan, -0.0006952718706718514, 0.00179463855686441, -0.001153807045825489, -0.0007090296813211244, 0.000137028863545747, 0.006670848599065867, -0.005498112922165805, 0.001421391023843761], dtype=np.float64), np.array([np.nan, -0.002565692477269114, 0.002125332357775206, -0.0009641371299507833, 0.003712786171321043, 0.001282471852770764, 0.0002262886186270548, -0.006510071882485726, 0.01243327883803539], dtype=np.float64), np.array([np.nan, -0.002170152177993684, 0.002915285520983635, -0.001863882881010248, -0.002494950550547465, 0.0004187827907710905, -0.001009981263546227, 0.0004230264400260503, 0.00245752591853626], dtype=np.float64), np.array([np.nan, -0.002723387704355568, 0.002007295399058147, -0.001189668304951413, 0.0001672905908063297, -0.0002721968500889238, -0.0005869916483960576, 0.001136485825094485, 0.001522474179598972], dtype=np.float64), np.array([np.nan, -0.00197760721561336, 0.001491587478361034, -0.001288306127279617, -0.0006058496834176058, 0.0002776060240069905, -0.001622621390953226, 0.0004260858412001439, -0.0003682519432462936], dtype=np.float64), np.array([np.nan, -0.002516160322803815, 0.001940164714223896, -0.001175614476758423, 0.0004312411759243052, 3.212943141118693e-06, -0.0002202759704065197, 0.0003807158595350892, -0.0003695503801501715], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = s0 * t28
  t35 = t34 * t32
  t38 = 0.65124e1 + t25 * t35 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t33 * t39
  t41 = t26 * t40
  t43 = tau0 * t28
  t45 = 0.1e1 / t30 / r0
  t51 = 0.5e1 / 0.9e1 * (t43 * t45 - t35 / 0.8e1) * t20 * t24
  t52 = 0.1e5 <= t51
  t53 = 0.1e5 < t51
  t54 = f.my_piecewise3(t53, t51, 0.1e5)
  t55 = t54 ** 2
  t59 = 0.1e1 / t55 / t54
  t61 = t55 ** 2
  t62 = 0.1e1 / t61
  t65 = f.my_piecewise3(t53, 0.1e5, t51)
  t66 = t65 ** 2
  t67 = 0.1e1 - t66
  t68 = t67 ** 2
  t69 = t68 * t67
  t70 = t66 * t65
  t72 = 0.1e1 + 0.4e1 * t70
  t74 = t70 * t72 + 0.1e1
  t75 = 0.1e1 / t74
  t77 = f.my_piecewise3(t52, 0.3e1 / 0.4e1 / t55 + t59 / 0.16e2 - 0.3e1 / 0.4e1 * t62 - 0.1e1 / 0.4e1, t69 * t75)
  t79 = t77 ** 2
  t80 = t79 * t77
  t81 = t79 ** 2
  t82 = t81 * t80
  t84 = t81 * t77
  t87 = t81 * t79
  t92 = t41 / 0.12e2 - 0.1e1
  t93 = t92 ** 2
  t94 = t93 ** 2
  t95 = t94 * t92
  t97 = t93 * t92
  t99 = t94 * t97
  t103 = t94 * t93
  t107 = 0.15704354653915893750000000000000000000000000000000e-3 + 0.18321747096235209375000000000000000000000000000000e-2 * t94 - 0.15704354653915893750000000000000000000000000000000e-2 * t93
  t110 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t81 - 0.15e2 / 0.4e1 * t79
  t112 = 0.13502664484515602222625000000000000000000000000000e1 - 0.13465921726261020182291666666666666666666666666667e-1 * t41 + 0.20748619661467272631250000000000000000000000000000e0 * t77 - 0.67464548655177289687500000000000000000000000000000e-1 * t82 + 0.87534515809640139187500000000000000000000000000000e-1 * t84 - 0.32121495135261672812500000000000000000000000000000e-1 * t80 - 0.28551704175417885000000000000000000000000000000000e-1 * t87 + 0.29439726278665657500000000000000000000000000000000e-1 * t81 - 0.58828844909941371000000000000000000000000000000000e-2 * t79 - 0.15887583418757175562500000000000000000000000000000e-1 * t95 + 0.74168801870361915625000000000000000000000000000000e-2 * t97 + 0.15682422300093093187500000000000000000000000000000e-1 * t99 - 0.1047053293912749375000000000000000000000000000000e-2 * t94 - 0.37102687351218925312500000000000000000000000000000e0 * t93 + 0.22419222998949863625000000000000000000000000000000e-1 * t103 + t107 * t110
  t115 = 0.48092694478903650000000000000000000000000000000000e-3 + 0.56108143558720925000000000000000000000000000000000e-2 * t94 - 0.48092694478903650000000000000000000000000000000000e-2 * t93
  t118 = 0.5e1 / 0.2e1 * t80 - 0.3e1 / 0.2e1 * t77
  t122 = 0.51385823829655125000000000000000000000000000000000e-4 + 0.59950127801264312500000000000000000000000000000000e-3 * t94 - 0.51385823829655125000000000000000000000000000000000e-3 * t93
  t124 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t79
  t128 = 0.63120565750733737500000000000000000000000000000000e-2 + 0.73640660042522693750000000000000000000000000000000e-1 * t94 - 0.63120565750733737500000000000000000000000000000000e-1 * t93
  t132 = 0.10781029398107630000000000000000000000000000000000e-2 * t97 - 0.53905146990538150000000000000000000000000000000000e-4 * t41 + 0.64686176388645780000000000000000000000000000000000e-3
  t137 = 0.429e3 / 0.16e2 * t82 - 0.693e3 / 0.16e2 * t84 + 0.315e3 / 0.16e2 * t80 - 0.35e2 / 0.16e2 * t77
  t141 = -0.15146242085440145000000000000000000000000000000000e-2 * t97 + 0.75731210427200725000000000000000000000000000000000e-4 * t41 - 0.90877452512640870000000000000000000000000000000000e-3
  t145 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t87 - 0.315e3 / 0.16e2 * t81 + 0.105e3 / 0.16e2 * t79
  t149 = 0.41822647701582425000000000000000000000000000000000e-3 * t97 - 0.20911323850791212500000000000000000000000000000000e-4 * t41 + 0.25093588620949455000000000000000000000000000000000e-3
  t153 = 0.63e2 / 0.8e1 * t84 - 0.35e2 / 0.4e1 * t80 + 0.15e2 / 0.8e1 * t77
  t157 = -0.62373763763686625000000000000000000000000000000000e-2 * t97 + 0.31186881881843312500000000000000000000000000000000e-3 * t41 - 0.37424258258211975000000000000000000000000000000000e-2
  t161 = 0.92819654283026075000000000000000000000000000000000e-2 * t97 - 0.46409827141513037500000000000000000000000000000000e-3 * t41 + 0.55691792569815645000000000000000000000000000000000e-2
  t165 = -0.17725742033028110000000000000000000000000000000000e-2 * t97 + 0.88628710165140550000000000000000000000000000000000e-4 * t41 - 0.10635445219816866000000000000000000000000000000000e-2
  t169 = -0.25764285735652700000000000000000000000000000000000e-1 * t97 + 0.12882142867826350000000000000000000000000000000000e-2 * t41 - 0.15458571441391620000000000000000000000000000000000e-1
  t172 = 0.58780723837921150000000000000000000000000000000000e-3 - 0.17634217151376345000000000000000000000000000000000e-2 * t93
  t175 = 0.64415306363980850000000000000000000000000000000000e-3 - 0.19324591909194255000000000000000000000000000000000e-2 * t93
  t178 = 0.59483415247570650000000000000000000000000000000000e-3 - 0.17845024574271195000000000000000000000000000000000e-2 * t93
  t181 = 0.93194144050512400000000000000000000000000000000000e-3 - 0.27958243215153720000000000000000000000000000000000e-2 * t93
  t184 = 0.48206856497539165000000000000000000000000000000000e-3 - 0.14462056949261749500000000000000000000000000000000e-2 * t93
  t187 = 0.57690352291274450000000000000000000000000000000000e-3 - 0.17307105687382335000000000000000000000000000000000e-2 * t93
  t189 = t157 * t110 + t181 * t110 + t115 * t118 + t161 * t118 + t184 * t118 + t122 * t124 + t165 * t124 + t187 * t124 + t128 * t77 + t132 * t137 + t172 * t137 + t141 * t145 + t175 * t145 + t149 * t153 + t178 * t153 + t169 * t77
  t192 = 0.71898032915134300000000000000000000000000000000000e-2 - 0.21569409874540290000000000000000000000000000000000e-1 * t93
  t195 = 0.16168039285199133333333333333333333333333333333333e-3 * t41 - 0.1940164714223896e-2
  t198 = 0.12429895653008616666666666666666666666666666666667e-3 * t41 - 0.1491587478361034e-2
  t201 = 0.98280297068585083333333333333333333333333333333333e-2 * t41 - 0.1179363564823021e0
  t204 = 0.14955321307203416666666666666666666666666666666667e-3 * t41 - 0.1794638556864410e-2
  t207 = 0.17711102981460050000000000000000000000000000000000e-3 * t41 - 0.2125332357775206e-2
  t210 = 0.24294046008196958333333333333333333333333333333333e-3 * t41 - 0.2915285520983635e-2
  t213 = 0.16727461658817891666666666666666666666666666666667e-3 * t41 - 0.2007295399058147e-2
  t219 = -0.99085695677764733437500000000000000000000000000000e-2 * t99 + 0.16006150840254303093750000000000000000000000000000e-1 * t95 - 0.72755231092065014062500000000000000000000000000000e-2 * t97 + 0.67365954714875013020833333333333333333333333333333e-4 * t41 - 0.80839145657850015625000000000000000000000000000000e-3
  t225 = -0.98737552282912471500000000000000000000000000000000e-2 * t99 + 0.15949912291855091550000000000000000000000000000000e-1 * t95 - 0.72499601326614052500000000000000000000000000000000e-2 * t97 + 0.67129260487605604166666666666666666666666666666667e-4 * t41 - 0.80555112585126725000000000000000000000000000000000e-3
  t231 = 0.40821338940497436750000000000000000000000000000000e-1 * t99 - 0.65942162903880474750000000000000000000000000000000e-1 * t95 + 0.29973710410854761250000000000000000000000000000000e-1 * t97 - 0.27753435565606260416666666666666666666666666666667e-3 * t41 + 0.33304122678727512500000000000000000000000000000000e-2
  t237 = 0.65892413690753471250000000000000000000000000000000e-1 * t99 - 0.10644159134660176125000000000000000000000000000000e0 * t95 + 0.48382541521182618750000000000000000000000000000000e-1 * t97 - 0.44798649556650572916666666666666666666666666666667e-3 * t41 + 0.53758379467980687500000000000000000000000000000000e-2
  t243 = 0.33336728884482389437500000000000000000000000000000e0 * t99 - 0.53851638967240782937500000000000000000000000000000e0 * t95 + 0.24478017712382174062500000000000000000000000000000e0 * t97 - 0.22664831215168679687500000000000000000000000000000e-2 * t41 + 0.27197797458202415625000000000000000000000000000000e-1
  t249 = 0.38111046826810841812500000000000000000000000000000e-1 * t99 - 0.61563998720232898312500000000000000000000000000000e-1 * t95 + 0.27983635781924044687500000000000000000000000000000e-1 * t97 - 0.25910773872151893229166666666666666666666666666667e-3 * t41 + 0.31092928646582271875000000000000000000000000000000e-2
  t255 = 0.10290575827668764306250000000000000000000000000000e-1 * t99 - 0.16623237875464926956250000000000000000000000000000e-1 * t95 + 0.75560172161204213437500000000000000000000000000000e-2 * t97 - 0.69963122371485382812500000000000000000000000000000e-4 * t41 + 0.83955746845782459375000000000000000000000000000000e-3
  t260 = -0.11897370610471537500000000000000000000000000000000e-3 + 0.54965852220378503250000000000000000000000000000000e-2 * t103 - 0.74953434845970686250000000000000000000000000000000e-2 * t94 + 0.24984478281990228750000000000000000000000000000000e-2 * t93
  t262 = t210 * t110 + t237 * t110 + t207 * t118 + t243 * t118 + t204 * t124 + t249 * t124 + t195 * t137 + t219 * t137 + t260 * t137 + t198 * t145 + t225 * t145 + t213 * t153 + t231 * t153 + t192 * t77 + t201 * t77 + t255 * t77
  t266 = -0.13315182537504496875000000000000000000000000000000e-3 + 0.61516143323270775562500000000000000000000000000000e-2 * t103 - 0.83885649986278330312500000000000000000000000000000e-2 * t94 + 0.27961883328759443437500000000000000000000000000000e-2 * t93
  t271 = -0.35515182034202656250000000000000000000000000000000e-3 + 0.16408014099801627187500000000000000000000000000000e-1 * t103 - 0.22374564681547673437500000000000000000000000000000e-1 * t94 + 0.74581882271825578125000000000000000000000000000000e-2 * t93
  t276 = -0.13219576250814071875000000000000000000000000000000e-3 + 0.61074442278761012062500000000000000000000000000000e-2 * t103 - 0.83283330380128652812500000000000000000000000000000e-2 * t94 + 0.27761110126709550937500000000000000000000000000000e-2 * t93
  t281 = 0.20343974632767893750000000000000000000000000000000e-2 - 0.93989162803387669125000000000000000000000000000000e-1 * t103 + 0.12816704018643773062500000000000000000000000000000e0 * t94 - 0.42722346728812576875000000000000000000000000000000e-1 * t93
  t286 = 0.17181602881768140625000000000000000000000000000000e-2 - 0.79379005313768809687500000000000000000000000000000e-1 * t103 + 0.10824409815513928593750000000000000000000000000000e0 * t94 - 0.36081366051713095312500000000000000000000000000000e-1 * t93
  t291 = -0.72956774270285406250000000000000000000000000000000e-3 + 0.33706029712871857687500000000000000000000000000000e-1 * t103 - 0.45962767790279805937500000000000000000000000000000e-1 * t94 + 0.15320922596759935312500000000000000000000000000000e-1 * t93
  t296 = -0.17346732669513426375000000000000000000000000000000e-2 * t95 + 0.19274147410570473750000000000000000000000000000000e-2 * t97 - 0.34418120376018703125000000000000000000000000000000e-4 * t41 + 0.41301744451222443750000000000000000000000000000000e-3
  t301 = -0.12778143453756654750000000000000000000000000000000e-1 * t95 + 0.14197937170840727500000000000000000000000000000000e-1 * t97 - 0.25353459233644156250000000000000000000000000000000e-3 * t41 + 0.30424151080372987500000000000000000000000000000000e-2
  t306 = -0.46225592311189536000000000000000000000000000000000e-2 * t95 + 0.51361769234655040000000000000000000000000000000000e-2 * t97 - 0.91717445061884000000000000000000000000000000000000e-4 * t41 + 0.11006093407426080000000000000000000000000000000000e-2
  t311 = -0.79536024504265376250000000000000000000000000000000e-2 * t95 + 0.88373360560294862500000000000000000000000000000000e-2 * t97 - 0.15780957242909796875000000000000000000000000000000e-3 * t41 + 0.18937148691491756250000000000000000000000000000000e-2
  t316 = 0.17820228716880565500000000000000000000000000000000e-2 * t95 - 0.19800254129867295000000000000000000000000000000000e-2 * t97 + 0.35357596660477312500000000000000000000000000000000e-4 * t41 - 0.42429115992572775000000000000000000000000000000000e-3
  t321 = 0.52532932717643702625000000000000000000000000000000e-1 * t95 - 0.58369925241826336250000000000000000000000000000000e-1 * t97 + 0.10423200936040417187500000000000000000000000000000e-2 * t41 - 0.12507841123248500625000000000000000000000000000000e-1
  t326 = -0.20296500388975755000000000000000000000000000000000e-2 * t95 + 0.22551667098861950000000000000000000000000000000000e-2 * t97 - 0.40270834105110625000000000000000000000000000000000e-4 * t41 + 0.48325000926132750000000000000000000000000000000000e-3
  t330 = 0.12048536779195098750000000000000000000000000000000e-5 + 0.14056626242394281875000000000000000000000000000000e-4 * t94 - 0.12048536779195098750000000000000000000000000000000e-4 * t93
  t334 = 0.10410225900262143750000000000000000000000000000000e-3 + 0.12145263550305834375000000000000000000000000000000e-2 * t94 - 0.10410225900262143750000000000000000000000000000000e-2 * t93
  t338 = -0.10207381878334642500000000000000000000000000000000e-3 - 0.11908612191390416250000000000000000000000000000000e-2 * t94 + 0.10207381878334642500000000000000000000000000000000e-2 * t93
  t340 = t276 * t110 + t311 * t110 + t281 * t118 + t316 * t118 + t286 * t124 + t321 * t124 + t296 * t137 + t330 * t137 + t266 * t145 + t301 * t145 + t334 * t145 + t271 * t153 + t306 * t153 + t338 * t153 + t291 * t77 + t326 * t77
  t342 = t112 + t189 + t262 + t340
  t346 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t342)
  t352 = t122 * t77
  t357 = 0.1e1 / t30 / t29 / r0
  t363 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t43 * t32 + t34 * t357 / 0.3e1) * t20 * t24
  t364 = f.my_piecewise3(t53, t363, 0)
  t370 = 0.1e1 / t61 / t54
  t374 = t68 * t75
  t375 = f.my_piecewise3(t53, 0, t363)
  t379 = t74 ** 2
  t381 = t69 / t379
  t382 = t66 * t72
  t385 = t66 ** 2
  t386 = t385 * t65
  t392 = f.my_piecewise3(t52, -0.3e1 / 0.2e1 * t59 * t364 - 0.3e1 / 0.16e2 * t62 * t364 + 0.3e1 * t370 * t364, -0.6e1 * t374 * t65 * t375 - t381 * (0.3e1 * t382 * t375 + 0.12e2 * t386 * t375))
  t395 = t321 * t77
  t398 = t286 * t77
  t401 = t249 * t77
  t404 = t204 * t77
  t409 = t26 * t28 * t357 * t39
  t411 = t20 ** 2
  t414 = t411 / t22 / t21
  t415 = s0 ** 2
  t417 = t29 ** 2
  t422 = t38 ** 2
  t423 = 0.1e1 / t422
  t425 = t414 * t415 * t27 / t18 / t417 / t29 * t423
  t427 = -0.2e1 / 0.9e1 * t409 + t425 / 0.54e2
  t428 = t92 * t427
  t431 = t187 * t77
  t446 = t165 * t77
  t449 = 0.3e1 * t352 * t392 + 0.3e1 * t395 * t392 + 0.3e1 * t398 * t392 + 0.3e1 * t401 * t392 + 0.3e1 * t404 * t392 - 0.34614211374764670000000000000000000000000000000000e-2 * t428 * t124 + 0.3e1 * t431 * t392 - 0.43138819749080580000000000000000000000000000000000e-1 * t428 * t77 - 0.35268434302752690000000000000000000000000000000000e-2 * t428 * t137 - 0.38649183818388510000000000000000000000000000000000e-2 * t428 * t145 - 0.35690049148542390000000000000000000000000000000000e-2 * t428 * t153 - 0.55916486430307440000000000000000000000000000000000e-2 * t428 * t110 - 0.28924113898523499000000000000000000000000000000000e-2 * t428 * t118 + 0.3e1 * t446 * t392
  t457 = t81 * t392
  t459 = t79 * t392
  t462 = 0.315e3 / 0.8e1 * t457 - 0.105e3 / 0.4e1 * t459 + 0.15e2 / 0.8e1 * t392
  t470 = 0.15e2 / 0.2e1 * t459 - 0.3e1 / 0.2e1 * t392
  t476 = t80 * t392
  t478 = t77 * t392
  t480 = 0.35e2 / 0.2e1 * t476 - 0.15e2 / 0.2e1 * t478
  t495 = t84 * t392
  t499 = 0.693e3 / 0.8e1 * t495 - 0.315e3 / 0.4e1 * t476 + 0.105e3 / 0.8e1 * t478
  t501 = 0.20748619661467272631250000000000000000000000000000e0 * t392 + 0.35909124603362720486111111111111111111111111111112e-1 * t409 - 0.29924270502802267071759259259259259259259259259260e-2 * t425 + (-0.44606564423514377777777777777777777777777777777779e-3 * t409 + 0.37172137019595314814814814814814814814814814814816e-4 * t425) * t153 + t213 * t462 + (-0.47229607950560133333333333333333333333333333333333e-3 * t409 + 0.39358006625466777777777777777777777777777777777778e-4 * t425) * t118 + t207 * t470 + (-0.64784122688525222222222222222222222222222222222221e-3 * t409 + 0.53986768907104351851851851851851851851851851851851e-4 * t425) * t110 + t210 * t480 + (-0.26208079218289355555555555555555555555555555555555e-1 * t409 + 0.21840066015241129629629629629629629629629629629630e-2 * t425) * t77 + t201 * t392 + (-0.39880856819209111111111111111111111111111111111112e-3 * t409 + 0.33234047349340925925925925925925925925925925925927e-4 * t425) * t124 + (-0.33146388408022977777777777777777777777777777777779e-3 * t409 + 0.27621990340019148148148148148148148148148148148149e-4 * t425) * t145 + t198 * t499
  t508 = t87 * t392
  t513 = 0.3003e4 / 0.16e2 * t508 - 0.3465e4 / 0.16e2 * t457 + 0.945e3 / 0.16e2 * t459 - 0.35e2 / 0.16e2 * t392
  t517 = t103 * t427
  t519 = t94 * t427
  t521 = t93 * t427
  t553 = t192 * t392 + (-0.43114771427197688888888888888888888888888888888888e-3 * t409 + 0.35928976189331407407407407407407407407407407407407e-4 * t425) * t137 + t195 * t513 + t181 * t480 + t231 * t462 + (-0.69116286598038730050000000000000000000000000000000e-1 * t517 + 0.79749561459275457750000000000000000000000000000000e-1 * t519 - 0.21749880397984215750000000000000000000000000000000e-1 * t521 - 0.17901136130028161111111111111111111111111111111111e-3 * t409 + 0.14917613441690134259259259259259259259259259259259e-4 * t425) * t145 + t225 * t499 + (-0.69359986974435313406250000000000000000000000000000e-1 * t517 + 0.80030754201271515468750000000000000000000000000000e-1 * t519 - 0.21826569327619504218750000000000000000000000000000e-1 * t521 - 0.17964254590633336805555555555555555555555555555555e-3 * t409 + 0.14970212158861114004629629629629629629629629629630e-4 * t425) * t137 + t219 * t513 + t255 * t392 + (0.46124689583527429875000000000000000000000000000000e0 * t517 - 0.53220795673300880625000000000000000000000000000000e0 * t519 + 0.14514762456354785625000000000000000000000000000000e0 * t521 + 0.11946306548440152777777777777777777777777777777778e-2 * t409 - 0.99552554570334606481481481481481481481481481481482e-4 * t425) * t110 + t237 * t480 + (0.23335710219137672606250000000000000000000000000000e1 * t517 - 0.26925819483620391468750000000000000000000000000000e1 * t519 + 0.73434053137146522187500000000000000000000000000000e0 * t521 + 0.60439549907116479166666666666666666666666666666667e-2 * t409 - 0.50366291589263732638888888888888888888888888888889e-3 * t425) * t118 + t243 * t470
  t562 = t95 * t427
  t564 = t97 * t427
  t608 = (0.28574937258348205725000000000000000000000000000000e0 * t517 - 0.32971081451940237375000000000000000000000000000000e0 * t519 + 0.89921131232564283750000000000000000000000000000000e-1 * t521 + 0.74009161508283361111111111111111111111111111111112e-3 * t409 - 0.61674301256902800925925925925925925925925925925927e-4 * t425) * t153 + t271 * t462 + (0.32979511332227101950000000000000000000000000000000e-1 * t562 - 0.29981373938388274500000000000000000000000000000000e-1 * t564 + 0.49968956563980457500000000000000000000000000000000e-2 * t428) * t137 + t260 * t513 + (0.26677732778767589268750000000000000000000000000000e0 * t517 - 0.30781999360116449156250000000000000000000000000000e0 * t519 + 0.83950907345772134062500000000000000000000000000000e-1 * t521 + 0.69095396992405048611111111111111111111111111111112e-3 * t409 - 0.57579497493670873842592592592592592592592592592593e-4 * t425) * t124 + 0.10977695610065165231250000000000000000000000000000e0 * t517 + (0.72034030793681350143750000000000000000000000000000e-1 * t517 - 0.83116189377324634781250000000000000000000000000000e-1 * t519 + 0.22668051648361264031250000000000000000000000000000e-1 * t521 + 0.18656832632396102083333333333333333333333333333333e-3 * t409 - 0.15547360526996751736111111111111111111111111111111e-4 * t425) * t77 + (0.20223617827723114612500000000000000000000000000000e0 * t562 - 0.18385107116111922375000000000000000000000000000000e0 * t564 + 0.30641845193519870625000000000000000000000000000000e-1 * t428) * t77 + (0.36644665367256607237500000000000000000000000000000e-1 * t562 - 0.33313332152051461125000000000000000000000000000000e-1 * t564 + 0.55522220253419101875000000000000000000000000000000e-2 * t428) * t110 + t276 * t480 + (0.36909685993962465337500000000000000000000000000000e-1 * t562 - 0.33554259994511332125000000000000000000000000000000e-1 * t564 + 0.55923766657518886875000000000000000000000000000000e-2 * t428) * t145 + t266 * t499 + (0.98448084598809763125000000000000000000000000000000e-1 * t562 - 0.89498258726190693750000000000000000000000000000000e-1 * t564 + 0.14916376454365115625000000000000000000000000000000e-1 * t428) * t153 + t291 * t392
  t661 = (-0.86733663347567131875000000000000000000000000000000e-2 * t519 + 0.57822442231711421250000000000000000000000000000000e-2 * t521 + 0.91781654336049875000000000000000000000000000000000e-4 * t409 - 0.76484711946708229166666666666666666666666666666667e-5 * t425) * t137 + t296 * t513 + (-0.56393497682032601475000000000000000000000000000000e0 * t562 + 0.51266816074575092250000000000000000000000000000000e0 * t564 - 0.85444693457625153750000000000000000000000000000000e-1 * t428) * t118 + 0.13451533799369918175000000000000000000000000000000e0 * t562 + t281 * t470 + (-0.47627403188261285812500000000000000000000000000000e0 * t562 + 0.43297639262055714375000000000000000000000000000000e0 * t564 - 0.72162732103426190625000000000000000000000000000000e-1 * t428) * t124 + (-0.10148250194487877500000000000000000000000000000000e-1 * t519 + 0.67655001296585850000000000000000000000000000000000e-2 * t521 + 0.10738889094696166666666666666666666666666666666667e-3 * t409 - 0.89490742455801388888888888888888888888888888888889e-5 * t425) * t77 + t306 * t462 + (-0.39768012252132688125000000000000000000000000000000e-1 * t519 + 0.26512008168088458750000000000000000000000000000000e-1 * t521 + 0.42082552647759458333333333333333333333333333333333e-3 * t409 - 0.35068793873132881944444444444444444444444444444444e-4 * t425) * t110 + t311 * t480 + (-0.63890717268783273750000000000000000000000000000000e-1 * t519 + 0.42593811512522182500000000000000000000000000000000e-1 * t521 + 0.67609224623051083333333333333333333333333333333333e-3 * t409 - 0.56341020519209236111111111111111111111111111111111e-4 * t425) * t145 + t301 * t499 + (-0.23112796155594768000000000000000000000000000000000e-1 * t519 + 0.15408530770396512000000000000000000000000000000000e-1 * t521 + 0.24457985349835733333333333333333333333333333333333e-3 * t409 - 0.20381654458196444444444444444444444444444444444444e-4 * t425) * t153 + (-0.47634448765561665000000000000000000000000000000000e-2 * t564 + 0.20414763756669285000000000000000000000000000000000e-2 * t428) * t153
  t695 = t338 * t462 + t326 * t392 + (0.56226504969577127500000000000000000000000000000000e-4 * t564 - 0.24097073558390197500000000000000000000000000000000e-4 * t428) * t137 + t330 * t513 + (0.89101143584402827500000000000000000000000000000000e-2 * t519 - 0.59400762389601885000000000000000000000000000000000e-2 * t521 - 0.94286924427939500000000000000000000000000000000000e-4 * t409 + 0.78572437023282916666666666666666666666666666666667e-5 * t425) * t118 - 0.79437917093785877812500000000000000000000000000000e-1 * t519 + t316 * t470 + (0.26266466358821851312500000000000000000000000000000e0 * t519 - 0.17510977572547900875000000000000000000000000000000e0 * t521 - 0.27795202496107779166666666666666666666666666666667e-2 * t409 + 0.23162668746756482638888888888888888888888888888889e-3 * t425) * t124 - 0.4188213175650997500000000000000000000000000000000e-2 * t564 - 0.74205374702437850625000000000000000000000000000000e0 * t428 + t115 * t470 + (0.23980051120505725000000000000000000000000000000000e-2 * t564 - 0.10277164765931025000000000000000000000000000000000e-2 * t428) * t124 + (0.29456264017009077500000000000000000000000000000000e0 * t564 - 0.12624113150146747500000000000000000000000000000000e0 * t428) * t77 + t128 * t392
  t736 = (0.73286988384940837500000000000000000000000000000000e-2 * t564 - 0.31408709307831787500000000000000000000000000000000e-2 * t428) * t110 + t107 * t480 + (0.48581054201223337500000000000000000000000000000000e-2 * t564 - 0.20820451800524287500000000000000000000000000000000e-2 * t428) * t145 + t334 * t499 + t157 * t480 + (0.27845896284907822500000000000000000000000000000000e-1 * t521 + 0.12375953904403476666666666666666666666666666666667e-2 * t409 - 0.10313294920336230555555555555555555555555555555556e-3 * t425) * t118 + t161 * t470 + (-0.45438726256320435000000000000000000000000000000000e-2 * t521 - 0.20194989447253526666666666666666666666666666666667e-3 * t409 + 0.16829157872711272222222222222222222222222222222222e-4 * t425) * t145 + t141 * t499 + (0.12546794310474727500000000000000000000000000000000e-2 * t521 + 0.55763530268776566666666666666666666666666666666667e-4 * t409 - 0.46469608557313805555555555555555555555555555555556e-5 * t425) * t153 + t149 * t462 + (0.32343088194322890000000000000000000000000000000000e-2 * t521 + 0.14374705864143506666666666666666666666666666666667e-3 * t409 - 0.11978921553452922222222222222222222222222222222222e-4 * t425) * t137 + t132 * t513 + (0.22443257423488370000000000000000000000000000000000e-1 * t564 - 0.96185388957807300000000000000000000000000000000000e-2 * t428) * t118
  t764 = -0.96364485405785018437500000000000000000000000000000e-1 * t459 + t184 * t470 + 0.43767257904820069593750000000000000000000000000000e0 * t457 + t178 * t462 - 0.17131022505250731000000000000000000000000000000000e0 * t495 + 0.11775890511466263000000000000000000000000000000000e0 * t476 - 0.11765768981988274200000000000000000000000000000000e-1 * t478 + t175 * t499 + (-0.53177226099084330000000000000000000000000000000000e-2 * t521 - 0.23634322710704146666666666666666666666666666666667e-3 * t409 + 0.19695268925586788888888888888888888888888888888889e-4 * t425) * t124 + 0.22250640561108574687500000000000000000000000000000e-1 * t521 + (-0.77292857206958100000000000000000000000000000000000e-1 * t521 - 0.34352380980870266666666666666666666666666666666667e-2 * t409 + 0.28626984150725222222222222222222222222222222222222e-3 * t425) * t77 + t169 * t392 - 0.47225184058624102781250000000000000000000000000000e0 * t508 + t172 * t513 + (-0.18712129129105987500000000000000000000000000000000e-1 * t521 - 0.83165018351582166666666666666666666666666666666667e-3 * t409 + 0.69304181959651805555555555555555555555555555555555e-4 * t425) * t110
  t772 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t342 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t449 + t501 + t553 + t608 + t661 + t695 + t736 + t764))
  vrho_0_ = 0.2e1 * r0 * t772 + 0.2e1 * t346
  t775 = t25 * t40
  t783 = t414 * s0 * t27 / t18 / t417 / r0 * t423
  t785 = t775 / 0.12e2 - t783 / 0.144e3
  t786 = t92 * t785
  t790 = 0.5e1 / 0.72e2 * t25 * t33
  t791 = f.my_piecewise3(t53, -t790, 0)
  t799 = f.my_piecewise3(t53, 0, -t790)
  t810 = f.my_piecewise3(t52, -0.3e1 / 0.2e1 * t59 * t791 - 0.3e1 / 0.16e2 * t62 * t791 + 0.3e1 * t370 * t791, -0.6e1 * t374 * t65 * t799 - t381 * (0.3e1 * t382 * t799 + 0.12e2 * t386 * t799))
  t837 = -0.34614211374764670000000000000000000000000000000000e-2 * t786 * t124 + 0.3e1 * t431 * t810 - 0.43138819749080580000000000000000000000000000000000e-1 * t786 * t77 + 0.3e1 * t404 * t810 - 0.35268434302752690000000000000000000000000000000000e-2 * t786 * t137 - 0.38649183818388510000000000000000000000000000000000e-2 * t786 * t145 - 0.35690049148542390000000000000000000000000000000000e-2 * t786 * t153 - 0.55916486430307440000000000000000000000000000000000e-2 * t786 * t110 - 0.28924113898523499000000000000000000000000000000000e-2 * t786 * t118 + 0.3e1 * t446 * t810 + 0.3e1 * t352 * t810 + 0.3e1 * t395 * t810 + 0.3e1 * t398 * t810 + 0.3e1 * t401 * t810
  t843 = t80 * t810
  t845 = t77 * t810
  t847 = 0.35e2 / 0.2e1 * t843 - 0.15e2 / 0.2e1 * t845
  t850 = t103 * t785
  t852 = t94 * t785
  t854 = t93 * t785
  t860 = t84 * t810
  t864 = 0.693e3 / 0.8e1 * t860 - 0.315e3 / 0.4e1 * t843 + 0.105e3 / 0.8e1 * t845
  t873 = t87 * t810
  t875 = t81 * t810
  t877 = t79 * t810
  t880 = 0.3003e4 / 0.16e2 * t873 - 0.3465e4 / 0.16e2 * t875 + 0.945e3 / 0.16e2 * t877 - 0.35e2 / 0.16e2 * t810
  t889 = 0.315e3 / 0.8e1 * t875 - 0.105e3 / 0.4e1 * t877 + 0.15e2 / 0.8e1 * t810
  t894 = 0.15e2 / 0.2e1 * t877 - 0.3e1 / 0.2e1 * t810
  t910 = 0.11221601438550850151909722222222222222222222222222e-2 * t783 + (0.24294046008196958333333333333333333333333333333333e-3 * t775 - 0.20245038340164131944444444444444444444444444444444e-4 * t783) * t110 + t210 * t847 + t237 * t847 + (-0.69116286598038730050000000000000000000000000000000e-1 * t850 + 0.79749561459275457750000000000000000000000000000000e-1 * t852 - 0.21749880397984215750000000000000000000000000000000e-1 * t854 + 0.67129260487605604166666666666666666666666666666667e-4 * t775 - 0.55941050406338003472222222222222222222222222222222e-5 * t783) * t145 + t225 * t864 + (-0.69359986974435313406250000000000000000000000000000e-1 * t850 + 0.80030754201271515468750000000000000000000000000000e-1 * t852 - 0.21826569327619504218750000000000000000000000000000e-1 * t854 + 0.67365954714875013020833333333333333333333333333333e-4 * t775 - 0.56138295595729177517361111111111111111111111111111e-5 * t783) * t137 + t219 * t880 + (0.16727461658817891666666666666666666666666666666667e-3 * t775 - 0.13939551382348243055555555555555555555555555555556e-4 * t783) * t153 + t213 * t889 - 0.13465921726261020182291666666666666666666666666667e-1 * t775 + t243 * t894 + (0.26677732778767589268750000000000000000000000000000e0 * t850 - 0.30781999360116449156250000000000000000000000000000e0 * t852 + 0.83950907345772134062500000000000000000000000000000e-1 * t854 - 0.25910773872151893229166666666666666666666666666667e-3 * t775 + 0.21592311560126577690972222222222222222222222222222e-4 * t783) * t124 + (0.28574937258348205725000000000000000000000000000000e0 * t850 - 0.32971081451940237375000000000000000000000000000000e0 * t852 + 0.89921131232564283750000000000000000000000000000000e-1 * t854 - 0.27753435565606260416666666666666666666666666666667e-3 * t775 + 0.23127862971338550347222222222222222222222222222222e-4 * t783) * t153
  t930 = t95 * t785
  t932 = t97 * t785
  t962 = t231 * t889 + (0.46124689583527429875000000000000000000000000000000e0 * t850 - 0.53220795673300880625000000000000000000000000000000e0 * t852 + 0.14514762456354785625000000000000000000000000000000e0 * t854 - 0.44798649556650572916666666666666666666666666666667e-3 * t775 + 0.37332207963875477430555555555555555555555555555556e-4 * t783) * t110 + t266 * t864 + (0.72034030793681350143750000000000000000000000000000e-1 * t850 - 0.83116189377324634781250000000000000000000000000000e-1 * t852 + 0.22668051648361264031250000000000000000000000000000e-1 * t854 - 0.69963122371485382812500000000000000000000000000000e-4 * t775 + 0.58302601976237819010416666666666666666666666666667e-5 * t783) * t77 + 0.10977695610065165231250000000000000000000000000000e0 * t850 + t255 * t810 + (0.32979511332227101950000000000000000000000000000000e-1 * t930 - 0.29981373938388274500000000000000000000000000000000e-1 * t932 + 0.49968956563980457500000000000000000000000000000000e-2 * t786) * t137 + t260 * t880 + (0.23335710219137672606250000000000000000000000000000e1 * t850 - 0.26925819483620391468750000000000000000000000000000e1 * t852 + 0.73434053137146522187500000000000000000000000000000e0 * t854 - 0.22664831215168679687500000000000000000000000000000e-2 * t775 + 0.18887359345973899739583333333333333333333333333333e-3 * t783) * t118 + (-0.56393497682032601475000000000000000000000000000000e0 * t930 + 0.51266816074575092250000000000000000000000000000000e0 * t932 - 0.85444693457625153750000000000000000000000000000000e-1 * t786) * t118 + t281 * t894 + (0.98448084598809763125000000000000000000000000000000e-1 * t930 - 0.89498258726190693750000000000000000000000000000000e-1 * t932 + 0.14916376454365115625000000000000000000000000000000e-1 * t786) * t153 + t271 * t889 + (0.36909685993962465337500000000000000000000000000000e-1 * t930 - 0.33554259994511332125000000000000000000000000000000e-1 * t932 + 0.55923766657518886875000000000000000000000000000000e-2 * t786) * t145
  t1005 = 0.13451533799369918175000000000000000000000000000000e0 * t930 + (0.20223617827723114612500000000000000000000000000000e0 * t930 - 0.18385107116111922375000000000000000000000000000000e0 * t932 + 0.30641845193519870625000000000000000000000000000000e-1 * t786) * t77 + t291 * t810 + (-0.86733663347567131875000000000000000000000000000000e-2 * t852 + 0.57822442231711421250000000000000000000000000000000e-2 * t854 - 0.34418120376018703125000000000000000000000000000000e-4 * t775 + 0.28681766980015585937500000000000000000000000000000e-5 * t783) * t137 + t296 * t880 + (0.36644665367256607237500000000000000000000000000000e-1 * t930 - 0.33313332152051461125000000000000000000000000000000e-1 * t932 + 0.55522220253419101875000000000000000000000000000000e-2 * t786) * t110 + t276 * t847 + t311 * t847 + (0.89101143584402827500000000000000000000000000000000e-2 * t852 - 0.59400762389601885000000000000000000000000000000000e-2 * t854 + 0.35357596660477312500000000000000000000000000000000e-4 * t775 - 0.29464663883731093750000000000000000000000000000000e-5 * t783) * t118 + t316 * t894 + (-0.23112796155594768000000000000000000000000000000000e-1 * t852 + 0.15408530770396512000000000000000000000000000000000e-1 * t854 - 0.91717445061884000000000000000000000000000000000000e-4 * t775 + 0.76431204218236666666666666666666666666666666666667e-5 * t783) * t153 + t306 * t889 + (-0.63890717268783273750000000000000000000000000000000e-1 * t852 + 0.42593811512522182500000000000000000000000000000000e-1 * t854 - 0.25353459233644156250000000000000000000000000000000e-3 * t775 + 0.21127882694703463541666666666666666666666666666667e-4 * t783) * t145 + t301 * t864
  t1050 = (-0.47627403188261285812500000000000000000000000000000e0 * t930 + 0.43297639262055714375000000000000000000000000000000e0 * t932 - 0.72162732103426190625000000000000000000000000000000e-1 * t786) * t124 + t334 * t864 + (0.26266466358821851312500000000000000000000000000000e0 * t852 - 0.17510977572547900875000000000000000000000000000000e0 * t854 + 0.10423200936040417187500000000000000000000000000000e-2 * t775 - 0.86860007800336809895833333333333333333333333333333e-4 * t783) * t124 - 0.79437917093785877812500000000000000000000000000000e-1 * t852 + (-0.10148250194487877500000000000000000000000000000000e-1 * t852 + 0.67655001296585850000000000000000000000000000000000e-2 * t854 - 0.40270834105110625000000000000000000000000000000000e-4 * t775 + 0.33559028420925520833333333333333333333333333333333e-5 * t783) * t77 + t326 * t810 + (0.56226504969577127500000000000000000000000000000000e-4 * t932 - 0.24097073558390197500000000000000000000000000000000e-4 * t786) * t137 + t330 * t880 + (-0.39768012252132688125000000000000000000000000000000e-1 * t852 + 0.26512008168088458750000000000000000000000000000000e-1 * t854 - 0.15780957242909796875000000000000000000000000000000e-3 * t775 + 0.13150797702424830729166666666666666666666666666667e-4 * t783) * t110 + t132 * t880 + (0.73286988384940837500000000000000000000000000000000e-2 * t932 - 0.31408709307831787500000000000000000000000000000000e-2 * t786) * t110 + t107 * t847 + (0.22443257423488370000000000000000000000000000000000e-1 * t932 - 0.96185388957807300000000000000000000000000000000000e-2 * t786) * t118 + t115 * t894
  t1093 = (-0.47634448765561665000000000000000000000000000000000e-2 * t932 + 0.20414763756669285000000000000000000000000000000000e-2 * t786) * t153 + t338 * t889 + (0.48581054201223337500000000000000000000000000000000e-2 * t932 - 0.20820451800524287500000000000000000000000000000000e-2 * t786) * t145 + (-0.18712129129105987500000000000000000000000000000000e-1 * t854 + 0.31186881881843312500000000000000000000000000000000e-3 * t775 - 0.25989068234869427083333333333333333333333333333333e-4 * t783) * t110 + t157 * t847 + (0.27845896284907822500000000000000000000000000000000e-1 * t854 - 0.46409827141513037500000000000000000000000000000000e-3 * t775 + 0.38674855951260864583333333333333333333333333333333e-4 * t783) * t118 + t161 * t894 + (-0.53177226099084330000000000000000000000000000000000e-2 * t854 + 0.88628710165140550000000000000000000000000000000000e-4 * t775 - 0.73857258470950458333333333333333333333333333333333e-5 * t783) * t124 + (0.23980051120505725000000000000000000000000000000000e-2 * t932 - 0.10277164765931025000000000000000000000000000000000e-2 * t786) * t124 - 0.4188213175650997500000000000000000000000000000000e-2 * t932 - 0.74205374702437850625000000000000000000000000000000e0 * t786 + (0.29456264017009077500000000000000000000000000000000e0 * t932 - 0.12624113150146747500000000000000000000000000000000e0 * t786) * t77 + t128 * t810 + (0.32343088194322890000000000000000000000000000000000e-2 * t854 - 0.53905146990538150000000000000000000000000000000000e-4 * t775 + 0.44920955825448458333333333333333333333333333333333e-5 * t783) * t137
  t1121 = 0.20748619661467272631250000000000000000000000000000e0 * t810 - 0.47225184058624102781250000000000000000000000000000e0 * t873 + 0.43767257904820069593750000000000000000000000000000e0 * t875 + t184 * t894 + t178 * t889 + t181 * t847 + (0.12546794310474727500000000000000000000000000000000e-2 * t854 - 0.20911323850791212500000000000000000000000000000000e-4 * t775 + 0.17426103208992677083333333333333333333333333333333e-5 * t783) * t153 + 0.22250640561108574687500000000000000000000000000000e-1 * t854 + t149 * t889 + (-0.45438726256320435000000000000000000000000000000000e-2 * t854 + 0.75731210427200725000000000000000000000000000000000e-4 * t775 - 0.63109342022667270833333333333333333333333333333333e-5 * t783) * t145 + t141 * t864 + t175 * t864 + (-0.77292857206958100000000000000000000000000000000000e-1 * t854 + 0.12882142867826350000000000000000000000000000000000e-2 * t775 - 0.10735119056521958333333333333333333333333333333333e-3 * t783) * t77 + t169 * t810
  t1152 = t172 * t880 + (0.98280297068585083333333333333333333333333333333333e-2 * t775 - 0.81900247557154236111111111111111111111111111111111e-3 * t783) * t77 + t201 * t810 + (0.14955321307203416666666666666666666666666666666667e-3 * t775 - 0.12462767756002847222222222222222222222222222222222e-4 * t783) * t124 + (0.17711102981460050000000000000000000000000000000000e-3 * t775 - 0.14759252484550041666666666666666666666666666666667e-4 * t783) * t118 + t207 * t894 - 0.96364485405785018437500000000000000000000000000000e-1 * t877 + (0.12429895653008616666666666666666666666666666666667e-3 * t775 - 0.10358246377507180555555555555555555555555555555556e-4 * t783) * t145 + t198 * t864 - 0.17131022505250731000000000000000000000000000000000e0 * t860 + 0.11775890511466263000000000000000000000000000000000e0 * t843 - 0.11765768981988274200000000000000000000000000000000e-1 * t845 + t192 * t810 + (0.16168039285199133333333333333333333333333333333333e-3 * t775 - 0.13473366070999277777777777777777777777777777777777e-4 * t783) * t137 + t195 * t880
  t1159 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t837 + t910 + t962 + t1005 + t1050 + t1093 + t1121 + t1152))
  vsigma_0_ = 0.2e1 * r0 * t1159
  vlapl_0_ = 0.0e0
  t1163 = 0.5e1 / 0.9e1 * t28 * t45 * t25
  t1164 = f.my_piecewise3(t53, t1163, 0)
  t1172 = f.my_piecewise3(t53, 0, t1163)
  t1183 = f.my_piecewise3(t52, -0.3e1 / 0.2e1 * t59 * t1164 - 0.3e1 / 0.16e2 * t62 * t1164 + 0.3e1 * t370 * t1164, -0.6e1 * t374 * t65 * t1172 - t381 * (0.3e1 * t382 * t1172 + 0.12e2 * t386 * t1172))
  t1199 = t79 * t1183
  t1202 = 0.15e2 / 0.2e1 * t1199 - 0.3e1 / 0.2e1 * t1183
  t1204 = t84 * t1183
  t1206 = t80 * t1183
  t1208 = t77 * t1183
  t1210 = 0.693e3 / 0.8e1 * t1204 - 0.315e3 / 0.4e1 * t1206 + 0.105e3 / 0.8e1 * t1208
  t1213 = t87 * t1183
  t1215 = t81 * t1183
  t1219 = 0.3003e4 / 0.16e2 * t1213 - 0.3465e4 / 0.16e2 * t1215 + 0.945e3 / 0.16e2 * t1199 - 0.35e2 / 0.16e2 * t1183
  t1223 = 0.35e2 / 0.2e1 * t1206 - 0.15e2 / 0.2e1 * t1208
  t1226 = t192 * t1183 + t201 * t1183 + 0.3e1 * t352 * t1183 + 0.3e1 * t395 * t1183 + 0.3e1 * t398 * t1183 + 0.3e1 * t401 * t1183 + 0.3e1 * t404 * t1183 + 0.3e1 * t431 * t1183 + 0.3e1 * t446 * t1183 + t184 * t1202 + t207 * t1202 + t198 * t1210 + t195 * t1219 + t181 * t1223
  t1230 = 0.315e3 / 0.8e1 * t1215 - 0.105e3 / 0.4e1 * t1199 + 0.15e2 / 0.8e1 * t1183
  t1245 = t169 * t1183 + t161 * t1202 + t243 * t1202 + t175 * t1210 + t225 * t1210 + t172 * t1219 + t219 * t1219 + t260 * t1219 + t296 * t1219 + t210 * t1223 + t237 * t1223 + t178 * t1230 + t213 * t1230 + t231 * t1230
  t1261 = t301 * t1210 + t281 * t1202 + t291 * t1183 + t271 * t1230 + t276 * t1223 + t266 * t1210 + t255 * t1183 + t128 * t1183 + t132 * t1219 - 0.47225184058624102781250000000000000000000000000000e0 * t1213 + t107 * t1223 + t115 * t1202 + t334 * t1210 + t338 * t1230
  t1276 = t326 * t1183 + t330 * t1219 + t311 * t1223 + t316 * t1202 + t306 * t1230 + t149 * t1230 + 0.43767257904820069593750000000000000000000000000000e0 * t1215 - 0.96364485405785018437500000000000000000000000000000e-1 * t1199 + t157 * t1223 + 0.11775890511466263000000000000000000000000000000000e0 * t1206 - 0.11765768981988274200000000000000000000000000000000e-1 * t1208 + t141 * t1210 - 0.17131022505250731000000000000000000000000000000000e0 * t1204 + 0.20748619661467272631250000000000000000000000000000e0 * t1183
  t1282 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t1226 + t1245 + t1261 + t1276))
  vtau_0_ = 0.2e1 * r0 * t1282
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

