"""Generated from mgga_x_mn12.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  mn12_omega_x = 2.5

  mn12_gamma_x = 0.004

  mn12_wx = lambda t: (K_FACTOR_C - t) / (K_FACTOR_C + t)

  mn12_vx = lambda rs, z: 1 / (1 + rs / (mn12_omega_x * f.RS_FACTOR) * (2 / (1 + z)) ** (1 / 3))

  mn12_ux = lambda x: mn12_gamma_x * x ** 2 / (1 + mn12_gamma_x * x ** 2)

  mn12_pol1 = lambda t: params_c[1] + params_c[2] * mn12_wx(t) + params_c[3] * mn12_wx(t) ** 2 + params_c[4] * mn12_wx(t) ** 3 + params_c[5] * mn12_wx(t) ** 4 + params_c[6] * mn12_wx(t) ** 5

  mn12_pol2 = lambda t: params_c[7] + params_c[8] * mn12_wx(t) + params_c[9] * mn12_wx(t) ** 2 + params_c[10] * mn12_wx(t) ** 3 + params_c[11] * mn12_wx(t) ** 4

  mn12_pol3 = lambda t: params_c[12] + params_c[13] * mn12_wx(t) + params_c[14] * mn12_wx(t) ** 2 + params_c[15] * mn12_wx(t) ** 3

  mn12_pol4 = lambda t: params_c[16] + params_c[17] * mn12_wx(t) + params_c[18] * mn12_wx(t) ** 2

  mn12_pol5 = lambda t: params_c[19] + params_c[20] * mn12_wx(t) + params_c[21] * mn12_wx(t) ** 2 + params_c[22] * mn12_wx(t) ** 3 + params_c[23] * mn12_wx(t) ** 4

  mn12_pol6 = lambda t: params_c[24] + params_c[25] * mn12_wx(t) + params_c[26] * mn12_wx(t) ** 2 + params_c[27] * mn12_wx(t) ** 3

  mn12_pol7 = lambda t: params_c[28] + params_c[29] * mn12_wx(t) + params_c[30] * mn12_wx(t) ** 2

  mn12_pol8 = lambda t: params_c[31] + params_c[32] * mn12_wx(t) + params_c[33] * mn12_wx(t) ** 2 + params_c[34] * mn12_wx(t) ** 3

  mn12_pol9 = lambda t: params_c[35] + params_c[36] * mn12_wx(t) + params_c[37] * mn12_wx(t) ** 2

  mn12_pol10 = lambda t: params_c[38] + params_c[39] * mn12_wx(t) + params_c[40] * mn12_wx(t) ** 2

  mn12_f = lambda rs, z, x, u, t: +mn12_pol1(t) + mn12_pol2(t) * mn12_ux(x) + mn12_pol3(t) * mn12_ux(x) ** 2 + mn12_pol4(t) * mn12_ux(x) ** 3 + mn12_pol5(t) * mn12_vx(rs, z) + mn12_pol6(t) * mn12_ux(x) * mn12_vx(rs, z) + mn12_pol7(t) * mn12_ux(x) ** 2 * mn12_vx(rs, z) + mn12_pol8(t) * mn12_vx(rs, z) ** 2 + mn12_pol9(t) * mn12_ux(x) * mn12_vx(rs, z) ** 2 + mn12_pol10(t) * mn12_vx(rs, z) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, mn12_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  mn12_omega_x = 2.5

  mn12_gamma_x = 0.004

  mn12_wx = lambda t: (K_FACTOR_C - t) / (K_FACTOR_C + t)

  mn12_vx = lambda rs, z: 1 / (1 + rs / (mn12_omega_x * f.RS_FACTOR) * (2 / (1 + z)) ** (1 / 3))

  mn12_ux = lambda x: mn12_gamma_x * x ** 2 / (1 + mn12_gamma_x * x ** 2)

  mn12_pol1 = lambda t: params_c[1] + params_c[2] * mn12_wx(t) + params_c[3] * mn12_wx(t) ** 2 + params_c[4] * mn12_wx(t) ** 3 + params_c[5] * mn12_wx(t) ** 4 + params_c[6] * mn12_wx(t) ** 5

  mn12_pol2 = lambda t: params_c[7] + params_c[8] * mn12_wx(t) + params_c[9] * mn12_wx(t) ** 2 + params_c[10] * mn12_wx(t) ** 3 + params_c[11] * mn12_wx(t) ** 4

  mn12_pol3 = lambda t: params_c[12] + params_c[13] * mn12_wx(t) + params_c[14] * mn12_wx(t) ** 2 + params_c[15] * mn12_wx(t) ** 3

  mn12_pol4 = lambda t: params_c[16] + params_c[17] * mn12_wx(t) + params_c[18] * mn12_wx(t) ** 2

  mn12_pol5 = lambda t: params_c[19] + params_c[20] * mn12_wx(t) + params_c[21] * mn12_wx(t) ** 2 + params_c[22] * mn12_wx(t) ** 3 + params_c[23] * mn12_wx(t) ** 4

  mn12_pol6 = lambda t: params_c[24] + params_c[25] * mn12_wx(t) + params_c[26] * mn12_wx(t) ** 2 + params_c[27] * mn12_wx(t) ** 3

  mn12_pol7 = lambda t: params_c[28] + params_c[29] * mn12_wx(t) + params_c[30] * mn12_wx(t) ** 2

  mn12_pol8 = lambda t: params_c[31] + params_c[32] * mn12_wx(t) + params_c[33] * mn12_wx(t) ** 2 + params_c[34] * mn12_wx(t) ** 3

  mn12_pol9 = lambda t: params_c[35] + params_c[36] * mn12_wx(t) + params_c[37] * mn12_wx(t) ** 2

  mn12_pol10 = lambda t: params_c[38] + params_c[39] * mn12_wx(t) + params_c[40] * mn12_wx(t) ** 2

  mn12_f = lambda rs, z, x, u, t: +mn12_pol1(t) + mn12_pol2(t) * mn12_ux(x) + mn12_pol3(t) * mn12_ux(x) ** 2 + mn12_pol4(t) * mn12_ux(x) ** 3 + mn12_pol5(t) * mn12_vx(rs, z) + mn12_pol6(t) * mn12_ux(x) * mn12_vx(rs, z) + mn12_pol7(t) * mn12_ux(x) ** 2 * mn12_vx(rs, z) + mn12_pol8(t) * mn12_vx(rs, z) ** 2 + mn12_pol9(t) * mn12_ux(x) * mn12_vx(rs, z) ** 2 + mn12_pol10(t) * mn12_vx(rs, z) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, mn12_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  mn12_omega_x = 2.5

  mn12_gamma_x = 0.004

  mn12_wx = lambda t: (K_FACTOR_C - t) / (K_FACTOR_C + t)

  mn12_vx = lambda rs, z: 1 / (1 + rs / (mn12_omega_x * f.RS_FACTOR) * (2 / (1 + z)) ** (1 / 3))

  mn12_ux = lambda x: mn12_gamma_x * x ** 2 / (1 + mn12_gamma_x * x ** 2)

  mn12_pol1 = lambda t: params_c[1] + params_c[2] * mn12_wx(t) + params_c[3] * mn12_wx(t) ** 2 + params_c[4] * mn12_wx(t) ** 3 + params_c[5] * mn12_wx(t) ** 4 + params_c[6] * mn12_wx(t) ** 5

  mn12_pol2 = lambda t: params_c[7] + params_c[8] * mn12_wx(t) + params_c[9] * mn12_wx(t) ** 2 + params_c[10] * mn12_wx(t) ** 3 + params_c[11] * mn12_wx(t) ** 4

  mn12_pol3 = lambda t: params_c[12] + params_c[13] * mn12_wx(t) + params_c[14] * mn12_wx(t) ** 2 + params_c[15] * mn12_wx(t) ** 3

  mn12_pol4 = lambda t: params_c[16] + params_c[17] * mn12_wx(t) + params_c[18] * mn12_wx(t) ** 2

  mn12_pol5 = lambda t: params_c[19] + params_c[20] * mn12_wx(t) + params_c[21] * mn12_wx(t) ** 2 + params_c[22] * mn12_wx(t) ** 3 + params_c[23] * mn12_wx(t) ** 4

  mn12_pol6 = lambda t: params_c[24] + params_c[25] * mn12_wx(t) + params_c[26] * mn12_wx(t) ** 2 + params_c[27] * mn12_wx(t) ** 3

  mn12_pol7 = lambda t: params_c[28] + params_c[29] * mn12_wx(t) + params_c[30] * mn12_wx(t) ** 2

  mn12_pol8 = lambda t: params_c[31] + params_c[32] * mn12_wx(t) + params_c[33] * mn12_wx(t) ** 2 + params_c[34] * mn12_wx(t) ** 3

  mn12_pol9 = lambda t: params_c[35] + params_c[36] * mn12_wx(t) + params_c[37] * mn12_wx(t) ** 2

  mn12_pol10 = lambda t: params_c[38] + params_c[39] * mn12_wx(t) + params_c[40] * mn12_wx(t) ** 2

  mn12_f = lambda rs, z, x, u, t: +mn12_pol1(t) + mn12_pol2(t) * mn12_ux(x) + mn12_pol3(t) * mn12_ux(x) ** 2 + mn12_pol4(t) * mn12_ux(x) ** 3 + mn12_pol5(t) * mn12_vx(rs, z) + mn12_pol6(t) * mn12_ux(x) * mn12_vx(rs, z) + mn12_pol7(t) * mn12_ux(x) ** 2 * mn12_vx(rs, z) + mn12_pol8(t) * mn12_vx(rs, z) ** 2 + mn12_pol9(t) * mn12_ux(x) * mn12_vx(rs, z) ** 2 + mn12_pol10(t) * mn12_vx(rs, z) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, mn12_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = params.c[0]
  t29 = params.c[1]
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = 0.3e1 / 0.10e2 * t31 * t34
  t37 = r0 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = 0.1e1 / t38 / r0
  t41 = tau0 * t40
  t42 = t36 - t41
  t43 = t29 * t42
  t44 = t36 + t41
  t45 = 0.1e1 / t44
  t47 = params.c[2]
  t48 = t42 ** 2
  t49 = t47 * t48
  t50 = t44 ** 2
  t51 = 0.1e1 / t50
  t53 = params.c[3]
  t54 = t48 * t42
  t55 = t53 * t54
  t57 = 0.1e1 / t50 / t44
  t59 = params.c[4]
  t60 = t48 ** 2
  t61 = t59 * t60
  t62 = t50 ** 2
  t63 = 0.1e1 / t62
  t65 = params.c[5]
  t67 = t65 * t60 * t42
  t69 = 0.1e1 / t62 / t44
  t71 = params.c[6]
  t72 = params.c[7]
  t73 = t72 * t42
  t75 = params.c[8]
  t76 = t75 * t48
  t78 = params.c[9]
  t79 = t78 * t54
  t81 = params.c[10]
  t82 = t81 * t60
  t84 = t73 * t45 + t76 * t51 + t79 * t57 + t82 * t63 + t71
  t85 = t84 * s0
  t86 = r0 ** 2
  t88 = 0.1e1 / t38 / t86
  t91 = 0.1e1 + 0.4e-2 * s0 * t88
  t92 = 0.1e1 / t91
  t93 = t88 * t92
  t96 = params.c[11]
  t97 = params.c[12]
  t98 = t97 * t42
  t100 = params.c[13]
  t101 = t100 * t48
  t103 = params.c[14]
  t104 = t103 * t54
  t106 = t101 * t51 + t104 * t57 + t98 * t45 + t96
  t107 = s0 ** 2
  t108 = t106 * t107
  t109 = t86 ** 2
  t112 = 0.1e1 / t37 / t109 / r0
  t113 = t91 ** 2
  t114 = 0.1e1 / t113
  t115 = t112 * t114
  t118 = params.c[15]
  t119 = params.c[16]
  t120 = t119 * t42
  t122 = params.c[17]
  t123 = t122 * t48
  t125 = t120 * t45 + t123 * t51 + t118
  t126 = t107 * s0
  t127 = t125 * t126
  t128 = t109 ** 2
  t131 = 0.1e1 / t113 / t91
  t132 = 0.1e1 / t128 * t131
  t135 = params.c[18]
  t136 = params.c[19]
  t137 = t136 * t42
  t139 = params.c[20]
  t140 = t139 * t48
  t142 = params.c[21]
  t143 = t142 * t54
  t145 = params.c[22]
  t146 = t145 * t60
  t148 = t137 * t45 + t140 * t51 + t143 * t57 + t146 * t63 + t135
  t150 = 2 ** (0.1e1 / 0.3e1)
  t151 = 0.1e1 / t26 * t150
  t153 = 0.1e1 + t17 <= f.p.zeta_threshold
  t155 = 0.1e1 - t17 <= f.p.zeta_threshold
  t156 = f.my_piecewise5(t153, t11, t155, t15, t17)
  t157 = 0.1e1 + t156
  t159 = (0.1e1 / t157) ** (0.1e1 / 0.3e1)
  t162 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 * t151 * t159
  t163 = 0.1e1 / t162
  t165 = params.c[23]
  t166 = params.c[24]
  t167 = t166 * t42
  t169 = params.c[25]
  t170 = t169 * t48
  t172 = params.c[26]
  t173 = t172 * t54
  t175 = t167 * t45 + t170 * t51 + t173 * t57 + t165
  t176 = t175 * s0
  t177 = t93 * t163
  t180 = params.c[27]
  t181 = params.c[28]
  t182 = t181 * t42
  t184 = params.c[29]
  t185 = t184 * t48
  t187 = t182 * t45 + t185 * t51 + t180
  t188 = t187 * t107
  t189 = t115 * t163
  t192 = params.c[30]
  t193 = params.c[31]
  t194 = t193 * t42
  t196 = params.c[32]
  t197 = t196 * t48
  t199 = params.c[33]
  t200 = t199 * t54
  t202 = t194 * t45 + t197 * t51 + t200 * t57 + t192
  t203 = t162 ** 2
  t204 = 0.1e1 / t203
  t206 = params.c[34]
  t207 = params.c[35]
  t208 = t207 * t42
  t210 = params.c[36]
  t211 = t210 * t48
  t213 = t208 * t45 + t211 * t51 + t206
  t214 = t213 * s0
  t215 = t93 * t204
  t218 = params.c[37]
  t219 = params.c[38]
  t220 = t219 * t42
  t222 = params.c[39]
  t223 = t222 * t48
  t225 = t220 * t45 + t223 * t51 + t218
  t227 = 0.1e1 / t203 / t162
  t229 = t28 + t43 * t45 + t49 * t51 + t55 * t57 + t61 * t63 + t67 * t69 + 0.4e-2 * t85 * t93 + 0.16e-4 * t108 * t115 + 0.64e-7 * t127 * t132 + t148 * t163 + 0.4e-2 * t176 * t177 + 0.16e-4 * t188 * t189 + t202 * t204 + 0.4e-2 * t214 * t215 + t225 * t227
  t233 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t229)
  t234 = r1 <= f.p.dens_threshold
  t235 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t236 = 0.1e1 + t235
  t237 = t236 <= f.p.zeta_threshold
  t238 = t236 ** (0.1e1 / 0.3e1)
  t240 = f.my_piecewise3(t237, t22, t238 * t236)
  t241 = t240 * t26
  t242 = r1 ** (0.1e1 / 0.3e1)
  t243 = t242 ** 2
  t245 = 0.1e1 / t243 / r1
  t246 = tau1 * t245
  t247 = t36 - t246
  t248 = t29 * t247
  t249 = t36 + t246
  t250 = 0.1e1 / t249
  t252 = t247 ** 2
  t253 = t47 * t252
  t254 = t249 ** 2
  t255 = 0.1e1 / t254
  t257 = t252 * t247
  t258 = t53 * t257
  t260 = 0.1e1 / t254 / t249
  t262 = t252 ** 2
  t263 = t59 * t262
  t264 = t254 ** 2
  t265 = 0.1e1 / t264
  t268 = t65 * t262 * t247
  t270 = 0.1e1 / t264 / t249
  t272 = t72 * t247
  t274 = t75 * t252
  t276 = t78 * t257
  t278 = t81 * t262
  t280 = t272 * t250 + t274 * t255 + t276 * t260 + t278 * t265 + t71
  t281 = t280 * s2
  t282 = r1 ** 2
  t284 = 0.1e1 / t243 / t282
  t287 = 0.1e1 + 0.4e-2 * s2 * t284
  t288 = 0.1e1 / t287
  t289 = t284 * t288
  t292 = t97 * t247
  t294 = t100 * t252
  t296 = t103 * t257
  t298 = t292 * t250 + t294 * t255 + t296 * t260 + t96
  t299 = s2 ** 2
  t300 = t298 * t299
  t301 = t282 ** 2
  t304 = 0.1e1 / t242 / t301 / r1
  t305 = t287 ** 2
  t306 = 0.1e1 / t305
  t307 = t304 * t306
  t310 = t119 * t247
  t312 = t122 * t252
  t314 = t310 * t250 + t312 * t255 + t118
  t315 = t299 * s2
  t316 = t314 * t315
  t317 = t301 ** 2
  t320 = 0.1e1 / t305 / t287
  t321 = 0.1e1 / t317 * t320
  t324 = t136 * t247
  t326 = t139 * t252
  t328 = t142 * t257
  t330 = t145 * t262
  t332 = t324 * t250 + t326 * t255 + t328 * t260 + t330 * t265 + t135
  t333 = f.my_piecewise5(t155, t11, t153, t15, -t17)
  t334 = 0.1e1 + t333
  t336 = (0.1e1 / t334) ** (0.1e1 / 0.3e1)
  t339 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 * t151 * t336
  t340 = 0.1e1 / t339
  t342 = t166 * t247
  t344 = t169 * t252
  t346 = t172 * t257
  t348 = t342 * t250 + t344 * t255 + t346 * t260 + t165
  t349 = t348 * s2
  t350 = t289 * t340
  t353 = t181 * t247
  t355 = t184 * t252
  t357 = t353 * t250 + t355 * t255 + t180
  t358 = t357 * t299
  t359 = t307 * t340
  t362 = t193 * t247
  t364 = t196 * t252
  t366 = t199 * t257
  t368 = t362 * t250 + t364 * t255 + t366 * t260 + t192
  t369 = t339 ** 2
  t370 = 0.1e1 / t369
  t372 = t207 * t247
  t374 = t210 * t252
  t376 = t372 * t250 + t374 * t255 + t206
  t377 = t376 * s2
  t378 = t289 * t370
  t381 = t219 * t247
  t383 = t222 * t252
  t385 = t381 * t250 + t383 * t255 + t218
  t387 = 0.1e1 / t369 / t339
  t389 = t28 + t248 * t250 + t253 * t255 + t258 * t260 + t263 * t265 + t268 * t270 + 0.4e-2 * t281 * t289 + 0.16e-4 * t300 * t307 + 0.64e-7 * t316 * t321 + t332 * t340 + 0.4e-2 * t349 * t350 + 0.16e-4 * t358 * t359 + t368 * t370 + 0.4e-2 * t377 * t378 + t385 * t387
  t393 = f.my_piecewise3(t234, 0, -0.3e1 / 0.8e1 * t5 * t241 * t389)
  t394 = t6 ** 2
  t396 = t16 / t394
  t397 = t7 - t396
  t398 = f.my_piecewise5(t10, 0, t14, 0, t397)
  t401 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t398)
  t406 = t26 ** 2
  t407 = 0.1e1 / t406
  t411 = t5 * t25 * t407 * t229 / 0.8e1
  t412 = t59 * t54
  t414 = t63 * tau0 * t88
  t418 = t69 * tau0 * t88
  t421 = t65 * t60
  t425 = 0.1e1 / t62 / t50
  t430 = t86 * r0
  t433 = 0.1e1 / t38 / t430 * t92
  t440 = 0.1e1 / t37 / t109 / t86 * t114
  t441 = t440 * t163
  t447 = t148 * t204
  t450 = 0.1e1 / t26 / t6 * t150
  t452 = 0.13333333333333333333333333333333333333333333333333e0 * t450 * t159
  t453 = t159 ** 2
  t455 = t157 ** 2
  t457 = 0.1e1 / t453 / t455
  t458 = f.my_piecewise5(t153, 0, t155, 0, t397)
  t462 = -t452 - 0.13333333333333333333333333333333333333333333333333e0 * t151 * t457 * t458
  t464 = t202 * t227
  t467 = t203 ** 2
  t469 = t225 / t467
  t473 = t88 * t45
  t477 = t51 * tau0 * t88
  t480 = t222 * t42
  t484 = t57 * tau0 * t88
  t494 = t139 * t42
  t499 = t142 * t48
  t504 = t145 * t54
  t516 = t196 * t42
  t521 = t199 * t48
  t528 = t176 * t88
  t529 = t92 * t204
  t533 = t188 * t112
  t534 = t114 * t204
  t538 = t214 * t88
  t539 = t92 * t227
  t548 = t210 * t42
  t561 = 0.20e2 / 0.3e1 * t412 * t414 + 0.20e2 / 0.3e1 * t61 * t418 + 0.25e2 / 0.3e1 * t421 * t418 + 0.25e2 / 0.3e1 * t67 * t425 * tau0 * t88 - 0.10666666666666666666666666666666666666666666666667e-1 * t176 * t433 * t163 - 0.85333333333333333333333333333333333333333333333333e-4 * t188 * t441 - 0.10666666666666666666666666666666666666666666666667e-1 * t214 * t433 * t204 - t447 * t462 - 0.2e1 * t464 * t462 - 0.3e1 * t469 * t462 + (0.5e1 / 0.3e1 * t219 * tau0 * t473 + 0.5e1 / 0.3e1 * t220 * t477 + 0.10e2 / 0.3e1 * t480 * t477 + 0.10e2 / 0.3e1 * t223 * t484) * t227 + (0.5e1 / 0.3e1 * t136 * tau0 * t473 + 0.5e1 / 0.3e1 * t137 * t477 + 0.10e2 / 0.3e1 * t494 * t477 + 0.10e2 / 0.3e1 * t140 * t484 + 0.5e1 * t499 * t484 + 0.5e1 * t143 * t414 + 0.20e2 / 0.3e1 * t504 * t414 + 0.20e2 / 0.3e1 * t146 * t418) * t163 + (0.5e1 / 0.3e1 * t193 * tau0 * t473 + 0.5e1 / 0.3e1 * t194 * t477 + 0.10e2 / 0.3e1 * t516 * t477 + 0.10e2 / 0.3e1 * t197 * t484 + 0.5e1 * t521 * t484 + 0.5e1 * t200 * t414) * t204 - 0.4e-2 * t528 * t529 * t462 - 0.16e-4 * t533 * t534 * t462 - 0.8e-2 * t538 * t539 * t462 + 0.4e-2 * (0.5e1 / 0.3e1 * t207 * tau0 * t473 + 0.5e1 / 0.3e1 * t208 * t477 + 0.10e2 / 0.3e1 * t548 * t477 + 0.10e2 / 0.3e1 * t211 * t484) * s0 * t215 + 0.42666666666666666666666666666666666666666666666668e-4 * t213 * t107 * t440 * t204
  t567 = t169 * t42
  t572 = t172 * t48
  t589 = t184 * t42
  t601 = 0.1e1 / t128 / r0 * t131
  t607 = t47 * t42
  t612 = t53 * t48
  t622 = t75 * t42
  t627 = t78 * t48
  t632 = t81 * t54
  t649 = t100 * t42
  t654 = t103 * t48
  t671 = t122 * t42
  t680 = t107 ** 2
  t685 = t113 ** 2
  t686 = 0.1e1 / t685
  t699 = 0.4e-2 * (0.5e1 / 0.3e1 * t166 * tau0 * t473 + 0.5e1 / 0.3e1 * t167 * t477 + 0.10e2 / 0.3e1 * t567 * t477 + 0.10e2 / 0.3e1 * t170 * t484 + 0.5e1 * t572 * t484 + 0.5e1 * t173 * t414) * s0 * t177 + 0.42666666666666666666666666666666666666666666666668e-4 * t175 * t107 * t441 + 0.16e-4 * (0.5e1 / 0.3e1 * t181 * tau0 * t473 + 0.5e1 / 0.3e1 * t182 * t477 + 0.10e2 / 0.3e1 * t589 * t477 + 0.10e2 / 0.3e1 * t185 * t484) * t107 * t189 + 0.34133333333333333333333333333333333333333333333334e-6 * t187 * t126 * t601 * t163 + 0.5e1 / 0.3e1 * t43 * t477 + 0.10e2 / 0.3e1 * t607 * t477 + 0.10e2 / 0.3e1 * t49 * t484 + 0.5e1 * t612 * t484 + 0.5e1 * t55 * t414 + 0.4e-2 * (0.5e1 / 0.3e1 * t72 * tau0 * t473 + 0.5e1 / 0.3e1 * t73 * t477 + 0.10e2 / 0.3e1 * t622 * t477 + 0.10e2 / 0.3e1 * t76 * t484 + 0.5e1 * t627 * t484 + 0.5e1 * t79 * t414 + 0.20e2 / 0.3e1 * t632 * t414 + 0.20e2 / 0.3e1 * t82 * t418) * s0 * t93 + 0.42666666666666666666666666666666666666666666666668e-4 * t84 * t107 * t440 + 0.16e-4 * (0.5e1 / 0.3e1 * t97 * tau0 * t473 + 0.5e1 / 0.3e1 * t98 * t477 + 0.10e2 / 0.3e1 * t649 * t477 + 0.10e2 / 0.3e1 * t101 * t484 + 0.5e1 * t654 * t484 + 0.5e1 * t104 * t414) * t107 * t115 + 0.34133333333333333333333333333333333333333333333334e-6 * t106 * t126 * t601 + 0.64e-7 * (0.5e1 / 0.3e1 * t119 * tau0 * t473 + 0.5e1 / 0.3e1 * t120 * t477 + 0.10e2 / 0.3e1 * t671 * t477 + 0.10e2 / 0.3e1 * t123 * t484) * t126 * t132 + 0.20480000000000000000000000000000000000000000000001e-8 * t125 * t680 / t38 / t128 / t430 * t686 - 0.10666666666666666666666666666666666666666666666667e-1 * t85 * t433 - 0.85333333333333333333333333333333333333333333333333e-4 * t108 * t440 - 0.512e-6 * t127 * t601 + 0.5e1 / 0.3e1 * t29 * tau0 * t473
  t705 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t401 * t26 * t229 - t411 - 0.3e1 / 0.8e1 * t5 * t27 * (t561 + t699))
  t706 = -t397
  t707 = f.my_piecewise5(t14, 0, t10, 0, t706)
  t710 = f.my_piecewise3(t237, 0, 0.4e1 / 0.3e1 * t238 * t707)
  t718 = t5 * t240 * t407 * t389 / 0.8e1
  t719 = t332 * t370
  t721 = 0.13333333333333333333333333333333333333333333333333e0 * t450 * t336
  t722 = t336 ** 2
  t724 = t334 ** 2
  t726 = 0.1e1 / t722 / t724
  t727 = f.my_piecewise5(t155, 0, t153, 0, t706)
  t731 = -t721 - 0.13333333333333333333333333333333333333333333333333e0 * t151 * t726 * t727
  t733 = t349 * t284
  t734 = t288 * t370
  t738 = t358 * t304
  t739 = t306 * t370
  t743 = t368 * t387
  t746 = t377 * t284
  t747 = t288 * t387
  t751 = t369 ** 2
  t753 = t385 / t751
  t761 = f.my_piecewise3(t234, 0, -0.3e1 / 0.8e1 * t5 * t710 * t26 * t389 - t718 - 0.3e1 / 0.8e1 * t5 * t241 * (-t719 * t731 - 0.4e-2 * t733 * t734 * t731 - 0.16e-4 * t738 * t739 * t731 - 0.2e1 * t743 * t731 - 0.8e-2 * t746 * t747 * t731 - 0.3e1 * t753 * t731))
  vrho_0_ = t233 + t393 + t6 * (t705 + t761)
  t764 = -t7 - t396
  t765 = f.my_piecewise5(t10, 0, t14, 0, t764)
  t768 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t765)
  t773 = f.my_piecewise5(t153, 0, t155, 0, t764)
  t777 = -t452 - 0.13333333333333333333333333333333333333333333333333e0 * t151 * t457 * t773
  t797 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t768 * t26 * t229 - t411 - 0.3e1 / 0.8e1 * t5 * t27 * (-t447 * t777 - 0.4e-2 * t528 * t529 * t777 - 0.16e-4 * t533 * t534 * t777 - 0.2e1 * t464 * t777 - 0.8e-2 * t538 * t539 * t777 - 0.3e1 * t469 * t777))
  t798 = -t764
  t799 = f.my_piecewise5(t14, 0, t10, 0, t798)
  t802 = f.my_piecewise3(t237, 0, 0.4e1 / 0.3e1 * t238 * t799)
  t807 = f.my_piecewise5(t155, 0, t153, 0, t798)
  t811 = -t721 - 0.13333333333333333333333333333333333333333333333333e0 * t151 * t726 * t807
  t818 = t284 * t250
  t822 = t255 * tau1 * t284
  t825 = t196 * t247
  t829 = t260 * tau1 * t284
  t832 = t199 * t252
  t836 = t265 * tau1 * t284
  t846 = t222 * t247
  t858 = t139 * t247
  t863 = t142 * t252
  t868 = t145 * t257
  t872 = t270 * tau1 * t284
  t877 = t282 * r1
  t880 = 0.1e1 / t243 / t877 * t288
  t887 = 0.1e1 / t242 / t301 / t282 * t306
  t888 = t887 * t340
  t899 = t210 * t247
  t913 = t169 * t247
  t918 = t172 * t252
  t929 = t47 * t247
  t934 = t53 * t252
  t939 = t59 * t257
  t944 = -0.2e1 * t743 * t811 - 0.3e1 * t753 * t811 - t719 * t811 + (0.5e1 / 0.3e1 * t193 * tau1 * t818 + 0.5e1 / 0.3e1 * t362 * t822 + 0.10e2 / 0.3e1 * t825 * t822 + 0.10e2 / 0.3e1 * t364 * t829 + 0.5e1 * t832 * t829 + 0.5e1 * t366 * t836) * t370 + (0.5e1 / 0.3e1 * t219 * tau1 * t818 + 0.5e1 / 0.3e1 * t381 * t822 + 0.10e2 / 0.3e1 * t846 * t822 + 0.10e2 / 0.3e1 * t383 * t829) * t387 + (0.5e1 / 0.3e1 * t136 * tau1 * t818 + 0.5e1 / 0.3e1 * t324 * t822 + 0.10e2 / 0.3e1 * t858 * t822 + 0.10e2 / 0.3e1 * t326 * t829 + 0.5e1 * t863 * t829 + 0.5e1 * t328 * t836 + 0.20e2 / 0.3e1 * t868 * t836 + 0.20e2 / 0.3e1 * t330 * t872) * t340 - 0.10666666666666666666666666666666666666666666666667e-1 * t349 * t880 * t340 - 0.85333333333333333333333333333333333333333333333333e-4 * t358 * t888 - 0.10666666666666666666666666666666666666666666666667e-1 * t377 * t880 * t370 + 0.4e-2 * (0.5e1 / 0.3e1 * t207 * tau1 * t818 + 0.5e1 / 0.3e1 * t372 * t822 + 0.10e2 / 0.3e1 * t899 * t822 + 0.10e2 / 0.3e1 * t374 * t829) * s2 * t378 + 0.4e-2 * (0.5e1 / 0.3e1 * t166 * tau1 * t818 + 0.5e1 / 0.3e1 * t342 * t822 + 0.10e2 / 0.3e1 * t913 * t822 + 0.10e2 / 0.3e1 * t344 * t829 + 0.5e1 * t918 * t829 + 0.5e1 * t346 * t836) * s2 * t350 + 0.5e1 / 0.3e1 * t248 * t822 + 0.10e2 / 0.3e1 * t929 * t822 + 0.10e2 / 0.3e1 * t253 * t829 + 0.5e1 * t934 * t829 + 0.5e1 * t258 * t836 + 0.20e2 / 0.3e1 * t939 * t836 + 0.20e2 / 0.3e1 * t263 * t872
  t945 = t65 * t262
  t949 = 0.1e1 / t264 / t254
  t966 = t184 * t247
  t978 = 0.1e1 / t317 / r1 * t320
  t999 = t122 * t247
  t1008 = t299 ** 2
  t1013 = t305 ** 2
  t1014 = 0.1e1 / t1013
  t1032 = t75 * t247
  t1037 = t78 * t252
  t1042 = t81 * t257
  t1059 = t100 * t247
  t1064 = t103 * t252
  t1073 = 0.25e2 / 0.3e1 * t945 * t872 + 0.25e2 / 0.3e1 * t268 * t949 * tau1 * t284 + 0.42666666666666666666666666666666666666666666666668e-4 * t376 * t299 * t887 * t370 + 0.42666666666666666666666666666666666666666666666668e-4 * t348 * t299 * t888 + 0.16e-4 * (0.5e1 / 0.3e1 * t181 * tau1 * t818 + 0.5e1 / 0.3e1 * t353 * t822 + 0.10e2 / 0.3e1 * t966 * t822 + 0.10e2 / 0.3e1 * t355 * t829) * t299 * t359 + 0.34133333333333333333333333333333333333333333333334e-6 * t357 * t315 * t978 * t340 - 0.4e-2 * t733 * t734 * t811 - 0.16e-4 * t738 * t739 * t811 - 0.8e-2 * t746 * t747 * t811 + 0.34133333333333333333333333333333333333333333333334e-6 * t298 * t315 * t978 + 0.64e-7 * (0.5e1 / 0.3e1 * t119 * tau1 * t818 + 0.5e1 / 0.3e1 * t310 * t822 + 0.10e2 / 0.3e1 * t999 * t822 + 0.10e2 / 0.3e1 * t312 * t829) * t315 * t321 + 0.20480000000000000000000000000000000000000000000001e-8 * t314 * t1008 / t243 / t317 / t877 * t1014 - 0.85333333333333333333333333333333333333333333333333e-4 * t300 * t887 - 0.512e-6 * t316 * t978 - 0.10666666666666666666666666666666666666666666666667e-1 * t281 * t880 + 0.5e1 / 0.3e1 * t29 * tau1 * t818 + 0.4e-2 * (0.5e1 / 0.3e1 * t72 * tau1 * t818 + 0.5e1 / 0.3e1 * t272 * t822 + 0.10e2 / 0.3e1 * t1032 * t822 + 0.10e2 / 0.3e1 * t274 * t829 + 0.5e1 * t1037 * t829 + 0.5e1 * t276 * t836 + 0.20e2 / 0.3e1 * t1042 * t836 + 0.20e2 / 0.3e1 * t278 * t872) * s2 * t289 + 0.42666666666666666666666666666666666666666666666668e-4 * t280 * t299 * t887 + 0.16e-4 * (0.5e1 / 0.3e1 * t97 * tau1 * t818 + 0.5e1 / 0.3e1 * t292 * t822 + 0.10e2 / 0.3e1 * t1059 * t822 + 0.10e2 / 0.3e1 * t294 * t829 + 0.5e1 * t1064 * t829 + 0.5e1 * t296 * t836) * t299 * t307
  t1079 = f.my_piecewise3(t234, 0, -0.3e1 / 0.8e1 * t5 * t802 * t26 * t389 - t718 - 0.3e1 / 0.8e1 * t5 * t241 * (t944 + t1073))
  vrho_1_ = t233 + t393 + t6 * (t797 + t1079)
  t1119 = 0.4e-2 * t84 * t88 * t92 - 0.16e-4 * t85 * t115 + 0.32e-4 * t106 * s0 * t115 - 0.128e-6 * t108 * t132 + 0.192e-6 * t125 * t107 * t132 - 0.768e-9 * t127 / t38 / t128 / t86 * t686 + 0.4e-2 * t175 * t88 * t92 * t163 - 0.16e-4 * t176 * t189 + 0.32e-4 * t187 * s0 * t189 - 0.128e-6 * t188 * t132 * t163 + 0.4e-2 * t213 * t88 * t529 - 0.16e-4 * t214 * t115 * t204
  t1123 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1119)
  vsigma_0_ = t6 * t1123
  vsigma_1_ = 0.0e0
  t1161 = 0.4e-2 * t280 * t284 * t288 - 0.16e-4 * t281 * t307 + 0.32e-4 * t298 * s2 * t307 - 0.128e-6 * t300 * t321 + 0.192e-6 * t314 * t299 * t321 - 0.768e-9 * t316 / t243 / t317 / t282 * t1014 + 0.4e-2 * t348 * t284 * t288 * t340 - 0.16e-4 * t349 * t359 + 0.32e-4 * t357 * s2 * t359 - 0.128e-6 * t358 * t321 * t340 + 0.4e-2 * t376 * t284 * t734 - 0.16e-4 * t377 * t307 * t370
  t1165 = f.my_piecewise3(t234, 0, -0.3e1 / 0.8e1 * t5 * t241 * t1161)
  vsigma_2_ = t6 * t1165
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t1168 = t51 * t40
  t1172 = t57 * t40
  t1177 = t63 * t40
  t1182 = t69 * t40
  t1311 = -t29 * t40 * t45 - t43 * t1168 - 0.2e1 * t607 * t1168 - 0.2e1 * t49 * t1172 - 0.3e1 * t612 * t1172 - 0.3e1 * t55 * t1177 - 0.4e1 * t412 * t1177 - 0.4e1 * t61 * t1182 - 0.5e1 * t421 * t1182 - 0.5e1 * t67 * t425 * t40 + 0.4e-2 * (-t72 * t40 * t45 - 0.2e1 * t622 * t1168 - t73 * t1168 - 0.3e1 * t627 * t1172 - 0.2e1 * t76 * t1172 - 0.4e1 * t632 * t1177 - 0.3e1 * t79 * t1177 - 0.4e1 * t82 * t1182) * s0 * t93 + 0.16e-4 * (-t97 * t40 * t45 - 0.2e1 * t101 * t1172 - 0.3e1 * t104 * t1177 - 0.2e1 * t649 * t1168 - t98 * t1168 - 0.3e1 * t654 * t1172) * t107 * t115 + 0.64e-7 * (-t119 * t40 * t45 - t120 * t1168 - 0.2e1 * t671 * t1168 - 0.2e1 * t123 * t1172) * t126 * t132 + (-t136 * t40 * t45 - t137 * t1168 - 0.2e1 * t494 * t1168 - 0.2e1 * t140 * t1172 - 0.3e1 * t499 * t1172 - 0.3e1 * t143 * t1177 - 0.4e1 * t504 * t1177 - 0.4e1 * t146 * t1182) * t163 + 0.4e-2 * (-t166 * t40 * t45 - t167 * t1168 - 0.2e1 * t567 * t1168 - 0.2e1 * t170 * t1172 - 0.3e1 * t572 * t1172 - 0.3e1 * t173 * t1177) * s0 * t177 + 0.16e-4 * (-t181 * t40 * t45 - t182 * t1168 - 0.2e1 * t589 * t1168 - 0.2e1 * t185 * t1172) * t107 * t189 + (-t193 * t40 * t45 - t194 * t1168 - 0.2e1 * t516 * t1168 - 0.2e1 * t197 * t1172 - 0.3e1 * t521 * t1172 - 0.3e1 * t200 * t1177) * t204 + 0.4e-2 * (-t207 * t40 * t45 - t208 * t1168 - 0.2e1 * t548 * t1168 - 0.2e1 * t211 * t1172) * s0 * t215 + (-t219 * t40 * t45 - t220 * t1168 - 0.2e1 * t480 * t1168 - 0.2e1 * t223 * t1172) * t227
  t1315 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1311)
  vtau_0_ = t6 * t1315
  t1318 = t255 * t245
  t1322 = t260 * t245
  t1327 = t265 * t245
  t1332 = t270 * t245
  t1461 = -t29 * t245 * t250 - t248 * t1318 - 0.2e1 * t929 * t1318 - 0.2e1 * t253 * t1322 - 0.3e1 * t934 * t1322 - 0.3e1 * t258 * t1327 - 0.4e1 * t939 * t1327 - 0.4e1 * t263 * t1332 - 0.5e1 * t945 * t1332 - 0.5e1 * t268 * t949 * t245 + 0.4e-2 * (-t72 * t245 * t250 - 0.2e1 * t1032 * t1318 - 0.3e1 * t1037 * t1322 - 0.4e1 * t1042 * t1327 - t272 * t1318 - 0.2e1 * t274 * t1322 - 0.3e1 * t276 * t1327 - 0.4e1 * t278 * t1332) * s2 * t289 + 0.16e-4 * (-t97 * t245 * t250 - 0.2e1 * t1059 * t1318 - 0.3e1 * t1064 * t1322 - t292 * t1318 - 0.2e1 * t294 * t1322 - 0.3e1 * t296 * t1327) * t299 * t307 + 0.64e-7 * (-t119 * t245 * t250 - t310 * t1318 - 0.2e1 * t999 * t1318 - 0.2e1 * t312 * t1322) * t315 * t321 + (-t136 * t245 * t250 - t324 * t1318 - 0.2e1 * t858 * t1318 - 0.2e1 * t326 * t1322 - 0.3e1 * t863 * t1322 - 0.3e1 * t328 * t1327 - 0.4e1 * t868 * t1327 - 0.4e1 * t330 * t1332) * t340 + 0.4e-2 * (-t166 * t245 * t250 - t342 * t1318 - 0.2e1 * t913 * t1318 - 0.2e1 * t344 * t1322 - 0.3e1 * t918 * t1322 - 0.3e1 * t346 * t1327) * s2 * t350 + 0.16e-4 * (-t181 * t245 * t250 - t353 * t1318 - 0.2e1 * t966 * t1318 - 0.2e1 * t355 * t1322) * t299 * t359 + (-t193 * t245 * t250 - t362 * t1318 - 0.2e1 * t825 * t1318 - 0.2e1 * t364 * t1322 - 0.3e1 * t832 * t1322 - 0.3e1 * t366 * t1327) * t370 + 0.4e-2 * (-t207 * t245 * t250 - t372 * t1318 - 0.2e1 * t899 * t1318 - 0.2e1 * t374 * t1322) * s2 * t378 + (-t219 * t245 * t250 - t381 * t1318 - 0.2e1 * t846 * t1318 - 0.2e1 * t383 * t1322) * t387
  t1465 = f.my_piecewise3(t234, 0, -0.3e1 / 0.8e1 * t5 * t241 * t1461)
  vtau_1_ = t6 * t1465
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  mn12_omega_x = 2.5

  mn12_gamma_x = 0.004

  mn12_wx = lambda t: (K_FACTOR_C - t) / (K_FACTOR_C + t)

  mn12_vx = lambda rs, z: 1 / (1 + rs / (mn12_omega_x * f.RS_FACTOR) * (2 / (1 + z)) ** (1 / 3))

  mn12_ux = lambda x: mn12_gamma_x * x ** 2 / (1 + mn12_gamma_x * x ** 2)

  mn12_pol1 = lambda t: params_c[1] + params_c[2] * mn12_wx(t) + params_c[3] * mn12_wx(t) ** 2 + params_c[4] * mn12_wx(t) ** 3 + params_c[5] * mn12_wx(t) ** 4 + params_c[6] * mn12_wx(t) ** 5

  mn12_pol2 = lambda t: params_c[7] + params_c[8] * mn12_wx(t) + params_c[9] * mn12_wx(t) ** 2 + params_c[10] * mn12_wx(t) ** 3 + params_c[11] * mn12_wx(t) ** 4

  mn12_pol3 = lambda t: params_c[12] + params_c[13] * mn12_wx(t) + params_c[14] * mn12_wx(t) ** 2 + params_c[15] * mn12_wx(t) ** 3

  mn12_pol4 = lambda t: params_c[16] + params_c[17] * mn12_wx(t) + params_c[18] * mn12_wx(t) ** 2

  mn12_pol5 = lambda t: params_c[19] + params_c[20] * mn12_wx(t) + params_c[21] * mn12_wx(t) ** 2 + params_c[22] * mn12_wx(t) ** 3 + params_c[23] * mn12_wx(t) ** 4

  mn12_pol6 = lambda t: params_c[24] + params_c[25] * mn12_wx(t) + params_c[26] * mn12_wx(t) ** 2 + params_c[27] * mn12_wx(t) ** 3

  mn12_pol7 = lambda t: params_c[28] + params_c[29] * mn12_wx(t) + params_c[30] * mn12_wx(t) ** 2

  mn12_pol8 = lambda t: params_c[31] + params_c[32] * mn12_wx(t) + params_c[33] * mn12_wx(t) ** 2 + params_c[34] * mn12_wx(t) ** 3

  mn12_pol9 = lambda t: params_c[35] + params_c[36] * mn12_wx(t) + params_c[37] * mn12_wx(t) ** 2

  mn12_pol10 = lambda t: params_c[38] + params_c[39] * mn12_wx(t) + params_c[40] * mn12_wx(t) ** 2

  mn12_f = lambda rs, z, x, u, t: +mn12_pol1(t) + mn12_pol2(t) * mn12_ux(x) + mn12_pol3(t) * mn12_ux(x) ** 2 + mn12_pol4(t) * mn12_ux(x) ** 3 + mn12_pol5(t) * mn12_vx(rs, z) + mn12_pol6(t) * mn12_ux(x) * mn12_vx(rs, z) + mn12_pol7(t) * mn12_ux(x) ** 2 * mn12_vx(rs, z) + mn12_pol8(t) * mn12_vx(rs, z) ** 2 + mn12_pol9(t) * mn12_ux(x) * mn12_vx(rs, z) ** 2 + mn12_pol10(t) * mn12_vx(rs, z) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange_nsp(f, params, mn12_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t21 = params.c[1]
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = 0.3e1 / 0.10e2 * t23 * t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = tau0 * t30
  t32 = t18 ** 2
  t34 = 0.1e1 / t32 / r0
  t35 = t31 * t34
  t36 = t28 - t35
  t37 = t21 * t36
  t38 = t28 + t35
  t39 = 0.1e1 / t38
  t41 = params.c[2]
  t42 = t36 ** 2
  t43 = t41 * t42
  t44 = t38 ** 2
  t45 = 0.1e1 / t44
  t47 = params.c[3]
  t48 = t42 * t36
  t49 = t47 * t48
  t51 = 0.1e1 / t44 / t38
  t53 = params.c[4]
  t54 = t42 ** 2
  t55 = t53 * t54
  t56 = t44 ** 2
  t57 = 0.1e1 / t56
  t59 = params.c[5]
  t61 = t59 * t54 * t36
  t63 = 0.1e1 / t56 / t38
  t66 = params.c[7]
  t67 = t66 * t36
  t69 = params.c[8]
  t70 = t69 * t42
  t72 = params.c[9]
  t73 = t72 * t48
  t75 = params.c[10]
  t76 = t75 * t54
  t78 = t67 * t39 + t70 * t45 + t73 * t51 + t76 * t57 + params.c[6]
  t79 = t78 * s0
  t80 = r0 ** 2
  t82 = 0.1e1 / t32 / t80
  t83 = t30 * t82
  t87 = 0.1e1 + 0.4e-2 * s0 * t30 * t82
  t88 = 0.1e1 / t87
  t89 = t83 * t88
  t93 = params.c[12]
  t94 = t93 * t36
  t96 = params.c[13]
  t97 = t96 * t42
  t99 = params.c[14]
  t100 = t99 * t48
  t102 = t100 * t51 + t94 * t39 + t97 * t45 + params.c[11]
  t103 = s0 ** 2
  t104 = t102 * t103
  t105 = t80 ** 2
  t108 = 0.1e1 / t18 / t105 / r0
  t110 = t87 ** 2
  t111 = 0.1e1 / t110
  t112 = t29 * t108 * t111
  t116 = params.c[16]
  t117 = t116 * t36
  t119 = params.c[17]
  t120 = t119 * t42
  t122 = t117 * t39 + t120 * t45 + params.c[15]
  t123 = t103 * s0
  t124 = t122 * t123
  t125 = t105 ** 2
  t128 = 0.1e1 / t110 / t87
  t129 = 0.1e1 / t125 * t128
  t133 = params.c[19]
  t134 = t133 * t36
  t136 = params.c[20]
  t137 = t136 * t42
  t139 = params.c[21]
  t140 = t139 * t48
  t142 = params.c[22]
  t143 = t142 * t54
  t145 = t134 * t39 + t137 * t45 + t140 * t51 + t143 * t57 + params.c[18]
  t149 = (0.1e1 / t11) ** (0.1e1 / 0.3e1)
  t152 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 / t18 * t29 * t149
  t153 = 0.1e1 / t152
  t156 = params.c[24]
  t157 = t156 * t36
  t159 = params.c[25]
  t160 = t159 * t42
  t162 = params.c[26]
  t163 = t162 * t48
  t165 = t157 * t39 + t160 * t45 + t163 * t51 + params.c[23]
  t166 = t165 * s0
  t167 = t166 * t30
  t168 = t82 * t88
  t169 = t168 * t153
  t173 = params.c[28]
  t174 = t173 * t36
  t176 = params.c[29]
  t177 = t176 * t42
  t179 = t174 * t39 + t177 * t45 + params.c[27]
  t180 = t179 * t103
  t181 = t180 * t29
  t182 = t108 * t111
  t183 = t182 * t153
  t187 = params.c[31]
  t188 = t187 * t36
  t190 = params.c[32]
  t191 = t190 * t42
  t193 = params.c[33]
  t194 = t193 * t48
  t196 = t188 * t39 + t191 * t45 + t194 * t51 + params.c[30]
  t197 = t152 ** 2
  t198 = 0.1e1 / t197
  t201 = params.c[35]
  t202 = t201 * t36
  t204 = params.c[36]
  t205 = t204 * t42
  t207 = t202 * t39 + t205 * t45 + params.c[34]
  t208 = t207 * s0
  t209 = t208 * t30
  t210 = t168 * t198
  t214 = params.c[38]
  t215 = t214 * t36
  t217 = params.c[39]
  t218 = t217 * t42
  t220 = t215 * t39 + t218 * t45 + params.c[37]
  t222 = 0.1e1 / t197 / t152
  t224 = params.c[0] + t37 * t39 + t43 * t45 + t49 * t51 + t55 * t57 + t61 * t63 + 0.4e-2 * t79 * t89 + 0.32e-4 * t104 * t112 + 0.256e-6 * t124 * t129 + t145 * t153 + 0.4e-2 * t167 * t169 + 0.32e-4 * t181 * t183 + t196 * t198 + 0.4e-2 * t209 * t210 + t220 * t222
  t228 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t224)
  t235 = t83 * t39
  t239 = t31 * t82
  t242 = t176 * t36
  t260 = t204 * t36
  t274 = t105 * t80
  t276 = 0.1e1 / t18 / t274
  t277 = t276 * t111
  t281 = 0.1e1 / t105
  t291 = 0.1e1 / t18 / r0 * t29 * t149
  t294 = t197 ** 2
  t305 = 0.1e1 / t125 / r0 * t128
  t315 = t69 * t36
  t322 = t72 * t42
  t329 = t75 * t48
  t342 = t29 * t276 * t111
  t351 = t96 * t36
  t358 = t99 * t42
  t369 = t80 * r0
  t371 = 0.1e1 / t32 / t369
  t378 = t103 ** 2
  t383 = t110 ** 2
  t384 = 0.1e1 / t383
  t398 = t136 * t36
  t405 = t139 * t42
  t412 = t142 * t48
  t427 = t190 * t36
  t434 = t193 * t42
  t449 = t217 * t36
  t458 = 0.32e-4 * (0.5e1 / 0.3e1 * t173 * tau0 * t235 + 0.5e1 / 0.3e1 * t174 * t45 * t239 + 0.10e2 / 0.3e1 * t242 * t45 * t239 + 0.10e2 / 0.3e1 * t177 * t51 * t239) * t103 * t29 * t183 + 0.4e-2 * (0.5e1 / 0.3e1 * t201 * tau0 * t235 + 0.5e1 / 0.3e1 * t202 * t45 * t239 + 0.10e2 / 0.3e1 * t260 * t45 * t239 + 0.10e2 / 0.3e1 * t205 * t51 * t239) * s0 * t30 * t210 + 0.85333333333333333333333333333333333333333333333336e-4 * t207 * t103 * t29 * t277 * t198 + 0.21333333333333333333333333333333333333333333333333e-2 * t208 * t281 * t88 * t222 * t149 + 0.26666666666666666666666666666666666666666666666666e0 * t196 * t222 * t291 + 0.39999999999999999999999999999999999999999999999999e0 * t220 / t294 * t291 + 0.5e1 / 0.3e1 * t21 * tau0 * t235 + 0.13653333333333333333333333333333333333333333333334e-5 * t179 * t123 * t305 * t153 + 0.4e-2 * (0.5e1 / 0.3e1 * t66 * tau0 * t235 + 0.5e1 / 0.3e1 * t67 * t45 * t239 + 0.10e2 / 0.3e1 * t315 * t45 * t239 + 0.10e2 / 0.3e1 * t70 * t51 * t239 + 0.5e1 * t322 * t51 * t239 + 0.5e1 * t73 * t57 * t239 + 0.20e2 / 0.3e1 * t329 * t57 * t239 + 0.20e2 / 0.3e1 * t76 * t63 * t239) * s0 * t89 + 0.85333333333333333333333333333333333333333333333336e-4 * t78 * t103 * t342 + 0.32e-4 * (0.5e1 / 0.3e1 * t93 * tau0 * t235 + 0.5e1 / 0.3e1 * t94 * t45 * t239 + 0.10e2 / 0.3e1 * t351 * t45 * t239 + 0.10e2 / 0.3e1 * t97 * t51 * t239 + 0.5e1 * t358 * t51 * t239 + 0.5e1 * t100 * t57 * t239) * t103 * t112 - 0.10666666666666666666666666666666666666666666666667e-1 * t79 * t30 * t371 * t88 - 0.17066666666666666666666666666666666666666666666667e-3 * t104 * t342 + 0.81920000000000000000000000000000000000000000000003e-8 * t122 * t378 / t32 / t125 / t369 * t384 * t30 + 0.13333333333333333333333333333333333333333333333333e0 * t145 * t198 * t291 + (0.5e1 / 0.3e1 * t133 * tau0 * t235 + 0.5e1 / 0.3e1 * t134 * t45 * t239 + 0.10e2 / 0.3e1 * t398 * t45 * t239 + 0.10e2 / 0.3e1 * t137 * t51 * t239 + 0.5e1 * t405 * t51 * t239 + 0.5e1 * t140 * t57 * t239 + 0.20e2 / 0.3e1 * t412 * t57 * t239 + 0.20e2 / 0.3e1 * t143 * t63 * t239) * t153 + (0.5e1 / 0.3e1 * t187 * tau0 * t235 + 0.5e1 / 0.3e1 * t188 * t45 * t239 + 0.10e2 / 0.3e1 * t427 * t45 * t239 + 0.10e2 / 0.3e1 * t191 * t51 * t239 + 0.5e1 * t434 * t51 * t239 + 0.5e1 * t194 * t57 * t239) * t198 + (0.5e1 / 0.3e1 * t214 * tau0 * t235 + 0.5e1 / 0.3e1 * t215 * t45 * t239 + 0.10e2 / 0.3e1 * t449 * t45 * t239 + 0.10e2 / 0.3e1 * t218 * t51 * t239) * t222
  t470 = t119 * t36
  t489 = t53 * t48
  t496 = t59 * t54
  t501 = 0.1e1 / t56 / t44
  t505 = t371 * t88
  t509 = t277 * t153
  t521 = t159 * t36
  t528 = t162 * t42
  t552 = t41 * t36
  t559 = t47 * t42
  t566 = -0.2048e-5 * t124 * t305 + 0.13653333333333333333333333333333333333333333333334e-5 * t102 * t123 * t305 + 0.256e-6 * (0.5e1 / 0.3e1 * t116 * tau0 * t235 + 0.5e1 / 0.3e1 * t117 * t45 * t239 + 0.10e2 / 0.3e1 * t470 * t45 * t239 + 0.10e2 / 0.3e1 * t120 * t51 * t239) * t123 * t129 + 0.42666666666666666666666666666666666666666666666666e-5 * t180 * t30 / t32 / t274 * t111 * t198 * t149 + 0.20e2 / 0.3e1 * t489 * t57 * t239 + 0.20e2 / 0.3e1 * t55 * t63 * t239 + 0.25e2 / 0.3e1 * t496 * t63 * t239 + 0.25e2 / 0.3e1 * t61 * t501 * t239 - 0.10666666666666666666666666666666666666666666666667e-1 * t167 * t505 * t153 - 0.17066666666666666666666666666666666666666666666667e-3 * t181 * t509 - 0.10666666666666666666666666666666666666666666666667e-1 * t209 * t505 * t198 + 0.4e-2 * (0.5e1 / 0.3e1 * t156 * tau0 * t235 + 0.5e1 / 0.3e1 * t157 * t45 * t239 + 0.10e2 / 0.3e1 * t521 * t45 * t239 + 0.10e2 / 0.3e1 * t160 * t51 * t239 + 0.5e1 * t528 * t51 * t239 + 0.5e1 * t163 * t57 * t239) * s0 * t30 * t169 + 0.85333333333333333333333333333333333333333333333336e-4 * t165 * t103 * t29 * t509 + 0.10666666666666666666666666666666666666666666666666e-2 * t166 * t281 * t88 * t198 * t149 + 0.5e1 / 0.3e1 * t37 * t45 * t239 + 0.10e2 / 0.3e1 * t552 * t45 * t239 + 0.10e2 / 0.3e1 * t43 * t51 * t239 + 0.5e1 * t559 * t51 * t239 + 0.5e1 * t49 * t57 * t239
  t572 = f.my_piecewise3(t2, 0, -t6 * t17 / t32 * t224 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t458 + t566))
  vrho_0_ = 0.2e1 * r0 * t572 + 0.2e1 * t228
  t615 = 0.4e-2 * t78 * t30 * t168 - 0.32e-4 * t79 * t112 + 0.64e-4 * t102 * s0 * t112 - 0.512e-6 * t104 * t129 + 0.768e-6 * t122 * t103 * t129 - 0.3072e-8 * t124 / t32 / t125 / t80 * t384 * t30 + 0.4e-2 * t165 * t30 * t169 - 0.32e-4 * t166 * t29 * t183 + 0.64e-4 * t179 * s0 * t29 * t183 - 0.512e-6 * t180 * t129 * t153 + 0.4e-2 * t207 * t30 * t210 - 0.32e-4 * t208 * t29 * t182 * t198
  t619 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t615)
  vsigma_0_ = 0.2e1 * r0 * t619
  vlapl_0_ = 0.0e0
  t622 = t34 * t39
  t625 = t45 * t30 * t34
  t630 = t51 * t30 * t34
  t636 = t57 * t30 * t34
  t642 = t63 * t30 * t34
  t775 = -t21 * t30 * t622 - t37 * t625 - 0.2e1 * t552 * t625 - 0.2e1 * t43 * t630 - 0.3e1 * t559 * t630 - 0.3e1 * t49 * t636 - 0.4e1 * t489 * t636 - 0.4e1 * t55 * t642 - 0.5e1 * t496 * t642 - 0.5e1 * t61 * t501 * t30 * t34 + 0.4e-2 * (-t66 * t30 * t622 - 0.2e1 * t315 * t625 - 0.3e1 * t322 * t630 - 0.4e1 * t329 * t636 - t67 * t625 - 0.2e1 * t70 * t630 - 0.3e1 * t73 * t636 - 0.4e1 * t76 * t642) * s0 * t89 + 0.32e-4 * (-t93 * t30 * t622 - 0.3e1 * t100 * t636 - 0.2e1 * t351 * t625 - 0.3e1 * t358 * t630 - t94 * t625 - 0.2e1 * t97 * t630) * t103 * t112 + 0.256e-6 * (-t116 * t30 * t622 - t117 * t625 - 0.2e1 * t120 * t630 - 0.2e1 * t470 * t625) * t123 * t129 + (-t133 * t30 * t622 - t134 * t625 - 0.2e1 * t137 * t630 - 0.3e1 * t140 * t636 - 0.4e1 * t143 * t642 - 0.2e1 * t398 * t625 - 0.3e1 * t405 * t630 - 0.4e1 * t412 * t636) * t153 + 0.4e-2 * (-t156 * t30 * t622 - t157 * t625 - 0.2e1 * t160 * t630 - 0.3e1 * t163 * t636 - 0.2e1 * t521 * t625 - 0.3e1 * t528 * t630) * s0 * t30 * t169 + 0.32e-4 * (-t173 * t30 * t622 - t174 * t625 - 0.2e1 * t177 * t630 - 0.2e1 * t242 * t625) * t103 * t29 * t183 + (-t187 * t30 * t622 - t188 * t625 - 0.2e1 * t191 * t630 - 0.3e1 * t194 * t636 - 0.2e1 * t427 * t625 - 0.3e1 * t434 * t630) * t198 + 0.4e-2 * (-t201 * t30 * t622 - t202 * t625 - 0.2e1 * t205 * t630 - 0.2e1 * t260 * t625) * s0 * t30 * t210 + (-t214 * t30 * t622 - t215 * t625 - 0.2e1 * t218 * t630 - 0.2e1 * t449 * t625) * t222
  t779 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t775)
  vtau_0_ = 0.2e1 * r0 * t779
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t24 = params.c[1]
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = jnp.pi ** 2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.3e1 / 0.10e2 * t26 * t29
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = tau0 * t33
  t35 = t34 * t21
  t36 = t31 - t35
  t37 = t24 * t36
  t38 = t31 + t35
  t39 = 0.1e1 / t38
  t41 = params.c[2]
  t42 = t36 ** 2
  t43 = t41 * t42
  t44 = t38 ** 2
  t45 = 0.1e1 / t44
  t47 = params.c[3]
  t48 = t42 * t36
  t49 = t47 * t48
  t50 = t44 * t38
  t51 = 0.1e1 / t50
  t53 = params.c[4]
  t54 = t42 ** 2
  t55 = t53 * t54
  t56 = t44 ** 2
  t57 = 0.1e1 / t56
  t59 = params.c[5]
  t61 = t59 * t54 * t36
  t63 = 0.1e1 / t56 / t38
  t66 = params.c[7]
  t67 = t66 * t36
  t69 = params.c[8]
  t70 = t69 * t42
  t72 = params.c[9]
  t73 = t72 * t48
  t75 = params.c[10]
  t76 = t75 * t54
  t78 = t67 * t39 + t70 * t45 + t73 * t51 + t76 * t57 + params.c[6]
  t79 = t78 * s0
  t80 = r0 ** 2
  t82 = 0.1e1 / t19 / t80
  t83 = t33 * t82
  t87 = 0.1e1 + 0.4e-2 * s0 * t33 * t82
  t88 = 0.1e1 / t87
  t89 = t83 * t88
  t93 = params.c[12]
  t94 = t93 * t36
  t96 = params.c[13]
  t97 = t96 * t42
  t99 = params.c[14]
  t100 = t99 * t48
  t102 = t100 * t51 + t94 * t39 + t97 * t45 + params.c[11]
  t103 = s0 ** 2
  t104 = t102 * t103
  t105 = t80 ** 2
  t106 = t105 * r0
  t108 = 0.1e1 / t18 / t106
  t109 = t32 * t108
  t110 = t87 ** 2
  t111 = 0.1e1 / t110
  t112 = t109 * t111
  t116 = params.c[16]
  t117 = t116 * t36
  t119 = params.c[17]
  t120 = t119 * t42
  t122 = t117 * t39 + t120 * t45 + params.c[15]
  t123 = t103 * s0
  t124 = t122 * t123
  t125 = t105 ** 2
  t126 = 0.1e1 / t125
  t128 = 0.1e1 / t110 / t87
  t129 = t126 * t128
  t133 = params.c[19]
  t134 = t133 * t36
  t136 = params.c[20]
  t137 = t136 * t42
  t139 = params.c[21]
  t140 = t139 * t48
  t142 = params.c[22]
  t143 = t142 * t54
  t145 = t134 * t39 + t137 * t45 + t140 * t51 + t143 * t57 + params.c[18]
  t148 = 0.1e1 / t11
  t149 = t148 ** (0.1e1 / 0.3e1)
  t152 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 / t18 * t32 * t149
  t153 = 0.1e1 / t152
  t156 = params.c[24]
  t157 = t156 * t36
  t159 = params.c[25]
  t160 = t159 * t42
  t162 = params.c[26]
  t163 = t162 * t48
  t165 = t157 * t39 + t160 * t45 + t163 * t51 + params.c[23]
  t166 = t165 * s0
  t167 = t166 * t33
  t168 = t82 * t88
  t169 = t168 * t153
  t173 = params.c[28]
  t174 = t173 * t36
  t176 = params.c[29]
  t177 = t176 * t42
  t179 = t174 * t39 + t177 * t45 + params.c[27]
  t180 = t179 * t103
  t181 = t180 * t32
  t183 = t108 * t111 * t153
  t187 = params.c[31]
  t188 = t187 * t36
  t190 = params.c[32]
  t191 = t190 * t42
  t193 = params.c[33]
  t194 = t193 * t48
  t196 = t188 * t39 + t191 * t45 + t194 * t51 + params.c[30]
  t197 = t152 ** 2
  t198 = 0.1e1 / t197
  t201 = params.c[35]
  t202 = t201 * t36
  t204 = params.c[36]
  t205 = t204 * t42
  t207 = t202 * t39 + t205 * t45 + params.c[34]
  t208 = t207 * s0
  t209 = t208 * t33
  t210 = t168 * t198
  t214 = params.c[38]
  t215 = t214 * t36
  t217 = params.c[39]
  t218 = t217 * t42
  t220 = t215 * t39 + t218 * t45 + params.c[37]
  t222 = 0.1e1 / t197 / t152
  t224 = params.c[0] + t37 * t39 + t43 * t45 + t49 * t51 + t55 * t57 + t61 * t63 + 0.4e-2 * t79 * t89 + 0.32e-4 * t104 * t112 + 0.256e-6 * t124 * t129 + t145 * t153 + 0.4e-2 * t167 * t169 + 0.32e-4 * t181 * t183 + t196 * t198 + 0.4e-2 * t209 * t210 + t220 * t222
  t229 = t17 / t19
  t230 = t145 * t198
  t234 = 0.1e1 / t18 / r0 * t32 * t149
  t237 = t179 * t123
  t238 = t125 * r0
  t239 = 0.1e1 / t238
  t240 = t239 * t128
  t241 = t240 * t153
  t244 = t196 * t222
  t247 = t197 ** 2
  t248 = 0.1e1 / t247
  t249 = t220 * t248
  t252 = t66 * tau0
  t253 = t83 * t39
  t256 = t67 * t45
  t257 = t34 * t82
  t260 = t69 * t36
  t261 = t260 * t45
  t264 = t70 * t51
  t267 = t72 * t42
  t268 = t267 * t51
  t271 = t73 * t57
  t274 = t75 * t48
  t275 = t274 * t57
  t278 = t76 * t63
  t281 = 0.5e1 / 0.3e1 * t252 * t253 + 0.5e1 / 0.3e1 * t256 * t257 + 0.10e2 / 0.3e1 * t261 * t257 + 0.10e2 / 0.3e1 * t264 * t257 + 0.5e1 * t268 * t257 + 0.5e1 * t271 * t257 + 0.20e2 / 0.3e1 * t275 * t257 + 0.20e2 / 0.3e1 * t278 * t257
  t282 = t281 * s0
  t285 = t78 * t103
  t286 = t105 * t80
  t288 = 0.1e1 / t18 / t286
  t289 = t32 * t288
  t290 = t289 * t111
  t293 = t93 * tau0
  t296 = t94 * t45
  t299 = t96 * t36
  t300 = t299 * t45
  t303 = t97 * t51
  t306 = t99 * t42
  t307 = t306 * t51
  t310 = t100 * t57
  t313 = 0.5e1 / 0.3e1 * t293 * t253 + 0.5e1 / 0.3e1 * t296 * t257 + 0.10e2 / 0.3e1 * t300 * t257 + 0.10e2 / 0.3e1 * t303 * t257 + 0.5e1 * t307 * t257 + 0.5e1 * t310 * t257
  t314 = t313 * t103
  t317 = t103 ** 2
  t318 = t122 * t317
  t319 = t80 * r0
  t320 = t125 * t319
  t322 = 0.1e1 / t19 / t320
  t323 = t110 ** 2
  t324 = 0.1e1 / t323
  t326 = t322 * t324 * t33
  t329 = t24 * tau0
  t333 = 0.1e1 / t19 / t319
  t334 = t33 * t333
  t335 = t334 * t88
  t340 = t173 * tau0
  t343 = t174 * t45
  t346 = t176 * t36
  t347 = t346 * t45
  t350 = t177 * t51
  t353 = 0.5e1 / 0.3e1 * t340 * t253 + 0.5e1 / 0.3e1 * t343 * t257 + 0.10e2 / 0.3e1 * t347 * t257 + 0.10e2 / 0.3e1 * t350 * t257
  t354 = t353 * t103
  t355 = t354 * t32
  t358 = t201 * tau0
  t361 = t202 * t45
  t364 = t204 * t36
  t365 = t364 * t45
  t368 = t205 * t51
  t371 = 0.5e1 / 0.3e1 * t358 * t253 + 0.5e1 / 0.3e1 * t361 * t257 + 0.10e2 / 0.3e1 * t365 * t257 + 0.10e2 / 0.3e1 * t368 * t257
  t372 = t371 * s0
  t373 = t372 * t33
  t376 = t288 * t111
  t377 = t376 * t153
  t380 = t333 * t88
  t381 = t380 * t198
  t384 = t380 * t153
  t387 = t37 * t45
  t390 = t41 * t36
  t391 = t390 * t45
  t394 = 0.13333333333333333333333333333333333333333333333333e0 * t230 * t234 + 0.13653333333333333333333333333333333333333333333334e-5 * t237 * t241 + 0.26666666666666666666666666666666666666666666666666e0 * t244 * t234 + 0.39999999999999999999999999999999999999999999999999e0 * t249 * t234 + 0.4e-2 * t282 * t89 + 0.85333333333333333333333333333333333333333333333336e-4 * t285 * t290 + 0.32e-4 * t314 * t112 + 0.81920000000000000000000000000000000000000000000003e-8 * t318 * t326 + 0.5e1 / 0.3e1 * t329 * t253 - 0.10666666666666666666666666666666666666666666666667e-1 * t79 * t335 - 0.17066666666666666666666666666666666666666666666667e-3 * t104 * t290 + 0.32e-4 * t355 * t183 + 0.4e-2 * t373 * t210 - 0.17066666666666666666666666666666666666666666666667e-3 * t181 * t377 - 0.10666666666666666666666666666666666666666666666667e-1 * t209 * t381 - 0.10666666666666666666666666666666666666666666666667e-1 * t167 * t384 + 0.5e1 / 0.3e1 * t387 * t257 + 0.10e2 / 0.3e1 * t391 * t257
  t395 = t43 * t51
  t398 = t47 * t42
  t399 = t398 * t51
  t402 = t49 * t57
  t405 = t53 * t48
  t406 = t405 * t57
  t409 = t55 * t63
  t412 = t59 * t54
  t413 = t412 * t63
  t417 = 0.1e1 / t56 / t44
  t418 = t61 * t417
  t421 = t156 * tau0
  t424 = t157 * t45
  t427 = t159 * t36
  t428 = t427 * t45
  t431 = t160 * t51
  t434 = t162 * t42
  t435 = t434 * t51
  t438 = t163 * t57
  t441 = 0.5e1 / 0.3e1 * t421 * t253 + 0.5e1 / 0.3e1 * t424 * t257 + 0.10e2 / 0.3e1 * t428 * t257 + 0.10e2 / 0.3e1 * t431 * t257 + 0.5e1 * t435 * t257 + 0.5e1 * t438 * t257
  t442 = t441 * s0
  t443 = t442 * t33
  t446 = t165 * t103
  t447 = t446 * t32
  t450 = 0.1e1 / t105
  t453 = t88 * t198 * t149
  t456 = t207 * t103
  t457 = t456 * t32
  t458 = t376 * t198
  t462 = t88 * t222
  t463 = t462 * t149
  t466 = t214 * tau0
  t469 = t215 * t45
  t472 = t217 * t36
  t473 = t472 * t45
  t476 = t218 * t51
  t479 = 0.5e1 / 0.3e1 * t466 * t253 + 0.5e1 / 0.3e1 * t469 * t257 + 0.10e2 / 0.3e1 * t473 * t257 + 0.10e2 / 0.3e1 * t476 * t257
  t481 = t133 * tau0
  t484 = t134 * t45
  t487 = t136 * t36
  t488 = t487 * t45
  t491 = t137 * t51
  t494 = t139 * t42
  t495 = t494 * t51
  t498 = t140 * t57
  t501 = t142 * t48
  t502 = t501 * t57
  t505 = t143 * t63
  t508 = 0.5e1 / 0.3e1 * t481 * t253 + 0.5e1 / 0.3e1 * t484 * t257 + 0.10e2 / 0.3e1 * t488 * t257 + 0.10e2 / 0.3e1 * t491 * t257 + 0.5e1 * t495 * t257 + 0.5e1 * t498 * t257 + 0.20e2 / 0.3e1 * t502 * t257 + 0.20e2 / 0.3e1 * t505 * t257
  t510 = t187 * tau0
  t513 = t188 * t45
  t516 = t190 * t36
  t517 = t516 * t45
  t520 = t191 * t51
  t523 = t193 * t42
  t524 = t523 * t51
  t527 = t194 * t57
  t530 = 0.5e1 / 0.3e1 * t510 * t253 + 0.5e1 / 0.3e1 * t513 * t257 + 0.10e2 / 0.3e1 * t517 * t257 + 0.10e2 / 0.3e1 * t520 * t257 + 0.5e1 * t524 * t257 + 0.5e1 * t527 * t257
  t532 = t116 * tau0
  t535 = t117 * t45
  t538 = t119 * t36
  t539 = t538 * t45
  t542 = t120 * t51
  t545 = 0.5e1 / 0.3e1 * t532 * t253 + 0.5e1 / 0.3e1 * t535 * t257 + 0.10e2 / 0.3e1 * t539 * t257 + 0.10e2 / 0.3e1 * t542 * t257
  t546 = t545 * t123
  t549 = t180 * t33
  t551 = 0.1e1 / t19 / t286
  t553 = t198 * t149
  t554 = t551 * t111 * t553
  t559 = t102 * t123
  t562 = 0.10e2 / 0.3e1 * t395 * t257 + 0.5e1 * t399 * t257 + 0.5e1 * t402 * t257 + 0.20e2 / 0.3e1 * t406 * t257 + 0.20e2 / 0.3e1 * t409 * t257 + 0.25e2 / 0.3e1 * t413 * t257 + 0.25e2 / 0.3e1 * t418 * t257 + 0.4e-2 * t443 * t169 + 0.85333333333333333333333333333333333333333333333336e-4 * t447 * t377 + 0.10666666666666666666666666666666666666666666666666e-2 * t166 * t450 * t453 + 0.85333333333333333333333333333333333333333333333336e-4 * t457 * t458 + 0.21333333333333333333333333333333333333333333333333e-2 * t208 * t450 * t463 + t479 * t222 + t508 * t153 + t530 * t198 + 0.256e-6 * t546 * t129 + 0.42666666666666666666666666666666666666666666666666e-5 * t549 * t554 - 0.2048e-5 * t124 * t240 + 0.13653333333333333333333333333333333333333333333334e-5 * t559 * t240
  t563 = t394 + t562
  t567 = t17 * t18
  t568 = t145 * t222
  t569 = t149 ** 2
  t570 = t83 * t569
  t573 = t353 * t123
  t576 = t196 * t248
  t580 = 0.1e1 / t247 / t152
  t581 = t220 * t580
  t584 = t334 * t39
  t587 = tau0 ** 2
  t588 = t66 * t587
  t589 = t109 * t45
  t592 = t67 * t51
  t593 = t587 * t32
  t594 = t593 * t108
  t597 = t34 * t333
  t600 = t69 * t587
  t603 = t260 * t51
  t608 = t70 * t57
  t613 = t72 * t36
  t614 = t613 * t51
  t617 = t267 * t57
  t622 = t73 * t63
  t627 = t75 * t42
  t628 = t627 * t57
  t631 = t274 * t63
  t636 = t76 * t417
  t641 = -0.40e2 / 0.9e1 * t252 * t584 + 0.100e3 / 0.9e1 * t588 * t589 + 0.100e3 / 0.9e1 * t592 * t594 - 0.40e2 / 0.9e1 * t256 * t597 + 0.100e3 / 0.9e1 * t600 * t589 + 0.400e3 / 0.9e1 * t603 * t594 - 0.80e2 / 0.9e1 * t261 * t597 + 0.100e3 / 0.3e1 * t608 * t594 - 0.80e2 / 0.9e1 * t264 * t597 + 0.100e3 / 0.3e1 * t614 * t594 + 0.100e3 * t617 * t594 - 0.40e2 / 0.3e1 * t268 * t597 + 0.200e3 / 0.3e1 * t622 * t594 - 0.40e2 / 0.3e1 * t271 * t597 + 0.200e3 / 0.3e1 * t628 * t594 + 0.1600e4 / 0.9e1 * t631 * t594 - 0.160e3 / 0.9e1 * t275 * t597 + 0.1000e4 / 0.9e1 * t636 * t594 - 0.160e3 / 0.9e1 * t278 * t597
  t642 = t641 * s0
  t645 = t281 * t103
  t648 = t479 * t248
  t651 = t530 * t222
  t654 = t508 * t198
  t660 = 0.1e1 / t18 / t80 * t32 * t149
  t664 = t125 * t80
  t666 = 0.1e1 / t664 * t128
  t667 = t666 * t153
  t676 = 0.1e1 / t19 / t125 / t105
  t678 = t676 * t324 * t33
  t684 = 0.1e1 / t19 / t105
  t685 = t33 * t684
  t686 = t685 * t88
  t689 = t105 * t319
  t691 = 0.1e1 / t18 / t689
  t693 = t32 * t691 * t111
  t702 = t165 * t123
  t705 = -0.19569777777777777777777777777777777777777777777779e-4 * t237 * t667 - 0.35555555555555555555555555555555555555555555555555e0 * t244 * t660 - 0.53333333333333333333333333333333333333333333333332e0 * t249 * t660 - 0.16110933333333333333333333333333333333333333333334e-6 * t318 * t678 - 0.40e2 / 0.9e1 * t329 * t584 + 0.39111111111111111111111111111111111111111111111112e-1 * t79 * t686 + 0.10808888888888888888888888888888888888888888888889e-2 * t104 * t693 - 0.76800000000000000000000000000000000000000000000003e-3 * t285 * t693 - 0.34133333333333333333333333333333333333333333333334e-3 * t314 * t290 - 0.21333333333333333333333333333333333333333333333334e-1 * t282 * t335 + 0.36408888888888888888888888888888888888888888888891e-5 * t702 * t667
  t707 = t207 * t123
  t708 = t666 * t198
  t711 = t102 * t317
  t714 = t41 * t587
  t719 = t93 * t587
  t722 = t94 * t51
  t727 = t96 * t587
  t730 = t299 * t51
  t735 = t97 * t57
  t740 = t99 * t36
  t741 = t740 * t51
  t744 = t306 * t57
  t749 = t100 * t63
  t754 = -0.40e2 / 0.9e1 * t293 * t584 + 0.100e3 / 0.9e1 * t719 * t589 + 0.100e3 / 0.9e1 * t722 * t594 - 0.40e2 / 0.9e1 * t296 * t597 + 0.100e3 / 0.9e1 * t727 * t589 + 0.400e3 / 0.9e1 * t730 * t594 - 0.80e2 / 0.9e1 * t300 * t597 + 0.100e3 / 0.3e1 * t735 * t594 - 0.80e2 / 0.9e1 * t303 * t597 + 0.100e3 / 0.3e1 * t741 * t594 + 0.100e3 * t744 * t594 - 0.40e2 / 0.3e1 * t307 * t597 + 0.200e3 / 0.3e1 * t749 * t594 - 0.40e2 / 0.3e1 * t310 * t597
  t755 = t754 * t103
  t758 = t545 * t317
  t761 = t317 * s0
  t762 = t122 * t761
  t767 = 0.1e1 / t323 / t87
  t769 = 0.1e1 / t18 / t125 / t689 * t767 * t32
  t772 = t24 * t587
  t777 = t156 * t587
  t780 = t157 * t51
  t785 = t159 * t587
  t788 = t427 * t51
  t793 = t160 * t57
  t798 = t162 * t36
  t799 = t798 * t51
  t802 = t434 * t57
  t807 = t163 * t63
  t812 = -0.40e2 / 0.9e1 * t421 * t584 + 0.100e3 / 0.9e1 * t777 * t589 + 0.100e3 / 0.9e1 * t780 * t594 - 0.40e2 / 0.9e1 * t424 * t597 + 0.100e3 / 0.9e1 * t785 * t589 + 0.400e3 / 0.9e1 * t788 * t594 - 0.80e2 / 0.9e1 * t428 * t597 + 0.100e3 / 0.3e1 * t793 * t594 - 0.80e2 / 0.9e1 * t431 * t597 + 0.100e3 / 0.3e1 * t799 * t594 + 0.100e3 * t802 * t594 - 0.40e2 / 0.3e1 * t435 * t597 + 0.200e3 / 0.3e1 * t807 * t594 - 0.40e2 / 0.3e1 * t438 * t597
  t813 = t812 * s0
  t814 = t813 * t33
  t819 = t111 * t222 * t569
  t822 = t179 * t317
  t825 = t324 * t153 * t33
  t831 = t201 * t587
  t834 = t202 * t51
  t839 = t204 * t587
  t842 = t364 * t51
  t847 = t205 * t57
  t852 = -0.40e2 / 0.9e1 * t358 * t584 + 0.100e3 / 0.9e1 * t831 * t589 + 0.100e3 / 0.9e1 * t834 * t594 - 0.40e2 / 0.9e1 * t361 * t597 + 0.100e3 / 0.9e1 * t839 * t589 + 0.400e3 / 0.9e1 * t842 * t594 - 0.80e2 / 0.9e1 * t365 * t597 + 0.100e3 / 0.3e1 * t847 * t594 - 0.80e2 / 0.9e1 * t368 * t597
  t853 = t852 * s0
  t854 = t853 * t33
  t857 = t371 * t103
  t858 = t857 * t32
  t864 = t684 * t88
  t865 = t864 * t153
  t880 = t691 * t111
  t881 = t880 * t153
  t884 = 0.4e-2 * t854 * t210 + 0.17066666666666666666666666666666666666666666666667e-3 * t858 * t458 + 0.42666666666666666666666666666666666666666666666666e-2 * t372 * t450 * t463 + 0.39111111111111111111111111111111111111111111111112e-1 * t167 * t865 - 0.40e2 / 0.9e1 * t387 * t597 - 0.80e2 / 0.9e1 * t391 * t597 - 0.80e2 / 0.9e1 * t395 * t597 - 0.40e2 / 0.3e1 * t399 * t597 - 0.40e2 / 0.3e1 * t402 * t597 - 0.160e3 / 0.9e1 * t406 * t597 + 0.10808888888888888888888888888888888888888888888889e-2 * t181 * t881
  t887 = t864 * t198
  t890 = t55 * t417
  t893 = t59 * t48
  t894 = t893 * t63
  t897 = t412 * t417
  t901 = 0.1e1 / t56 / t50
  t902 = t61 * t901
  t916 = 0.1e1 / t106
  t920 = t37 * t51
  t923 = t390 * t51
  t926 = t43 * t57
  t929 = t47 * t36
  t930 = t929 * t51
  t933 = t398 * t57
  t936 = t49 * t63
  t943 = t880 * t198
  t949 = -0.71111111111111111111111111111111111111111111111109e-2 * t166 * t916 * t453 + 0.100e3 / 0.9e1 * t920 * t594 + 0.400e3 / 0.9e1 * t923 * t594 + 0.100e3 / 0.3e1 * t926 * t594 + 0.100e3 / 0.3e1 * t930 * t594 + 0.100e3 * t933 * t594 + 0.200e3 / 0.3e1 * t936 * t594 - 0.34133333333333333333333333333333333333333333333334e-3 * t355 * t377 - 0.21333333333333333333333333333333333333333333333334e-1 * t373 * t381 - 0.76800000000000000000000000000000000000000000000003e-3 * t457 * t943 - 0.14222222222222222222222222222222222222222222222222e-1 * t208 * t916 * t463
  t951 = t441 * t103
  t952 = t951 * t32
  t960 = t173 * t587
  t963 = t174 * t51
  t968 = t176 * t587
  t971 = t346 * t51
  t976 = t177 * t57
  t981 = -0.40e2 / 0.9e1 * t340 * t584 + 0.100e3 / 0.9e1 * t960 * t589 + 0.100e3 / 0.9e1 * t963 * t594 - 0.40e2 / 0.9e1 * t343 * t597 + 0.100e3 / 0.9e1 * t968 * t589 + 0.400e3 / 0.9e1 * t971 * t594 - 0.80e2 / 0.9e1 * t347 * t597 + 0.100e3 / 0.3e1 * t976 * t594 - 0.80e2 / 0.9e1 * t350 * t597
  t982 = t981 * t103
  t983 = t982 * t32
  t986 = t53 * t42
  t987 = t986 * t57
  t990 = t405 * t63
  t999 = t116 * t587
  t1002 = t117 * t51
  t1007 = t119 * t587
  t1010 = t538 * t51
  t1015 = t120 * t57
  t1020 = -0.40e2 / 0.9e1 * t532 * t584 + 0.100e3 / 0.9e1 * t999 * t589 + 0.100e3 / 0.9e1 * t1002 * t594 - 0.40e2 / 0.9e1 * t535 * t597 + 0.100e3 / 0.9e1 * t1007 * t589 + 0.400e3 / 0.9e1 * t1010 * t594 - 0.80e2 / 0.9e1 * t539 * t597 + 0.100e3 / 0.3e1 * t1015 * t594 - 0.80e2 / 0.9e1 * t542 * t597
  t1021 = t1020 * t123
  t1026 = t78 * t123
  t1030 = t313 * t123
  t1035 = t214 * t587
  t1038 = t215 * t51
  t1043 = t217 * t587
  t1046 = t472 * t51
  t1051 = t218 * t57
  t1056 = -0.40e2 / 0.9e1 * t466 * t584 + 0.100e3 / 0.9e1 * t1035 * t589 + 0.100e3 / 0.9e1 * t1038 * t594 - 0.40e2 / 0.9e1 * t469 * t597 + 0.100e3 / 0.9e1 * t1043 * t589 + 0.400e3 / 0.9e1 * t1046 * t594 - 0.80e2 / 0.9e1 * t473 * t597 + 0.100e3 / 0.3e1 * t1051 * t594 - 0.80e2 / 0.9e1 * t476 * t597
  t1060 = t133 * t587
  t1063 = t134 * t51
  t1068 = t136 * t587
  t1071 = t487 * t51
  t1076 = t137 * t57
  t1081 = t139 * t36
  t1082 = t1081 * t51
  t1085 = t494 * t57
  t1090 = t140 * t63
  t1095 = t142 * t42
  t1096 = t1095 * t57
  t1099 = t501 * t63
  t1104 = t143 * t417
  t1109 = -0.40e2 / 0.9e1 * t481 * t584 + 0.100e3 / 0.9e1 * t1060 * t589 + 0.100e3 / 0.9e1 * t1063 * t594 - 0.40e2 / 0.9e1 * t484 * t597 + 0.100e3 / 0.9e1 * t1068 * t589 + 0.400e3 / 0.9e1 * t1071 * t594 - 0.80e2 / 0.9e1 * t488 * t597 + 0.100e3 / 0.3e1 * t1076 * t594 - 0.80e2 / 0.9e1 * t491 * t597 + 0.100e3 / 0.3e1 * t1082 * t594 + 0.100e3 * t1085 * t594 - 0.40e2 / 0.3e1 * t495 * t597 + 0.200e3 / 0.3e1 * t1090 * t594 - 0.40e2 / 0.3e1 * t498 * t597 + 0.200e3 / 0.3e1 * t1096 * t594 + 0.1600e4 / 0.9e1 * t1099 * t594 - 0.160e3 / 0.9e1 * t502 * t597 + 0.1000e4 / 0.9e1 * t1104 * t594 - 0.160e3 / 0.9e1 * t505 * t597
  t1113 = t187 * t587
  t1116 = t188 * t51
  t1121 = t190 * t587
  t1124 = t516 * t51
  t1129 = t191 * t57
  t1134 = t193 * t36
  t1135 = t1134 * t51
  t1138 = t523 * t57
  t1143 = t194 * t63
  t1148 = -0.40e2 / 0.9e1 * t510 * t584 + 0.100e3 / 0.9e1 * t1113 * t589 + 0.100e3 / 0.9e1 * t1116 * t594 - 0.40e2 / 0.9e1 * t513 * t597 + 0.100e3 / 0.9e1 * t1121 * t589 + 0.400e3 / 0.9e1 * t1124 * t594 - 0.80e2 / 0.9e1 * t517 * t597 + 0.100e3 / 0.3e1 * t1129 * t594 - 0.80e2 / 0.9e1 * t520 * t597 + 0.100e3 / 0.3e1 * t1135 * t594 + 0.100e3 * t1138 * t594 - 0.40e2 / 0.3e1 * t524 * t597 + 0.200e3 / 0.3e1 * t1143 * t594 - 0.40e2 / 0.3e1 * t527 * t597
  t1150 = t456 * t33
  t1152 = 0.1e1 / t19 / t689
  t1153 = t1152 * t111
  t1154 = t222 * t149
  t1155 = t1153 * t1154
  t1159 = t88 * t248
  t1160 = t569 * t32
  t1161 = t1159 * t1160
  t1164 = t446 * t33
  t1165 = t1153 * t553
  t1169 = t462 * t1160
  t1172 = t354 * t33
  t1177 = 0.1e1 / t18 / t664
  t1184 = 0.27306666666666666666666666666666666666666666666668e-5 * t1030 * t240 + t1056 * t222 + t1109 * t153 + t1148 * t198 + 0.45511111111111111111111111111111111111111111111112e-4 * t1150 * t1155 + 0.85333333333333333333333333333333333333333333333330e-3 * t208 * t108 * t1161 + 0.22755555555555555555555555555555555555555555555555e-4 * t1164 * t1165 + 0.28444444444444444444444444444444444444444444444442e-3 * t166 * t108 * t1169 + 0.85333333333333333333333333333333333333333333333332e-5 * t1172 * t554 + 0.36408888888888888888888888888888888888888888888890e-6 * t237 * t32 * t1177 * t128 * t553 - 0.51199999999999999999999999999999999999999999999999e-4 * t549 * t1165
  t1187 = t1184 + t949 + t884 + t705 - 0.4096e-5 * t546 * t240 + 0.256e-6 * t1021 * t129 + 0.18432e-4 * t124 * t666 + 0.36408888888888888888888888888888888888888888888891e-5 * t1026 * t666 + 0.32e-4 * t983 * t183 + 0.200e3 / 0.3e1 * t987 * t594 + 0.1600e4 / 0.9e1 * t990 * t594 - 0.19569777777777777777777777777777777777777777777779e-4 * t559 * t666 + 0.17066666666666666666666666666666666666666666666667e-3 * t952 * t377 + 0.39111111111111111111111111111111111111111111111112e-1 * t209 * t887 + 0.1000e4 / 0.9e1 * t890 * t594 + 0.1000e4 / 0.9e1 * t894 * t594 + 0.2500e4 / 0.9e1 * t897 * t594 + 0.500e3 / 0.3e1 * t902 * t594 - 0.160e3 / 0.9e1 * t409 * t597 - 0.200e3 / 0.9e1 * t413 * t597 - 0.200e3 / 0.9e1 * t418 * t597 - 0.21333333333333333333333333333333333333333333333334e-1 * t443 * t384 - 0.76800000000000000000000000000000000000000000000003e-3 * t447 * t881 + 0.4e-2 * t814 * t169 + 0.32e-4 * t755 * t112 + 0.16384000000000000000000000000000000000000000000001e-7 * t758 * t326 + 0.69905066666666666666666666666666666666666666666671e-9 * t762 * t769 + 0.100e3 / 0.9e1 * t772 * t589 + 0.43690666666666666666666666666666666666666666666670e-7 * t711 * t678 + 0.100e3 / 0.9e1 * t714 * t589 + 0.36408888888888888888888888888888888888888888888891e-5 * t707 * t708 + 0.4e-2 * t642 * t89 + 0.17066666666666666666666666666666666666666666666667e-3 * t645 * t290 + 0.79999999999999999999999999999999999999999999999998e0 * t648 * t234 + 0.53333333333333333333333333333333333333333333333332e0 * t651 * t234 + 0.26666666666666666666666666666666666666666666666666e0 * t654 * t234 - 0.17777777777777777777777777777777777777777777777777e0 * t230 * t660 + 0.21333333333333333333333333333333333333333333333332e0 * t581 * t570 + 0.35555555555555555555555555555555555555555555555554e-1 * t568 * t570 + 0.27306666666666666666666666666666666666666666666668e-5 * t573 * t241 + 0.10666666666666666666666666666666666666666666666666e0 * t576 * t570 + 0.22755555555555555555555555555555555555555555555555e-5 * t180 * t126 * t819 + 0.43690666666666666666666666666666666666666666666670e-7 * t822 * t676 * t825 + 0.21333333333333333333333333333333333333333333333332e-2 * t442 * t450 * t453
  t1192 = f.my_piecewise3(t2, 0, t6 * t22 * t224 / 0.12e2 - t6 * t229 * t563 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t567 * t1187)
  t1211 = t125 ** 2
  t1213 = 0.1e1 / t18 / t1211
  t1215 = t1213 * t767 * t32
  t1218 = t587 * tau0
  t1220 = t126 * t51
  t1229 = t685 * t39
  t1232 = t289 * t45
  t1235 = t593 * t288
  t1238 = t34 * t684
  t1249 = 0.1000e4 / 0.9e1 * t93 * t1218 * t1220 + 0.2000e4 / 0.9e1 * t96 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t99 * t1218 * t1220 + 0.440e3 / 0.27e2 * t293 * t1229 - 0.800e3 / 0.9e1 * t727 * t1232 - 0.800e3 / 0.3e1 * t735 * t1235 + 0.880e3 / 0.27e2 * t303 * t1238 - 0.800e3 / 0.3e1 * t741 * t1235 - 0.800e3 * t744 * t1235 + 0.440e3 / 0.9e1 * t307 * t1238 - 0.1600e4 / 0.3e1 * t749 * t1235
  t1261 = t57 * t1218 * t126
  t1265 = t63 * t1218 * t126
  t1273 = t417 * t1218 * t126
  t1280 = 0.440e3 / 0.9e1 * t310 * t1238 - 0.800e3 / 0.9e1 * t722 * t1235 + 0.440e3 / 0.27e2 * t296 * t1238 - 0.3200e4 / 0.9e1 * t730 * t1235 + 0.880e3 / 0.27e2 * t300 * t1238 + 0.2000e4 / 0.3e1 * t299 * t1261 + 0.4000e4 / 0.9e1 * t97 * t1265 + 0.1000e4 * t740 * t1261 + 0.2000e4 * t306 * t1265 + 0.10000e5 / 0.9e1 * t100 * t1273 - 0.800e3 / 0.9e1 * t719 * t1232 + 0.1000e4 / 0.9e1 * t94 * t1261
  t1307 = 0.1e1 / t320 * t128
  t1308 = t1307 * t153
  t1315 = t334 * t569
  t1324 = 0.10922666666666666666666666666666666666666666666667e-4 * t371 * t123 * t708 + 0.13107200000000000000000000000000000000000000000001e-6 * t313 * t317 * t678 + 0.37282702222222222222222222222222222222222222222226e-8 * t102 * t761 * t1215 + 0.32e-4 * (t1249 + t1280) * t103 * t112 - 0.23040000000000000000000000000000000000000000000001e-2 * t645 * t693 - 0.51200000000000000000000000000000000000000000000001e-3 * t755 * t290 - 0.32000000000000000000000000000000000000000000000001e-1 * t642 * t335 + 0.10922666666666666666666666666666666666666666666667e-4 * t441 * t123 * t667 + 0.25600000000000000000000000000000000000000000000001e-3 * t641 * t103 * t290 + 0.12000000000000000000000000000000000000000000000000e1 * t1056 * t248 * t234 + 0.31999999999999999999999999999999999999999999999998e0 * t530 * t248 * t570 + 0.63999999999999999999999999999999999999999999999997e0 * t479 * t580 * t570 + 0.24181570370370370370370370370370370370370370370372e-3 * t237 * t1308 - 0.10666666666666666666666666666666666666666666666666e1 * t651 * t660 - 0.15999999999999999999999999999999999999999999999999e1 * t648 * t660 - 0.85333333333333333333333333333333333333333333333328e0 * t581 * t1315 - 0.58709333333333333333333333333333333333333333333336e-4 * t573 * t667 - 0.42666666666666666666666666666666666666666666666665e0 * t576 * t1315 - 0.48332800000000000000000000000000000000000000000002e-6 * t758 * t678
  t1333 = 0.1e1 / t19 / t125 / t106
  t1335 = t1333 * t324 * t33
  t1372 = -0.12800e5 / 0.9e1 * t631 * t1235 + 0.1760e4 / 0.27e2 * t275 * t1238 - 0.800e3 / 0.9e1 * t592 * t1235 + 0.440e3 / 0.27e2 * t256 * t1238 - 0.3200e4 / 0.9e1 * t603 * t1235 + 0.880e3 / 0.27e2 * t261 * t1238 - 0.800e3 / 0.3e1 * t608 * t1235 + 0.880e3 / 0.27e2 * t264 * t1238 - 0.800e3 / 0.3e1 * t614 * t1235 - 0.8000e4 / 0.9e1 * t636 * t1235 + 0.1760e4 / 0.27e2 * t278 * t1238 - 0.800e3 * t617 * t1235 + 0.440e3 / 0.9e1 * t268 * t1238 - 0.1600e4 / 0.3e1 * t622 * t1235 + 0.440e3 / 0.9e1 * t271 * t1238 - 0.1600e4 / 0.3e1 * t628 * t1235
  t1387 = t901 * t1218 * t126
  t1411 = 0.1000e4 * t613 * t1261 + 0.2000e4 * t267 * t1265 + 0.10000e5 / 0.9e1 * t73 * t1273 + 0.4000e4 / 0.9e1 * t75 * t36 * t1261 + 0.8000e4 / 0.3e1 * t627 * t1265 + 0.40000e5 / 0.9e1 * t274 * t1273 + 0.20000e5 / 0.9e1 * t76 * t1387 + 0.440e3 / 0.27e2 * t252 * t1229 - 0.800e3 / 0.9e1 * t600 * t1232 - 0.800e3 / 0.9e1 * t588 * t1232 + 0.1000e4 / 0.9e1 * t67 * t1261 + 0.2000e4 / 0.3e1 * t260 * t1261 + 0.4000e4 / 0.9e1 * t70 * t1265 + 0.1000e4 / 0.9e1 * t66 * t1218 * t1220 + 0.2000e4 / 0.9e1 * t69 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t72 * t1218 * t1220
  t1438 = 0.1e1 / t18 / t125
  t1440 = t32 * t1438 * t111
  t1450 = 0.1e1 / t19 / t106
  t1457 = -0.24466773333333333333333333333333333333333333333335e-7 * t762 * t1215 - 0.800e3 / 0.9e1 * t772 * t1232 - 0.14222222222222222222222222222222222222222222222222e0 * t568 * t1315 - 0.11796480000000000000000000000000000000000000000001e-5 * t711 * t1335 - 0.800e3 / 0.9e1 * t714 * t1232 + 0.4e-2 * (t1372 + t1411) * s0 * t89 + 0.24576000000000000000000000000000000000000000000001e-7 * t1020 * t317 * t326 + 0.20971520000000000000000000000000000000000000000002e-8 * t545 * t761 * t769 + 0.10666666666666666666666666666666666666666666666666e0 * t508 * t222 * t570 + 0.40960000000000000000000000000000000000000000000002e-5 * t981 * t123 * t241 + 0.11733333333333333333333333333333333333333333333334e0 * t282 * t686 - 0.69176888888888888888888888888888888888888888888893e-4 * t702 * t1308 - 0.69176888888888888888888888888888888888888888888893e-4 * t707 * t1307 * t198 + 0.32426666666666666666666666666666666666666666666667e-2 * t314 * t693 + 0.64663703703703703703703703703703703703703703703706e-2 * t285 * t1440 + 0.79999999999999999999999999999999999999999999999998e0 * t1148 * t222 * t234 + 0.39999999999999999999999999999999999999999999999999e0 * t1109 * t198 * t234 - 0.18251851851851851851851851851851851851851851851852e0 * t79 * t33 * t1450 * t88 - 0.79265185185185185185185185185185185185185185185186e-2 * t104 * t1440
  t1490 = t56 ** 2
  t1499 = 0.1e1 / t18 / t319 * t32 * t149
  t1508 = 0.11650844444444444444444444444444444444444444444445e-6 * t78 * t317 * t1335 + 0.1000e4 / 0.9e1 * t37 * t1261 + 0.2000e4 / 0.3e1 * t390 * t1261 + 0.4000e4 / 0.9e1 * t43 * t1265 + 0.1000e4 * t929 * t1261 + 0.2000e4 * t398 * t1265 + 0.10000e5 / 0.9e1 * t49 * t1273 + 0.4000e4 / 0.9e1 * t53 * t36 * t1261 + 0.8000e4 / 0.3e1 * t986 * t1265 + 0.40000e5 / 0.9e1 * t405 * t1273 + 0.20000e5 / 0.9e1 * t55 * t1387 + 0.10000e5 / 0.9e1 * t59 * t42 * t1265 + 0.50000e5 / 0.9e1 * t893 * t1273 + 0.25000e5 / 0.3e1 * t412 * t1387 + 0.35000e5 / 0.9e1 * t61 / t1490 * t1218 * t126 + 0.82962962962962962962962962962962962962962962962962e0 * t244 * t1499 + 0.12444444444444444444444444444444444444444444444444e1 * t249 * t1499 + 0.26305422222222222222222222222222222222222222222223e-5 * t318 * t1335 + 0.440e3 / 0.27e2 * t329 * t1229
  t1543 = 0.440e3 / 0.27e2 * t358 * t1229 - 0.800e3 / 0.9e1 * t831 * t1232 + 0.1000e4 / 0.9e1 * t201 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t202 * t1261 - 0.800e3 / 0.9e1 * t834 * t1235 + 0.440e3 / 0.27e2 * t361 * t1238 - 0.800e3 / 0.9e1 * t839 * t1232 + 0.2000e4 / 0.9e1 * t204 * t1218 * t1220 + 0.2000e4 / 0.3e1 * t364 * t1261 - 0.3200e4 / 0.9e1 * t842 * t1235 + 0.880e3 / 0.27e2 * t365 * t1238 + 0.4000e4 / 0.9e1 * t205 * t1265 - 0.800e3 / 0.3e1 * t847 * t1235 + 0.880e3 / 0.27e2 * t368 * t1238
  t1560 = t1438 * t111
  t1561 = t1560 * t153
  t1564 = t1450 * t88
  t1601 = -0.800e3 / 0.9e1 * t785 * t1232 + 0.440e3 / 0.27e2 * t421 * t1229 - 0.800e3 / 0.9e1 * t777 * t1232 + 0.1000e4 / 0.9e1 * t157 * t1261 + 0.2000e4 / 0.3e1 * t427 * t1261 + 0.4000e4 / 0.9e1 * t160 * t1265 + 0.1000e4 * t798 * t1261 + 0.2000e4 * t434 * t1265 + 0.10000e5 / 0.9e1 * t163 * t1273 - 0.1600e4 / 0.3e1 * t807 * t1235 + 0.440e3 / 0.9e1 * t438 * t1238
  t1629 = -0.3200e4 / 0.9e1 * t788 * t1235 + 0.880e3 / 0.27e2 * t428 * t1238 - 0.800e3 / 0.3e1 * t793 * t1235 + 0.880e3 / 0.27e2 * t431 * t1238 - 0.800e3 / 0.3e1 * t799 * t1235 - 0.800e3 * t802 * t1235 + 0.440e3 / 0.9e1 * t435 * t1238 - 0.800e3 / 0.9e1 * t780 * t1235 + 0.440e3 / 0.27e2 * t424 * t1238 + 0.1000e4 / 0.9e1 * t156 * t1218 * t1220 + 0.2000e4 / 0.9e1 * t159 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t162 * t1218 * t1220
  t1646 = -0.53333333333333333333333333333333333333333333333332e0 * t654 * t660 + 0.41481481481481481481481481481481481481481481481480e0 * t230 * t1499 + 0.4e-2 * t1543 * s0 * t33 * t210 - 0.32000000000000000000000000000000000000000000000001e-1 * t854 * t381 + 0.25600000000000000000000000000000000000000000000001e-3 * t852 * t103 * t32 * t458 + 0.440e3 / 0.9e1 * t399 * t1238 + 0.440e3 / 0.9e1 * t402 * t1238 + 0.1760e4 / 0.27e2 * t406 * t1238 - 0.79265185185185185185185185185185185185185185185186e-2 * t181 * t1561 - 0.18251851851851851851851851851851851851851851851852e0 * t209 * t1564 * t198 - 0.45511111111111111111111111111111111111111111111109e-4 * t180 * t239 * t819 + 0.63999999999999999999999999999999999999999999999999e-2 * t853 * t450 * t463 - 0.23040000000000000000000000000000000000000000000001e-2 * t858 * t943 - 0.42666666666666666666666666666666666666666666666666e-1 * t372 * t916 * t463 + 0.4e-2 * (t1601 + t1629) * s0 * t33 * t169 + 0.25600000000000000000000000000000000000000000000001e-3 * t812 * t103 * t32 * t377 + 0.32426666666666666666666666666666666666666666666667e-2 * t355 * t881 - 0.18251851851851851851851851851851851851851851851852e0 * t167 * t1564 * t153 + 0.440e3 / 0.27e2 * t387 * t1238
  t1654 = t111 * t248
  t1669 = 0.1e1 / t286
  t1699 = 0.880e3 / 0.27e2 * t391 * t1238 + 0.880e3 / 0.27e2 * t395 * t1238 + 0.54613333333333333333333333333333333333333333333333e-4 * t456 * t239 * t1654 * t569 + 0.37282702222222222222222222222222222222222222222226e-8 * t179 * t761 * t1213 * t767 * t153 * t32 - 0.23040000000000000000000000000000000000000000000000e-2 * t952 * t881 + 0.64663703703703703703703703703703703703703703703706e-2 * t457 * t1560 * t198 + 0.91970370370370370370370370370370370370370370370369e-1 * t208 * t1669 * t463 + 0.1760e4 / 0.27e2 * t409 * t1238 + 0.2200e4 / 0.27e2 * t413 * t1238 + 0.2200e4 / 0.27e2 * t418 * t1238 + 0.11733333333333333333333333333333333333333333333334e0 * t373 * t887 - 0.1600e4 / 0.3e1 * t987 * t1235 - 0.12800e5 / 0.9e1 * t990 * t1235 - 0.8000e4 / 0.9e1 * t890 * t1235 - 0.8000e4 / 0.9e1 * t894 * t1235 - 0.20000e5 / 0.9e1 * t897 * t1235 - 0.4000e4 / 0.3e1 * t902 * t1235 - 0.51200000000000000000000000000000000000000000000001e-3 * t983 * t377 + 0.11650844444444444444444444444444444444444444444445e-6 * t165 * t317 * t1333 * t825
  t1709 = t324 * t198
  t1757 = 0.440e3 / 0.27e2 * t340 * t1229 - 0.800e3 / 0.9e1 * t960 * t1232 + 0.1000e4 / 0.9e1 * t173 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t174 * t1261 - 0.800e3 / 0.9e1 * t963 * t1235 + 0.440e3 / 0.27e2 * t343 * t1238 - 0.800e3 / 0.9e1 * t968 * t1232 + 0.2000e4 / 0.9e1 * t176 * t1218 * t1220 + 0.2000e4 / 0.3e1 * t346 * t1261 - 0.3200e4 / 0.9e1 * t971 * t1235 + 0.880e3 / 0.27e2 * t347 * t1238 + 0.4000e4 / 0.9e1 * t177 * t1265 - 0.800e3 / 0.3e1 * t976 * t1235 + 0.880e3 / 0.27e2 * t350 * t1238
  t1787 = -0.11796480000000000000000000000000000000000000000001e-5 * t822 * t1333 * t825 + 0.13107200000000000000000000000000000000000000000001e-6 * t353 * t317 * t676 * t825 + 0.11650844444444444444444444444444444444444444444445e-6 * t207 * t317 * t1333 * t1709 * t33 + 0.11733333333333333333333333333333333333333333333334e0 * t443 * t865 + 0.64663703703703703703703703703703703703703703703706e-2 * t447 * t1561 + 0.45985185185185185185185185185185185185185185185184e-1 * t166 * t1669 * t453 - 0.800e3 / 0.9e1 * t920 * t1235 - 0.32000000000000000000000000000000000000000000000001e-1 * t814 * t384 - 0.21333333333333333333333333333333333333333333333333e-1 * t442 * t916 * t453 + 0.32e-4 * t1757 * t103 * t32 * t183 + 0.34952533333333333333333333333333333333333333333335e-7 * t822 / t125 / t286 * t1709 * t149 + 0.18204444444444444444444444444444444444444444444444e-4 * t446 * t239 * t819 + 0.68266666666666666666666666666666666666666666666664e-5 * t354 * t126 * t819 + 0.31999999999999999999999999999999999999999999999998e-2 * t813 * t450 * t453 - 0.3200e4 / 0.9e1 * t923 * t1235 - 0.800e3 / 0.3e1 * t926 * t1235 - 0.800e3 / 0.3e1 * t930 * t1235 - 0.800e3 * t933 * t1235 - 0.1600e4 / 0.3e1 * t936 * t1235
  t1794 = t450 * t148
  t1859 = 0.440e3 / 0.27e2 * t532 * t1229 - 0.800e3 / 0.9e1 * t999 * t1232 + 0.1000e4 / 0.9e1 * t116 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t117 * t1261 - 0.800e3 / 0.9e1 * t1002 * t1235 + 0.440e3 / 0.27e2 * t535 * t1238 - 0.800e3 / 0.9e1 * t1007 * t1232 + 0.2000e4 / 0.9e1 * t119 * t1218 * t1220 + 0.2000e4 / 0.3e1 * t538 * t1261 - 0.3200e4 / 0.9e1 * t1010 * t1235 + 0.880e3 / 0.27e2 * t539 * t1238 + 0.4000e4 / 0.9e1 * t120 * t1265 - 0.800e3 / 0.3e1 * t1015 * t1235 + 0.880e3 / 0.27e2 * t542 * t1238
  t1873 = t32 * t149
  t1874 = t128 * t198 * t1873
  t1878 = 0.1e1 / t18 / t320
  t1883 = t128 * t222
  t1887 = -0.184320e-3 * t124 * t1307 + 0.28444444444444444444444444444444444444444444444442e0 * t220 / t247 / t197 * t1794 + 0.10922666666666666666666666666666666666666666666667e-4 * t281 * t123 * t666 - 0.69176888888888888888888888888888888888888888888893e-4 * t1026 * t1307 - 0.58709333333333333333333333333333333333333333333336e-4 * t1030 * t666 + 0.2000e4 / 0.9e1 * t41 * t1218 * t1220 + 0.40960000000000000000000000000000000000000000000002e-5 * t754 * t123 * t240 + 0.74565404444444444444444444444444444444444444444451e-10 * t122 * t317 * t103 / t1211 / t319 / t323 / t110 + 0.1000e4 / 0.9e1 * t24 * t1218 * t1220 + 0.28444444444444444444444444444444444444444444444442e-1 * t145 * t248 * t1794 + 0.55296e-4 * t546 * t666 - 0.6144e-5 * t1021 * t240 + 0.256e-6 * t1859 * t123 * t129 + 0.1000e4 / 0.9e1 * t47 * t1218 * t1220 + 0.24181570370370370370370370370370370370370370370372e-3 * t559 * t1307 + 0.11377777777777777777777777777777777777777777777776e0 * t196 * t580 * t1794 + 0.10922666666666666666666666666666666666666666666667e-5 * t573 * t1177 * t1874 + 0.14563555555555555555555555555555555555555555555556e-5 * t702 * t1878 * t1874 + 0.29127111111111111111111111111111111111111111111112e-5 * t707 * t1878 * t1883 * t1873
  t1890 = 0.1e1 / t19 / t125 * t111
  t1891 = t1890 * t553
  t1926 = t148 * t33
  t1983 = 0.440e3 / 0.27e2 * t481 * t1229 - 0.800e3 / 0.9e1 * t1068 * t1232 + 0.2000e4 * t494 * t1265 + 0.10000e5 / 0.9e1 * t140 * t1273 + 0.4000e4 / 0.9e1 * t142 * t36 * t1261 + 0.8000e4 / 0.3e1 * t1095 * t1265 + 0.40000e5 / 0.9e1 * t501 * t1273 + 0.20000e5 / 0.9e1 * t143 * t1387 - 0.800e3 / 0.9e1 * t1060 * t1232 + 0.1000e4 / 0.9e1 * t134 * t1261 + 0.2000e4 / 0.3e1 * t487 * t1261 + 0.4000e4 / 0.9e1 * t137 * t1265 + 0.1000e4 * t1081 * t1261 - 0.12800e5 / 0.9e1 * t1099 * t1235 + 0.1760e4 / 0.27e2 * t502 * t1238 - 0.8000e4 / 0.9e1 * t1104 * t1235
  t2019 = 0.1760e4 / 0.27e2 * t505 * t1238 - 0.3200e4 / 0.9e1 * t1071 * t1235 + 0.880e3 / 0.27e2 * t488 * t1238 - 0.800e3 / 0.3e1 * t1076 * t1235 + 0.880e3 / 0.27e2 * t491 * t1238 - 0.800e3 / 0.3e1 * t1082 * t1235 - 0.800e3 * t1085 * t1235 - 0.800e3 / 0.9e1 * t1063 * t1235 + 0.440e3 / 0.27e2 * t484 * t1238 + 0.440e3 / 0.9e1 * t495 * t1238 - 0.1600e4 / 0.3e1 * t1090 * t1235 + 0.440e3 / 0.9e1 * t498 * t1238 - 0.1600e4 / 0.3e1 * t1096 * t1235 + 0.1000e4 / 0.9e1 * t133 * t1218 * t1220 + 0.2000e4 / 0.9e1 * t136 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t139 * t1218 * t1220
  t2044 = -0.800e3 / 0.9e1 * t1121 * t1232 + 0.440e3 / 0.27e2 * t510 * t1229 - 0.800e3 / 0.3e1 * t1135 * t1235 - 0.800e3 * t1138 * t1235 + 0.440e3 / 0.9e1 * t524 * t1238 - 0.1600e4 / 0.3e1 * t1143 * t1235 + 0.440e3 / 0.9e1 * t527 * t1238 - 0.800e3 / 0.9e1 * t1116 * t1235 + 0.440e3 / 0.27e2 * t513 * t1238 - 0.3200e4 / 0.9e1 * t1124 * t1235 + 0.880e3 / 0.27e2 * t517 * t1238
  t2072 = -0.800e3 / 0.3e1 * t1129 * t1235 + 0.880e3 / 0.27e2 * t520 * t1238 - 0.800e3 / 0.9e1 * t1113 * t1232 + 0.1000e4 / 0.9e1 * t188 * t1261 + 0.2000e4 / 0.3e1 * t516 * t1261 + 0.4000e4 / 0.9e1 * t191 * t1265 + 0.1000e4 * t1134 * t1261 + 0.2000e4 * t523 * t1265 + 0.10000e5 / 0.9e1 * t194 * t1273 + 0.1000e4 / 0.9e1 * t187 * t1218 * t1220 + 0.2000e4 / 0.9e1 * t190 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t193 * t1218 * t1220
  t2105 = 0.440e3 / 0.27e2 * t466 * t1229 - 0.800e3 / 0.9e1 * t1035 * t1232 + 0.1000e4 / 0.9e1 * t214 * t1218 * t1220 + 0.1000e4 / 0.9e1 * t215 * t1261 - 0.800e3 / 0.9e1 * t1038 * t1235 + 0.440e3 / 0.27e2 * t469 * t1238 - 0.800e3 / 0.9e1 * t1043 * t1232 + 0.2000e4 / 0.9e1 * t217 * t1218 * t1220 + 0.2000e4 / 0.3e1 * t472 * t1261 - 0.3200e4 / 0.9e1 * t1046 * t1235 + 0.880e3 / 0.27e2 * t473 * t1238 + 0.4000e4 / 0.9e1 * t218 * t1265 - 0.800e3 / 0.3e1 * t1051 * t1235 + 0.880e3 / 0.27e2 * t476 * t1238
  t2107 = -0.35271111111111111111111111111111111111111111111111e-3 * t1164 * t1891 - 0.34133333333333333333333333333333333333333333333331e-2 * t166 * t288 * t1169 + 0.13653333333333333333333333333333333333333333333334e-3 * t857 * t33 * t1155 + 0.25599999999999999999999999999999999999999999999999e-2 * t372 * t108 * t1161 - 0.70542222222222222222222222222222222222222222222224e-3 * t1150 * t1890 * t1154 - 0.10240000000000000000000000000000000000000000000000e-1 * t208 * t288 * t1161 + 0.12800000000000000000000000000000000000000000000000e-4 * t982 * t33 * t554 + 0.68266666666666666666666666666666666666666666666665e-4 * t951 * t1152 * t111 * t198 * t149 * t33 + 0.85333333333333333333333333333333333333333333333326e-3 * t442 * t108 * t1169 - 0.85560888888888888888888888888888888888888888888892e-5 * t237 * t1878 * t1874 + 0.45511111111111111111111111111111111111111111111108e-3 * t208 * t551 * t88 * t580 * t1926 + 0.14563555555555555555555555555555555555555555555556e-6 * t237 * t322 * t1883 * t569 * t33 + 0.91022222222222222222222222222222222222222222222218e-6 * t180 / t18 / t238 * t1654 * t148 * t32 + 0.11377777777777777777777777777777777777777777777777e-3 * t166 * t551 * t1159 * t1926 + 0.53665185185185185185185185185185185185185185185185e-3 * t549 * t1891 - 0.15360000000000000000000000000000000000000000000000e-3 * t1172 * t1165 + (t1983 + t2019) * t153 + (t2044 + t2072) * t198 + t2105 * t222
  t2115 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t82 * t224 + t6 * t22 * t563 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t229 * t1187 - 0.3e1 / 0.8e1 * t6 * t567 * (t1324 + t1457 + t1508 + t1646 + t1699 + t1787 + t1887 + t2107))
  v3rho3_0_ = 0.2e1 * r0 * t2115 + 0.6e1 * t1192

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t25 = params.c[1]
  t26 = 6 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = jnp.pi ** 2
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = 0.3e1 / 0.10e2 * t27 * t30
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = tau0 * t34
  t37 = 0.1e1 / t20 / r0
  t38 = t35 * t37
  t39 = t32 - t38
  t40 = t25 * t39
  t41 = t32 + t38
  t42 = 0.1e1 / t41
  t44 = params.c[2]
  t45 = t39 ** 2
  t46 = t44 * t45
  t47 = t41 ** 2
  t48 = 0.1e1 / t47
  t50 = params.c[3]
  t51 = t45 * t39
  t52 = t50 * t51
  t53 = t47 * t41
  t54 = 0.1e1 / t53
  t56 = params.c[4]
  t57 = t45 ** 2
  t58 = t56 * t57
  t59 = t47 ** 2
  t60 = 0.1e1 / t59
  t62 = params.c[5]
  t64 = t62 * t57 * t39
  t66 = 0.1e1 / t59 / t41
  t69 = params.c[7]
  t70 = t69 * t39
  t72 = params.c[8]
  t73 = t72 * t45
  t75 = params.c[9]
  t76 = t75 * t51
  t78 = params.c[10]
  t79 = t78 * t57
  t81 = t70 * t42 + t73 * t48 + t76 * t54 + t79 * t60 + params.c[6]
  t82 = t81 * s0
  t83 = t34 * t22
  t87 = 0.1e1 + 0.4e-2 * s0 * t34 * t22
  t88 = 0.1e1 / t87
  t89 = t83 * t88
  t93 = params.c[12]
  t94 = t93 * t39
  t96 = params.c[13]
  t97 = t96 * t45
  t99 = params.c[14]
  t100 = t99 * t51
  t102 = t100 * t54 + t94 * t42 + t97 * t48 + params.c[11]
  t103 = s0 ** 2
  t104 = t102 * t103
  t105 = t18 ** 2
  t106 = t105 * r0
  t108 = 0.1e1 / t19 / t106
  t109 = t33 * t108
  t110 = t87 ** 2
  t111 = 0.1e1 / t110
  t112 = t109 * t111
  t116 = params.c[16]
  t117 = t116 * t39
  t119 = params.c[17]
  t120 = t119 * t45
  t122 = t117 * t42 + t120 * t48 + params.c[15]
  t123 = t103 * s0
  t124 = t122 * t123
  t125 = t105 ** 2
  t126 = 0.1e1 / t125
  t127 = t110 * t87
  t128 = 0.1e1 / t127
  t129 = t126 * t128
  t133 = params.c[19]
  t134 = t133 * t39
  t136 = params.c[20]
  t137 = t136 * t45
  t139 = params.c[21]
  t140 = t139 * t51
  t142 = params.c[22]
  t143 = t142 * t57
  t145 = t134 * t42 + t137 * t48 + t140 * t54 + t143 * t60 + params.c[18]
  t148 = 0.1e1 / t11
  t149 = t148 ** (0.1e1 / 0.3e1)
  t152 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 / t19 * t33 * t149
  t153 = 0.1e1 / t152
  t156 = params.c[24]
  t157 = t156 * t39
  t159 = params.c[25]
  t160 = t159 * t45
  t162 = params.c[26]
  t163 = t162 * t51
  t165 = t157 * t42 + t160 * t48 + t163 * t54 + params.c[23]
  t166 = t165 * s0
  t167 = t166 * t34
  t168 = t22 * t88
  t169 = t168 * t153
  t173 = params.c[28]
  t174 = t173 * t39
  t176 = params.c[29]
  t177 = t176 * t45
  t179 = t174 * t42 + t177 * t48 + params.c[27]
  t180 = t179 * t103
  t181 = t180 * t33
  t183 = t108 * t111 * t153
  t187 = params.c[31]
  t188 = t187 * t39
  t190 = params.c[32]
  t191 = t190 * t45
  t193 = params.c[33]
  t194 = t193 * t51
  t196 = t188 * t42 + t191 * t48 + t194 * t54 + params.c[30]
  t197 = t152 ** 2
  t198 = 0.1e1 / t197
  t201 = params.c[35]
  t202 = t201 * t39
  t204 = params.c[36]
  t205 = t204 * t45
  t207 = t202 * t42 + t205 * t48 + params.c[34]
  t208 = t207 * s0
  t209 = t208 * t34
  t210 = t168 * t198
  t214 = params.c[38]
  t215 = t214 * t39
  t217 = params.c[39]
  t218 = t217 * t45
  t220 = t215 * t42 + t218 * t48 + params.c[37]
  t221 = t197 * t152
  t222 = 0.1e1 / t221
  t224 = params.c[0] + t40 * t42 + t46 * t48 + t52 * t54 + t58 * t60 + t64 * t66 + 0.4e-2 * t82 * t89 + 0.32e-4 * t104 * t112 + 0.256e-6 * t124 * t129 + t145 * t153 + 0.4e-2 * t167 * t169 + 0.32e-4 * t181 * t183 + t196 * t198 + 0.4e-2 * t209 * t210 + t220 * t222
  t227 = 0.5e1 / 0.36e2 * t6 * t23 * t224
  t228 = t17 * t37
  t229 = t18 * r0
  t231 = 0.1e1 / t20 / t229
  t232 = t34 * t231
  t233 = t232 * t88
  t236 = t105 * t18
  t238 = 0.1e1 / t19 / t236
  t239 = t33 * t238
  t240 = t239 * t111
  t243 = t145 * t198
  t247 = 0.1e1 / t19 / r0 * t33 * t149
  t250 = t179 * t123
  t251 = t125 * r0
  t252 = 0.1e1 / t251
  t253 = t252 * t128
  t254 = t253 * t153
  t257 = t196 * t222
  t260 = t197 ** 2
  t261 = 0.1e1 / t260
  t262 = t220 * t261
  t265 = t69 * tau0
  t266 = t83 * t42
  t269 = t70 * t48
  t270 = t35 * t22
  t273 = t72 * t39
  t274 = t273 * t48
  t277 = t73 * t54
  t280 = t75 * t45
  t281 = t280 * t54
  t284 = t76 * t60
  t287 = t78 * t51
  t288 = t287 * t60
  t291 = t79 * t66
  t294 = 0.5e1 / 0.3e1 * t265 * t266 + 0.5e1 / 0.3e1 * t269 * t270 + 0.10e2 / 0.3e1 * t274 * t270 + 0.10e2 / 0.3e1 * t277 * t270 + 0.5e1 * t281 * t270 + 0.5e1 * t284 * t270 + 0.20e2 / 0.3e1 * t288 * t270 + 0.20e2 / 0.3e1 * t291 * t270
  t295 = t294 * s0
  t298 = t81 * t103
  t301 = t93 * tau0
  t304 = t94 * t48
  t307 = t96 * t39
  t308 = t307 * t48
  t311 = t97 * t54
  t314 = t99 * t45
  t315 = t314 * t54
  t318 = t100 * t60
  t321 = 0.5e1 / 0.3e1 * t301 * t266 + 0.5e1 / 0.3e1 * t304 * t270 + 0.10e2 / 0.3e1 * t308 * t270 + 0.10e2 / 0.3e1 * t311 * t270 + 0.5e1 * t315 * t270 + 0.5e1 * t318 * t270
  t322 = t321 * t103
  t325 = t103 ** 2
  t326 = t122 * t325
  t327 = t125 * t229
  t329 = 0.1e1 / t20 / t327
  t330 = t110 ** 2
  t331 = 0.1e1 / t330
  t333 = t329 * t331 * t34
  t336 = t25 * tau0
  t339 = t201 * tau0
  t342 = t202 * t48
  t345 = t204 * t39
  t346 = t345 * t48
  t349 = t205 * t54
  t352 = 0.5e1 / 0.3e1 * t339 * t266 + 0.5e1 / 0.3e1 * t342 * t270 + 0.10e2 / 0.3e1 * t346 * t270 + 0.10e2 / 0.3e1 * t349 * t270
  t353 = t352 * s0
  t354 = t353 * t34
  t357 = t207 * t103
  t358 = t357 * t33
  t359 = t238 * t111
  t360 = t359 * t198
  t363 = 0.1e1 / t105
  t365 = t88 * t222
  t366 = t365 * t149
  t369 = t56 * t51
  t370 = t369 * t60
  t373 = t58 * t66
  t376 = t62 * t57
  t377 = t376 * t66
  t381 = 0.1e1 / t59 / t47
  t382 = t64 * t381
  t385 = -0.10666666666666666666666666666666666666666666666667e-1 * t82 * t233 - 0.17066666666666666666666666666666666666666666666667e-3 * t104 * t240 + 0.13333333333333333333333333333333333333333333333333e0 * t243 * t247 + 0.13653333333333333333333333333333333333333333333334e-5 * t250 * t254 + 0.26666666666666666666666666666666666666666666666666e0 * t257 * t247 + 0.39999999999999999999999999999999999999999999999999e0 * t262 * t247 + 0.4e-2 * t295 * t89 + 0.85333333333333333333333333333333333333333333333336e-4 * t298 * t240 + 0.32e-4 * t322 * t112 + 0.81920000000000000000000000000000000000000000000003e-8 * t326 * t333 + 0.5e1 / 0.3e1 * t336 * t266 + 0.4e-2 * t354 * t210 + 0.85333333333333333333333333333333333333333333333336e-4 * t358 * t360 + 0.21333333333333333333333333333333333333333333333333e-2 * t208 * t363 * t366 + 0.20e2 / 0.3e1 * t370 * t270 + 0.20e2 / 0.3e1 * t373 * t270 + 0.25e2 / 0.3e1 * t377 * t270 + 0.25e2 / 0.3e1 * t382 * t270
  t386 = t156 * tau0
  t389 = t157 * t48
  t392 = t159 * t39
  t393 = t392 * t48
  t396 = t160 * t54
  t399 = t162 * t45
  t400 = t399 * t54
  t403 = t163 * t60
  t406 = 0.5e1 / 0.3e1 * t386 * t266 + 0.5e1 / 0.3e1 * t389 * t270 + 0.10e2 / 0.3e1 * t393 * t270 + 0.10e2 / 0.3e1 * t396 * t270 + 0.5e1 * t400 * t270 + 0.5e1 * t403 * t270
  t407 = t406 * s0
  t408 = t407 * t34
  t411 = t165 * t103
  t412 = t411 * t33
  t413 = t359 * t153
  t418 = t88 * t198 * t149
  t421 = t173 * tau0
  t424 = t174 * t48
  t427 = t176 * t39
  t428 = t427 * t48
  t431 = t177 * t54
  t434 = 0.5e1 / 0.3e1 * t421 * t266 + 0.5e1 / 0.3e1 * t424 * t270 + 0.10e2 / 0.3e1 * t428 * t270 + 0.10e2 / 0.3e1 * t431 * t270
  t435 = t434 * t103
  t436 = t435 * t33
  t441 = t231 * t88
  t442 = t441 * t198
  t445 = t441 * t153
  t448 = t40 * t48
  t451 = t44 * t39
  t452 = t451 * t48
  t455 = t46 * t54
  t458 = t50 * t45
  t459 = t458 * t54
  t462 = t52 * t60
  t465 = t133 * tau0
  t468 = t134 * t48
  t471 = t136 * t39
  t472 = t471 * t48
  t475 = t137 * t54
  t478 = t139 * t45
  t479 = t478 * t54
  t482 = t140 * t60
  t485 = t142 * t51
  t486 = t485 * t60
  t489 = t143 * t66
  t492 = 0.5e1 / 0.3e1 * t465 * t266 + 0.5e1 / 0.3e1 * t468 * t270 + 0.10e2 / 0.3e1 * t472 * t270 + 0.10e2 / 0.3e1 * t475 * t270 + 0.5e1 * t479 * t270 + 0.5e1 * t482 * t270 + 0.20e2 / 0.3e1 * t486 * t270 + 0.20e2 / 0.3e1 * t489 * t270
  t494 = t187 * tau0
  t497 = t188 * t48
  t500 = t190 * t39
  t501 = t500 * t48
  t504 = t191 * t54
  t507 = t193 * t45
  t508 = t507 * t54
  t511 = t194 * t60
  t514 = 0.5e1 / 0.3e1 * t494 * t266 + 0.5e1 / 0.3e1 * t497 * t270 + 0.10e2 / 0.3e1 * t501 * t270 + 0.10e2 / 0.3e1 * t504 * t270 + 0.5e1 * t508 * t270 + 0.5e1 * t511 * t270
  t516 = t214 * tau0
  t519 = t215 * t48
  t522 = t217 * t39
  t523 = t522 * t48
  t526 = t218 * t54
  t529 = 0.5e1 / 0.3e1 * t516 * t266 + 0.5e1 / 0.3e1 * t519 * t270 + 0.10e2 / 0.3e1 * t523 * t270 + 0.10e2 / 0.3e1 * t526 * t270
  t533 = t102 * t123
  t536 = t116 * tau0
  t539 = t117 * t48
  t542 = t119 * t39
  t543 = t542 * t48
  t546 = t120 * t54
  t549 = 0.5e1 / 0.3e1 * t536 * t266 + 0.5e1 / 0.3e1 * t539 * t270 + 0.10e2 / 0.3e1 * t543 * t270 + 0.10e2 / 0.3e1 * t546 * t270
  t550 = t549 * t123
  t553 = t180 * t34
  t555 = 0.1e1 / t20 / t236
  t557 = t198 * t149
  t558 = t555 * t111 * t557
  t561 = 0.4e-2 * t408 * t169 + 0.85333333333333333333333333333333333333333333333336e-4 * t412 * t413 + 0.10666666666666666666666666666666666666666666666666e-2 * t166 * t363 * t418 + 0.32e-4 * t436 * t183 - 0.17066666666666666666666666666666666666666666666667e-3 * t181 * t413 - 0.10666666666666666666666666666666666666666666666667e-1 * t209 * t442 - 0.10666666666666666666666666666666666666666666666667e-1 * t167 * t445 + 0.5e1 / 0.3e1 * t448 * t270 + 0.10e2 / 0.3e1 * t452 * t270 + 0.10e2 / 0.3e1 * t455 * t270 + 0.5e1 * t459 * t270 + 0.5e1 * t462 * t270 + t492 * t153 + t514 * t198 + t529 * t222 - 0.2048e-5 * t124 * t253 + 0.13653333333333333333333333333333333333333333333334e-5 * t533 * t253 + 0.256e-6 * t550 * t129 + 0.42666666666666666666666666666666666666666666666666e-5 * t553 * t558
  t562 = t385 + t561
  t565 = t6 * t228 * t562 / 0.4e1
  t567 = t17 / t20
  t568 = t325 * s0
  t569 = t122 * t568
  t570 = t105 * t229
  t571 = t125 * t570
  t573 = 0.1e1 / t19 / t571
  t575 = 0.1e1 / t330 / t87
  t577 = t573 * t575 * t33
  t580 = tau0 ** 2
  t581 = t25 * t580
  t582 = t109 * t48
  t585 = t145 * t222
  t586 = t149 ** 2
  t587 = t83 * t586
  t590 = t434 * t123
  t593 = t196 * t261
  t597 = 0.1e1 / t260 / t152
  t598 = t220 * t597
  t601 = t232 * t42
  t604 = t69 * t580
  t607 = t70 * t54
  t608 = t580 * t33
  t609 = t608 * t108
  t612 = t35 * t231
  t615 = t72 * t580
  t618 = t273 * t54
  t623 = t73 * t60
  t628 = t75 * t39
  t629 = t628 * t54
  t632 = t280 * t60
  t637 = t76 * t66
  t642 = t78 * t45
  t643 = t642 * t60
  t646 = t287 * t66
  t651 = t79 * t381
  t656 = -0.40e2 / 0.9e1 * t265 * t601 + 0.100e3 / 0.9e1 * t604 * t582 + 0.100e3 / 0.9e1 * t607 * t609 - 0.40e2 / 0.9e1 * t269 * t612 + 0.100e3 / 0.9e1 * t615 * t582 + 0.400e3 / 0.9e1 * t618 * t609 - 0.80e2 / 0.9e1 * t274 * t612 + 0.100e3 / 0.3e1 * t623 * t609 - 0.80e2 / 0.9e1 * t277 * t612 + 0.100e3 / 0.3e1 * t629 * t609 + 0.100e3 * t632 * t609 - 0.40e2 / 0.3e1 * t281 * t612 + 0.200e3 / 0.3e1 * t637 * t609 - 0.40e2 / 0.3e1 * t284 * t612 + 0.200e3 / 0.3e1 * t643 * t609 + 0.1600e4 / 0.9e1 * t646 * t609 - 0.160e3 / 0.9e1 * t288 * t612 + 0.1000e4 / 0.9e1 * t651 * t609 - 0.160e3 / 0.9e1 * t291 * t612
  t657 = t656 * s0
  t662 = t133 * t580
  t665 = t134 * t54
  t670 = t136 * t580
  t673 = t471 * t54
  t678 = t137 * t60
  t683 = t139 * t39
  t684 = t683 * t54
  t687 = t478 * t60
  t692 = t140 * t66
  t697 = t142 * t45
  t698 = t697 * t60
  t701 = t485 * t66
  t706 = t143 * t381
  t711 = -0.40e2 / 0.9e1 * t465 * t601 + 0.100e3 / 0.9e1 * t662 * t582 + 0.100e3 / 0.9e1 * t665 * t609 - 0.40e2 / 0.9e1 * t468 * t612 + 0.100e3 / 0.9e1 * t670 * t582 + 0.400e3 / 0.9e1 * t673 * t609 - 0.80e2 / 0.9e1 * t472 * t612 + 0.100e3 / 0.3e1 * t678 * t609 - 0.80e2 / 0.9e1 * t475 * t612 + 0.100e3 / 0.3e1 * t684 * t609 + 0.100e3 * t687 * t609 - 0.40e2 / 0.3e1 * t479 * t612 + 0.200e3 / 0.3e1 * t692 * t609 - 0.40e2 / 0.3e1 * t482 * t612 + 0.200e3 / 0.3e1 * t698 * t609 + 0.1600e4 / 0.9e1 * t701 * t609 - 0.160e3 / 0.9e1 * t486 * t612 + 0.1000e4 / 0.9e1 * t706 * t609 - 0.160e3 / 0.9e1 * t489 * t612
  t715 = t187 * t580
  t718 = t188 * t54
  t723 = t190 * t580
  t726 = t500 * t54
  t731 = t191 * t60
  t736 = t193 * t39
  t737 = t736 * t54
  t740 = t507 * t60
  t745 = t194 * t66
  t750 = -0.40e2 / 0.9e1 * t494 * t601 + 0.100e3 / 0.9e1 * t715 * t582 + 0.100e3 / 0.9e1 * t718 * t609 - 0.40e2 / 0.9e1 * t497 * t612 + 0.100e3 / 0.9e1 * t723 * t582 + 0.400e3 / 0.9e1 * t726 * t609 - 0.80e2 / 0.9e1 * t501 * t612 + 0.100e3 / 0.3e1 * t731 * t609 - 0.80e2 / 0.9e1 * t504 * t612 + 0.100e3 / 0.3e1 * t737 * t609 + 0.100e3 * t740 * t609 - 0.40e2 / 0.3e1 * t508 * t612 + 0.200e3 / 0.3e1 * t745 * t609 - 0.40e2 / 0.3e1 * t511 * t612
  t753 = 0.1e1 / t20 / t570
  t754 = t753 * t111
  t755 = t754 * t557
  t759 = t357 * t34
  t760 = t222 * t149
  t761 = t754 * t760
  t765 = t88 * t261
  t766 = t586 * t33
  t767 = t765 * t766
  t770 = t411 * t34
  t774 = t365 * t766
  t777 = t435 * t34
  t781 = t125 * t18
  t783 = 0.1e1 / t19 / t781
  t785 = t783 * t128 * t557
  t788 = 0.1e1 / t781
  t789 = t788 * t128
  t792 = t81 * t123
  t795 = t321 * t123
  t802 = 0.45511111111111111111111111111111111111111111111112e-4 * t759 * t761 + 0.85333333333333333333333333333333333333333333333330e-3 * t208 * t108 * t767 + 0.22755555555555555555555555555555555555555555555555e-4 * t770 * t755 + 0.28444444444444444444444444444444444444444444444442e-3 * t166 * t108 * t774 + 0.85333333333333333333333333333333333333333333333332e-5 * t777 * t558 + 0.36408888888888888888888888888888888888888888888890e-6 * t250 * t33 * t785 + 0.18432e-4 * t124 * t789 + 0.36408888888888888888888888888888888888888888888891e-5 * t792 * t789 + 0.27306666666666666666666666666666666666666666666668e-5 * t795 * t253 - 0.19569777777777777777777777777777777777777777777779e-4 * t533 * t789 - 0.4096e-5 * t550 * t253
  t806 = t116 * t580
  t809 = t117 * t54
  t814 = t119 * t580
  t817 = t542 * t54
  t822 = t120 * t60
  t827 = -0.40e2 / 0.9e1 * t536 * t601 + 0.100e3 / 0.9e1 * t806 * t582 + 0.100e3 / 0.9e1 * t809 * t609 - 0.40e2 / 0.9e1 * t539 * t612 + 0.100e3 / 0.9e1 * t814 * t582 + 0.400e3 / 0.9e1 * t817 * t609 - 0.80e2 / 0.9e1 * t543 * t612 + 0.100e3 / 0.3e1 * t822 * t609 - 0.80e2 / 0.9e1 * t546 * t612
  t828 = t827 * t123
  t833 = t173 * t580
  t836 = t174 * t54
  t841 = t176 * t580
  t844 = t427 * t54
  t849 = t177 * t60
  t854 = -0.40e2 / 0.9e1 * t421 * t601 + 0.100e3 / 0.9e1 * t833 * t582 + 0.100e3 / 0.9e1 * t836 * t609 - 0.40e2 / 0.9e1 * t424 * t612 + 0.100e3 / 0.9e1 * t841 * t582 + 0.400e3 / 0.9e1 * t844 * t609 - 0.80e2 / 0.9e1 * t428 * t612 + 0.100e3 / 0.3e1 * t849 * t609 - 0.80e2 / 0.9e1 * t431 * t612
  t855 = t854 * t103
  t856 = t855 * t33
  t859 = t56 * t45
  t860 = t859 * t60
  t863 = t369 * t66
  t866 = t58 * t381
  t869 = t62 * t51
  t870 = t869 * t66
  t873 = t376 * t381
  t877 = 0.1e1 / t59 / t53
  t878 = t64 * t877
  t881 = t406 * t103
  t882 = t881 * t33
  t893 = t201 * t580
  t896 = t202 * t54
  t901 = t204 * t580
  t904 = t345 * t54
  t909 = t205 * t60
  t914 = -0.40e2 / 0.9e1 * t339 * t601 + 0.100e3 / 0.9e1 * t893 * t582 + 0.100e3 / 0.9e1 * t896 * t609 - 0.40e2 / 0.9e1 * t342 * t612 + 0.100e3 / 0.9e1 * t901 * t582 + 0.400e3 / 0.9e1 * t904 * t609 - 0.80e2 / 0.9e1 * t346 * t612 + 0.100e3 / 0.3e1 * t909 * t609 - 0.80e2 / 0.9e1 * t349 * t612
  t915 = t914 * s0
  t916 = t915 * t34
  t919 = t352 * t103
  t920 = t919 * t33
  t935 = 0.1e1 / t19 / t570
  t936 = t935 * t111
  t937 = t936 * t153
  t941 = 0.1e1 / t20 / t105
  t942 = t941 * t88
  t943 = t942 * t198
  t948 = t111 * t222 * t586
  t951 = -0.200e3 / 0.9e1 * t382 * t612 + 0.4e-2 * t916 * t210 + 0.17066666666666666666666666666666666666666666666667e-3 * t920 * t360 + 0.42666666666666666666666666666666666666666666666666e-2 * t353 * t363 * t366 - 0.80e2 / 0.9e1 * t455 * t612 - 0.40e2 / 0.3e1 * t459 * t612 - 0.40e2 / 0.3e1 * t462 * t612 - 0.160e3 / 0.9e1 * t370 * t612 + 0.10808888888888888888888888888888888888888888888889e-2 * t181 * t937 + 0.39111111111111111111111111111111111111111111111112e-1 * t209 * t943 + 0.22755555555555555555555555555555555555555555555555e-5 * t180 * t126 * t948
  t954 = t179 * t325
  t955 = t125 * t105
  t957 = 0.1e1 / t20 / t955
  t960 = t331 * t153 * t34
  t967 = t451 * t54
  t970 = t46 * t60
  t973 = t50 * t39
  t974 = t973 * t54
  t977 = t458 * t60
  t980 = t52 * t66
  t988 = t936 * t198
  t991 = t942 * t153
  t1000 = t156 * t580
  t1003 = t157 * t54
  t1008 = t159 * t580
  t1011 = t392 * t54
  t1016 = t160 * t60
  t1021 = t162 * t39
  t1022 = t1021 * t54
  t1025 = t399 * t60
  t1030 = t163 * t66
  t1035 = -0.40e2 / 0.9e1 * t386 * t601 + 0.100e3 / 0.9e1 * t1000 * t582 + 0.100e3 / 0.9e1 * t1003 * t609 - 0.40e2 / 0.9e1 * t389 * t612 + 0.100e3 / 0.9e1 * t1008 * t582 + 0.400e3 / 0.9e1 * t1011 * t609 - 0.80e2 / 0.9e1 * t393 * t612 + 0.100e3 / 0.3e1 * t1016 * t609 - 0.80e2 / 0.9e1 * t396 * t612 + 0.100e3 / 0.3e1 * t1022 * t609 + 0.100e3 * t1025 * t609 - 0.40e2 / 0.3e1 * t400 * t612 + 0.200e3 / 0.3e1 * t1030 * t609 - 0.40e2 / 0.3e1 * t403 * t612
  t1036 = t1035 * s0
  t1037 = t1036 * t34
  t1040 = 0.1e1 / t106
  t1051 = t40 * t54
  t1056 = t214 * t580
  t1059 = t215 * t54
  t1064 = t217 * t580
  t1067 = t522 * t54
  t1072 = t218 * t60
  t1077 = -0.40e2 / 0.9e1 * t516 * t601 + 0.100e3 / 0.9e1 * t1056 * t582 + 0.100e3 / 0.9e1 * t1059 * t609 - 0.40e2 / 0.9e1 * t519 * t612 + 0.100e3 / 0.9e1 * t1064 * t582 + 0.400e3 / 0.9e1 * t1067 * t609 - 0.80e2 / 0.9e1 * t523 * t612 + 0.100e3 / 0.3e1 * t1072 * t609 - 0.80e2 / 0.9e1 * t526 * t612
  t1079 = -0.76800000000000000000000000000000000000000000000003e-3 * t358 * t988 + 0.39111111111111111111111111111111111111111111111112e-1 * t167 * t991 - 0.40e2 / 0.9e1 * t448 * t612 - 0.80e2 / 0.9e1 * t452 * t612 + 0.4e-2 * t1037 * t169 - 0.14222222222222222222222222222222222222222222222222e-1 * t208 * t1040 * t366 - 0.21333333333333333333333333333333333333333333333334e-1 * t408 * t445 - 0.76800000000000000000000000000000000000000000000003e-3 * t412 * t937 - 0.71111111111111111111111111111111111111111111111109e-2 * t166 * t1040 * t418 + 0.100e3 / 0.9e1 * t1051 * t609 + t1077 * t222
  t1081 = t294 * t103
  t1084 = t529 * t261
  t1087 = t514 * t222
  t1090 = t492 * t198
  t1096 = 0.1e1 / t19 / t18 * t33 * t149
  t1099 = t789 * t153
  t1107 = t957 * t331 * t34
  t1113 = t34 * t941
  t1114 = t1113 * t88
  t1117 = t33 * t935
  t1118 = t1117 * t111
  t1127 = t165 * t123
  t1130 = t207 * t123
  t1131 = t789 * t198
  t1134 = t102 * t325
  t1137 = t44 * t580
  t1142 = t93 * t580
  t1145 = t94 * t54
  t1150 = t96 * t580
  t1153 = t307 * t54
  t1158 = t97 * t60
  t1163 = t99 * t39
  t1164 = t1163 * t54
  t1167 = t314 * t60
  t1172 = t100 * t66
  t1177 = -0.40e2 / 0.9e1 * t301 * t601 + 0.100e3 / 0.9e1 * t1142 * t582 + 0.100e3 / 0.9e1 * t1145 * t609 - 0.40e2 / 0.9e1 * t304 * t612 + 0.100e3 / 0.9e1 * t1150 * t582 + 0.400e3 / 0.9e1 * t1153 * t609 - 0.80e2 / 0.9e1 * t308 * t612 + 0.100e3 / 0.3e1 * t1158 * t609 - 0.80e2 / 0.9e1 * t311 * t612 + 0.100e3 / 0.3e1 * t1164 * t609 + 0.100e3 * t1167 * t609 - 0.40e2 / 0.3e1 * t315 * t612 + 0.200e3 / 0.3e1 * t1172 * t609 - 0.40e2 / 0.3e1 * t318 * t612
  t1178 = t1177 * t103
  t1181 = t549 * t325
  t1184 = 0.39111111111111111111111111111111111111111111111112e-1 * t82 * t1114 + 0.10808888888888888888888888888888888888888888888889e-2 * t104 * t1118 - 0.76800000000000000000000000000000000000000000000003e-3 * t298 * t1118 - 0.34133333333333333333333333333333333333333333333334e-3 * t322 * t240 - 0.21333333333333333333333333333333333333333333333334e-1 * t295 * t233 + 0.36408888888888888888888888888888888888888888888891e-5 * t1127 * t1099 + 0.36408888888888888888888888888888888888888888888891e-5 * t1130 * t1131 + 0.43690666666666666666666666666666666666666666666670e-7 * t1134 * t1107 + 0.100e3 / 0.9e1 * t1137 * t582 + 0.32e-4 * t1178 * t112 + 0.16384000000000000000000000000000000000000000000001e-7 * t1181 * t333
  t1187 = t951 + t1079 + t1184 + t802 + 0.21333333333333333333333333333333333333333333333332e-2 * t407 * t363 * t418 + 0.43690666666666666666666666666666666666666666666670e-7 * t954 * t957 * t960 + 0.79999999999999999999999999999999999999999999999998e0 * t1084 * t247 + 0.53333333333333333333333333333333333333333333333332e0 * t1087 * t247 + 0.26666666666666666666666666666666666666666666666666e0 * t1090 * t247 - 0.17777777777777777777777777777777777777777777777777e0 * t243 * t1096 - 0.19569777777777777777777777777777777777777777777779e-4 * t250 * t1099 - 0.35555555555555555555555555555555555555555555555555e0 * t257 * t1096 - 0.53333333333333333333333333333333333333333333333332e0 * t262 * t1096 - 0.16110933333333333333333333333333333333333333333334e-6 * t326 * t1107 - 0.40e2 / 0.9e1 * t336 * t601 - 0.160e3 / 0.9e1 * t373 * t612 - 0.200e3 / 0.9e1 * t377 * t612 + 0.400e3 / 0.9e1 * t967 * t609 + 0.17066666666666666666666666666666666666666666666667e-3 * t882 * t413 + 0.256e-6 * t828 * t129 + 0.17066666666666666666666666666666666666666666666667e-3 * t1081 * t240 + 0.100e3 / 0.3e1 * t970 * t609 + 0.100e3 / 0.3e1 * t974 * t609 + 0.100e3 * t977 * t609 + 0.200e3 / 0.3e1 * t980 * t609 - 0.34133333333333333333333333333333333333333333333334e-3 * t436 * t413 - 0.21333333333333333333333333333333333333333333333334e-1 * t354 * t442 + t750 * t198 - 0.51199999999999999999999999999999999999999999999999e-4 * t553 * t755 + 0.32e-4 * t856 * t183 + 0.200e3 / 0.3e1 * t860 * t609 + 0.1600e4 / 0.9e1 * t863 * t609 + 0.1000e4 / 0.9e1 * t866 * t609 + 0.1000e4 / 0.9e1 * t870 * t609 + 0.2500e4 / 0.9e1 * t873 * t609 + 0.500e3 / 0.3e1 * t878 * t609 + t711 * t153 + 0.4e-2 * t657 * t89 + 0.21333333333333333333333333333333333333333333333332e0 * t598 * t587 + 0.69905066666666666666666666666666666666666666666671e-9 * t569 * t577 + 0.100e3 / 0.9e1 * t581 * t582 + 0.35555555555555555555555555555555555555555555555554e-1 * t585 * t587 + 0.27306666666666666666666666666666666666666666666668e-5 * t590 * t254 + 0.10666666666666666666666666666666666666666666666666e0 * t593 * t587
  t1190 = 0.3e1 / 0.8e1 * t6 * t567 * t1187
  t1191 = t17 * t19
  t1192 = t1177 * t123
  t1195 = t325 * t103
  t1196 = t122 * t1195
  t1197 = t125 ** 2
  t1201 = 0.1e1 / t330 / t110
  t1202 = 0.1e1 / t1197 / t229 * t1201
  t1205 = t580 * tau0
  t1206 = t25 * t1205
  t1207 = t126 * t54
  t1210 = t145 * t261
  t1211 = t363 * t148
  t1215 = 0.1e1 / t327 * t128
  t1222 = t1113 * t42
  t1225 = t239 * t48
  t1228 = t116 * t1205
  t1231 = t60 * t1205
  t1232 = t1231 * t126
  t1235 = t608 * t238
  t1238 = t35 * t941
  t1243 = t119 * t1205
  t1252 = t66 * t1205
  t1253 = t1252 * t126
  t1260 = 0.440e3 / 0.27e2 * t536 * t1222 - 0.800e3 / 0.9e1 * t806 * t1225 + 0.1000e4 / 0.9e1 * t1228 * t1207 + 0.1000e4 / 0.9e1 * t117 * t1232 - 0.800e3 / 0.9e1 * t809 * t1235 + 0.440e3 / 0.27e2 * t539 * t1238 - 0.800e3 / 0.9e1 * t814 * t1225 + 0.2000e4 / 0.9e1 * t1243 * t1207 + 0.2000e4 / 0.3e1 * t542 * t1232 - 0.3200e4 / 0.9e1 * t817 * t1235 + 0.880e3 / 0.27e2 * t543 * t1238 + 0.4000e4 / 0.9e1 * t120 * t1253 - 0.800e3 / 0.3e1 * t822 * t1235 + 0.880e3 / 0.27e2 * t546 * t1238
  t1261 = t1260 * t123
  t1264 = t50 * t1205
  t1269 = t196 * t597
  t1273 = 0.1e1 / t260 / t197
  t1274 = t220 * t1273
  t1277 = t294 * t123
  t1284 = t44 * t1205
  t1291 = t214 * t1205
  t1302 = t217 * t1205
  t1317 = 0.440e3 / 0.27e2 * t516 * t1222 - 0.800e3 / 0.9e1 * t1056 * t1225 + 0.1000e4 / 0.9e1 * t1291 * t1207 + 0.1000e4 / 0.9e1 * t215 * t1232 - 0.800e3 / 0.9e1 * t1059 * t1235 + 0.440e3 / 0.27e2 * t519 * t1238 - 0.800e3 / 0.9e1 * t1064 * t1225 + 0.2000e4 / 0.9e1 * t1302 * t1207 + 0.2000e4 / 0.3e1 * t522 * t1232 - 0.3200e4 / 0.9e1 * t1067 * t1235 + 0.880e3 / 0.27e2 * t523 * t1238 + 0.4000e4 / 0.9e1 * t218 * t1253 - 0.800e3 / 0.3e1 * t1072 * t1235 + 0.880e3 / 0.27e2 * t526 * t1238
  t1320 = t88 * t597
  t1321 = t148 * t34
  t1322 = t1320 * t1321
  t1326 = t765 * t1321
  t1329 = 0.40960000000000000000000000000000000000000000000002e-5 * t1192 * t253 + 0.74565404444444444444444444444444444444444444444451e-10 * t1196 * t1202 + 0.1000e4 / 0.9e1 * t1206 * t1207 + 0.28444444444444444444444444444444444444444444444442e-1 * t1210 * t1211 - 0.184320e-3 * t124 * t1215 + 0.55296e-4 * t550 * t789 - 0.6144e-5 * t828 * t253 + 0.256e-6 * t1261 * t129 + 0.1000e4 / 0.9e1 * t1264 * t1207 + 0.24181570370370370370370370370370370370370370370372e-3 * t533 * t1215 + 0.11377777777777777777777777777777777777777777777776e0 * t1269 * t1211 + 0.28444444444444444444444444444444444444444444444442e0 * t1274 * t1211 + 0.10922666666666666666666666666666666666666666666667e-4 * t1277 * t789 - 0.69176888888888888888888888888888888888888888888893e-4 * t792 * t1215 - 0.58709333333333333333333333333333333333333333333336e-4 * t795 * t789 + 0.2000e4 / 0.9e1 * t1284 * t1207 + t1317 * t222 + 0.45511111111111111111111111111111111111111111111108e-3 * t208 * t555 * t1322 + 0.11377777777777777777777777777777777777777777777777e-3 * t166 * t555 * t1326
  t1331 = 0.1e1 / t20 / t125
  t1332 = t1331 * t111
  t1333 = t1332 * t557
  t1337 = t128 * t222
  t1338 = t586 * t34
  t1339 = t1337 * t1338
  t1343 = 0.1e1 / t19 / t251
  t1345 = t111 * t261
  t1346 = t148 * t33
  t1347 = t1345 * t1346
  t1363 = t72 * t1205
  t1366 = t75 * t1205
  t1369 = t69 * t1205
  t1374 = t381 * t1205
  t1375 = t1374 * t126
  t1378 = t877 * t1205
  t1379 = t1378 * t126
  t1400 = t78 * t39
  t1403 = 0.2000e4 / 0.9e1 * t1363 * t1207 + 0.1000e4 / 0.9e1 * t1366 * t1207 + 0.1000e4 / 0.9e1 * t1369 * t1207 + 0.8000e4 / 0.3e1 * t642 * t1253 + 0.40000e5 / 0.9e1 * t287 * t1375 + 0.20000e5 / 0.9e1 * t79 * t1379 + 0.440e3 / 0.27e2 * t265 * t1222 - 0.800e3 / 0.9e1 * t615 * t1225 - 0.800e3 / 0.9e1 * t604 * t1225 + 0.1000e4 / 0.9e1 * t70 * t1232 + 0.2000e4 / 0.3e1 * t273 * t1232 + 0.4000e4 / 0.9e1 * t73 * t1253 + 0.1000e4 * t628 * t1232 + 0.2000e4 * t280 * t1253 + 0.10000e5 / 0.9e1 * t76 * t1375 + 0.4000e4 / 0.9e1 * t1400 * t1232
  t1436 = 0.880e3 / 0.27e2 * t277 * t1238 - 0.800e3 / 0.3e1 * t629 * t1235 + 0.1760e4 / 0.27e2 * t291 * t1238 - 0.800e3 * t632 * t1235 + 0.440e3 / 0.9e1 * t281 * t1238 - 0.1600e4 / 0.3e1 * t637 * t1235 + 0.440e3 / 0.9e1 * t284 * t1238 - 0.1600e4 / 0.3e1 * t643 * t1235 - 0.12800e5 / 0.9e1 * t646 * t1235 + 0.1760e4 / 0.27e2 * t288 * t1238 - 0.8000e4 / 0.9e1 * t651 * t1235 - 0.800e3 / 0.9e1 * t607 * t1235 + 0.440e3 / 0.27e2 * t269 * t1238 - 0.3200e4 / 0.9e1 * t618 * t1235 + 0.880e3 / 0.27e2 * t274 * t1238 - 0.800e3 / 0.3e1 * t623 * t1235
  t1437 = t1403 + t1436
  t1438 = t1437 * s0
  t1441 = t827 * t325
  t1449 = 0.1e1 / t19 / t125
  t1450 = t1449 * t111
  t1451 = t1450 * t198
  t1466 = 0.53665185185185185185185185185185185185185185185185e-3 * t553 * t1333 + 0.14563555555555555555555555555555555555555555555556e-6 * t250 * t329 * t1339 + 0.91022222222222222222222222222222222222222222222218e-6 * t180 * t1343 * t1347 - 0.15360000000000000000000000000000000000000000000000e-3 * t777 * t755 - 0.35271111111111111111111111111111111111111111111111e-3 * t770 * t1333 - 0.34133333333333333333333333333333333333333333333331e-2 * t166 * t238 * t774 - 0.10240000000000000000000000000000000000000000000000e-1 * t208 * t238 * t767 + 0.25599999999999999999999999999999999999999999999999e-2 * t353 * t108 * t767 + 0.4e-2 * t1438 * t89 + 0.24576000000000000000000000000000000000000000000001e-7 * t1441 * t333 + 0.2200e4 / 0.27e2 * t382 * t1238 + 0.11733333333333333333333333333333333333333333333334e0 * t354 * t943 + 0.64663703703703703703703703703703703703703703703706e-2 * t358 * t1451 - 0.1600e4 / 0.3e1 * t860 * t1235 - 0.12800e5 / 0.9e1 * t863 * t1235 - 0.8000e4 / 0.9e1 * t866 * t1235 - 0.8000e4 / 0.9e1 * t870 * t1235 - 0.20000e5 / 0.9e1 * t873 * t1235 - 0.4000e4 / 0.3e1 * t878 * t1235
  t1467 = t1329 + t1466
  t1469 = 0.1760e4 / 0.27e2 * t373 * t1238
  t1471 = 0.51200000000000000000000000000000000000000000000001e-3 * t856 * t413
  t1472 = t93 * t1205
  t1475 = t96 * t1205
  t1478 = t99 * t1205
  t1497 = 0.1000e4 / 0.9e1 * t1472 * t1207 + 0.2000e4 / 0.9e1 * t1475 * t1207 + 0.1000e4 / 0.9e1 * t1478 * t1207 + 0.440e3 / 0.27e2 * t301 * t1222 - 0.800e3 / 0.9e1 * t1150 * t1225 - 0.800e3 / 0.3e1 * t1158 * t1235 + 0.880e3 / 0.27e2 * t311 * t1238 - 0.800e3 / 0.3e1 * t1164 * t1235 - 0.800e3 * t1167 * t1235 + 0.440e3 / 0.9e1 * t315 * t1238 - 0.1600e4 / 0.3e1 * t1172 * t1235
  t1522 = 0.440e3 / 0.9e1 * t318 * t1238 - 0.800e3 / 0.9e1 * t1145 * t1235 + 0.440e3 / 0.27e2 * t304 * t1238 - 0.3200e4 / 0.9e1 * t1153 * t1235 + 0.880e3 / 0.27e2 * t308 * t1238 + 0.2000e4 / 0.3e1 * t307 * t1232 + 0.4000e4 / 0.9e1 * t97 * t1253 + 0.1000e4 * t1163 * t1232 + 0.2000e4 * t314 * t1253 + 0.10000e5 / 0.9e1 * t100 * t1375 - 0.800e3 / 0.9e1 * t1142 * t1225 + 0.1000e4 / 0.9e1 * t94 * t1232
  t1523 = t1497 + t1522
  t1524 = t1523 * t103
  t1526 = 0.32e-4 * t1524 * t112
  t1527 = t1081 * t1118
  t1530 = 0.51200000000000000000000000000000000000000000000001e-3 * t1178 * t240
  t1532 = 0.32000000000000000000000000000000000000000000000001e-1 * t657 * t233
  t1533 = t406 * t123
  t1535 = 0.10922666666666666666666666666666666666666666666667e-4 * t1533 * t1099
  t1536 = t656 * t103
  t1538 = 0.25600000000000000000000000000000000000000000000001e-3 * t1536 * t240
  t1539 = t1077 * t261
  t1541 = 0.12000000000000000000000000000000000000000000000000e1 * t1539 * t247
  t1542 = t514 * t261
  t1544 = 0.31999999999999999999999999999999999999999999999998e0 * t1542 * t587
  t1545 = t529 * t597
  t1547 = 0.63999999999999999999999999999999999999999999999997e0 * t1545 * t587
  t1548 = t919 * t34
  t1550 = 0.13653333333333333333333333333333333333333333333334e-3 * t1548 * t761
  t1551 = t1332 * t760
  t1553 = 0.70542222222222222222222222222222222222222222222224e-3 * t759 * t1551
  t1554 = t855 * t34
  t1556 = 0.12800000000000000000000000000000000000000000000000e-4 * t1554 * t558
  t1559 = t149 * t34
  t1560 = t111 * t198 * t1559
  t1562 = 0.68266666666666666666666666666666666666666666666665e-4 * t881 * t753 * t1560
  t1565 = 0.85333333333333333333333333333333333333333333333326e-3 * t407 * t108 * t774
  t1567 = 0.1e1 / t19 / t327
  t1570 = t33 * t149
  t1571 = t128 * t198 * t1570
  t1573 = 0.85560888888888888888888888888888888888888888888892e-5 * t250 * t1567 * t1571
  t1576 = 0.10922666666666666666666666666666666666666666666667e-5 * t590 * t783 * t1571
  t1579 = 0.14563555555555555555555555555555555555555555555556e-5 * t1127 * t1567 * t1571
  t1580 = t1469 - t1471 + t1526 - 0.23040000000000000000000000000000000000000000000000e-2 * t1527 - t1530 - t1532 + t1535 + t1538 + t1541 + t1544 + t1547 + t1550 - t1553 + t1556 + t1562 + t1565 - t1573 + t1576 + t1579
  t1582 = t1337 * t1570
  t1607 = 0.440e3 / 0.27e2 * t386 * t1222 - 0.800e3 / 0.9e1 * t1008 * t1225 - 0.800e3 / 0.9e1 * t1000 * t1225 + 0.1000e4 / 0.9e1 * t157 * t1232 + 0.2000e4 / 0.3e1 * t392 * t1232 + 0.4000e4 / 0.9e1 * t160 * t1253 + 0.1000e4 * t1021 * t1232 + 0.2000e4 * t399 * t1253 + 0.10000e5 / 0.9e1 * t163 * t1375 + 0.440e3 / 0.9e1 * t403 * t1238 - 0.3200e4 / 0.9e1 * t1011 * t1235
  t1626 = t156 * t1205
  t1629 = t159 * t1205
  t1632 = t162 * t1205
  t1635 = 0.880e3 / 0.27e2 * t393 * t1238 - 0.800e3 / 0.3e1 * t1016 * t1235 + 0.880e3 / 0.27e2 * t396 * t1238 - 0.800e3 / 0.3e1 * t1022 * t1235 - 0.800e3 * t1025 * t1235 + 0.440e3 / 0.9e1 * t400 * t1238 - 0.1600e4 / 0.3e1 * t1030 * t1235 - 0.800e3 / 0.9e1 * t1003 * t1235 + 0.440e3 / 0.27e2 * t389 * t1238 + 0.1000e4 / 0.9e1 * t1626 * t1207 + 0.2000e4 / 0.9e1 * t1629 * t1207 + 0.1000e4 / 0.9e1 * t1632 * t1207
  t1636 = t1607 + t1635
  t1637 = t1636 * s0
  t1638 = t1637 * t34
  t1641 = t854 * t123
  t1644 = t352 * t123
  t1647 = t321 * t325
  t1650 = t102 * t568
  t1652 = 0.1e1 / t19 / t1197
  t1654 = t1652 * t575 * t33
  t1661 = t1215 * t153
  t1664 = t1215 * t198
  t1670 = t33 * t1449 * t111
  t1673 = t750 * t222
  t1676 = t549 * t568
  t1679 = t492 * t222
  t1682 = t711 * t198
  t1691 = 0.29127111111111111111111111111111111111111111111112e-5 * t1130 * t1567 * t1582 + 0.4e-2 * t1638 * t169 + 0.40960000000000000000000000000000000000000000000002e-5 * t1641 * t254 + 0.10922666666666666666666666666666666666666666666667e-4 * t1644 * t1131 + 0.13107200000000000000000000000000000000000000000001e-6 * t1647 * t1107 + 0.37282702222222222222222222222222222222222222222226e-8 * t1650 * t1654 - 0.800e3 / 0.9e1 * t1137 * t1225 + 0.11733333333333333333333333333333333333333333333334e0 * t295 * t1114 - 0.69176888888888888888888888888888888888888888888893e-4 * t1127 * t1661 - 0.69176888888888888888888888888888888888888888888893e-4 * t1130 * t1664 + 0.32426666666666666666666666666666666666666666666667e-2 * t322 * t1118 + 0.64663703703703703703703703703703703703703703703706e-2 * t298 * t1670 + 0.79999999999999999999999999999999999999999999999998e0 * t1673 * t247 + 0.20971520000000000000000000000000000000000000000002e-8 * t1676 * t577 + 0.10666666666666666666666666666666666666666666666666e0 * t1679 * t587 + 0.39999999999999999999999999999999999999999999999999e0 * t1682 * t247 + 0.4000e4 / 0.9e1 * t46 * t1253 + 0.1000e4 * t973 * t1232 + 0.2000e4 * t458 * t1253
  t1696 = t56 * t39
  t1705 = t62 * t45
  t1712 = t59 ** 2
  t1713 = 0.1e1 / t1712
  t1714 = t1713 * t1205
  t1721 = 0.1e1 / t19 / t229 * t33 * t149
  t1726 = t81 * t325
  t1727 = t125 * t106
  t1729 = 0.1e1 / t20 / t1727
  t1731 = t1729 * t331 * t34
  t1745 = 0.1e1 / t20 / t106
  t1746 = t34 * t1745
  t1747 = t1746 * t88
  t1752 = 0.10000e5 / 0.9e1 * t52 * t1375 + 0.4000e4 / 0.9e1 * t1696 * t1232 + 0.8000e4 / 0.3e1 * t859 * t1253 + 0.40000e5 / 0.9e1 * t369 * t1375 + 0.20000e5 / 0.9e1 * t58 * t1379 + 0.10000e5 / 0.9e1 * t1705 * t1253 + 0.50000e5 / 0.9e1 * t869 * t1375 + 0.25000e5 / 0.3e1 * t376 * t1379 + 0.35000e5 / 0.9e1 * t64 * t1714 * t126 + 0.82962962962962962962962962962962962962962962962962e0 * t257 * t1721 - 0.79265185185185185185185185185185185185185185185186e-2 * t104 * t1670 + 0.11650844444444444444444444444444444444444444444445e-6 * t1726 * t1731 + 0.1000e4 / 0.9e1 * t40 * t1232 + 0.2000e4 / 0.3e1 * t451 * t1232 + 0.12444444444444444444444444444444444444444444444444e1 * t262 * t1721 + 0.26305422222222222222222222222222222222222222222223e-5 * t326 * t1731 + 0.440e3 / 0.27e2 * t336 * t1222 - 0.18251851851851851851851851851851851851851851851852e0 * t82 * t1747 - 0.53333333333333333333333333333333333333333333333332e0 * t1090 * t1096
  t1754 = 0.41481481481481481481481481481481481481481481481480e0 * t243 * t1721
  t1756 = 0.24181570370370370370370370370370370370370370370372e-3 * t250 * t1661
  t1758 = 0.10666666666666666666666666666666666666666666666666e1 * t1087 * t1096
  t1760 = 0.15999999999999999999999999999999999999999999999999e1 * t1084 * t1096
  t1762 = 0.58709333333333333333333333333333333333333333333336e-4 * t590 * t1099
  t1763 = t232 * t586
  t1765 = 0.42666666666666666666666666666666666666666666666665e0 * t593 * t1763
  t1767 = 0.85333333333333333333333333333333333333333333333328e0 * t598 * t1763
  t1769 = 0.48332800000000000000000000000000000000000000000002e-6 * t1181 * t1107
  t1771 = 0.24466773333333333333333333333333333333333333333335e-7 * t569 * t1654
  t1773 = 0.800e3 / 0.9e1 * t581 * t1225
  t1775 = 0.14222222222222222222222222222222222222222222222222e0 * t585 * t1763
  t1777 = 0.11796480000000000000000000000000000000000000000001e-5 * t1134 * t1731
  t1780 = 0.63999999999999999999999999999999999999999999999999e-2 * t915 * t363 * t366
  t1781 = t920 * t988
  t1784 = 0.880e3 / 0.27e2 * t455 * t1238
  t1785 = t165 * t325
  t1788 = 0.11650844444444444444444444444444444444444444444445e-6 * t1785 * t1729 * t960
  t1789 = t207 * t325
  t1791 = t331 * t198
  t1792 = t1791 * t34
  t1794 = 0.11650844444444444444444444444444444444444444444445e-6 * t1789 * t1729 * t1792
  t1797 = 0.11796480000000000000000000000000000000000000000001e-5 * t954 * t1729 * t960
  t1798 = t434 * t325
  t1801 = 0.13107200000000000000000000000000000000000000000001e-6 * t1798 * t957 * t960
  t1802 = t1754 + t1756 - t1758 - t1760 - t1762 - t1765 - t1767 - t1769 - t1771 - t1773 - t1775 - t1777 + t1780 - 0.23040000000000000000000000000000000000000000000000e-2 * t1781 + t1784 + t1788 + t1794 - t1797 + t1801
  t1809 = t179 * t568
  t1812 = t575 * t153 * t33
  t1815 = t125 * t236
  t1816 = 0.1e1 / t1815
  t1818 = t1791 * t149
  t1821 = 0.1e1 / t236
  t1829 = t1745 * t88
  t1830 = t1829 * t198
  t1839 = t1450 * t153
  t1847 = t1829 * t153
  t1855 = t1345 * t586
  t1861 = 0.2200e4 / 0.27e2 * t377 * t1238 + 0.68266666666666666666666666666666666666666666666664e-5 * t435 * t126 * t948 + 0.37282702222222222222222222222222222222222222222226e-8 * t1809 * t1652 * t1812 + 0.34952533333333333333333333333333333333333333333335e-7 * t954 * t1816 * t1818 + 0.91970370370370370370370370370370370370370370370369e-1 * t208 * t1821 * t366 - 0.32000000000000000000000000000000000000000000000001e-1 * t1037 * t445 - 0.23040000000000000000000000000000000000000000000000e-2 * t882 * t937 - 0.18251851851851851851851851851851851851851851851852e0 * t209 * t1830 + 0.440e3 / 0.9e1 * t459 * t1238 + 0.440e3 / 0.9e1 * t462 * t1238 + 0.1760e4 / 0.27e2 * t370 * t1238 - 0.79265185185185185185185185185185185185185185185186e-2 * t181 * t1839 - 0.45511111111111111111111111111111111111111111111109e-4 * t180 * t252 * t948 + 0.32426666666666666666666666666666666666666666666667e-2 * t436 * t937 - 0.18251851851851851851851851851851851851851851851852e0 * t167 * t1847 + 0.440e3 / 0.27e2 * t448 * t1238 + 0.880e3 / 0.27e2 * t452 * t1238 + 0.54613333333333333333333333333333333333333333333333e-4 * t357 * t252 * t1855 + 0.18204444444444444444444444444444444444444444444444e-4 * t411 * t252 * t948
  t1894 = t201 * t1205
  t1905 = t204 * t1205
  t1920 = 0.440e3 / 0.27e2 * t339 * t1222 - 0.800e3 / 0.9e1 * t893 * t1225 + 0.1000e4 / 0.9e1 * t1894 * t1207 + 0.1000e4 / 0.9e1 * t202 * t1232 - 0.800e3 / 0.9e1 * t896 * t1235 + 0.440e3 / 0.27e2 * t342 * t1238 - 0.800e3 / 0.9e1 * t901 * t1225 + 0.2000e4 / 0.9e1 * t1905 * t1207 + 0.2000e4 / 0.3e1 * t345 * t1232 - 0.3200e4 / 0.9e1 * t904 * t1235 + 0.880e3 / 0.27e2 * t346 * t1238 + 0.4000e4 / 0.9e1 * t205 * t1253 - 0.800e3 / 0.3e1 * t909 * t1235 + 0.880e3 / 0.27e2 * t349 * t1238
  t1921 = t1920 * s0
  t1922 = t1921 * t34
  t1931 = t173 * t1205
  t1942 = t176 * t1205
  t1957 = 0.440e3 / 0.27e2 * t421 * t1222 - 0.800e3 / 0.9e1 * t833 * t1225 + 0.1000e4 / 0.9e1 * t1931 * t1207 + 0.1000e4 / 0.9e1 * t174 * t1232 - 0.800e3 / 0.9e1 * t836 * t1235 + 0.440e3 / 0.27e2 * t424 * t1238 - 0.800e3 / 0.9e1 * t841 * t1225 + 0.2000e4 / 0.9e1 * t1942 * t1207 + 0.2000e4 / 0.3e1 * t427 * t1232 - 0.3200e4 / 0.9e1 * t844 * t1235 + 0.880e3 / 0.27e2 * t428 * t1238 + 0.4000e4 / 0.9e1 * t177 * t1253 - 0.800e3 / 0.3e1 * t849 * t1235 + 0.880e3 / 0.27e2 * t431 * t1238
  t1958 = t1957 * t103
  t1959 = t1958 * t33
  t1962 = t1035 * t103
  t1963 = t1962 * t33
  t1966 = t914 * t103
  t1967 = t1966 * t33
  t1992 = -0.800e3 / 0.9e1 * t723 * t1225 + 0.440e3 / 0.27e2 * t494 * t1222 - 0.800e3 * t740 * t1235 + 0.440e3 / 0.9e1 * t508 * t1238 - 0.1600e4 / 0.3e1 * t745 * t1235 + 0.440e3 / 0.9e1 * t511 * t1238 - 0.800e3 / 0.9e1 * t718 * t1235 + 0.440e3 / 0.27e2 * t497 * t1238 - 0.3200e4 / 0.9e1 * t726 * t1235 + 0.880e3 / 0.27e2 * t501 * t1238 - 0.800e3 / 0.3e1 * t731 * t1235
  t2011 = t187 * t1205
  t2014 = t190 * t1205
  t2017 = t193 * t1205
  t2020 = 0.880e3 / 0.27e2 * t504 * t1238 - 0.800e3 / 0.3e1 * t737 * t1235 - 0.800e3 / 0.9e1 * t715 * t1225 + 0.1000e4 / 0.9e1 * t188 * t1232 + 0.2000e4 / 0.3e1 * t500 * t1232 + 0.4000e4 / 0.9e1 * t191 * t1253 + 0.1000e4 * t736 * t1232 + 0.2000e4 * t507 * t1253 + 0.10000e5 / 0.9e1 * t194 * t1375 + 0.1000e4 / 0.9e1 * t2011 * t1207 + 0.2000e4 / 0.9e1 * t2014 * t1207 + 0.1000e4 / 0.9e1 * t2017 * t1207
  t2021 = t1992 + t2020
  t2023 = t133 * t1205
  t2026 = t136 * t1205
  t2029 = t139 * t1205
  t2058 = 0.1000e4 / 0.9e1 * t2023 * t1207 + 0.2000e4 / 0.9e1 * t2026 * t1207 + 0.1000e4 / 0.9e1 * t2029 * t1207 + 0.440e3 / 0.9e1 * t482 * t1238 - 0.1600e4 / 0.3e1 * t698 * t1235 - 0.12800e5 / 0.9e1 * t701 * t1235 + 0.1760e4 / 0.27e2 * t486 * t1238 - 0.8000e4 / 0.9e1 * t706 * t1235 + 0.1760e4 / 0.27e2 * t489 * t1238 - 0.3200e4 / 0.9e1 * t673 * t1235 + 0.880e3 / 0.27e2 * t472 * t1238 - 0.800e3 / 0.3e1 * t678 * t1235 + 0.880e3 / 0.27e2 * t475 * t1238 - 0.800e3 / 0.3e1 * t684 * t1235 - 0.800e3 * t687 * t1235 - 0.1600e4 / 0.3e1 * t692 * t1235
  t2071 = t142 * t39
  t2092 = 0.440e3 / 0.9e1 * t479 * t1238 - 0.800e3 / 0.9e1 * t665 * t1235 + 0.440e3 / 0.27e2 * t468 * t1238 + 0.440e3 / 0.27e2 * t465 * t1222 - 0.800e3 / 0.9e1 * t670 * t1225 + 0.10000e5 / 0.9e1 * t140 * t1375 + 0.4000e4 / 0.9e1 * t2071 * t1232 + 0.8000e4 / 0.3e1 * t697 * t1253 + 0.40000e5 / 0.9e1 * t485 * t1375 + 0.20000e5 / 0.9e1 * t143 * t1379 - 0.800e3 / 0.9e1 * t662 * t1225 + 0.1000e4 / 0.9e1 * t134 * t1232 + 0.2000e4 / 0.3e1 * t471 * t1232 + 0.4000e4 / 0.9e1 * t137 * t1253 + 0.1000e4 * t683 * t1232 + 0.2000e4 * t478 * t1253
  t2093 = t2058 + t2092
  t2095 = 0.31999999999999999999999999999999999999999999999998e-2 * t1036 * t363 * t418 - 0.800e3 / 0.9e1 * t1051 * t1235 - 0.21333333333333333333333333333333333333333333333333e-1 * t407 * t1040 * t418 - 0.3200e4 / 0.9e1 * t967 * t1235 - 0.800e3 / 0.3e1 * t970 * t1235 - 0.800e3 / 0.3e1 * t974 * t1235 - 0.800e3 * t977 * t1235 - 0.1600e4 / 0.3e1 * t980 * t1235 + 0.11733333333333333333333333333333333333333333333334e0 * t408 * t991 + 0.64663703703703703703703703703703703703703703703706e-2 * t412 * t1839 + 0.45985185185185185185185185185185185185185185185184e-1 * t166 * t1821 * t418 - 0.42666666666666666666666666666666666666666666666666e-1 * t353 * t1040 * t366 + 0.4e-2 * t1922 * t210 - 0.32000000000000000000000000000000000000000000000001e-1 * t916 * t442 + 0.32e-4 * t1959 * t183 + 0.25600000000000000000000000000000000000000000000001e-3 * t1963 * t413 + 0.25600000000000000000000000000000000000000000000001e-3 * t1967 * t360 + t2021 * t198 + t2093 * t153
  t2096 = t1861 + t2095
  t2098 = t1467 + t1580 + t1691 + t1752 + t1802 + t2096
  t2103 = f.my_piecewise3(t2, 0, -t227 + t565 - t1190 - 0.3e1 / 0.8e1 * t6 * t1191 * t2098)
  t2106 = t1469 - t1471 + t1526 - 0.23040000000000000000000000000000000000000000000001e-2 * t1527 - t1530 - t1532 + t1535 + t1538 + t1541 + t1544 + t1547 + t1550 - t1553 + t1556 + t1562 + t1565 - t1573 + t1576 + t1579
  t2110 = t1754 + t1756 - t1758 - t1760 - t1762 - t1765 - t1767 - t1769 - t1771 - t1773 - t1775 - t1777 + t1780 - 0.23040000000000000000000000000000000000000000000001e-2 * t1781 + t1784 + t1788 + t1794 - t1797 + t1801
  t2113 = t1467 + t2106 + t1691 + t1752 + t2110 + t2096
  t2118 = f.my_piecewise3(t2, 0, -t227 + t565 - t1190 - 0.3e1 / 0.8e1 * t6 * t1191 * t2113)
  t2137 = t128 * t261
  t2162 = t148 * t149
  t2179 = t331 * t222
  t2189 = 0.23301688888888888888888888888888888888888888888890e-5 * t1130 * t957 * t2137 * t1338 + 0.21466074074074074074074074074074074074074074074074e-2 * t777 * t1333 + 0.45511111111111111111111111111111111111111111111107e-3 * t407 * t555 * t1326 - 0.34224355555555555555555555555555555555555555555556e-4 * t590 * t1567 * t1571 - 0.49516088888888888888888888888888888888888888888889e-5 * t250 * t957 * t1339 + 0.27306666666666666666666666666666666666666666666668e-3 * t1966 * t34 * t761 + 0.38836148148148148148148148148148148148148148148147e-4 * t357 * t783 * t111 * t597 * t1346 + 0.60681481481481481481481481481481481481481481481476e-3 * t208 * t126 * t88 * t1273 * t2162 - 0.21238518518518518518518518518518518518518518518517e-2 * t166 * t753 * t1326 - 0.40959999999999999999999999999999999999999999999999e-1 * t353 * t238 * t767 - 0.84954074074074074074074074074074074074074074074071e-2 * t208 * t753 * t1322 + 0.51199999999999999999999999999999999999999999999998e-2 * t915 * t108 * t767 + 0.18641351111111111111111111111111111111111111111112e-7 * t954 * t573 * t2179 * t766 + 0.36408888888888888888888888888888888888888888888887e-5 * t435 * t1343 * t1347 + 0.58254222222222222222222222222222222222222222222222e-6 * t590 * t329 * t1339
  t2201 = t580 ** 2
  t2203 = 0.1e1 / t20 / t781
  t2205 = t2201 * t2203 * t34
  t2229 = 0.1e1 / t19 / t105 * t33 * t149
  t2241 = 0.77672296296296296296296296296296296296296296296296e-6 * t1127 * t957 * t1339 + 0.11650844444444444444444444444444444444444444444445e-4 * t1644 * t1567 * t1582 - 0.73007407407407407407407407407407407407407407407411e0 * t295 * t1747 + 0.1400000e7 / 0.27e2 * t64 / t1712 / t41 * t2205 + 0.200000e6 / 0.9e1 * t458 * t381 * t2205 + 0.100000e6 / 0.9e1 * t52 * t877 * t2205 - 0.42666666666666666666666666666666666666666666666668e-1 * t1922 * t442 + 0.34133333333333333333333333333333333333333333333335e-3 * t1437 * t103 * t240 + 0.32768000000000000000000000000000000000000000000001e-7 * t1260 * t325 * t333 + 0.23466666666666666666666666666666666666666666666668e0 * t657 * t1114 + 0.16592592592592592592592592592592592592592592592592e1 * t1090 * t1721 - 0.13827160493827160493827160493827160493827160493827e1 * t243 * t2229 + 0.41943040000000000000000000000000000000000000000004e-8 * t827 * t568 * t577 + 0.54613333333333333333333333333333333333333333333336e-5 * t1957 * t123 * t254 + 0.21845333333333333333333333333333333333333333333334e-4 * t914 * t123 * t1131
  t2270 = t1197 * r0
  t2272 = 0.1e1 / t19 / t2270
  t2274 = t2272 * t575 * t33
  t2277 = t1117 * t48
  t2282 = t34 * t2203 * t60
  t2290 = 0.26214400000000000000000000000000000000000000000002e-6 * t1177 * t325 * t1107 + 0.53333333333333333333333333333333333333333333333332e0 * t2093 * t198 * t247 + 0.21333333333333333333333333333333333333333333333332e0 * t711 * t222 * t587 + 0.25865481481481481481481481481481481481481481481483e-1 * t1081 * t1670 + 0.16000000000000000000000000000000000000000000000000e1 * t1317 * t261 * t247 + 0.12800000000000000000000000000000000000000000000000e1 * t1077 * t597 * t587 + 0.21845333333333333333333333333333333333333333333334e-4 * t1035 * t123 * t1099 - 0.46080000000000000000000000000000000000000000000002e-2 * t1536 * t1118 + 0.14913080888888888888888888888888888888888888888891e-7 * t321 * t568 * t1654 + 0.10522168888888888888888888888888888888888888888889e-4 * t1181 * t1731 + 0.62409690074074074074074074074074074074074074074078e-6 * t569 * t2274 + 0.54400e5 / 0.81e2 * t581 * t2277 + 0.20000e5 / 0.9e1 * t50 * t2201 * t2282 + 0.20000e5 / 0.27e2 * t56 * t2201 * t2282 + 0.33185185185185185185185185185185185185185185185183e1 * t1087 * t1721
  t2291 = t1113 * t586
  t2311 = 0.1e1 / t20 / t1815
  t2313 = t2311 * t331 * t34
  t2328 = 0.18962962962962962962962962962962962962962962962962e1 * t593 * t2291 + 0.46603377777777777777777777777777777777777777777780e-6 * t294 * t325 * t1731 + 0.63999999999999999999999999999999999999999999999996e0 * t750 * t261 * t587 - 0.27670755555555555555555555555555555555555555555556e-3 * t1533 * t1661 - 0.27670755555555555555555555555555555555555555555557e-3 * t1644 * t1664 + 0.64853333333333333333333333333333333333333333333334e-2 * t1178 * t1118 - 0.47185920000000000000000000000000000000000000000004e-5 * t1647 * t1731 - 0.16155837629629629629629629629629629629629629629631e-6 * t1650 * t2274 + 0.23859958518518518518518518518518518518518518518520e-4 * t1134 * t2313 + 0.54400e5 / 0.81e2 * t1137 * t2277 - 0.34133333333333333333333333333333333333333333333331e1 * t1545 * t1763 - 0.11741866666666666666666666666666666666666666666667e-3 * t1641 * t1099 - 0.96665600000000000000000000000000000000000000000004e-6 * t1441 * t1107 - 0.97867093333333333333333333333333333333333333333341e-7 * t1676 * t1654 - 0.56888888888888888888888888888888888888888888888887e0 * t1679 * t1763
  t2337 = 0.1e1 / t1197 / t105 * t1201
  t2352 = t252 * t54
  t2355 = t1040 * t148
  t2374 = t33 * t1343 * t111
  t2379 = t1231 * t252
  t2382 = 0.10666666666666666666666666666666666666666666666666e1 * t2021 * t222 * t247 + 0.39768215703703703703703703703703703703703703703709e-9 * t179 * t1195 * t2337 * t153 + 0.21845333333333333333333333333333333333333333333334e-4 * t656 * t123 * t789 + 0.45511111111111111111111111111111111111111111111105e0 * t514 * t597 * t1211 + 0.11377777777777777777777777777777777777777777777777e1 * t529 * t1273 * t1211 - 0.40265318400000000000000000000000000000000000000004e-8 * t1196 * t2337 - 0.16000e5 / 0.9e1 * t1206 * t2352 - 0.22755555555555555555555555555555555555555555555554e0 * t1210 * t2355 + 0.29826161777777777777777777777777777777777777777781e-9 * t549 * t1195 * t1202 + 0.11377777777777777777777777777777777777777777777777e0 * t492 * t261 * t1211 + 0.39768215703703703703703703703703703703703703703709e-9 * t102 * t1195 * t2337 + 0.48545185185185185185185185185185185185185185185182e-6 * t180 * t2203 * t111 * t597 * t148 * t1559 + 0.66054320987654320987654320987654320987654320987655e-1 * t104 * t2374 - 0.38059425185185185185185185185185185185185185185188e-5 * t1726 * t2313 - 0.16000e5 / 0.9e1 * t40 * t2379
  t2389 = t1374 * t252
  t2392 = t1378 * t252
  t2400 = t1252 * t252
  t2417 = -0.32000e5 / 0.3e1 * t451 * t2379 - 0.41481481481481481481481481481481481481481481481480e1 * t262 * t2229 - 0.41848983703703703703703703703703703703703703703705e-4 * t326 * t2313 - 0.800000e6 / 0.9e1 * t869 * t2389 - 0.400000e6 / 0.3e1 * t376 * t2392 - 0.560000e6 / 0.9e1 * t64 * t1714 * t252 - 0.27654320987654320987654320987654320987654320987654e1 * t257 * t2229 - 0.32000e5 * t458 * t2400 - 0.160000e6 / 0.9e1 * t52 * t2389 - 0.64000e5 / 0.9e1 * t1696 * t2379 - 0.128000e6 / 0.3e1 * t859 * t2400 - 0.640000e6 / 0.9e1 * t369 * t2389 - 0.320000e6 / 0.9e1 * t58 * t2392 - 0.160000e6 / 0.9e1 * t1705 * t2400 - 0.10666666666666666666666666666666666666666666666666e1 * t1682 * t1096
  t2430 = 0.1e1 / t955 * t128
  t2431 = t2430 * t153
  t2452 = t608 * t935
  t2455 = t35 * t1745
  t2478 = 0.108800e6 / 0.27e2 * t637 * t2452 - 0.6160e4 / 0.27e2 * t284 * t2455 + 0.108800e6 / 0.27e2 * t643 * t2452 - 0.24640e5 / 0.81e2 * t288 * t2455 - 0.12320e5 / 0.81e2 * t274 * t2455 + 0.54400e5 / 0.27e2 * t623 * t2452 - 0.12320e5 / 0.81e2 * t277 * t2455 + 0.54400e5 / 0.27e2 * t629 * t2452 - 0.24640e5 / 0.81e2 * t291 * t2455 + 0.160000e6 / 0.27e2 * t273 * t66 * t2205 + 0.100000e6 / 0.27e2 * t73 * t381 * t2205
  t2511 = 0.20000e5 / 0.27e2 * t70 * t66 * t2205 + 0.217600e6 / 0.81e2 * t618 * t2452 + 0.870400e6 / 0.81e2 * t646 * t2452 + 0.544000e6 / 0.81e2 * t651 * t2452 + 0.40000e5 / 0.3e1 * t628 * t66 * t2205 + 0.200000e6 / 0.9e1 * t280 * t381 * t2205 + 0.100000e6 / 0.9e1 * t76 * t877 * t2205 + 0.320000e6 / 0.27e2 * t1400 * t66 * t2205 + 0.400000e6 / 0.9e1 * t642 * t381 * t2205 + 0.1600000e7 / 0.27e2 * t287 * t877 * t2205 + 0.700000e6 / 0.27e2 * t79 * t1713 * t2205 + 0.54400e5 / 0.81e2 * t607 * t2452
  t2537 = t1746 * t42
  t2540 = -0.6160e4 / 0.81e2 * t269 * t2455 + 0.54400e5 / 0.9e1 * t632 * t2452 - 0.6160e4 / 0.27e2 * t281 * t2455 + 0.20000e5 / 0.9e1 * t72 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t75 * t2201 * t2282 + 0.20000e5 / 0.27e2 * t78 * t2201 * t2282 + 0.54400e5 / 0.81e2 * t604 * t2277 + 0.20000e5 / 0.27e2 * t69 * t2201 * t2282 - 0.32000e5 / 0.3e1 * t273 * t2379 - 0.64000e5 / 0.9e1 * t73 * t2400 - 0.6160e4 / 0.81e2 * t265 * t2537
  t2565 = 0.54400e5 / 0.81e2 * t615 * t2277 - 0.16000e5 / 0.9e1 * t70 * t2379 - 0.16000e5 * t628 * t2379 - 0.32000e5 * t280 * t2400 - 0.160000e6 / 0.9e1 * t76 * t2389 - 0.64000e5 / 0.9e1 * t1400 * t2379 - 0.128000e6 / 0.3e1 * t642 * t2400 - 0.640000e6 / 0.9e1 * t287 * t2389 - 0.32000e5 / 0.9e1 * t1363 * t2352 - 0.16000e5 / 0.9e1 * t1369 * t2352 - 0.16000e5 / 0.9e1 * t1366 * t2352 - 0.320000e6 / 0.9e1 * t79 * t2392
  t2606 = -0.16000e5 / 0.9e1 * t1472 * t2352 - 0.32000e5 / 0.9e1 * t1475 * t2352 - 0.16000e5 / 0.9e1 * t1478 * t2352 - 0.32000e5 / 0.3e1 * t307 * t2379 - 0.64000e5 / 0.9e1 * t97 * t2400 - 0.16000e5 * t1163 * t2379 - 0.32000e5 * t314 * t2400 - 0.160000e6 / 0.9e1 * t100 * t2389 - 0.16000e5 / 0.9e1 * t94 * t2379 - 0.6160e4 / 0.81e2 * t301 * t2537 + 0.54400e5 / 0.81e2 * t1150 * t2277 + 0.20000e5 / 0.27e2 * t93 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t96 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t99 * t2201 * t2282 + 0.54400e5 / 0.81e2 * t1142 * t2277 - 0.6160e4 / 0.81e2 * t304 * t2455
  t2645 = -0.12320e5 / 0.81e2 * t308 * t2455 + 0.40000e5 / 0.3e1 * t1163 * t66 * t2205 + 0.200000e6 / 0.9e1 * t314 * t381 * t2205 + 0.100000e6 / 0.9e1 * t100 * t877 * t2205 + 0.20000e5 / 0.27e2 * t94 * t66 * t2205 + 0.160000e6 / 0.27e2 * t307 * t66 * t2205 + 0.100000e6 / 0.27e2 * t97 * t381 * t2205 + 0.217600e6 / 0.81e2 * t1153 * t2452 + 0.54400e5 / 0.27e2 * t1158 * t2452 - 0.12320e5 / 0.81e2 * t311 * t2455 + 0.54400e5 / 0.27e2 * t1164 * t2452 + 0.54400e5 / 0.9e1 * t1167 * t2452 - 0.6160e4 / 0.27e2 * t315 * t2455 + 0.108800e6 / 0.27e2 * t1172 * t2452 - 0.6160e4 / 0.27e2 * t318 * t2455 + 0.54400e5 / 0.81e2 * t1145 * t2452
  t2652 = -0.64000e5 / 0.9e1 * t46 * t2400 - 0.16000e5 * t973 * t2379 - 0.21333333333333333333333333333333333333333333333332e1 * t1673 * t1096 - 0.31706074074074074074074074074074074074074074074075e-1 * t322 * t1670 - 0.57780148148148148148148148148148148148148148148150e-1 * t298 * t2374 + 0.10368442469135802469135802469135802469135802469136e-2 * t1127 * t2431 + 0.10368442469135802469135802469135802469135802469136e-2 * t1130 * t2430 * t198 - 0.68266666666666666666666666666666666666666666666668e-3 * t1959 * t413 + 0.18394074074074074074074074074074074074074074074073e0 * t407 * t1821 * t418 + 0.72817777777777777777777777777777777777777777777774e-4 * t881 * t252 * t948 - 0.12743111111111111111111111111111111111111111111111e-2 * t357 * t788 * t1855 + 0.46603377777777777777777777777777777777777777777780e-6 * t406 * t325 * t1729 * t960 + 0.4e-2 * (t2478 + t2511 + t2540 + t2565) * s0 * t89 + 0.32e-4 * (t2606 + t2645) * t103 * t112 - 0.68266666666666666666666666666666666666666666666668e-3 * t1524 * t240
  t2698 = t575 * t198
  t2702 = 0.46603377777777777777777777777777777777777777777780e-6 * t352 * t325 * t1729 * t1792 + 0.26214400000000000000000000000000000000000000000002e-6 * t854 * t325 * t957 * t960 + 0.20000e5 / 0.27e2 * t40 * t66 * t2205 + 0.100000e6 / 0.27e2 * t62 * t39 * t66 * t2205 + 0.1000000e7 / 0.27e2 * t1705 * t381 * t2205 - 0.47185920000000000000000000000000000000000000000004e-5 * t1798 * t1729 * t960 + 0.23859958518518518518518518518518518518518518518520e-4 * t954 * t2311 * t960 + 0.21845333333333333333333333333333333333333333333334e-5 * t1641 * t33 * t785 - 0.42666666666666666666666666666666666666666666666668e-1 * t1638 * t445 - 0.46080000000000000000000000000000000000000000000001e-2 * t1963 * t937 - 0.73007407407407407407407407407407407407407407407411e0 * t354 * t1830 + 0.34133333333333333333333333333333333333333333333335e-3 * t1920 * t103 * t33 * t360 - 0.31706074074074074074074074074074074074074074074075e-1 * t436 * t1839 + 0.64853333333333333333333333333333333333333333333334e-2 * t856 * t937 - 0.73007407407407407407407407407407407407407407407411e0 * t408 * t1847 + 0.99420539259259259259259259259259259259259259259267e-8 * t207 * t568 * t2272 * t2698 * t33
  t2708 = t1346 * t149
  t2746 = -0.16000e5 / 0.9e1 * t157 * t2379 - 0.32000e5 / 0.3e1 * t392 * t2379 - 0.64000e5 / 0.9e1 * t160 * t2400 - 0.16000e5 * t1021 * t2379 - 0.32000e5 * t399 * t2400 - 0.160000e6 / 0.9e1 * t163 * t2389 - 0.6160e4 / 0.81e2 * t386 * t2537 + 0.54400e5 / 0.81e2 * t1008 * t2277 + 0.54400e5 / 0.81e2 * t1000 * t2277 + 0.20000e5 / 0.27e2 * t156 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t159 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t162 * t2201 * t2282 - 0.6160e4 / 0.27e2 * t400 * t2455 + 0.54400e5 / 0.81e2 * t1003 * t2452 - 0.6160e4 / 0.27e2 * t403 * t2455 + 0.217600e6 / 0.81e2 * t1011 * t2452
  t2785 = -0.12320e5 / 0.81e2 * t393 * t2455 + 0.20000e5 / 0.27e2 * t157 * t66 * t2205 + 0.160000e6 / 0.27e2 * t392 * t66 * t2205 + 0.100000e6 / 0.27e2 * t160 * t381 * t2205 + 0.40000e5 / 0.3e1 * t1021 * t66 * t2205 + 0.200000e6 / 0.9e1 * t399 * t381 * t2205 + 0.100000e6 / 0.9e1 * t163 * t877 * t2205 + 0.54400e5 / 0.9e1 * t1025 * t2452 + 0.108800e6 / 0.27e2 * t1030 * t2452 - 0.6160e4 / 0.81e2 * t389 * t2455 + 0.54400e5 / 0.27e2 * t1016 * t2452 - 0.12320e5 / 0.81e2 * t396 * t2455 + 0.54400e5 / 0.27e2 * t1022 * t2452 - 0.32000e5 / 0.9e1 * t1629 * t2352 - 0.16000e5 / 0.9e1 * t1626 * t2352 - 0.16000e5 / 0.9e1 * t1632 * t2352
  t2795 = t1343 * t111
  t2796 = t2795 * t153
  t2799 = 0.1e1 / t570
  t2859 = 0.217600e6 / 0.81e2 * t844 * t2452 - 0.12320e5 / 0.81e2 * t428 * t2455 + 0.54400e5 / 0.27e2 * t849 * t2452 - 0.12320e5 / 0.81e2 * t431 * t2455 + 0.54400e5 / 0.81e2 * t836 * t2452 - 0.6160e4 / 0.81e2 * t424 * t2455 - 0.16000e5 / 0.9e1 * t1931 * t2352 - 0.32000e5 / 0.9e1 * t1942 * t2352 + 0.54400e5 / 0.81e2 * t841 * t2277 - 0.32000e5 / 0.3e1 * t427 * t2379 + 0.160000e6 / 0.27e2 * t427 * t66 * t2205 - 0.64000e5 / 0.9e1 * t177 * t2400 + 0.100000e6 / 0.27e2 * t177 * t381 * t2205 - 0.6160e4 / 0.81e2 * t421 * t2537 - 0.16000e5 / 0.9e1 * t174 * t2379 + 0.20000e5 / 0.27e2 * t174 * t66 * t2205 + 0.20000e5 / 0.27e2 * t173 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t176 * t2201 * t2282 + 0.54400e5 / 0.81e2 * t833 * t2277
  t2873 = 0.15170370370370370370370370370370370370370370370369e-1 * t145 * t597 * t108 * t2708 + 0.4e-2 * (t2746 + t2785) * s0 * t34 * t169 + 0.34133333333333333333333333333333333333333333333335e-3 * t1636 * t103 * t33 * t413 - 0.57780148148148148148148148148148148148148148148150e-1 * t412 * t2796 - 0.32458271604938271604938271604938271604938271604937e0 * t166 * t2799 * t418 + 0.54400e5 / 0.81e2 * t1051 * t2452 + 0.42666666666666666666666666666666666666666666666664e-2 * t1637 * t363 * t418 + 0.544000e6 / 0.81e2 * t866 * t2452 + 0.13653333333333333333333333333333333333333333333333e-4 * t855 * t126 * t948 - 0.16155837629629629629629629629629629629629629629631e-6 * t1809 * t2272 * t1812 + 0.32e-4 * t2859 * t103 * t33 * t183 + 0.544000e6 / 0.81e2 * t870 * t2452 + 0.1360000e7 / 0.81e2 * t873 * t2452 + 0.272000e6 / 0.27e2 * t878 * t2452 + 0.13981013333333333333333333333333333333333333333334e-6 * t1798 * t1816 * t1818
  t2874 = 0.1e1 / t571
  t2900 = 0.1e1 / t20 / t251 * t111
  t2904 = t2900 * t557
  t2919 = 0.1e1 / t19 / t955
  t2926 = 0.12427567407407407407407407407407407407407407407408e-6 * t1785 * t2874 * t1818 + 0.24855134814814814814814814814814814814814814814816e-6 * t1789 * t2874 * t2179 * t149 + 0.69581432098765432098765432098765432098765432098763e-3 * t180 * t788 * t948 + 0.15534459259259259259259259259259259259259259259260e-6 * t250 / t1727 * t2137 * t148 - 0.13514979555555555555555555555555555555555555555556e-5 * t954 * t2874 * t1818 + 0.17066666666666666666666666666666666666666666666667e-4 * t1958 * t34 * t558 - 0.28216888888888888888888888888888888888888888888889e-2 * t1548 * t1551 + 0.88190419753086419753086419753086419753086419753088e-2 * t759 * t2900 * t760 + 0.44095209876543209876543209876543209876543209876543e-2 * t770 * t2904 + 0.33880493827160493827160493827160493827160493827158e-1 * t166 * t935 * t774 + 0.10164148148148148148148148148148148148148148148148e0 * t208 * t935 * t767 - 0.57078518518518518518518518518518518518518518518519e-2 * t553 * t2904 - 0.26699851851851851851851851851851851851851851851850e-4 * t180 * t783 * t1347 + 0.15210824691358024691358024691358024691358024691358e-3 * t250 * t2919 * t1571 - 0.40777955555555555555555555555555555555555555555556e-4 * t1127 * t2919 * t1571
  t3009 = 0.217600e6 / 0.81e2 * t817 * t2452 - 0.12320e5 / 0.81e2 * t543 * t2455 + 0.54400e5 / 0.27e2 * t822 * t2452 - 0.12320e5 / 0.81e2 * t546 * t2455 + 0.54400e5 / 0.81e2 * t809 * t2452 - 0.6160e4 / 0.81e2 * t539 * t2455 - 0.16000e5 / 0.9e1 * t1228 * t2352 - 0.32000e5 / 0.9e1 * t1243 * t2352 - 0.32000e5 / 0.3e1 * t542 * t2379 + 0.160000e6 / 0.27e2 * t542 * t66 * t2205 - 0.64000e5 / 0.9e1 * t120 * t2400 + 0.100000e6 / 0.27e2 * t120 * t381 * t2205 - 0.6160e4 / 0.81e2 * t536 * t2537 - 0.16000e5 / 0.9e1 * t117 * t2379 + 0.20000e5 / 0.27e2 * t117 * t66 * t2205 + 0.54400e5 / 0.81e2 * t814 * t2277 + 0.54400e5 / 0.81e2 * t806 * t2277 + 0.20000e5 / 0.27e2 * t116 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t119 * t2201 * t2282
  t3020 = -0.14108444444444444444444444444444444444444444444445e-2 * t881 * t1331 * t1560 - 0.13653333333333333333333333333333333333333333333332e-1 * t407 * t238 * t774 + 0.97090370370370370370370370370370370370370370370366e-5 * t411 * t783 * t1347 + 0.12136296296296296296296296296296296296296296296295e-3 * t166 * t126 * t1320 * t2162 + 0.18204444444444444444444444444444444444444444444443e-2 * t353 * t555 * t1322 + 0.13653333333333333333333333333333333333333333333333e-3 * t1962 * t753 * t1560 + 0.58254222222222222222222222222222222222222222222223e-5 * t1533 * t1567 * t1571 + 0.17066666666666666666666666666666666666666666666665e-2 * t1036 * t108 * t774 + 0.19884107851851851851851851851851851851851851851853e-8 * t1809 / t20 / t2270 * t2698 * t1559 - 0.30720000000000000000000000000000000000000000000000e-3 * t1554 * t755 - 0.81555911111111111111111111111111111111111111111115e-4 * t1130 * t33 * t2919 * t128 * t760 + 0.256e-6 * t3009 * t123 * t129 - 0.16000e5 / 0.9e1 * t1264 * t2352 + 0.54613333333333333333333333333333333333333333333336e-5 * t1523 * t123 * t253 - 0.27670755555555555555555555555555555555555555555557e-3 * t1277 * t1215
  t3057 = -0.11741866666666666666666666666666666666666666666667e-3 * t1192 * t789 + 0.2027520e-2 * t124 * t2430 - 0.91022222222222222222222222222222222222222222222210e0 * t1269 * t2355 - 0.22755555555555555555555555555555555555555555555554e1 * t1274 * t2355 + 0.96726281481481481481481481481481481481481481481486e-3 * t795 * t1215 + 0.10368442469135802469135802469135802469135802469136e-2 * t792 * t2430 - 0.29981708641975308641975308641975308641975308641977e-2 * t533 * t2430 - 0.32000e5 / 0.9e1 * t1284 * t2352 - 0.737280e-3 * t550 * t1215 + 0.110592e-3 * t828 * t789 - 0.8192e-5 * t1261 * t253 + 0.14913080888888888888888888888888888888888888888891e-7 * t434 * t568 * t1652 * t1812 - 0.38059425185185185185185185185185185185185185185188e-5 * t1785 * t2311 * t960 - 0.38059425185185185185185185185185185185185185185188e-5 * t1789 * t2311 * t1792 - 0.46080000000000000000000000000000000000000000000002e-2 * t1967 * t988 + 0.217600e6 / 0.81e2 * t967 * t2452
  t3096 = 0.54400e5 / 0.27e2 * t970 * t2452 + 0.54400e5 / 0.27e2 * t974 * t2452 + 0.54400e5 / 0.9e1 * t977 * t2452 + 0.108800e6 / 0.27e2 * t980 * t2452 + 0.108800e6 / 0.27e2 * t860 * t2452 + 0.870400e6 / 0.81e2 * t863 * t2452 + 0.85333333333333333333333333333333333333333333333332e-2 * t1921 * t363 * t366 + 0.1000000e7 / 0.9e1 * t869 * t877 * t2205 + 0.3500000e7 / 0.27e2 * t376 * t1713 * t2205 - 0.17066666666666666666666666666666666666666666666666e1 * t1542 * t1763 - 0.31999999999999999999999999999999999999999999999999e1 * t1539 * t1096 + 0.99420539259259259259259259259259259259259259259267e-8 * t81 * t568 * t2274 + 0.20000e5 / 0.27e2 * t25 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t44 * t2201 * t2282 + 0.49777777777777777777777777777777777777777777777775e1 * t1084 * t1721
  t3126 = t555 * t88
  t3132 = 0.37925925925925925925925925925925925925925925925924e1 * t598 * t2291 - 0.42666666666666666666666666666666666666666666666665e-1 * t1036 * t1040 * t418 + 0.36788148148148148148148148148148148148148148148148e0 * t353 * t1821 * t366 - 0.12320e5 / 0.81e2 * t455 * t2455 - 0.6160e4 / 0.27e2 * t459 * t2455 - 0.6160e4 / 0.27e2 * t462 * t2455 - 0.24640e5 / 0.81e2 * t370 * t2455 + 0.66054320987654320987654320987654320987654320987655e-1 * t181 * t2796 - 0.85333333333333333333333333333333333333333333333333e-1 * t915 * t1040 * t366 + 0.25865481481481481481481481481481481481481481481483e-1 * t920 * t1451 + 0.23466666666666666666666666666666666666666666666668e0 * t1037 * t991 - 0.6160e4 / 0.81e2 * t448 * t2455 - 0.12320e5 / 0.81e2 * t452 * t2455 + 0.10342716049382716049382716049382716049382716049383e1 * t167 * t3126 * t153 + 0.25865481481481481481481481481481481481481481481482e-1 * t882 * t1839
  t3185 = 0.10342716049382716049382716049382716049382716049383e1 * t209 * t3126 * t198 + 0.320000e6 / 0.27e2 * t1696 * t66 * t2205 + 0.400000e6 / 0.9e1 * t859 * t381 * t2205 + 0.1600000e7 / 0.27e2 * t369 * t877 * t2205 + 0.700000e6 / 0.27e2 * t58 * t1713 * t2205 + 0.160000e6 / 0.27e2 * t451 * t66 * t2205 + 0.100000e6 / 0.27e2 * t46 * t381 * t2205 + 0.40000e5 / 0.3e1 * t973 * t66 * t2205 - 0.57780148148148148148148148148148148148148148148150e-1 * t358 * t2795 * t198 - 0.64916543209876543209876543209876543209876543209875e0 * t208 * t2799 * t366 - 0.42666666666666666666666666666666666666666666666668e-1 * t1438 * t233 + 0.47721858844444444444444444444444444444444444444450e-11 * t122 * t325 * t123 / t20 / t1197 / t236 / t330 / t127 * t34 - 0.29981708641975308641975308641975308641975308641977e-2 * t250 * t2431 - 0.6160e4 / 0.81e2 * t336 * t2537 + 0.10342716049382716049382716049382716049382716049383e1 * t82 * t34 * t555 * t88
  t3233 = -0.6160e4 / 0.81e2 * t342 * t2455 + 0.217600e6 / 0.81e2 * t904 * t2452 - 0.12320e5 / 0.81e2 * t346 * t2455 + 0.54400e5 / 0.27e2 * t909 * t2452 - 0.12320e5 / 0.81e2 * t349 * t2455 + 0.54400e5 / 0.81e2 * t896 * t2452 - 0.16000e5 / 0.9e1 * t1894 * t2352 - 0.32000e5 / 0.9e1 * t1905 * t2352 + 0.20000e5 / 0.9e1 * t204 * t2201 * t2282 + 0.54400e5 / 0.81e2 * t893 * t2277 + 0.20000e5 / 0.27e2 * t201 * t2201 * t2282 - 0.32000e5 / 0.3e1 * t345 * t2379 + 0.160000e6 / 0.27e2 * t345 * t66 * t2205 - 0.64000e5 / 0.9e1 * t205 * t2400 + 0.100000e6 / 0.27e2 * t205 * t381 * t2205 - 0.6160e4 / 0.81e2 * t339 * t2537 - 0.16000e5 / 0.9e1 * t202 * t2379 + 0.20000e5 / 0.27e2 * t202 * t66 * t2205 + 0.54400e5 / 0.81e2 * t901 * t2277
  t3305 = 0.54400e5 / 0.81e2 * t723 * t2277 - 0.32000e5 / 0.9e1 * t2014 * t2352 - 0.16000e5 / 0.9e1 * t2011 * t2352 - 0.16000e5 / 0.9e1 * t2017 * t2352 - 0.12320e5 / 0.81e2 * t504 * t2455 + 0.54400e5 / 0.9e1 * t740 * t2452 - 0.6160e4 / 0.27e2 * t508 * t2455 + 0.108800e6 / 0.27e2 * t745 * t2452 - 0.6160e4 / 0.27e2 * t511 * t2455 + 0.54400e5 / 0.81e2 * t718 * t2452 - 0.6160e4 / 0.81e2 * t497 * t2455 + 0.217600e6 / 0.81e2 * t726 * t2452 + 0.100000e6 / 0.9e1 * t194 * t877 * t2205 + 0.20000e5 / 0.27e2 * t188 * t66 * t2205 + 0.160000e6 / 0.27e2 * t500 * t66 * t2205 + 0.100000e6 / 0.27e2 * t191 * t381 * t2205
  t3343 = 0.40000e5 / 0.3e1 * t736 * t66 * t2205 + 0.200000e6 / 0.9e1 * t507 * t381 * t2205 + 0.54400e5 / 0.27e2 * t737 * t2452 - 0.12320e5 / 0.81e2 * t501 * t2455 + 0.54400e5 / 0.27e2 * t731 * t2452 + 0.20000e5 / 0.9e1 * t193 * t2201 * t2282 + 0.54400e5 / 0.81e2 * t715 * t2277 - 0.16000e5 * t736 * t2379 - 0.32000e5 * t507 * t2400 - 0.160000e6 / 0.9e1 * t194 * t2389 - 0.16000e5 / 0.9e1 * t188 * t2379 - 0.32000e5 / 0.3e1 * t500 * t2379 - 0.64000e5 / 0.9e1 * t191 * t2400 + 0.20000e5 / 0.27e2 * t187 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t190 * t2201 * t2282 - 0.6160e4 / 0.81e2 * t494 * t2537
  t3371 = -0.6160e4 / 0.81e2 * t465 * t2537 + 0.54400e5 / 0.81e2 * t670 * t2277 - 0.160000e6 / 0.9e1 * t140 * t2389 - 0.64000e5 / 0.9e1 * t2071 * t2379 - 0.128000e6 / 0.3e1 * t697 * t2400 - 0.640000e6 / 0.9e1 * t485 * t2389 - 0.320000e6 / 0.9e1 * t143 * t2392 + 0.54400e5 / 0.81e2 * t662 * t2277 + 0.20000e5 / 0.27e2 * t142 * t2201 * t2282 + 0.20000e5 / 0.27e2 * t133 * t2201 * t2282 + 0.20000e5 / 0.9e1 * t136 * t2201 * t2282
  t3401 = 0.20000e5 / 0.9e1 * t139 * t2201 * t2282 - 0.16000e5 / 0.9e1 * t134 * t2379 - 0.32000e5 / 0.3e1 * t471 * t2379 - 0.64000e5 / 0.9e1 * t137 * t2400 - 0.16000e5 * t683 * t2379 - 0.32000e5 * t478 * t2400 + 0.160000e6 / 0.27e2 * t471 * t66 * t2205 + 0.100000e6 / 0.27e2 * t137 * t381 * t2205 + 0.40000e5 / 0.3e1 * t683 * t66 * t2205 + 0.54400e5 / 0.27e2 * t684 * t2452 + 0.54400e5 / 0.9e1 * t687 * t2452 + 0.200000e6 / 0.9e1 * t478 * t381 * t2205
  t3430 = 0.100000e6 / 0.9e1 * t140 * t877 * t2205 + 0.320000e6 / 0.27e2 * t2071 * t66 * t2205 + 0.400000e6 / 0.9e1 * t697 * t381 * t2205 + 0.1600000e7 / 0.27e2 * t485 * t877 * t2205 + 0.700000e6 / 0.27e2 * t143 * t1713 * t2205 + 0.217600e6 / 0.81e2 * t673 * t2452 - 0.12320e5 / 0.81e2 * t472 * t2455 + 0.54400e5 / 0.27e2 * t678 * t2452 - 0.12320e5 / 0.81e2 * t475 * t2455 + 0.108800e6 / 0.27e2 * t692 * t2452 - 0.6160e4 / 0.27e2 * t482 * t2455
  t3456 = 0.108800e6 / 0.27e2 * t698 * t2452 + 0.870400e6 / 0.81e2 * t701 * t2452 - 0.24640e5 / 0.81e2 * t486 * t2455 + 0.544000e6 / 0.81e2 * t706 * t2452 - 0.24640e5 / 0.81e2 * t489 * t2455 - 0.6160e4 / 0.27e2 * t479 * t2455 + 0.54400e5 / 0.81e2 * t665 * t2452 - 0.6160e4 / 0.81e2 * t468 * t2455 + 0.20000e5 / 0.27e2 * t134 * t66 * t2205 - 0.32000e5 / 0.9e1 * t2026 * t2352 - 0.16000e5 / 0.9e1 * t2023 * t2352 - 0.16000e5 / 0.9e1 * t2029 * t2352
  t3503 = -0.12320e5 / 0.81e2 * t523 * t2455 + 0.54400e5 / 0.27e2 * t1072 * t2452 - 0.12320e5 / 0.81e2 * t526 * t2455 + 0.54400e5 / 0.81e2 * t1059 * t2452 - 0.6160e4 / 0.81e2 * t519 * t2455 + 0.217600e6 / 0.81e2 * t1067 * t2452 - 0.16000e5 / 0.9e1 * t1291 * t2352 - 0.32000e5 / 0.9e1 * t1302 * t2352 + 0.20000e5 / 0.9e1 * t217 * t2201 * t2282 + 0.54400e5 / 0.81e2 * t1064 * t2277 - 0.32000e5 / 0.3e1 * t522 * t2379 + 0.160000e6 / 0.27e2 * t522 * t66 * t2205 - 0.64000e5 / 0.9e1 * t218 * t2400 + 0.100000e6 / 0.27e2 * t218 * t381 * t2205 - 0.6160e4 / 0.81e2 * t516 * t2537 - 0.16000e5 / 0.9e1 * t215 * t2379 + 0.20000e5 / 0.27e2 * t215 * t66 * t2205 + 0.54400e5 / 0.81e2 * t1056 * t2277 + 0.20000e5 / 0.27e2 * t214 * t2201 * t2282
  t3505 = 0.63209876543209876543209876543209876543209876543208e0 * t585 * t2291 + 0.96726281481481481481481481481481481481481481481486e-3 * t590 * t1661 + 0.4e-2 * t3233 * s0 * t34 * t210 - 0.30800e5 / 0.81e2 * t377 * t2455 - 0.30800e5 / 0.81e2 * t382 * t2455 - 0.24640e5 / 0.81e2 * t373 * t2455 + 0.21845333333333333333333333333333333333333333333333e-3 * t919 * t252 * t1855 - 0.18204444444444444444444444444444444444444444444444e-3 * t435 * t252 * t948 - 0.42477037037037037037037037037037037037037037037036e-3 * t411 * t788 * t948 + 0.99420539259259259259259259259259259259259259259267e-8 * t165 * t568 * t2272 * t1812 + 0.23466666666666666666666666666666666666666666666668e0 * t916 * t943 + 0.75851851851851851851851851851851851851851851851838e-1 * t196 * t1273 * t108 * t2708 + 0.22755555555555555555555555555555555555555555555553e0 * t220 / t260 / t221 * t108 * t2708 + (t3305 + t3343) * t198 + (t3371 + t3401 + t3430 + t3456) * t153 + t3503 * t222
  t3514 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t231 * t224 - 0.5e1 / 0.9e1 * t6 * t23 * t562 + t6 * t228 * t1187 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t567 * t2098 - t6 * t567 * t2113 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1191 * (t2189 + t2241 + t2290 + t2328 + t2382 + t2417 + t2652 + t2702 + t2873 + t2926 + t3020 + t3057 + t3096 + t3132 + t3185 + t3505))
  v4rho4_0_ = 0.2e1 * r0 * t3514 + 0.6e1 * t2103 + 0.2e1 * t2118

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = params.c[0]
  t33 = params.c[1]
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = 0.3e1 / 0.10e2 * t35 * t38
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t45 = tau0 / t42 / r0
  t46 = t40 - t45
  t47 = t33 * t46
  t48 = t40 + t45
  t49 = 0.1e1 / t48
  t51 = params.c[2]
  t52 = t46 ** 2
  t53 = t51 * t52
  t54 = t48 ** 2
  t55 = 0.1e1 / t54
  t57 = params.c[3]
  t58 = t52 * t46
  t59 = t57 * t58
  t60 = t54 * t48
  t61 = 0.1e1 / t60
  t63 = params.c[4]
  t64 = t52 ** 2
  t65 = t63 * t64
  t66 = t54 ** 2
  t67 = 0.1e1 / t66
  t69 = params.c[5]
  t71 = t69 * t64 * t46
  t73 = 0.1e1 / t66 / t48
  t75 = params.c[6]
  t76 = params.c[7]
  t77 = t76 * t46
  t79 = params.c[8]
  t80 = t79 * t52
  t82 = params.c[9]
  t83 = t82 * t58
  t85 = params.c[10]
  t86 = t85 * t64
  t88 = t77 * t49 + t80 * t55 + t83 * t61 + t86 * t67 + t75
  t89 = t88 * s0
  t90 = r0 ** 2
  t92 = 0.1e1 / t42 / t90
  t95 = 0.1e1 + 0.4e-2 * s0 * t92
  t96 = 0.1e1 / t95
  t97 = t92 * t96
  t100 = params.c[11]
  t101 = params.c[12]
  t102 = t101 * t46
  t104 = params.c[13]
  t105 = t104 * t52
  t107 = params.c[14]
  t108 = t107 * t58
  t110 = t102 * t49 + t105 * t55 + t108 * t61 + t100
  t111 = s0 ** 2
  t112 = t110 * t111
  t113 = t90 ** 2
  t116 = 0.1e1 / t41 / t113 / r0
  t117 = t95 ** 2
  t118 = 0.1e1 / t117
  t119 = t116 * t118
  t122 = params.c[15]
  t123 = params.c[16]
  t124 = t123 * t46
  t126 = params.c[17]
  t127 = t126 * t52
  t129 = t124 * t49 + t127 * t55 + t122
  t130 = t111 * s0
  t131 = t129 * t130
  t132 = t113 ** 2
  t135 = 0.1e1 / t117 / t95
  t136 = 0.1e1 / t132 * t135
  t139 = params.c[18]
  t140 = params.c[19]
  t141 = t140 * t46
  t143 = params.c[20]
  t144 = t143 * t52
  t146 = params.c[21]
  t147 = t146 * t58
  t149 = params.c[22]
  t150 = t149 * t64
  t152 = t141 * t49 + t144 * t55 + t147 * t61 + t150 * t67 + t139
  t154 = 2 ** (0.1e1 / 0.3e1)
  t155 = 0.1e1 / t30 * t154
  t157 = 0.1e1 + t17 <= f.p.zeta_threshold
  t159 = 0.1e1 - t17 <= f.p.zeta_threshold
  t160 = f.my_piecewise5(t157, t11, t159, t15, t17)
  t161 = 0.1e1 + t160
  t162 = 0.1e1 / t161
  t163 = t162 ** (0.1e1 / 0.3e1)
  t166 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 * t155 * t163
  t167 = 0.1e1 / t166
  t169 = params.c[23]
  t170 = params.c[24]
  t171 = t170 * t46
  t173 = params.c[25]
  t174 = t173 * t52
  t176 = params.c[26]
  t177 = t176 * t58
  t179 = t171 * t49 + t174 * t55 + t177 * t61 + t169
  t180 = t179 * s0
  t181 = t97 * t167
  t184 = params.c[27]
  t185 = params.c[28]
  t186 = t185 * t46
  t188 = params.c[29]
  t189 = t188 * t52
  t191 = t186 * t49 + t189 * t55 + t184
  t192 = t191 * t111
  t193 = t119 * t167
  t196 = params.c[30]
  t197 = params.c[31]
  t198 = t197 * t46
  t200 = params.c[32]
  t201 = t200 * t52
  t203 = params.c[33]
  t204 = t203 * t58
  t206 = t198 * t49 + t201 * t55 + t204 * t61 + t196
  t207 = t166 ** 2
  t208 = 0.1e1 / t207
  t210 = params.c[34]
  t211 = params.c[35]
  t212 = t211 * t46
  t214 = params.c[36]
  t215 = t214 * t52
  t217 = t212 * t49 + t215 * t55 + t210
  t218 = t217 * s0
  t219 = t97 * t208
  t222 = params.c[37]
  t223 = params.c[38]
  t224 = t223 * t46
  t226 = params.c[39]
  t227 = t226 * t52
  t229 = t224 * t49 + t227 * t55 + t222
  t231 = 0.1e1 / t207 / t166
  t233 = t32 + t47 * t49 + t53 * t55 + t59 * t61 + t65 * t67 + t71 * t73 + 0.4e-2 * t89 * t97 + 0.16e-4 * t112 * t119 + 0.64e-7 * t131 * t136 + t152 * t167 + 0.4e-2 * t180 * t181 + 0.16e-4 * t192 * t193 + t206 * t208 + 0.4e-2 * t218 * t219 + t229 * t231
  t237 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t238 = t237 * f.p.zeta_threshold
  t240 = f.my_piecewise3(t20, t238, t21 * t19)
  t241 = t30 ** 2
  t242 = 0.1e1 / t241
  t243 = t240 * t242
  t246 = t5 * t243 * t233 / 0.8e1
  t247 = t240 * t30
  t248 = t180 * t92
  t249 = t96 * t208
  t252 = 0.1e1 / t30 / t6 * t154
  t254 = 0.13333333333333333333333333333333333333333333333333e0 * t252 * t163
  t255 = t163 ** 2
  t256 = 0.1e1 / t255
  t257 = t161 ** 2
  t259 = t256 / t257
  t260 = f.my_piecewise5(t157, 0, t159, 0, t25)
  t261 = t259 * t260
  t264 = -t254 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t261
  t265 = t249 * t264
  t268 = t192 * t116
  t269 = t118 * t208
  t270 = t269 * t264
  t273 = t218 * t92
  t274 = t96 * t231
  t275 = t274 * t264
  t278 = t90 * r0
  t280 = 0.1e1 / t42 / t278
  t281 = t280 * t96
  t286 = 0.1e1 / t41 / t113 / t90
  t287 = t286 * t118
  t291 = 0.1e1 / t132 / r0
  t292 = t291 * t135
  t295 = t33 * tau0
  t296 = t92 * t49
  t299 = t76 * tau0
  t302 = t55 * tau0
  t303 = t302 * t92
  t306 = t79 * t46
  t309 = t61 * tau0
  t310 = t309 * t92
  t313 = t82 * t52
  t316 = t67 * tau0
  t317 = t316 * t92
  t320 = t85 * t58
  t323 = t73 * tau0
  t324 = t323 * t92
  t327 = 0.5e1 / 0.3e1 * t299 * t296 + 0.5e1 / 0.3e1 * t77 * t303 + 0.10e2 / 0.3e1 * t306 * t303 + 0.10e2 / 0.3e1 * t80 * t310 + 0.5e1 * t313 * t310 + 0.5e1 * t83 * t317 + 0.20e2 / 0.3e1 * t320 * t317 + 0.20e2 / 0.3e1 * t86 * t324
  t328 = t327 * s0
  t331 = t88 * t111
  t334 = t101 * tau0
  t339 = t104 * t46
  t344 = t107 * t52
  t349 = 0.5e1 / 0.3e1 * t334 * t296 + 0.5e1 / 0.3e1 * t102 * t303 + 0.10e2 / 0.3e1 * t339 * t303 + 0.10e2 / 0.3e1 * t105 * t310 + 0.5e1 * t344 * t310 + 0.5e1 * t108 * t317
  t350 = t349 * t111
  t353 = t110 * t130
  t356 = t123 * tau0
  t361 = t126 * t46
  t366 = 0.5e1 / 0.3e1 * t356 * t296 + 0.5e1 / 0.3e1 * t124 * t303 + 0.10e2 / 0.3e1 * t361 * t303 + 0.10e2 / 0.3e1 * t127 * t310
  t367 = t366 * t130
  t370 = t111 ** 2
  t371 = t129 * t370
  t375 = t117 ** 2
  t376 = 0.1e1 / t375
  t377 = 0.1e1 / t42 / t132 / t278 * t376
  t380 = t207 ** 2
  t381 = 0.1e1 / t380
  t382 = t229 * t381
  t385 = t152 * t208
  t387 = t206 * t231
  t390 = t170 * tau0
  t395 = t173 * t46
  t400 = t176 * t52
  t405 = 0.5e1 / 0.3e1 * t390 * t296 + 0.5e1 / 0.3e1 * t171 * t303 + 0.10e2 / 0.3e1 * t395 * t303 + 0.10e2 / 0.3e1 * t174 * t310 + 0.5e1 * t400 * t310 + 0.5e1 * t177 * t317
  t406 = t405 * s0
  t409 = t179 * t111
  t410 = t287 * t167
  t413 = -0.4e-2 * t248 * t265 - 0.16e-4 * t268 * t270 - 0.8e-2 * t273 * t275 - 0.10666666666666666666666666666666666666666666666667e-1 * t89 * t281 - 0.85333333333333333333333333333333333333333333333333e-4 * t112 * t287 - 0.512e-6 * t131 * t292 + 0.5e1 / 0.3e1 * t295 * t296 + 0.4e-2 * t328 * t97 + 0.42666666666666666666666666666666666666666666666668e-4 * t331 * t287 + 0.16e-4 * t350 * t119 + 0.34133333333333333333333333333333333333333333333334e-6 * t353 * t292 + 0.64e-7 * t367 * t136 + 0.20480000000000000000000000000000000000000000000001e-8 * t371 * t377 - 0.3e1 * t382 * t264 - t385 * t264 - 0.2e1 * t387 * t264 + 0.4e-2 * t406 * t181 + 0.42666666666666666666666666666666666666666666666668e-4 * t409 * t410
  t414 = t185 * tau0
  t419 = t188 * t46
  t424 = 0.5e1 / 0.3e1 * t414 * t296 + 0.5e1 / 0.3e1 * t186 * t303 + 0.10e2 / 0.3e1 * t419 * t303 + 0.10e2 / 0.3e1 * t189 * t310
  t425 = t424 * t111
  t428 = t191 * t130
  t429 = t292 * t167
  t434 = t51 * t46
  t439 = t57 * t52
  t444 = t63 * t58
  t449 = t69 * t64
  t453 = 0.1e1 / t66 / t54
  t454 = t453 * tau0
  t458 = t281 * t167
  t463 = t281 * t208
  t466 = t211 * tau0
  t471 = t214 * t46
  t476 = 0.5e1 / 0.3e1 * t466 * t296 + 0.5e1 / 0.3e1 * t212 * t303 + 0.10e2 / 0.3e1 * t471 * t303 + 0.10e2 / 0.3e1 * t215 * t310
  t477 = t476 * s0
  t480 = t217 * t111
  t481 = t287 * t208
  t484 = t140 * tau0
  t489 = t143 * t46
  t494 = t146 * t52
  t499 = t149 * t58
  t504 = 0.5e1 / 0.3e1 * t484 * t296 + 0.5e1 / 0.3e1 * t141 * t303 + 0.10e2 / 0.3e1 * t489 * t303 + 0.10e2 / 0.3e1 * t144 * t310 + 0.5e1 * t494 * t310 + 0.5e1 * t147 * t317 + 0.20e2 / 0.3e1 * t499 * t317 + 0.20e2 / 0.3e1 * t150 * t324
  t506 = t197 * tau0
  t511 = t200 * t46
  t516 = t203 * t52
  t521 = 0.5e1 / 0.3e1 * t506 * t296 + 0.5e1 / 0.3e1 * t198 * t303 + 0.10e2 / 0.3e1 * t511 * t303 + 0.10e2 / 0.3e1 * t201 * t310 + 0.5e1 * t516 * t310 + 0.5e1 * t204 * t317
  t523 = t223 * tau0
  t528 = t226 * t46
  t533 = 0.5e1 / 0.3e1 * t523 * t296 + 0.5e1 / 0.3e1 * t224 * t303 + 0.10e2 / 0.3e1 * t528 * t303 + 0.10e2 / 0.3e1 * t227 * t310
  t535 = 0.16e-4 * t425 * t193 + 0.34133333333333333333333333333333333333333333333334e-6 * t428 * t429 + 0.5e1 / 0.3e1 * t47 * t303 + 0.10e2 / 0.3e1 * t434 * t303 + 0.10e2 / 0.3e1 * t53 * t310 + 0.5e1 * t439 * t310 + 0.5e1 * t59 * t317 + 0.20e2 / 0.3e1 * t444 * t317 + 0.20e2 / 0.3e1 * t65 * t324 + 0.25e2 / 0.3e1 * t449 * t324 + 0.25e2 / 0.3e1 * t71 * t454 * t92 - 0.10666666666666666666666666666666666666666666666667e-1 * t180 * t458 - 0.85333333333333333333333333333333333333333333333333e-4 * t192 * t410 - 0.10666666666666666666666666666666666666666666666667e-1 * t218 * t463 + 0.4e-2 * t477 * t219 + 0.42666666666666666666666666666666666666666666666668e-4 * t480 * t481 + t504 * t167 + t521 * t208 + t533 * t231
  t536 = t413 + t535
  t541 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t233 - t246 - 0.3e1 / 0.8e1 * t5 * t247 * t536)
  t543 = r1 <= f.p.dens_threshold
  t544 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t545 = 0.1e1 + t544
  t546 = t545 <= f.p.zeta_threshold
  t547 = t545 ** (0.1e1 / 0.3e1)
  t548 = -t25
  t549 = f.my_piecewise5(t14, 0, t10, 0, t548)
  t552 = f.my_piecewise3(t546, 0, 0.4e1 / 0.3e1 * t547 * t549)
  t553 = t552 * t30
  t554 = r1 ** (0.1e1 / 0.3e1)
  t555 = t554 ** 2
  t558 = tau1 / t555 / r1
  t559 = t40 - t558
  t560 = t33 * t559
  t561 = t40 + t558
  t562 = 0.1e1 / t561
  t564 = t559 ** 2
  t565 = t51 * t564
  t566 = t561 ** 2
  t567 = 0.1e1 / t566
  t569 = t564 * t559
  t570 = t57 * t569
  t571 = t566 * t561
  t572 = 0.1e1 / t571
  t574 = t564 ** 2
  t575 = t63 * t574
  t576 = t566 ** 2
  t577 = 0.1e1 / t576
  t580 = t69 * t574 * t559
  t582 = 0.1e1 / t576 / t561
  t584 = t76 * t559
  t586 = t79 * t564
  t588 = t82 * t569
  t590 = t85 * t574
  t592 = t584 * t562 + t586 * t567 + t588 * t572 + t590 * t577 + t75
  t593 = t592 * s2
  t594 = r1 ** 2
  t596 = 0.1e1 / t555 / t594
  t599 = 0.1e1 + 0.4e-2 * s2 * t596
  t600 = 0.1e1 / t599
  t601 = t596 * t600
  t604 = t101 * t559
  t606 = t104 * t564
  t608 = t107 * t569
  t610 = t604 * t562 + t606 * t567 + t608 * t572 + t100
  t611 = s2 ** 2
  t612 = t610 * t611
  t613 = t594 ** 2
  t616 = 0.1e1 / t554 / t613 / r1
  t617 = t599 ** 2
  t618 = 0.1e1 / t617
  t619 = t616 * t618
  t622 = t123 * t559
  t624 = t126 * t564
  t626 = t622 * t562 + t624 * t567 + t122
  t627 = t611 * s2
  t628 = t626 * t627
  t629 = t613 ** 2
  t632 = 0.1e1 / t617 / t599
  t633 = 0.1e1 / t629 * t632
  t636 = t140 * t559
  t638 = t143 * t564
  t640 = t146 * t569
  t642 = t149 * t574
  t644 = t636 * t562 + t638 * t567 + t640 * t572 + t642 * t577 + t139
  t645 = f.my_piecewise5(t159, t11, t157, t15, -t17)
  t646 = 0.1e1 + t645
  t647 = 0.1e1 / t646
  t648 = t647 ** (0.1e1 / 0.3e1)
  t651 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 * t155 * t648
  t652 = 0.1e1 / t651
  t654 = t170 * t559
  t656 = t173 * t564
  t658 = t176 * t569
  t660 = t654 * t562 + t656 * t567 + t658 * t572 + t169
  t661 = t660 * s2
  t662 = t601 * t652
  t665 = t185 * t559
  t667 = t188 * t564
  t669 = t665 * t562 + t667 * t567 + t184
  t670 = t669 * t611
  t671 = t619 * t652
  t674 = t197 * t559
  t676 = t200 * t564
  t678 = t203 * t569
  t680 = t674 * t562 + t676 * t567 + t678 * t572 + t196
  t681 = t651 ** 2
  t682 = 0.1e1 / t681
  t684 = t211 * t559
  t686 = t214 * t564
  t688 = t684 * t562 + t686 * t567 + t210
  t689 = t688 * s2
  t690 = t601 * t682
  t693 = t223 * t559
  t695 = t226 * t564
  t697 = t693 * t562 + t695 * t567 + t222
  t699 = 0.1e1 / t681 / t651
  t701 = t32 + t560 * t562 + t565 * t567 + t570 * t572 + t575 * t577 + t580 * t582 + 0.4e-2 * t593 * t601 + 0.16e-4 * t612 * t619 + 0.64e-7 * t628 * t633 + t644 * t652 + 0.4e-2 * t661 * t662 + 0.16e-4 * t670 * t671 + t680 * t682 + 0.4e-2 * t689 * t690 + t697 * t699
  t706 = f.my_piecewise3(t546, t238, t547 * t545)
  t707 = t706 * t242
  t710 = t5 * t707 * t701 / 0.8e1
  t711 = t706 * t30
  t712 = t644 * t682
  t714 = 0.13333333333333333333333333333333333333333333333333e0 * t252 * t648
  t715 = t648 ** 2
  t716 = 0.1e1 / t715
  t717 = t646 ** 2
  t719 = t716 / t717
  t720 = f.my_piecewise5(t159, 0, t157, 0, t548)
  t721 = t719 * t720
  t724 = -t714 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t721
  t726 = t661 * t596
  t727 = t600 * t682
  t728 = t727 * t724
  t731 = t670 * t616
  t732 = t618 * t682
  t733 = t732 * t724
  t736 = t680 * t699
  t739 = t689 * t596
  t740 = t600 * t699
  t741 = t740 * t724
  t744 = t681 ** 2
  t745 = 0.1e1 / t744
  t746 = t697 * t745
  t749 = -t712 * t724 - 0.4e-2 * t726 * t728 - 0.16e-4 * t731 * t733 - 0.2e1 * t736 * t724 - 0.8e-2 * t739 * t741 - 0.3e1 * t746 * t724
  t754 = f.my_piecewise3(t543, 0, -0.3e1 / 0.8e1 * t5 * t553 * t701 - t710 - 0.3e1 / 0.8e1 * t5 * t711 * t749)
  t756 = t21 ** 2
  t757 = 0.1e1 / t756
  t758 = t26 ** 2
  t763 = t16 / t22 / t6
  t765 = -0.2e1 * t23 + 0.2e1 * t763
  t766 = f.my_piecewise5(t10, 0, t14, 0, t765)
  t770 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t757 * t758 + 0.4e1 / 0.3e1 * t21 * t766)
  t777 = t5 * t29 * t242 * t233
  t783 = 0.1e1 / t241 / t6
  t787 = t5 * t240 * t783 * t233 / 0.12e2
  t789 = t5 * t243 * t536
  t795 = 0.1e1 / t132 / t90 * t135
  t800 = t113 * t278
  t803 = 0.1e1 / t41 / t800 * t118
  t806 = tau0 ** 2
  t808 = t116 * t55
  t821 = 0.1e1 / t42 / t132 / t113 * t376
  t824 = t280 * t49
  t831 = t61 * t806 * t116
  t834 = t302 * t280
  t845 = t67 * t806 * t116
  t848 = t309 * t280
  t897 = t73 * t806 * t116
  t900 = t316 * t280
  t911 = t453 * t806 * t116
  t914 = t323 * t280
  t917 = -0.40e2 / 0.9e1 * t299 * t824 + 0.50e2 / 0.9e1 * t76 * t806 * t808 + 0.50e2 / 0.9e1 * t77 * t831 - 0.40e2 / 0.9e1 * t77 * t834 + 0.50e2 / 0.9e1 * t79 * t806 * t808 + 0.200e3 / 0.9e1 * t306 * t831 - 0.80e2 / 0.9e1 * t306 * t834 + 0.50e2 / 0.3e1 * t80 * t845 - 0.80e2 / 0.9e1 * t80 * t848 + 0.50e2 / 0.3e1 * t82 * t46 * t831 + 0.50e2 * t313 * t845 - 0.40e2 / 0.3e1 * t313 * t848 + 0.100e3 / 0.3e1 * t83 * t897 - 0.40e2 / 0.3e1 * t83 * t900 + 0.100e3 / 0.3e1 * t85 * t52 * t845 + 0.800e3 / 0.9e1 * t320 * t897 - 0.160e3 / 0.9e1 * t320 * t900 + 0.500e3 / 0.9e1 * t86 * t911 - 0.160e3 / 0.9e1 * t86 * t914
  t958 = -0.40e2 / 0.9e1 * t334 * t824 + 0.50e2 / 0.9e1 * t101 * t806 * t808 + 0.50e2 / 0.9e1 * t102 * t831 - 0.40e2 / 0.9e1 * t102 * t834 + 0.50e2 / 0.9e1 * t104 * t806 * t808 + 0.200e3 / 0.9e1 * t339 * t831 - 0.80e2 / 0.9e1 * t339 * t834 + 0.50e2 / 0.3e1 * t105 * t845 - 0.80e2 / 0.9e1 * t105 * t848 + 0.50e2 / 0.3e1 * t107 * t46 * t831 + 0.50e2 * t344 * t845 - 0.40e2 / 0.3e1 * t344 * t848 + 0.100e3 / 0.3e1 * t108 * t897 - 0.40e2 / 0.3e1 * t108 * t900
  t970 = 0.1e1 / t42 / t113 * t96
  t977 = 0.87381333333333333333333333333333333333333333333340e-10 * t129 * t370 * s0 / t41 / t132 / t800 / t375 / t95 + 0.4e-2 * t917 * s0 * t97 + 0.85333333333333333333333333333333333333333333333336e-4 * t327 * t111 * t287 + 0.91022222222222222222222222222222222222222222222228e-6 * t88 * t130 * t795 + 0.16e-4 * t958 * t111 * t119 + 0.54044444444444444444444444444444444444444444444444e-3 * t112 * t803 + 0.4608e-5 * t131 * t795 - 0.40e2 / 0.9e1 * t295 * t824 + 0.39111111111111111111111111111111111111111111111112e-1 * t89 * t970 - 0.1024e-5 * t367 * t292 - 0.40277333333333333333333333333333333333333333333336e-7 * t371 * t821
  t979 = t425 * t116
  t982 = t428 * t291
  t983 = t135 * t208
  t987 = t180 * t280
  t990 = t192 * t286
  t993 = t218 * t280
  t996 = t477 * t92
  t999 = t480 * t286
  t1000 = t118 * t231
  t1006 = 0.1e1 / t30 / t22 * t154
  t1008 = 0.17777777777777777777777777777777777777777777777777e0 * t1006 * t163
  t1009 = t252 * t261
  t1012 = 0.1e1 / t255 / t162
  t1013 = t257 ** 2
  t1014 = 0.1e1 / t1013
  t1015 = t1012 * t1014
  t1016 = t260 ** 2
  t1021 = 0.1e1 / t257 / t161
  t1022 = t256 * t1021
  t1026 = f.my_piecewise5(t157, 0, t159, 0, t765)
  t1030 = t1008 + 0.88888888888888888888888888888888888888888888888886e-1 * t1009 - 0.88888888888888888888888888888888888888888888888887e-1 * t155 * t1015 * t1016 + 0.26666666666666666666666666666666666666666666666666e0 * t155 * t1022 * t1016 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t259 * t1026
  t1040 = t406 * t92
  t1043 = -0.32e-4 * t979 * t270 - 0.68266666666666666666666666666666666666666666666668e-6 * t982 * t983 * t264 + 0.21333333333333333333333333333333333333333333333334e-1 * t987 * t265 + 0.17066666666666666666666666666666666666666666666667e-3 * t990 * t270 + 0.42666666666666666666666666666666666666666666666667e-1 * t993 * t275 - 0.16e-1 * t996 * t275 - 0.17066666666666666666666666666666666666666666666667e-3 * t999 * t1000 * t264 - 0.8e-2 * t273 * t274 * t1030 - 0.4e-2 * t248 * t249 * t1030 - 0.16e-4 * t268 * t269 * t1030 - 0.8e-2 * t1040 * t265
  t1044 = t409 * t286
  t1047 = t264 ** 2
  t1054 = t96 * t381
  t1100 = -0.40e2 / 0.9e1 * t484 * t824 + 0.50e2 / 0.9e1 * t140 * t806 * t808 + 0.50e2 / 0.9e1 * t141 * t831 - 0.40e2 / 0.9e1 * t141 * t834 + 0.50e2 / 0.9e1 * t143 * t806 * t808 + 0.200e3 / 0.9e1 * t489 * t831 - 0.80e2 / 0.9e1 * t489 * t834 + 0.50e2 / 0.3e1 * t144 * t845 - 0.80e2 / 0.9e1 * t144 * t848 + 0.50e2 / 0.3e1 * t146 * t46 * t831 + 0.50e2 * t494 * t845 - 0.40e2 / 0.3e1 * t494 * t848 + 0.100e3 / 0.3e1 * t147 * t897 - 0.40e2 / 0.3e1 * t147 * t900 + 0.100e3 / 0.3e1 * t149 * t52 * t845 + 0.800e3 / 0.9e1 * t499 * t897 - 0.160e3 / 0.9e1 * t499 * t900 + 0.500e3 / 0.9e1 * t150 * t911 - 0.160e3 / 0.9e1 * t150 * t914
  t1155 = -0.40e2 / 0.9e1 * t506 * t824 + 0.50e2 / 0.9e1 * t197 * t806 * t808 + 0.50e2 / 0.9e1 * t198 * t831 - 0.40e2 / 0.9e1 * t198 * t834 + 0.50e2 / 0.9e1 * t200 * t806 * t808 + 0.200e3 / 0.9e1 * t511 * t831 - 0.80e2 / 0.9e1 * t511 * t834 + 0.50e2 / 0.3e1 * t201 * t845 - 0.80e2 / 0.9e1 * t201 * t848 + 0.50e2 / 0.3e1 * t203 * t46 * t831 + 0.50e2 * t516 * t845 - 0.40e2 / 0.3e1 * t516 * t848 + 0.100e3 / 0.3e1 * t204 * t897 - 0.40e2 / 0.3e1 * t204 * t900
  t1166 = -0.85333333333333333333333333333333333333333333333336e-4 * t1044 * t270 + 0.8e-2 * t248 * t274 * t1047 + 0.32e-4 * t268 * t1000 * t1047 + 0.24e-1 * t273 * t1054 * t1047 + t1100 * t167 + (-0.40e2 / 0.9e1 * t523 * t824 + 0.50e2 / 0.9e1 * t223 * t806 * t808 + 0.50e2 / 0.9e1 * t224 * t831 - 0.40e2 / 0.9e1 * t224 * t834 + 0.50e2 / 0.9e1 * t226 * t806 * t808 + 0.200e3 / 0.9e1 * t528 * t831 - 0.80e2 / 0.9e1 * t528 * t834 + 0.50e2 / 0.3e1 * t227 * t845 - 0.80e2 / 0.9e1 * t227 * t848) * t231 + t1155 * t208 + 0.800e3 / 0.9e1 * t444 * t897 + 0.500e3 / 0.9e1 * t65 * t911 + 0.500e3 / 0.9e1 * t69 * t58 * t897 + 0.1250e4 / 0.9e1 * t449 * t911
  t1215 = -0.40e2 / 0.9e1 * t390 * t824 + 0.50e2 / 0.9e1 * t170 * t806 * t808 + 0.50e2 / 0.9e1 * t171 * t831 - 0.40e2 / 0.9e1 * t171 * t834 + 0.50e2 / 0.9e1 * t173 * t806 * t808 + 0.200e3 / 0.9e1 * t395 * t831 - 0.80e2 / 0.9e1 * t395 * t834 + 0.50e2 / 0.3e1 * t174 * t845 - 0.80e2 / 0.9e1 * t174 * t848 + 0.50e2 / 0.3e1 * t176 * t46 * t831 + 0.50e2 * t400 * t845 - 0.40e2 / 0.3e1 * t400 * t848 + 0.100e3 / 0.3e1 * t177 * t897 - 0.40e2 / 0.3e1 * t177 * t900
  t1219 = t803 * t167
  t1233 = 0.250e3 / 0.3e1 * t71 / t66 / t60 * t806 * t116 - 0.21333333333333333333333333333333333333333333333334e-1 * t406 * t458 + 0.85333333333333333333333333333333333333333333333336e-4 * t476 * t111 * t481 + 0.91022222222222222222222222222222222222222222222228e-6 * t217 * t130 * t795 * t208 + 0.4e-2 * t1215 * s0 * t181 - 0.38400000000000000000000000000000000000000000000001e-3 * t409 * t1219 - 0.21333333333333333333333333333333333333333333333334e-1 * t477 * t463 - 0.38400000000000000000000000000000000000000000000001e-3 * t480 * t803 * t208 - 0.80e2 / 0.9e1 * t53 * t848 - 0.40e2 / 0.3e1 * t439 * t848 - 0.40e2 / 0.3e1 * t59 * t900
  t1253 = t795 * t167
  t1260 = -0.160e3 / 0.9e1 * t444 * t900 - 0.160e3 / 0.9e1 * t65 * t914 - 0.200e3 / 0.9e1 * t449 * t914 - 0.200e3 / 0.9e1 * t71 * t454 * t280 + 0.39111111111111111111111111111111111111111111111112e-1 * t180 * t970 * t167 + 0.54044444444444444444444444444444444444444444444444e-3 * t192 * t1219 + 0.39111111111111111111111111111111111111111111111112e-1 * t218 * t970 * t208 - 0.17066666666666666666666666666666666666666666666667e-3 * t425 * t410 - 0.48924444444444444444444444444444444444444444444446e-5 * t428 * t1253 - 0.40e2 / 0.9e1 * t47 * t834 - 0.80e2 / 0.9e1 * t434 * t834
  t1333 = 0.100e3 / 0.3e1 * t63 * t52 * t845 + 0.4e-2 * (-0.40e2 / 0.9e1 * t466 * t824 + 0.50e2 / 0.9e1 * t211 * t806 * t808 + 0.50e2 / 0.9e1 * t212 * t831 - 0.40e2 / 0.9e1 * t212 * t834 + 0.50e2 / 0.9e1 * t214 * t806 * t808 + 0.200e3 / 0.9e1 * t471 * t831 - 0.80e2 / 0.9e1 * t471 * t834 + 0.50e2 / 0.3e1 * t215 * t845 - 0.80e2 / 0.9e1 * t215 * t848) * s0 * t219 + 0.50e2 / 0.3e1 * t57 * t46 * t831 + 0.50e2 * t439 * t845 + 0.100e3 / 0.3e1 * t59 * t897 + 0.68266666666666666666666666666666666666666666666668e-6 * t424 * t130 * t429 + 0.10922666666666666666666666666666666666666666666667e-7 * t191 * t370 * t821 * t167 + 0.50e2 / 0.9e1 * t47 * t831 + 0.200e3 / 0.9e1 * t434 * t831 + 0.50e2 / 0.3e1 * t53 * t845 + 0.16e-4 * (-0.40e2 / 0.9e1 * t414 * t824 + 0.50e2 / 0.9e1 * t185 * t806 * t808 + 0.50e2 / 0.9e1 * t186 * t831 - 0.40e2 / 0.9e1 * t186 * t834 + 0.50e2 / 0.9e1 * t188 * t806 * t808 + 0.200e3 / 0.9e1 * t419 * t831 - 0.80e2 / 0.9e1 * t419 * t834 + 0.50e2 / 0.3e1 * t189 * t845 - 0.80e2 / 0.9e1 * t189 * t848) * t111 * t193
  t1340 = t504 * t208
  t1348 = t229 / t380 / t166
  t1351 = t152 * t231
  t1354 = t206 * t381
  t1357 = t521 * t231
  t1362 = t533 * t381
  t1365 = 0.85333333333333333333333333333333333333333333333336e-4 * t405 * t111 * t410 + 0.91022222222222222222222222222222222222222222222228e-6 * t179 * t130 * t1253 - 0.2e1 * t1340 * t264 - t385 * t1030 - 0.3e1 * t382 * t1030 + 0.12e2 * t1348 * t1047 + 0.2e1 * t1351 * t1047 + 0.6e1 * t1354 * t1047 - 0.4e1 * t1357 * t264 - 0.2e1 * t387 * t1030 - 0.6e1 * t1362 * t264
  t1373 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t770 * t30 * t233 - t777 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t536 + t787 - t789 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t247 * (-0.17066666666666666666666666666666666666666666666667e-3 * t350 * t287 - 0.48924444444444444444444444444444444444444444444446e-5 * t353 * t795 - 0.21333333333333333333333333333333333333333333333334e-1 * t328 * t281 - 0.38400000000000000000000000000000000000000000000001e-3 * t331 * t803 + 0.50e2 / 0.9e1 * t33 * t806 * t808 + 0.50e2 / 0.9e1 * t51 * t806 * t808 + 0.68266666666666666666666666666666666666666666666668e-6 * t349 * t130 * t292 + 0.10922666666666666666666666666666666666666666666667e-7 * t110 * t370 * t821 + 0.64e-7 * (-0.40e2 / 0.9e1 * t356 * t824 + 0.50e2 / 0.9e1 * t123 * t806 * t808 + 0.50e2 / 0.9e1 * t124 * t831 - 0.40e2 / 0.9e1 * t124 * t834 + 0.50e2 / 0.9e1 * t126 * t806 * t808 + 0.200e3 / 0.9e1 * t361 * t831 - 0.80e2 / 0.9e1 * t361 * t834 + 0.50e2 / 0.3e1 * t127 * t845 - 0.80e2 / 0.9e1 * t127 * t848) * t130 * t136 + 0.40960000000000000000000000000000000000000000000002e-8 * t366 * t370 * t377 + t977 + t1043 + t1166 + t1233 + t1260 + t1333 + t1365))
  t1374 = t547 ** 2
  t1375 = 0.1e1 / t1374
  t1376 = t549 ** 2
  t1379 = -t765
  t1380 = f.my_piecewise5(t14, 0, t10, 0, t1379)
  t1384 = f.my_piecewise3(t546, 0, 0.4e1 / 0.9e1 * t1375 * t1376 + 0.4e1 / 0.3e1 * t547 * t1380)
  t1391 = t5 * t552 * t242 * t701
  t1399 = t5 * t706 * t783 * t701 / 0.12e2
  t1401 = t5 * t707 * t749
  t1403 = t644 * t699
  t1404 = t724 ** 2
  t1408 = 0.17777777777777777777777777777777777777777777777777e0 * t1006 * t648
  t1409 = t252 * t721
  t1412 = 0.1e1 / t715 / t647
  t1413 = t717 ** 2
  t1414 = 0.1e1 / t1413
  t1415 = t1412 * t1414
  t1416 = t720 ** 2
  t1421 = 0.1e1 / t717 / t646
  t1422 = t716 * t1421
  t1426 = f.my_piecewise5(t159, 0, t157, 0, t1379)
  t1430 = t1408 + 0.88888888888888888888888888888888888888888888888886e-1 * t1409 - 0.88888888888888888888888888888888888888888888888887e-1 * t155 * t1415 * t1416 + 0.26666666666666666666666666666666666666666666666666e0 * t155 * t1422 * t1416 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t719 * t1426
  t1438 = t618 * t699
  t1445 = t680 * t745
  t1450 = t600 * t745
  t1459 = t697 / t744 / t651
  t1464 = 0.2e1 * t1403 * t1404 - t712 * t1430 + 0.8e-2 * t726 * t740 * t1404 - 0.4e-2 * t726 * t727 * t1430 + 0.32e-4 * t731 * t1438 * t1404 - 0.16e-4 * t731 * t732 * t1430 + 0.6e1 * t1445 * t1404 - 0.2e1 * t736 * t1430 + 0.24e-1 * t739 * t1450 * t1404 - 0.8e-2 * t739 * t740 * t1430 + 0.12e2 * t1459 * t1404 - 0.3e1 * t746 * t1430
  t1469 = f.my_piecewise3(t543, 0, -0.3e1 / 0.8e1 * t5 * t1384 * t30 * t701 - t1391 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t553 * t749 + t1399 - t1401 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t711 * t1464)
  d11 = 0.2e1 * t541 + 0.2e1 * t754 + t6 * (t1373 + t1469)
  t1472 = -t7 - t24
  t1473 = f.my_piecewise5(t10, 0, t14, 0, t1472)
  t1476 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t1473)
  t1477 = t1476 * t30
  t1481 = f.my_piecewise5(t157, 0, t159, 0, t1472)
  t1482 = t259 * t1481
  t1485 = -t254 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t1482
  t1487 = t249 * t1485
  t1490 = t269 * t1485
  t1495 = t274 * t1485
  t1500 = -t385 * t1485 - 0.4e-2 * t248 * t1487 - 0.16e-4 * t268 * t1490 - 0.2e1 * t387 * t1485 - 0.8e-2 * t273 * t1495 - 0.3e1 * t382 * t1485
  t1505 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1477 * t233 - t246 - 0.3e1 / 0.8e1 * t5 * t247 * t1500)
  t1506 = -t1472
  t1507 = f.my_piecewise5(t14, 0, t10, 0, t1506)
  t1510 = f.my_piecewise3(t546, 0, 0.4e1 / 0.3e1 * t547 * t1507)
  t1511 = t1510 * t30
  t1515 = f.my_piecewise5(t159, 0, t157, 0, t1506)
  t1516 = t719 * t1515
  t1519 = -t714 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t1516
  t1520 = t740 * t1519
  t1523 = t727 * t1519
  t1526 = t732 * t1519
  t1529 = t197 * tau1
  t1530 = t596 * t562
  t1533 = t567 * tau1
  t1534 = t1533 * t596
  t1537 = t200 * t559
  t1540 = t572 * tau1
  t1541 = t1540 * t596
  t1544 = t203 * t564
  t1547 = t577 * tau1
  t1548 = t1547 * t596
  t1551 = 0.5e1 / 0.3e1 * t1529 * t1530 + 0.5e1 / 0.3e1 * t674 * t1534 + 0.10e2 / 0.3e1 * t1537 * t1534 + 0.10e2 / 0.3e1 * t676 * t1541 + 0.5e1 * t1544 * t1541 + 0.5e1 * t678 * t1548
  t1553 = t223 * tau1
  t1558 = t226 * t559
  t1563 = 0.5e1 / 0.3e1 * t1553 * t1530 + 0.5e1 / 0.3e1 * t693 * t1534 + 0.10e2 / 0.3e1 * t1558 * t1534 + 0.10e2 / 0.3e1 * t695 * t1541
  t1565 = t140 * tau1
  t1570 = t143 * t559
  t1575 = t146 * t564
  t1580 = t149 * t569
  t1583 = t582 * tau1
  t1584 = t1583 * t596
  t1587 = 0.5e1 / 0.3e1 * t1565 * t1530 + 0.5e1 / 0.3e1 * t636 * t1534 + 0.10e2 / 0.3e1 * t1570 * t1534 + 0.10e2 / 0.3e1 * t638 * t1541 + 0.5e1 * t1575 * t1541 + 0.5e1 * t640 * t1548 + 0.20e2 / 0.3e1 * t1580 * t1548 + 0.20e2 / 0.3e1 * t642 * t1584
  t1589 = t170 * tau1
  t1594 = t173 * t559
  t1599 = t176 * t564
  t1604 = 0.5e1 / 0.3e1 * t1589 * t1530 + 0.5e1 / 0.3e1 * t654 * t1534 + 0.10e2 / 0.3e1 * t1594 * t1534 + 0.10e2 / 0.3e1 * t656 * t1541 + 0.5e1 * t1599 * t1541 + 0.5e1 * t658 * t1548
  t1605 = t1604 * s2
  t1608 = t660 * t611
  t1611 = 0.1e1 / t554 / t613 / t594
  t1612 = t1611 * t618
  t1613 = t1612 * t652
  t1616 = t185 * tau1
  t1621 = t188 * t559
  t1626 = 0.5e1 / 0.3e1 * t1616 * t1530 + 0.5e1 / 0.3e1 * t665 * t1534 + 0.10e2 / 0.3e1 * t1621 * t1534 + 0.10e2 / 0.3e1 * t667 * t1541
  t1627 = t1626 * t611
  t1630 = t669 * t627
  t1632 = 0.1e1 / t629 / r1
  t1633 = t1632 * t632
  t1634 = t1633 * t652
  t1639 = t51 * t559
  t1644 = t57 * t564
  t1649 = t63 * t569
  t1654 = t69 * t574
  t1657 = -0.8e-2 * t739 * t1520 - 0.4e-2 * t726 * t1523 - 0.16e-4 * t731 * t1526 + t1551 * t682 + t1563 * t699 + t1587 * t652 + 0.4e-2 * t1605 * t662 + 0.42666666666666666666666666666666666666666666666668e-4 * t1608 * t1613 + 0.16e-4 * t1627 * t671 + 0.34133333333333333333333333333333333333333333333334e-6 * t1630 * t1634 + 0.5e1 / 0.3e1 * t560 * t1534 + 0.10e2 / 0.3e1 * t1639 * t1534 + 0.10e2 / 0.3e1 * t565 * t1541 + 0.5e1 * t1644 * t1541 + 0.5e1 * t570 * t1548 + 0.20e2 / 0.3e1 * t1649 * t1548 + 0.20e2 / 0.3e1 * t575 * t1584 + 0.25e2 / 0.3e1 * t1654 * t1584
  t1659 = 0.1e1 / t576 / t566
  t1660 = t1659 * tau1
  t1664 = t594 * r1
  t1666 = 0.1e1 / t555 / t1664
  t1667 = t1666 * t600
  t1668 = t1667 * t682
  t1671 = t1667 * t652
  t1676 = t211 * tau1
  t1681 = t214 * t559
  t1686 = 0.5e1 / 0.3e1 * t1676 * t1530 + 0.5e1 / 0.3e1 * t684 * t1534 + 0.10e2 / 0.3e1 * t1681 * t1534 + 0.10e2 / 0.3e1 * t686 * t1541
  t1687 = t1686 * s2
  t1690 = t688 * t611
  t1691 = t1612 * t682
  t1700 = t592 * t611
  t1703 = t101 * tau1
  t1708 = t104 * t559
  t1713 = t107 * t564
  t1718 = 0.5e1 / 0.3e1 * t1703 * t1530 + 0.5e1 / 0.3e1 * t604 * t1534 + 0.10e2 / 0.3e1 * t1708 * t1534 + 0.10e2 / 0.3e1 * t606 * t1541 + 0.5e1 * t1713 * t1541 + 0.5e1 * t608 * t1548
  t1719 = t1718 * t611
  t1722 = t610 * t627
  t1725 = t123 * tau1
  t1730 = t126 * t559
  t1735 = 0.5e1 / 0.3e1 * t1725 * t1530 + 0.5e1 / 0.3e1 * t622 * t1534 + 0.10e2 / 0.3e1 * t1730 * t1534 + 0.10e2 / 0.3e1 * t624 * t1541
  t1736 = t1735 * t627
  t1739 = t611 ** 2
  t1740 = t626 * t1739
  t1744 = t617 ** 2
  t1745 = 0.1e1 / t1744
  t1746 = 0.1e1 / t555 / t629 / t1664 * t1745
  t1749 = t33 * tau1
  t1752 = t76 * tau1
  t1757 = t79 * t559
  t1762 = t82 * t564
  t1767 = t85 * t569
  t1772 = 0.5e1 / 0.3e1 * t1752 * t1530 + 0.5e1 / 0.3e1 * t584 * t1534 + 0.10e2 / 0.3e1 * t1757 * t1534 + 0.10e2 / 0.3e1 * t586 * t1541 + 0.5e1 * t1762 * t1541 + 0.5e1 * t588 * t1548 + 0.20e2 / 0.3e1 * t1767 * t1548 + 0.20e2 / 0.3e1 * t590 * t1584
  t1773 = t1772 * s2
  t1781 = 0.25e2 / 0.3e1 * t580 * t1660 * t596 - 0.10666666666666666666666666666666666666666666666667e-1 * t689 * t1668 - 0.10666666666666666666666666666666666666666666666667e-1 * t661 * t1671 - 0.85333333333333333333333333333333333333333333333333e-4 * t670 * t1613 + 0.4e-2 * t1687 * t690 + 0.42666666666666666666666666666666666666666666666668e-4 * t1690 * t1691 - 0.10666666666666666666666666666666666666666666666667e-1 * t593 * t1667 - 0.85333333333333333333333333333333333333333333333333e-4 * t612 * t1612 - 0.512e-6 * t628 * t1633 + 0.42666666666666666666666666666666666666666666666668e-4 * t1700 * t1612 + 0.16e-4 * t1719 * t619 + 0.34133333333333333333333333333333333333333333333334e-6 * t1722 * t1633 + 0.64e-7 * t1736 * t633 + 0.20480000000000000000000000000000000000000000000001e-8 * t1740 * t1746 + 0.5e1 / 0.3e1 * t1749 * t1530 + 0.4e-2 * t1773 * t601 - 0.3e1 * t746 * t1519 - t712 * t1519 - 0.2e1 * t736 * t1519
  t1782 = t1657 + t1781
  t1787 = f.my_piecewise3(t543, 0, -0.3e1 / 0.8e1 * t5 * t1511 * t701 - t710 - 0.3e1 / 0.8e1 * t5 * t711 * t1782)
  t1791 = 0.2e1 * t763
  t1792 = f.my_piecewise5(t10, 0, t14, 0, t1791)
  t1796 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t757 * t1473 * t26 + 0.4e1 / 0.3e1 * t21 * t1792)
  t1803 = t5 * t1476 * t242 * t233
  t1814 = t5 * t243 * t1500
  t1817 = t1485 * t264
  t1821 = t252 * t1482
  t1833 = f.my_piecewise5(t157, 0, t159, 0, t1791)
  t1837 = t1008 + 0.44444444444444444444444444444444444444444444444443e-1 * t1009 + 0.44444444444444444444444444444444444444444444444443e-1 * t1821 - 0.88888888888888888888888888888888888888888888888887e-1 * t155 * t1012 * t1014 * t1481 * t260 + 0.26666666666666666666666666666666666666666666666666e0 * t155 * t256 * t1021 * t1481 * t260 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t259 * t1833
  t1861 = -t1340 * t1485 + 0.2e1 * t1351 * t1817 - t385 * t1837 - 0.4e-2 * t1040 * t1487 + 0.10666666666666666666666666666666666666666666666667e-1 * t987 * t1487 - 0.42666666666666666666666666666666666666666666666668e-4 * t1044 * t1490 + 0.8e-2 * t248 * t274 * t1817 - 0.4e-2 * t248 * t249 * t1837 - 0.16e-4 * t979 * t1490 + 0.85333333333333333333333333333333333333333333333333e-4 * t990 * t1490 - 0.34133333333333333333333333333333333333333333333334e-6 * t982 * t983 * t1485 + 0.32e-4 * t268 * t1000 * t1817
  t1890 = -0.16e-4 * t268 * t269 * t1837 - 0.2e1 * t1357 * t1485 + 0.6e1 * t1354 * t1817 - 0.2e1 * t387 * t1837 - 0.8e-2 * t996 * t1495 + 0.21333333333333333333333333333333333333333333333333e-1 * t993 * t1495 - 0.85333333333333333333333333333333333333333333333336e-4 * t999 * t1000 * t1485 + 0.24e-1 * t273 * t1054 * t1817 - 0.8e-2 * t273 * t274 * t1837 - 0.3e1 * t1362 * t1485 + 0.12e2 * t1348 * t1817 - 0.3e1 * t382 * t1837
  t1896 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1796 * t30 * t233 - t1803 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t1477 * t536 - t777 / 0.8e1 + t787 - t789 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t31 * t1500 - t1814 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t247 * (t1861 + t1890))
  t1900 = f.my_piecewise5(t14, 0, t10, 0, -t1791)
  t1904 = f.my_piecewise3(t546, 0, 0.4e1 / 0.9e1 * t1375 * t1507 * t549 + 0.4e1 / 0.3e1 * t547 * t1900)
  t1911 = t5 * t1510 * t242 * t701
  t1922 = t5 * t707 * t1782
  t1924 = t1519 * t724
  t1928 = t252 * t1516
  t1940 = f.my_piecewise5(t159, 0, t157, 0, -t1791)
  t1944 = t1408 + 0.44444444444444444444444444444444444444444444444443e-1 * t1409 + 0.44444444444444444444444444444444444444444444444443e-1 * t1928 - 0.88888888888888888888888888888888888888888888888887e-1 * t155 * t1412 * t1414 * t1515 * t720 + 0.26666666666666666666666666666666666666666666666666e0 * t155 * t716 * t1421 * t1515 * t720 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t719 * t1940
  t1954 = t1563 * t745
  t1957 = t1587 * t682
  t1959 = t1551 * t699
  t1962 = t1687 * t596
  t1965 = t1690 * t1611
  t1969 = t1605 * t596
  t1972 = 0.6e1 * t1445 * t1924 - 0.2e1 * t736 * t1944 + 0.2e1 * t1403 * t1924 - t712 * t1944 + 0.12e2 * t1459 * t1924 - 0.3e1 * t746 * t1944 - 0.3e1 * t1954 * t724 - t1957 * t724 - 0.2e1 * t1959 * t724 - 0.8e-2 * t1962 * t741 - 0.85333333333333333333333333333333333333333333333336e-4 * t1965 * t1438 * t724 - 0.4e-2 * t1969 * t728
  t1973 = t1608 * t1611
  t1976 = t1627 * t616
  t1979 = t1630 * t1632
  t1980 = t632 * t682
  t1984 = t689 * t1666
  t1987 = t661 * t1666
  t1990 = t670 * t1611
  t2011 = -0.42666666666666666666666666666666666666666666666668e-4 * t1973 * t733 - 0.16e-4 * t1976 * t733 - 0.34133333333333333333333333333333333333333333333334e-6 * t1979 * t1980 * t724 + 0.21333333333333333333333333333333333333333333333334e-1 * t1984 * t741 + 0.10666666666666666666666666666666666666666666666667e-1 * t1987 * t728 + 0.85333333333333333333333333333333333333333333333333e-4 * t1990 * t733 + 0.8e-2 * t726 * t740 * t1924 - 0.4e-2 * t726 * t727 * t1944 + 0.32e-4 * t731 * t1438 * t1924 - 0.16e-4 * t731 * t732 * t1944 + 0.24e-1 * t739 * t1450 * t1924 - 0.8e-2 * t739 * t740 * t1944
  t2017 = f.my_piecewise3(t543, 0, -0.3e1 / 0.8e1 * t5 * t1904 * t30 * t701 - t1911 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t1511 * t749 - t1391 / 0.8e1 + t1399 - t1401 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t553 * t1782 - t1922 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t711 * (t1972 + t2011))
  d12 = t541 + t754 + t1505 + t1787 + t6 * (t1896 + t2017)
  t2022 = t1473 ** 2
  t2026 = 0.2e1 * t23 + 0.2e1 * t763
  t2027 = f.my_piecewise5(t10, 0, t14, 0, t2026)
  t2031 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t757 * t2022 + 0.4e1 / 0.3e1 * t21 * t2027)
  t2041 = t1485 ** 2
  t2045 = t1481 ** 2
  t2052 = f.my_piecewise5(t157, 0, t159, 0, t2026)
  t2056 = t1008 + 0.88888888888888888888888888888888888888888888888886e-1 * t1821 - 0.88888888888888888888888888888888888888888888888887e-1 * t155 * t1015 * t2045 + 0.26666666666666666666666666666666666666666666666666e0 * t155 * t1022 * t2045 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t259 * t2052
  t2084 = 0.2e1 * t1351 * t2041 - t385 * t2056 + 0.8e-2 * t248 * t274 * t2041 - 0.4e-2 * t248 * t249 * t2056 + 0.32e-4 * t268 * t1000 * t2041 - 0.16e-4 * t268 * t269 * t2056 + 0.6e1 * t1354 * t2041 - 0.2e1 * t387 * t2056 + 0.24e-1 * t273 * t1054 * t2041 - 0.8e-2 * t273 * t274 * t2056 + 0.12e2 * t1348 * t2041 - 0.3e1 * t382 * t2056
  t2089 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t2031 * t30 * t233 - t1803 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t1477 * t1500 + t787 - t1814 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t247 * t2084)
  t2090 = t1507 ** 2
  t2093 = -t2026
  t2094 = f.my_piecewise5(t14, 0, t10, 0, t2093)
  t2098 = f.my_piecewise3(t546, 0, 0.4e1 / 0.9e1 * t1375 * t2090 + 0.4e1 / 0.3e1 * t547 * t2094)
  t2109 = t1515 ** 2
  t2116 = f.my_piecewise5(t159, 0, t157, 0, t2093)
  t2120 = t1408 + 0.88888888888888888888888888888888888888888888888886e-1 * t1928 - 0.88888888888888888888888888888888888888888888888887e-1 * t155 * t1415 * t2109 + 0.26666666666666666666666666666666666666666666666666e0 * t155 * t1422 * t2109 - 0.13333333333333333333333333333333333333333333333333e0 * t155 * t719 * t2116
  t2128 = t1519 ** 2
  t2139 = t1666 * t562
  t2142 = tau1 ** 2
  t2144 = t616 * t567
  t2148 = t572 * t2142 * t616
  t2151 = t1533 * t1666
  t2162 = t577 * t2142 * t616
  t2165 = t1540 * t1666
  t2176 = t582 * t2142 * t616
  t2179 = t1547 * t1666
  t2190 = t1659 * t2142 * t616
  t2193 = t1583 * t1666
  t2196 = -0.40e2 / 0.9e1 * t1565 * t2139 + 0.50e2 / 0.9e1 * t140 * t2142 * t2144 + 0.50e2 / 0.9e1 * t636 * t2148 - 0.40e2 / 0.9e1 * t636 * t2151 + 0.50e2 / 0.9e1 * t143 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1570 * t2148 - 0.80e2 / 0.9e1 * t1570 * t2151 + 0.50e2 / 0.3e1 * t638 * t2162 - 0.80e2 / 0.9e1 * t638 * t2165 + 0.50e2 / 0.3e1 * t146 * t559 * t2148 + 0.50e2 * t1575 * t2162 - 0.40e2 / 0.3e1 * t1575 * t2165 + 0.100e3 / 0.3e1 * t640 * t2176 - 0.40e2 / 0.3e1 * t640 * t2179 + 0.100e3 / 0.3e1 * t149 * t564 * t2162 + 0.800e3 / 0.9e1 * t1580 * t2176 - 0.160e3 / 0.9e1 * t1580 * t2179 + 0.500e3 / 0.9e1 * t642 * t2190 - 0.160e3 / 0.9e1 * t642 * t2193
  t2203 = 0.1e1 / t629 / t594 * t632
  t2233 = t613 * t1664
  t2236 = 0.1e1 / t554 / t2233 * t618
  t2245 = 0.1e1 / t555 / t613 * t600
  t2253 = 0.1e1 / t555 / t629 / t613 * t1745
  t2258 = -0.17066666666666666666666666666666666666666666666667e-3 * t1719 * t1612 - 0.48924444444444444444444444444444444444444444444446e-5 * t1722 * t2203 + 0.64e-7 * (-0.40e2 / 0.9e1 * t1725 * t2139 + 0.50e2 / 0.9e1 * t123 * t2142 * t2144 + 0.50e2 / 0.9e1 * t622 * t2148 - 0.40e2 / 0.9e1 * t622 * t2151 + 0.50e2 / 0.9e1 * t126 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1730 * t2148 - 0.80e2 / 0.9e1 * t1730 * t2151 + 0.50e2 / 0.3e1 * t624 * t2162 - 0.80e2 / 0.9e1 * t624 * t2165) * t627 * t633 + 0.40960000000000000000000000000000000000000000000002e-8 * t1735 * t1739 * t1746 + 0.54044444444444444444444444444444444444444444444444e-3 * t612 * t2236 + 0.4608e-5 * t628 * t2203 - 0.21333333333333333333333333333333333333333333333334e-1 * t1773 * t1667 + 0.39111111111111111111111111111111111111111111111112e-1 * t593 * t2245 - 0.1024e-5 * t1736 * t1633 - 0.40277333333333333333333333333333333333333333333336e-7 * t1740 * t2253 - 0.40e2 / 0.9e1 * t1749 * t2139
  t2297 = -0.40e2 / 0.9e1 * t1703 * t2139 + 0.50e2 / 0.9e1 * t101 * t2142 * t2144 + 0.50e2 / 0.9e1 * t604 * t2148 - 0.40e2 / 0.9e1 * t604 * t2151 + 0.50e2 / 0.9e1 * t104 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1708 * t2148 - 0.80e2 / 0.9e1 * t1708 * t2151 + 0.50e2 / 0.3e1 * t606 * t2162 - 0.80e2 / 0.9e1 * t606 * t2165 + 0.50e2 / 0.3e1 * t107 * t559 * t2148 + 0.50e2 * t1713 * t2162 - 0.40e2 / 0.3e1 * t1713 * t2165 + 0.100e3 / 0.3e1 * t608 * t2176 - 0.40e2 / 0.3e1 * t608 * t2179
  t2362 = -0.40e2 / 0.9e1 * t1752 * t2139 + 0.50e2 / 0.9e1 * t76 * t2142 * t2144 + 0.50e2 / 0.9e1 * t584 * t2148 - 0.40e2 / 0.9e1 * t584 * t2151 + 0.50e2 / 0.9e1 * t79 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1757 * t2148 - 0.80e2 / 0.9e1 * t1757 * t2151 + 0.50e2 / 0.3e1 * t586 * t2162 - 0.80e2 / 0.9e1 * t586 * t2165 + 0.50e2 / 0.3e1 * t82 * t559 * t2148 + 0.50e2 * t1762 * t2162 - 0.40e2 / 0.3e1 * t1762 * t2165 + 0.100e3 / 0.3e1 * t588 * t2176 - 0.40e2 / 0.3e1 * t588 * t2179 + 0.100e3 / 0.3e1 * t85 * t564 * t2162 + 0.800e3 / 0.9e1 * t1767 * t2176 - 0.160e3 / 0.9e1 * t1767 * t2179 + 0.500e3 / 0.9e1 * t590 * t2190 - 0.160e3 / 0.9e1 * t590 * t2193
  t2402 = -0.40e2 / 0.9e1 * t1529 * t2139 + 0.50e2 / 0.9e1 * t197 * t2142 * t2144 + 0.50e2 / 0.9e1 * t674 * t2148 - 0.40e2 / 0.9e1 * t674 * t2151 + 0.50e2 / 0.9e1 * t200 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1537 * t2148 - 0.80e2 / 0.9e1 * t1537 * t2151 + 0.50e2 / 0.3e1 * t676 * t2162 - 0.80e2 / 0.9e1 * t676 * t2165 + 0.50e2 / 0.3e1 * t203 * t559 * t2148 + 0.50e2 * t1544 * t2162 - 0.40e2 / 0.3e1 * t1544 * t2165 + 0.100e3 / 0.3e1 * t678 * t2176 - 0.40e2 / 0.3e1 * t678 * t2179
  t2404 = 0.50e2 / 0.9e1 * t51 * t2142 * t2144 + 0.91022222222222222222222222222222222222222222222228e-6 * t592 * t627 * t2203 + 0.16e-4 * t2297 * t611 * t619 + 0.68266666666666666666666666666666666666666666666668e-6 * t1718 * t627 * t1633 + 0.10922666666666666666666666666666666666666666666667e-7 * t610 * t1739 * t2253 + 0.87381333333333333333333333333333333333333333333340e-10 * t626 * t1739 * s2 / t554 / t629 / t2233 / t1744 / t599 + 0.50e2 / 0.9e1 * t33 * t2142 * t2144 + 0.4e-2 * t2362 * s2 * t601 + 0.85333333333333333333333333333333333333333333333336e-4 * t1772 * t611 * t1612 - 0.38400000000000000000000000000000000000000000000001e-3 * t1700 * t2236 + t2402 * t682
  t2452 = (-0.40e2 / 0.9e1 * t1553 * t2139 + 0.50e2 / 0.9e1 * t223 * t2142 * t2144 + 0.50e2 / 0.9e1 * t693 * t2148 - 0.40e2 / 0.9e1 * t693 * t2151 + 0.50e2 / 0.9e1 * t226 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1558 * t2148 - 0.80e2 / 0.9e1 * t1558 * t2151 + 0.50e2 / 0.3e1 * t695 * t2162 - 0.80e2 / 0.9e1 * t695 * t2165) * t699 - 0.32e-4 * t1976 * t1526 + 0.17066666666666666666666666666666666666666666666667e-3 * t1990 * t1526 - 0.16e-1 * t1962 * t1520 - 0.17066666666666666666666666666666666666666666666667e-3 * t1965 * t1438 * t1519 + 0.42666666666666666666666666666666666666666666666667e-1 * t1984 * t1520 + 0.21333333333333333333333333333333333333333333333334e-1 * t1987 * t1523 - 0.68266666666666666666666666666666666666666666666668e-6 * t1979 * t1980 * t1519 + 0.24e-1 * t739 * t1450 * t2128 + 0.8e-2 * t726 * t740 * t2128 + 0.32e-4 * t731 * t1438 * t2128
  t2469 = t2203 * t652
  t2503 = t2236 * t652
  t2508 = -0.8e-2 * t739 * t740 * t2120 - 0.4e-2 * t726 * t727 * t2120 - 0.16e-4 * t731 * t732 * t2120 - 0.8e-2 * t1969 * t1523 - 0.85333333333333333333333333333333333333333333333336e-4 * t1973 * t1526 + 0.91022222222222222222222222222222222222222222222228e-6 * t660 * t627 * t2469 + 0.16e-4 * (-0.40e2 / 0.9e1 * t1616 * t2139 + 0.50e2 / 0.9e1 * t185 * t2142 * t2144 + 0.50e2 / 0.9e1 * t665 * t2148 - 0.40e2 / 0.9e1 * t665 * t2151 + 0.50e2 / 0.9e1 * t188 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1621 * t2148 - 0.80e2 / 0.9e1 * t1621 * t2151 + 0.50e2 / 0.3e1 * t667 * t2162 - 0.80e2 / 0.9e1 * t667 * t2165) * t611 * t671 + 0.85333333333333333333333333333333333333333333333336e-4 * t1686 * t611 * t1691 + 0.91022222222222222222222222222222222222222222222228e-6 * t688 * t627 * t2203 * t682 + 0.54044444444444444444444444444444444444444444444444e-3 * t670 * t2503 - 0.40e2 / 0.3e1 * t1644 * t2165
  t2536 = -0.40e2 / 0.3e1 * t570 * t2179 - 0.160e3 / 0.9e1 * t1649 * t2179 - 0.160e3 / 0.9e1 * t575 * t2193 - 0.200e3 / 0.9e1 * t1654 * t2193 - 0.200e3 / 0.9e1 * t580 * t1660 * t1666 + 0.39111111111111111111111111111111111111111111111112e-1 * t689 * t2245 * t682 + 0.39111111111111111111111111111111111111111111111112e-1 * t661 * t2245 * t652 - 0.48924444444444444444444444444444444444444444444446e-5 * t1630 * t2469 - 0.40e2 / 0.9e1 * t560 * t2151 + 0.68266666666666666666666666666666666666666666666668e-6 * t1626 * t627 * t1634 + 0.85333333333333333333333333333333333333333333333336e-4 * t1604 * t611 * t1613
  t2569 = -0.40e2 / 0.9e1 * t1589 * t2139 + 0.50e2 / 0.9e1 * t170 * t2142 * t2144 + 0.50e2 / 0.9e1 * t654 * t2148 - 0.40e2 / 0.9e1 * t654 * t2151 + 0.50e2 / 0.9e1 * t173 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1594 * t2148 - 0.80e2 / 0.9e1 * t1594 * t2151 + 0.50e2 / 0.3e1 * t656 * t2162 - 0.80e2 / 0.9e1 * t656 * t2165 + 0.50e2 / 0.3e1 * t176 * t559 * t2148 + 0.50e2 * t1599 * t2162 - 0.40e2 / 0.3e1 * t1599 * t2165 + 0.100e3 / 0.3e1 * t658 * t2176 - 0.40e2 / 0.3e1 * t658 * t2179
  t2621 = 0.4e-2 * t2569 * s2 * t662 - 0.80e2 / 0.9e1 * t1639 * t2151 - 0.80e2 / 0.9e1 * t565 * t2165 + 0.4e-2 * (-0.40e2 / 0.9e1 * t1676 * t2139 + 0.50e2 / 0.9e1 * t211 * t2142 * t2144 + 0.50e2 / 0.9e1 * t684 * t2148 - 0.40e2 / 0.9e1 * t684 * t2151 + 0.50e2 / 0.9e1 * t214 * t2142 * t2144 + 0.200e3 / 0.9e1 * t1681 * t2148 - 0.80e2 / 0.9e1 * t1681 * t2151 + 0.50e2 / 0.3e1 * t686 * t2162 - 0.80e2 / 0.9e1 * t686 * t2165) * s2 * t690 + 0.500e3 / 0.9e1 * t69 * t569 * t2176 + 0.1250e4 / 0.9e1 * t1654 * t2190 + 0.250e3 / 0.3e1 * t580 / t576 / t571 * t2142 * t616 - 0.21333333333333333333333333333333333333333333333334e-1 * t1687 * t1668 - 0.38400000000000000000000000000000000000000000000001e-3 * t1690 * t2236 * t682 - 0.21333333333333333333333333333333333333333333333334e-1 * t1605 * t1671 - 0.38400000000000000000000000000000000000000000000001e-3 * t1608 * t2503
  t2648 = -0.17066666666666666666666666666666666666666666666667e-3 * t1627 * t1613 + 0.10922666666666666666666666666666666666666666666667e-7 * t669 * t1739 * t2253 * t652 + 0.50e2 / 0.9e1 * t560 * t2148 + 0.200e3 / 0.9e1 * t1639 * t2148 + 0.50e2 / 0.3e1 * t565 * t2162 + 0.50e2 / 0.3e1 * t57 * t559 * t2148 + 0.50e2 * t1644 * t2162 + 0.100e3 / 0.3e1 * t570 * t2176 + 0.100e3 / 0.3e1 * t63 * t564 * t2162 + 0.800e3 / 0.9e1 * t1649 * t2176 + 0.500e3 / 0.9e1 * t575 * t2190
  t2656 = f.my_piecewise3(t543, 0, -0.3e1 / 0.8e1 * t5 * t2098 * t30 * t701 - t1911 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t1511 * t1782 + t1399 - t1922 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t711 * (0.2e1 * t1403 * t2128 + 0.6e1 * t1445 * t2128 + 0.12e2 * t1459 * t2128 - 0.6e1 * t1954 * t1519 - 0.2e1 * t1957 * t1519 - 0.4e1 * t1959 * t1519 - t712 * t2120 - 0.2e1 * t736 * t2120 - 0.3e1 * t746 * t2120 + t2196 * t652 + t2258 + t2404 + t2452 + t2508 + t2536 + t2621 + t2648))
  d22 = 0.2e1 * t1505 + 0.2e1 * t1787 + t6 * (t2089 + t2656)

  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t32 = t24 * t6
  t33 = 0.1e1 / t32
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = params.c[0]
  t45 = params.c[1]
  t46 = 6 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = jnp.pi ** 2
  t49 = t48 ** (0.1e1 / 0.3e1)
  t50 = t49 ** 2
  t52 = 0.3e1 / 0.10e2 * t47 * t50
  t53 = r0 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t57 = tau0 / t54 / r0
  t58 = t52 - t57
  t59 = t45 * t58
  t60 = t52 + t57
  t61 = 0.1e1 / t60
  t63 = params.c[2]
  t64 = t58 ** 2
  t65 = t63 * t64
  t66 = t60 ** 2
  t67 = 0.1e1 / t66
  t69 = params.c[3]
  t70 = t64 * t58
  t71 = t69 * t70
  t72 = t66 * t60
  t73 = 0.1e1 / t72
  t75 = params.c[4]
  t76 = t64 ** 2
  t77 = t75 * t76
  t78 = t66 ** 2
  t79 = 0.1e1 / t78
  t81 = params.c[5]
  t83 = t81 * t76 * t58
  t85 = 0.1e1 / t78 / t60
  t87 = params.c[6]
  t88 = params.c[7]
  t89 = t88 * t58
  t91 = params.c[8]
  t92 = t91 * t64
  t94 = params.c[9]
  t95 = t94 * t70
  t97 = params.c[10]
  t98 = t97 * t76
  t100 = t89 * t61 + t92 * t67 + t95 * t73 + t98 * t79 + t87
  t101 = t100 * s0
  t102 = r0 ** 2
  t104 = 0.1e1 / t54 / t102
  t107 = 0.1e1 + 0.4e-2 * s0 * t104
  t108 = 0.1e1 / t107
  t109 = t104 * t108
  t112 = params.c[11]
  t113 = params.c[12]
  t114 = t113 * t58
  t116 = params.c[13]
  t117 = t116 * t64
  t119 = params.c[14]
  t120 = t119 * t70
  t122 = t114 * t61 + t117 * t67 + t120 * t73 + t112
  t123 = s0 ** 2
  t124 = t122 * t123
  t125 = t102 ** 2
  t126 = t125 * r0
  t128 = 0.1e1 / t53 / t126
  t129 = t107 ** 2
  t130 = 0.1e1 / t129
  t131 = t128 * t130
  t134 = params.c[15]
  t135 = params.c[16]
  t136 = t135 * t58
  t138 = params.c[17]
  t139 = t138 * t64
  t141 = t136 * t61 + t139 * t67 + t134
  t142 = t123 * s0
  t143 = t141 * t142
  t144 = t125 ** 2
  t145 = 0.1e1 / t144
  t147 = 0.1e1 / t129 / t107
  t148 = t145 * t147
  t151 = params.c[18]
  t152 = params.c[19]
  t153 = t152 * t58
  t155 = params.c[20]
  t156 = t155 * t64
  t158 = params.c[21]
  t159 = t158 * t70
  t161 = params.c[22]
  t162 = t161 * t76
  t164 = t153 * t61 + t156 * t67 + t159 * t73 + t162 * t79 + t151
  t166 = 2 ** (0.1e1 / 0.3e1)
  t167 = 0.1e1 / t42 * t166
  t169 = 0.1e1 + t17 <= f.p.zeta_threshold
  t171 = 0.1e1 - t17 <= f.p.zeta_threshold
  t172 = f.my_piecewise5(t169, t11, t171, t15, t17)
  t173 = 0.1e1 + t172
  t174 = 0.1e1 / t173
  t175 = t174 ** (0.1e1 / 0.3e1)
  t178 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 * t167 * t175
  t179 = 0.1e1 / t178
  t181 = params.c[23]
  t182 = params.c[24]
  t183 = t182 * t58
  t185 = params.c[25]
  t186 = t185 * t64
  t188 = params.c[26]
  t189 = t188 * t70
  t191 = t183 * t61 + t186 * t67 + t189 * t73 + t181
  t192 = t191 * s0
  t193 = t109 * t179
  t196 = params.c[27]
  t197 = params.c[28]
  t198 = t197 * t58
  t200 = params.c[29]
  t201 = t200 * t64
  t203 = t198 * t61 + t201 * t67 + t196
  t204 = t203 * t123
  t205 = t131 * t179
  t208 = params.c[30]
  t209 = params.c[31]
  t210 = t209 * t58
  t212 = params.c[32]
  t213 = t212 * t64
  t215 = params.c[33]
  t216 = t215 * t70
  t218 = t210 * t61 + t213 * t67 + t216 * t73 + t208
  t219 = t178 ** 2
  t220 = 0.1e1 / t219
  t222 = params.c[34]
  t223 = params.c[35]
  t224 = t223 * t58
  t226 = params.c[36]
  t227 = t226 * t64
  t229 = t224 * t61 + t227 * t67 + t222
  t230 = t229 * s0
  t231 = t109 * t220
  t234 = params.c[37]
  t235 = params.c[38]
  t236 = t235 * t58
  t238 = params.c[39]
  t239 = t238 * t64
  t241 = t236 * t61 + t239 * t67 + t234
  t243 = 0.1e1 / t219 / t178
  t245 = t44 + t59 * t61 + t65 * t67 + t71 * t73 + t77 * t79 + t83 * t85 + 0.4e-2 * t101 * t109 + 0.16e-4 * t124 * t131 + 0.64e-7 * t143 * t148 + t164 * t179 + 0.4e-2 * t192 * t193 + 0.16e-4 * t204 * t205 + t218 * t220 + 0.4e-2 * t230 * t231 + t241 * t243
  t251 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t252 = t42 ** 2
  t253 = 0.1e1 / t252
  t254 = t251 * t253
  t258 = t251 * t42
  t259 = t102 * r0
  t261 = 0.1e1 / t54 / t259
  t262 = t261 * t108
  t267 = 0.1e1 / t53 / t125 / t102
  t268 = t267 * t130
  t272 = 0.1e1 / t144 / r0
  t273 = t272 * t147
  t276 = t45 * tau0
  t277 = t104 * t61
  t280 = t88 * tau0
  t283 = t67 * tau0
  t284 = t283 * t104
  t287 = t91 * t58
  t290 = t73 * tau0
  t291 = t290 * t104
  t294 = t94 * t64
  t297 = t79 * tau0
  t298 = t297 * t104
  t301 = t97 * t70
  t304 = t85 * tau0
  t305 = t304 * t104
  t308 = 0.5e1 / 0.3e1 * t280 * t277 + 0.5e1 / 0.3e1 * t89 * t284 + 0.10e2 / 0.3e1 * t287 * t284 + 0.10e2 / 0.3e1 * t92 * t291 + 0.5e1 * t294 * t291 + 0.5e1 * t95 * t298 + 0.20e2 / 0.3e1 * t301 * t298 + 0.20e2 / 0.3e1 * t98 * t305
  t309 = t308 * s0
  t312 = t100 * t123
  t315 = t113 * tau0
  t320 = t116 * t58
  t325 = t119 * t64
  t330 = 0.5e1 / 0.3e1 * t315 * t277 + 0.5e1 / 0.3e1 * t114 * t284 + 0.10e2 / 0.3e1 * t320 * t284 + 0.10e2 / 0.3e1 * t117 * t291 + 0.5e1 * t325 * t291 + 0.5e1 * t120 * t298
  t331 = t330 * t123
  t334 = t122 * t142
  t337 = t135 * tau0
  t342 = t138 * t58
  t347 = 0.5e1 / 0.3e1 * t337 * t277 + 0.5e1 / 0.3e1 * t136 * t284 + 0.10e2 / 0.3e1 * t342 * t284 + 0.10e2 / 0.3e1 * t139 * t291
  t348 = t347 * t142
  t351 = t123 ** 2
  t352 = t141 * t351
  t353 = t144 * t259
  t356 = t129 ** 2
  t357 = 0.1e1 / t356
  t358 = 0.1e1 / t54 / t353 * t357
  t361 = t182 * tau0
  t366 = t185 * t58
  t371 = t188 * t64
  t376 = 0.5e1 / 0.3e1 * t361 * t277 + 0.5e1 / 0.3e1 * t183 * t284 + 0.10e2 / 0.3e1 * t366 * t284 + 0.10e2 / 0.3e1 * t186 * t291 + 0.5e1 * t371 * t291 + 0.5e1 * t189 * t298
  t377 = t376 * s0
  t380 = t191 * t123
  t381 = t268 * t179
  t384 = t197 * tau0
  t389 = t200 * t58
  t394 = 0.5e1 / 0.3e1 * t384 * t277 + 0.5e1 / 0.3e1 * t198 * t284 + 0.10e2 / 0.3e1 * t389 * t284 + 0.10e2 / 0.3e1 * t201 * t291
  t395 = t394 * t123
  t398 = t203 * t142
  t399 = t273 * t179
  t404 = t63 * t58
  t409 = t69 * t64
  t412 = -0.10666666666666666666666666666666666666666666666667e-1 * t101 * t262 - 0.85333333333333333333333333333333333333333333333333e-4 * t124 * t268 - 0.512e-6 * t143 * t273 + 0.5e1 / 0.3e1 * t276 * t277 + 0.4e-2 * t309 * t109 + 0.42666666666666666666666666666666666666666666666668e-4 * t312 * t268 + 0.16e-4 * t331 * t131 + 0.34133333333333333333333333333333333333333333333334e-6 * t334 * t273 + 0.64e-7 * t348 * t148 + 0.20480000000000000000000000000000000000000000000001e-8 * t352 * t358 + 0.4e-2 * t377 * t193 + 0.42666666666666666666666666666666666666666666666668e-4 * t380 * t381 + 0.16e-4 * t395 * t205 + 0.34133333333333333333333333333333333333333333333334e-6 * t398 * t399 + 0.5e1 / 0.3e1 * t59 * t284 + 0.10e2 / 0.3e1 * t404 * t284 + 0.10e2 / 0.3e1 * t65 * t291 + 0.5e1 * t409 * t291
  t415 = t75 * t70
  t420 = t81 * t76
  t424 = 0.1e1 / t78 / t66
  t425 = t424 * tau0
  t429 = t229 * t123
  t430 = t268 * t220
  t433 = t262 * t179
  t438 = t262 * t220
  t441 = t223 * tau0
  t446 = t226 * t58
  t451 = 0.5e1 / 0.3e1 * t441 * t277 + 0.5e1 / 0.3e1 * t224 * t284 + 0.10e2 / 0.3e1 * t446 * t284 + 0.10e2 / 0.3e1 * t227 * t291
  t452 = t451 * s0
  t455 = t152 * tau0
  t460 = t155 * t58
  t465 = t158 * t64
  t470 = t161 * t70
  t475 = 0.5e1 / 0.3e1 * t455 * t277 + 0.5e1 / 0.3e1 * t153 * t284 + 0.10e2 / 0.3e1 * t460 * t284 + 0.10e2 / 0.3e1 * t156 * t291 + 0.5e1 * t465 * t291 + 0.5e1 * t159 * t298 + 0.20e2 / 0.3e1 * t470 * t298 + 0.20e2 / 0.3e1 * t162 * t305
  t477 = t235 * tau0
  t482 = t238 * t58
  t487 = 0.5e1 / 0.3e1 * t477 * t277 + 0.5e1 / 0.3e1 * t236 * t284 + 0.10e2 / 0.3e1 * t482 * t284 + 0.10e2 / 0.3e1 * t239 * t291
  t489 = t209 * tau0
  t494 = t212 * t58
  t499 = t215 * t64
  t504 = 0.5e1 / 0.3e1 * t489 * t277 + 0.5e1 / 0.3e1 * t210 * t284 + 0.10e2 / 0.3e1 * t494 * t284 + 0.10e2 / 0.3e1 * t213 * t291 + 0.5e1 * t499 * t291 + 0.5e1 * t216 * t298
  t506 = t192 * t104
  t507 = t108 * t220
  t510 = 0.1e1 / t42 / t6 * t166
  t513 = t175 ** 2
  t514 = 0.1e1 / t513
  t515 = t173 ** 2
  t516 = 0.1e1 / t515
  t517 = t514 * t516
  t518 = f.my_piecewise5(t169, 0, t171, 0, t27)
  t519 = t517 * t518
  t522 = -0.13333333333333333333333333333333333333333333333333e0 * t510 * t175 - 0.13333333333333333333333333333333333333333333333333e0 * t167 * t519
  t523 = t507 * t522
  t526 = t204 * t128
  t527 = t130 * t220
  t528 = t527 * t522
  t531 = t230 * t104
  t532 = t108 * t243
  t533 = t532 * t522
  t536 = t219 ** 2
  t537 = 0.1e1 / t536
  t538 = t241 * t537
  t541 = t164 * t220
  t543 = t218 * t243
  t546 = 0.5e1 * t71 * t298 + 0.20e2 / 0.3e1 * t415 * t298 + 0.20e2 / 0.3e1 * t77 * t305 + 0.25e2 / 0.3e1 * t420 * t305 + 0.25e2 / 0.3e1 * t83 * t425 * t104 + 0.42666666666666666666666666666666666666666666666668e-4 * t429 * t430 - 0.10666666666666666666666666666666666666666666666667e-1 * t192 * t433 - 0.85333333333333333333333333333333333333333333333333e-4 * t204 * t381 - 0.10666666666666666666666666666666666666666666666667e-1 * t230 * t438 + 0.4e-2 * t452 * t231 + t475 * t179 + t487 * t243 + t504 * t220 - 0.4e-2 * t506 * t523 - 0.16e-4 * t526 * t528 - 0.8e-2 * t531 * t533 - 0.3e1 * t538 * t522 - t541 * t522 - 0.2e1 * t543 * t522
  t547 = t412 + t546
  t551 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t552 = t551 * f.p.zeta_threshold
  t554 = f.my_piecewise3(t20, t552, t21 * t19)
  t556 = 0.1e1 / t252 / t6
  t557 = t554 * t556
  t561 = t554 * t253
  t565 = t554 * t42
  t566 = t261 * t61
  t569 = tau0 ** 2
  t570 = t182 * t569
  t571 = t128 * t67
  t574 = t73 * t569
  t575 = t574 * t128
  t578 = t283 * t261
  t581 = t185 * t569
  t588 = t79 * t569
  t589 = t588 * t128
  t592 = t290 * t261
  t595 = t188 * t58
  t602 = t85 * t569
  t603 = t602 * t128
  t606 = t297 * t261
  t609 = -0.40e2 / 0.9e1 * t361 * t566 + 0.50e2 / 0.9e1 * t570 * t571 + 0.50e2 / 0.9e1 * t183 * t575 - 0.40e2 / 0.9e1 * t183 * t578 + 0.50e2 / 0.9e1 * t581 * t571 + 0.200e3 / 0.9e1 * t366 * t575 - 0.80e2 / 0.9e1 * t366 * t578 + 0.50e2 / 0.3e1 * t186 * t589 - 0.80e2 / 0.9e1 * t186 * t592 + 0.50e2 / 0.3e1 * t595 * t575 + 0.50e2 * t371 * t589 - 0.40e2 / 0.3e1 * t371 * t592 + 0.100e3 / 0.3e1 * t189 * t603 - 0.40e2 / 0.3e1 * t189 * t606
  t610 = t609 * s0
  t613 = t125 * t259
  t615 = 0.1e1 / t53 / t613
  t616 = t615 * t130
  t617 = t616 * t179
  t622 = t616 * t220
  t627 = t223 * t569
  t634 = t226 * t569
  t645 = -0.40e2 / 0.9e1 * t441 * t566 + 0.50e2 / 0.9e1 * t627 * t571 + 0.50e2 / 0.9e1 * t224 * t575 - 0.40e2 / 0.9e1 * t224 * t578 + 0.50e2 / 0.9e1 * t634 * t571 + 0.200e3 / 0.9e1 * t446 * t575 - 0.80e2 / 0.9e1 * t446 * t578 + 0.50e2 / 0.3e1 * t227 * t589 - 0.80e2 / 0.9e1 * t227 * t592
  t646 = t645 * s0
  t649 = t69 * t58
  t656 = t75 * t64
  t672 = t304 * t261
  t681 = 0.1e1 / t54 / t125
  t682 = t681 * t108
  t683 = t682 * t179
  t688 = t682 * t220
  t691 = -0.80e2 / 0.9e1 * t404 * t578 - 0.80e2 / 0.9e1 * t65 * t592 - 0.40e2 / 0.3e1 * t409 * t592 - 0.40e2 / 0.3e1 * t71 * t606 - 0.160e3 / 0.9e1 * t415 * t606 - 0.160e3 / 0.9e1 * t77 * t672 - 0.200e3 / 0.9e1 * t420 * t672 - 0.200e3 / 0.9e1 * t83 * t425 * t261 + 0.39111111111111111111111111111111111111111111111112e-1 * t192 * t683 + 0.54044444444444444444444444444444444444444444444444e-3 * t204 * t617 + 0.39111111111111111111111111111111111111111111111112e-1 * t230 * t688
  t693 = t424 * t569
  t694 = t693 * t128
  t697 = t81 * t70
  t703 = 0.1e1 / t78 / t72
  t704 = t703 * t569
  t710 = t197 * t569
  t717 = t200 * t569
  t728 = -0.40e2 / 0.9e1 * t384 * t566 + 0.50e2 / 0.9e1 * t710 * t571 + 0.50e2 / 0.9e1 * t198 * t575 - 0.40e2 / 0.9e1 * t198 * t578 + 0.50e2 / 0.9e1 * t717 * t571 + 0.200e3 / 0.9e1 * t389 * t575 - 0.80e2 / 0.9e1 * t389 * t578 + 0.50e2 / 0.3e1 * t201 * t589 - 0.80e2 / 0.9e1 * t201 * t592
  t729 = t728 * t123
  t732 = t376 * t123
  t735 = t191 * t142
  t737 = 0.1e1 / t144 / t102
  t738 = t737 * t147
  t739 = t738 * t179
  t742 = t451 * t123
  t745 = t229 * t142
  t746 = t738 * t220
  t751 = 0.1e1 / t42 / t24 * t166
  t757 = 0.1e1 / t513 / t174
  t758 = t515 ** 2
  t759 = 0.1e1 / t758
  t761 = t518 ** 2
  t762 = t757 * t759 * t761
  t766 = 0.1e1 / t515 / t173
  t768 = t514 * t766 * t761
  t771 = f.my_piecewise5(t169, 0, t171, 0, t36)
  t772 = t517 * t771
  t775 = 0.17777777777777777777777777777777777777777777777777e0 * t751 * t175 + 0.88888888888888888888888888888888888888888888888886e-1 * t510 * t519 - 0.88888888888888888888888888888888888888888888888887e-1 * t167 * t762 + 0.26666666666666666666666666666666666666666666666666e0 * t167 * t768 - 0.13333333333333333333333333333333333333333333333333e0 * t167 * t772
  t779 = 0.500e3 / 0.9e1 * t77 * t694 + 0.500e3 / 0.9e1 * t697 * t603 + 0.1250e4 / 0.9e1 * t420 * t694 + 0.250e3 / 0.3e1 * t83 * t704 * t128 + 0.16e-4 * t729 * t205 + 0.85333333333333333333333333333333333333333333333336e-4 * t732 * t381 + 0.91022222222222222222222222222222222222222222222228e-6 * t735 * t739 + 0.85333333333333333333333333333333333333333333333336e-4 * t742 * t430 + 0.91022222222222222222222222222222222222222222222228e-6 * t745 * t746 - t541 * t775 - 0.3e1 * t538 * t775
  t780 = t504 * t243
  t785 = t487 * t537
  t788 = t475 * t220
  t792 = 0.1e1 / t536 / t178
  t793 = t241 * t792
  t794 = t522 ** 2
  t797 = t164 * t243
  t800 = t218 * t537
  t805 = t135 * t569
  t812 = t138 * t569
  t823 = -0.40e2 / 0.9e1 * t337 * t566 + 0.50e2 / 0.9e1 * t805 * t571 + 0.50e2 / 0.9e1 * t136 * t575 - 0.40e2 / 0.9e1 * t136 * t578 + 0.50e2 / 0.9e1 * t812 * t571 + 0.200e3 / 0.9e1 * t342 * t575 - 0.80e2 / 0.9e1 * t342 * t578 + 0.50e2 / 0.3e1 * t139 * t589 - 0.80e2 / 0.9e1 * t139 * t592
  t824 = t823 * t142
  t827 = t347 * t351
  t830 = t351 * s0
  t831 = t141 * t830
  t836 = 0.1e1 / t356 / t107
  t837 = 0.1e1 / t53 / t144 / t613 * t836
  t842 = t88 * t569
  t849 = t91 * t569
  t860 = t94 * t58
  t871 = t97 * t64
  t882 = -0.40e2 / 0.9e1 * t280 * t566 + 0.50e2 / 0.9e1 * t842 * t571 + 0.50e2 / 0.9e1 * t89 * t575 - 0.40e2 / 0.9e1 * t89 * t578 + 0.50e2 / 0.9e1 * t849 * t571 + 0.200e3 / 0.9e1 * t287 * t575 - 0.80e2 / 0.9e1 * t287 * t578 + 0.50e2 / 0.3e1 * t92 * t589 - 0.80e2 / 0.9e1 * t92 * t592 + 0.50e2 / 0.3e1 * t860 * t575 + 0.50e2 * t294 * t589 - 0.40e2 / 0.3e1 * t294 * t592 + 0.100e3 / 0.3e1 * t95 * t603 - 0.40e2 / 0.3e1 * t95 * t606 + 0.100e3 / 0.3e1 * t871 * t589 + 0.800e3 / 0.9e1 * t301 * t603 - 0.160e3 / 0.9e1 * t301 * t606 + 0.500e3 / 0.9e1 * t98 * t694 - 0.160e3 / 0.9e1 * t98 * t672
  t883 = t882 * s0
  t886 = -0.4e1 * t780 * t522 - 0.2e1 * t543 * t775 - 0.6e1 * t785 * t522 - 0.2e1 * t788 * t522 + 0.12e2 * t793 * t794 + 0.2e1 * t797 * t794 + 0.6e1 * t800 * t794 + 0.64e-7 * t824 * t148 + 0.40960000000000000000000000000000000000000000000002e-8 * t827 * t358 + 0.87381333333333333333333333333333333333333333333340e-10 * t831 * t837 + 0.4e-2 * t883 * t109
  t889 = t308 * t123
  t892 = t100 * t142
  t897 = t113 * t569
  t904 = t116 * t569
  t915 = t119 * t58
  t926 = -0.40e2 / 0.9e1 * t315 * t566 + 0.50e2 / 0.9e1 * t897 * t571 + 0.50e2 / 0.9e1 * t114 * t575 - 0.40e2 / 0.9e1 * t114 * t578 + 0.50e2 / 0.9e1 * t904 * t571 + 0.200e3 / 0.9e1 * t320 * t575 - 0.80e2 / 0.9e1 * t320 * t578 + 0.50e2 / 0.3e1 * t117 * t589 - 0.80e2 / 0.9e1 * t117 * t592 + 0.50e2 / 0.3e1 * t915 * t575 + 0.50e2 * t325 * t589 - 0.40e2 / 0.3e1 * t325 * t592 + 0.100e3 / 0.3e1 * t120 * t603 - 0.40e2 / 0.3e1 * t120 * t606
  t927 = t926 * t123
  t942 = 0.1e1 / t54 / t144 / t125
  t943 = t942 * t357
  t950 = 0.85333333333333333333333333333333333333333333333336e-4 * t889 * t268 + 0.91022222222222222222222222222222222222222222222228e-6 * t892 * t738 + 0.16e-4 * t927 * t131 + 0.54044444444444444444444444444444444444444444444444e-3 * t124 * t616 + 0.4608e-5 * t143 * t738 - 0.40e2 / 0.9e1 * t276 * t566 + 0.39111111111111111111111111111111111111111111111112e-1 * t101 * t682 - 0.1024e-5 * t348 * t273 - 0.40277333333333333333333333333333333333333333333336e-7 * t352 * t943 - 0.17066666666666666666666666666666666666666666666667e-3 * t331 * t268 - 0.48924444444444444444444444444444444444444444444446e-5 * t334 * t738
  t955 = t45 * t569
  t958 = t63 * t569
  t961 = t330 * t142
  t964 = t122 * t351
  t975 = t394 * t142
  t978 = -0.21333333333333333333333333333333333333333333333334e-1 * t309 * t262 - 0.38400000000000000000000000000000000000000000000001e-3 * t312 * t616 + 0.50e2 / 0.9e1 * t955 * t571 + 0.50e2 / 0.9e1 * t958 * t571 + 0.68266666666666666666666666666666666666666666666668e-6 * t961 * t273 + 0.10922666666666666666666666666666666666666666666667e-7 * t964 * t943 - 0.17066666666666666666666666666666666666666666666667e-3 * t395 * t381 - 0.48924444444444444444444444444444444444444444444446e-5 * t398 * t739 - 0.40e2 / 0.9e1 * t59 * t578 - 0.21333333333333333333333333333333333333333333333334e-1 * t377 * t433 + 0.68266666666666666666666666666666666666666666666668e-6 * t975 * t399
  t980 = t203 * t351
  t981 = t943 * t179
  t992 = t209 * t569
  t999 = t212 * t569
  t1010 = t215 * t58
  t1021 = -0.40e2 / 0.9e1 * t489 * t566 + 0.50e2 / 0.9e1 * t992 * t571 + 0.50e2 / 0.9e1 * t210 * t575 - 0.40e2 / 0.9e1 * t210 * t578 + 0.50e2 / 0.9e1 * t999 * t571 + 0.200e3 / 0.9e1 * t494 * t575 - 0.80e2 / 0.9e1 * t494 * t578 + 0.50e2 / 0.3e1 * t213 * t589 - 0.80e2 / 0.9e1 * t213 * t592 + 0.50e2 / 0.3e1 * t1010 * t575 + 0.50e2 * t499 * t589 - 0.40e2 / 0.3e1 * t499 * t592 + 0.100e3 / 0.3e1 * t216 * t603 - 0.40e2 / 0.3e1 * t216 * t606
  t1025 = t235 * t569
  t1032 = t238 * t569
  t1043 = -0.40e2 / 0.9e1 * t477 * t566 + 0.50e2 / 0.9e1 * t1025 * t571 + 0.50e2 / 0.9e1 * t236 * t575 - 0.40e2 / 0.9e1 * t236 * t578 + 0.50e2 / 0.9e1 * t1032 * t571 + 0.200e3 / 0.9e1 * t482 * t575 - 0.80e2 / 0.9e1 * t482 * t578 + 0.50e2 / 0.3e1 * t239 * t589 - 0.80e2 / 0.9e1 * t239 * t592
  t1047 = t152 * t569
  t1054 = t155 * t569
  t1065 = t158 * t58
  t1076 = t161 * t64
  t1087 = -0.40e2 / 0.9e1 * t455 * t566 + 0.50e2 / 0.9e1 * t1047 * t571 + 0.50e2 / 0.9e1 * t153 * t575 - 0.40e2 / 0.9e1 * t153 * t578 + 0.50e2 / 0.9e1 * t1054 * t571 + 0.200e3 / 0.9e1 * t460 * t575 - 0.80e2 / 0.9e1 * t460 * t578 + 0.50e2 / 0.3e1 * t156 * t589 - 0.80e2 / 0.9e1 * t156 * t592 + 0.50e2 / 0.3e1 * t1065 * t575 + 0.50e2 * t465 * t589 - 0.40e2 / 0.3e1 * t465 * t592 + 0.100e3 / 0.3e1 * t159 * t603 - 0.40e2 / 0.3e1 * t159 * t606 + 0.100e3 / 0.3e1 * t1076 * t589 + 0.800e3 / 0.9e1 * t470 * t603 - 0.160e3 / 0.9e1 * t470 * t606 + 0.500e3 / 0.9e1 * t162 * t694 - 0.160e3 / 0.9e1 * t162 * t672
  t1089 = t377 * t104
  t1092 = t380 * t267
  t1095 = t532 * t794
  t1098 = t130 * t243
  t1099 = t1098 * t794
  t1102 = 0.10922666666666666666666666666666666666666666666667e-7 * t980 * t981 + 0.50e2 / 0.9e1 * t59 * t575 + 0.200e3 / 0.9e1 * t404 * t575 + 0.50e2 / 0.3e1 * t65 * t589 + t1021 * t220 + t1043 * t243 + t1087 * t179 - 0.8e-2 * t1089 * t523 - 0.85333333333333333333333333333333333333333333333336e-4 * t1092 * t528 + 0.8e-2 * t506 * t1095 + 0.32e-4 * t526 * t1099
  t1103 = t108 * t537
  t1104 = t1103 * t794
  t1107 = t395 * t128
  t1110 = t398 * t272
  t1111 = t147 * t220
  t1112 = t1111 * t522
  t1115 = t192 * t261
  t1118 = t204 * t267
  t1121 = t230 * t261
  t1124 = t452 * t104
  t1127 = t527 * t775
  t1130 = t532 * t775
  t1133 = t507 * t775
  t1136 = t429 * t267
  t1137 = t1098 * t522
  t1140 = 0.24e-1 * t531 * t1104 - 0.32e-4 * t1107 * t528 - 0.68266666666666666666666666666666666666666666666668e-6 * t1110 * t1112 + 0.21333333333333333333333333333333333333333333333334e-1 * t1115 * t523 + 0.17066666666666666666666666666666666666666666666667e-3 * t1118 * t528 + 0.42666666666666666666666666666666666666666666666667e-1 * t1121 * t533 - 0.16e-1 * t1124 * t533 - 0.16e-4 * t526 * t1127 - 0.8e-2 * t531 * t1130 - 0.4e-2 * t506 * t1133 - 0.17066666666666666666666666666666666666666666666667e-3 * t1136 * t1137
  t1143 = 0.4e-2 * t610 * t193 - 0.38400000000000000000000000000000000000000000000001e-3 * t380 * t617 - 0.21333333333333333333333333333333333333333333333334e-1 * t452 * t438 - 0.38400000000000000000000000000000000000000000000001e-3 * t429 * t622 + 0.4e-2 * t646 * t231 + 0.50e2 / 0.3e1 * t649 * t575 + 0.50e2 * t409 * t589 + 0.100e3 / 0.3e1 * t71 * t603 + 0.100e3 / 0.3e1 * t656 * t589 + 0.800e3 / 0.9e1 * t415 * t603 + t691 + t779 + t886 + t950 + t978 + t1102 + t1140
  t1148 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t245 - t5 * t254 * t245 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t258 * t547 + t5 * t557 * t245 / 0.12e2 - t5 * t561 * t547 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t565 * t1143)
  t1150 = r1 <= f.p.dens_threshold
  t1151 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t1152 = 0.1e1 + t1151
  t1153 = t1152 <= f.p.zeta_threshold
  t1154 = t1152 ** (0.1e1 / 0.3e1)
  t1155 = t1154 ** 2
  t1156 = 0.1e1 / t1155
  t1157 = -t27
  t1158 = f.my_piecewise5(t14, 0, t10, 0, t1157)
  t1159 = t1158 ** 2
  t1162 = -t36
  t1163 = f.my_piecewise5(t14, 0, t10, 0, t1162)
  t1167 = f.my_piecewise3(t1153, 0, 0.4e1 / 0.9e1 * t1156 * t1159 + 0.4e1 / 0.3e1 * t1154 * t1163)
  t1168 = t1167 * t42
  t1169 = r1 ** (0.1e1 / 0.3e1)
  t1170 = t1169 ** 2
  t1173 = tau1 / t1170 / r1
  t1174 = t52 - t1173
  t1176 = t52 + t1173
  t1177 = 0.1e1 / t1176
  t1179 = t1174 ** 2
  t1181 = t1176 ** 2
  t1182 = 0.1e1 / t1181
  t1184 = t1179 * t1174
  t1187 = 0.1e1 / t1181 / t1176
  t1189 = t1179 ** 2
  t1191 = t1181 ** 2
  t1192 = 0.1e1 / t1191
  t1209 = r1 ** 2
  t1211 = 0.1e1 / t1170 / t1209
  t1214 = 0.1e1 + 0.4e-2 * s2 * t1211
  t1215 = 0.1e1 / t1214
  t1216 = t1211 * t1215
  t1226 = s2 ** 2
  t1228 = t1209 ** 2
  t1231 = 0.1e1 / t1169 / t1228 / r1
  t1232 = t1214 ** 2
  t1233 = 0.1e1 / t1232
  t1234 = t1231 * t1233
  t1244 = t1228 ** 2
  t1259 = t152 * t1174 * t1177 + t155 * t1179 * t1182 + t158 * t1184 * t1187 + t161 * t1189 * t1192 + t151
  t1260 = f.my_piecewise5(t171, t11, t169, t15, -t17)
  t1261 = 0.1e1 + t1260
  t1262 = 0.1e1 / t1261
  t1263 = t1262 ** (0.1e1 / 0.3e1)
  t1266 = 0.1e1 + 0.39999999999999999999999999999999999999999999999998e0 * t167 * t1263
  t1267 = 0.1e1 / t1266
  t1276 = (t182 * t1174 * t1177 + t185 * t1179 * t1182 + t188 * t1184 * t1187 + t181) * s2
  t1285 = (t197 * t1174 * t1177 + t200 * t1179 * t1182 + t196) * t1226
  t1295 = t209 * t1174 * t1177 + t212 * t1179 * t1182 + t215 * t1184 * t1187 + t208
  t1296 = t1266 ** 2
  t1297 = 0.1e1 / t1296
  t1304 = (t223 * t1174 * t1177 + t226 * t1179 * t1182 + t222) * s2
  t1312 = t235 * t1174 * t1177 + t238 * t1179 * t1182 + t234
  t1314 = 0.1e1 / t1296 / t1266
  t1316 = t44 + t45 * t1174 * t1177 + t63 * t1179 * t1182 + t69 * t1184 * t1187 + t75 * t1189 * t1192 + t81 * t1189 * t1174 / t1191 / t1176 + 0.4e-2 * (t88 * t1174 * t1177 + t91 * t1179 * t1182 + t94 * t1184 * t1187 + t97 * t1189 * t1192 + t87) * s2 * t1216 + 0.16e-4 * (t113 * t1174 * t1177 + t116 * t1179 * t1182 + t119 * t1184 * t1187 + t112) * t1226 * t1234 + 0.64e-7 * (t135 * t1174 * t1177 + t138 * t1179 * t1182 + t134) * t1226 * s2 / t1244 / t1232 / t1214 + t1259 * t1267 + 0.4e-2 * t1276 * t1216 * t1267 + 0.16e-4 * t1285 * t1234 * t1267 + t1295 * t1297 + 0.4e-2 * t1304 * t1216 * t1297 + t1312 * t1314
  t1322 = f.my_piecewise3(t1153, 0, 0.4e1 / 0.3e1 * t1154 * t1158)
  t1323 = t1322 * t253
  t1327 = t1322 * t42
  t1328 = t1259 * t1297
  t1331 = t1263 ** 2
  t1332 = 0.1e1 / t1331
  t1333 = t1261 ** 2
  t1334 = 0.1e1 / t1333
  t1335 = t1332 * t1334
  t1336 = f.my_piecewise5(t171, 0, t169, 0, t1157)
  t1337 = t1335 * t1336
  t1340 = -0.13333333333333333333333333333333333333333333333333e0 * t510 * t1263 - 0.13333333333333333333333333333333333333333333333333e0 * t167 * t1337
  t1342 = t1276 * t1211
  t1343 = t1215 * t1297
  t1347 = t1285 * t1231
  t1348 = t1233 * t1297
  t1352 = t1295 * t1314
  t1355 = t1304 * t1211
  t1356 = t1215 * t1314
  t1360 = t1296 ** 2
  t1361 = 0.1e1 / t1360
  t1362 = t1312 * t1361
  t1365 = -t1328 * t1340 - 0.4e-2 * t1342 * t1343 * t1340 - 0.16e-4 * t1347 * t1348 * t1340 - 0.2e1 * t1352 * t1340 - 0.8e-2 * t1355 * t1356 * t1340 - 0.3e1 * t1362 * t1340
  t1370 = f.my_piecewise3(t1153, t552, t1154 * t1152)
  t1371 = t1370 * t556
  t1375 = t1370 * t253
  t1379 = t1370 * t42
  t1380 = t1259 * t1314
  t1381 = t1340 ** 2
  t1389 = 0.1e1 / t1331 / t1262
  t1390 = t1333 ** 2
  t1391 = 0.1e1 / t1390
  t1393 = t1336 ** 2
  t1394 = t1389 * t1391 * t1393
  t1398 = 0.1e1 / t1333 / t1261
  t1400 = t1332 * t1398 * t1393
  t1403 = f.my_piecewise5(t171, 0, t169, 0, t1162)
  t1404 = t1335 * t1403
  t1407 = 0.17777777777777777777777777777777777777777777777777e0 * t751 * t1263 + 0.88888888888888888888888888888888888888888888888886e-1 * t510 * t1337 - 0.88888888888888888888888888888888888888888888888887e-1 * t167 * t1394 + 0.26666666666666666666666666666666666666666666666666e0 * t167 * t1400 - 0.13333333333333333333333333333333333333333333333333e0 * t167 * t1404
  t1415 = t1233 * t1314
  t1422 = t1295 * t1361
  t1427 = t1215 * t1361
  t1435 = 0.1e1 / t1360 / t1266
  t1436 = t1312 * t1435
  t1441 = 0.2e1 * t1380 * t1381 - t1328 * t1407 + 0.8e-2 * t1342 * t1356 * t1381 - 0.4e-2 * t1342 * t1343 * t1407 + 0.32e-4 * t1347 * t1415 * t1381 - 0.16e-4 * t1347 * t1348 * t1407 + 0.6e1 * t1422 * t1381 - 0.2e1 * t1352 * t1407 + 0.24e-1 * t1355 * t1427 * t1381 - 0.8e-2 * t1355 * t1356 * t1407 + 0.12e2 * t1436 * t1381 - 0.3e1 * t1362 * t1407
  t1446 = f.my_piecewise3(t1150, 0, -0.3e1 / 0.8e1 * t5 * t1168 * t1316 - t5 * t1323 * t1316 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t1327 * t1365 + t5 * t1371 * t1316 / 0.12e2 - t5 * t1375 * t1365 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t1379 * t1441)
  t1456 = t24 ** 2
  t1460 = 0.6e1 * t33 - 0.6e1 * t16 / t1456
  t1461 = f.my_piecewise5(t10, 0, t14, 0, t1460)
  t1465 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t1461)
  t1488 = 0.1e1 / t252 / t24
  t1503 = 0.1e1 / t53 / t144 * t130
  t1504 = t1503 * t179
  t1507 = t78 ** 2
  t1509 = t569 * tau0
  t1514 = t574 * t267
  t1518 = 0.1e1 / t353 * t147
  t1522 = t681 * t61
  t1525 = t267 * t67
  t1529 = t145 * t73
  t1533 = t79 * t1509 * t145
  t1538 = t283 * t681
  t1553 = t85 * t1509 * t145
  t1556 = t588 * t267
  t1559 = t290 * t681
  t1562 = 0.440e3 / 0.27e2 * t441 * t1522 - 0.400e3 / 0.9e1 * t627 * t1525 + 0.250e3 / 0.9e1 * t223 * t1509 * t1529 + 0.250e3 / 0.9e1 * t224 * t1533 - 0.400e3 / 0.9e1 * t224 * t1514 + 0.440e3 / 0.27e2 * t224 * t1538 - 0.400e3 / 0.9e1 * t634 * t1525 + 0.500e3 / 0.9e1 * t226 * t1509 * t1529 + 0.500e3 / 0.3e1 * t446 * t1533 - 0.1600e4 / 0.9e1 * t446 * t1514 + 0.880e3 / 0.27e2 * t446 * t1538 + 0.1000e4 / 0.9e1 * t227 * t1553 - 0.400e3 / 0.3e1 * t227 * t1556 + 0.880e3 / 0.27e2 * t227 * t1559
  t1575 = t424 * t1509 * t145
  t1588 = t602 * t267
  t1591 = 0.500e3 / 0.3e1 * t366 * t1533 + 0.1000e4 / 0.9e1 * t186 * t1553 + 0.250e3 * t595 * t1533 + 0.500e3 * t371 * t1553 + 0.2500e4 / 0.9e1 * t189 * t1575 + 0.440e3 / 0.27e2 * t361 * t1522 + 0.250e3 / 0.9e1 * t183 * t1533 - 0.400e3 / 0.9e1 * t581 * t1525 - 0.400e3 * t371 * t1556 + 0.440e3 / 0.9e1 * t371 * t1559 - 0.800e3 / 0.3e1 * t189 * t1588
  t1592 = t297 * t681
  t1620 = 0.440e3 / 0.9e1 * t189 * t1592 - 0.400e3 / 0.9e1 * t183 * t1514 + 0.440e3 / 0.27e2 * t183 * t1538 - 0.1600e4 / 0.9e1 * t366 * t1514 + 0.880e3 / 0.27e2 * t366 * t1538 - 0.400e3 / 0.3e1 * t186 * t1556 + 0.880e3 / 0.27e2 * t186 * t1559 - 0.400e3 / 0.3e1 * t595 * t1514 - 0.400e3 / 0.9e1 * t570 * t1525 + 0.250e3 / 0.9e1 * t182 * t1509 * t1529 + 0.500e3 / 0.9e1 * t185 * t1509 * t1529 + 0.250e3 / 0.9e1 * t188 * t1509 * t1529
  t1629 = t144 ** 2
  t1632 = 0.1e1 / t53 / t1629 * t836
  t1653 = 0.1e1 / t54 / t144 / t126 * t357
  t1681 = -0.400e3 / 0.9e1 * t897 * t1525 + 0.250e3 / 0.9e1 * t113 * t1509 * t1529 + 0.500e3 / 0.9e1 * t116 * t1509 * t1529 + 0.250e3 / 0.9e1 * t119 * t1509 * t1529 - 0.400e3 / 0.3e1 * t117 * t1556 + 0.880e3 / 0.27e2 * t117 * t1559 - 0.400e3 / 0.3e1 * t915 * t1514 - 0.400e3 * t325 * t1556 + 0.440e3 / 0.9e1 * t325 * t1559 - 0.800e3 / 0.3e1 * t120 * t1588 + 0.440e3 / 0.9e1 * t120 * t1592
  t1706 = -0.400e3 / 0.9e1 * t114 * t1514 + 0.440e3 / 0.27e2 * t114 * t1538 - 0.1600e4 / 0.9e1 * t320 * t1514 + 0.880e3 / 0.27e2 * t320 * t1538 + 0.1000e4 / 0.9e1 * t117 * t1553 + 0.250e3 * t915 * t1533 + 0.500e3 * t325 * t1553 + 0.2500e4 / 0.9e1 * t120 * t1575 + 0.440e3 / 0.27e2 * t315 * t1522 + 0.250e3 / 0.9e1 * t114 * t1533 - 0.400e3 / 0.9e1 * t904 * t1525 + 0.500e3 / 0.3e1 * t320 * t1533
  t1716 = t522 * t775
  t1719 = -0.32000000000000000000000000000000000000000000000001e-1 * t610 * t433 + 0.32331851851851851851851851851851851851851851851853e-2 * t380 * t1504 + 0.8750e4 / 0.9e1 * t83 / t1507 * t1509 * t145 - 0.400e3 / 0.9e1 * t59 * t1514 - 0.17294222222222222222222222222222222222222222222223e-4 * t745 * t1518 * t220 + 0.4e-2 * t1562 * s0 * t231 + 0.4e-2 * (t1591 + t1620) * s0 * t193 - 0.25600000000000000000000000000000000000000000000000e-3 * t927 * t268 - 0.12083200000000000000000000000000000000000000000001e-6 * t827 * t943 - 0.30583466666666666666666666666666666666666666666669e-8 * t831 * t1632 - 0.1536e-5 * t824 * t273 + 0.500e3 / 0.9e1 * t63 * t1509 * t1529 + 0.10240000000000000000000000000000000000000000000000e-5 * t926 * t142 * t273 + 0.12800000000000000000000000000000000000000000000000e-3 * t882 * t123 * t268 + 0.27306666666666666666666666666666666666666666666669e-5 * t308 * t142 * t738 + 0.29127111111111111111111111111111111111111111111114e-7 * t100 * t351 * t1653 + 0.16e-4 * (t1681 + t1706) * t123 * t131 + 0.16213333333333333333333333333333333333333333333333e-2 * t331 * t616 + 0.32768000000000000000000000000000000000000000000001e-7 * t330 * t351 * t943 + 0.6e1 * t797 * t1716
  t1741 = 0.1e1 / t54 / t126 * t108
  t1787 = 0.440e3 / 0.27e2 * t337 * t1522 - 0.400e3 / 0.9e1 * t805 * t1525 + 0.250e3 / 0.9e1 * t135 * t1509 * t1529 + 0.250e3 / 0.9e1 * t136 * t1533 - 0.400e3 / 0.9e1 * t136 * t1514 + 0.440e3 / 0.27e2 * t136 * t1538 - 0.400e3 / 0.9e1 * t812 * t1525 + 0.500e3 / 0.9e1 * t138 * t1509 * t1529 + 0.500e3 / 0.3e1 * t342 * t1533 - 0.1600e4 / 0.9e1 * t342 * t1514 + 0.880e3 / 0.27e2 * t342 * t1538 + 0.1000e4 / 0.9e1 * t139 * t1553 - 0.400e3 / 0.3e1 * t139 * t1556 + 0.880e3 / 0.27e2 * t139 * t1559
  t1831 = t703 * t1509 * t145
  t1844 = 0.250e3 / 0.9e1 * t88 * t1509 * t1529 + 0.500e3 / 0.9e1 * t91 * t1509 * t1529 + 0.250e3 / 0.9e1 * t94 * t1509 * t1529 - 0.400e3 / 0.9e1 * t842 * t1525 + 0.440e3 / 0.27e2 * t280 * t1522 - 0.400e3 / 0.9e1 * t849 * t1525 + 0.2500e4 / 0.9e1 * t95 * t1575 + 0.1000e4 / 0.9e1 * t97 * t58 * t1533 + 0.2000e4 / 0.3e1 * t871 * t1553 + 0.10000e5 / 0.9e1 * t301 * t1575 + 0.5000e4 / 0.9e1 * t98 * t1831 + 0.250e3 / 0.9e1 * t89 * t1533 + 0.500e3 / 0.3e1 * t287 * t1533 + 0.440e3 / 0.9e1 * t294 * t1559 - 0.800e3 / 0.3e1 * t95 * t1588 + 0.440e3 / 0.9e1 * t95 * t1592
  t1851 = t693 * t267
  t1854 = t304 * t681
  t1879 = -0.800e3 / 0.3e1 * t871 * t1556 - 0.6400e4 / 0.9e1 * t301 * t1588 + 0.1760e4 / 0.27e2 * t301 * t1592 - 0.4000e4 / 0.9e1 * t98 * t1851 + 0.1760e4 / 0.27e2 * t98 * t1854 - 0.400e3 / 0.9e1 * t89 * t1514 + 0.440e3 / 0.27e2 * t89 * t1538 - 0.1600e4 / 0.9e1 * t287 * t1514 + 0.880e3 / 0.27e2 * t287 * t1538 - 0.400e3 / 0.3e1 * t92 * t1556 + 0.880e3 / 0.27e2 * t92 * t1559 - 0.400e3 / 0.3e1 * t860 * t1514 - 0.400e3 * t294 * t1556 + 0.1000e4 / 0.9e1 * t92 * t1553 + 0.250e3 * t860 * t1533 + 0.500e3 * t294 * t1553
  t1886 = -0.32000000000000000000000000000000000000000000000001e-1 * t883 * t262 - 0.11520000000000000000000000000000000000000000000000e-2 * t889 * t616 - 0.17294222222222222222222222222222222222222222222223e-4 * t892 * t1518 + 0.250e3 / 0.9e1 * t45 * t1509 * t1529 + 0.46603377777777777777777777777777777777777777777781e-9 * t122 * t830 * t1632 + 0.64e-7 * t1787 * t142 * t148 + 0.61440000000000000000000000000000000000000000000003e-8 * t823 * t351 * t358 + 0.26214400000000000000000000000000000000000000000002e-9 * t347 * t830 * t837 + 0.46603377777777777777777777777777777777777777777783e-11 * t141 * t351 * t123 / t1629 / t259 / t356 / t129 + 0.4e-2 * (t1844 + t1879) * s0 * t109 - 0.14677333333333333333333333333333333333333333333334e-4 * t961 * t738
  t1905 = t130 * t537
  t1916 = 0.1e1 / t42 / t32 * t166
  t1932 = t761 * t518
  t1956 = f.my_piecewise5(t169, 0, t171, 0, t1460)
  t1960 = -0.41481481481481481481481481481481481481481481481480e0 * t1916 * t175 - 0.17777777777777777777777777777777777777777777777777e0 * t751 * t519 + 0.88888888888888888888888888888888888888888888888886e-1 * t510 * t762 - 0.26666666666666666666666666666666666666666666666666e0 * t510 * t768 + 0.13333333333333333333333333333333333333333333333333e0 * t510 * t772 - 0.14814814814814814814814814814814814814814814814815e0 * t167 / t513 / t516 / t758 / t515 * t1932 + 0.53333333333333333333333333333333333333333333333332e0 * t167 * t757 / t758 / t173 * t1932 - 0.26666666666666666666666666666666666666666666666666e0 * t167 * t757 * t759 * t518 * t771 - 0.79999999999999999999999999999999999999999999999998e0 * t167 * t514 * t759 * t1932 + 0.79999999999999999999999999999999999999999999999998e0 * t167 * t514 * t766 * t518 * t771 - 0.13333333333333333333333333333333333333333333333333e0 * t167 * t517 * t1956
  t1974 = t794 * t522
  t1989 = -0.24e-1 * t1124 * t1130 - 0.8e-2 * t531 * t532 * t1960 - 0.24e-1 * t646 * t104 * t533 - 0.12e-1 * t610 * t104 * t523 + 0.11520000000000000000000000000000000000000000000000e-2 * t380 * t615 * t528 - 0.96e-1 * t531 * t108 * t792 * t1974 + 0.24e-1 * t1089 * t1095 + 0.25600000000000000000000000000000000000000000000001e-3 * t1092 * t1099 - 0.64000000000000000000000000000000000000000000000001e-1 * t1115 * t1095 - 0.24e-1 * t506 * t1103 * t1974 - 0.51200000000000000000000000000000000000000000000001e-3 * t1118 * t1099
  t1994 = t147 * t243
  t2053 = 0.440e3 / 0.27e2 * t477 * t1522 - 0.400e3 / 0.9e1 * t1025 * t1525 + 0.250e3 / 0.9e1 * t235 * t1509 * t1529 + 0.250e3 / 0.9e1 * t236 * t1533 - 0.400e3 / 0.9e1 * t236 * t1514 + 0.440e3 / 0.27e2 * t236 * t1538 - 0.400e3 / 0.9e1 * t1032 * t1525 + 0.500e3 / 0.9e1 * t238 * t1509 * t1529 + 0.500e3 / 0.3e1 * t482 * t1533 - 0.1600e4 / 0.9e1 * t482 * t1514 + 0.880e3 / 0.27e2 * t482 * t1538 + 0.1000e4 / 0.9e1 * t239 * t1553 - 0.400e3 / 0.3e1 * t239 * t1556 + 0.880e3 / 0.27e2 * t239 * t1559
  t2083 = 0.12800000000000000000000000000000000000000000000000e0 * t452 * t261 * t533 + t2053 * t243 + 0.14677333333333333333333333333333333333333333333334e-4 * t398 * t737 * t1112 - 0.11733333333333333333333333333333333333333333333334e0 * t192 * t681 * t523 - 0.16213333333333333333333333333333333333333333333333e-2 * t204 * t615 * t528 - 0.23466666666666666666666666666666666666666666666667e0 * t230 * t681 * t533 - 0.27306666666666666666666666666666666666666666666669e-5 * t735 * t737 * t1112 - 0.51200000000000000000000000000000000000000000000001e-3 * t742 * t267 * t1137 - 0.54613333333333333333333333333333333333333333333337e-5 * t745 * t737 * t1994 * t522 - 0.48e-4 * t729 * t128 * t528 - 0.25600000000000000000000000000000000000000000000001e-3 * t732 * t267 * t528
  t2155 = 0.440e3 / 0.9e1 * t159 * t1592 - 0.800e3 / 0.3e1 * t1076 * t1556 - 0.6400e4 / 0.9e1 * t470 * t1588 + 0.1760e4 / 0.27e2 * t470 * t1592 - 0.4000e4 / 0.9e1 * t162 * t1851 + 0.1760e4 / 0.27e2 * t162 * t1854 - 0.400e3 / 0.9e1 * t153 * t1514 + 0.440e3 / 0.27e2 * t153 * t1538 - 0.1600e4 / 0.9e1 * t460 * t1514 + 0.880e3 / 0.27e2 * t460 * t1538 - 0.400e3 / 0.3e1 * t156 * t1556 + 0.880e3 / 0.27e2 * t156 * t1559 - 0.400e3 / 0.3e1 * t1065 * t1514 - 0.400e3 * t465 * t1556 + 0.2500e4 / 0.9e1 * t159 * t1575 + 0.1000e4 / 0.9e1 * t161 * t58 * t1533
  t2191 = 0.2000e4 / 0.3e1 * t1076 * t1553 + 0.10000e5 / 0.9e1 * t470 * t1575 + 0.5000e4 / 0.9e1 * t162 * t1831 + 0.250e3 / 0.9e1 * t153 * t1533 + 0.500e3 / 0.3e1 * t460 * t1533 + 0.1000e4 / 0.9e1 * t156 * t1553 + 0.250e3 * t1065 * t1533 + 0.500e3 * t465 * t1553 + 0.440e3 / 0.9e1 * t465 * t1559 - 0.800e3 / 0.3e1 * t159 * t1588 - 0.400e3 / 0.9e1 * t1054 * t1525 + 0.440e3 / 0.27e2 * t455 * t1522 - 0.400e3 / 0.9e1 * t1047 * t1525 + 0.250e3 / 0.9e1 * t152 * t1509 * t1529 + 0.500e3 / 0.9e1 * t155 * t1509 * t1529 + 0.250e3 / 0.9e1 * t158 * t1509 * t1529
  t2240 = 0.440e3 / 0.27e2 * t384 * t1522 - 0.400e3 / 0.9e1 * t710 * t1525 + 0.250e3 / 0.9e1 * t197 * t1509 * t1529 + 0.250e3 / 0.9e1 * t198 * t1533 - 0.400e3 / 0.9e1 * t198 * t1514 + 0.440e3 / 0.27e2 * t198 * t1538 - 0.400e3 / 0.9e1 * t717 * t1525 + 0.500e3 / 0.9e1 * t200 * t1509 * t1529 + 0.500e3 / 0.3e1 * t389 * t1533 - 0.1600e4 / 0.9e1 * t389 * t1514 + 0.880e3 / 0.27e2 * t389 * t1538 + 0.1000e4 / 0.9e1 * t201 * t1553 - 0.400e3 / 0.3e1 * t201 * t1556 + 0.880e3 / 0.27e2 * t201 * t1559
  t2244 = -0.9e1 * t785 * t775 - 0.3e1 * t788 * t775 - 0.2e1 * t543 * t1960 + (t2155 + t2191) * t179 + 0.12800000000000000000000000000000000000000000000000e-3 * t609 * t123 * t381 + 0.32768000000000000000000000000000000000000000000001e-7 * t394 * t351 * t981 + 0.46603377777777777777777777777777777777777777777781e-9 * t203 * t830 * t1632 * t179 + 0.250e3 / 0.9e1 * t59 * t1533 + 0.500e3 / 0.3e1 * t404 * t1533 + 0.1000e4 / 0.9e1 * t65 * t1553 + 0.16e-4 * t2240 * t123 * t205
  t2272 = t1518 * t179
  t2294 = 0.440e3 / 0.27e2 * t59 * t1538 - 0.11520000000000000000000000000000000000000000000000e-2 * t732 * t617 - 0.17294222222222222222222222222222222222222222222223e-4 * t735 * t2272 - 0.32000000000000000000000000000000000000000000000001e-1 * t646 * t438 - 0.11520000000000000000000000000000000000000000000000e-2 * t742 * t622 + 0.10240000000000000000000000000000000000000000000000e-5 * t728 * t142 * t399 + 0.12800000000000000000000000000000000000000000000000e-3 * t645 * t123 * t430 + 0.250e3 * t649 * t1533 + 0.500e3 * t409 * t1553 + 0.2500e4 / 0.9e1 * t71 * t1575 + 0.1000e4 / 0.9e1 * t75 * t58 * t1533
  t2356 = 0.250e3 * t1010 * t1533 + 0.500e3 * t499 * t1553 + 0.2500e4 / 0.9e1 * t216 * t1575 + 0.440e3 / 0.9e1 * t499 * t1559 - 0.800e3 / 0.3e1 * t216 * t1588 + 0.440e3 / 0.9e1 * t216 * t1592 - 0.400e3 / 0.9e1 * t210 * t1514 + 0.440e3 / 0.27e2 * t210 * t1538 - 0.1600e4 / 0.9e1 * t494 * t1514 + 0.880e3 / 0.27e2 * t494 * t1538 - 0.400e3 / 0.3e1 * t213 * t1556
  t2384 = 0.880e3 / 0.27e2 * t213 * t1559 - 0.400e3 / 0.3e1 * t1010 * t1514 - 0.400e3 * t499 * t1556 + 0.440e3 / 0.27e2 * t489 * t1522 + 0.250e3 / 0.9e1 * t210 * t1533 - 0.400e3 / 0.9e1 * t999 * t1525 + 0.500e3 / 0.3e1 * t494 * t1533 + 0.1000e4 / 0.9e1 * t213 * t1553 - 0.400e3 / 0.9e1 * t992 * t1525 + 0.250e3 / 0.9e1 * t209 * t1509 * t1529 + 0.500e3 / 0.9e1 * t212 * t1509 * t1529 + 0.250e3 / 0.9e1 * t215 * t1509 * t1529
  t2396 = 0.1760e4 / 0.27e2 * t77 * t1854 + 0.2200e4 / 0.27e2 * t420 * t1854 + 0.2200e4 / 0.27e2 * t83 * t425 * t681 - 0.18251851851851851851851851851851851851851851851852e0 * t192 * t1741 * t179 - 0.39632592592592592592592592592592592592592592592592e-2 * t204 * t1504 - 0.18251851851851851851851851851851851851851851851852e0 * t230 * t1741 * t220 + (t2356 + t2384) * t220 + 0.11733333333333333333333333333333333333333333333334e0 * t452 * t688 + 0.32331851851851851851851851851851851851851851851853e-2 * t429 * t1503 * t220 + 0.880e3 / 0.27e2 * t404 * t1538 + 0.880e3 / 0.27e2 * t65 * t1559
  t2419 = t1653 * t179
  t2458 = -0.6e1 * t164 * t537 * t1974 - 0.24e2 * t218 * t792 * t1974 - 0.60e2 * t241 / t536 / t219 * t1974 + 0.72e-1 * t531 * t1103 * t1716 + 0.24e-1 * t506 * t532 * t1716 + 0.96e-4 * t526 * t1098 * t1716 - 0.25600000000000000000000000000000000000000000000001e-3 * t1136 * t1098 * t775 - 0.12e-1 * t1089 * t1133 - 0.48e-4 * t1107 * t1127 - 0.16e-4 * t526 * t527 * t1960 + 0.51200000000000000000000000000000000000000000000001e-3 * t395 * t267 * t528
  t2467 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1465 * t42 * t245 - 0.3e1 / 0.8e1 * t5 * t41 * t253 * t245 - 0.9e1 / 0.8e1 * t5 * t43 * t547 + t5 * t251 * t556 * t245 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t254 * t547 - 0.9e1 / 0.8e1 * t5 * t258 * t1143 - 0.5e1 / 0.36e2 * t5 * t554 * t1488 * t245 + t5 * t557 * t547 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t561 * t1143 - 0.3e1 / 0.8e1 * t5 * t565 * (t1719 + t2244 + t2458 + t2294 + t2396 + t2083 + 0.29127111111111111111111111111111111111111111111114e-7 * t229 * t351 * t1653 * t220 - 0.32768000000000000000000000000000000000000000000001e-7 * t980 * t942 * t357 * t220 * t522 + 0.20480000000000000000000000000000000000000000000001e-5 * t1110 * t1994 * t794 - 0.4e-2 * t506 * t507 * t1960 - 0.10240000000000000000000000000000000000000000000000e-5 * t1110 * t1111 * t775 + 0.23040000000000000000000000000000000000000000000000e-2 * t429 * t615 * t1137 + 0.64000000000000000000000000000000000000000000000001e-1 * t377 * t261 * t523 - 0.20480000000000000000000000000000000000000000000001e-5 * t975 * t272 * t1112 + 0.36e2 * t487 * t792 * t794 - 0.6e1 * t1021 * t243 * t522 - 0.9e1 * t1043 * t537 * t522 - 0.3e1 * t1087 * t220 * t522 + 0.6e1 * t475 * t243 * t794 + 0.18e2 * t504 * t537 * t794 - 0.2000e4 / 0.3e1 * t83 * t704 * t267 + 0.2500e4 / 0.9e1 * t81 * t64 * t1553 + 0.27306666666666666666666666666666666666666666666669e-5 * t451 * t142 * t746 + 0.27306666666666666666666666666666666666666666666669e-5 * t376 * t142 * t739 + 0.29127111111111111111111111111111111111111111111114e-7 * t191 * t351 * t2419 + 0.250e3 / 0.9e1 * t69 * t1509 * t1529 + 0.76800000000000000000000000000000000000000000000002e-3 * t1136 * t1905 * t794 - 0.96e-4 * t526 * t1905 * t1974 + t1886 + t1989 - 0.29491200000000000000000000000000000000000000000001e-6 * t980 * t2419 + 0.440e3 / 0.9e1 * t409 * t1559 + 0.440e3 / 0.9e1 * t71 * t1592 - 0.25600000000000000000000000000000000000000000000000e-3 * t729 * t381 + 0.60453925925925925925925925925925925925925925925928e-4 * t398 * t2272 + 0.16213333333333333333333333333333333333333333333333e-2 * t395 * t617 - 0.14677333333333333333333333333333333333333333333334e-4 * t975 * t739 - 0.400e3 / 0.3e1 * t649 * t1514 - 0.400e3 * t409 * t1556 - 0.800e3 / 0.3e1 * t71 * t1588 - 0.800e3 / 0.3e1 * t656 * t1556 - 0.6400e4 / 0.9e1 * t415 * t1588 - 0.4000e4 / 0.9e1 * t77 * t1851 - 0.4000e4 / 0.9e1 * t697 * t1588 - 0.10000e5 / 0.9e1 * t420 * t1851 + 0.65763555555555555555555555555555555555555555555559e-6 * t352 * t1653 - 0.39632592592592592592592592592592592592592592592592e-2 * t124 * t1503 - 0.46080e-4 * t143 * t1518 + 0.440e3 / 0.27e2 * t276 * t1522 - 0.18251851851851851851851851851851851851851851851852e0 * t101 * t1741 + 0.72e-1 * t1124 * t1104 - 0.29491200000000000000000000000000000000000000000001e-6 * t964 * t1653 + 0.11733333333333333333333333333333333333333333333334e0 * t309 * t682 + 0.32331851851851851851851851851851851851851851851853e-2 * t312 * t1503 - 0.400e3 / 0.9e1 * t955 * t1525 - 0.400e3 / 0.9e1 * t958 * t1525 - 0.19200000000000000000000000000000000000000000000000e0 * t1121 * t1104 + 0.64000000000000000000000000000000000000000000000000e-1 * t1121 * t1130 + 0.32000000000000000000000000000000000000000000000001e-1 * t1115 * t1133 + 0.25600000000000000000000000000000000000000000000000e-3 * t1118 * t1127 + 0.12500e5 / 0.9e1 * t697 * t1575 + 0.6250e4 / 0.3e1 * t420 * t1831 - 0.1600e4 / 0.9e1 * t404 * t1514 - 0.400e3 / 0.3e1 * t65 * t1556 + 0.11733333333333333333333333333333333333333333333334e0 * t377 * t683 + 0.1760e4 / 0.27e2 * t415 * t1592 + 0.2000e4 / 0.3e1 * t656 * t1553 + 0.10000e5 / 0.9e1 * t415 * t1575 + 0.5000e4 / 0.9e1 * t77 * t1831 + 0.18e2 * t800 * t1716 + 0.36e2 * t793 * t1716 + 0.60453925925925925925925925925925925925925925925928e-4 * t334 * t1518 + 0.13824e-4 * t348 * t738 - 0.6e1 * t780 * t775 - t541 * t1960 - 0.3e1 * t538 * t1960 + 0.96e-4 * t1107 * t1099 - 0.12800000000000000000000000000000000000000000000000e-3 * t1092 * t1127))
  t2476 = -t1460
  t2477 = f.my_piecewise5(t14, 0, t10, 0, t2476)
  t2481 = f.my_piecewise3(t1153, 0, -0.8e1 / 0.27e2 / t1155 / t1152 * t1159 * t1158 + 0.4e1 / 0.3e1 * t1156 * t1158 * t1163 + 0.4e1 / 0.3e1 * t1154 * t2477)
  t2514 = t1381 * t1340
  t2517 = t1340 * t1407
  t2535 = t1393 * t1336
  t2559 = f.my_piecewise5(t171, 0, t169, 0, t2476)
  t2563 = -0.41481481481481481481481481481481481481481481481480e0 * t1916 * t1263 - 0.17777777777777777777777777777777777777777777777777e0 * t751 * t1337 + 0.88888888888888888888888888888888888888888888888886e-1 * t510 * t1394 - 0.26666666666666666666666666666666666666666666666666e0 * t510 * t1400 + 0.13333333333333333333333333333333333333333333333333e0 * t510 * t1404 - 0.14814814814814814814814814814814814814814814814815e0 * t167 / t1331 / t1334 / t1390 / t1333 * t2535 + 0.53333333333333333333333333333333333333333333333332e0 * t167 * t1389 / t1390 / t1261 * t2535 - 0.26666666666666666666666666666666666666666666666666e0 * t167 * t1389 * t1391 * t1336 * t1403 - 0.79999999999999999999999999999999999999999999999998e0 * t167 * t1332 * t1391 * t2535 + 0.79999999999999999999999999999999999999999999999998e0 * t167 * t1332 * t1398 * t1336 * t1403 - 0.13333333333333333333333333333333333333333333333333e0 * t167 * t1335 * t2559
  t2610 = -0.6e1 * t1259 * t1361 * t2514 + 0.6e1 * t1380 * t2517 - t1328 * t2563 - 0.24e-1 * t1342 * t1427 * t2514 + 0.24e-1 * t1342 * t1356 * t2517 - 0.4e-2 * t1342 * t1343 * t2563 - 0.96e-4 * t1347 * t1233 * t1361 * t2514 + 0.96e-4 * t1347 * t1415 * t2517 - 0.16e-4 * t1347 * t1348 * t2563 - 0.24e2 * t1295 * t1435 * t2514 + 0.18e2 * t1422 * t2517 - 0.2e1 * t1352 * t2563 - 0.96e-1 * t1355 * t1215 * t1435 * t2514 + 0.72e-1 * t1355 * t1427 * t2517 - 0.8e-2 * t1355 * t1356 * t2563 - 0.60e2 * t1312 / t1360 / t1296 * t2514 + 0.36e2 * t1436 * t2517 - 0.3e1 * t1362 * t2563
  t2615 = f.my_piecewise3(t1150, 0, -0.3e1 / 0.8e1 * t5 * t2481 * t42 * t1316 - 0.3e1 / 0.8e1 * t5 * t1167 * t253 * t1316 - 0.9e1 / 0.8e1 * t5 * t1168 * t1365 + t5 * t1322 * t556 * t1316 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t1323 * t1365 - 0.9e1 / 0.8e1 * t5 * t1327 * t1441 - 0.5e1 / 0.36e2 * t5 * t1370 * t1488 * t1316 + t5 * t1371 * t1365 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t1375 * t1441 - 0.3e1 / 0.8e1 * t5 * t1379 * t2610)
  d111 = 0.3e1 * t1148 + 0.3e1 * t1446 + t6 * (t2467 + t2615)

  res = {'v3rho3': d111}
  return res
