"""Generated from mgga_x_pbe_gx.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c0 = 0.827411

  params_c1 = -0.64356

  params_alphainf = 0.852

  gx_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  gx_cx0 = 4 / 3 * (2 / jnp.pi) ** (1 / 3)

  gx_cx1 = X_FACTOR_C

  pbe_gx_mu = 0.001015549

  gx_gx1 = lambda a: 1 + (1 - params_alphainf) * (1 - a) / (1 + a)

  gx_gx0 = lambda a: +gx_cx0 / gx_cx1 + a * (params_c0 + params_c1 * a) / (1.0 + (params_c0 + params_c1 - 1) * a) * (1 - gx_cx0 / gx_cx1)

  pbe_gx = lambda x: 1 / (1 + pbe_gx_mu * x ** 2)

  gx_f_a = lambda a: +gx_gx0(a) * Heaviside(1 - a) + gx_gx1(a) * Heaviside(a - 1)

  pbe_gx_f = lambda x, u, t: gx_f_a(gx_alpha(x, t)) * pbe_gx(x)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pbe_gx_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c0 = 0.827411

  params_c1 = -0.64356

  params_alphainf = 0.852

  gx_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  gx_cx0 = 4 / 3 * (2 / jnp.pi) ** (1 / 3)

  gx_cx1 = X_FACTOR_C

  pbe_gx_mu = 0.001015549

  gx_gx1 = lambda a: 1 + (1 - params_alphainf) * (1 - a) / (1 + a)

  gx_gx0 = lambda a: +gx_cx0 / gx_cx1 + a * (params_c0 + params_c1 * a) / (1.0 + (params_c0 + params_c1 - 1) * a) * (1 - gx_cx0 / gx_cx1)

  pbe_gx = lambda x: 1 / (1 + pbe_gx_mu * x ** 2)

  gx_f_a = lambda a: +gx_gx0(a) * Heaviside(1 - a) + gx_gx1(a) * Heaviside(a - 1)

  pbe_gx_f = lambda x, u, t: gx_f_a(gx_alpha(x, t)) * pbe_gx(x)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pbe_gx_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c0 = 0.827411

  params_c1 = -0.64356

  params_alphainf = 0.852

  gx_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  gx_cx0 = 4 / 3 * (2 / jnp.pi) ** (1 / 3)

  gx_cx1 = X_FACTOR_C

  pbe_gx_mu = 0.001015549

  gx_gx1 = lambda a: 1 + (1 - params_alphainf) * (1 - a) / (1 + a)

  gx_gx0 = lambda a: +gx_cx0 / gx_cx1 + a * (params_c0 + params_c1 * a) / (1.0 + (params_c0 + params_c1 - 1) * a) * (1 - gx_cx0 / gx_cx1)

  pbe_gx = lambda x: 1 / (1 + pbe_gx_mu * x ** 2)

  gx_f_a = lambda a: +gx_gx0(a) * Heaviside(1 - a) + gx_gx1(a) * Heaviside(a - 1)

  pbe_gx_f = lambda x, u, t: gx_f_a(gx_alpha(x, t)) * pbe_gx(x)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pbe_gx_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  Dirac = lambda *args: jnp.zeros_like(args[-1])

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t2 ** 2
  t31 = 4 ** (0.1e1 / 0.3e1)
  t33 = 0.8e1 / 0.27e2 * t28 * t29 * t31
  t34 = r0 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = 0.1e1 / t35 / r0
  t39 = r0 ** 2
  t41 = 0.1e1 / t35 / t39
  t42 = s0 * t41
  t44 = tau0 * t37 - t42 / 0.8e1
  t45 = 6 ** (0.1e1 / 0.3e1)
  t47 = jnp.pi ** 2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t51 = t44 * t45 * t50
  t53 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t51
  t55 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t51
  t56 = 0.1e1 / t55
  t58 = 0.1e1 - t33
  t59 = t53 * t56 * t58
  t62 = t33 + 0.5e1 / 0.9e1 * t51 * t59
  t63 = 0.5e1 / 0.9e1 * t51
  t64 = 0.1e1 - t63
  t65 = Heaviside(t64)
  t68 = 0.148e0 - 0.82222222222222222222222222222222222222222222222222e-1 * t51
  t69 = 0.1e1 + t63
  t70 = 0.1e1 / t69
  t72 = t68 * t70 + 0.1e1
  t73 = -t64
  t74 = Heaviside(t73)
  t76 = t62 * t65 + t72 * t74
  t77 = t27 * t76
  t79 = 0.1e1 + 0.1015549e-2 * t42
  t80 = 0.1e1 / t79
  t81 = t77 * t80
  t84 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t81)
  t85 = r1 <= f.p.dens_threshold
  t86 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t87 = 0.1e1 + t86
  t88 = t87 <= f.p.zeta_threshold
  t89 = t87 ** (0.1e1 / 0.3e1)
  t91 = f.my_piecewise3(t88, t22, t89 * t87)
  t92 = t5 * t91
  t93 = r1 ** (0.1e1 / 0.3e1)
  t94 = t93 ** 2
  t96 = 0.1e1 / t94 / r1
  t98 = r1 ** 2
  t100 = 0.1e1 / t94 / t98
  t101 = s2 * t100
  t103 = tau1 * t96 - t101 / 0.8e1
  t105 = t103 * t45 * t50
  t107 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t105
  t109 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t105
  t110 = 0.1e1 / t109
  t112 = t107 * t110 * t58
  t115 = t33 + 0.5e1 / 0.9e1 * t105 * t112
  t116 = 0.5e1 / 0.9e1 * t105
  t117 = 0.1e1 - t116
  t118 = Heaviside(t117)
  t121 = 0.148e0 - 0.82222222222222222222222222222222222222222222222222e-1 * t105
  t122 = 0.1e1 + t116
  t123 = 0.1e1 / t122
  t125 = t121 * t123 + 0.1e1
  t126 = -t117
  t127 = Heaviside(t126)
  t129 = t115 * t118 + t125 * t127
  t130 = t27 * t129
  t132 = 0.1e1 + 0.1015549e-2 * t101
  t133 = 0.1e1 / t132
  t134 = t130 * t133
  t137 = f.my_piecewise3(t85, 0, -0.3e1 / 0.8e1 * t92 * t134)
  t138 = t6 ** 2
  t140 = t16 / t138
  t141 = t7 - t140
  t142 = f.my_piecewise5(t10, 0, t14, 0, t141)
  t145 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t142)
  t149 = t27 ** 2
  t150 = 0.1e1 / t149
  t154 = t26 * t150 * t76 * t80 / 0.8e1
  t160 = s0 / t35 / t39 / r0
  t162 = -0.5e1 / 0.3e1 * tau0 * t41 + t160 / 0.3e1
  t163 = t162 * t45
  t164 = t163 * t50
  t167 = t45 ** 2
  t170 = 0.1e1 / t48 / t47
  t171 = t44 * t167 * t170
  t176 = t55 ** 2
  t178 = t53 / t176
  t185 = Dirac(t64)
  t186 = t62 * t185
  t189 = t50 * t70
  t192 = t69 ** 2
  t194 = t68 / t192
  t199 = Dirac(t73)
  t200 = t72 * t199
  t210 = t79 ** 2
  t211 = 0.1e1 / t210
  t217 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t145 * t81 - t154 - 0.3e1 / 0.8e1 * t26 * t27 * ((0.5e1 / 0.9e1 * t164 * t59 - 0.19862962962962962962962962962962962962962962962963e0 * t171 * t162 * t56 * t58 + 0.25189783950617283950617283950617283950617283950617e0 * t171 * t178 * t58 * t162) * t65 - 0.5e1 / 0.9e1 * t186 * t164 + (-0.82222222222222222222222222222222222222222222222222e-1 * t163 * t189 - 0.5e1 / 0.9e1 * t194 * t164) * t74 + 0.5e1 / 0.9e1 * t200 * t164) * t80 - 0.10155490000000000000000000000000000000000000000000e-2 * t5 * t25 * t27 * t76 * t211 * t160)
  t219 = f.my_piecewise5(t14, 0, t10, 0, -t141)
  t222 = f.my_piecewise3(t88, 0, 0.4e1 / 0.3e1 * t89 * t219)
  t229 = t92 * t150 * t129 * t133 / 0.8e1
  t231 = f.my_piecewise3(t85, 0, -0.3e1 / 0.8e1 * t5 * t222 * t134 - t229)
  vrho_0_ = t84 + t137 + t6 * (t217 + t231)
  t234 = -t7 - t140
  t235 = f.my_piecewise5(t10, 0, t14, 0, t234)
  t238 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t235)
  t243 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t238 * t81 - t154)
  t245 = f.my_piecewise5(t14, 0, t10, 0, -t234)
  t248 = f.my_piecewise3(t88, 0, 0.4e1 / 0.3e1 * t89 * t245)
  t257 = s2 / t94 / t98 / r1
  t259 = -0.5e1 / 0.3e1 * tau1 * t100 + t257 / 0.3e1
  t260 = t259 * t45
  t261 = t260 * t50
  t265 = t103 * t167 * t170
  t270 = t109 ** 2
  t272 = t107 / t270
  t279 = Dirac(t117)
  t280 = t115 * t279
  t283 = t50 * t123
  t286 = t122 ** 2
  t288 = t121 / t286
  t293 = Dirac(t126)
  t294 = t125 * t293
  t304 = t132 ** 2
  t305 = 0.1e1 / t304
  t311 = f.my_piecewise3(t85, 0, -0.3e1 / 0.8e1 * t5 * t248 * t134 - t229 - 0.3e1 / 0.8e1 * t92 * t27 * ((0.5e1 / 0.9e1 * t261 * t112 - 0.19862962962962962962962962962962962962962962962963e0 * t265 * t259 * t110 * t58 + 0.25189783950617283950617283950617283950617283950617e0 * t265 * t272 * t58 * t259) * t118 - 0.5e1 / 0.9e1 * t280 * t261 + (-0.82222222222222222222222222222222222222222222222222e-1 * t260 * t283 - 0.5e1 / 0.9e1 * t288 * t261) * t127 + 0.5e1 / 0.9e1 * t294 * t261) * t133 - 0.10155490000000000000000000000000000000000000000000e-2 * t5 * t91 * t27 * t129 * t305 * t257)
  vrho_1_ = t84 + t137 + t6 * (t243 + t311)
  t314 = t41 * t45
  t315 = t314 * t50
  t348 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * ((-0.5e1 / 0.72e2 * t315 * t59 + 0.24828703703703703703703703703703703703703703703703e-1 * t171 * t41 * t56 * t58 - 0.31487229938271604938271604938271604938271604938272e-1 * t171 * t178 * t58 * t41) * t65 + 0.5e1 / 0.72e2 * t186 * t315 + (0.10277777777777777777777777777777777777777777777778e-1 * t314 * t189 + 0.5e1 / 0.72e2 * t194 * t315) * t74 - 0.5e1 / 0.72e2 * t200 * t315) * t80 + 0.38083087500000000000000000000000000000000000000000e-3 * t26 * t77 * t211 * t41)
  vsigma_0_ = t6 * t348
  vsigma_1_ = 0.0e0
  t349 = t100 * t45
  t350 = t349 * t50
  t383 = f.my_piecewise3(t85, 0, -0.3e1 / 0.8e1 * t92 * t27 * ((-0.5e1 / 0.72e2 * t350 * t112 + 0.24828703703703703703703703703703703703703703703703e-1 * t265 * t100 * t110 * t58 - 0.31487229938271604938271604938271604938271604938272e-1 * t265 * t272 * t58 * t100) * t118 + 0.5e1 / 0.72e2 * t280 * t350 + (0.10277777777777777777777777777777777777777777777778e-1 * t349 * t283 + 0.5e1 / 0.72e2 * t288 * t350) * t127 - 0.5e1 / 0.72e2 * t294 * t350) * t133 + 0.38083087500000000000000000000000000000000000000000e-3 * t92 * t130 * t305 * t100)
  vsigma_2_ = t6 * t383
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t384 = t37 * t45
  t385 = t384 * t50
  t413 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * ((0.5e1 / 0.9e1 * t385 * t59 - 0.19862962962962962962962962962962962962962962962963e0 * t171 * t37 * t56 * t58 + 0.25189783950617283950617283950617283950617283950617e0 * t171 * t178 * t58 * t37) * t65 - 0.5e1 / 0.9e1 * t186 * t385 + (-0.82222222222222222222222222222222222222222222222222e-1 * t384 * t189 - 0.5e1 / 0.9e1 * t194 * t385) * t74 + 0.5e1 / 0.9e1 * t200 * t385) * t80)
  vtau_0_ = t6 * t413
  t414 = t96 * t45
  t415 = t414 * t50
  t443 = f.my_piecewise3(t85, 0, -0.3e1 / 0.8e1 * t92 * t27 * ((0.5e1 / 0.9e1 * t415 * t112 - 0.19862962962962962962962962962962962962962962962963e0 * t265 * t96 * t110 * t58 + 0.25189783950617283950617283950617283950617283950617e0 * t265 * t272 * t58 * t96) * t118 - 0.5e1 / 0.9e1 * t280 * t415 + (-0.82222222222222222222222222222222222222222222222222e-1 * t414 * t283 - 0.5e1 / 0.9e1 * t288 * t415) * t127 + 0.5e1 / 0.9e1 * t294 * t415) * t133)
  vtau_1_ = t6 * t443
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c0 = 0.827411

  params_c1 = -0.64356

  params_alphainf = 0.852

  gx_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  gx_cx0 = 4 / 3 * (2 / jnp.pi) ** (1 / 3)

  gx_cx1 = X_FACTOR_C

  pbe_gx_mu = 0.001015549

  gx_gx1 = lambda a: 1 + (1 - params_alphainf) * (1 - a) / (1 + a)

  gx_gx0 = lambda a: +gx_cx0 / gx_cx1 + a * (params_c0 + params_c1 * a) / (1.0 + (params_c0 + params_c1 - 1) * a) * (1 - gx_cx0 / gx_cx1)

  pbe_gx = lambda x: 1 / (1 + pbe_gx_mu * x ** 2)

  gx_f_a = lambda a: +gx_gx0(a) * Heaviside(1 - a) + gx_gx1(a) * Heaviside(a - 1)

  pbe_gx_f = lambda x, u, t: gx_f_a(gx_alpha(x, t)) * pbe_gx(x)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pbe_gx_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  Dirac = lambda *args: jnp.zeros_like(args[-1])

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 2 ** (0.1e1 / 0.3e1)
  t21 = t3 ** 2
  t23 = 4 ** (0.1e1 / 0.3e1)
  t25 = 0.8e1 / 0.27e2 * t20 * t21 * t23
  t26 = t20 ** 2
  t27 = tau0 * t26
  t28 = t19 ** 2
  t30 = 0.1e1 / t28 / r0
  t32 = s0 * t26
  t33 = r0 ** 2
  t35 = 0.1e1 / t28 / t33
  t36 = t32 * t35
  t38 = t27 * t30 - t36 / 0.8e1
  t39 = 6 ** (0.1e1 / 0.3e1)
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = t38 * t39 * t44
  t47 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t45
  t49 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t45
  t50 = 0.1e1 / t49
  t52 = 0.1e1 - t25
  t53 = t47 * t50 * t52
  t56 = t25 + 0.5e1 / 0.9e1 * t45 * t53
  t57 = 0.5e1 / 0.9e1 * t45
  t58 = 0.1e1 - t57
  t59 = Heaviside(t58)
  t62 = 0.148e0 - 0.82222222222222222222222222222222222222222222222222e-1 * t45
  t63 = 0.1e1 + t57
  t64 = 0.1e1 / t63
  t66 = t62 * t64 + 0.1e1
  t67 = -t58
  t68 = Heaviside(t67)
  t70 = t56 * t59 + t66 * t68
  t73 = 0.1e1 + 0.1015549e-2 * t36
  t74 = 0.1e1 / t73
  t78 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t70 * t74)
  t86 = t33 * r0
  t91 = -0.5e1 / 0.3e1 * t27 * t35 + t32 / t28 / t86 / 0.3e1
  t92 = t91 * t39
  t93 = t92 * t44
  t96 = t39 ** 2
  t97 = t38 * t96
  t99 = 0.1e1 / t42 / t41
  t100 = t97 * t99
  t105 = t49 ** 2
  t106 = 0.1e1 / t105
  t114 = Dirac(t58)
  t115 = t56 * t114
  t121 = t63 ** 2
  t123 = t62 / t121
  t128 = Dirac(t67)
  t129 = t66 * t128
  t141 = t73 ** 2
  t142 = 0.1e1 / t141
  t148 = f.my_piecewise3(t2, 0, -t18 / t28 * t70 * t74 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * ((0.5e1 / 0.9e1 * t93 * t53 - 0.19862962962962962962962962962962962962962962962963e0 * t100 * t91 * t50 * t52 + 0.25189783950617283950617283950617283950617283950617e0 * t100 * t47 * t106 * t52 * t91) * t59 - 0.5e1 / 0.9e1 * t115 * t93 + (-0.82222222222222222222222222222222222222222222222222e-1 * t92 * t44 * t64 - 0.5e1 / 0.9e1 * t123 * t93) * t68 + 0.5e1 / 0.9e1 * t129 * t93) * t74 - 0.10155490000000000000000000000000000000000000000000e-2 * t6 * t17 / t19 / t86 * t70 * t142 * t32)
  vrho_0_ = 0.2e1 * r0 * t148 + 0.2e1 * t78
  t151 = t26 * t35
  t154 = t50 * t52
  t155 = t44 * t47 * t154
  t162 = t97 * t99 * t47
  t163 = t106 * t52
  t169 = t115 * t26
  t171 = t35 * t39 * t44
  t175 = t39 * t44 * t64
  t178 = t123 * t26
  t183 = t129 * t26
  t199 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * ((-0.5e1 / 0.72e2 * t151 * t39 * t155 + 0.24828703703703703703703703703703703703703703703703e-1 * t100 * t151 * t154 - 0.31487229938271604938271604938271604938271604938272e-1 * t162 * t163 * t151) * t59 + 0.5e1 / 0.72e2 * t169 * t171 + (0.10277777777777777777777777777777777777777777777778e-1 * t151 * t175 + 0.5e1 / 0.72e2 * t178 * t171) * t68 - 0.5e1 / 0.72e2 * t183 * t171) * t74 + 0.38083087500000000000000000000000000000000000000000e-3 * t18 / t19 / t33 * t70 * t142 * t26)
  vsigma_0_ = 0.2e1 * r0 * t199
  vlapl_0_ = 0.0e0
  t201 = t26 * t30
  t214 = t30 * t39 * t44
  t230 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * ((0.5e1 / 0.9e1 * t201 * t39 * t155 - 0.19862962962962962962962962962962962962962962962963e0 * t100 * t201 * t154 + 0.25189783950617283950617283950617283950617283950617e0 * t162 * t163 * t201) * t59 - 0.5e1 / 0.9e1 * t169 * t214 + (-0.82222222222222222222222222222222222222222222222222e-1 * t201 * t175 - 0.5e1 / 0.9e1 * t178 * t214) * t68 + 0.5e1 / 0.9e1 * t183 * t214) * t74)
  vtau_0_ = 0.2e1 * r0 * t230
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t3 ** 2
  t25 = 4 ** (0.1e1 / 0.3e1)
  t27 = 0.8e1 / 0.27e2 * t22 * t23 * t25
  t28 = t22 ** 2
  t29 = tau0 * t28
  t31 = 0.1e1 / t20 / r0
  t33 = s0 * t28
  t34 = r0 ** 2
  t36 = 0.1e1 / t20 / t34
  t37 = t33 * t36
  t39 = t29 * t31 - t37 / 0.8e1
  t40 = 6 ** (0.1e1 / 0.3e1)
  t42 = jnp.pi ** 2
  t43 = t42 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = 0.1e1 / t44
  t46 = t39 * t40 * t45
  t48 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t46
  t50 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t46
  t51 = 0.1e1 / t50
  t53 = 0.1e1 - t27
  t54 = t48 * t51 * t53
  t57 = t27 + 0.5e1 / 0.9e1 * t46 * t54
  t58 = 0.5e1 / 0.9e1 * t46
  t59 = 0.1e1 - t58
  t60 = Heaviside(t59)
  t62 = 0.1e1 + t58
  t63 = 0.1e1 / t62
  t66 = 0.1e1 + 0.148e0 * t59 * t63
  t68 = Heaviside(-t59)
  t70 = t57 * t60 + t66 * t68
  t73 = 0.1e1 + 0.1015549e-2 * t37
  t74 = 0.1e1 / t73
  t80 = t34 * r0
  t82 = 0.1e1 / t20 / t80
  t85 = -0.5e1 / 0.3e1 * t29 * t36 + t33 * t82 / 0.3e1
  t86 = t85 * t40
  t87 = t86 * t45
  t90 = t40 ** 2
  t93 = 0.1e1 / t43 / t42
  t94 = t39 * t90 * t93
  t99 = t50 ** 2
  t100 = 0.1e1 / t99
  t101 = t48 * t100
  t106 = 0.5e1 / 0.9e1 * t87 * t54 - 0.19862962962962962962962962962962962962962962962963e0 * t94 * t85 * t51 * t53 + 0.25189783950617283950617283950617283950617283950617e0 * t94 * t101 * t53 * t85
  t108 = Dirac(t59)
  t109 = t57 * t108
  t112 = t45 * t63
  t115 = t62 ** 2
  t116 = 0.1e1 / t115
  t117 = t59 * t116
  t120 = -0.82222222222222222222222222222222222222222222222222e-1 * t86 * t112 - 0.82222222222222222222222222222222222222222222222222e-1 * t117 * t87
  t122 = t66 * t108
  t125 = t106 * t60 - 0.5e1 / 0.9e1 * t109 * t87 + t120 * t68 + 0.5e1 / 0.9e1 * t122 * t87
  t133 = t6 * t17 / t19 / t80
  t134 = t73 ** 2
  t135 = 0.1e1 / t134
  t137 = t70 * t135 * t33
  t141 = f.my_piecewise3(t2, 0, -t18 * t21 * t70 * t74 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t125 * t74 - 0.10155490000000000000000000000000000000000000000000e-2 * t133 * t137)
  t151 = t34 ** 2
  t164 = 0.40e2 / 0.9e1 * t29 * t82 - 0.11e2 / 0.9e1 * t33 / t20 / t151
  t165 = t164 * t40
  t166 = t165 * t45
  t169 = t85 ** 2
  t170 = t169 * t90
  t175 = t170 * t93
  t183 = t42 ** 2
  t185 = t39 / t183
  t206 = Dirac(1, t59)
  t250 = s0 ** 2
  t256 = f.my_piecewise3(t2, 0, t18 * t31 * t70 * t74 / 0.12e2 - t18 * t21 * t125 * t74 / 0.4e1 + 0.30466470000000000000000000000000000000000000000000e-2 * t6 * t17 / t19 / t151 * t137 - 0.3e1 / 0.8e1 * t18 * t19 * ((0.5e1 / 0.9e1 * t166 * t54 - 0.39725925925925925925925925925925925925925925925926e0 * t170 * t93 * t51 * t53 + 0.50379567901234567901234567901234567901234567901234e0 * t175 * t101 * t53 - 0.19862962962962962962962962962962962962962962962963e0 * t94 * t164 * t51 * t53 - 0.10807424906172839506172839506172839506172839506173e1 * t185 * t169 * t100 * t53 + 0.13705744654341563786008230452674897119341563786008e1 * t185 * t48 / t99 / t50 * t53 * t169 + 0.25189783950617283950617283950617283950617283950617e0 * t94 * t101 * t53 * t164) * t60 - 0.10e2 / 0.9e1 * t106 * t108 * t87 + 0.25e2 / 0.81e2 * t57 * t206 * t175 - 0.5e1 / 0.9e1 * t109 * t166 + (-0.82222222222222222222222222222222222222222222222222e-1 * t165 * t112 + 0.91358024691358024691358024691358024691358024691358e-1 * t170 * t93 * t116 + 0.91358024691358024691358024691358024691358024691358e-1 * t59 / t115 / t62 * t175 - 0.82222222222222222222222222222222222222222222222222e-1 * t117 * t166) * t68 + 0.10e2 / 0.9e1 * t120 * t108 * t87 - 0.25e2 / 0.81e2 * t66 * t206 * t175 + 0.5e1 / 0.9e1 * t122 * t166) * t74 - 0.20310980000000000000000000000000000000000000000000e-2 * t133 * t125 * t135 * t33 - 0.11000957561610666666666666666666666666666666666667e-4 * t6 * t17 / t151 / t80 * t70 / t134 / t73 * t250 * t22)
  v2rho2_0_ = 0.2e1 * r0 * t256 + 0.4e1 * t141

  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t3 ** 2
  t26 = 4 ** (0.1e1 / 0.3e1)
  t28 = 0.8e1 / 0.27e2 * t23 * t24 * t26
  t29 = t23 ** 2
  t30 = tau0 * t29
  t32 = s0 * t29
  t33 = r0 ** 2
  t35 = 0.1e1 / t20 / t33
  t36 = t32 * t35
  t38 = t30 * t22 - t36 / 0.8e1
  t39 = 6 ** (0.1e1 / 0.3e1)
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = t38 * t39 * t44
  t47 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t45
  t49 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t45
  t50 = 0.1e1 / t49
  t52 = 0.1e1 - t28
  t53 = t47 * t50 * t52
  t56 = t28 + 0.5e1 / 0.9e1 * t45 * t53
  t57 = 0.5e1 / 0.9e1 * t45
  t58 = 0.1e1 - t57
  t59 = Heaviside(t58)
  t61 = 0.1e1 + t57
  t62 = 0.1e1 / t61
  t65 = 0.1e1 + 0.148e0 * t58 * t62
  t67 = Heaviside(-t58)
  t69 = t56 * t59 + t65 * t67
  t72 = 0.1e1 + 0.1015549e-2 * t36
  t73 = 0.1e1 / t72
  t77 = 0.1e1 / t20
  t80 = t33 * r0
  t82 = 0.1e1 / t20 / t80
  t85 = -0.5e1 / 0.3e1 * t30 * t35 + t32 * t82 / 0.3e1
  t86 = t85 * t39
  t87 = t86 * t44
  t90 = t39 ** 2
  t93 = 0.1e1 / t42 / t41
  t94 = t38 * t90 * t93
  t96 = t85 * t50 * t52
  t99 = t49 ** 2
  t100 = 0.1e1 / t99
  t101 = t47 * t100
  t103 = t101 * t52 * t85
  t106 = 0.5e1 / 0.9e1 * t87 * t53 - 0.19862962962962962962962962962962962962962962962963e0 * t94 * t96 + 0.25189783950617283950617283950617283950617283950617e0 * t94 * t103
  t108 = Dirac(t58)
  t109 = t56 * t108
  t112 = t44 * t62
  t115 = t61 ** 2
  t116 = 0.1e1 / t115
  t117 = t58 * t116
  t120 = -0.82222222222222222222222222222222222222222222222222e-1 * t86 * t112 - 0.82222222222222222222222222222222222222222222222222e-1 * t117 * t87
  t122 = t65 * t108
  t125 = t106 * t59 - 0.5e1 / 0.9e1 * t109 * t87 + t120 * t67 + 0.5e1 / 0.9e1 * t122 * t87
  t130 = t33 ** 2
  t134 = t6 * t17 / t19 / t130
  t135 = t72 ** 2
  t136 = 0.1e1 / t135
  t138 = t69 * t136 * t32
  t144 = 0.1e1 / t20 / t130
  t147 = 0.40e2 / 0.9e1 * t30 * t82 - 0.11e2 / 0.9e1 * t32 * t144
  t148 = t147 * t39
  t149 = t148 * t44
  t152 = t85 ** 2
  t153 = t152 * t90
  t158 = t153 * t93
  t166 = t41 ** 2
  t167 = 0.1e1 / t166
  t168 = t38 * t167
  t173 = t168 * t47
  t175 = 0.1e1 / t99 / t49
  t176 = t175 * t52
  t184 = 0.5e1 / 0.9e1 * t149 * t53 - 0.39725925925925925925925925925925925925925925925926e0 * t153 * t93 * t50 * t52 + 0.50379567901234567901234567901234567901234567901234e0 * t158 * t101 * t52 - 0.19862962962962962962962962962962962962962962962963e0 * t94 * t147 * t50 * t52 - 0.10807424906172839506172839506172839506172839506173e1 * t168 * t152 * t100 * t52 + 0.13705744654341563786008230452674897119341563786008e1 * t173 * t176 * t152 + 0.25189783950617283950617283950617283950617283950617e0 * t94 * t101 * t52 * t147
  t186 = t106 * t108
  t189 = Dirac(1, t58)
  t190 = t56 * t189
  t197 = t93 * t116
  t201 = 0.1e1 / t115 / t61
  t202 = t58 * t201
  t207 = -0.82222222222222222222222222222222222222222222222222e-1 * t148 * t112 + 0.91358024691358024691358024691358024691358024691358e-1 * t153 * t197 + 0.91358024691358024691358024691358024691358024691358e-1 * t202 * t158 - 0.82222222222222222222222222222222222222222222222222e-1 * t117 * t149
  t209 = t120 * t108
  t212 = t65 * t189
  t217 = t184 * t59 - 0.10e2 / 0.9e1 * t186 * t87 + 0.25e2 / 0.81e2 * t190 * t158 - 0.5e1 / 0.9e1 * t109 * t149 + t207 * t67 + 0.10e2 / 0.9e1 * t209 * t87 - 0.25e2 / 0.81e2 * t212 * t158 + 0.5e1 / 0.9e1 * t122 * t149
  t225 = t6 * t17 / t19 / t80
  t227 = t125 * t136 * t32
  t233 = t6 * t17 / t130 / t80
  t235 = 0.1e1 / t135 / t72
  t237 = s0 ** 2
  t238 = t237 * t23
  t239 = t69 * t235 * t238
  t243 = f.my_piecewise3(t2, 0, t18 * t22 * t69 * t73 / 0.12e2 - t18 * t77 * t125 * t73 / 0.4e1 + 0.30466470000000000000000000000000000000000000000000e-2 * t134 * t138 - 0.3e1 / 0.8e1 * t18 * t19 * t217 * t73 - 0.20310980000000000000000000000000000000000000000000e-2 * t225 * t227 - 0.11000957561610666666666666666666666666666666666667e-4 * t233 * t239)
  t253 = t130 * r0
  t266 = t130 ** 2
  t278 = -0.440e3 / 0.27e2 * t30 * t144 + 0.154e3 / 0.27e2 * t32 / t20 / t253
  t279 = t278 * t39
  t280 = t279 * t44
  t283 = t147 * t90
  t284 = t283 * t93
  t289 = t152 * t85
  t290 = t289 * t167
  t291 = t100 * t52
  t307 = t39 * t44
  t311 = t99 ** 2
  t327 = 0.5e1 / 0.9e1 * t280 * t53 - 0.11917777777777777777777777777777777777777777777778e1 * t284 * t96 + 0.15113870370370370370370370370370370370370370370370e1 * t284 * t103 - 0.32422274718518518518518518518518518518518518518519e1 * t290 * t291 + 0.41117233963024691358024691358024691358024691358024e1 * t290 * t47 * t175 * t52 - 0.19862962962962962962962962962962962962962962962963e0 * t94 * t278 * t50 * t52 - 0.32422274718518518518518518518518518518518518518519e1 * t168 * t147 * t291 * t85 - 0.14700781716246761316872427983539094650205761316872e1 * t168 * t289 * t176 * t307 + 0.18643216323160354903978052126200274348422496570644e1 * t168 * t47 / t311 * t52 * t289 * t307 + 0.41117233963024691358024691358024691358024691358024e1 * t173 * t176 * t85 * t147 + 0.25189783950617283950617283950617283950617283950617e0 * t94 * t101 * t52 * t278
  t337 = Dirac(2, t58)
  t353 = t115 ** 2
  t381 = t327 * t59 - 0.5e1 / 0.3e1 * t184 * t108 * t87 + 0.25e2 / 0.27e2 * t106 * t189 * t158 - 0.5e1 / 0.3e1 * t186 * t149 - 0.250e3 / 0.243e3 * t56 * t337 * t290 + 0.25e2 / 0.27e2 * t190 * t85 * t284 - 0.5e1 / 0.9e1 * t109 * t280 + (-0.82222222222222222222222222222222222222222222222222e-1 * t279 * t112 + 0.27407407407407407407407407407407407407407407407408e0 * t283 * t197 * t85 - 0.91358024691358024691358024691358024691358024691358e0 * t290 * t201 - 0.91358024691358024691358024691358024691358024691358e0 * t58 / t353 * t290 + 0.27407407407407407407407407407407407407407407407408e0 * t202 * t85 * t284 - 0.82222222222222222222222222222222222222222222222222e-1 * t117 * t280) * t67 + 0.5e1 / 0.3e1 * t207 * t108 * t87 - 0.25e2 / 0.27e2 * t120 * t189 * t158 + 0.5e1 / 0.3e1 * t209 * t149 + 0.250e3 / 0.243e3 * t65 * t337 * t290 - 0.25e2 / 0.27e2 * t212 * t85 * t284 + 0.5e1 / 0.9e1 * t122 * t280
  t398 = t135 ** 2
  t406 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t35 * t69 * t73 + t18 * t22 * t125 * t73 / 0.4e1 - 0.12976459444444444444444444444444444444444444444444e-1 * t6 * t17 / t19 / t253 * t138 - 0.3e1 / 0.8e1 * t18 * t77 * t217 * t73 + 0.91399410000000000000000000000000000000000000000000e-2 * t134 * t227 + 0.11000957561610666666666666666666666666666666666667e-3 * t6 * t17 / t266 * t239 - 0.3e1 / 0.8e1 * t18 * t19 * t381 * t73 - 0.30466470000000000000000000000000000000000000000000e-2 * t225 * t217 * t136 * t32 - 0.33002872684832000000000000000000000000000000000001e-4 * t233 * t125 * t235 * t238 - 0.17875218321177841476266666666666666666666666666667e-6 * t18 / t20 / t266 / t33 * t69 / t398 * t237 * s0)
  v3rho3_0_ = 0.2e1 * r0 * t406 + 0.6e1 * t243

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t3 ** 2
  t27 = 4 ** (0.1e1 / 0.3e1)
  t29 = 0.8e1 / 0.27e2 * t24 * t25 * t27
  t30 = t24 ** 2
  t31 = tau0 * t30
  t33 = 0.1e1 / t21 / r0
  t35 = s0 * t30
  t36 = t35 * t23
  t38 = t31 * t33 - t36 / 0.8e1
  t39 = 6 ** (0.1e1 / 0.3e1)
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = t38 * t39 * t44
  t47 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t45
  t49 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t45
  t50 = 0.1e1 / t49
  t52 = 0.1e1 - t29
  t53 = t47 * t50 * t52
  t56 = t29 + 0.5e1 / 0.9e1 * t45 * t53
  t57 = 0.5e1 / 0.9e1 * t45
  t58 = 0.1e1 - t57
  t59 = Heaviside(t58)
  t61 = 0.1e1 + t57
  t62 = 0.1e1 / t61
  t65 = 0.1e1 + 0.148e0 * t58 * t62
  t67 = Heaviside(-t58)
  t69 = t56 * t59 + t65 * t67
  t72 = 0.1e1 + 0.1015549e-2 * t36
  t73 = 0.1e1 / t72
  t79 = t19 * r0
  t81 = 0.1e1 / t21 / t79
  t84 = -0.5e1 / 0.3e1 * t31 * t23 + t35 * t81 / 0.3e1
  t85 = t84 * t39
  t86 = t85 * t44
  t89 = t39 ** 2
  t92 = 0.1e1 / t42 / t41
  t93 = t38 * t89 * t92
  t95 = t84 * t50 * t52
  t98 = t49 ** 2
  t99 = 0.1e1 / t98
  t100 = t47 * t99
  t102 = t100 * t52 * t84
  t105 = 0.5e1 / 0.9e1 * t86 * t53 - 0.19862962962962962962962962962962962962962962962963e0 * t93 * t95 + 0.25189783950617283950617283950617283950617283950617e0 * t93 * t102
  t107 = Dirac(t58)
  t108 = t56 * t107
  t111 = t44 * t62
  t114 = t61 ** 2
  t115 = 0.1e1 / t114
  t116 = t58 * t115
  t119 = -0.82222222222222222222222222222222222222222222222222e-1 * t85 * t111 - 0.82222222222222222222222222222222222222222222222222e-1 * t116 * t86
  t121 = t65 * t107
  t124 = t105 * t59 - 0.5e1 / 0.9e1 * t108 * t86 + t119 * t67 + 0.5e1 / 0.9e1 * t121 * t86
  t129 = t19 ** 2
  t130 = t129 * r0
  t134 = t6 * t17 / t20 / t130
  t135 = t72 ** 2
  t136 = 0.1e1 / t135
  t138 = t69 * t136 * t35
  t141 = 0.1e1 / t21
  t145 = 0.1e1 / t21 / t129
  t148 = 0.40e2 / 0.9e1 * t31 * t81 - 0.11e2 / 0.9e1 * t35 * t145
  t149 = t148 * t39
  t150 = t149 * t44
  t153 = t84 ** 2
  t154 = t153 * t89
  t156 = t92 * t50 * t52
  t159 = t154 * t92
  t160 = t100 * t52
  t167 = t41 ** 2
  t168 = 0.1e1 / t167
  t169 = t38 * t168
  t171 = t153 * t99 * t52
  t174 = t169 * t47
  t176 = 0.1e1 / t98 / t49
  t177 = t176 * t52
  t178 = t177 * t153
  t185 = 0.5e1 / 0.9e1 * t150 * t53 - 0.39725925925925925925925925925925925925925925925926e0 * t154 * t156 + 0.50379567901234567901234567901234567901234567901234e0 * t159 * t160 - 0.19862962962962962962962962962962962962962962962963e0 * t93 * t148 * t50 * t52 - 0.10807424906172839506172839506172839506172839506173e1 * t169 * t171 + 0.13705744654341563786008230452674897119341563786008e1 * t174 * t178 + 0.25189783950617283950617283950617283950617283950617e0 * t93 * t100 * t52 * t148
  t187 = t105 * t107
  t190 = Dirac(1, t58)
  t191 = t56 * t190
  t198 = t92 * t115
  t202 = 0.1e1 / t114 / t61
  t203 = t58 * t202
  t208 = -0.82222222222222222222222222222222222222222222222222e-1 * t149 * t111 + 0.91358024691358024691358024691358024691358024691358e-1 * t154 * t198 + 0.91358024691358024691358024691358024691358024691358e-1 * t203 * t159 - 0.82222222222222222222222222222222222222222222222222e-1 * t116 * t150
  t210 = t119 * t107
  t213 = t65 * t190
  t218 = t185 * t59 - 0.10e2 / 0.9e1 * t187 * t86 + 0.25e2 / 0.81e2 * t191 * t159 - 0.5e1 / 0.9e1 * t108 * t150 + t208 * t67 + 0.10e2 / 0.9e1 * t210 * t86 - 0.25e2 / 0.81e2 * t213 * t159 + 0.5e1 / 0.9e1 * t121 * t150
  t226 = t6 * t17 / t20 / t129
  t228 = t124 * t136 * t35
  t231 = t129 ** 2
  t234 = t6 * t17 / t231
  t236 = 0.1e1 / t135 / t72
  t238 = s0 ** 2
  t239 = t238 * t24
  t240 = t69 * t236 * t239
  t246 = 0.1e1 / t21 / t130
  t249 = -0.440e3 / 0.27e2 * t31 * t145 + 0.154e3 / 0.27e2 * t35 * t246
  t250 = t249 * t39
  t251 = t250 * t44
  t254 = t148 * t89
  t255 = t254 * t92
  t260 = t153 * t84
  t261 = t260 * t168
  t262 = t99 * t52
  t274 = t262 * t84
  t278 = t39 * t44
  t282 = t98 ** 2
  t283 = 0.1e1 / t282
  t285 = t169 * t47 * t283
  t298 = 0.5e1 / 0.9e1 * t251 * t53 - 0.11917777777777777777777777777777777777777777777778e1 * t255 * t95 + 0.15113870370370370370370370370370370370370370370370e1 * t255 * t102 - 0.32422274718518518518518518518518518518518518518519e1 * t261 * t262 + 0.41117233963024691358024691358024691358024691358024e1 * t261 * t47 * t176 * t52 - 0.19862962962962962962962962962962962962962962962963e0 * t93 * t249 * t50 * t52 - 0.32422274718518518518518518518518518518518518518519e1 * t169 * t148 * t274 - 0.14700781716246761316872427983539094650205761316872e1 * t169 * t260 * t177 * t278 + 0.18643216323160354903978052126200274348422496570644e1 * t285 * t52 * t260 * t278 + 0.41117233963024691358024691358024691358024691358024e1 * t174 * t177 * t84 * t148 + 0.25189783950617283950617283950617283950617283950617e0 * t93 * t100 * t52 * t249
  t300 = t185 * t107
  t303 = t105 * t190
  t308 = Dirac(2, t58)
  t309 = t56 * t308
  t312 = t191 * t84
  t319 = t198 * t84
  t324 = t114 ** 2
  t325 = 0.1e1 / t324
  t326 = t58 * t325
  t329 = t203 * t84
  t334 = -0.82222222222222222222222222222222222222222222222222e-1 * t250 * t111 + 0.27407407407407407407407407407407407407407407407408e0 * t254 * t319 - 0.91358024691358024691358024691358024691358024691358e0 * t261 * t202 - 0.91358024691358024691358024691358024691358024691358e0 * t326 * t261 + 0.27407407407407407407407407407407407407407407407408e0 * t329 * t255 - 0.82222222222222222222222222222222222222222222222222e-1 * t116 * t251
  t336 = t208 * t107
  t339 = t119 * t190
  t344 = t65 * t308
  t347 = t213 * t84
  t352 = t298 * t59 - 0.5e1 / 0.3e1 * t300 * t86 + 0.25e2 / 0.27e2 * t303 * t159 - 0.5e1 / 0.3e1 * t187 * t150 - 0.250e3 / 0.243e3 * t309 * t261 + 0.25e2 / 0.27e2 * t312 * t255 - 0.5e1 / 0.9e1 * t108 * t251 + t334 * t67 + 0.5e1 / 0.3e1 * t336 * t86 - 0.25e2 / 0.27e2 * t339 * t159 + 0.5e1 / 0.3e1 * t210 * t150 + 0.250e3 / 0.243e3 * t344 * t261 - 0.25e2 / 0.27e2 * t347 * t255 + 0.5e1 / 0.9e1 * t121 * t251
  t360 = t6 * t17 / t20 / t79
  t362 = t218 * t136 * t35
  t368 = t6 * t17 / t129 / t79
  t370 = t124 * t236 * t239
  t375 = 0.1e1 / t21 / t231 / t19
  t377 = t135 ** 2
  t380 = 0.1e1 / t377 * t238 * s0
  t385 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t23 * t69 * t73 + t18 * t33 * t124 * t73 / 0.4e1 - 0.12976459444444444444444444444444444444444444444444e-1 * t134 * t138 - 0.3e1 / 0.8e1 * t18 * t141 * t218 * t73 + 0.91399410000000000000000000000000000000000000000000e-2 * t226 * t228 + 0.11000957561610666666666666666666666666666666666667e-3 * t234 * t240 - 0.3e1 / 0.8e1 * t18 * t20 * t352 * t73 - 0.30466470000000000000000000000000000000000000000000e-2 * t360 * t362 - 0.33002872684832000000000000000000000000000000000001e-4 * t368 * t370 - 0.17875218321177841476266666666666666666666666666667e-6 * t18 * t375 * t69 * t380)
  t390 = t153 * t168 * t148
  t395 = t129 * t19
  t400 = 0.6160e4 / 0.81e2 * t31 * t246 - 0.2618e4 / 0.81e2 * t35 / t21 / t395
  t401 = t400 * t39
  t402 = t401 * t44
  t427 = 0.20e2 / 0.9e1 * t210 * t251 + 0.500e3 / 0.81e2 * t344 * t390 + 0.5e1 / 0.9e1 * t121 * t402 + 0.20e2 / 0.9e1 * t334 * t107 * t86 + 0.10e2 / 0.3e1 * t336 * t150 - 0.50e2 / 0.27e2 * t208 * t190 * t159 - 0.20e2 / 0.9e1 * t298 * t107 * t86 - 0.10e2 / 0.3e1 * t300 * t150 + 0.50e2 / 0.27e2 * t185 * t190 * t159 - 0.20e2 / 0.9e1 * t187 * t251 - 0.500e3 / 0.81e2 * t309 * t390 - 0.5e1 / 0.9e1 * t108 * t402
  t437 = Dirac(3, t58)
  t439 = t153 ** 2
  t441 = t278 * t168
  t449 = t148 * t168
  t453 = t148 ** 2
  t454 = t453 * t89
  t457 = t439 * t168
  t470 = t454 * t92
  t473 = t89 * t92
  t474 = t473 * t249
  t508 = t52 * t153
  t528 = t283 * t52
  t549 = -0.19453364831111111111111111111111111111111111111112e2 * t449 * t171 - 0.19862962962962962962962962962962962962962962962963e0 * t93 * t400 * t50 * t52 - 0.43229699624691358024691358024691358024691358024692e1 * t169 * t249 * t274 - 0.32422274718518518518518518518518518518518518518519e1 * t169 * t453 * t99 * t52 + 0.5e1 / 0.9e1 * t402 * t53 - 0.15890370370370370370370370370370370370370370370370e1 * t474 * t95 - 0.11917777777777777777777777777777777777777777777778e1 * t454 * t156 + 0.24670340377814814814814814814814814814814814814814e2 * t449 * t47 * t178 - 0.58803126864987045267489711934156378600823045267489e1 * t457 * t176 * t52 * t39 * t44 + 0.11185929793896212942386831275720164609053497942386e2 * t285 * t508 * t150 + 0.41117233963024691358024691358024691358024691358024e1 * t174 * t177 * t453 + 0.54822978617366255144032921810699588477366255144032e1 * t174 * t177 * t84 * t249 + 0.25189783950617283950617283950617283950617283950617e0 * t93 * t100 * t52 * t400 + 0.20151827160493827160493827160493827160493827160494e1 * t474 * t102 + 0.15113870370370370370370370370370370370370370370370e1 * t470 * t160 + 0.74572865292641419615912208504801097393689986282576e1 * t457 * t47 * t528 * t278 - 0.26662285104295728893342478280749885688157293095563e1 * t169 * t439 * t528 * t473 - 0.88204690297480567901234567901234567901234567901233e1 * t169 * t148 * t176 * t508 * t278 + 0.33812538575402223321170629477213839353757049230298e1 * t169 * t47 / t282 / t49 * t52 * t439 * t473
  t566 = 0.1000e4 / 0.243e3 * t119 * t308 * t261 - 0.1000e4 / 0.243e3 * t105 * t308 * t261 + 0.100e3 / 0.27e2 * t303 * t84 * t255 + 0.1250e4 / 0.2187e4 * t56 * t437 * t439 * t441 + (-0.82222222222222222222222222222222222222222222222222e-1 * t401 * t111 + 0.36543209876543209876543209876543209876543209876544e0 * t249 * t89 * t319 - 0.54814814814814814814814814814814814814814814814815e1 * t449 * t202 * t153 + 0.27407407407407407407407407407407407407407407407408e0 * t454 * t198 + 0.20301783264746227709190672153635116598079561042524e1 * t457 * t325 * t39 * t44 + 0.20301783264746227709190672153635116598079561042524e1 * t58 / t324 / t61 * t439 * t441 - 0.54814814814814814814814814814814814814814814814815e1 * t326 * t390 + 0.27407407407407407407407407407407407407407407407408e0 * t203 * t470 + 0.36543209876543209876543209876543209876543209876544e0 * t329 * t474 - 0.82222222222222222222222222222222222222222222222222e-1 * t116 * t402) * t67 + t549 * t59 + 0.25e2 / 0.27e2 * t191 * t470 + 0.100e3 / 0.81e2 * t312 * t474 - 0.100e3 / 0.27e2 * t339 * t84 * t255 - 0.1250e4 / 0.2187e4 * t65 * t437 * t439 * t441 - 0.25e2 / 0.27e2 * t213 * t470 - 0.100e3 / 0.81e2 * t347 * t474
  t611 = t238 ** 2
  t638 = -0.3e1 / 0.8e1 * t18 * t20 * (t427 + t566) * t73 - t18 * t141 * t352 * t73 / 0.2e1 + t18 * t33 * t218 * t73 / 0.2e1 - 0.5e1 / 0.9e1 * t18 * t23 * t124 * t73 + 0.68831654444444444444444444444444444444444444444442e-1 * t6 * t17 / t20 / t395 * t138 - 0.51905837777777777777777777777777777777777777777777e-1 * t134 * t228 - 0.71500873284711365905066666666666666666666666666669e-6 * t18 * t375 * t124 * t380 + 0.36942117863767539050951111111111111111111111111112e-5 * t18 / t21 / t231 / t79 * t69 * t380 - 0.19363370763577424782273212871111111111111111111112e-8 * t6 * t17 / t20 / t231 / t395 * t69 / t377 / t72 * t611 * t30 - 0.66005745369664000000000000000000000000000000000002e-4 * t368 * t218 * t236 * t239 - 0.40621960000000000000000000000000000000000000000000e-2 * t360 * t352 * t136 * t35 + 0.44003830246442666666666666666666666666666666666668e-3 * t234 * t370 + 0.18279882000000000000000000000000000000000000000000e-1 * t226 * t362 + 0.10e2 / 0.27e2 * t18 * t81 * t69 * t73 - 0.10206443959938785185185185185185185185185185185185e-2 * t6 * t17 / t231 / r0 * t240
  t639 = f.my_piecewise3(t2, 0, t638)
  v4rho4_0_ = 0.2e1 * r0 * t639 + 0.8e1 * t385

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t2 ** 2
  t47 = 4 ** (0.1e1 / 0.3e1)
  t49 = 0.8e1 / 0.27e2 * t44 * t45 * t47
  t50 = r0 ** (0.1e1 / 0.3e1)
  t51 = t50 ** 2
  t55 = r0 ** 2
  t57 = 0.1e1 / t51 / t55
  t58 = s0 * t57
  t60 = tau0 / t51 / r0 - t58 / 0.8e1
  t61 = 6 ** (0.1e1 / 0.3e1)
  t63 = jnp.pi ** 2
  t64 = t63 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t66 = 0.1e1 / t65
  t67 = t60 * t61 * t66
  t69 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t67
  t71 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t67
  t72 = 0.1e1 / t71
  t74 = 0.1e1 - t49
  t75 = t69 * t72 * t74
  t78 = t49 + 0.5e1 / 0.9e1 * t67 * t75
  t79 = 0.5e1 / 0.9e1 * t67
  t80 = 0.1e1 - t79
  t81 = Heaviside(t80)
  t83 = 0.1e1 + t79
  t84 = 0.1e1 / t83
  t87 = 0.1e1 + 0.148e0 * t80 * t84
  t89 = Heaviside(-t80)
  t91 = t78 * t81 + t87 * t89
  t94 = 0.1e1 + 0.1015549e-2 * t58
  t95 = 0.1e1 / t94
  t96 = t43 * t91 * t95
  t101 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t102 = t5 * t101
  t103 = t43 ** 2
  t104 = 0.1e1 / t103
  t106 = t104 * t91 * t95
  t111 = t55 * r0
  t113 = 0.1e1 / t51 / t111
  t114 = s0 * t113
  t116 = -0.5e1 / 0.3e1 * tau0 * t57 + t114 / 0.3e1
  t117 = t116 * t61
  t118 = t117 * t66
  t121 = t61 ** 2
  t124 = 0.1e1 / t64 / t63
  t125 = t60 * t121 * t124
  t127 = t116 * t72 * t74
  t130 = t71 ** 2
  t131 = 0.1e1 / t130
  t132 = t69 * t131
  t134 = t132 * t74 * t116
  t137 = 0.5e1 / 0.9e1 * t118 * t75 - 0.19862962962962962962962962962962962962962962962963e0 * t125 * t127 + 0.25189783950617283950617283950617283950617283950617e0 * t125 * t134
  t139 = Dirac(t80)
  t140 = t78 * t139
  t143 = t66 * t84
  t146 = t83 ** 2
  t147 = 0.1e1 / t146
  t148 = t80 * t147
  t151 = -0.82222222222222222222222222222222222222222222222222e-1 * t117 * t143 - 0.82222222222222222222222222222222222222222222222222e-1 * t148 * t118
  t153 = t87 * t139
  t156 = t137 * t81 - 0.5e1 / 0.9e1 * t140 * t118 + t151 * t89 + 0.5e1 / 0.9e1 * t153 * t118
  t158 = t43 * t156 * t95
  t162 = t5 * t101 * t43
  t163 = t94 ** 2
  t164 = 0.1e1 / t163
  t165 = t91 * t164
  t166 = t165 * t114
  t169 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t170 = t169 * f.p.zeta_threshold
  t172 = f.my_piecewise3(t20, t170, t21 * t19)
  t173 = t5 * t172
  t175 = 0.1e1 / t103 / t6
  t177 = t175 * t91 * t95
  t181 = t104 * t156 * t95
  t185 = t5 * t172 * t104
  t190 = t55 ** 2
  t192 = 0.1e1 / t51 / t190
  t193 = s0 * t192
  t195 = 0.40e2 / 0.9e1 * tau0 * t113 - 0.11e2 / 0.9e1 * t193
  t196 = t195 * t61
  t197 = t196 * t66
  t200 = t116 ** 2
  t201 = t200 * t121
  t206 = t201 * t124
  t214 = t63 ** 2
  t215 = 0.1e1 / t214
  t216 = t60 * t215
  t221 = t216 * t69
  t223 = 0.1e1 / t130 / t71
  t224 = t223 * t74
  t232 = 0.5e1 / 0.9e1 * t197 * t75 - 0.39725925925925925925925925925925925925925925925926e0 * t201 * t124 * t72 * t74 + 0.50379567901234567901234567901234567901234567901234e0 * t206 * t132 * t74 - 0.19862962962962962962962962962962962962962962962963e0 * t125 * t195 * t72 * t74 - 0.10807424906172839506172839506172839506172839506173e1 * t216 * t200 * t131 * t74 + 0.13705744654341563786008230452674897119341563786008e1 * t221 * t224 * t200 + 0.25189783950617283950617283950617283950617283950617e0 * t125 * t132 * t74 * t195
  t234 = t137 * t139
  t237 = Dirac(1, t80)
  t238 = t78 * t237
  t245 = t124 * t147
  t249 = 0.1e1 / t146 / t83
  t250 = t80 * t249
  t255 = -0.82222222222222222222222222222222222222222222222222e-1 * t196 * t143 + 0.91358024691358024691358024691358024691358024691358e-1 * t201 * t245 + 0.91358024691358024691358024691358024691358024691358e-1 * t250 * t206 - 0.82222222222222222222222222222222222222222222222222e-1 * t148 * t197
  t257 = t151 * t139
  t260 = t87 * t237
  t265 = t232 * t81 - 0.10e2 / 0.9e1 * t234 * t118 + 0.25e2 / 0.81e2 * t238 * t206 - 0.5e1 / 0.9e1 * t140 * t197 + t255 * t89 + 0.10e2 / 0.9e1 * t257 * t118 - 0.25e2 / 0.81e2 * t260 * t206 + 0.5e1 / 0.9e1 * t153 * t197
  t267 = t43 * t265 * t95
  t271 = t5 * t172 * t43
  t272 = t156 * t164
  t273 = t272 * t114
  t277 = 0.1e1 / t163 / t94
  t278 = t91 * t277
  t279 = s0 ** 2
  t283 = t279 / t50 / t190 / t111
  t284 = t278 * t283
  t287 = t165 * t193
  t290 = -0.3e1 / 0.8e1 * t42 * t96 - t102 * t106 / 0.4e1 - 0.3e1 / 0.4e1 * t102 * t158 - 0.20310980000000000000000000000000000000000000000000e-2 * t162 * t166 + t173 * t177 / 0.12e2 - t173 * t181 / 0.4e1 - 0.67703266666666666666666666666666666666666666666667e-3 * t185 * t166 - 0.3e1 / 0.8e1 * t173 * t267 - 0.20310980000000000000000000000000000000000000000000e-2 * t271 * t273 - 0.55004787808053333333333333333333333333333333333334e-5 * t271 * t284 + 0.37236796666666666666666666666666666666666666666667e-2 * t271 * t287
  t291 = f.my_piecewise3(t1, 0, t290)
  t293 = r1 <= f.p.dens_threshold
  t294 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t295 = 0.1e1 + t294
  t296 = t295 <= f.p.zeta_threshold
  t297 = t295 ** (0.1e1 / 0.3e1)
  t298 = t297 ** 2
  t299 = 0.1e1 / t298
  t301 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t302 = t301 ** 2
  t306 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t310 = f.my_piecewise3(t296, 0, 0.4e1 / 0.9e1 * t299 * t302 + 0.4e1 / 0.3e1 * t297 * t306)
  t311 = t5 * t310
  t312 = r1 ** (0.1e1 / 0.3e1)
  t313 = t312 ** 2
  t317 = r1 ** 2
  t320 = s2 / t313 / t317
  t324 = (tau1 / t313 / r1 - t320 / 0.8e1) * t61 * t66
  t335 = 0.5e1 / 0.9e1 * t324
  t336 = 0.1e1 - t335
  t337 = Heaviside(t336)
  t345 = Heaviside(-t336)
  t347 = (t49 + 0.5e1 / 0.9e1 * t324 * (0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t324) / (0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t324) * t74) * t337 + (0.1e1 + 0.148e0 * t336 / (0.1e1 + t335)) * t345
  t351 = 0.1e1 / (0.1e1 + 0.1015549e-2 * t320)
  t352 = t43 * t347 * t351
  t357 = f.my_piecewise3(t296, 0, 0.4e1 / 0.3e1 * t297 * t301)
  t358 = t5 * t357
  t360 = t104 * t347 * t351
  t364 = f.my_piecewise3(t296, t170, t297 * t295)
  t365 = t5 * t364
  t367 = t175 * t347 * t351
  t371 = f.my_piecewise3(t293, 0, -0.3e1 / 0.8e1 * t311 * t352 - t358 * t360 / 0.4e1 + t365 * t367 / 0.12e2)
  t389 = t24 ** 2
  t393 = 0.6e1 * t33 - 0.6e1 * t16 / t389
  t394 = f.my_piecewise5(t10, 0, t14, 0, t393)
  t398 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t394)
  t405 = 0.1e1 / t103 / t24
  t417 = s0 / t51 / t190 / r0
  t419 = -0.440e3 / 0.27e2 * tau0 * t192 + 0.154e3 / 0.27e2 * t417
  t420 = t419 * t61
  t421 = t420 * t66
  t424 = t195 * t121
  t425 = t424 * t124
  t430 = t200 * t116
  t431 = t430 * t215
  t432 = t131 * t74
  t448 = t61 * t66
  t452 = t130 ** 2
  t468 = 0.5e1 / 0.9e1 * t421 * t75 - 0.11917777777777777777777777777777777777777777777778e1 * t425 * t127 + 0.15113870370370370370370370370370370370370370370370e1 * t425 * t134 - 0.32422274718518518518518518518518518518518518518519e1 * t431 * t432 + 0.41117233963024691358024691358024691358024691358024e1 * t431 * t69 * t223 * t74 - 0.19862962962962962962962962962962962962962962962963e0 * t125 * t419 * t72 * t74 - 0.32422274718518518518518518518518518518518518518519e1 * t216 * t195 * t432 * t116 - 0.14700781716246761316872427983539094650205761316872e1 * t216 * t430 * t224 * t448 + 0.18643216323160354903978052126200274348422496570644e1 * t216 * t69 / t452 * t74 * t430 * t448 + 0.41117233963024691358024691358024691358024691358024e1 * t221 * t224 * t116 * t195 + 0.25189783950617283950617283950617283950617283950617e0 * t125 * t132 * t74 * t419
  t478 = Dirac(2, t80)
  t494 = t146 ** 2
  t522 = t468 * t81 - 0.5e1 / 0.3e1 * t232 * t139 * t118 + 0.25e2 / 0.27e2 * t137 * t237 * t206 - 0.5e1 / 0.3e1 * t234 * t197 - 0.250e3 / 0.243e3 * t78 * t478 * t431 + 0.25e2 / 0.27e2 * t238 * t116 * t425 - 0.5e1 / 0.9e1 * t140 * t421 + (-0.82222222222222222222222222222222222222222222222222e-1 * t420 * t143 + 0.27407407407407407407407407407407407407407407407408e0 * t424 * t245 * t116 - 0.91358024691358024691358024691358024691358024691358e0 * t431 * t249 - 0.91358024691358024691358024691358024691358024691358e0 * t80 / t494 * t431 + 0.27407407407407407407407407407407407407407407407408e0 * t250 * t116 * t425 - 0.82222222222222222222222222222222222222222222222222e-1 * t148 * t421) * t89 + 0.5e1 / 0.3e1 * t255 * t139 * t118 - 0.25e2 / 0.27e2 * t151 * t237 * t206 + 0.5e1 / 0.3e1 * t257 * t197 + 0.250e3 / 0.243e3 * t87 * t478 * t431 - 0.25e2 / 0.27e2 * t260 * t116 * t425 + 0.5e1 / 0.9e1 * t153 * t421
  t533 = t163 ** 2
  t537 = t190 ** 2
  t548 = t173 * t175 * t156 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t173 * t104 * t265 * t95 - 0.3e1 / 0.8e1 * t5 * t398 * t96 - 0.9e1 / 0.8e1 * t42 * t158 - 0.5e1 / 0.36e2 * t173 * t405 * t91 * t95 + t102 * t177 / 0.4e1 - 0.3e1 / 0.8e1 * t173 * t43 * t522 * t95 - 0.3e1 / 0.8e1 * t42 * t106 - 0.3e1 / 0.4e1 * t102 * t181 - 0.9e1 / 0.8e1 * t102 * t267 - 0.44688045802944603690666666666666666666666666666668e-7 * t271 * t91 / t533 * t279 * s0 / t537 / t111 - 0.30466470000000000000000000000000000000000000000000e-2 * t271 * t265 * t164 * t114
  t589 = -0.16501436342416000000000000000000000000000000000000e-4 * t271 * t156 * t277 * t283 - 0.20310980000000000000000000000000000000000000000001e-2 * t185 * t273 - 0.55004787808053333333333333333333333333333333333334e-5 * t185 * t284 - 0.16501436342416000000000000000000000000000000000000e-4 * t162 * t284 + 0.67703266666666666666666666666666666666666666666667e-3 * t5 * t172 * t175 * t166 - 0.60932940000000000000000000000000000000000000000000e-2 * t162 * t273 - 0.30466470000000000000000000000000000000000000000000e-2 * t5 * t41 * t43 * t166 - 0.20310980000000000000000000000000000000000000000001e-2 * t5 * t101 * t104 * t166 + 0.11171039000000000000000000000000000000000000000000e-1 * t162 * t287 + 0.37236796666666666666666666666666666666666666666667e-2 * t185 * t287 + 0.11171039000000000000000000000000000000000000000000e-1 * t271 * t272 * t193 + 0.60505266588858666666666666666666666666666666666668e-4 * t271 * t278 * t279 / t50 / t537 - 0.17377171777777777777777777777777777777777777777778e-1 * t271 * t165 * t417
  t591 = f.my_piecewise3(t1, 0, t548 + t589)
  t601 = f.my_piecewise5(t14, 0, t10, 0, -t393)
  t605 = f.my_piecewise3(t296, 0, -0.8e1 / 0.27e2 / t298 / t295 * t302 * t301 + 0.4e1 / 0.3e1 * t299 * t301 * t306 + 0.4e1 / 0.3e1 * t297 * t601)
  t618 = f.my_piecewise3(t293, 0, -0.3e1 / 0.8e1 * t5 * t605 * t352 - 0.3e1 / 0.8e1 * t311 * t360 + t358 * t367 / 0.4e1 - 0.5e1 / 0.36e2 * t365 * t405 * t347 * t351)
  d111 = 0.3e1 * t291 + 0.3e1 * t371 + t6 * (t591 + t618)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t28 = t5 * t25 * t26
  t29 = r0 ** 2
  t30 = t29 * r0
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / t30
  t37 = t29 ** 2
  t39 = 0.1e1 / t32 / t37
  t40 = s0 * t39
  t42 = 0.40e2 / 0.9e1 * tau0 * t34 - 0.11e2 / 0.9e1 * t40
  t43 = 6 ** (0.1e1 / 0.3e1)
  t44 = t42 * t43
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t54 = 0.1e1 / t32 / t29
  t55 = s0 * t54
  t57 = tau0 / t32 / r0 - t55 / 0.8e1
  t59 = t57 * t43 * t48
  t61 = 0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t59
  t63 = 0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t59
  t64 = 0.1e1 / t63
  t66 = 2 ** (0.1e1 / 0.3e1)
  t67 = t2 ** 2
  t69 = 4 ** (0.1e1 / 0.3e1)
  t71 = 0.8e1 / 0.27e2 * t66 * t67 * t69
  t72 = 0.1e1 - t71
  t73 = t61 * t64 * t72
  t78 = s0 * t34
  t80 = -0.5e1 / 0.3e1 * tau0 * t54 + t78 / 0.3e1
  t81 = t80 ** 2
  t82 = t43 ** 2
  t83 = t81 * t82
  t85 = 0.1e1 / t46 / t45
  t87 = t85 * t64 * t72
  t90 = t83 * t85
  t91 = t63 ** 2
  t92 = 0.1e1 / t91
  t93 = t61 * t92
  t94 = t93 * t72
  t98 = t57 * t82 * t85
  t103 = t45 ** 2
  t104 = 0.1e1 / t103
  t105 = t57 * t104
  t107 = t81 * t92 * t72
  t110 = t105 * t61
  t112 = 0.1e1 / t91 / t63
  t113 = t112 * t72
  t114 = t113 * t81
  t121 = 0.5e1 / 0.9e1 * t49 * t73 - 0.39725925925925925925925925925925925925925925925926e0 * t83 * t87 + 0.50379567901234567901234567901234567901234567901234e0 * t90 * t94 - 0.19862962962962962962962962962962962962962962962963e0 * t98 * t42 * t64 * t72 - 0.10807424906172839506172839506172839506172839506173e1 * t105 * t107 + 0.13705744654341563786008230452674897119341563786008e1 * t110 * t114 + 0.25189783950617283950617283950617283950617283950617e0 * t98 * t93 * t72 * t42
  t122 = 0.5e1 / 0.9e1 * t59
  t123 = 0.1e1 - t122
  t124 = Heaviside(t123)
  t126 = t80 * t43
  t127 = t126 * t48
  t131 = t80 * t64 * t72
  t135 = t93 * t72 * t80
  t138 = 0.5e1 / 0.9e1 * t127 * t73 - 0.19862962962962962962962962962962962962962962962963e0 * t98 * t131 + 0.25189783950617283950617283950617283950617283950617e0 * t98 * t135
  t139 = Dirac(t123)
  t140 = t138 * t139
  t145 = t71 + 0.5e1 / 0.9e1 * t59 * t73
  t146 = Dirac(1, t123)
  t147 = t145 * t146
  t150 = t145 * t139
  t153 = 0.1e1 + t122
  t154 = 0.1e1 / t153
  t155 = t48 * t154
  t158 = t153 ** 2
  t159 = 0.1e1 / t158
  t160 = t85 * t159
  t164 = 0.1e1 / t158 / t153
  t165 = t123 * t164
  t168 = t123 * t159
  t171 = -0.82222222222222222222222222222222222222222222222222e-1 * t44 * t155 + 0.91358024691358024691358024691358024691358024691358e-1 * t83 * t160 + 0.91358024691358024691358024691358024691358024691358e-1 * t165 * t90 - 0.82222222222222222222222222222222222222222222222222e-1 * t168 * t49
  t173 = Heaviside(-t123)
  t179 = -0.82222222222222222222222222222222222222222222222222e-1 * t126 * t155 - 0.82222222222222222222222222222222222222222222222222e-1 * t168 * t127
  t180 = t179 * t139
  t185 = 0.1e1 + 0.148e0 * t123 * t154
  t186 = t185 * t146
  t189 = t185 * t139
  t192 = t121 * t124 - 0.10e2 / 0.9e1 * t140 * t127 + 0.25e2 / 0.81e2 * t147 * t90 - 0.5e1 / 0.9e1 * t150 * t49 + t171 * t173 + 0.10e2 / 0.9e1 * t180 * t127 - 0.25e2 / 0.81e2 * t186 * t90 + 0.5e1 / 0.9e1 * t189 * t49
  t194 = 0.1e1 + 0.1015549e-2 * t55
  t195 = t194 ** 2
  t196 = 0.1e1 / t195
  t197 = t192 * t196
  t198 = t197 * t78
  t201 = t26 ** 2
  t202 = 0.1e1 / t201
  t204 = t5 * t25 * t202
  t211 = t138 * t124 - 0.5e1 / 0.9e1 * t150 * t127 + t179 * t173 + 0.5e1 / 0.9e1 * t189 * t127
  t212 = t211 * t196
  t213 = t212 * t78
  t218 = t145 * t124 + t185 * t173
  t220 = 0.1e1 / t195 / t194
  t221 = t218 * t220
  t222 = s0 ** 2
  t226 = t222 / t31 / t37 / t30
  t227 = t221 * t226
  t230 = t218 * t196
  t231 = t230 * t40
  t234 = t211 * t220
  t235 = t234 * t226
  t238 = t6 ** 2
  t239 = 0.1e1 / t238
  t241 = -t16 * t239 + t7
  t242 = f.my_piecewise5(t10, 0, t14, 0, t241)
  t245 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t242)
  t247 = t5 * t245 * t26
  t250 = t195 ** 2
  t251 = 0.1e1 / t250
  t252 = t218 * t251
  t253 = t222 * s0
  t254 = t37 ** 2
  t257 = t253 / t254 / t30
  t258 = t252 * t257
  t263 = t222 / t31 / t254
  t264 = t221 * t263
  t268 = t5 * t245 * t202
  t269 = t230 * t78
  t274 = 0.1e1 / t32 / t37 / r0
  t275 = s0 * t274
  t276 = t230 * t275
  t279 = t212 * t40
  t283 = 0.1e1 / t201 / t6
  t285 = t5 * t25 * t283
  t288 = -0.30466470000000000000000000000000000000000000000000e-2 * t28 * t198 - 0.20310980000000000000000000000000000000000000000001e-2 * t204 * t213 - 0.55004787808053333333333333333333333333333333333334e-5 * t204 * t227 + 0.37236796666666666666666666666666666666666666666667e-2 * t204 * t231 - 0.16501436342416000000000000000000000000000000000000e-4 * t28 * t235 - 0.16501436342416000000000000000000000000000000000000e-4 * t247 * t227 - 0.44688045802944603690666666666666666666666666666668e-7 * t28 * t258 + 0.60505266588858666666666666666666666666666666666668e-4 * t28 * t264 - 0.20310980000000000000000000000000000000000000000001e-2 * t268 * t269 - 0.17377171777777777777777777777777777777777777777778e-1 * t28 * t276 + 0.11171039000000000000000000000000000000000000000000e-1 * t28 * t279 + 0.67703266666666666666666666666666666666666666666667e-3 * t285 * t269
  t293 = t23 ** 2
  t294 = 0.1e1 / t293
  t295 = t242 ** 2
  t298 = t238 * t6
  t299 = 0.1e1 / t298
  t302 = 0.2e1 * t16 * t299 - 0.2e1 * t239
  t303 = f.my_piecewise5(t10, 0, t14, 0, t302)
  t307 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t294 * t295 + 0.4e1 / 0.3e1 * t23 * t303)
  t309 = t5 * t307 * t26
  t312 = t5 * t245
  t314 = 0.1e1 / t194
  t315 = t26 * t192 * t314
  t318 = t5 * t25
  t322 = -0.440e3 / 0.27e2 * tau0 * t39 + 0.154e3 / 0.27e2 * t275
  t323 = t322 * t43
  t324 = t323 * t48
  t327 = t42 * t82
  t328 = t327 * t85
  t333 = t81 * t80
  t334 = t333 * t104
  t335 = t92 * t72
  t347 = t335 * t80
  t351 = t43 * t48
  t355 = t91 ** 2
  t356 = 0.1e1 / t355
  t358 = t105 * t61 * t356
  t371 = 0.5e1 / 0.9e1 * t324 * t73 - 0.11917777777777777777777777777777777777777777777778e1 * t328 * t131 + 0.15113870370370370370370370370370370370370370370370e1 * t328 * t135 - 0.32422274718518518518518518518518518518518518518519e1 * t334 * t335 + 0.41117233963024691358024691358024691358024691358024e1 * t334 * t61 * t112 * t72 - 0.19862962962962962962962962962962962962962962962963e0 * t98 * t322 * t64 * t72 - 0.32422274718518518518518518518518518518518518518519e1 * t105 * t42 * t347 - 0.14700781716246761316872427983539094650205761316872e1 * t105 * t333 * t113 * t351 + 0.18643216323160354903978052126200274348422496570644e1 * t358 * t72 * t333 * t351 + 0.41117233963024691358024691358024691358024691358024e1 * t110 * t113 * t80 * t42 + 0.25189783950617283950617283950617283950617283950617e0 * t98 * t93 * t72 * t322
  t373 = t121 * t139
  t376 = t138 * t146
  t381 = Dirac(2, t123)
  t382 = t145 * t381
  t385 = t147 * t80
  t392 = t160 * t80
  t397 = t158 ** 2
  t398 = 0.1e1 / t397
  t399 = t123 * t398
  t402 = t165 * t80
  t407 = -0.82222222222222222222222222222222222222222222222222e-1 * t323 * t155 + 0.27407407407407407407407407407407407407407407407408e0 * t327 * t392 - 0.91358024691358024691358024691358024691358024691358e0 * t334 * t164 - 0.91358024691358024691358024691358024691358024691358e0 * t399 * t334 + 0.27407407407407407407407407407407407407407407407408e0 * t402 * t328 - 0.82222222222222222222222222222222222222222222222222e-1 * t168 * t324
  t409 = t171 * t139
  t412 = t179 * t146
  t417 = t185 * t381
  t420 = t186 * t80
  t425 = t371 * t124 - 0.5e1 / 0.3e1 * t373 * t127 + 0.25e2 / 0.27e2 * t376 * t90 - 0.5e1 / 0.3e1 * t140 * t49 - 0.250e3 / 0.243e3 * t382 * t334 + 0.25e2 / 0.27e2 * t385 * t328 - 0.5e1 / 0.9e1 * t150 * t324 + t407 * t173 + 0.5e1 / 0.3e1 * t409 * t127 - 0.25e2 / 0.27e2 * t412 * t90 + 0.5e1 / 0.3e1 * t180 * t49 + 0.250e3 / 0.243e3 * t417 * t334 - 0.25e2 / 0.27e2 * t420 * t328 + 0.5e1 / 0.9e1 * t189 * t324
  t427 = t26 * t425 * t314
  t431 = t202 * t211 * t314
  t435 = 0.1e1 / t201 / t238
  t437 = t435 * t218 * t314
  t441 = t283 * t218 * t314
  t444 = t5 * t307
  t446 = t202 * t218 * t314
  t450 = t283 * t211 * t314
  t454 = t202 * t192 * t314
  t458 = 0.1e1 / t293 / t19
  t462 = t294 * t242
  t465 = t238 ** 2
  t466 = 0.1e1 / t465
  t469 = -0.6e1 * t16 * t466 + 0.6e1 * t299
  t470 = f.my_piecewise5(t10, 0, t14, 0, t469)
  t474 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t458 * t295 * t242 + 0.4e1 / 0.3e1 * t462 * t303 + 0.4e1 / 0.3e1 * t23 * t470)
  t475 = t5 * t474
  t477 = t26 * t218 * t314
  t481 = t26 * t211 * t314
  t484 = 0.11171039000000000000000000000000000000000000000000e-1 * t247 * t231 - 0.60932940000000000000000000000000000000000000000000e-2 * t247 * t213 - 0.30466470000000000000000000000000000000000000000000e-2 * t309 * t269 - 0.9e1 / 0.8e1 * t312 * t315 - 0.3e1 / 0.8e1 * t318 * t427 - 0.3e1 / 0.4e1 * t312 * t431 - 0.5e1 / 0.36e2 * t318 * t437 + t312 * t441 / 0.4e1 - 0.3e1 / 0.8e1 * t444 * t446 + t318 * t450 / 0.4e1 - 0.3e1 / 0.8e1 * t318 * t454 - 0.3e1 / 0.8e1 * t475 * t477 - 0.9e1 / 0.8e1 * t444 * t481
  t486 = f.my_piecewise3(t1, 0, t288 + t484)
  t488 = r1 <= f.p.dens_threshold
  t489 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t490 = 0.1e1 + t489
  t491 = t490 <= f.p.zeta_threshold
  t492 = t490 ** (0.1e1 / 0.3e1)
  t493 = t492 ** 2
  t495 = 0.1e1 / t493 / t490
  t497 = f.my_piecewise5(t14, 0, t10, 0, -t241)
  t498 = t497 ** 2
  t502 = 0.1e1 / t493
  t503 = t502 * t497
  t505 = f.my_piecewise5(t14, 0, t10, 0, -t302)
  t509 = f.my_piecewise5(t14, 0, t10, 0, -t469)
  t513 = f.my_piecewise3(t491, 0, -0.8e1 / 0.27e2 * t495 * t498 * t497 + 0.4e1 / 0.3e1 * t503 * t505 + 0.4e1 / 0.3e1 * t492 * t509)
  t514 = t5 * t513
  t515 = r1 ** (0.1e1 / 0.3e1)
  t516 = t515 ** 2
  t520 = r1 ** 2
  t523 = s2 / t516 / t520
  t527 = (tau1 / t516 / r1 - t523 / 0.8e1) * t43 * t48
  t538 = 0.5e1 / 0.9e1 * t527
  t539 = 0.1e1 - t538
  t540 = Heaviside(t539)
  t548 = Heaviside(-t539)
  t550 = (t71 + 0.5e1 / 0.9e1 * t527 * (0.827411e0 - 0.35753333333333333333333333333333333333333333333333e0 * t527) / (0.10e1 - 0.45341611111111111111111111111111111111111111111111e0 * t527) * t72) * t540 + (0.1e1 + 0.148e0 * t539 / (0.1e1 + t538)) * t548
  t554 = 0.1e1 / (0.1e1 + 0.1015549e-2 * t523)
  t555 = t26 * t550 * t554
  t563 = f.my_piecewise3(t491, 0, 0.4e1 / 0.9e1 * t502 * t498 + 0.4e1 / 0.3e1 * t492 * t505)
  t564 = t5 * t563
  t566 = t202 * t550 * t554
  t571 = f.my_piecewise3(t491, 0, 0.4e1 / 0.3e1 * t492 * t497)
  t572 = t5 * t571
  t574 = t283 * t550 * t554
  t578 = f.my_piecewise3(t491, t22, t492 * t490)
  t579 = t5 * t578
  t581 = t435 * t550 * t554
  t585 = f.my_piecewise3(t488, 0, -0.3e1 / 0.8e1 * t514 * t555 - 0.3e1 / 0.8e1 * t564 * t566 + t572 * t574 / 0.4e1 - 0.5e1 / 0.36e2 * t579 * t581)
  t589 = t37 * t29
  t592 = s0 / t32 / t589
  t594 = 0.6160e4 / 0.81e2 * tau0 * t274 - 0.2618e4 / 0.81e2 * t592
  t595 = t594 * t43
  t596 = t595 * t48
  t607 = t81 * t104 * t42
  t627 = 0.5e1 / 0.9e1 * t189 * t596 + 0.10e2 / 0.3e1 * t409 * t49 - 0.50e2 / 0.27e2 * t171 * t146 * t90 + 0.20e2 / 0.9e1 * t180 * t324 + 0.500e3 / 0.81e2 * t417 * t607 - 0.500e3 / 0.81e2 * t382 * t607 - 0.5e1 / 0.9e1 * t150 * t596 + 0.20e2 / 0.9e1 * t407 * t139 * t127 - 0.20e2 / 0.9e1 * t371 * t139 * t127 - 0.10e2 / 0.3e1 * t373 * t49 + 0.50e2 / 0.27e2 * t121 * t146 * t90 - 0.20e2 / 0.9e1 * t140 * t324
  t628 = t42 ** 2
  t629 = t628 * t82
  t630 = t629 * t85
  t633 = t82 * t85
  t634 = t633 * t322
  t640 = Dirac(3, t123)
  t642 = t81 ** 2
  t644 = t351 * t104
  t663 = t42 * t104
  t669 = t642 * t104
  t694 = t72 * t81
  t732 = t356 * t72
  t758 = -0.19453364831111111111111111111111111111111111111112e2 * t663 * t107 - 0.88204690297480567901234567901234567901234567901233e1 * t105 * t42 * t112 * t694 * t351 + 0.33812538575402223321170629477213839353757049230298e1 * t105 * t61 / t355 / t63 * t72 * t642 * t633 - 0.43229699624691358024691358024691358024691358024692e1 * t105 * t322 * t347 - 0.32422274718518518518518518518518518518518518518519e1 * t105 * t628 * t92 * t72 + 0.5e1 / 0.9e1 * t596 * t73 - 0.15890370370370370370370370370370370370370370370370e1 * t634 * t131 - 0.11917777777777777777777777777777777777777777777778e1 * t629 * t87 + 0.24670340377814814814814814814814814814814814814814e2 * t663 * t61 * t114 - 0.58803126864987045267489711934156378600823045267489e1 * t669 * t112 * t72 * t43 * t48 - 0.19862962962962962962962962962962962962962962962963e0 * t98 * t594 * t64 * t72 - 0.26662285104295728893342478280749885688157293095563e1 * t105 * t642 * t732 * t633 + 0.41117233963024691358024691358024691358024691358024e1 * t110 * t113 * t628 + 0.54822978617366255144032921810699588477366255144032e1 * t110 * t113 * t80 * t322 + 0.25189783950617283950617283950617283950617283950617e0 * t98 * t93 * t72 * t594 + 0.20151827160493827160493827160493827160493827160494e1 * t634 * t135 + 0.15113870370370370370370370370370370370370370370370e1 * t630 * t94 + 0.74572865292641419615912208504801097393689986282576e1 * t669 * t61 * t732 * t351 + 0.11185929793896212942386831275720164609053497942386e2 * t358 * t694 * t49
  t766 = -0.25e2 / 0.27e2 * t186 * t630 - 0.100e3 / 0.81e2 * t420 * t634 - 0.100e3 / 0.27e2 * t412 * t80 * t328 - 0.1250e4 / 0.2187e4 * t185 * t640 * t642 * t644 + 0.1250e4 / 0.2187e4 * t145 * t640 * t642 * t644 + 0.25e2 / 0.27e2 * t147 * t630 + 0.100e3 / 0.81e2 * t385 * t634 + 0.100e3 / 0.27e2 * t376 * t80 * t328 + (-0.82222222222222222222222222222222222222222222222222e-1 * t595 * t155 + 0.36543209876543209876543209876543209876543209876544e0 * t322 * t82 * t392 - 0.54814814814814814814814814814814814814814814814815e1 * t663 * t164 * t81 + 0.27407407407407407407407407407407407407407407407408e0 * t629 * t160 + 0.20301783264746227709190672153635116598079561042524e1 * t669 * t398 * t43 * t48 + 0.20301783264746227709190672153635116598079561042524e1 * t123 / t397 / t153 * t642 * t644 - 0.54814814814814814814814814814814814814814814814815e1 * t399 * t607 + 0.27407407407407407407407407407407407407407407407408e0 * t165 * t630 + 0.36543209876543209876543209876543209876543209876544e0 * t402 * t634 - 0.82222222222222222222222222222222222222222222222222e-1 * t168 * t596) * t173 + t758 * t124 - 0.1000e4 / 0.243e3 * t138 * t381 * t334 + 0.1000e4 / 0.243e3 * t179 * t381 * t334
  t793 = t222 ** 2
  t807 = -0.3e1 / 0.8e1 * t318 * t26 * (t627 + t766) * t314 - 0.3e1 / 0.2e1 * t312 * t454 - 0.3e1 / 0.2e1 * t312 * t427 + t444 * t441 / 0.2e1 - t475 * t446 / 0.2e1 - 0.69508687111111111111111111111111111111111111111111e-1 * t28 * t212 * t275 + 0.44684156000000000000000000000000000000000000000000e-1 * t247 * t279 + 0.22342078000000000000000000000000000000000000000000e-1 * t28 * t197 * t40 - 0.17875218321177841476266666666666666666666666666667e-6 * t247 * t258 - 0.48408426908943561955683032177777777777777777777781e-9 * t28 * t218 / t250 / t194 * t793 / t32 / t254 / t589 - 0.40621960000000000000000000000000000000000000000001e-2 * t5 * t307 * t202 * t269 - 0.81243920000000000000000000000000000000000000000002e-2 * t268 * t213
  t842 = -0.66005745369664000000000000000000000000000000000000e-4 * t247 * t235 - 0.33002872684832000000000000000000000000000000000000e-4 * t28 * t192 * t220 * t226 - 0.17875218321177841476266666666666666666666666666667e-6 * t28 * t211 * t251 * t257 - 0.33002872684832000000000000000000000000000000000000e-4 * t309 * t227 - 0.22001915123221333333333333333333333333333333333334e-4 * t268 * t227 - 0.22001915123221333333333333333333333333333333333334e-4 * t204 * t235 - 0.59584061070592804920888888888888888888888888888891e-7 * t204 * t258 + 0.14894718666666666666666666666666666666666666666667e-1 * t268 * t231 + 0.14894718666666666666666666666666666666666666666667e-1 * t204 * t279 - 0.40621960000000000000000000000000000000000000000001e-2 * t204 * t198 - 0.40621960000000000000000000000000000000000000000000e-2 * t5 * t474 * t26 * t269 - 0.40621960000000000000000000000000000000000000000000e-2 * t28 * t425 * t196 * t78 + 0.73339717077404444444444444444444444444444444444446e-5 * t285 * t227
  t883 = 0.80673688785144888888888888888888888888888888888891e-4 * t204 * t264 - 0.49649062222222222222222222222222222222222222222222e-2 * t285 * t231 - 0.23169562370370370370370370370370370370370370370371e-1 * t204 * t276 + 0.24202106635543466666666666666666666666666666666667e-3 * t28 * t234 * t263 + 0.24202106635543466666666666666666666666666666666667e-3 * t247 * t264 + 0.98313700766478128119466666666666666666666666666670e-6 * t28 * t252 * t253 / t254 / t37 - 0.59832985848982459259259259259259259259259259259261e-3 * t28 * t221 * t222 / t31 / t254 / r0 + 0.27081306666666666666666666666666666666666666666668e-2 * t5 * t245 * t283 * t269 + 0.98470640074074074074074074074074074074074074074075e-1 * t28 * t230 * t592 - 0.15045170370370370370370370370370370370370370370371e-2 * t5 * t25 * t435 * t269 - 0.12186588000000000000000000000000000000000000000000e-1 * t309 * t213 - 0.12186588000000000000000000000000000000000000000000e-1 * t247 * t198
  t902 = t19 ** 2
  t905 = t295 ** 2
  t911 = t303 ** 2
  t920 = -0.24e2 * t466 + 0.24e2 * t16 / t465 / t6
  t921 = f.my_piecewise5(t10, 0, t14, 0, t920)
  t925 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t293 / t902 * t905 - 0.16e2 / 0.9e1 * t458 * t295 * t303 + 0.4e1 / 0.3e1 * t294 * t911 + 0.16e2 / 0.9e1 * t462 * t470 + 0.4e1 / 0.3e1 * t23 * t921)
  t938 = 0.1e1 / t201 / t298
  t944 = 0.27081306666666666666666666666666666666666666666668e-2 * t285 * t213 + 0.22342078000000000000000000000000000000000000000000e-1 * t309 * t231 - 0.69508687111111111111111111111111111111111111111111e-1 * t247 * t276 + t318 * t283 * t192 * t314 / 0.2e1 - 0.5e1 / 0.9e1 * t312 * t437 - 0.5e1 / 0.9e1 * t318 * t435 * t211 * t314 - 0.3e1 / 0.2e1 * t444 * t431 - 0.3e1 / 0.8e1 * t5 * t925 * t477 - t318 * t202 * t425 * t314 / 0.2e1 - 0.3e1 / 0.2e1 * t475 * t481 - 0.9e1 / 0.4e1 * t444 * t315 + 0.10e2 / 0.27e2 * t318 * t938 * t218 * t314 + t312 * t450
  t947 = f.my_piecewise3(t1, 0, t807 + t842 + t883 + t944)
  t948 = t490 ** 2
  t951 = t498 ** 2
  t957 = t505 ** 2
  t963 = f.my_piecewise5(t14, 0, t10, 0, -t920)
  t967 = f.my_piecewise3(t491, 0, 0.40e2 / 0.81e2 / t493 / t948 * t951 - 0.16e2 / 0.9e1 * t495 * t498 * t505 + 0.4e1 / 0.3e1 * t502 * t957 + 0.16e2 / 0.9e1 * t503 * t509 + 0.4e1 / 0.3e1 * t492 * t963)
  t982 = f.my_piecewise3(t488, 0, -0.3e1 / 0.8e1 * t5 * t967 * t555 - t514 * t566 / 0.2e1 + t564 * t574 / 0.2e1 - 0.5e1 / 0.9e1 * t572 * t581 + 0.10e2 / 0.27e2 * t579 * t938 * t550 * t554)
  d1111 = 0.4e1 * t486 + 0.4e1 * t585 + t6 * (t947 + t982)

  res = {'v4rho4': d1111}
  return res
