"""Generated from mgga_x_pkzb.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  pkzb_a2 = 146 / 2025

  pkzb_a3 = -73 / 405

  pkzb_a4 = 0.13195718784525778

  pkzb_kappa = 0.804

  pkzb_xx = lambda p, qt: MU_GE * p + pkzb_a2 * qt * qt + pkzb_a3 * qt * p + pkzb_a4 * p * p

  pkzb_f = lambda x, u, t: 1 + pkzb_kappa - pkzb_kappa ** 2 / (pkzb_kappa + pkzb_xx(X2S ** 2 * x ** 2, 6 * X2S ** 2 * t - 9 / 20 - X2S ** 2 * x ** 2 / 12))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pkzb_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  pkzb_a2 = 146 / 2025

  pkzb_a3 = -73 / 405

  pkzb_a4 = 0.13195718784525778

  pkzb_kappa = 0.804

  pkzb_xx = lambda p, qt: MU_GE * p + pkzb_a2 * qt * qt + pkzb_a3 * qt * p + pkzb_a4 * p * p

  pkzb_f = lambda x, u, t: 1 + pkzb_kappa - pkzb_kappa ** 2 / (pkzb_kappa + pkzb_xx(X2S ** 2 * x ** 2, 6 * X2S ** 2 * t - 9 / 20 - X2S ** 2 * x ** 2 / 12))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pkzb_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  pkzb_a2 = 146 / 2025

  pkzb_a3 = -73 / 405

  pkzb_a4 = 0.13195718784525778

  pkzb_kappa = 0.804

  pkzb_xx = lambda p, qt: MU_GE * p + pkzb_a2 * qt * qt + pkzb_a3 * qt * p + pkzb_a4 * p * p

  pkzb_f = lambda x, u, t: 1 + pkzb_kappa - pkzb_kappa ** 2 / (pkzb_kappa + pkzb_xx(X2S ** 2 * x ** 2, 6 * X2S ** 2 * t - 9 / 20 - X2S ** 2 * x ** 2 / 12))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pkzb_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t43 = 0.1e1 / t36 / r0
  t45 = t33 * tau0 * t43
  t48 = 0.73e2 / 0.4050e4 * t45 - 0.73e2 / 0.2250e4 - 0.73e2 / 0.291600e6 * t40
  t51 = t45 / 0.4e1 - 0.9e1 / 0.20e2 - t40 / 0.288e3
  t56 = (-0.73e2 / 0.1620e4 * t45 + 0.73e2 / 0.900e3 + 0.73e2 / 0.116640e6 * t40) * t28
  t57 = t32 * s0
  t58 = t57 * t38
  t61 = t28 ** 2
  t64 = t61 / t30 / t29
  t65 = s0 ** 2
  t66 = t34 ** 2
  t69 = 0.1e1 / t35 / t66 / r0
  t73 = 0.804e0 + 0.5e1 / 0.972e3 * t40 + t48 * t51 + t56 * t58 / 0.24e2 + 0.22909234000912809658291212568229166666666666666667e-3 * t64 * t65 * t69
  t76 = 0.1804e1 - 0.646416e0 / t73
  t80 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t76)
  t81 = r1 <= f.p.dens_threshold
  t82 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t83 = 0.1e1 + t82
  t84 = t83 <= f.p.zeta_threshold
  t85 = t83 ** (0.1e1 / 0.3e1)
  t87 = f.my_piecewise3(t84, t22, t85 * t83)
  t89 = r1 ** 2
  t90 = r1 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t93 = 0.1e1 / t91 / t89
  t95 = t33 * s2 * t93
  t98 = 0.1e1 / t91 / r1
  t100 = t33 * tau1 * t98
  t103 = 0.73e2 / 0.4050e4 * t100 - 0.73e2 / 0.2250e4 - 0.73e2 / 0.291600e6 * t95
  t106 = t100 / 0.4e1 - 0.9e1 / 0.20e2 - t95 / 0.288e3
  t111 = (-0.73e2 / 0.1620e4 * t100 + 0.73e2 / 0.900e3 + 0.73e2 / 0.116640e6 * t95) * t28
  t112 = t32 * s2
  t113 = t112 * t93
  t116 = s2 ** 2
  t117 = t89 ** 2
  t120 = 0.1e1 / t90 / t117 / r1
  t124 = 0.804e0 + 0.5e1 / 0.972e3 * t95 + t103 * t106 + t111 * t113 / 0.24e2 + 0.22909234000912809658291212568229166666666666666667e-3 * t64 * t116 * t120
  t127 = 0.1804e1 - 0.646416e0 / t124
  t131 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t87 * t26 * t127)
  t132 = t6 ** 2
  t134 = t16 / t132
  t135 = t7 - t134
  t136 = f.my_piecewise5(t10, 0, t14, 0, t135)
  t139 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t136)
  t144 = t26 ** 2
  t145 = 0.1e1 / t144
  t149 = t5 * t25 * t145 * t76 / 0.8e1
  t150 = t5 * t25
  t151 = t73 ** 2
  t153 = t26 / t151
  t156 = 0.1e1 / t36 / t34 / r0
  t158 = t33 * s0 * t156
  t161 = t33 * tau0 * t38
  t190 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t139 * t26 * t76 - t149 - 0.24240600000000000000000000000000000000000000000000e0 * t150 * t153 * (-0.10e2 / 0.729e3 * t158 + (-0.73e2 / 0.2430e4 * t161 + 0.73e2 / 0.109350e6 * t158) * t51 + t48 * (-0.5e1 / 0.12e2 * t161 + t158 / 0.108e3) + (0.73e2 / 0.972e3 * t161 - 0.73e2 / 0.43740e5 * t158) * t28 * t58 / 0.24e2 - t56 * t57 * t156 / 0.9e1 - 0.12218258133820165151088646703055555555555555555556e-2 * t64 * t65 / t35 / t66 / t34))
  t192 = f.my_piecewise5(t14, 0, t10, 0, -t135)
  t195 = f.my_piecewise3(t84, 0, 0.4e1 / 0.3e1 * t85 * t192)
  t203 = t5 * t87 * t145 * t127 / 0.8e1
  t205 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t195 * t26 * t127 - t203)
  vrho_0_ = t80 + t131 + t6 * (t190 + t205)
  t208 = -t7 - t134
  t209 = f.my_piecewise5(t10, 0, t14, 0, t208)
  t212 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t209)
  t218 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t212 * t26 * t76 - t149)
  t220 = f.my_piecewise5(t14, 0, t10, 0, -t208)
  t223 = f.my_piecewise3(t84, 0, 0.4e1 / 0.3e1 * t85 * t220)
  t228 = t5 * t87
  t229 = t124 ** 2
  t231 = t26 / t229
  t234 = 0.1e1 / t91 / t89 / r1
  t236 = t33 * s2 * t234
  t239 = t33 * tau1 * t93
  t268 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t223 * t26 * t127 - t203 - 0.24240600000000000000000000000000000000000000000000e0 * t228 * t231 * (-0.10e2 / 0.729e3 * t236 + (-0.73e2 / 0.2430e4 * t239 + 0.73e2 / 0.109350e6 * t236) * t106 + t103 * (-0.5e1 / 0.12e2 * t239 + t236 / 0.108e3) + (0.73e2 / 0.972e3 * t239 - 0.73e2 / 0.43740e5 * t236) * t28 * t113 / 0.24e2 - t111 * t112 * t234 / 0.9e1 - 0.12218258133820165151088646703055555555555555555556e-2 * t64 * t116 / t90 / t117 / t89))
  vrho_1_ = t80 + t131 + t6 * (t218 + t268)
  t276 = t48 * t28
  t277 = t32 * t38
  t289 = f.my_piecewise3(t1, 0, -0.24240600000000000000000000000000000000000000000000e0 * t150 * t153 * (0.5e1 / 0.972e3 * t33 * t38 - 0.73e2 / 0.291600e6 * t33 * t38 * t51 - t276 * t277 / 0.288e3 + 0.48426206913576876746852201085246627800640146319159e-3 * t64 * t69 * s0 + t56 * t277 / 0.24e2))
  vsigma_0_ = t6 * t289
  vsigma_1_ = 0.0e0
  t295 = t103 * t28
  t296 = t32 * t93
  t308 = f.my_piecewise3(t81, 0, -0.24240600000000000000000000000000000000000000000000e0 * t228 * t231 * (0.5e1 / 0.972e3 * t33 * t93 - 0.73e2 / 0.291600e6 * t33 * t93 * t106 - t295 * t296 / 0.288e3 + 0.48426206913576876746852201085246627800640146319159e-3 * t64 * t120 * s2 + t111 * t296 / 0.24e2))
  vsigma_2_ = t6 * t308
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t324 = f.my_piecewise3(t1, 0, -0.24240600000000000000000000000000000000000000000000e0 * t150 * t153 * (0.73e2 / 0.4050e4 * t33 * t43 * t51 + t276 * t32 * t43 / 0.4e1 - 0.73e2 / 0.38880e5 * t64 / t35 / t66 * s0))
  vtau_0_ = t6 * t324
  t340 = f.my_piecewise3(t81, 0, -0.24240600000000000000000000000000000000000000000000e0 * t228 * t231 * (0.73e2 / 0.4050e4 * t33 * t98 * t106 + t295 * t32 * t98 / 0.4e1 - 0.73e2 / 0.38880e5 * t64 / t90 / t117 * s2))
  vtau_1_ = t6 * t340
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  pkzb_a2 = 146 / 2025

  pkzb_a3 = -73 / 405

  pkzb_a4 = 0.13195718784525778

  pkzb_kappa = 0.804

  pkzb_xx = lambda p, qt: MU_GE * p + pkzb_a2 * qt * qt + pkzb_a3 * qt * p + pkzb_a4 * p * p

  pkzb_f = lambda x, u, t: 1 + pkzb_kappa - pkzb_kappa ** 2 / (pkzb_kappa + pkzb_xx(X2S ** 2 * x ** 2, 6 * X2S ** 2 * t - 9 / 20 - X2S ** 2 * x ** 2 / 12))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, pkzb_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = t25 * t33
  t36 = tau0 * t27
  t38 = 0.1e1 / t30 / r0
  t40 = t25 * t36 * t38
  t43 = 0.73e2 / 0.4050e4 * t40 - 0.73e2 / 0.2250e4 - 0.73e2 / 0.291600e6 * t34
  t46 = t40 / 0.4e1 - 0.9e1 / 0.20e2 - t34 / 0.288e3
  t51 = (-0.73e2 / 0.1620e4 * t40 + 0.73e2 / 0.900e3 + 0.73e2 / 0.116640e6 * t34) * t20
  t52 = t51 * t24
  t55 = t20 ** 2
  t58 = t55 / t22 / t21
  t59 = s0 ** 2
  t60 = t59 * t26
  t61 = t29 ** 2
  t64 = 0.1e1 / t18 / t61 / r0
  t68 = 0.804e0 + 0.5e1 / 0.972e3 * t34 + t43 * t46 + t52 * t33 / 0.24e2 + 0.45818468001825619316582425136458333333333333333334e-3 * t58 * t60 * t64
  t71 = 0.1804e1 - 0.646416e0 / t68
  t75 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t71)
  t81 = t6 * t17
  t82 = t68 ** 2
  t84 = t18 / t82
  t88 = t28 / t30 / t29 / r0
  t89 = t25 * t88
  t92 = t25 * t36 * t32
  t121 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t71 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t81 * t84 * (-0.10e2 / 0.729e3 * t89 + (-0.73e2 / 0.2430e4 * t92 + 0.73e2 / 0.109350e6 * t89) * t46 + t43 * (-0.5e1 / 0.12e2 * t92 + t89 / 0.108e3) + (0.73e2 / 0.972e3 * t92 - 0.73e2 / 0.43740e5 * t89) * t20 * t24 * t33 / 0.24e2 - t52 * t88 / 0.9e1 - 0.24436516267640330302177293406111111111111111111111e-2 * t58 * t60 / t18 / t61 / t29))
  vrho_0_ = 0.2e1 * r0 * t121 + 0.2e1 * t75
  t124 = t27 * t32
  t130 = t43 * t20
  t131 = t24 * t27
  t132 = t131 * t32
  t145 = f.my_piecewise3(t2, 0, -0.24240600000000000000000000000000000000000000000000e0 * t81 * t84 * (0.5e1 / 0.972e3 * t25 * t124 - 0.73e2 / 0.291600e6 * t25 * t124 * t46 - t130 * t132 / 0.288e3 + 0.96852413827153753493704402170493255601280292638319e-3 * t58 * t26 * t64 * s0 + t51 * t132 / 0.24e2))
  vsigma_0_ = 0.2e1 * r0 * t145
  vlapl_0_ = 0.0e0
  t164 = f.my_piecewise3(t2, 0, -0.24240600000000000000000000000000000000000000000000e0 * t81 * t84 * (0.73e2 / 0.4050e4 * t25 * t27 * t38 * t46 + t130 * t131 * t38 / 0.4e1 - 0.73e2 / 0.19440e5 * t58 * t26 / t18 / t61 * s0))
  vtau_0_ = 0.2e1 * r0 * t164
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = 0.1e1 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t27 = t22 * t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t34 = t30 * t33
  t35 = t27 * t34
  t37 = tau0 * t29
  t39 = 0.1e1 / t19 / r0
  t44 = t27 * t37 * t39 / 0.4e1 - 0.9e1 / 0.20e2 - t35 / 0.288e3
  t45 = t44 ** 2
  t48 = t44 * t22 * t26
  t51 = t22 ** 2
  t54 = t51 / t24 / t23
  t55 = s0 ** 2
  t56 = t55 * t28
  t57 = t31 ** 2
  t64 = 0.804e0 + 0.5e1 / 0.972e3 * t35 + 0.146e3 / 0.2025e4 * t45 - 0.73e2 / 0.9720e4 * t48 * t34 + 0.45818468001825619316582425136458333333333333333334e-3 * t54 * t56 / t18 / t57 / r0
  t67 = 0.1804e1 - 0.646416e0 / t64
  t71 = t6 * t17
  t72 = t64 ** 2
  t73 = 0.1e1 / t72
  t74 = t18 * t73
  t75 = t31 * r0
  t77 = 0.1e1 / t19 / t75
  t78 = t30 * t77
  t79 = t27 * t78
  t85 = -0.5e1 / 0.12e2 * t27 * t37 * t33 + t79 / 0.108e3
  t89 = t85 * t22 * t26
  t100 = -0.10e2 / 0.729e3 * t79 + 0.292e3 / 0.2025e4 * t44 * t85 - 0.73e2 / 0.9720e4 * t89 * t34 + 0.73e2 / 0.3645e4 * t48 * t78 - 0.24436516267640330302177293406111111111111111111111e-2 * t54 * t56 / t18 / t57 / t31
  t105 = f.my_piecewise3(t2, 0, -t6 * t17 * t20 * t67 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t71 * t74 * t100)
  t118 = t100 ** 2
  t124 = t30 / t19 / t57
  t125 = t27 * t124
  t127 = t85 ** 2
  t133 = 0.10e2 / 0.9e1 * t27 * t37 * t77 - 0.11e2 / 0.324e3 * t125
  t155 = f.my_piecewise3(t2, 0, t6 * t17 * t39 * t67 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t71 * t20 * t73 * t100 + 0.48481200000000000000000000000000000000000000000000e0 * t71 * t18 / t72 / t64 * t118 - 0.24240600000000000000000000000000000000000000000000e0 * t71 * t74 * (0.110e3 / 0.2187e4 * t125 + 0.292e3 / 0.2025e4 * t127 + 0.292e3 / 0.2025e4 * t44 * t133 - 0.73e2 / 0.9720e4 * t133 * t22 * t26 * t34 + 0.146e3 / 0.3645e4 * t89 * t78 - 0.803e3 / 0.10935e5 * t48 * t124 + 0.15476460302838875858045619157203703703703703703704e-1 * t54 * t56 / t18 / t57 / t75))
  v2rho2_0_ = 0.2e1 * r0 * t155 + 0.4e1 * t105
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t35 = t31 * t34
  t36 = t28 * t35
  t38 = tau0 * t30
  t43 = t28 * t38 * t21 / 0.4e1 - 0.9e1 / 0.20e2 - t36 / 0.288e3
  t44 = t43 ** 2
  t47 = t43 * t23 * t27
  t50 = t23 ** 2
  t53 = t50 / t25 / t24
  t54 = s0 ** 2
  t55 = t54 * t29
  t56 = t32 ** 2
  t57 = t56 * r0
  t63 = 0.804e0 + 0.5e1 / 0.972e3 * t36 + 0.146e3 / 0.2025e4 * t44 - 0.73e2 / 0.9720e4 * t47 * t35 + 0.45818468001825619316582425136458333333333333333334e-3 * t53 * t55 / t18 / t57
  t66 = 0.1804e1 - 0.646416e0 / t63
  t70 = t6 * t17
  t71 = 0.1e1 / t19
  t72 = t63 ** 2
  t73 = 0.1e1 / t72
  t74 = t71 * t73
  t75 = t32 * r0
  t77 = 0.1e1 / t19 / t75
  t78 = t31 * t77
  t79 = t28 * t78
  t85 = -0.5e1 / 0.12e2 * t28 * t38 * t34 + t79 / 0.108e3
  t89 = t85 * t23 * t27
  t100 = -0.10e2 / 0.729e3 * t79 + 0.292e3 / 0.2025e4 * t43 * t85 - 0.73e2 / 0.9720e4 * t89 * t35 + 0.73e2 / 0.3645e4 * t47 * t78 - 0.24436516267640330302177293406111111111111111111111e-2 * t53 * t55 / t18 / t56 / t32
  t105 = 0.1e1 / t72 / t63
  t106 = t18 * t105
  t107 = t100 ** 2
  t111 = t18 * t73
  t113 = 0.1e1 / t19 / t56
  t114 = t31 * t113
  t115 = t28 * t114
  t117 = t85 ** 2
  t123 = 0.10e2 / 0.9e1 * t28 * t38 * t77 - 0.11e2 / 0.324e3 * t115
  t127 = t123 * t23 * t27
  t140 = 0.110e3 / 0.2187e4 * t115 + 0.292e3 / 0.2025e4 * t117 + 0.292e3 / 0.2025e4 * t43 * t123 - 0.73e2 / 0.9720e4 * t127 * t35 + 0.146e3 / 0.3645e4 * t89 * t78 - 0.803e3 / 0.10935e5 * t47 * t114 + 0.15476460302838875858045619157203703703703703703704e-1 * t53 * t55 / t18 / t56 / t75
  t145 = f.my_piecewise3(t2, 0, t6 * t17 * t21 * t66 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t70 * t74 * t100 + 0.48481200000000000000000000000000000000000000000000e0 * t70 * t106 * t107 - 0.24240600000000000000000000000000000000000000000000e0 * t70 * t111 * t140)
  t162 = t72 ** 2
  t175 = t31 / t19 / t57
  t176 = t28 * t175
  t184 = -0.110e3 / 0.27e2 * t28 * t38 * t113 + 0.77e2 / 0.486e3 * t176
  t197 = t56 ** 2
  t208 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t66 + 0.16160400000000000000000000000000000000000000000000e0 * t70 * t21 * t73 * t100 + 0.48481200000000000000000000000000000000000000000000e0 * t70 * t71 * t105 * t107 - 0.24240600000000000000000000000000000000000000000000e0 * t70 * t74 * t140 - 0.14544360000000000000000000000000000000000000000000e1 * t70 * t18 / t162 * t107 * t100 + 0.14544360000000000000000000000000000000000000000000e1 * t70 * t106 * t100 * t140 - 0.24240600000000000000000000000000000000000000000000e0 * t70 * t111 * (-0.1540e4 / 0.6561e4 * t176 + 0.292e3 / 0.675e3 * t85 * t123 + 0.292e3 / 0.2025e4 * t43 * t184 - 0.73e2 / 0.9720e4 * t184 * t23 * t27 * t35 + 0.73e2 / 0.1215e4 * t127 * t78 - 0.803e3 / 0.3645e4 * t89 * t114 + 0.11242e5 / 0.32805e5 * t47 * t175 - 0.11349404222081842295900120715282716049382716049383e0 * t53 * t55 / t18 / t197))
  v3rho3_0_ = 0.2e1 * r0 * t208 + 0.6e1 * t145

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = t32 * t22
  t34 = t29 * t33
  t36 = tau0 * t31
  t38 = 0.1e1 / t20 / r0
  t43 = t29 * t36 * t38 / 0.4e1 - 0.9e1 / 0.20e2 - t34 / 0.288e3
  t44 = t43 ** 2
  t47 = t43 * t24 * t28
  t50 = t24 ** 2
  t53 = t50 / t26 / t25
  t54 = s0 ** 2
  t55 = t54 * t30
  t56 = t18 ** 2
  t57 = t56 * r0
  t63 = 0.804e0 + 0.5e1 / 0.972e3 * t34 + 0.146e3 / 0.2025e4 * t44 - 0.73e2 / 0.9720e4 * t47 * t33 + 0.45818468001825619316582425136458333333333333333334e-3 * t53 * t55 / t19 / t57
  t66 = 0.1804e1 - 0.646416e0 / t63
  t70 = t6 * t17
  t71 = t63 ** 2
  t72 = 0.1e1 / t71
  t73 = t38 * t72
  t74 = t18 * r0
  t76 = 0.1e1 / t20 / t74
  t77 = t32 * t76
  t78 = t29 * t77
  t84 = -0.5e1 / 0.12e2 * t29 * t36 * t22 + t78 / 0.108e3
  t88 = t84 * t24 * t28
  t93 = t56 * t18
  t99 = -0.10e2 / 0.729e3 * t78 + 0.292e3 / 0.2025e4 * t43 * t84 - 0.73e2 / 0.9720e4 * t88 * t33 + 0.73e2 / 0.3645e4 * t47 * t77 - 0.24436516267640330302177293406111111111111111111111e-2 * t53 * t55 / t19 / t93
  t103 = 0.1e1 / t20
  t105 = 0.1e1 / t71 / t63
  t106 = t103 * t105
  t107 = t99 ** 2
  t111 = t103 * t72
  t113 = 0.1e1 / t20 / t56
  t114 = t32 * t113
  t115 = t29 * t114
  t117 = t84 ** 2
  t123 = 0.10e2 / 0.9e1 * t29 * t36 * t76 - 0.11e2 / 0.324e3 * t115
  t127 = t123 * t24 * t28
  t140 = 0.110e3 / 0.2187e4 * t115 + 0.292e3 / 0.2025e4 * t117 + 0.292e3 / 0.2025e4 * t43 * t123 - 0.73e2 / 0.9720e4 * t127 * t33 + 0.146e3 / 0.3645e4 * t88 * t77 - 0.803e3 / 0.10935e5 * t47 * t114 + 0.15476460302838875858045619157203703703703703703704e-1 * t53 * t55 / t19 / t56 / t74
  t144 = t71 ** 2
  t145 = 0.1e1 / t144
  t146 = t19 * t145
  t147 = t107 * t99
  t151 = t19 * t105
  t152 = t99 * t140
  t156 = t19 * t72
  t158 = 0.1e1 / t20 / t57
  t159 = t32 * t158
  t160 = t29 * t159
  t168 = -0.110e3 / 0.27e2 * t29 * t36 * t113 + 0.77e2 / 0.486e3 * t160
  t172 = t168 * t24 * t28
  t181 = t56 ** 2
  t187 = -0.1540e4 / 0.6561e4 * t160 + 0.292e3 / 0.675e3 * t84 * t123 + 0.292e3 / 0.2025e4 * t43 * t168 - 0.73e2 / 0.9720e4 * t172 * t33 + 0.73e2 / 0.1215e4 * t127 * t77 - 0.803e3 / 0.3645e4 * t88 * t114 + 0.11242e5 / 0.32805e5 * t47 * t159 - 0.11349404222081842295900120715282716049382716049383e0 * t53 * t55 / t19 / t181
  t192 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t22 * t66 + 0.16160400000000000000000000000000000000000000000000e0 * t70 * t73 * t99 + 0.48481200000000000000000000000000000000000000000000e0 * t70 * t106 * t107 - 0.24240600000000000000000000000000000000000000000000e0 * t70 * t111 * t140 - 0.14544360000000000000000000000000000000000000000000e1 * t70 * t146 * t147 + 0.14544360000000000000000000000000000000000000000000e1 * t70 * t151 * t152 - 0.24240600000000000000000000000000000000000000000000e0 * t70 * t156 * t187)
  t222 = t107 ** 2
  t230 = t140 ** 2
  t240 = t32 / t20 / t93
  t241 = t29 * t240
  t243 = t123 ** 2
  t251 = 0.1540e4 / 0.81e2 * t29 * t36 * t158 - 0.1309e4 / 0.1458e4 * t241
  t276 = 0.10e2 / 0.27e2 * t6 * t17 * t76 * t66 - 0.35912000000000000000000000000000000000000000000000e0 * t70 * t22 * t72 * t99 - 0.64641600000000000000000000000000000000000000000000e0 * t70 * t38 * t105 * t107 + 0.32320800000000000000000000000000000000000000000000e0 * t70 * t73 * t140 - 0.19392480000000000000000000000000000000000000000000e1 * t70 * t103 * t145 * t147 + 0.19392480000000000000000000000000000000000000000000e1 * t70 * t106 * t152 - 0.32320800000000000000000000000000000000000000000000e0 * t70 * t111 * t187 + 0.58177440000000000000000000000000000000000000000000e1 * t70 * t19 / t144 / t63 * t222 - 0.87266160000000000000000000000000000000000000000000e1 * t70 * t146 * t107 * t140 + 0.14544360000000000000000000000000000000000000000000e1 * t70 * t151 * t230 + 0.19392480000000000000000000000000000000000000000000e1 * t70 * t151 * t99 * t187 - 0.24240600000000000000000000000000000000000000000000e0 * t70 * t156 * (0.26180e5 / 0.19683e5 * t241 + 0.292e3 / 0.675e3 * t243 + 0.1168e4 / 0.2025e4 * t84 * t168 + 0.292e3 / 0.2025e4 * t43 * t251 - 0.73e2 / 0.9720e4 * t251 * t24 * t28 * t33 + 0.292e3 / 0.3645e4 * t172 * t77 - 0.1606e4 / 0.3645e4 * t127 * t114 + 0.44968e5 / 0.32805e5 * t88 * t159 - 0.191114e6 / 0.98415e5 * t47 * t240 + 0.94578368517348685799167672627355967078189300411525e0 * t53 * t55 / t19 / t181 / r0)
  t277 = f.my_piecewise3(t2, 0, t276)
  v4rho4_0_ = 0.2e1 * r0 * t277 + 0.8e1 * t192

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t44 = t37 * s0 * t42
  t52 = t37 * tau0 / t40 / r0 / 0.4e1 - 0.9e1 / 0.20e2 - t44 / 0.288e3
  t53 = t52 ** 2
  t55 = t52 * t32
  t56 = t36 * s0
  t57 = t56 * t42
  t60 = t32 ** 2
  t63 = t60 / t34 / t33
  t64 = s0 ** 2
  t65 = t38 ** 2
  t72 = 0.804e0 + 0.5e1 / 0.972e3 * t44 + 0.146e3 / 0.2025e4 * t53 - 0.73e2 / 0.9720e4 * t55 * t57 + 0.22909234000912809658291212568229166666666666666667e-3 * t63 * t64 / t39 / t65 / r0
  t75 = 0.1804e1 - 0.646416e0 / t72
  t79 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t80 = t79 * f.p.zeta_threshold
  t82 = f.my_piecewise3(t20, t80, t21 * t19)
  t83 = t30 ** 2
  t84 = 0.1e1 / t83
  t88 = t5 * t82 * t84 * t75 / 0.8e1
  t89 = t5 * t82
  t90 = t72 ** 2
  t91 = 0.1e1 / t90
  t92 = t30 * t91
  t93 = t38 * r0
  t95 = 0.1e1 / t40 / t93
  t97 = t37 * s0 * t95
  t103 = -0.5e1 / 0.12e2 * t37 * tau0 * t42 + t97 / 0.108e3
  t106 = t103 * t32
  t109 = t56 * t95
  t118 = -0.10e2 / 0.729e3 * t97 + 0.292e3 / 0.2025e4 * t52 * t103 - 0.73e2 / 0.9720e4 * t106 * t57 + 0.73e2 / 0.3645e4 * t55 * t109 - 0.12218258133820165151088646703055555555555555555556e-2 * t63 * t64 / t39 / t65 / t38
  t119 = t92 * t118
  t123 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t29 * t30 * t75 - t88 - 0.24240600000000000000000000000000000000000000000000e0 * t89 * t119)
  t125 = r1 <= f.p.dens_threshold
  t126 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t127 = 0.1e1 + t126
  t128 = t127 <= f.p.zeta_threshold
  t129 = t127 ** (0.1e1 / 0.3e1)
  t131 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t134 = f.my_piecewise3(t128, 0, 0.4e1 / 0.3e1 * t129 * t131)
  t136 = r1 ** 2
  t137 = r1 ** (0.1e1 / 0.3e1)
  t138 = t137 ** 2
  t140 = 0.1e1 / t138 / t136
  t142 = t37 * s2 * t140
  t150 = t37 * tau1 / t138 / r1 / 0.4e1 - 0.9e1 / 0.20e2 - t142 / 0.288e3
  t151 = t150 ** 2
  t153 = t150 * t32
  t154 = t36 * s2
  t155 = t154 * t140
  t158 = s2 ** 2
  t159 = t136 ** 2
  t166 = 0.804e0 + 0.5e1 / 0.972e3 * t142 + 0.146e3 / 0.2025e4 * t151 - 0.73e2 / 0.9720e4 * t153 * t155 + 0.22909234000912809658291212568229166666666666666667e-3 * t63 * t158 / t137 / t159 / r1
  t169 = 0.1804e1 - 0.646416e0 / t166
  t174 = f.my_piecewise3(t128, t80, t129 * t127)
  t178 = t5 * t174 * t84 * t169 / 0.8e1
  t180 = f.my_piecewise3(t125, 0, -0.3e1 / 0.8e1 * t5 * t134 * t30 * t169 - t178)
  t182 = t21 ** 2
  t183 = 0.1e1 / t182
  t184 = t26 ** 2
  t189 = t16 / t22 / t6
  t191 = -0.2e1 * t23 + 0.2e1 * t189
  t192 = f.my_piecewise5(t10, 0, t14, 0, t191)
  t196 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t183 * t184 + 0.4e1 / 0.3e1 * t21 * t192)
  t203 = t5 * t29 * t84 * t75
  t209 = 0.1e1 / t83 / t6
  t213 = t5 * t82 * t209 * t75 / 0.12e2
  t216 = t89 * t84 * t91 * t118
  t221 = t118 ** 2
  t226 = 0.1e1 / t40 / t65
  t228 = t37 * s0 * t226
  t230 = t103 ** 2
  t236 = 0.10e2 / 0.9e1 * t37 * tau0 * t95 - 0.11e2 / 0.324e3 * t228
  t258 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t196 * t30 * t75 - t203 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t5 * t29 * t119 + t213 - 0.16160400000000000000000000000000000000000000000000e0 * t216 + 0.48481200000000000000000000000000000000000000000000e0 * t89 * t30 / t90 / t72 * t221 - 0.24240600000000000000000000000000000000000000000000e0 * t89 * t92 * (0.110e3 / 0.2187e4 * t228 + 0.292e3 / 0.2025e4 * t230 + 0.292e3 / 0.2025e4 * t52 * t236 - 0.73e2 / 0.9720e4 * t236 * t32 * t57 + 0.146e3 / 0.3645e4 * t106 * t109 - 0.803e3 / 0.10935e5 * t55 * t56 * t226 + 0.77382301514194379290228095786018518518518518518521e-2 * t63 * t64 / t39 / t65 / t93))
  t259 = t129 ** 2
  t260 = 0.1e1 / t259
  t261 = t131 ** 2
  t265 = f.my_piecewise5(t14, 0, t10, 0, -t191)
  t269 = f.my_piecewise3(t128, 0, 0.4e1 / 0.9e1 * t260 * t261 + 0.4e1 / 0.3e1 * t129 * t265)
  t276 = t5 * t134 * t84 * t169
  t281 = t5 * t174 * t209 * t169 / 0.12e2
  t283 = f.my_piecewise3(t125, 0, -0.3e1 / 0.8e1 * t5 * t269 * t30 * t169 - t276 / 0.4e1 + t281)
  d11 = 0.2e1 * t123 + 0.2e1 * t180 + t6 * (t258 + t283)
  t286 = -t7 - t24
  t287 = f.my_piecewise5(t10, 0, t14, 0, t286)
  t290 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t287)
  t296 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t290 * t30 * t75 - t88)
  t298 = f.my_piecewise5(t14, 0, t10, 0, -t286)
  t301 = f.my_piecewise3(t128, 0, 0.4e1 / 0.3e1 * t129 * t298)
  t306 = t5 * t174
  t307 = t166 ** 2
  t308 = 0.1e1 / t307
  t309 = t30 * t308
  t310 = t136 * r1
  t312 = 0.1e1 / t138 / t310
  t314 = t37 * s2 * t312
  t320 = -0.5e1 / 0.12e2 * t37 * tau1 * t140 + t314 / 0.108e3
  t323 = t320 * t32
  t326 = t154 * t312
  t335 = -0.10e2 / 0.729e3 * t314 + 0.292e3 / 0.2025e4 * t150 * t320 - 0.73e2 / 0.9720e4 * t323 * t155 + 0.73e2 / 0.3645e4 * t153 * t326 - 0.12218258133820165151088646703055555555555555555556e-2 * t63 * t158 / t137 / t159 / t136
  t336 = t309 * t335
  t340 = f.my_piecewise3(t125, 0, -0.3e1 / 0.8e1 * t5 * t301 * t30 * t169 - t178 - 0.24240600000000000000000000000000000000000000000000e0 * t306 * t336)
  t344 = 0.2e1 * t189
  t345 = f.my_piecewise5(t10, 0, t14, 0, t344)
  t349 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t183 * t287 * t26 + 0.4e1 / 0.3e1 * t21 * t345)
  t356 = t5 * t290 * t84 * t75
  t364 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t349 * t30 * t75 - t356 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t5 * t290 * t119 - t203 / 0.8e1 + t213 - 0.80802000000000000000000000000000000000000000000000e-1 * t216)
  t368 = f.my_piecewise5(t14, 0, t10, 0, -t344)
  t372 = f.my_piecewise3(t128, 0, 0.4e1 / 0.9e1 * t260 * t298 * t131 + 0.4e1 / 0.3e1 * t129 * t368)
  t379 = t5 * t301 * t84 * t169
  t387 = t306 * t84 * t308 * t335
  t390 = f.my_piecewise3(t125, 0, -0.3e1 / 0.8e1 * t5 * t372 * t30 * t169 - t379 / 0.8e1 - t276 / 0.8e1 + t281 - 0.24240600000000000000000000000000000000000000000000e0 * t5 * t134 * t336 - 0.80802000000000000000000000000000000000000000000000e-1 * t387)
  d12 = t123 + t180 + t296 + t340 + t6 * (t364 + t390)
  t395 = t287 ** 2
  t399 = 0.2e1 * t23 + 0.2e1 * t189
  t400 = f.my_piecewise5(t10, 0, t14, 0, t399)
  t404 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t183 * t395 + 0.4e1 / 0.3e1 * t21 * t400)
  t411 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t404 * t30 * t75 - t356 / 0.4e1 + t213)
  t412 = t298 ** 2
  t416 = f.my_piecewise5(t14, 0, t10, 0, -t399)
  t420 = f.my_piecewise3(t128, 0, 0.4e1 / 0.9e1 * t260 * t412 + 0.4e1 / 0.3e1 * t129 * t416)
  t433 = t335 ** 2
  t438 = 0.1e1 / t138 / t159
  t440 = t37 * s2 * t438
  t442 = t320 ** 2
  t448 = 0.10e2 / 0.9e1 * t37 * tau1 * t312 - 0.11e2 / 0.324e3 * t440
  t470 = f.my_piecewise3(t125, 0, -0.3e1 / 0.8e1 * t5 * t420 * t30 * t169 - t379 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t5 * t301 * t336 + t281 - 0.16160400000000000000000000000000000000000000000000e0 * t387 + 0.48481200000000000000000000000000000000000000000000e0 * t306 * t30 / t307 / t166 * t433 - 0.24240600000000000000000000000000000000000000000000e0 * t306 * t309 * (0.110e3 / 0.2187e4 * t440 + 0.292e3 / 0.2025e4 * t442 + 0.292e3 / 0.2025e4 * t150 * t448 - 0.73e2 / 0.9720e4 * t448 * t32 * t155 + 0.146e3 / 0.3645e4 * t323 * t326 - 0.803e3 / 0.10935e5 * t153 * t154 * t438 + 0.77382301514194379290228095786018518518518518518521e-2 * t63 * t158 / t137 / t159 / t310))
  d22 = 0.2e1 * t296 + 0.2e1 * t340 + t6 * (t411 + t470)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t56 = t49 * s0 * t54
  t64 = t49 * tau0 / t52 / r0 / 0.4e1 - 0.9e1 / 0.20e2 - t56 / 0.288e3
  t65 = t64 ** 2
  t67 = t64 * t44
  t68 = t48 * s0
  t69 = t68 * t54
  t72 = t44 ** 2
  t75 = t72 / t46 / t45
  t76 = s0 ** 2
  t77 = t50 ** 2
  t78 = t77 * r0
  t84 = 0.804e0 + 0.5e1 / 0.972e3 * t56 + 0.146e3 / 0.2025e4 * t65 - 0.73e2 / 0.9720e4 * t67 * t69 + 0.22909234000912809658291212568229166666666666666667e-3 * t75 * t76 / t51 / t78
  t87 = 0.1804e1 - 0.646416e0 / t84
  t93 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t94 = t42 ** 2
  t95 = 0.1e1 / t94
  t100 = t5 * t93
  t101 = t84 ** 2
  t102 = 0.1e1 / t101
  t103 = t42 * t102
  t104 = t50 * r0
  t106 = 0.1e1 / t52 / t104
  t108 = t49 * s0 * t106
  t114 = -0.5e1 / 0.12e2 * t49 * tau0 * t54 + t108 / 0.108e3
  t117 = t114 * t44
  t120 = t68 * t106
  t129 = -0.10e2 / 0.729e3 * t108 + 0.292e3 / 0.2025e4 * t64 * t114 - 0.73e2 / 0.9720e4 * t117 * t69 + 0.73e2 / 0.3645e4 * t67 * t120 - 0.12218258133820165151088646703055555555555555555556e-2 * t75 * t76 / t51 / t77 / t50
  t130 = t103 * t129
  t133 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t134 = t133 * f.p.zeta_threshold
  t136 = f.my_piecewise3(t20, t134, t21 * t19)
  t138 = 0.1e1 / t94 / t6
  t143 = t5 * t136
  t144 = t95 * t102
  t145 = t144 * t129
  t149 = 0.1e1 / t101 / t84
  t150 = t42 * t149
  t151 = t129 ** 2
  t152 = t150 * t151
  t156 = 0.1e1 / t52 / t77
  t158 = t49 * s0 * t156
  t160 = t114 ** 2
  t166 = 0.10e2 / 0.9e1 * t49 * tau0 * t106 - 0.11e2 / 0.324e3 * t158
  t169 = t166 * t44
  t174 = t68 * t156
  t183 = 0.110e3 / 0.2187e4 * t158 + 0.292e3 / 0.2025e4 * t160 + 0.292e3 / 0.2025e4 * t64 * t166 - 0.73e2 / 0.9720e4 * t169 * t69 + 0.146e3 / 0.3645e4 * t117 * t120 - 0.803e3 / 0.10935e5 * t67 * t174 + 0.77382301514194379290228095786018518518518518518521e-2 * t75 * t76 / t51 / t77 / t104
  t184 = t103 * t183
  t188 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t41 * t42 * t87 - t5 * t93 * t95 * t87 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t100 * t130 + t5 * t136 * t138 * t87 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t143 * t145 + 0.48481200000000000000000000000000000000000000000000e0 * t143 * t152 - 0.24240600000000000000000000000000000000000000000000e0 * t143 * t184)
  t190 = r1 <= f.p.dens_threshold
  t191 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t192 = 0.1e1 + t191
  t193 = t192 <= f.p.zeta_threshold
  t194 = t192 ** (0.1e1 / 0.3e1)
  t195 = t194 ** 2
  t196 = 0.1e1 / t195
  t198 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t199 = t198 ** 2
  t203 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t207 = f.my_piecewise3(t193, 0, 0.4e1 / 0.9e1 * t196 * t199 + 0.4e1 / 0.3e1 * t194 * t203)
  t209 = r1 ** 2
  t210 = r1 ** (0.1e1 / 0.3e1)
  t211 = t210 ** 2
  t213 = 0.1e1 / t211 / t209
  t215 = t49 * s2 * t213
  t223 = t49 * tau1 / t211 / r1 / 0.4e1 - 0.9e1 / 0.20e2 - t215 / 0.288e3
  t224 = t223 ** 2
  t231 = s2 ** 2
  t232 = t209 ** 2
  t242 = 0.1804e1 - 0.646416e0 / (0.804e0 + 0.5e1 / 0.972e3 * t215 + 0.146e3 / 0.2025e4 * t224 - 0.73e2 / 0.9720e4 * t223 * t44 * t48 * s2 * t213 + 0.22909234000912809658291212568229166666666666666667e-3 * t75 * t231 / t210 / t232 / r1)
  t248 = f.my_piecewise3(t193, 0, 0.4e1 / 0.3e1 * t194 * t198)
  t254 = f.my_piecewise3(t193, t134, t194 * t192)
  t260 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t207 * t42 * t242 - t5 * t248 * t95 * t242 / 0.4e1 + t5 * t254 * t138 * t242 / 0.12e2)
  t266 = t101 ** 2
  t287 = t24 ** 2
  t291 = 0.6e1 * t33 - 0.6e1 * t16 / t287
  t292 = f.my_piecewise5(t10, 0, t14, 0, t291)
  t296 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t292)
  t317 = 0.1e1 / t94 / t24
  t330 = 0.1e1 / t52 / t78
  t332 = t49 * s0 * t330
  t340 = -0.110e3 / 0.27e2 * t49 * tau0 * t156 + 0.77e2 / 0.486e3 * t332
  t353 = t77 ** 2
  t363 = 0.48481200000000000000000000000000000000000000000000e0 * t143 * t95 * t149 * t151 - 0.14544360000000000000000000000000000000000000000000e1 * t143 * t42 / t266 * t151 * t129 + 0.14544360000000000000000000000000000000000000000000e1 * t143 * t150 * t129 * t183 + 0.14544360000000000000000000000000000000000000000000e1 * t100 * t152 - 0.3e1 / 0.8e1 * t5 * t296 * t42 * t87 - 0.3e1 / 0.8e1 * t5 * t41 * t95 * t87 - 0.72721800000000000000000000000000000000000000000000e0 * t5 * t41 * t130 + t5 * t93 * t138 * t87 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t100 * t145 - 0.72721800000000000000000000000000000000000000000000e0 * t100 * t184 - 0.5e1 / 0.36e2 * t5 * t136 * t317 * t87 + 0.16160400000000000000000000000000000000000000000000e0 * t143 * t138 * t102 * t129 - 0.24240600000000000000000000000000000000000000000000e0 * t143 * t144 * t183 - 0.24240600000000000000000000000000000000000000000000e0 * t143 * t103 * (-0.1540e4 / 0.6561e4 * t332 + 0.292e3 / 0.675e3 * t114 * t166 + 0.292e3 / 0.2025e4 * t64 * t340 - 0.73e2 / 0.9720e4 * t340 * t44 * t69 + 0.73e2 / 0.1215e4 * t169 * t120 - 0.803e3 / 0.3645e4 * t117 * t174 + 0.11242e5 / 0.32805e5 * t67 * t68 * t330 - 0.56747021110409211479500603576413580246913580246915e-1 * t75 * t76 / t51 / t353)
  t364 = f.my_piecewise3(t1, 0, t363)
  t374 = f.my_piecewise5(t14, 0, t10, 0, -t291)
  t378 = f.my_piecewise3(t193, 0, -0.8e1 / 0.27e2 / t195 / t192 * t199 * t198 + 0.4e1 / 0.3e1 * t196 * t198 * t203 + 0.4e1 / 0.3e1 * t194 * t374)
  t396 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t378 * t42 * t242 - 0.3e1 / 0.8e1 * t5 * t207 * t95 * t242 + t5 * t248 * t138 * t242 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t254 * t317 * t242)
  d111 = 0.3e1 * t188 + 0.3e1 * t260 + t6 * (t364 + t396)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t35 = t30 * t34
  t36 = r0 ** 2
  t37 = r0 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = 0.1e1 / t38 / t36
  t42 = t35 * s0 * t40
  t50 = t35 * tau0 / t38 / r0 / 0.4e1 - 0.9e1 / 0.20e2 - t42 / 0.288e3
  t51 = t50 ** 2
  t53 = t50 * t30
  t54 = t34 * s0
  t55 = t54 * t40
  t58 = t30 ** 2
  t61 = t58 / t32 / t31
  t62 = s0 ** 2
  t63 = t36 ** 2
  t64 = t63 * r0
  t70 = 0.804e0 + 0.5e1 / 0.972e3 * t42 + 0.146e3 / 0.2025e4 * t51 - 0.73e2 / 0.9720e4 * t53 * t55 + 0.22909234000912809658291212568229166666666666666667e-3 * t61 * t62 / t37 / t64
  t71 = t70 ** 2
  t73 = 0.1e1 / t71 / t70
  t74 = t29 * t73
  t75 = t36 * r0
  t77 = 0.1e1 / t38 / t75
  t79 = t35 * s0 * t77
  t85 = -0.5e1 / 0.12e2 * t35 * tau0 * t40 + t79 / 0.108e3
  t88 = t85 * t30
  t91 = t54 * t77
  t94 = t63 * t36
  t100 = -0.10e2 / 0.729e3 * t79 + 0.292e3 / 0.2025e4 * t50 * t85 - 0.73e2 / 0.9720e4 * t88 * t55 + 0.73e2 / 0.3645e4 * t53 * t91 - 0.12218258133820165151088646703055555555555555555556e-2 * t61 * t62 / t37 / t94
  t101 = t100 ** 2
  t102 = t74 * t101
  t105 = t71 ** 2
  t106 = 0.1e1 / t105
  t107 = t27 * t106
  t108 = t101 * t100
  t109 = t107 * t108
  t112 = t27 * t73
  t114 = 0.1e1 / t38 / t63
  t116 = t35 * s0 * t114
  t118 = t85 ** 2
  t124 = 0.10e2 / 0.9e1 * t35 * tau0 * t77 - 0.11e2 / 0.324e3 * t116
  t127 = t124 * t30
  t132 = t54 * t114
  t141 = 0.110e3 / 0.2187e4 * t116 + 0.292e3 / 0.2025e4 * t118 + 0.292e3 / 0.2025e4 * t50 * t124 - 0.73e2 / 0.9720e4 * t127 * t55 + 0.146e3 / 0.3645e4 * t88 * t91 - 0.803e3 / 0.10935e5 * t53 * t132 + 0.77382301514194379290228095786018518518518518518521e-2 * t61 * t62 / t37 / t63 / t75
  t142 = t100 * t141
  t143 = t112 * t142
  t146 = t6 ** 2
  t147 = 0.1e1 / t146
  t149 = -t16 * t147 + t7
  t150 = f.my_piecewise5(t10, 0, t14, 0, t149)
  t153 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t150)
  t154 = t5 * t153
  t155 = t112 * t101
  t158 = t23 ** 2
  t160 = 0.1e1 / t158 / t19
  t161 = t150 ** 2
  t165 = 0.1e1 / t158
  t166 = t165 * t150
  t167 = t146 * t6
  t168 = 0.1e1 / t167
  t171 = 0.2e1 * t16 * t168 - 0.2e1 * t147
  t172 = f.my_piecewise5(t10, 0, t14, 0, t171)
  t175 = t146 ** 2
  t176 = 0.1e1 / t175
  t179 = -0.6e1 * t16 * t176 + 0.6e1 * t168
  t180 = f.my_piecewise5(t10, 0, t14, 0, t179)
  t184 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t160 * t161 * t150 + 0.4e1 / 0.3e1 * t166 * t172 + 0.4e1 / 0.3e1 * t23 * t180)
  t188 = 0.1804e1 - 0.646416e0 / t70
  t197 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t165 * t161 + 0.4e1 / 0.3e1 * t23 * t172)
  t202 = t5 * t197
  t203 = 0.1e1 / t71
  t204 = t27 * t203
  t205 = t204 * t100
  t209 = 0.1e1 / t28 / t6
  t214 = t29 * t203
  t215 = t214 * t100
  t218 = t204 * t141
  t222 = 0.1e1 / t28 / t146
  t227 = t209 * t203
  t228 = t227 * t100
  t231 = t214 * t141
  t235 = 0.1e1 / t38 / t64
  t237 = t35 * s0 * t235
  t245 = -0.110e3 / 0.27e2 * t35 * tau0 * t114 + 0.77e2 / 0.486e3 * t237
  t248 = t245 * t30
  t255 = t54 * t235
  t258 = t63 ** 2
  t264 = -0.1540e4 / 0.6561e4 * t237 + 0.292e3 / 0.675e3 * t85 * t124 + 0.292e3 / 0.2025e4 * t50 * t245 - 0.73e2 / 0.9720e4 * t248 * t55 + 0.73e2 / 0.1215e4 * t127 * t91 - 0.803e3 / 0.3645e4 * t88 * t132 + 0.11242e5 / 0.32805e5 * t53 * t255 - 0.56747021110409211479500603576413580246913580246915e-1 * t61 * t62 / t37 / t258
  t265 = t204 * t264
  t268 = 0.48481200000000000000000000000000000000000000000000e0 * t26 * t102 - 0.14544360000000000000000000000000000000000000000000e1 * t26 * t109 + 0.14544360000000000000000000000000000000000000000000e1 * t26 * t143 + 0.14544360000000000000000000000000000000000000000000e1 * t154 * t155 - 0.3e1 / 0.8e1 * t5 * t184 * t27 * t188 - 0.3e1 / 0.8e1 * t5 * t197 * t29 * t188 - 0.72721800000000000000000000000000000000000000000000e0 * t202 * t205 + t5 * t153 * t209 * t188 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t154 * t215 - 0.72721800000000000000000000000000000000000000000000e0 * t154 * t218 - 0.5e1 / 0.36e2 * t5 * t25 * t222 * t188 + 0.16160400000000000000000000000000000000000000000000e0 * t26 * t228 - 0.24240600000000000000000000000000000000000000000000e0 * t26 * t231 - 0.24240600000000000000000000000000000000000000000000e0 * t26 * t265
  t269 = f.my_piecewise3(t1, 0, t268)
  t271 = r1 <= f.p.dens_threshold
  t272 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t273 = 0.1e1 + t272
  t274 = t273 <= f.p.zeta_threshold
  t275 = t273 ** (0.1e1 / 0.3e1)
  t276 = t275 ** 2
  t278 = 0.1e1 / t276 / t273
  t280 = f.my_piecewise5(t14, 0, t10, 0, -t149)
  t281 = t280 ** 2
  t285 = 0.1e1 / t276
  t286 = t285 * t280
  t288 = f.my_piecewise5(t14, 0, t10, 0, -t171)
  t292 = f.my_piecewise5(t14, 0, t10, 0, -t179)
  t296 = f.my_piecewise3(t274, 0, -0.8e1 / 0.27e2 * t278 * t281 * t280 + 0.4e1 / 0.3e1 * t286 * t288 + 0.4e1 / 0.3e1 * t275 * t292)
  t298 = r1 ** 2
  t299 = r1 ** (0.1e1 / 0.3e1)
  t300 = t299 ** 2
  t302 = 0.1e1 / t300 / t298
  t304 = t35 * s2 * t302
  t312 = t35 * tau1 / t300 / r1 / 0.4e1 - 0.9e1 / 0.20e2 - t304 / 0.288e3
  t313 = t312 ** 2
  t320 = s2 ** 2
  t321 = t298 ** 2
  t331 = 0.1804e1 - 0.646416e0 / (0.804e0 + 0.5e1 / 0.972e3 * t304 + 0.146e3 / 0.2025e4 * t313 - 0.73e2 / 0.9720e4 * t312 * t30 * t34 * s2 * t302 + 0.22909234000912809658291212568229166666666666666667e-3 * t61 * t320 / t299 / t321 / r1)
  t340 = f.my_piecewise3(t274, 0, 0.4e1 / 0.9e1 * t285 * t281 + 0.4e1 / 0.3e1 * t275 * t288)
  t347 = f.my_piecewise3(t274, 0, 0.4e1 / 0.3e1 * t275 * t280)
  t353 = f.my_piecewise3(t274, t22, t275 * t273)
  t359 = f.my_piecewise3(t271, 0, -0.3e1 / 0.8e1 * t5 * t296 * t27 * t331 - 0.3e1 / 0.8e1 * t5 * t340 * t29 * t331 + t5 * t347 * t209 * t331 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t353 * t222 * t331)
  t374 = 0.1e1 / t28 / t167
  t379 = t19 ** 2
  t382 = t161 ** 2
  t388 = t172 ** 2
  t397 = -0.24e2 * t176 + 0.24e2 * t16 / t175 / t6
  t398 = f.my_piecewise5(t10, 0, t14, 0, t397)
  t402 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t158 / t379 * t382 - 0.16e2 / 0.9e1 * t160 * t161 * t172 + 0.4e1 / 0.3e1 * t165 * t388 + 0.16e2 / 0.9e1 * t166 * t180 + 0.4e1 / 0.3e1 * t23 * t398)
  t407 = t141 ** 2
  t419 = 0.1e1 / t38 / t94
  t421 = t35 * s0 * t419
  t423 = t124 ** 2
  t431 = 0.1540e4 / 0.81e2 * t35 * tau0 * t235 - 0.1309e4 / 0.1458e4 * t421
  t462 = -t5 * t184 * t29 * t188 / 0.2e1 + t5 * t197 * t209 * t188 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t153 * t222 * t188 + 0.10e2 / 0.27e2 * t5 * t25 * t374 * t188 - 0.3e1 / 0.8e1 * t5 * t402 * t27 * t188 + 0.14544360000000000000000000000000000000000000000000e1 * t26 * t112 * t407 - 0.96962400000000000000000000000000000000000000000000e0 * t202 * t215 - 0.14544360000000000000000000000000000000000000000000e1 * t202 * t218 - 0.32320800000000000000000000000000000000000000000000e0 * t26 * t214 * t264 - 0.24240600000000000000000000000000000000000000000000e0 * t26 * t204 * (0.26180e5 / 0.19683e5 * t421 + 0.292e3 / 0.675e3 * t423 + 0.1168e4 / 0.2025e4 * t85 * t245 + 0.292e3 / 0.2025e4 * t50 * t431 - 0.73e2 / 0.9720e4 * t431 * t30 * t55 + 0.292e3 / 0.3645e4 * t248 * t91 - 0.1606e4 / 0.3645e4 * t127 * t132 + 0.44968e5 / 0.32805e5 * t88 * t255 - 0.191114e6 / 0.98415e5 * t53 * t54 * t419 + 0.47289184258674342899583836313677983539094650205762e0 * t61 * t62 / t37 / t258 / r0) + 0.64641600000000000000000000000000000000000000000000e0 * t154 * t228 - 0.96962400000000000000000000000000000000000000000000e0 * t154 * t231 - 0.96962400000000000000000000000000000000000000000000e0 * t154 * t265
  t478 = t101 ** 2
  t507 = -0.35912000000000000000000000000000000000000000000000e0 * t26 * t222 * t203 * t100 - 0.64641600000000000000000000000000000000000000000000e0 * t26 * t209 * t73 * t101 - 0.19392480000000000000000000000000000000000000000000e1 * t26 * t29 * t106 * t108 + 0.58177440000000000000000000000000000000000000000000e1 * t26 * t27 / t105 / t70 * t478 + 0.19392480000000000000000000000000000000000000000000e1 * t154 * t102 - 0.58177440000000000000000000000000000000000000000000e1 * t154 * t109 + 0.29088720000000000000000000000000000000000000000000e1 * t202 * t155 - 0.96962400000000000000000000000000000000000000000000e0 * t5 * t184 * t205 + 0.32320800000000000000000000000000000000000000000000e0 * t26 * t227 * t141 + 0.19392480000000000000000000000000000000000000000000e1 * t26 * t112 * t100 * t264 + 0.19392480000000000000000000000000000000000000000000e1 * t26 * t74 * t142 - 0.87266160000000000000000000000000000000000000000000e1 * t26 * t107 * t101 * t141 + 0.58177440000000000000000000000000000000000000000000e1 * t154 * t143
  t509 = f.my_piecewise3(t1, 0, t462 + t507)
  t510 = t273 ** 2
  t513 = t281 ** 2
  t519 = t288 ** 2
  t525 = f.my_piecewise5(t14, 0, t10, 0, -t397)
  t529 = f.my_piecewise3(t274, 0, 0.40e2 / 0.81e2 / t276 / t510 * t513 - 0.16e2 / 0.9e1 * t278 * t281 * t288 + 0.4e1 / 0.3e1 * t285 * t519 + 0.16e2 / 0.9e1 * t286 * t292 + 0.4e1 / 0.3e1 * t275 * t525)
  t551 = f.my_piecewise3(t271, 0, -0.3e1 / 0.8e1 * t5 * t529 * t27 * t331 - t5 * t296 * t29 * t331 / 0.2e1 + t5 * t340 * t209 * t331 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t347 * t222 * t331 + 0.10e2 / 0.27e2 * t5 * t353 * t374 * t331)
  d1111 = 0.4e1 * t269 + 0.4e1 * t359 + t6 * (t509 + t551)

  res = {'v4rho4': d1111}
  return res
