"""Generated from mgga_x_tm.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) + 2 * tm_p(x) / 3

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) + 2 * tm_p(x) / 3

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) + 2 * tm_p(x) / 3

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 0.1e1 / r0
  t29 = s0 * t28
  t30 = 0.1e1 / tau0
  t32 = t29 * t30 / 0.8e1
  t33 = t32 < 0.10e1
  t34 = f.my_piecewise3(t33, t32, 0.10e1)
  t35 = t34 ** 2
  t36 = t35 * t34
  t38 = t35 + 0.3e1 * t36
  t39 = 0.1e1 + t36
  t40 = t39 ** 2
  t41 = 0.1e1 / t40
  t42 = t38 * t41
  t43 = 6 ** (0.1e1 / 0.3e1)
  t44 = jnp.pi ** 2
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = 0.1e1 / t46
  t48 = t43 * t47
  t49 = r0 ** 2
  t50 = r0 ** (0.1e1 / 0.3e1)
  t51 = t50 ** 2
  t53 = 0.1e1 / t51 / t49
  t54 = s0 * t53
  t55 = t48 * t54
  t57 = t43 ** 2
  t60 = t57 / t45 / t44
  t61 = s0 ** 2
  t62 = t49 ** 2
  t65 = 0.1e1 / t50 / t62 / r0
  t69 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t55 + 0.26899490462262948000000000000000000000000000000000e-2 * t60 * t61 * t65
  t70 = t69 ** (0.1e1 / 0.5e1)
  t74 = 0.1e1 / t51 / r0
  t75 = tau0 * t74
  t78 = 0.25633760400000000000000000000000000000000000000000e0 * t57 * t46
  t84 = 0.7e1 + 0.44760329444444444444444444444444444444444444444445e0 * t55 - 0.35e2 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t75 + t78 + 0.11867481666666666666666666666666666666666666666667e-1 * t54) * t43 * t47
  t85 = t70 ** 2
  t86 = 0.1e1 / t85
  t89 = 0.1e1 / t70 + t84 * t86 / 0.9e1
  t91 = 0.1e1 - t42
  t94 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t55) * t43
  t95 = t47 * s0
  t102 = (t75 - t54 / 0.8e1) * t43 * t47
  t105 = t102 / 0.4e1 - 0.9e1 / 0.20e2 + t55 / 0.36e2
  t106 = t105 ** 2
  t110 = 0.73e2 / 0.1620e4 * t102 - 0.73e2 / 0.900e3 + 0.73e2 / 0.14580e5 * t55
  t111 = t110 * t34
  t112 = 0.1e1 - t34
  t116 = (0.1e1 + 0.5e1 / 0.12e2 * t94 * t95 * t53 + 0.292e3 / 0.405e3 * t106 - 0.6e1 * t111 * t112) ** (0.1e1 / 0.10e2)
  t118 = t91 * t116 + t42 * t89
  t122 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t118)
  t123 = r1 <= f.p.dens_threshold
  t124 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t125 = 0.1e1 + t124
  t126 = t125 <= f.p.zeta_threshold
  t127 = t125 ** (0.1e1 / 0.3e1)
  t129 = f.my_piecewise3(t126, t22, t127 * t125)
  t130 = t129 * t26
  t131 = 0.1e1 / r1
  t132 = s2 * t131
  t133 = 0.1e1 / tau1
  t135 = t132 * t133 / 0.8e1
  t136 = t135 < 0.10e1
  t137 = f.my_piecewise3(t136, t135, 0.10e1)
  t138 = t137 ** 2
  t139 = t138 * t137
  t141 = t138 + 0.3e1 * t139
  t142 = 0.1e1 + t139
  t143 = t142 ** 2
  t144 = 0.1e1 / t143
  t145 = t141 * t144
  t146 = r1 ** 2
  t147 = r1 ** (0.1e1 / 0.3e1)
  t148 = t147 ** 2
  t150 = 0.1e1 / t148 / t146
  t151 = s2 * t150
  t152 = t48 * t151
  t154 = s2 ** 2
  t155 = t146 ** 2
  t158 = 0.1e1 / t147 / t155 / r1
  t162 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t152 + 0.26899490462262948000000000000000000000000000000000e-2 * t60 * t154 * t158
  t163 = t162 ** (0.1e1 / 0.5e1)
  t167 = 0.1e1 / t148 / r1
  t168 = tau1 * t167
  t175 = 0.7e1 + 0.44760329444444444444444444444444444444444444444445e0 * t152 - 0.35e2 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t168 + t78 + 0.11867481666666666666666666666666666666666666666667e-1 * t151) * t43 * t47
  t176 = t163 ** 2
  t177 = 0.1e1 / t176
  t180 = 0.1e1 / t163 + t175 * t177 / 0.9e1
  t182 = 0.1e1 - t145
  t185 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t152) * t43
  t186 = t47 * s2
  t193 = (t168 - t151 / 0.8e1) * t43 * t47
  t196 = t193 / 0.4e1 - 0.9e1 / 0.20e2 + t152 / 0.36e2
  t197 = t196 ** 2
  t201 = 0.73e2 / 0.1620e4 * t193 - 0.73e2 / 0.900e3 + 0.73e2 / 0.14580e5 * t152
  t202 = t201 * t137
  t203 = 0.1e1 - t137
  t207 = (0.1e1 + 0.5e1 / 0.12e2 * t185 * t186 * t150 + 0.292e3 / 0.405e3 * t197 - 0.6e1 * t202 * t203) ** (0.1e1 / 0.10e2)
  t209 = t145 * t180 + t182 * t207
  t213 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t130 * t209)
  t214 = t6 ** 2
  t216 = t16 / t214
  t217 = t7 - t216
  t218 = f.my_piecewise5(t10, 0, t14, 0, t217)
  t221 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t218)
  t226 = t26 ** 2
  t227 = 0.1e1 / t226
  t231 = t5 * t25 * t227 * t118 / 0.8e1
  t236 = f.my_piecewise3(t33, -s0 / t49 * t30 / 0.8e1, 0)
  t239 = t35 * t236
  t242 = (0.2e1 * t34 * t236 + 0.9e1 * t239) * t41
  t246 = t38 / t40 / t39
  t247 = t89 * t35
  t252 = 0.1e1 / t70 / t69
  t255 = 0.1e1 / t51 / t49 / r0
  t256 = s0 * t255
  t257 = t48 * t256
  t263 = t60 * t61 / t50 / t62 / t49
  t265 = -0.40121303703703703703703703703703703703703703703704e0 * t257 - 0.14346394913206905600000000000000000000000000000000e-1 * t263
  t269 = tau0 * t53
  t281 = t84 / t85 / t69
  t290 = t116 ** 2
  t291 = t290 ** 2
  t292 = t291 ** 2
  t295 = t91 / t292 / t116
  t304 = (-0.5e1 / 0.3e1 * t269 + t256 / 0.3e1) * t43 * t47
  t329 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t221 * t26 * t118 - t231 - 0.3e1 / 0.8e1 * t5 * t27 * (t242 * t89 - 0.6e1 * t246 * t247 * t236 + t42 * (-t252 * t265 / 0.5e1 + (-0.11936087851851851851851851851851851851851851851852e1 * t257 - 0.35e2 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t269 - 0.31646617777777777777777777777777777777777777777779e-1 * t256) * t43 * t47) * t86 / 0.9e1 - 0.2e1 / 0.45e2 * t281 * t265) + (0.6e1 * t246 * t239 - t242) * t116 + t295 * (-0.125e3 / 0.39366e5 * t263 - 0.10e2 / 0.9e1 * t94 * t95 * t255 + 0.584e3 / 0.405e3 * t105 * (t304 / 0.4e1 - 0.2e1 / 0.27e2 * t257) - 0.6e1 * (0.73e2 / 0.1620e4 * t304 - 0.146e3 / 0.10935e5 * t257) * t34 * t112 - 0.6e1 * t110 * t236 * t112 + 0.6e1 * t111 * t236) / 0.10e2))
  t331 = f.my_piecewise5(t14, 0, t10, 0, -t217)
  t334 = f.my_piecewise3(t126, 0, 0.4e1 / 0.3e1 * t127 * t331)
  t342 = t5 * t129 * t227 * t209 / 0.8e1
  t344 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t334 * t26 * t209 - t342)
  vrho_0_ = t122 + t213 + t6 * (t329 + t344)
  t347 = -t7 - t216
  t348 = f.my_piecewise5(t10, 0, t14, 0, t347)
  t351 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t348)
  t357 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t351 * t26 * t118 - t231)
  t359 = f.my_piecewise5(t14, 0, t10, 0, -t347)
  t362 = f.my_piecewise3(t126, 0, 0.4e1 / 0.3e1 * t127 * t359)
  t371 = f.my_piecewise3(t136, -s2 / t146 * t133 / 0.8e1, 0)
  t374 = t138 * t371
  t377 = (0.2e1 * t137 * t371 + 0.9e1 * t374) * t144
  t381 = t141 / t143 / t142
  t382 = t180 * t138
  t387 = 0.1e1 / t163 / t162
  t390 = 0.1e1 / t148 / t146 / r1
  t391 = s2 * t390
  t392 = t48 * t391
  t398 = t60 * t154 / t147 / t155 / t146
  t400 = -0.40121303703703703703703703703703703703703703703704e0 * t392 - 0.14346394913206905600000000000000000000000000000000e-1 * t398
  t404 = tau1 * t150
  t416 = t175 / t176 / t162
  t425 = t207 ** 2
  t426 = t425 ** 2
  t427 = t426 ** 2
  t430 = t182 / t427 / t207
  t439 = (-0.5e1 / 0.3e1 * t404 + t391 / 0.3e1) * t43 * t47
  t464 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t362 * t26 * t209 - t342 - 0.3e1 / 0.8e1 * t5 * t130 * (t377 * t180 - 0.6e1 * t381 * t382 * t371 + t145 * (-t387 * t400 / 0.5e1 + (-0.11936087851851851851851851851851851851851851851852e1 * t392 - 0.35e2 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t404 - 0.31646617777777777777777777777777777777777777777779e-1 * t391) * t43 * t47) * t177 / 0.9e1 - 0.2e1 / 0.45e2 * t416 * t400) + (0.6e1 * t381 * t374 - t377) * t207 + t430 * (-0.125e3 / 0.39366e5 * t398 - 0.10e2 / 0.9e1 * t185 * t186 * t390 + 0.584e3 / 0.405e3 * t196 * (t439 / 0.4e1 - 0.2e1 / 0.27e2 * t392) - 0.6e1 * (0.73e2 / 0.1620e4 * t439 - 0.146e3 / 0.10935e5 * t392) * t137 * t203 - 0.6e1 * t201 * t371 * t203 + 0.6e1 * t202 * t371) / 0.10e2))
  vrho_1_ = t122 + t213 + t6 * (t357 + t464)
  t469 = f.my_piecewise3(t33, t28 * t30 / 0.8e1, 0)
  t472 = t35 * t469
  t475 = (0.2e1 * t34 * t469 + 0.9e1 * t472) * t41
  t483 = t60 * s0 * t65
  t485 = 0.15045488888888888888888888888888888888888888888889e0 * t48 * t53 + 0.53798980924525896000000000000000000000000000000000e-2 * t483
  t500 = t47 * t53
  t522 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t475 * t89 - 0.6e1 * t246 * t247 * t469 + t42 * (-t252 * t485 / 0.5e1 + 0.44605775205761316872427983539094650205761316872429e-1 * t48 * t53 * t86 - 0.2e1 / 0.45e2 * t281 * t485) + (0.6e1 * t246 * t472 - t475) * t116 + t295 * (0.125e3 / 0.104976e6 * t483 + 0.5e1 / 0.12e2 * t94 * t500 - 0.73e2 / 0.14580e5 * t105 * t43 * t500 + 0.73e2 / 0.19440e5 * t48 * t53 * t34 * t112 - 0.6e1 * t110 * t469 * t112 + 0.6e1 * t111 * t469) / 0.10e2))
  vsigma_0_ = t6 * t522
  vsigma_1_ = 0.0e0
  t525 = f.my_piecewise3(t136, t131 * t133 / 0.8e1, 0)
  t528 = t138 * t525
  t531 = (0.2e1 * t137 * t525 + 0.9e1 * t528) * t144
  t539 = t60 * s2 * t158
  t541 = 0.15045488888888888888888888888888888888888888888889e0 * t48 * t150 + 0.53798980924525896000000000000000000000000000000000e-2 * t539
  t556 = t47 * t150
  t578 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t130 * (t531 * t180 - 0.6e1 * t381 * t382 * t525 + t145 * (-t387 * t541 / 0.5e1 + 0.44605775205761316872427983539094650205761316872429e-1 * t48 * t150 * t177 - 0.2e1 / 0.45e2 * t416 * t541) + (0.6e1 * t381 * t528 - t531) * t207 + t430 * (0.125e3 / 0.104976e6 * t539 + 0.5e1 / 0.12e2 * t185 * t556 - 0.73e2 / 0.14580e5 * t196 * t43 * t556 + 0.73e2 / 0.19440e5 * t48 * t150 * t137 * t203 - 0.6e1 * t201 * t525 * t203 + 0.6e1 * t202 * t525) / 0.10e2))
  vsigma_2_ = t6 * t578
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t579 = tau0 ** 2
  t583 = f.my_piecewise3(t33, -t29 / t579 / 0.8e1, 0)
  t586 = t35 * t583
  t589 = (0.2e1 * t34 * t583 + 0.9e1 * t586) * t41
  t622 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t589 * t89 - 0.6e1 * t246 * t247 * t583 - 0.62888224691358024691358024691358024691358024691358e-1 * t42 * t74 * t48 * t86 + (0.6e1 * t246 * t586 - t589) * t116 + t295 * (0.146e3 / 0.405e3 * t105 * t74 * t48 - 0.73e2 / 0.270e3 * t74 * t43 * t47 * t34 * t112 - 0.6e1 * t110 * t583 * t112 + 0.6e1 * t111 * t583) / 0.10e2))
  vtau_0_ = t6 * t622
  t623 = tau1 ** 2
  t627 = f.my_piecewise3(t136, -t132 / t623 / 0.8e1, 0)
  t630 = t138 * t627
  t633 = (0.2e1 * t137 * t627 + 0.9e1 * t630) * t144
  t666 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t130 * (t633 * t180 - 0.6e1 * t381 * t382 * t627 - 0.62888224691358024691358024691358024691358024691358e-1 * t145 * t167 * t48 * t177 + (0.6e1 * t381 * t630 - t633) * t207 + t430 * (0.146e3 / 0.405e3 * t196 * t167 * t48 - 0.73e2 / 0.270e3 * t167 * t43 * t47 * t137 * t203 - 0.6e1 * t201 * t627 * t203 + 0.6e1 * t202 * t627) / 0.10e2))
  vtau_1_ = t6 * t666
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) + 2 * tm_p(x) / 3

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 0.1e1 / r0
  t21 = s0 * t20
  t22 = 0.1e1 / tau0
  t24 = t21 * t22 / 0.8e1
  t25 = t24 < 0.10e1
  t26 = f.my_piecewise3(t25, t24, 0.10e1)
  t27 = t26 ** 2
  t28 = t27 * t26
  t30 = t27 + 0.3e1 * t28
  t31 = 0.1e1 + t28
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t34 = t30 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = s0 * t42
  t44 = r0 ** 2
  t45 = t18 ** 2
  t47 = 0.1e1 / t45 / t44
  t48 = t43 * t47
  t49 = t40 * t48
  t51 = t35 ** 2
  t54 = t51 / t37 / t36
  t55 = s0 ** 2
  t56 = t55 * t41
  t57 = t44 ** 2
  t60 = 0.1e1 / t18 / t57 / r0
  t64 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t49 + 0.53798980924525896000000000000000000000000000000000e-2 * t54 * t56 * t60
  t65 = t64 ** (0.1e1 / 0.5e1)
  t68 = tau0 * t42
  t70 = 0.1e1 / t45 / r0
  t71 = t68 * t70
  t80 = 0.7e1 + 0.44760329444444444444444444444444444444444444444445e0 * t49 - 0.35e2 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t71 + 0.25633760400000000000000000000000000000000000000000e0 * t51 * t38 + 0.11867481666666666666666666666666666666666666666667e-1 * t48) * t35 * t39
  t81 = t65 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t65 + t80 * t82 / 0.9e1
  t87 = 0.1e1 - t34
  t90 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t49) * t35
  t91 = t90 * t39
  t97 = (t71 - t48 / 0.8e1) * t35 * t39
  t100 = t97 / 0.4e1 - 0.9e1 / 0.20e2 + t49 / 0.36e2
  t101 = t100 ** 2
  t105 = 0.73e2 / 0.1620e4 * t97 - 0.73e2 / 0.900e3 + 0.73e2 / 0.14580e5 * t49
  t106 = t105 * t26
  t107 = 0.1e1 - t26
  t111 = (0.1e1 + 0.5e1 / 0.12e2 * t91 * t48 + 0.292e3 / 0.405e3 * t101 - 0.6e1 * t106 * t107) ** (0.1e1 / 0.10e2)
  t113 = t87 * t111 + t34 * t85
  t117 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t113)
  t127 = f.my_piecewise3(t25, -s0 / t44 * t22 / 0.8e1, 0)
  t130 = t27 * t127
  t133 = (0.2e1 * t26 * t127 + 0.9e1 * t130) * t33
  t137 = t30 / t32 / t31
  t138 = t85 * t27
  t143 = 0.1e1 / t65 / t64
  t147 = t43 / t45 / t44 / r0
  t148 = t40 * t147
  t154 = t54 * t56 / t18 / t57 / t44
  t156 = -0.40121303703703703703703703703703703703703703703704e0 * t148 - 0.28692789826413811200000000000000000000000000000000e-1 * t154
  t160 = t68 * t47
  t172 = t80 / t81 / t64
  t181 = t111 ** 2
  t182 = t181 ** 2
  t183 = t182 ** 2
  t186 = t87 / t183 / t111
  t194 = (-0.5e1 / 0.3e1 * t160 + t147 / 0.3e1) * t35 * t39
  t219 = f.my_piecewise3(t2, 0, -t6 * t17 / t45 * t113 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t133 * t85 - 0.6e1 * t137 * t138 * t127 + t34 * (-t143 * t156 / 0.5e1 + (-0.11936087851851851851851851851851851851851851851852e1 * t148 - 0.35e2 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t160 - 0.31646617777777777777777777777777777777777777777779e-1 * t147) * t35 * t39) * t82 / 0.9e1 - 0.2e1 / 0.45e2 * t172 * t156) + (0.6e1 * t137 * t130 - t133) * t111 + t186 * (-0.125e3 / 0.19683e5 * t154 - 0.10e2 / 0.9e1 * t91 * t147 + 0.584e3 / 0.405e3 * t100 * (t194 / 0.4e1 - 0.2e1 / 0.27e2 * t148) - 0.6e1 * (0.73e2 / 0.1620e4 * t194 - 0.146e3 / 0.10935e5 * t148) * t26 * t107 - 0.6e1 * t105 * t127 * t107 + 0.6e1 * t106 * t127) / 0.10e2))
  vrho_0_ = 0.2e1 * r0 * t219 + 0.2e1 * t117
  t224 = f.my_piecewise3(t25, t20 * t22 / 0.8e1, 0)
  t227 = t27 * t224
  t230 = (0.2e1 * t26 * t224 + 0.9e1 * t227) * t33
  t235 = t42 * t47
  t240 = t54 * s0 * t41 * t60
  t242 = 0.15045488888888888888888888888888888888888888888889e0 * t40 * t235 + 0.10759796184905179200000000000000000000000000000000e-1 * t240
  t258 = t39 * t42 * t47
  t281 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t230 * t85 - 0.6e1 * t137 * t138 * t224 + t34 * (-t143 * t242 / 0.5e1 + 0.44605775205761316872427983539094650205761316872429e-1 * t40 * t235 * t82 - 0.2e1 / 0.45e2 * t172 * t242) + (0.6e1 * t137 * t227 - t230) * t111 + t186 * (0.125e3 / 0.52488e5 * t240 + 0.5e1 / 0.12e2 * t90 * t258 - 0.73e2 / 0.14580e5 * t100 * t35 * t258 + 0.73e2 / 0.19440e5 * t40 * t42 * t47 * t26 * t107 - 0.6e1 * t105 * t224 * t107 + 0.6e1 * t106 * t224) / 0.10e2))
  vsigma_0_ = 0.2e1 * r0 * t281
  vlapl_0_ = 0.0e0
  t283 = tau0 ** 2
  t287 = f.my_piecewise3(t25, -t21 / t283 / 0.8e1, 0)
  t290 = t27 * t287
  t293 = (0.2e1 * t26 * t287 + 0.9e1 * t290) * t33
  t299 = t70 * t35
  t330 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t293 * t85 - 0.6e1 * t137 * t138 * t287 - 0.62888224691358024691358024691358024691358024691358e-1 * t34 * t42 * t299 * t39 * t82 + (0.6e1 * t137 * t290 - t293) * t111 + t186 * (0.146e3 / 0.405e3 * t100 * t42 * t299 * t39 - 0.73e2 / 0.270e3 * t42 * t70 * t35 * t39 * t26 * t107 - 0.6e1 * t105 * t287 * t107 + 0.6e1 * t106 * t287) / 0.10e2))
  vtau_0_ = 0.2e1 * r0 * t330
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t24 = 0.1e1 / tau0
  t26 = s0 / r0 * t24 / 0.8e1
  t27 = t26 < 0.10e1
  t28 = f.my_piecewise3(t27, t26, 0.10e1)
  t29 = t28 ** 2
  t30 = t29 * t28
  t32 = t29 + 0.3e1 * t30
  t33 = 0.1e1 + t30
  t34 = t33 ** 2
  t35 = 0.1e1 / t34
  t36 = t32 * t35
  t37 = 6 ** (0.1e1 / 0.3e1)
  t38 = jnp.pi ** 2
  t39 = t38 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t41 = 0.1e1 / t40
  t42 = t37 * t41
  t43 = 2 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = s0 * t44
  t46 = r0 ** 2
  t48 = 0.1e1 / t19 / t46
  t49 = t45 * t48
  t50 = t42 * t49
  t52 = t37 ** 2
  t55 = t52 / t39 / t38
  t56 = s0 ** 2
  t57 = t56 * t43
  t58 = t46 ** 2
  t65 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t50 + 0.53798980924525896000000000000000000000000000000000e-2 * t55 * t57 / t18 / t58 / r0
  t66 = t65 ** (0.1e1 / 0.5e1)
  t69 = tau0 * t44
  t71 = 0.1e1 / t19 / r0
  t72 = t69 * t71
  t81 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t50 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t72 + 0.25633760400000000000000000000000000000000000000000e0 * t52 * t40 + 0.11867481666666666666666666666666666666666666666667e-1 * t49) * t37 * t41
  t82 = t66 ** 2
  t83 = 0.1e1 / t82
  t86 = 0.1e1 / t66 + 0.7e1 / 0.9e1 * t81 * t83
  t88 = 0.1e1 - t36
  t92 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t50) * t37 * t41
  t101 = (t72 - t49 / 0.8e1) * t37 * t41 / 0.4e1 - 0.9e1 / 0.20e2 + t50 / 0.36e2
  t102 = t101 ** 2
  t104 = t101 * t28
  t105 = 0.1e1 - t28
  t108 = 0.1e1 + 0.5e1 / 0.12e2 * t92 * t49 + 0.292e3 / 0.405e3 * t102 - 0.146e3 / 0.135e3 * t104 * t105
  t109 = t108 ** (0.1e1 / 0.10e2)
  t111 = t88 * t109 + t36 * t86
  t115 = t17 * t18
  t120 = f.my_piecewise3(t27, -s0 / t46 * t24 / 0.8e1, 0)
  t123 = t29 * t120
  t125 = 0.2e1 * t28 * t120 + 0.9e1 * t123
  t126 = t125 * t35
  t129 = 0.1e1 / t34 / t33
  t130 = t32 * t129
  t131 = t86 * t29
  t132 = t131 * t120
  t136 = 0.1e1 / t66 / t65
  t137 = t46 * r0
  t139 = 0.1e1 / t19 / t137
  t140 = t45 * t139
  t141 = t42 * t140
  t147 = t55 * t57 / t18 / t58 / t46
  t149 = -0.40121303703703703703703703703703703703703703703704e0 * t141 - 0.28692789826413811200000000000000000000000000000000e-1 * t147
  t153 = t69 * t48
  t160 = -0.17051554074074074074074074074074074074074074074074e0 * t141 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t153 - 0.31646617777777777777777777777777777777777777777779e-1 * t140) * t37 * t41
  t164 = 0.1e1 / t82 / t65
  t165 = t81 * t164
  t168 = -t136 * t149 / 0.5e1 + 0.7e1 / 0.9e1 * t160 * t83 - 0.14e2 / 0.45e2 * t165 * t149
  t172 = 0.6e1 * t130 * t123 - t126
  t174 = t109 ** 2
  t175 = t174 ** 2
  t176 = t175 ** 2
  t177 = t176 * t109
  t178 = 0.1e1 / t177
  t179 = t88 * t178
  t190 = (-0.5e1 / 0.3e1 * t153 + t140 / 0.3e1) * t37 * t41 / 0.4e1 - 0.2e1 / 0.27e2 * t141
  t193 = t190 * t28
  t201 = -0.125e3 / 0.19683e5 * t147 - 0.10e2 / 0.9e1 * t92 * t140 + 0.584e3 / 0.405e3 * t101 * t190 - 0.146e3 / 0.135e3 * t193 * t105 - 0.146e3 / 0.135e3 * t101 * t120 * t105 + 0.146e3 / 0.135e3 * t104 * t120
  t204 = t126 * t86 - 0.6e1 * t130 * t132 + t36 * t168 + t172 * t109 + t179 * t201 / 0.10e2
  t209 = f.my_piecewise3(t2, 0, -t6 * t21 * t111 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t115 * t204)
  t218 = t120 ** 2
  t224 = f.my_piecewise3(t27, s0 / t137 * t24 / 0.4e1, 0)
  t227 = t28 * t218
  t229 = t29 * t224
  t232 = (0.2e1 * t28 * t224 + 0.2e1 * t218 + 0.18e2 * t227 + 0.9e1 * t229) * t35
  t234 = t125 * t129
  t239 = t34 ** 2
  t241 = t32 / t239
  t242 = t29 ** 2
  t258 = t65 ** 2
  t261 = t149 ** 2
  t266 = t45 / t19 / t58
  t267 = t42 * t266
  t273 = t55 * t57 / t18 / t58 / t137
  t275 = 0.14711144691358024691358024691358024691358024691358e1 * t267 + 0.18172100223395413760000000000000000000000000000000e0 * t273
  t279 = t69 * t139
  t318 = t201 ** 2
  t324 = t190 ** 2
  t333 = (0.40e2 / 0.9e1 * t279 - 0.11e2 / 0.9e1 * t266) * t37 * t41 / 0.4e1 + 0.22e2 / 0.81e2 * t267
  t354 = t232 * t86 - 0.12e2 * t234 * t132 + 0.2e1 * t126 * t168 + 0.54e2 * t241 * t86 * t242 * t218 - 0.12e2 * t130 * t168 * t29 * t120 - 0.12e2 * t130 * t86 * t28 * t218 - 0.6e1 * t130 * t131 * t224 + t36 * (0.6e1 / 0.25e2 / t66 / t258 * t261 - t136 * t275 / 0.5e1 + 0.7e1 / 0.9e1 * (0.62522364938271604938271604938271604938271604938271e0 * t267 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t279 + 0.11603759851851851851851851851851851851851851851852e0 * t266) * t37 * t41) * t83 - 0.28e2 / 0.45e2 * t160 * t164 * t149 + 0.98e2 / 0.225e3 * t81 / t82 / t258 * t261 - 0.14e2 / 0.45e2 * t165 * t275) + (-0.54e2 * t241 * t242 * t218 + 0.12e2 * t234 * t123 + 0.12e2 * t130 * t227 + 0.6e1 * t130 * t229 - t232) * t109 + t172 * t178 * t201 / 0.5e1 - 0.9e1 / 0.100e3 * t88 / t177 / t108 * t318 + t179 * (0.125e3 / 0.2187e4 * t273 + 0.110e3 / 0.27e2 * t92 * t266 + 0.584e3 / 0.405e3 * t324 + 0.584e3 / 0.405e3 * t101 * t333 - 0.146e3 / 0.135e3 * t333 * t28 * t105 - 0.292e3 / 0.135e3 * t190 * t120 * t105 + 0.292e3 / 0.135e3 * t193 * t120 - 0.146e3 / 0.135e3 * t101 * t224 * t105 + 0.292e3 / 0.135e3 * t101 * t218 + 0.146e3 / 0.135e3 * t104 * t224) / 0.10e2
  t359 = f.my_piecewise3(t2, 0, t6 * t17 * t71 * t111 / 0.12e2 - t6 * t21 * t204 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t115 * t354)
  v2rho2_0_ = 0.2e1 * r0 * t359 + 0.4e1 * t209
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t25 = 0.1e1 / tau0
  t27 = s0 / r0 * t25 / 0.8e1
  t28 = t27 < 0.10e1
  t29 = f.my_piecewise3(t28, t27, 0.10e1)
  t30 = t29 ** 2
  t31 = t30 * t29
  t33 = t30 + 0.3e1 * t31
  t34 = 0.1e1 + t31
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t33 * t36
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = jnp.pi ** 2
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t43 = t38 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t46 = s0 * t45
  t47 = r0 ** 2
  t49 = 0.1e1 / t19 / t47
  t50 = t46 * t49
  t51 = t43 * t50
  t53 = t38 ** 2
  t56 = t53 / t40 / t39
  t57 = s0 ** 2
  t58 = t57 * t44
  t59 = t47 ** 2
  t60 = t59 * r0
  t66 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t51 + 0.53798980924525896000000000000000000000000000000000e-2 * t56 * t58 / t18 / t60
  t67 = t66 ** (0.1e1 / 0.5e1)
  t70 = tau0 * t45
  t71 = t70 * t21
  t80 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t51 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t71 + 0.25633760400000000000000000000000000000000000000000e0 * t53 * t41 + 0.11867481666666666666666666666666666666666666666667e-1 * t50) * t38 * t42
  t81 = t67 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t67 + 0.7e1 / 0.9e1 * t80 * t82
  t87 = 0.1e1 - t37
  t91 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t51) * t38 * t42
  t100 = (t71 - t50 / 0.8e1) * t38 * t42 / 0.4e1 - 0.9e1 / 0.20e2 + t51 / 0.36e2
  t101 = t100 ** 2
  t103 = t100 * t29
  t104 = 0.1e1 - t29
  t107 = 0.1e1 + 0.5e1 / 0.12e2 * t91 * t50 + 0.292e3 / 0.405e3 * t101 - 0.146e3 / 0.135e3 * t103 * t104
  t108 = t107 ** (0.1e1 / 0.10e2)
  t110 = t87 * t108 + t37 * t85
  t115 = t17 / t19
  t120 = f.my_piecewise3(t28, -s0 / t47 * t25 / 0.8e1, 0)
  t121 = t29 * t120
  t123 = t30 * t120
  t125 = 0.2e1 * t121 + 0.9e1 * t123
  t126 = t125 * t36
  t129 = 0.1e1 / t35 / t34
  t130 = t33 * t129
  t131 = t85 * t30
  t132 = t131 * t120
  t136 = 0.1e1 / t67 / t66
  t137 = t47 * r0
  t139 = 0.1e1 / t19 / t137
  t140 = t46 * t139
  t141 = t43 * t140
  t147 = t56 * t58 / t18 / t59 / t47
  t149 = -0.40121303703703703703703703703703703703703703703704e0 * t141 - 0.28692789826413811200000000000000000000000000000000e-1 * t147
  t153 = t70 * t49
  t160 = -0.17051554074074074074074074074074074074074074074074e0 * t141 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t153 - 0.31646617777777777777777777777777777777777777777779e-1 * t140) * t38 * t42
  t164 = 0.1e1 / t81 / t66
  t165 = t80 * t164
  t168 = -t136 * t149 / 0.5e1 + 0.7e1 / 0.9e1 * t160 * t82 - 0.14e2 / 0.45e2 * t165 * t149
  t172 = 0.6e1 * t130 * t123 - t126
  t174 = t108 ** 2
  t175 = t174 ** 2
  t176 = t175 ** 2
  t177 = t176 * t108
  t178 = 0.1e1 / t177
  t179 = t87 * t178
  t190 = (-0.5e1 / 0.3e1 * t153 + t140 / 0.3e1) * t38 * t42 / 0.4e1 - 0.2e1 / 0.27e2 * t141
  t193 = t190 * t29
  t201 = -0.125e3 / 0.19683e5 * t147 - 0.10e2 / 0.9e1 * t91 * t140 + 0.584e3 / 0.405e3 * t100 * t190 - 0.146e3 / 0.135e3 * t193 * t104 - 0.146e3 / 0.135e3 * t100 * t120 * t104 + 0.146e3 / 0.135e3 * t103 * t120
  t204 = t126 * t85 - 0.6e1 * t130 * t132 + t37 * t168 + t172 * t108 + t179 * t201 / 0.10e2
  t208 = t17 * t18
  t209 = t120 ** 2
  t215 = f.my_piecewise3(t28, s0 / t137 * t25 / 0.4e1, 0)
  t218 = t29 * t209
  t220 = t30 * t215
  t222 = 0.2e1 * t29 * t215 + 0.2e1 * t209 + 0.18e2 * t218 + 0.9e1 * t220
  t223 = t222 * t36
  t225 = t125 * t129
  t230 = t35 ** 2
  t231 = 0.1e1 / t230
  t232 = t33 * t231
  t233 = t30 ** 2
  t235 = t85 * t233 * t209
  t238 = t168 * t30
  t239 = t238 * t120
  t243 = t85 * t29 * t209
  t246 = t131 * t215
  t249 = t66 ** 2
  t251 = 0.1e1 / t67 / t249
  t252 = t149 ** 2
  t256 = 0.1e1 / t19 / t59
  t257 = t46 * t256
  t258 = t43 * t257
  t264 = t56 * t58 / t18 / t59 / t137
  t266 = 0.14711144691358024691358024691358024691358024691358e1 * t258 + 0.18172100223395413760000000000000000000000000000000e0 * t264
  t270 = t70 * t139
  t277 = 0.62522364938271604938271604938271604938271604938271e0 * t258 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t270 + 0.11603759851851851851851851851851851851851851851852e0 * t257) * t38 * t42
  t280 = t160 * t164
  t284 = 0.1e1 / t81 / t249
  t285 = t80 * t284
  t290 = 0.6e1 / 0.25e2 * t251 * t252 - t136 * t266 / 0.5e1 + 0.7e1 / 0.9e1 * t277 * t82 - 0.28e2 / 0.45e2 * t280 * t149 + 0.98e2 / 0.225e3 * t285 * t252 - 0.14e2 / 0.45e2 * t165 * t266
  t294 = t233 * t209
  t301 = 0.12e2 * t225 * t123 + 0.12e2 * t130 * t218 + 0.6e1 * t130 * t220 - 0.54e2 * t232 * t294 - t223
  t303 = t172 * t178
  t307 = 0.1e1 / t177 / t107
  t308 = t87 * t307
  t309 = t201 ** 2
  t315 = t190 ** 2
  t324 = (0.40e2 / 0.9e1 * t270 - 0.11e2 / 0.9e1 * t257) * t38 * t42 / 0.4e1 + 0.22e2 / 0.81e2 * t258
  t327 = t324 * t29
  t335 = t100 * t215
  t342 = 0.125e3 / 0.2187e4 * t264 + 0.110e3 / 0.27e2 * t91 * t257 + 0.584e3 / 0.405e3 * t315 + 0.584e3 / 0.405e3 * t100 * t324 - 0.146e3 / 0.135e3 * t327 * t104 - 0.292e3 / 0.135e3 * t190 * t120 * t104 + 0.292e3 / 0.135e3 * t193 * t120 - 0.146e3 / 0.135e3 * t335 * t104 + 0.292e3 / 0.135e3 * t100 * t209 + 0.146e3 / 0.135e3 * t103 * t215
  t345 = t223 * t85 - 0.12e2 * t225 * t132 + 0.2e1 * t126 * t168 + 0.54e2 * t232 * t235 - 0.12e2 * t130 * t239 - 0.12e2 * t130 * t243 - 0.6e1 * t130 * t246 + t37 * t290 + t301 * t108 + t303 * t201 / 0.5e1 - 0.9e1 / 0.100e3 * t308 * t309 + t179 * t342 / 0.10e2
  t350 = f.my_piecewise3(t2, 0, t6 * t22 * t110 / 0.12e2 - t6 * t115 * t204 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t208 * t345)
  t364 = t233 * t120 * t215
  t368 = t121 * t215
  t371 = t107 ** 2
  t391 = f.my_piecewise3(t28, -0.3e1 / 0.4e1 * s0 / t59 * t25, 0)
  t394 = t209 * t120
  t397 = t30 * t391
  t400 = (0.6e1 * t120 * t215 + 0.2e1 * t29 * t391 + 0.54e2 * t368 + 0.18e2 * t394 + 0.9e1 * t397) * t36
  t404 = t249 * t66
  t407 = t252 * t149
  t415 = t46 / t19 / t60
  t416 = t43 * t415
  t418 = t59 ** 2
  t422 = t56 * t58 / t18 / t418
  t424 = -0.68652008559670781893004115226337448559670781893004e1 * t416 - 0.13326206830489970090666666666666666666666666666667e1 * t422
  t428 = t70 * t256
  t470 = (-0.440e3 / 0.27e2 * t428 + 0.154e3 / 0.27e2 * t415) * t38 * t42 / 0.4e1 - 0.308e3 / 0.243e3 * t416
  t495 = -0.85250e5 / 0.177147e6 * t422 - 0.1540e4 / 0.81e2 * t91 * t415 + 0.584e3 / 0.135e3 * t190 * t324 + 0.584e3 / 0.405e3 * t100 * t470 - 0.146e3 / 0.135e3 * t470 * t29 * t104 - 0.146e3 / 0.45e2 * t324 * t120 * t104 + 0.146e3 / 0.45e2 * t327 * t120 - 0.146e3 / 0.45e2 * t190 * t215 * t104 + 0.292e3 / 0.45e2 * t190 * t209 + 0.146e3 / 0.45e2 * t193 * t215 - 0.146e3 / 0.135e3 * t100 * t391 * t104 + 0.292e3 / 0.45e2 * t335 * t120 + 0.146e3 / 0.135e3 * t103 * t391
  t501 = t222 * t129
  t504 = t125 * t231
  t513 = t33 / t230 / t34
  t514 = t233 * t30
  t529 = -0.324e3 * t232 * t31 * t394 + 0.648e3 * t513 * t514 * t394 + 0.18e2 * t501 * t123 + 0.36e2 * t130 * t368 + 0.12e2 * t130 * t394 + 0.6e1 * t130 * t397 + 0.36e2 * t225 * t218 + 0.18e2 * t225 * t220 - 0.162e3 * t232 * t364 - 0.162e3 * t504 * t294 - t400
  t535 = 0.162e3 * t232 * t85 * t364 - 0.36e2 * t130 * t85 * t368 + 0.171e3 / 0.1000e4 * t87 / t177 / t371 * t309 * t201 + 0.3e1 * t223 * t168 - 0.27e2 / 0.100e3 * t172 * t307 * t309 + 0.3e1 * t126 * t290 + t400 * t85 + 0.3e1 / 0.10e2 * t303 * t342 + t37 * (-0.66e2 / 0.125e3 / t67 / t404 * t407 + 0.18e2 / 0.25e2 * t251 * t149 * t266 - t136 * t424 / 0.5e1 + 0.7e1 / 0.9e1 * (-0.29177103637860082304526748971193415637860082304526e1 * t416 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t428 - 0.54150879308641975308641975308641975308641975308643e0 * t415) * t38 * t42) * t82 - 0.14e2 / 0.15e2 * t277 * t164 * t149 + 0.98e2 / 0.75e2 * t160 * t284 * t252 - 0.14e2 / 0.15e2 * t280 * t266 - 0.392e3 / 0.375e3 * t80 / t81 / t404 * t407 + 0.98e2 / 0.75e2 * t285 * t149 * t266 - 0.14e2 / 0.45e2 * t165 * t424) + t179 * t495 / 0.10e2 + 0.3e1 / 0.10e2 * t301 * t178 * t201 + t529 * t108 - 0.36e2 * t130 * t168 * t29 * t209
  t574 = -0.36e2 * t225 * t243 - 0.18e2 * t130 * t290 * t30 * t120 + 0.324e3 * t232 * t85 * t31 * t394 - 0.18e2 * t501 * t132 - 0.36e2 * t225 * t239 - 0.6e1 * t130 * t131 * t391 - 0.18e2 * t225 * t246 + 0.162e3 * t504 * t235 - 0.18e2 * t130 * t238 * t215 + 0.162e3 * t232 * t168 * t233 * t209 - 0.648e3 * t513 * t85 * t514 * t394 - 0.27e2 / 0.100e3 * t308 * t201 * t342 - 0.12e2 * t130 * t85 * t394
  t580 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t49 * t110 + t6 * t22 * t204 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t115 * t345 - 0.3e1 / 0.8e1 * t6 * t208 * (t535 + t574))
  v3rho3_0_ = 0.2e1 * r0 * t580 + 0.6e1 * t350

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t26 = 0.1e1 / tau0
  t28 = s0 / r0 * t26 / 0.8e1
  t29 = t28 < 0.10e1
  t30 = f.my_piecewise3(t29, t28, 0.10e1)
  t31 = t30 ** 2
  t32 = t31 * t30
  t34 = t31 + 0.3e1 * t32
  t35 = 0.1e1 + t32
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t39 * t43
  t45 = 2 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = s0 * t46
  t48 = t47 * t22
  t49 = t44 * t48
  t51 = t39 ** 2
  t54 = t51 / t41 / t40
  t55 = s0 ** 2
  t56 = t55 * t45
  t57 = t18 ** 2
  t58 = t57 * r0
  t64 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t49 + 0.53798980924525896000000000000000000000000000000000e-2 * t54 * t56 / t19 / t58
  t65 = t64 ** (0.1e1 / 0.5e1)
  t68 = tau0 * t46
  t70 = 0.1e1 / t20 / r0
  t71 = t68 * t70
  t80 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t49 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t71 + 0.25633760400000000000000000000000000000000000000000e0 * t51 * t42 + 0.11867481666666666666666666666666666666666666666667e-1 * t48) * t39 * t43
  t81 = t65 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t65 + 0.7e1 / 0.9e1 * t80 * t82
  t87 = 0.1e1 - t38
  t91 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t49) * t39 * t43
  t100 = (t71 - t48 / 0.8e1) * t39 * t43 / 0.4e1 - 0.9e1 / 0.20e2 + t49 / 0.36e2
  t101 = t100 ** 2
  t103 = t100 * t30
  t104 = 0.1e1 - t30
  t107 = 0.1e1 + 0.5e1 / 0.12e2 * t91 * t48 + 0.292e3 / 0.405e3 * t101 - 0.146e3 / 0.135e3 * t103 * t104
  t108 = t107 ** (0.1e1 / 0.10e2)
  t110 = t87 * t108 + t38 * t85
  t114 = t17 * t70
  t119 = f.my_piecewise3(t29, -s0 / t18 * t26 / 0.8e1, 0)
  t120 = t30 * t119
  t122 = t31 * t119
  t124 = 0.2e1 * t120 + 0.9e1 * t122
  t125 = t124 * t37
  t128 = 0.1e1 / t36 / t35
  t129 = t34 * t128
  t130 = t85 * t31
  t131 = t130 * t119
  t135 = 0.1e1 / t65 / t64
  t136 = t18 * r0
  t138 = 0.1e1 / t20 / t136
  t139 = t47 * t138
  t140 = t44 * t139
  t142 = t57 * t18
  t146 = t54 * t56 / t19 / t142
  t148 = -0.40121303703703703703703703703703703703703703703704e0 * t140 - 0.28692789826413811200000000000000000000000000000000e-1 * t146
  t152 = t68 * t22
  t159 = -0.17051554074074074074074074074074074074074074074074e0 * t140 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t152 - 0.31646617777777777777777777777777777777777777777779e-1 * t139) * t39 * t43
  t163 = 0.1e1 / t81 / t64
  t164 = t80 * t163
  t167 = -t135 * t148 / 0.5e1 + 0.7e1 / 0.9e1 * t159 * t82 - 0.14e2 / 0.45e2 * t164 * t148
  t171 = 0.6e1 * t129 * t122 - t125
  t173 = t108 ** 2
  t174 = t173 ** 2
  t175 = t174 ** 2
  t176 = t175 * t108
  t177 = 0.1e1 / t176
  t178 = t87 * t177
  t189 = (-0.5e1 / 0.3e1 * t152 + t139 / 0.3e1) * t39 * t43 / 0.4e1 - 0.2e1 / 0.27e2 * t140
  t192 = t189 * t30
  t200 = -0.125e3 / 0.19683e5 * t146 - 0.10e2 / 0.9e1 * t91 * t139 + 0.584e3 / 0.405e3 * t100 * t189 - 0.146e3 / 0.135e3 * t192 * t104 - 0.146e3 / 0.135e3 * t100 * t119 * t104 + 0.146e3 / 0.135e3 * t103 * t119
  t203 = t125 * t85 - 0.6e1 * t129 * t131 + t38 * t167 + t171 * t108 + t178 * t200 / 0.10e2
  t208 = t17 / t20
  t209 = t119 ** 2
  t215 = f.my_piecewise3(t29, s0 / t136 * t26 / 0.4e1, 0)
  t218 = t30 * t209
  t220 = t31 * t215
  t222 = 0.2e1 * t30 * t215 + 0.2e1 * t209 + 0.18e2 * t218 + 0.9e1 * t220
  t223 = t222 * t37
  t225 = t124 * t128
  t230 = t36 ** 2
  t231 = 0.1e1 / t230
  t232 = t34 * t231
  t233 = t31 ** 2
  t234 = t85 * t233
  t235 = t234 * t209
  t238 = t167 * t31
  t239 = t238 * t119
  t242 = t85 * t30
  t243 = t242 * t209
  t246 = t130 * t215
  t249 = t64 ** 2
  t251 = 0.1e1 / t65 / t249
  t252 = t148 ** 2
  t256 = 0.1e1 / t20 / t57
  t257 = t47 * t256
  t258 = t44 * t257
  t264 = t54 * t56 / t19 / t57 / t136
  t266 = 0.14711144691358024691358024691358024691358024691358e1 * t258 + 0.18172100223395413760000000000000000000000000000000e0 * t264
  t270 = t68 * t138
  t277 = 0.62522364938271604938271604938271604938271604938271e0 * t258 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t270 + 0.11603759851851851851851851851851851851851851851852e0 * t257) * t39 * t43
  t280 = t159 * t163
  t284 = 0.1e1 / t81 / t249
  t285 = t80 * t284
  t290 = 0.6e1 / 0.25e2 * t251 * t252 - t135 * t266 / 0.5e1 + 0.7e1 / 0.9e1 * t277 * t82 - 0.28e2 / 0.45e2 * t280 * t148 + 0.98e2 / 0.225e3 * t285 * t252 - 0.14e2 / 0.45e2 * t164 * t266
  t294 = t233 * t209
  t301 = 0.12e2 * t225 * t122 + 0.12e2 * t129 * t218 + 0.6e1 * t129 * t220 - 0.54e2 * t232 * t294 - t223
  t303 = t171 * t177
  t307 = 0.1e1 / t176 / t107
  t308 = t87 * t307
  t309 = t200 ** 2
  t315 = t189 ** 2
  t324 = (0.40e2 / 0.9e1 * t270 - 0.11e2 / 0.9e1 * t257) * t39 * t43 / 0.4e1 + 0.22e2 / 0.81e2 * t258
  t327 = t324 * t30
  t335 = t100 * t215
  t342 = 0.125e3 / 0.2187e4 * t264 + 0.110e3 / 0.27e2 * t91 * t257 + 0.584e3 / 0.405e3 * t315 + 0.584e3 / 0.405e3 * t100 * t324 - 0.146e3 / 0.135e3 * t327 * t104 - 0.292e3 / 0.135e3 * t189 * t119 * t104 + 0.292e3 / 0.135e3 * t192 * t119 - 0.146e3 / 0.135e3 * t335 * t104 + 0.292e3 / 0.135e3 * t100 * t209 + 0.146e3 / 0.135e3 * t103 * t215
  t345 = t223 * t85 - 0.12e2 * t225 * t131 + 0.2e1 * t125 * t167 + 0.54e2 * t232 * t235 - 0.12e2 * t129 * t239 - 0.12e2 * t129 * t243 - 0.6e1 * t129 * t246 + t38 * t290 + t301 * t108 + t303 * t200 / 0.5e1 - 0.9e1 / 0.100e3 * t308 * t309 + t178 * t342 / 0.10e2
  t349 = t17 * t19
  t351 = t167 * t233 * t209
  t355 = t167 * t30 * t209
  t361 = t209 * t119
  t362 = t85 * t32 * t361
  t365 = t222 * t128
  t368 = t238 * t215
  t377 = f.my_piecewise3(t29, -0.3e1 / 0.4e1 * s0 / t57 * t26, 0)
  t378 = t130 * t377
  t383 = t124 * t231
  t387 = 0.1e1 / t230 / t35
  t388 = t34 * t387
  t389 = t233 * t31
  t391 = t85 * t389 * t361
  t394 = t290 * t31
  t395 = t394 * t119
  t403 = t120 * t215
  t405 = t31 * t377
  t407 = 0.6e1 * t119 * t215 + 0.2e1 * t30 * t377 + 0.18e2 * t361 + 0.54e2 * t403 + 0.9e1 * t405
  t408 = t407 * t37
  t417 = t389 * t361
  t420 = t32 * t361
  t423 = t233 * t119
  t424 = t423 * t215
  t433 = 0.18e2 * t365 * t122 + 0.12e2 * t129 * t361 + 0.36e2 * t129 * t403 + 0.6e1 * t129 * t405 + 0.36e2 * t225 * t218 + 0.18e2 * t225 * t220 - 0.324e3 * t232 * t420 - 0.162e3 * t232 * t424 - 0.162e3 * t383 * t294 + 0.648e3 * t388 * t417 - t408
  t435 = t433 * t108 - 0.36e2 * t129 * t355 - 0.18e2 * t129 * t368 - 0.6e1 * t129 * t378 - 0.18e2 * t129 * t395 - 0.18e2 * t365 * t131 - 0.36e2 * t225 * t239 - 0.36e2 * t225 * t243 - 0.18e2 * t225 * t246 + 0.162e3 * t232 * t351 + 0.324e3 * t232 * t362 + 0.162e3 * t383 * t235 - 0.648e3 * t388 * t391
  t436 = t85 * t361
  t439 = t200 * t342
  t442 = t57 ** 2
  t446 = t54 * t56 / t19 / t442
  t449 = 0.1e1 / t20 / t58
  t450 = t47 * t449
  t455 = t68 * t256
  t462 = t44 * t450
  t464 = (-0.440e3 / 0.27e2 * t455 + 0.154e3 / 0.27e2 * t450) * t39 * t43 / 0.4e1 - 0.308e3 / 0.243e3 * t462
  t467 = t464 * t30
  t475 = t189 * t215
  t482 = t100 * t377
  t489 = -0.85250e5 / 0.177147e6 * t446 - 0.1540e4 / 0.81e2 * t91 * t450 + 0.584e3 / 0.135e3 * t189 * t324 + 0.584e3 / 0.405e3 * t100 * t464 - 0.146e3 / 0.135e3 * t467 * t104 - 0.146e3 / 0.45e2 * t324 * t119 * t104 + 0.146e3 / 0.45e2 * t327 * t119 - 0.146e3 / 0.45e2 * t475 * t104 + 0.292e3 / 0.45e2 * t189 * t209 + 0.146e3 / 0.45e2 * t192 * t215 - 0.146e3 / 0.135e3 * t482 * t104 + 0.292e3 / 0.45e2 * t335 * t119 + 0.146e3 / 0.135e3 * t103 * t377
  t492 = t301 * t177
  t500 = t249 * t64
  t502 = 0.1e1 / t65 / t500
  t503 = t252 * t148
  t506 = t251 * t148
  t511 = -0.68652008559670781893004115226337448559670781893004e1 * t462 - 0.13326206830489970090666666666666666666666666666667e1 * t446
  t521 = -0.29177103637860082304526748971193415637860082304526e1 * t462 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t455 - 0.54150879308641975308641975308641975308641975308643e0 * t450) * t39 * t43
  t524 = t277 * t163
  t527 = t159 * t284
  t533 = 0.1e1 / t81 / t500
  t534 = t80 * t533
  t537 = t148 * t266
  t542 = -0.66e2 / 0.125e3 * t502 * t503 + 0.18e2 / 0.25e2 * t506 * t266 - t135 * t511 / 0.5e1 + 0.7e1 / 0.9e1 * t521 * t82 - 0.14e2 / 0.15e2 * t524 * t148 + 0.98e2 / 0.75e2 * t527 * t252 - 0.14e2 / 0.15e2 * t280 * t266 - 0.392e3 / 0.375e3 * t534 * t503 + 0.98e2 / 0.75e2 * t285 * t537 - 0.14e2 / 0.45e2 * t164 * t511
  t546 = t171 * t307
  t549 = t107 ** 2
  t551 = 0.1e1 / t176 / t549
  t552 = t87 * t551
  t553 = t309 * t200
  t556 = t232 * t85
  t559 = t129 * t85
  t562 = -0.12e2 * t129 * t436 - 0.27e2 / 0.100e3 * t308 * t439 + t178 * t489 / 0.10e2 + 0.3e1 / 0.10e2 * t492 * t200 + 0.3e1 / 0.10e2 * t303 * t342 + 0.3e1 * t125 * t290 + t408 * t85 + t38 * t542 + 0.3e1 * t223 * t167 - 0.27e2 / 0.100e3 * t546 * t309 + 0.171e3 / 0.1000e4 * t552 * t553 + 0.162e3 * t556 * t424 - 0.36e2 * t559 * t403
  t563 = t435 + t562
  t568 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t110 + t6 * t114 * t203 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t208 * t345 - 0.3e1 / 0.8e1 * t6 * t349 * t563)
  t591 = t233 * t30
  t592 = t209 ** 2
  t597 = t389 * t209 * t215
  t604 = t32 * t209 * t215
  t607 = t215 ** 2
  t611 = t423 * t377
  t614 = t30 * t607
  t617 = -0.162e3 * t232 * t233 * t607 - 0.1080e4 * t232 * t31 * t592 + 0.7776e4 * t388 * t591 * t592 + 0.36e2 * t129 * t614 + 0.72e2 * t365 * t218 + 0.144e3 * t225 * t403 - 0.1944e4 * t232 * t604 - 0.216e3 * t232 * t611 - 0.1296e4 * t383 * t420 - 0.648e3 * t383 * t424 + 0.3888e4 * t388 * t597
  t618 = t120 * t377
  t628 = f.my_piecewise3(t29, 0.3e1 * s0 / t58 * t26, 0)
  t631 = t209 * t215
  t635 = t31 * t628
  t638 = (0.8e1 * t119 * t377 + 0.2e1 * t30 * t628 + 0.6e1 * t607 + 0.54e2 * t614 + 0.72e2 * t618 + 0.108e3 * t631 + 0.9e1 * t635) * t37
  t639 = t407 * t128
  t644 = t222 * t231
  t647 = t124 * t387
  t656 = t34 / t230 / t36
  t657 = t233 ** 2
  t665 = -0.9720e4 * t656 * t657 * t592 + 0.24e2 * t639 * t122 + 0.48e2 * t129 * t618 + 0.72e2 * t129 * t631 + 0.6e1 * t129 * t635 + 0.36e2 * t365 * t220 + 0.48e2 * t225 * t361 + 0.24e2 * t225 * t405 - 0.324e3 * t644 * t294 + 0.2592e4 * t647 * t417 - t638
  t699 = (t617 + t665) * t108 - 0.2592e4 * t388 * t167 * t389 * t361 - 0.36e2 * t129 * t394 * t215 - 0.24e2 * t129 * t238 * t377 - 0.36e2 * t365 * t246 - 0.24e2 * t225 * t378 + 0.324e3 * t644 * t235 - 0.2592e4 * t647 * t391 - 0.72e2 * t365 * t239 - 0.6e1 * t129 * t130 * t628 + 0.9720e4 * t656 * t85 * t657 * t592 - 0.144e3 * t225 * t355 - 0.72e2 * t365 * t243
  t724 = t342 ** 2
  t734 = t309 ** 2
  t743 = -0.72e2 * t129 * t290 * t30 * t209 + 0.648e3 * t383 * t351 - 0.24e2 * t639 * t131 - 0.36e2 * t129 * t242 * t607 + 0.1296e4 * t383 * t362 + 0.1296e4 * t232 * t167 * t32 * t361 - 0.7776e4 * t388 * t85 * t591 * t592 + 0.162e3 * t232 * t234 * t607 - 0.27e2 / 0.100e3 * t308 * t724 - 0.27e2 / 0.50e2 * t301 * t307 * t309 - 0.4959e4 / 0.10000e5 * t87 / t176 / t549 / t107 * t734 + 0.171e3 / 0.250e3 * t171 * t551 * t553 + 0.2e1 / 0.5e1 * t433 * t177 * t200
  t779 = 0.648e3 * t232 * t167 * t424 - 0.144e3 * t225 * t85 * t403 + 0.648e3 * t383 * t85 * t424 - 0.3888e4 * t388 * t85 * t597 + 0.1944e4 * t556 * t604 - 0.48e2 * t559 * t618 + 0.216e3 * t556 * t611 - 0.144e3 * t129 * t167 * t403 - 0.9e1 / 0.25e2 * t308 * t200 * t489 - 0.27e2 / 0.25e2 * t546 * t439 + 0.513e3 / 0.500e3 * t552 * t309 * t342 - 0.48e2 * t225 * t436 - 0.48e2 * t129 * t167 * t361
  t819 = t68 * t449
  t823 = t47 / t20 / t142
  t829 = t44 * t823
  t831 = (0.6160e4 / 0.81e2 * t819 - 0.2618e4 / 0.81e2 * t823) * t39 * t43 / 0.4e1 + 0.5236e4 / 0.729e3 * t829
  t849 = t54 * t56 / t19 / t442 / r0
  t851 = t324 ** 2
  t861 = -0.584e3 / 0.135e3 * t189 * t377 * t104 + 0.1168e4 / 0.45e2 * t475 * t119 + 0.584e3 / 0.135e3 * t192 * t377 - 0.146e3 / 0.135e3 * t100 * t628 * t104 + 0.1168e4 / 0.135e3 * t482 * t119 + 0.292e3 / 0.45e2 * t100 * t607 + 0.146e3 / 0.135e3 * t103 * t628 - 0.146e3 / 0.135e3 * t831 * t30 * t104 - 0.584e3 / 0.135e3 * t464 * t119 * t104 + 0.584e3 / 0.135e3 * t467 * t119 - 0.292e3 / 0.45e2 * t324 * t215 * t104 + 0.292e3 / 0.45e2 * t327 * t215 + 0.761750e6 / 0.177147e6 * t849 + 0.584e3 / 0.135e3 * t851 + 0.2336e4 / 0.405e3 * t189 * t464 + 0.584e3 / 0.405e3 * t100 * t831 + 0.584e3 / 0.45e2 * t324 * t209 + 0.26180e5 / 0.243e3 * t91 * t823
  t872 = 0.38902804850480109739368998628257887517146776406036e2 * t829 + 0.11105172358741641742222222222222222222222222222222e2 * t849
  t882 = t249 ** 2
  t885 = t252 ** 2
  t891 = t266 ** 2
  t929 = -0.14e2 / 0.45e2 * t164 * t872 - 0.56e2 / 0.45e2 * t521 * t163 * t148 - 0.28e2 / 0.15e2 * t524 * t266 - 0.56e2 / 0.45e2 * t280 * t511 + 0.1056e4 / 0.625e3 / t65 / t882 * t885 - 0.396e3 / 0.125e3 * t502 * t252 * t266 + 0.18e2 / 0.25e2 * t251 * t891 + 0.24e2 / 0.25e2 * t506 * t511 - t135 * t872 / 0.5e1 + 0.7e1 / 0.9e1 * (0.16533692061454046639231824417009602194787379972565e2 * t829 - 0.5e1 / 0.9e1 * (0.11068327545679012345679012345679012345679012345679e2 * t819 + 0.30685498274897119341563786008230452674897119341564e1 * t823) * t39 * t43) * t82 + 0.392e3 / 0.225e3 * t285 * t148 * t511 + 0.196e3 / 0.75e2 * t277 * t284 * t252 - 0.1568e4 / 0.375e3 * t159 * t533 * t503 + 0.392e3 / 0.75e2 * t527 * t537 + 0.6664e4 / 0.1875e4 * t80 / t81 / t882 * t885 - 0.784e3 / 0.125e3 * t534 * t252 * t266 + 0.98e2 / 0.75e2 * t285 * t891
  t933 = t638 * t85 + 0.6e1 * t223 * t290 - 0.72e2 * t225 * t395 - 0.24e2 * t129 * t542 * t31 * t119 - 0.72e2 * t129 * t85 * t209 * t215 + 0.1080e4 * t232 * t85 * t592 * t31 + 0.324e3 * t232 * t290 * t233 * t209 - 0.72e2 * t225 * t368 + t178 * t861 / 0.10e2 + 0.3e1 / 0.5e1 * t492 * t342 + 0.2e1 / 0.5e1 * t303 * t489 + 0.4e1 * t125 * t542 + t38 * t929 + 0.4e1 * t408 * t167
  t940 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t138 * t110 - 0.5e1 / 0.9e1 * t6 * t23 * t203 + t6 * t114 * t345 / 0.2e1 - t6 * t208 * t563 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t349 * (t699 + t743 + t779 + t933))
  v4rho4_0_ = 0.2e1 * r0 * t940 + 0.8e1 * t568

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t34 = 0.1e1 / tau0
  t36 = s0 / r0 * t34 / 0.8e1
  t37 = t36 < 0.10e1
  t38 = f.my_piecewise3(t37, t36, 0.10e1)
  t39 = t38 ** 2
  t40 = t39 * t38
  t42 = t39 + 0.3e1 * t40
  t43 = 0.1e1 + t40
  t44 = t43 ** 2
  t45 = 0.1e1 / t44
  t46 = t42 * t45
  t47 = 6 ** (0.1e1 / 0.3e1)
  t48 = jnp.pi ** 2
  t49 = t48 ** (0.1e1 / 0.3e1)
  t50 = t49 ** 2
  t51 = 0.1e1 / t50
  t52 = t47 * t51
  t53 = r0 ** 2
  t54 = r0 ** (0.1e1 / 0.3e1)
  t55 = t54 ** 2
  t57 = 0.1e1 / t55 / t53
  t58 = s0 * t57
  t59 = t52 * t58
  t61 = t47 ** 2
  t64 = t61 / t49 / t48
  t65 = s0 ** 2
  t66 = t53 ** 2
  t73 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t59 + 0.26899490462262948000000000000000000000000000000000e-2 * t64 * t65 / t54 / t66 / r0
  t74 = t73 ** (0.1e1 / 0.5e1)
  t79 = tau0 / t55 / r0
  t82 = 0.25633760400000000000000000000000000000000000000000e0 * t61 * t50
  t88 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t59 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t79 + t82 + 0.11867481666666666666666666666666666666666666666667e-1 * t58) * t47 * t51
  t89 = t74 ** 2
  t90 = 0.1e1 / t89
  t93 = 0.1e1 / t74 + 0.7e1 / 0.9e1 * t88 * t90
  t95 = 0.1e1 - t46
  t98 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t59) * t47
  t99 = t51 * s0
  t109 = (t79 - t58 / 0.8e1) * t47 * t51 / 0.4e1 - 0.9e1 / 0.20e2 + t59 / 0.36e2
  t110 = t109 ** 2
  t112 = t109 * t38
  t113 = 0.1e1 - t38
  t116 = 0.1e1 + 0.5e1 / 0.12e2 * t98 * t99 * t57 + 0.292e3 / 0.405e3 * t110 - 0.146e3 / 0.135e3 * t112 * t113
  t117 = t116 ** (0.1e1 / 0.10e2)
  t119 = t95 * t117 + t46 * t93
  t123 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t124 = t123 * f.p.zeta_threshold
  t126 = f.my_piecewise3(t20, t124, t21 * t19)
  t127 = t30 ** 2
  t128 = 0.1e1 / t127
  t129 = t126 * t128
  t132 = t5 * t129 * t119 / 0.8e1
  t133 = t126 * t30
  t138 = f.my_piecewise3(t37, -s0 / t53 * t34 / 0.8e1, 0)
  t141 = t39 * t138
  t143 = 0.2e1 * t38 * t138 + 0.9e1 * t141
  t144 = t143 * t45
  t147 = 0.1e1 / t44 / t43
  t148 = t42 * t147
  t149 = t93 * t39
  t150 = t149 * t138
  t154 = 0.1e1 / t74 / t73
  t155 = t53 * r0
  t157 = 0.1e1 / t55 / t155
  t158 = s0 * t157
  t159 = t52 * t158
  t165 = t64 * t65 / t54 / t66 / t53
  t167 = -0.40121303703703703703703703703703703703703703703704e0 * t159 - 0.14346394913206905600000000000000000000000000000000e-1 * t165
  t171 = tau0 * t57
  t178 = -0.17051554074074074074074074074074074074074074074074e0 * t159 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t171 - 0.31646617777777777777777777777777777777777777777779e-1 * t158) * t47 * t51
  t182 = 0.1e1 / t89 / t73
  t183 = t88 * t182
  t186 = -t154 * t167 / 0.5e1 + 0.7e1 / 0.9e1 * t178 * t90 - 0.14e2 / 0.45e2 * t183 * t167
  t190 = 0.6e1 * t148 * t141 - t144
  t192 = t117 ** 2
  t193 = t192 ** 2
  t194 = t193 ** 2
  t195 = t194 * t117
  t196 = 0.1e1 / t195
  t197 = t95 * t196
  t209 = (-0.5e1 / 0.3e1 * t171 + t158 / 0.3e1) * t47 * t51 / 0.4e1 - 0.2e1 / 0.27e2 * t159
  t212 = t209 * t38
  t220 = -0.125e3 / 0.39366e5 * t165 - 0.10e2 / 0.9e1 * t98 * t99 * t157 + 0.584e3 / 0.405e3 * t109 * t209 - 0.146e3 / 0.135e3 * t212 * t113 - 0.146e3 / 0.135e3 * t109 * t138 * t113 + 0.146e3 / 0.135e3 * t112 * t138
  t223 = t144 * t93 - 0.6e1 * t148 * t150 + t46 * t186 + t190 * t117 + t197 * t220 / 0.10e2
  t228 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t119 - t132 - 0.3e1 / 0.8e1 * t5 * t133 * t223)
  t230 = r1 <= f.p.dens_threshold
  t231 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t232 = 0.1e1 + t231
  t233 = t232 <= f.p.zeta_threshold
  t234 = t232 ** (0.1e1 / 0.3e1)
  t236 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t239 = f.my_piecewise3(t233, 0, 0.4e1 / 0.3e1 * t234 * t236)
  t240 = t239 * t30
  t243 = 0.1e1 / tau1
  t245 = s2 / r1 * t243 / 0.8e1
  t246 = t245 < 0.10e1
  t247 = f.my_piecewise3(t246, t245, 0.10e1)
  t248 = t247 ** 2
  t249 = t248 * t247
  t251 = t248 + 0.3e1 * t249
  t252 = 0.1e1 + t249
  t253 = t252 ** 2
  t254 = 0.1e1 / t253
  t255 = t251 * t254
  t256 = r1 ** 2
  t257 = r1 ** (0.1e1 / 0.3e1)
  t258 = t257 ** 2
  t260 = 0.1e1 / t258 / t256
  t261 = s2 * t260
  t262 = t52 * t261
  t264 = s2 ** 2
  t265 = t256 ** 2
  t272 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t262 + 0.26899490462262948000000000000000000000000000000000e-2 * t64 * t264 / t257 / t265 / r1
  t273 = t272 ** (0.1e1 / 0.5e1)
  t278 = tau1 / t258 / r1
  t285 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t262 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t278 + t82 + 0.11867481666666666666666666666666666666666666666667e-1 * t261) * t47 * t51
  t286 = t273 ** 2
  t287 = 0.1e1 / t286
  t290 = 0.1e1 / t273 + 0.7e1 / 0.9e1 * t285 * t287
  t292 = 0.1e1 - t255
  t295 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t262) * t47
  t296 = t51 * s2
  t306 = (t278 - t261 / 0.8e1) * t47 * t51 / 0.4e1 - 0.9e1 / 0.20e2 + t262 / 0.36e2
  t307 = t306 ** 2
  t309 = t306 * t247
  t310 = 0.1e1 - t247
  t313 = 0.1e1 + 0.5e1 / 0.12e2 * t295 * t296 * t260 + 0.292e3 / 0.405e3 * t307 - 0.146e3 / 0.135e3 * t309 * t310
  t314 = t313 ** (0.1e1 / 0.10e2)
  t316 = t255 * t290 + t292 * t314
  t321 = f.my_piecewise3(t233, t124, t234 * t232)
  t322 = t321 * t128
  t325 = t5 * t322 * t316 / 0.8e1
  t327 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t240 * t316 - t325)
  t329 = t21 ** 2
  t330 = 0.1e1 / t329
  t331 = t26 ** 2
  t336 = t16 / t22 / t6
  t338 = -0.2e1 * t23 + 0.2e1 * t336
  t339 = f.my_piecewise5(t10, 0, t14, 0, t338)
  t343 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t330 * t331 + 0.4e1 / 0.3e1 * t21 * t339)
  t350 = t5 * t29 * t128 * t119
  t356 = 0.1e1 / t127 / t6
  t360 = t5 * t126 * t356 * t119 / 0.12e2
  t362 = t5 * t129 * t223
  t364 = t138 ** 2
  t370 = f.my_piecewise3(t37, s0 / t155 * t34 / 0.4e1, 0)
  t373 = t38 * t364
  t375 = t39 * t370
  t378 = (0.2e1 * t38 * t370 + 0.2e1 * t364 + 0.18e2 * t373 + 0.9e1 * t375) * t45
  t380 = t143 * t147
  t385 = t44 ** 2
  t387 = t42 / t385
  t388 = t39 ** 2
  t404 = t73 ** 2
  t407 = t167 ** 2
  t411 = 0.1e1 / t55 / t66
  t412 = s0 * t411
  t413 = t52 * t412
  t419 = t64 * t65 / t54 / t66 / t155
  t421 = 0.14711144691358024691358024691358024691358024691358e1 * t413 + 0.90860501116977068800000000000000000000000000000000e-1 * t419
  t425 = tau0 * t157
  t464 = t220 ** 2
  t471 = t209 ** 2
  t480 = (0.40e2 / 0.9e1 * t425 - 0.11e2 / 0.9e1 * t412) * t47 * t51 / 0.4e1 + 0.22e2 / 0.81e2 * t413
  t501 = t378 * t93 - 0.12e2 * t380 * t150 + 0.2e1 * t144 * t186 + 0.54e2 * t387 * t93 * t388 * t364 - 0.12e2 * t148 * t186 * t39 * t138 - 0.12e2 * t148 * t93 * t38 * t364 - 0.6e1 * t148 * t149 * t370 + t46 * (0.6e1 / 0.25e2 / t74 / t404 * t407 - t154 * t421 / 0.5e1 + 0.7e1 / 0.9e1 * (0.62522364938271604938271604938271604938271604938271e0 * t413 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t425 + 0.11603759851851851851851851851851851851851851851852e0 * t412) * t47 * t51) * t90 - 0.28e2 / 0.45e2 * t178 * t182 * t167 + 0.98e2 / 0.225e3 * t88 / t89 / t404 * t407 - 0.14e2 / 0.45e2 * t183 * t421) + (-0.54e2 * t387 * t388 * t364 + 0.12e2 * t380 * t141 + 0.12e2 * t148 * t373 + 0.6e1 * t148 * t375 - t378) * t117 + t190 * t196 * t220 / 0.5e1 - 0.9e1 / 0.100e3 * t95 / t195 / t116 * t464 + t197 * (0.125e3 / 0.4374e4 * t419 + 0.110e3 / 0.27e2 * t98 * t99 * t411 + 0.584e3 / 0.405e3 * t471 + 0.584e3 / 0.405e3 * t109 * t480 - 0.146e3 / 0.135e3 * t480 * t38 * t113 - 0.292e3 / 0.135e3 * t209 * t138 * t113 + 0.292e3 / 0.135e3 * t212 * t138 - 0.146e3 / 0.135e3 * t109 * t370 * t113 + 0.292e3 / 0.135e3 * t109 * t364 + 0.146e3 / 0.135e3 * t112 * t370) / 0.10e2
  t506 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t343 * t30 * t119 - t350 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t223 + t360 - t362 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t133 * t501)
  t507 = t234 ** 2
  t508 = 0.1e1 / t507
  t509 = t236 ** 2
  t513 = f.my_piecewise5(t14, 0, t10, 0, -t338)
  t517 = f.my_piecewise3(t233, 0, 0.4e1 / 0.9e1 * t508 * t509 + 0.4e1 / 0.3e1 * t234 * t513)
  t524 = t5 * t239 * t128 * t316
  t529 = t5 * t321 * t356 * t316 / 0.12e2
  t531 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t517 * t30 * t316 - t524 / 0.4e1 + t529)
  d11 = 0.2e1 * t228 + 0.2e1 * t327 + t6 * (t506 + t531)
  t534 = -t7 - t24
  t535 = f.my_piecewise5(t10, 0, t14, 0, t534)
  t538 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t535)
  t539 = t538 * t30
  t544 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t539 * t119 - t132)
  t546 = f.my_piecewise5(t14, 0, t10, 0, -t534)
  t549 = f.my_piecewise3(t233, 0, 0.4e1 / 0.3e1 * t234 * t546)
  t550 = t549 * t30
  t554 = t321 * t30
  t559 = f.my_piecewise3(t246, -s2 / t256 * t243 / 0.8e1, 0)
  t562 = t248 * t559
  t564 = 0.2e1 * t247 * t559 + 0.9e1 * t562
  t565 = t564 * t254
  t568 = 0.1e1 / t253 / t252
  t569 = t251 * t568
  t570 = t290 * t248
  t571 = t570 * t559
  t575 = 0.1e1 / t273 / t272
  t576 = t256 * r1
  t578 = 0.1e1 / t258 / t576
  t579 = s2 * t578
  t580 = t52 * t579
  t586 = t64 * t264 / t257 / t265 / t256
  t588 = -0.40121303703703703703703703703703703703703703703704e0 * t580 - 0.14346394913206905600000000000000000000000000000000e-1 * t586
  t592 = tau1 * t260
  t599 = -0.17051554074074074074074074074074074074074074074074e0 * t580 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t592 - 0.31646617777777777777777777777777777777777777777779e-1 * t579) * t47 * t51
  t603 = 0.1e1 / t286 / t272
  t604 = t285 * t603
  t607 = -t575 * t588 / 0.5e1 + 0.7e1 / 0.9e1 * t599 * t287 - 0.14e2 / 0.45e2 * t604 * t588
  t611 = 0.6e1 * t569 * t562 - t565
  t613 = t314 ** 2
  t614 = t613 ** 2
  t615 = t614 ** 2
  t616 = t615 * t314
  t617 = 0.1e1 / t616
  t618 = t292 * t617
  t630 = (-0.5e1 / 0.3e1 * t592 + t579 / 0.3e1) * t47 * t51 / 0.4e1 - 0.2e1 / 0.27e2 * t580
  t633 = t630 * t247
  t641 = -0.125e3 / 0.39366e5 * t586 - 0.10e2 / 0.9e1 * t295 * t296 * t578 + 0.584e3 / 0.405e3 * t306 * t630 - 0.146e3 / 0.135e3 * t633 * t310 - 0.146e3 / 0.135e3 * t306 * t559 * t310 + 0.146e3 / 0.135e3 * t309 * t559
  t644 = t565 * t290 - 0.6e1 * t569 * t571 + t255 * t607 + t611 * t314 + t618 * t641 / 0.10e2
  t649 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t550 * t316 - t325 - 0.3e1 / 0.8e1 * t5 * t554 * t644)
  t653 = 0.2e1 * t336
  t654 = f.my_piecewise5(t10, 0, t14, 0, t653)
  t658 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t330 * t535 * t26 + 0.4e1 / 0.3e1 * t21 * t654)
  t665 = t5 * t538 * t128 * t119
  t673 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t658 * t30 * t119 - t665 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t539 * t223 - t350 / 0.8e1 + t360 - t362 / 0.8e1)
  t677 = f.my_piecewise5(t14, 0, t10, 0, -t653)
  t681 = f.my_piecewise3(t233, 0, 0.4e1 / 0.9e1 * t508 * t546 * t236 + 0.4e1 / 0.3e1 * t234 * t677)
  t688 = t5 * t549 * t128 * t316
  t695 = t5 * t322 * t644
  t698 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t681 * t30 * t316 - t688 / 0.8e1 - t524 / 0.8e1 + t529 - 0.3e1 / 0.8e1 * t5 * t240 * t644 - t695 / 0.8e1)
  d12 = t228 + t327 + t544 + t649 + t6 * (t673 + t698)
  t703 = t535 ** 2
  t707 = 0.2e1 * t23 + 0.2e1 * t336
  t708 = f.my_piecewise5(t10, 0, t14, 0, t707)
  t712 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t330 * t703 + 0.4e1 / 0.3e1 * t21 * t708)
  t719 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t712 * t30 * t119 - t665 / 0.4e1 + t360)
  t720 = t546 ** 2
  t724 = f.my_piecewise5(t14, 0, t10, 0, -t707)
  t728 = f.my_piecewise3(t233, 0, 0.4e1 / 0.9e1 * t508 * t720 + 0.4e1 / 0.3e1 * t234 * t724)
  t738 = t559 ** 2
  t744 = f.my_piecewise3(t246, s2 / t576 * t243 / 0.4e1, 0)
  t747 = t247 * t738
  t749 = t248 * t744
  t752 = (0.2e1 * t247 * t744 + 0.2e1 * t738 + 0.18e2 * t747 + 0.9e1 * t749) * t254
  t754 = t564 * t568
  t759 = t253 ** 2
  t761 = t251 / t759
  t762 = t248 ** 2
  t778 = t272 ** 2
  t781 = t588 ** 2
  t785 = 0.1e1 / t258 / t265
  t786 = s2 * t785
  t787 = t52 * t786
  t793 = t64 * t264 / t257 / t265 / t576
  t795 = 0.14711144691358024691358024691358024691358024691358e1 * t787 + 0.90860501116977068800000000000000000000000000000000e-1 * t793
  t799 = tau1 * t578
  t838 = t641 ** 2
  t845 = t630 ** 2
  t854 = (0.40e2 / 0.9e1 * t799 - 0.11e2 / 0.9e1 * t786) * t47 * t51 / 0.4e1 + 0.22e2 / 0.81e2 * t787
  t875 = t752 * t290 - 0.12e2 * t754 * t571 + 0.2e1 * t565 * t607 + 0.54e2 * t761 * t290 * t762 * t738 - 0.12e2 * t569 * t607 * t248 * t559 - 0.12e2 * t569 * t290 * t247 * t738 - 0.6e1 * t569 * t570 * t744 + t255 * (0.6e1 / 0.25e2 / t273 / t778 * t781 - t575 * t795 / 0.5e1 + 0.7e1 / 0.9e1 * (0.62522364938271604938271604938271604938271604938271e0 * t787 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t799 + 0.11603759851851851851851851851851851851851851851852e0 * t786) * t47 * t51) * t287 - 0.28e2 / 0.45e2 * t599 * t603 * t588 + 0.98e2 / 0.225e3 * t285 / t286 / t778 * t781 - 0.14e2 / 0.45e2 * t604 * t795) + (-0.54e2 * t761 * t762 * t738 + 0.12e2 * t754 * t562 + 0.12e2 * t569 * t747 + 0.6e1 * t569 * t749 - t752) * t314 + t611 * t617 * t641 / 0.5e1 - 0.9e1 / 0.100e3 * t292 / t616 / t313 * t838 + t618 * (0.125e3 / 0.4374e4 * t793 + 0.110e3 / 0.27e2 * t295 * t296 * t785 + 0.584e3 / 0.405e3 * t845 + 0.584e3 / 0.405e3 * t306 * t854 - 0.146e3 / 0.135e3 * t854 * t247 * t310 - 0.292e3 / 0.135e3 * t630 * t559 * t310 + 0.292e3 / 0.135e3 * t633 * t559 - 0.146e3 / 0.135e3 * t306 * t744 * t310 + 0.292e3 / 0.135e3 * t306 * t738 + 0.146e3 / 0.135e3 * t309 * t744) / 0.10e2
  t880 = f.my_piecewise3(t230, 0, -0.3e1 / 0.8e1 * t5 * t728 * t30 * t316 - t688 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t550 * t644 + t529 - t695 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t554 * t875)
  d22 = 0.2e1 * t544 + 0.2e1 * t649 + t6 * (t719 + t880)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t46 = 0.1e1 / tau0
  t48 = s0 / r0 * t46 / 0.8e1
  t49 = t48 < 0.10e1
  t50 = f.my_piecewise3(t49, t48, 0.10e1)
  t51 = t50 ** 2
  t52 = t51 * t50
  t54 = t51 + 0.3e1 * t52
  t55 = 0.1e1 + t52
  t56 = t55 ** 2
  t57 = 0.1e1 / t56
  t58 = t54 * t57
  t59 = 6 ** (0.1e1 / 0.3e1)
  t60 = jnp.pi ** 2
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t63 = 0.1e1 / t62
  t64 = t59 * t63
  t65 = r0 ** 2
  t66 = r0 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t69 = 0.1e1 / t67 / t65
  t70 = s0 * t69
  t71 = t64 * t70
  t73 = t59 ** 2
  t76 = t73 / t61 / t60
  t77 = s0 ** 2
  t78 = t65 ** 2
  t79 = t78 * r0
  t85 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t71 + 0.26899490462262948000000000000000000000000000000000e-2 * t76 * t77 / t66 / t79
  t86 = t85 ** (0.1e1 / 0.5e1)
  t91 = tau0 / t67 / r0
  t94 = 0.25633760400000000000000000000000000000000000000000e0 * t73 * t62
  t100 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t71 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t91 + t94 + 0.11867481666666666666666666666666666666666666666667e-1 * t70) * t59 * t63
  t101 = t86 ** 2
  t102 = 0.1e1 / t101
  t105 = 0.1e1 / t86 + 0.7e1 / 0.9e1 * t100 * t102
  t107 = 0.1e1 - t58
  t110 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t71) * t59
  t111 = t63 * s0
  t121 = (t91 - t70 / 0.8e1) * t59 * t63 / 0.4e1 - 0.9e1 / 0.20e2 + t71 / 0.36e2
  t122 = t121 ** 2
  t124 = t121 * t50
  t125 = 0.1e1 - t50
  t128 = 0.1e1 + 0.5e1 / 0.12e2 * t110 * t111 * t69 + 0.292e3 / 0.405e3 * t122 - 0.146e3 / 0.135e3 * t124 * t125
  t129 = t128 ** (0.1e1 / 0.10e2)
  t131 = t58 * t105 + t107 * t129
  t137 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t138 = t42 ** 2
  t139 = 0.1e1 / t138
  t140 = t137 * t139
  t144 = t137 * t42
  t149 = f.my_piecewise3(t49, -s0 / t65 * t46 / 0.8e1, 0)
  t150 = t50 * t149
  t152 = t51 * t149
  t154 = 0.2e1 * t150 + 0.9e1 * t152
  t155 = t154 * t57
  t158 = 0.1e1 / t56 / t55
  t159 = t54 * t158
  t160 = t105 * t51
  t161 = t160 * t149
  t165 = 0.1e1 / t86 / t85
  t166 = t65 * r0
  t168 = 0.1e1 / t67 / t166
  t169 = s0 * t168
  t170 = t64 * t169
  t176 = t76 * t77 / t66 / t78 / t65
  t178 = -0.40121303703703703703703703703703703703703703703704e0 * t170 - 0.14346394913206905600000000000000000000000000000000e-1 * t176
  t182 = tau0 * t69
  t189 = -0.17051554074074074074074074074074074074074074074074e0 * t170 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t182 - 0.31646617777777777777777777777777777777777777777779e-1 * t169) * t59 * t63
  t193 = 0.1e1 / t101 / t85
  t194 = t100 * t193
  t197 = -t165 * t178 / 0.5e1 + 0.7e1 / 0.9e1 * t189 * t102 - 0.14e2 / 0.45e2 * t194 * t178
  t201 = 0.6e1 * t159 * t152 - t155
  t203 = t129 ** 2
  t204 = t203 ** 2
  t205 = t204 ** 2
  t206 = t205 * t129
  t207 = 0.1e1 / t206
  t208 = t107 * t207
  t220 = (-0.5e1 / 0.3e1 * t182 + t169 / 0.3e1) * t59 * t63 / 0.4e1 - 0.2e1 / 0.27e2 * t170
  t223 = t220 * t50
  t231 = -0.125e3 / 0.39366e5 * t176 - 0.10e2 / 0.9e1 * t110 * t111 * t168 + 0.584e3 / 0.405e3 * t121 * t220 - 0.146e3 / 0.135e3 * t223 * t125 - 0.146e3 / 0.135e3 * t121 * t149 * t125 + 0.146e3 / 0.135e3 * t124 * t149
  t234 = t155 * t105 - 0.6e1 * t159 * t161 + t58 * t197 + t201 * t129 + t208 * t231 / 0.10e2
  t238 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t239 = t238 * f.p.zeta_threshold
  t241 = f.my_piecewise3(t20, t239, t21 * t19)
  t243 = 0.1e1 / t138 / t6
  t244 = t241 * t243
  t248 = t241 * t139
  t252 = t241 * t42
  t253 = t149 ** 2
  t259 = f.my_piecewise3(t49, s0 / t166 * t46 / 0.4e1, 0)
  t262 = t50 * t253
  t264 = t51 * t259
  t266 = 0.2e1 * t50 * t259 + 0.2e1 * t253 + 0.18e2 * t262 + 0.9e1 * t264
  t267 = t266 * t57
  t269 = t154 * t158
  t274 = t56 ** 2
  t275 = 0.1e1 / t274
  t276 = t54 * t275
  t277 = t51 ** 2
  t279 = t105 * t277 * t253
  t282 = t197 * t51
  t283 = t282 * t149
  t287 = t105 * t50 * t253
  t290 = t160 * t259
  t293 = t85 ** 2
  t295 = 0.1e1 / t86 / t293
  t296 = t178 ** 2
  t300 = 0.1e1 / t67 / t78
  t301 = s0 * t300
  t302 = t64 * t301
  t308 = t76 * t77 / t66 / t78 / t166
  t310 = 0.14711144691358024691358024691358024691358024691358e1 * t302 + 0.90860501116977068800000000000000000000000000000000e-1 * t308
  t314 = tau0 * t168
  t321 = 0.62522364938271604938271604938271604938271604938271e0 * t302 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t314 + 0.11603759851851851851851851851851851851851851851852e0 * t301) * t59 * t63
  t324 = t189 * t193
  t328 = 0.1e1 / t101 / t293
  t329 = t100 * t328
  t334 = 0.6e1 / 0.25e2 * t295 * t296 - t165 * t310 / 0.5e1 + 0.7e1 / 0.9e1 * t321 * t102 - 0.28e2 / 0.45e2 * t324 * t178 + 0.98e2 / 0.225e3 * t329 * t296 - 0.14e2 / 0.45e2 * t194 * t310
  t338 = t277 * t253
  t345 = 0.12e2 * t269 * t152 + 0.12e2 * t159 * t262 + 0.6e1 * t159 * t264 - 0.54e2 * t276 * t338 - t267
  t347 = t201 * t207
  t351 = 0.1e1 / t206 / t128
  t352 = t107 * t351
  t353 = t231 ** 2
  t360 = t220 ** 2
  t369 = (0.40e2 / 0.9e1 * t314 - 0.11e2 / 0.9e1 * t301) * t59 * t63 / 0.4e1 + 0.22e2 / 0.81e2 * t302
  t372 = t369 * t50
  t380 = t121 * t259
  t387 = 0.125e3 / 0.4374e4 * t308 + 0.110e3 / 0.27e2 * t110 * t111 * t300 + 0.584e3 / 0.405e3 * t360 + 0.584e3 / 0.405e3 * t121 * t369 - 0.146e3 / 0.135e3 * t372 * t125 - 0.292e3 / 0.135e3 * t220 * t149 * t125 + 0.292e3 / 0.135e3 * t223 * t149 - 0.146e3 / 0.135e3 * t380 * t125 + 0.292e3 / 0.135e3 * t121 * t253 + 0.146e3 / 0.135e3 * t124 * t259
  t390 = t267 * t105 - 0.12e2 * t269 * t161 + 0.2e1 * t155 * t197 + 0.54e2 * t276 * t279 - 0.12e2 * t159 * t283 - 0.12e2 * t159 * t287 - 0.6e1 * t159 * t290 + t58 * t334 + t345 * t129 + t347 * t231 / 0.5e1 - 0.9e1 / 0.100e3 * t352 * t353 + t208 * t387 / 0.10e2
  t395 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t131 - t5 * t140 * t131 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t144 * t234 + t5 * t244 * t131 / 0.12e2 - t5 * t248 * t234 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t252 * t390)
  t397 = r1 <= f.p.dens_threshold
  t398 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t399 = 0.1e1 + t398
  t400 = t399 <= f.p.zeta_threshold
  t401 = t399 ** (0.1e1 / 0.3e1)
  t402 = t401 ** 2
  t403 = 0.1e1 / t402
  t405 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t406 = t405 ** 2
  t410 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t414 = f.my_piecewise3(t400, 0, 0.4e1 / 0.9e1 * t403 * t406 + 0.4e1 / 0.3e1 * t401 * t410)
  t420 = s2 / r1 / tau1 / 0.8e1
  t422 = f.my_piecewise3(t420 < 0.10e1, t420, 0.10e1)
  t423 = t422 ** 2
  t424 = t423 * t422
  t428 = (0.1e1 + t424) ** 2
  t430 = (t423 + 0.3e1 * t424) / t428
  t431 = r1 ** 2
  t432 = r1 ** (0.1e1 / 0.3e1)
  t433 = t432 ** 2
  t435 = 0.1e1 / t433 / t431
  t436 = s2 * t435
  t437 = t64 * t436
  t439 = s2 ** 2
  t440 = t431 ** 2
  t448 = (0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t437 + 0.26899490462262948000000000000000000000000000000000e-2 * t76 * t439 / t432 / t440 / r1) ** (0.1e1 / 0.5e1)
  t453 = tau1 / t433 / r1
  t461 = t448 ** 2
  t481 = (t453 - t436 / 0.8e1) * t59 * t63 / 0.4e1 - 0.9e1 / 0.20e2 + t437 / 0.36e2
  t482 = t481 ** 2
  t489 = (0.1e1 + 0.5e1 / 0.12e2 * (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t437) * t59 * t63 * s2 * t435 + 0.292e3 / 0.405e3 * t482 - 0.146e3 / 0.135e3 * t481 * t422 * (0.1e1 - t422)) ** (0.1e1 / 0.10e2)
  t491 = t430 * (0.1e1 / t448 + 0.7e1 / 0.9e1 * (0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t437 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t453 + t94 + 0.11867481666666666666666666666666666666666666666667e-1 * t436) * t59 * t63) / t461) + (0.1e1 - t430) * t489
  t497 = f.my_piecewise3(t400, 0, 0.4e1 / 0.3e1 * t401 * t405)
  t503 = f.my_piecewise3(t400, t239, t401 * t399)
  t509 = f.my_piecewise3(t397, 0, -0.3e1 / 0.8e1 * t5 * t414 * t42 * t491 - t5 * t497 * t139 * t491 / 0.4e1 + t5 * t503 * t243 * t491 / 0.12e2)
  t519 = t24 ** 2
  t523 = 0.6e1 * t33 - 0.6e1 * t16 / t519
  t524 = f.my_piecewise5(t10, 0, t14, 0, t523)
  t528 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t524)
  t551 = 0.1e1 / t138 / t24
  t568 = f.my_piecewise3(t49, -0.3e1 / 0.4e1 * s0 / t78 * t46, 0)
  t571 = t253 * t149
  t573 = t150 * t259
  t575 = t51 * t568
  t578 = (0.6e1 * t149 * t259 + 0.2e1 * t50 * t568 + 0.18e2 * t571 + 0.54e2 * t573 + 0.9e1 * t575) * t57
  t579 = t266 * t158
  t582 = t154 * t275
  t591 = t54 / t274 / t55
  t592 = t277 * t51
  t600 = t277 * t149 * t259
  t609 = -0.324e3 * t276 * t52 * t571 + 0.648e3 * t591 * t592 * t571 + 0.18e2 * t579 * t152 + 0.12e2 * t159 * t571 + 0.36e2 * t159 * t573 + 0.6e1 * t159 * t575 + 0.36e2 * t269 * t262 + 0.18e2 * t269 * t264 - 0.162e3 * t276 * t600 - 0.162e3 * t582 * t338 - t578
  t648 = t609 * t129 - 0.12e2 * t159 * t105 * t571 - 0.27e2 / 0.100e3 * t352 * t231 * t387 - 0.36e2 * t269 * t287 + 0.324e3 * t276 * t105 * t52 * t571 - 0.36e2 * t159 * t197 * t50 * t253 - 0.36e2 * t269 * t283 - 0.18e2 * t269 * t290 + 0.162e3 * t582 * t279 + 0.162e3 * t276 * t197 * t277 * t253 - 0.648e3 * t591 * t105 * t592 * t571 - 0.18e2 * t159 * t334 * t51 * t149 - 0.18e2 * t159 * t282 * t259
  t654 = t128 ** 2
  t671 = t293 * t85
  t674 = t296 * t178
  t681 = 0.1e1 / t67 / t79
  t682 = s0 * t681
  t683 = t64 * t682
  t685 = t78 ** 2
  t689 = t76 * t77 / t66 / t685
  t691 = -0.68652008559670781893004115226337448559670781893004e1 * t683 - 0.66631034152449850453333333333333333333333333333333e0 * t689
  t695 = tau0 * t300
  t738 = (-0.440e3 / 0.27e2 * t695 + 0.154e3 / 0.27e2 * t682) * t59 * t63 / 0.4e1 - 0.308e3 / 0.243e3 * t683
  t763 = -0.42625e5 / 0.177147e6 * t689 - 0.1540e4 / 0.81e2 * t110 * t111 * t681 + 0.584e3 / 0.135e3 * t220 * t369 + 0.584e3 / 0.405e3 * t121 * t738 - 0.146e3 / 0.135e3 * t738 * t50 * t125 - 0.146e3 / 0.45e2 * t369 * t149 * t125 + 0.146e3 / 0.45e2 * t372 * t149 - 0.146e3 / 0.45e2 * t220 * t259 * t125 + 0.292e3 / 0.45e2 * t220 * t253 + 0.146e3 / 0.45e2 * t223 * t259 - 0.146e3 / 0.135e3 * t121 * t568 * t125 + 0.292e3 / 0.45e2 * t380 * t149 + 0.146e3 / 0.135e3 * t124 * t568
  t775 = -0.6e1 * t159 * t160 * t568 - 0.18e2 * t579 * t161 + 0.171e3 / 0.1000e4 * t107 / t206 / t654 * t353 * t231 - 0.27e2 / 0.100e3 * t201 * t351 * t353 + 0.3e1 * t155 * t334 + t578 * t105 + 0.3e1 * t267 * t197 + 0.3e1 / 0.10e2 * t347 * t387 + t58 * (-0.66e2 / 0.125e3 / t86 / t671 * t674 + 0.18e2 / 0.25e2 * t295 * t178 * t310 - t165 * t691 / 0.5e1 + 0.7e1 / 0.9e1 * (-0.29177103637860082304526748971193415637860082304526e1 * t683 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t695 - 0.54150879308641975308641975308641975308641975308643e0 * t682) * t59 * t63) * t102 - 0.14e2 / 0.15e2 * t321 * t193 * t178 + 0.98e2 / 0.75e2 * t189 * t328 * t296 - 0.14e2 / 0.15e2 * t324 * t310 - 0.392e3 / 0.375e3 * t100 / t101 / t671 * t674 + 0.98e2 / 0.75e2 * t329 * t178 * t310 - 0.14e2 / 0.45e2 * t194 * t691) + t208 * t763 / 0.10e2 + 0.3e1 / 0.10e2 * t345 * t207 * t231 + 0.162e3 * t276 * t105 * t600 - 0.36e2 * t159 * t105 * t573
  t781 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t528 * t42 * t131 - 0.3e1 / 0.8e1 * t5 * t41 * t139 * t131 - 0.9e1 / 0.8e1 * t5 * t43 * t234 + t5 * t137 * t243 * t131 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t140 * t234 - 0.9e1 / 0.8e1 * t5 * t144 * t390 - 0.5e1 / 0.36e2 * t5 * t241 * t551 * t131 + t5 * t244 * t234 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t248 * t390 - 0.3e1 / 0.8e1 * t5 * t252 * (t648 + t775))
  t791 = f.my_piecewise5(t14, 0, t10, 0, -t523)
  t795 = f.my_piecewise3(t400, 0, -0.8e1 / 0.27e2 / t402 / t399 * t406 * t405 + 0.4e1 / 0.3e1 * t403 * t405 * t410 + 0.4e1 / 0.3e1 * t401 * t791)
  t813 = f.my_piecewise3(t397, 0, -0.3e1 / 0.8e1 * t5 * t795 * t42 * t491 - 0.3e1 / 0.8e1 * t5 * t414 * t139 * t491 + t5 * t497 * t243 * t491 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t503 * t551 * t491)
  d111 = 0.3e1 * t395 + 0.3e1 * t509 + t6 * (t781 + t813)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t58 = 0.1e1 / tau0
  t60 = s0 / r0 * t58 / 0.8e1
  t61 = t60 < 0.10e1
  t62 = f.my_piecewise3(t61, t60, 0.10e1)
  t63 = t62 ** 2
  t64 = t63 * t62
  t66 = t63 + 0.3e1 * t64
  t67 = 0.1e1 + t64
  t68 = t67 ** 2
  t69 = 0.1e1 / t68
  t70 = t66 * t69
  t71 = 6 ** (0.1e1 / 0.3e1)
  t72 = jnp.pi ** 2
  t73 = t72 ** (0.1e1 / 0.3e1)
  t74 = t73 ** 2
  t75 = 0.1e1 / t74
  t76 = t71 * t75
  t77 = r0 ** 2
  t78 = r0 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / t77
  t82 = s0 * t81
  t83 = t76 * t82
  t85 = t71 ** 2
  t88 = t85 / t73 / t72
  t89 = s0 ** 2
  t90 = t77 ** 2
  t91 = t90 * r0
  t97 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t83 + 0.26899490462262948000000000000000000000000000000000e-2 * t88 * t89 / t78 / t91
  t98 = t97 ** (0.1e1 / 0.5e1)
  t103 = tau0 / t79 / r0
  t106 = 0.25633760400000000000000000000000000000000000000000e0 * t85 * t74
  t112 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t83 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t103 + t106 + 0.11867481666666666666666666666666666666666666666667e-1 * t82) * t71 * t75
  t113 = t98 ** 2
  t114 = 0.1e1 / t113
  t117 = 0.1e1 / t98 + 0.7e1 / 0.9e1 * t112 * t114
  t119 = 0.1e1 - t70
  t122 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t83) * t71
  t123 = t75 * s0
  t133 = (t103 - t82 / 0.8e1) * t71 * t75 / 0.4e1 - 0.9e1 / 0.20e2 + t83 / 0.36e2
  t134 = t133 ** 2
  t136 = t133 * t62
  t137 = 0.1e1 - t62
  t140 = 0.1e1 + 0.5e1 / 0.12e2 * t122 * t123 * t81 + 0.292e3 / 0.405e3 * t134 - 0.146e3 / 0.135e3 * t136 * t137
  t141 = t140 ** (0.1e1 / 0.10e2)
  t143 = t70 * t117 + t119 * t141
  t152 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t153 = t54 ** 2
  t154 = 0.1e1 / t153
  t155 = t152 * t154
  t159 = t152 * t54
  t164 = f.my_piecewise3(t61, -s0 / t77 * t58 / 0.8e1, 0)
  t165 = t62 * t164
  t167 = t63 * t164
  t169 = 0.2e1 * t165 + 0.9e1 * t167
  t170 = t169 * t69
  t173 = 0.1e1 / t68 / t67
  t174 = t66 * t173
  t175 = t117 * t63
  t176 = t175 * t164
  t180 = 0.1e1 / t98 / t97
  t181 = t77 * r0
  t183 = 0.1e1 / t79 / t181
  t184 = s0 * t183
  t185 = t76 * t184
  t187 = t90 * t77
  t191 = t88 * t89 / t78 / t187
  t193 = -0.40121303703703703703703703703703703703703703703704e0 * t185 - 0.14346394913206905600000000000000000000000000000000e-1 * t191
  t197 = tau0 * t81
  t204 = -0.17051554074074074074074074074074074074074074074074e0 * t185 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t197 - 0.31646617777777777777777777777777777777777777777779e-1 * t184) * t71 * t75
  t208 = 0.1e1 / t113 / t97
  t209 = t112 * t208
  t212 = -t180 * t193 / 0.5e1 + 0.7e1 / 0.9e1 * t204 * t114 - 0.14e2 / 0.45e2 * t209 * t193
  t216 = 0.6e1 * t174 * t167 - t170
  t218 = t141 ** 2
  t219 = t218 ** 2
  t220 = t219 ** 2
  t221 = t220 * t141
  t222 = 0.1e1 / t221
  t223 = t119 * t222
  t235 = (-0.5e1 / 0.3e1 * t197 + t184 / 0.3e1) * t71 * t75 / 0.4e1 - 0.2e1 / 0.27e2 * t185
  t238 = t235 * t62
  t246 = -0.125e3 / 0.39366e5 * t191 - 0.10e2 / 0.9e1 * t122 * t123 * t183 + 0.584e3 / 0.405e3 * t133 * t235 - 0.146e3 / 0.135e3 * t238 * t137 - 0.146e3 / 0.135e3 * t133 * t164 * t137 + 0.146e3 / 0.135e3 * t136 * t164
  t249 = t170 * t117 - 0.6e1 * t174 * t176 + t70 * t212 + t216 * t141 + t223 * t246 / 0.10e2
  t255 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t257 = 0.1e1 / t153 / t6
  t258 = t255 * t257
  t262 = t255 * t154
  t266 = t255 * t54
  t267 = t164 ** 2
  t273 = f.my_piecewise3(t61, s0 / t181 * t58 / 0.4e1, 0)
  t276 = t62 * t267
  t278 = t63 * t273
  t280 = 0.2e1 * t62 * t273 + 0.2e1 * t267 + 0.18e2 * t276 + 0.9e1 * t278
  t281 = t280 * t69
  t283 = t169 * t173
  t288 = t68 ** 2
  t289 = 0.1e1 / t288
  t290 = t66 * t289
  t291 = t63 ** 2
  t292 = t117 * t291
  t293 = t292 * t267
  t296 = t212 * t63
  t297 = t296 * t164
  t300 = t117 * t62
  t301 = t300 * t267
  t304 = t175 * t273
  t307 = t97 ** 2
  t309 = 0.1e1 / t98 / t307
  t310 = t193 ** 2
  t314 = 0.1e1 / t79 / t90
  t315 = s0 * t314
  t316 = t76 * t315
  t322 = t88 * t89 / t78 / t90 / t181
  t324 = 0.14711144691358024691358024691358024691358024691358e1 * t316 + 0.90860501116977068800000000000000000000000000000000e-1 * t322
  t328 = tau0 * t183
  t335 = 0.62522364938271604938271604938271604938271604938271e0 * t316 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t328 + 0.11603759851851851851851851851851851851851851851852e0 * t315) * t71 * t75
  t338 = t204 * t208
  t342 = 0.1e1 / t113 / t307
  t343 = t112 * t342
  t348 = 0.6e1 / 0.25e2 * t309 * t310 - t180 * t324 / 0.5e1 + 0.7e1 / 0.9e1 * t335 * t114 - 0.28e2 / 0.45e2 * t338 * t193 + 0.98e2 / 0.225e3 * t343 * t310 - 0.14e2 / 0.45e2 * t209 * t324
  t352 = t291 * t267
  t359 = 0.12e2 * t283 * t167 + 0.12e2 * t174 * t276 + 0.6e1 * t174 * t278 - 0.54e2 * t290 * t352 - t281
  t361 = t216 * t222
  t365 = 0.1e1 / t221 / t140
  t366 = t119 * t365
  t367 = t246 ** 2
  t374 = t235 ** 2
  t383 = (0.40e2 / 0.9e1 * t328 - 0.11e2 / 0.9e1 * t315) * t71 * t75 / 0.4e1 + 0.22e2 / 0.81e2 * t316
  t386 = t383 * t62
  t394 = t133 * t273
  t401 = 0.125e3 / 0.4374e4 * t322 + 0.110e3 / 0.27e2 * t122 * t123 * t314 + 0.584e3 / 0.405e3 * t374 + 0.584e3 / 0.405e3 * t133 * t383 - 0.146e3 / 0.135e3 * t386 * t137 - 0.292e3 / 0.135e3 * t235 * t164 * t137 + 0.292e3 / 0.135e3 * t238 * t164 - 0.146e3 / 0.135e3 * t394 * t137 + 0.292e3 / 0.135e3 * t133 * t267 + 0.146e3 / 0.135e3 * t136 * t273
  t404 = t281 * t117 - 0.12e2 * t283 * t176 + 0.2e1 * t170 * t212 + 0.54e2 * t290 * t293 - 0.12e2 * t174 * t297 - 0.12e2 * t174 * t301 - 0.6e1 * t174 * t304 + t70 * t348 + t359 * t141 + t361 * t246 / 0.5e1 - 0.9e1 / 0.100e3 * t366 * t367 + t223 * t401 / 0.10e2
  t408 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t409 = t408 * f.p.zeta_threshold
  t411 = f.my_piecewise3(t20, t409, t21 * t19)
  t413 = 0.1e1 / t153 / t25
  t414 = t411 * t413
  t418 = t411 * t257
  t422 = t411 * t154
  t426 = t411 * t54
  t433 = f.my_piecewise3(t61, -0.3e1 / 0.4e1 * s0 / t90 * t58, 0)
  t436 = t267 * t164
  t438 = t165 * t273
  t440 = t63 * t433
  t442 = 0.6e1 * t164 * t273 + 0.2e1 * t62 * t433 + 0.18e2 * t436 + 0.54e2 * t438 + 0.9e1 * t440
  t443 = t442 * t69
  t444 = t280 * t173
  t447 = t169 * t289
  t455 = 0.1e1 / t288 / t67
  t456 = t66 * t455
  t457 = t291 * t63
  t458 = t457 * t436
  t461 = t64 * t436
  t464 = t291 * t164
  t465 = t464 * t273
  t474 = 0.18e2 * t444 * t167 + 0.12e2 * t174 * t436 + 0.36e2 * t174 * t438 + 0.6e1 * t174 * t440 + 0.36e2 * t283 * t276 + 0.18e2 * t283 * t278 - 0.324e3 * t290 * t461 - 0.162e3 * t290 * t465 - 0.162e3 * t447 * t352 + 0.648e3 * t456 * t458 - t443
  t477 = t212 * t62 * t267
  t487 = t212 * t291 * t267
  t491 = t117 * t457 * t436
  t497 = t117 * t64 * t436
  t500 = t348 * t63
  t501 = t500 * t164
  t504 = t296 * t273
  t507 = t175 * t433
  t512 = t474 * t141 - 0.36e2 * t174 * t477 - 0.18e2 * t174 * t501 - 0.18e2 * t174 * t504 - 0.6e1 * t174 * t507 - 0.18e2 * t444 * t176 - 0.36e2 * t283 * t297 - 0.36e2 * t283 * t301 - 0.18e2 * t283 * t304 + 0.162e3 * t290 * t487 + 0.324e3 * t290 * t497 + 0.162e3 * t447 * t293 - 0.648e3 * t456 * t491
  t516 = t216 * t365
  t519 = t140 ** 2
  t521 = 0.1e1 / t221 / t519
  t522 = t119 * t521
  t523 = t367 * t246
  t526 = t307 * t97
  t528 = 0.1e1 / t98 / t526
  t529 = t310 * t193
  t532 = t309 * t193
  t536 = 0.1e1 / t79 / t91
  t537 = s0 * t536
  t538 = t76 * t537
  t540 = t90 ** 2
  t544 = t88 * t89 / t78 / t540
  t546 = -0.68652008559670781893004115226337448559670781893004e1 * t538 - 0.66631034152449850453333333333333333333333333333333e0 * t544
  t550 = tau0 * t314
  t557 = -0.29177103637860082304526748971193415637860082304526e1 * t538 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t550 - 0.54150879308641975308641975308641975308641975308643e0 * t537) * t71 * t75
  t560 = t335 * t208
  t563 = t204 * t342
  t569 = 0.1e1 / t113 / t526
  t570 = t112 * t569
  t573 = t193 * t324
  t578 = -0.66e2 / 0.125e3 * t528 * t529 + 0.18e2 / 0.25e2 * t532 * t324 - t180 * t546 / 0.5e1 + 0.7e1 / 0.9e1 * t557 * t114 - 0.14e2 / 0.15e2 * t560 * t193 + 0.98e2 / 0.75e2 * t563 * t310 - 0.14e2 / 0.15e2 * t338 * t324 - 0.392e3 / 0.375e3 * t570 * t529 + 0.98e2 / 0.75e2 * t343 * t573 - 0.14e2 / 0.45e2 * t209 * t546
  t584 = t359 * t222
  t600 = (-0.440e3 / 0.27e2 * t550 + 0.154e3 / 0.27e2 * t537) * t71 * t75 / 0.4e1 - 0.308e3 / 0.243e3 * t538
  t603 = t600 * t62
  t611 = t235 * t273
  t618 = t133 * t433
  t625 = -0.42625e5 / 0.177147e6 * t544 - 0.1540e4 / 0.81e2 * t122 * t123 * t536 + 0.584e3 / 0.135e3 * t235 * t383 + 0.584e3 / 0.405e3 * t133 * t600 - 0.146e3 / 0.135e3 * t603 * t137 - 0.146e3 / 0.45e2 * t383 * t164 * t137 + 0.146e3 / 0.45e2 * t386 * t164 - 0.146e3 / 0.45e2 * t611 * t137 + 0.292e3 / 0.45e2 * t235 * t267 + 0.146e3 / 0.45e2 * t238 * t273 - 0.146e3 / 0.135e3 * t618 * t137 + 0.292e3 / 0.45e2 * t394 * t164 + 0.146e3 / 0.135e3 * t136 * t433
  t628 = t246 * t401
  t631 = t117 * t436
  t634 = t290 * t117
  t637 = t174 * t117
  t640 = t443 * t117 + 0.3e1 * t281 * t212 - 0.27e2 / 0.100e3 * t516 * t367 + 0.171e3 / 0.1000e4 * t522 * t523 + t70 * t578 + 0.3e1 * t170 * t348 + 0.3e1 / 0.10e2 * t361 * t401 + 0.3e1 / 0.10e2 * t584 * t246 + t223 * t625 / 0.10e2 - 0.27e2 / 0.100e3 * t366 * t628 - 0.12e2 * t174 * t631 + 0.162e3 * t634 * t465 - 0.36e2 * t637 * t438
  t641 = t512 + t640
  t646 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t143 - 0.3e1 / 0.8e1 * t5 * t155 * t143 - 0.9e1 / 0.8e1 * t5 * t159 * t249 + t5 * t258 * t143 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t262 * t249 - 0.9e1 / 0.8e1 * t5 * t266 * t404 - 0.5e1 / 0.36e2 * t5 * t414 * t143 + t5 * t418 * t249 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t422 * t404 - 0.3e1 / 0.8e1 * t5 * t426 * t641)
  t648 = r1 <= f.p.dens_threshold
  t649 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t650 = 0.1e1 + t649
  t651 = t650 <= f.p.zeta_threshold
  t652 = t650 ** (0.1e1 / 0.3e1)
  t653 = t652 ** 2
  t655 = 0.1e1 / t653 / t650
  t657 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t658 = t657 ** 2
  t662 = 0.1e1 / t653
  t663 = t662 * t657
  t665 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t669 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t673 = f.my_piecewise3(t651, 0, -0.8e1 / 0.27e2 * t655 * t658 * t657 + 0.4e1 / 0.3e1 * t663 * t665 + 0.4e1 / 0.3e1 * t652 * t669)
  t679 = s2 / r1 / tau1 / 0.8e1
  t681 = f.my_piecewise3(t679 < 0.10e1, t679, 0.10e1)
  t682 = t681 ** 2
  t683 = t682 * t681
  t687 = (0.1e1 + t683) ** 2
  t689 = (t682 + 0.3e1 * t683) / t687
  t690 = r1 ** 2
  t691 = r1 ** (0.1e1 / 0.3e1)
  t692 = t691 ** 2
  t694 = 0.1e1 / t692 / t690
  t695 = s2 * t694
  t696 = t76 * t695
  t698 = s2 ** 2
  t699 = t690 ** 2
  t707 = (0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t696 + 0.26899490462262948000000000000000000000000000000000e-2 * t88 * t698 / t691 / t699 / r1) ** (0.1e1 / 0.5e1)
  t712 = tau1 / t692 / r1
  t720 = t707 ** 2
  t740 = (t712 - t695 / 0.8e1) * t71 * t75 / 0.4e1 - 0.9e1 / 0.20e2 + t696 / 0.36e2
  t741 = t740 ** 2
  t748 = (0.1e1 + 0.5e1 / 0.12e2 * (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t696) * t71 * t75 * s2 * t694 + 0.292e3 / 0.405e3 * t741 - 0.146e3 / 0.135e3 * t740 * t681 * (0.1e1 - t681)) ** (0.1e1 / 0.10e2)
  t750 = t689 * (0.1e1 / t707 + 0.7e1 / 0.9e1 * (0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t696 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t712 + t106 + 0.11867481666666666666666666666666666666666666666667e-1 * t695) * t71 * t75) / t720) + (0.1e1 - t689) * t748
  t759 = f.my_piecewise3(t651, 0, 0.4e1 / 0.9e1 * t662 * t658 + 0.4e1 / 0.3e1 * t652 * t665)
  t766 = f.my_piecewise3(t651, 0, 0.4e1 / 0.3e1 * t652 * t657)
  t772 = f.my_piecewise3(t651, t409, t652 * t650)
  t778 = f.my_piecewise3(t648, 0, -0.3e1 / 0.8e1 * t5 * t673 * t54 * t750 - 0.3e1 / 0.8e1 * t5 * t759 * t154 * t750 + t5 * t766 * t257 * t750 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t772 * t413 * t750)
  t781 = 0.1e1 / t153 / t36
  t809 = t19 ** 2
  t812 = t30 ** 2
  t818 = t41 ** 2
  t827 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t828 = f.my_piecewise5(t10, 0, t14, 0, t827)
  t832 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t809 * t812 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t818 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t828)
  t845 = t273 ** 2
  t853 = f.my_piecewise3(t61, 0.3e1 * s0 / t91 * t58, 0)
  t856 = t267 * t273
  t858 = t62 * t845
  t860 = t165 * t433
  t862 = t63 * t853
  t865 = (0.8e1 * t164 * t433 + 0.2e1 * t62 * t853 + 0.6e1 * t845 + 0.108e3 * t856 + 0.54e2 * t858 + 0.72e2 * t860 + 0.9e1 * t862) * t69
  t869 = t324 ** 2
  t883 = t307 ** 2
  t887 = t310 ** 2
  t894 = 0.1e1 / t79 / t187
  t895 = s0 * t894
  t896 = t76 * t895
  t902 = t88 * t89 / t78 / t540 / r0
  t904 = 0.38902804850480109739368998628257887517146776406036e2 * t896 + 0.55525861793708208711111111111111111111111111111111e1 * t902
  t928 = tau0 * t536
  t938 = 0.98e2 / 0.75e2 * t343 * t869 + 0.392e3 / 0.225e3 * t343 * t193 * t546 + 0.196e3 / 0.75e2 * t335 * t342 * t310 - 0.1568e4 / 0.375e3 * t204 * t569 * t529 + 0.392e3 / 0.75e2 * t563 * t573 + 0.6664e4 / 0.1875e4 * t112 / t113 / t883 * t887 - 0.784e3 / 0.125e3 * t570 * t310 * t324 - 0.14e2 / 0.45e2 * t209 * t904 - 0.56e2 / 0.45e2 * t557 * t208 * t193 - 0.28e2 / 0.15e2 * t560 * t324 - 0.56e2 / 0.45e2 * t338 * t546 + 0.1056e4 / 0.625e3 / t98 / t883 * t887 - 0.396e3 / 0.125e3 * t528 * t310 * t324 + 0.18e2 / 0.25e2 * t309 * t869 + 0.24e2 / 0.25e2 * t532 * t546 - t180 * t904 / 0.5e1 + 0.7e1 / 0.9e1 * (0.16533692061454046639231824417009602194787379972565e2 * t896 - 0.5e1 / 0.9e1 * (0.11068327545679012345679012345679012345679012345679e2 * t928 + 0.30685498274897119341563786008230452674897119341564e1 * t895) * t71 * t75) * t114
  t950 = (0.6160e4 / 0.81e2 * t928 - 0.2618e4 / 0.81e2 * t895) * t71 * t75 / 0.4e1 + 0.5236e4 / 0.729e3 * t896
  t985 = t383 ** 2
  t991 = 0.380875e6 / 0.177147e6 * t902 - 0.146e3 / 0.135e3 * t950 * t62 * t137 - 0.584e3 / 0.135e3 * t600 * t164 * t137 + 0.584e3 / 0.135e3 * t603 * t164 - 0.292e3 / 0.45e2 * t383 * t273 * t137 + 0.292e3 / 0.45e2 * t386 * t273 - 0.584e3 / 0.135e3 * t235 * t433 * t137 + 0.1168e4 / 0.45e2 * t611 * t164 + 0.584e3 / 0.135e3 * t238 * t433 - 0.146e3 / 0.135e3 * t133 * t853 * t137 + 0.1168e4 / 0.135e3 * t618 * t164 + 0.292e3 / 0.45e2 * t133 * t845 + 0.146e3 / 0.135e3 * t136 * t853 + 0.26180e5 / 0.243e3 * t122 * t123 * t894 + 0.584e3 / 0.45e2 * t383 * t267 + 0.584e3 / 0.135e3 * t985 + 0.2336e4 / 0.405e3 * t235 * t600 + 0.584e3 / 0.405e3 * t133 * t950
  t996 = t401 ** 2
  t1006 = t367 ** 2
  t1014 = -0.27e2 / 0.50e2 * t359 * t365 * t367 + 0.6e1 * t281 * t348 + t865 * t117 + 0.4e1 * t170 * t578 + t70 * t938 + 0.2e1 / 0.5e1 * t361 * t625 + t223 * t991 / 0.10e2 + 0.3e1 / 0.5e1 * t584 * t401 - 0.27e2 / 0.100e3 * t366 * t996 + 0.171e3 / 0.250e3 * t216 * t521 * t523 - 0.4959e4 / 0.10000e5 * t119 / t221 / t519 / t140 * t1006 + 0.2e1 / 0.5e1 * t474 * t222 * t246 + 0.4e1 * t443 * t212
  t1021 = t66 / t288 / t68
  t1022 = t291 ** 2
  t1023 = t267 ** 2
  t1031 = t442 * t173
  t1036 = t280 * t289
  t1039 = t169 * t455
  t1046 = -0.9720e4 * t1021 * t1022 * t1023 + 0.24e2 * t1031 * t167 - 0.324e3 * t1036 * t352 + 0.2592e4 * t1039 * t458 + 0.72e2 * t174 * t856 + 0.36e2 * t174 * t858 + 0.48e2 * t174 * t860 + 0.6e1 * t174 * t862 + 0.36e2 * t444 * t278 + 0.48e2 * t283 * t436 + 0.24e2 * t283 * t440
  t1055 = t291 * t62
  t1060 = t457 * t267 * t273
  t1067 = t64 * t267 * t273
  t1073 = t464 * t433
  t1076 = 0.7776e4 * t456 * t1055 * t1023 - 0.1080e4 * t290 * t63 * t1023 - 0.162e3 * t290 * t291 * t845 + 0.3888e4 * t456 * t1060 - 0.1944e4 * t290 * t1067 - 0.216e3 * t290 * t1073 + 0.72e2 * t444 * t276 + 0.144e3 * t283 * t438 - 0.1296e4 * t447 * t461 - 0.648e3 * t447 * t465 - t865
  t1116 = (t1046 + t1076) * t141 - 0.6e1 * t174 * t175 * t853 - 0.24e2 * t1031 * t176 - 0.24e2 * t174 * t296 * t433 + 0.162e3 * t290 * t292 * t845 - 0.36e2 * t174 * t300 * t845 + 0.1296e4 * t290 * t212 * t64 * t436 - 0.7776e4 * t456 * t117 * t1055 * t1023 + 0.1080e4 * t290 * t175 * t1023 - 0.72e2 * t174 * t117 * t267 * t273 + 0.1296e4 * t447 * t497 - 0.72e2 * t174 * t348 * t62 * t267 - 0.24e2 * t283 * t507
  t1153 = 0.9720e4 * t1021 * t117 * t1022 * t1023 - 0.24e2 * t174 * t578 * t63 * t164 - 0.2592e4 * t456 * t212 * t457 * t436 + 0.324e3 * t290 * t348 * t291 * t267 - 0.36e2 * t174 * t500 * t273 - 0.2592e4 * t1039 * t491 - 0.144e3 * t283 * t477 - 0.72e2 * t283 * t501 - 0.72e2 * t283 * t504 - 0.72e2 * t444 * t297 - 0.72e2 * t444 * t301 - 0.36e2 * t444 * t304 + 0.648e3 * t447 * t487
  t1190 = 0.324e3 * t1036 * t293 - 0.9e1 / 0.25e2 * t366 * t246 * t625 - 0.27e2 / 0.25e2 * t516 * t628 - 0.48e2 * t174 * t212 * t436 + 0.513e3 / 0.500e3 * t522 * t367 * t401 - 0.48e2 * t283 * t631 + 0.648e3 * t290 * t212 * t465 - 0.3888e4 * t456 * t117 * t1060 - 0.144e3 * t283 * t117 * t438 + 0.1944e4 * t634 * t1067 - 0.144e3 * t174 * t212 * t438 - 0.48e2 * t637 * t860 + 0.216e3 * t634 * t1073 + 0.648e3 * t447 * t117 * t465
  t1208 = 0.10e2 / 0.27e2 * t5 * t411 * t781 * t143 - t5 * t422 * t641 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t414 * t249 + t5 * t418 * t404 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t266 * t641 - 0.3e1 / 0.2e1 * t5 * t262 * t404 + t5 * t258 * t249 - 0.3e1 / 0.2e1 * t5 * t155 * t249 - 0.9e1 / 0.4e1 * t5 * t159 * t404 - 0.3e1 / 0.8e1 * t5 * t832 * t54 * t143 - 0.3e1 / 0.2e1 * t5 * t55 * t249 - 0.3e1 / 0.8e1 * t5 * t426 * (t1014 + t1116 + t1153 + t1190) - t5 * t53 * t154 * t143 / 0.2e1 + t5 * t152 * t257 * t143 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t255 * t413 * t143
  t1209 = f.my_piecewise3(t1, 0, t1208)
  t1210 = t650 ** 2
  t1213 = t658 ** 2
  t1219 = t665 ** 2
  t1225 = f.my_piecewise5(t14, 0, t10, 0, -t827)
  t1229 = f.my_piecewise3(t651, 0, 0.40e2 / 0.81e2 / t653 / t1210 * t1213 - 0.16e2 / 0.9e1 * t655 * t658 * t665 + 0.4e1 / 0.3e1 * t662 * t1219 + 0.16e2 / 0.9e1 * t663 * t669 + 0.4e1 / 0.3e1 * t652 * t1225)
  t1251 = f.my_piecewise3(t648, 0, -0.3e1 / 0.8e1 * t5 * t1229 * t54 * t750 - t5 * t673 * t154 * t750 / 0.2e1 + t5 * t759 * t257 * t750 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t766 * t413 * t750 + 0.10e2 / 0.27e2 * t5 * t772 * t781 * t750)
  d1111 = 0.4e1 * t646 + 0.4e1 * t778 + t6 * (t1209 + t1251)

  res = {'v4rho4': d1111}
  return res
