"""Generated from mgga_x_vcml.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1050362267560025, -0.1304673327239498, -0.25273044468938444, 0.0020345583050872945, 0.009705556829333915, -0.0018727613481398786, 0.005056319358478653, -0.0014994572626212954], dtype=np.float64), np.array([np.nan, 0.19526954394443446, 0.12131628073942294, -0.013135604251829597, -0.016823429546012295, -0.0021100890252897446, -0.0016609256494831233, 0.0028206838819829017, 0.00017309630990864668], dtype=np.float64), np.array([np.nan, -0.00068200282327089, 0.0012341314639045392, -0.000835331263170036, -7.823588139015819e-05, -0.0014878680171769923, 0.005061925051098745, -0.007631605623646023, -0.01006770315965861], dtype=np.float64), np.array([np.nan, -0.00217177716567727, 0.0024977311122498513, -0.0008670535705479461, 0.0027822064319562786, -0.0002571281595426713, -3.656012084198544e-05, -0.009195715678311926, 0.010726279571787276], dtype=np.float64), np.array([np.nan, -0.001432652476750007, 0.0050995906979556666, 0.0003180493235941731, -0.004704436332280876, 0.0009891355730978566, -0.0010249162124576494, 0.0008367073496483024, -0.00031389079758955066], dtype=np.float64), np.array([np.nan, -0.004500541251076788, 0.0016437722411542371, 8.482767148525194e-05, -0.00019375881298946268, -7.261106354828029e-05, -0.0038541498256550073, -0.0031296536914037784, 0.0038758929812102785], dtype=np.float64), np.array([np.nan, 0.00030574929164576756, 0.0005970286163074767, -0.0009048853909642742, -0.000689695394243961, 0.0001331797359718674, -0.007555456486598222, 0.001864317026752979, -0.00019095139973664826], dtype=np.float64), np.array([np.nan, -0.002025317083565653, 0.0023160016166370034, 0.00018939021743243079, 0.0004308565933608885, -1.792697304428732e-05, -0.0005194058669188706, -0.00018156466410673526, -0.00029476504977320184], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1050362267560025, -0.1304673327239498, -0.25273044468938444, 0.0020345583050872945, 0.009705556829333915, -0.0018727613481398786, 0.005056319358478653, -0.0014994572626212954], dtype=np.float64), np.array([np.nan, 0.19526954394443446, 0.12131628073942294, -0.013135604251829597, -0.016823429546012295, -0.0021100890252897446, -0.0016609256494831233, 0.0028206838819829017, 0.00017309630990864668], dtype=np.float64), np.array([np.nan, -0.00068200282327089, 0.0012341314639045392, -0.000835331263170036, -7.823588139015819e-05, -0.0014878680171769923, 0.005061925051098745, -0.007631605623646023, -0.01006770315965861], dtype=np.float64), np.array([np.nan, -0.00217177716567727, 0.0024977311122498513, -0.0008670535705479461, 0.0027822064319562786, -0.0002571281595426713, -3.656012084198544e-05, -0.009195715678311926, 0.010726279571787276], dtype=np.float64), np.array([np.nan, -0.001432652476750007, 0.0050995906979556666, 0.0003180493235941731, -0.004704436332280876, 0.0009891355730978566, -0.0010249162124576494, 0.0008367073496483024, -0.00031389079758955066], dtype=np.float64), np.array([np.nan, -0.004500541251076788, 0.0016437722411542371, 8.482767148525194e-05, -0.00019375881298946268, -7.261106354828029e-05, -0.0038541498256550073, -0.0031296536914037784, 0.0038758929812102785], dtype=np.float64), np.array([np.nan, 0.00030574929164576756, 0.0005970286163074767, -0.0009048853909642742, -0.000689695394243961, 0.0001331797359718674, -0.007555456486598222, 0.001864317026752979, -0.00019095139973664826], dtype=np.float64), np.array([np.nan, -0.002025317083565653, 0.0023160016166370034, 0.00018939021743243079, 0.0004308565933608885, -1.792697304428732e-05, -0.0005194058669188706, -0.00018156466410673526, -0.00029476504977320184], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1050362267560025, -0.1304673327239498, -0.25273044468938444, 0.0020345583050872945, 0.009705556829333915, -0.0018727613481398786, 0.005056319358478653, -0.0014994572626212954], dtype=np.float64), np.array([np.nan, 0.19526954394443446, 0.12131628073942294, -0.013135604251829597, -0.016823429546012295, -0.0021100890252897446, -0.0016609256494831233, 0.0028206838819829017, 0.00017309630990864668], dtype=np.float64), np.array([np.nan, -0.00068200282327089, 0.0012341314639045392, -0.000835331263170036, -7.823588139015819e-05, -0.0014878680171769923, 0.005061925051098745, -0.007631605623646023, -0.01006770315965861], dtype=np.float64), np.array([np.nan, -0.00217177716567727, 0.0024977311122498513, -0.0008670535705479461, 0.0027822064319562786, -0.0002571281595426713, -3.656012084198544e-05, -0.009195715678311926, 0.010726279571787276], dtype=np.float64), np.array([np.nan, -0.001432652476750007, 0.0050995906979556666, 0.0003180493235941731, -0.004704436332280876, 0.0009891355730978566, -0.0010249162124576494, 0.0008367073496483024, -0.00031389079758955066], dtype=np.float64), np.array([np.nan, -0.004500541251076788, 0.0016437722411542371, 8.482767148525194e-05, -0.00019375881298946268, -7.261106354828029e-05, -0.0038541498256550073, -0.0031296536914037784, 0.0038758929812102785], dtype=np.float64), np.array([np.nan, 0.00030574929164576756, 0.0005970286163074767, -0.0009048853909642742, -0.000689695394243961, 0.0001331797359718674, -0.007555456486598222, 0.001864317026752979, -0.00019095139973664826], dtype=np.float64), np.array([np.nan, -0.002025317083565653, 0.0023160016166370034, 0.00018939021743243079, 0.0004308565933608885, -1.792697304428732e-05, -0.0005194058669188706, -0.00018156466410673526, -0.00029476504977320184], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t42 = 0.65124e1 + t33 * t39 / 0.24e2
  t43 = 0.1e1 / t42
  t45 = t33 * t39 * t43
  t47 = t45 / 0.12e2 - 0.1e1
  t48 = t47 ** 2
  t49 = t48 ** 2
  t50 = t49 * t48
  t55 = 0.10284428865871160000000000000000000000000000000000e-3 * t45 - 0.12341314639045392e-2
  t57 = 0.1e1 / t36 / r0
  t63 = 0.5e1 / 0.9e1 * (tau0 * t57 - t39 / 0.8e1) * t28 * t32
  t64 = 0.1e5 <= t63
  t65 = 0.1e5 < t63
  t66 = f.my_piecewise3(t65, t63, 0.1e5)
  t67 = t66 ** 2
  t71 = 0.1e1 / t67 / t66
  t73 = t67 ** 2
  t74 = 0.1e1 / t73
  t77 = f.my_piecewise3(t65, 0.1e5, t63)
  t78 = t77 ** 2
  t79 = 0.1e1 - t78
  t80 = t79 ** 2
  t81 = t80 * t79
  t82 = t78 * t77
  t84 = 0.1e1 + 0.4e1 * t82
  t86 = t82 * t84 + 0.1e1
  t87 = 0.1e1 / t86
  t89 = f.my_piecewise3(t64, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t67 + t71 / 0.16e2 - 0.3e1 / 0.4e1 * t74, t81 * t87)
  t90 = t89 ** 2
  t92 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t90
  t95 = 0.20814425935415427500000000000000000000000000000000e-3 * t45 - 0.24977311122498513e-2
  t96 = t90 * t89
  t99 = 0.5e1 / 0.2e1 * t96 - 0.3e1 / 0.2e1 * t89
  t101 = t48 * t47
  t104 = -0.19558970347539547500000000000000000000000000000000e-3 * t101 + 0.97794851737697737500000000000000000000000000000000e-5 * t45 - 0.11735382208523728500000000000000000000000000000000e-3
  t108 = -0.42058573865030737500000000000000000000000000000000e-1 * t101 + 0.21029286932515368750000000000000000000000000000000e-2 * t45 - 0.25235144319018442500000000000000000000000000000000e-1
  t111 = -0.94695108716215395000000000000000000000000000000000e-4 + 0.28408532614864618500000000000000000000000000000000e-3 * t48
  t112 = t90 ** 2
  t113 = t112 * t96
  t115 = t112 * t89
  t119 = 0.429e3 / 0.16e2 * t113 - 0.693e3 / 0.16e2 * t115 + 0.315e3 / 0.16e2 * t96 - 0.35e2 / 0.16e2 * t89
  t122 = 0.45244269548213710000000000000000000000000000000000e-3 - 0.13573280864464113000000000000000000000000000000000e-2 * t48
  t123 = t112 * t90
  t127 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t123 - 0.315e3 / 0.16e2 * t112 + 0.105e3 / 0.16e2 * t90
  t130 = -0.42413835742625970000000000000000000000000000000000e-4 + 0.12724150722787791000000000000000000000000000000000e-3 * t48
  t134 = 0.63e2 / 0.8e1 * t115 - 0.35e2 / 0.4e1 * t96 + 0.15e2 / 0.8e1 * t89
  t137 = -0.15902466179708655000000000000000000000000000000000e-3 + 0.47707398539125965000000000000000000000000000000000e-3 * t48
  t140 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t112 - 0.15e2 / 0.4e1 * t90
  t143 = 0.43352678527397305000000000000000000000000000000000e-3 - 0.13005803558219191500000000000000000000000000000000e-2 * t48
  t146 = 0.41766563158501800000000000000000000000000000000000e-3 - 0.12529968947550540000000000000000000000000000000000e-2 * t48
  t149 = 0.65678021259147985000000000000000000000000000000000e-2 - 0.19703406377744395500000000000000000000000000000000e-1 * t48
  t152 = 0.19300013471975028333333333333333333333333333333333e-3 * t45 - 0.23160016166370034e-2
  t155 = 0.49752384692289725000000000000000000000000000000000e-4 * t45 - 0.5970286163074767e-3
  t157 = 0.73000610738035552687500000000000000000000000000000e-1 * t50 - 0.57084476241712602812500000000000000000000000000000e-1 * t49 - 0.38230940935406268093750000000000000000000000000000e0 * t48 + t55 * t92 + t95 * t99 + t104 * t92 + t108 * t89 + t111 * t119 + t122 * t127 + t130 * t134 + t137 * t140 + t143 * t99 + t146 * t92 + t149 * t89 + t152 * t119 + t155 * t127
  t159 = 0.13698102009618642500000000000000000000000000000000e-3 * t45 - 0.16437722411542371e-2
  t162 = 0.42496589149630555000000000000000000000000000000000e-3 * t45 - 0.50995906979556666e-2
  t165 = 0.10109690061618578333333333333333333333333333333333e-1 * t45 - 0.12131628073942294e0
  t169 = -0.27229148830605108750000000000000000000000000000000e-4 - 0.31767340302372626875000000000000000000000000000000e-3 * t49 + 0.27229148830605108750000000000000000000000000000000e-3 * t48
  t173 = 0.37092583991169622500000000000000000000000000000000e-3 + 0.43274681323031226250000000000000000000000000000000e-2 * t49 - 0.37092583991169622500000000000000000000000000000000e-2 * t48
  t177 = -0.96423059828501737500000000000000000000000000000000e-4 - 0.11249356979991869375000000000000000000000000000000e-2 * t49 + 0.96423059828501737500000000000000000000000000000000e-3 * t48
  t181 = -0.55795050644137211250000000000000000000000000000000e-3 - 0.65094225751493413125000000000000000000000000000000e-2 * t49 + 0.55795050644137211250000000000000000000000000000000e-2 * t48
  t185 = -0.79128338448365422500000000000000000000000000000000e-3 - 0.92316394856426326250000000000000000000000000000000e-2 * t49 + 0.79128338448365422500000000000000000000000000000000e-2 * t48
  t189 = 0.10771414834022212500000000000000000000000000000000e-2 * t101 - 0.53857074170111062500000000000000000000000000000000e-4 * t45 + 0.64628489004133275000000000000000000000000000000000e-3
  t193 = -0.17242384856099025000000000000000000000000000000000e-2 * t101 + 0.86211924280495125000000000000000000000000000000000e-4 * t45 - 0.10345430913659415000000000000000000000000000000000e-2
  t197 = -0.48439703247365670000000000000000000000000000000000e-3 * t101 + 0.24219851623682835000000000000000000000000000000000e-4 * t45 - 0.29063821948419402000000000000000000000000000000000e-3
  t201 = -0.11761090830702190000000000000000000000000000000000e-1 * t101 + 0.58805454153510950000000000000000000000000000000000e-3 * t45 - 0.70566544984213140000000000000000000000000000000000e-2
  t205 = 0.69555160798906965000000000000000000000000000000000e-2 * t101 - 0.34777580399453482500000000000000000000000000000000e-3 * t45 + 0.41733096479344179000000000000000000000000000000000e-2
  t210 = -0.88146371311965678125000000000000000000000000000000e-3 + 0.40723623546128143293750000000000000000000000000000e-1 * t50 - 0.55532213926538377218750000000000000000000000000000e-1 * t49 + 0.18510737975512792406250000000000000000000000000000e-1 * t48
  t212 = t49 * t47
  t216 = -0.40903212019861059750000000000000000000000000000000e-2 * t212 + 0.45448013355401177500000000000000000000000000000000e-2 * t101 - 0.81157166706073531250000000000000000000000000000000e-4 * t45 + 0.97388600047288237500000000000000000000000000000000e-3
  t221 = -0.59499219831960998250000000000000000000000000000000e-1 * t212 + 0.66110244257734442500000000000000000000000000000000e-1 * t101 - 0.11805400760309721875000000000000000000000000000000e-2 * t45 + 0.14166480912371666250000000000000000000000000000000e-1
  t223 = t189 * t119 + t216 * t119 + t193 * t127 + t221 * t127 + t159 * t134 + t169 * t134 + t197 * t134 + t162 * t140 + t173 * t140 + t201 * t140 + t165 * t89 + t177 * t99 + t181 * t92 + t185 * t89 + t205 * t99 + t210 * t89
  t228 = -0.30351429877033182487500000000000000000000000000000e-1 * t212 + 0.33723810974481313875000000000000000000000000000000e-1 * t101 - 0.60221091025859489062500000000000000000000000000000e-3 * t45 + 0.72265309231031386875000000000000000000000000000000e-2
  t233 = -0.80712151731039890250000000000000000000000000000000e-2 * t212 + 0.89680168590044322500000000000000000000000000000000e-2 * t101 - 0.16014315819650771875000000000000000000000000000000e-3 * t45 + 0.19217178983580926250000000000000000000000000000000e-2
  t238 = -0.28791095163063534000000000000000000000000000000000e-3 * t212 + 0.31990105736737260000000000000000000000000000000000e-3 * t101 - 0.57125188815602250000000000000000000000000000000000e-5 * t45 + 0.68550226578722700000000000000000000000000000000000e-4
  t243 = 0.39862659777402616875000000000000000000000000000000e-1 * t212 - 0.44291844197114018750000000000000000000000000000000e-1 * t101 + 0.79092578923417890625000000000000000000000000000000e-3 * t45 - 0.94911094708101468750000000000000000000000000000000e-2
  t248 = -0.13079789489679595987500000000000000000000000000000e-1 * t212 + 0.14533099432977328875000000000000000000000000000000e-1 * t101 - 0.25951963273173801562500000000000000000000000000000e-3 * t45 + 0.31142355927808561875000000000000000000000000000000e-2
  t252 = -0.67226148916077450000000000000000000000000000000000e-5 - 0.78430507068757025000000000000000000000000000000000e-4 * t49 + 0.67226148916077450000000000000000000000000000000000e-4 * t48
  t256 = 0.49942400989450275000000000000000000000000000000000e-4 + 0.58266134487691987500000000000000000000000000000000e-3 * t49 - 0.49942400989450275000000000000000000000000000000000e-3 * t48
  t258 = t49 * t101
  t263 = 0.46411448094255891075000000000000000000000000000000e-2 * t258 - 0.74972339229182593275000000000000000000000000000000e-2 * t212 + 0.34078336013264815125000000000000000000000000000000e-2 * t101 - 0.31554014827097051041666666666666666666666666666667e-4 * t45 + 0.37864817792516461250000000000000000000000000000000e-3
  t268 = 0.56738957533354768750000000000000000000000000000000e-4 - 0.26213398380409903162500000000000000000000000000000e-2 * t50 + 0.35745543246013504312500000000000000000000000000000e-2 * t49 - 0.11915181082004501437500000000000000000000000000000e-2 * t48
  t273 = -0.58259907086030593750000000000000000000000000000000e-3 + 0.26916077073746134312500000000000000000000000000000e-1 * t50 - 0.36703741464199274062500000000000000000000000000000e-1 * t49 + 0.12234580488066424687500000000000000000000000000000e-1 * t48
  t278 = 0.97801677856368075000000000000000000000000000000000e-3 - 0.45184375169642050650000000000000000000000000000000e-1 * t50 + 0.61615057049511887250000000000000000000000000000000e-1 * t49 - 0.20538352349837295750000000000000000000000000000000e-1 * t48
  t283 = -0.26147104676509450000000000000000000000000000000000e-3 + 0.12079962360547365900000000000000000000000000000000e-1 * t50 - 0.16472675946200953500000000000000000000000000000000e-1 * t49 + 0.54908919820669845000000000000000000000000000000000e-2 * t48
  t288 = 0.28736611494724768750000000000000000000000000000000e-2 - 0.13276314510562843162500000000000000000000000000000e0 * t50 + 0.18104065241676604312500000000000000000000000000000e0 * t49 - 0.60346884138922014375000000000000000000000000000000e-1 * t48
  t293 = 0.23848767573893821875000000000000000000000000000000e-2 - 0.11018130619138945706250000000000000000000000000000e0 * t50 + 0.15024723571553107781250000000000000000000000000000e0 * t49 - 0.50082411905177025937500000000000000000000000000000e-1 * t48
  t299 = -0.51198844054388814712500000000000000000000000000000e-2 * t258 + 0.82705825010935777612500000000000000000000000000000e-2 * t212 - 0.37593556823152626187500000000000000000000000000000e-2 * t101 + 0.34808848910326505729166666666666666666666666666667e-4 * t45 - 0.41770618692391806875000000000000000000000000000000e-3
  t305 = 0.10392238055870059228125000000000000000000000000000e0 * t258 - 0.16787461474867018753125000000000000000000000000000e0 * t212 + 0.76306643067577357968750000000000000000000000000000e-1 * t101 - 0.70654299136645701822916666666666666666666666666667e-3 * t45 + 0.84785158963974842187500000000000000000000000000000e-2
  t307 = t252 * t119 + t268 * t119 + t256 * t127 + t273 * t127 + t299 * t127 + t228 * t134 + t278 * t134 + t305 * t134 + t233 * t140 + t283 * t140 + t238 * t99 + t243 * t92 + t248 * t89 + t263 * t89 + t288 * t99 + t293 * t92
  t312 = -0.84161970103698270712500000000000000000000000000000e-2 * t258 + 0.13595395170597412961250000000000000000000000000000e-1 * t212 - 0.61797250775442786187500000000000000000000000000000e-2 * t101 + 0.57219676643928505729166666666666666666666666666667e-4 * t45 - 0.68663611972714206875000000000000000000000000000000e-3
  t318 = 0.28759837101854633775000000000000000000000000000000e0 * t258 - 0.46458198395303639175000000000000000000000000000000e0 * t212 + 0.21117362906956199625000000000000000000000000000000e0 * t101 - 0.19553113802737221875000000000000000000000000000000e-2 * t45 + 0.23463736563284666250000000000000000000000000000000e-1
  t324 = -0.26994029096834648062500000000000000000000000000000e0 * t258 + 0.43605739310271354562500000000000000000000000000000e0 * t212 - 0.19820790595577888437500000000000000000000000000000e0 * t101 + 0.18352583884794341145833333333333333333333333333333e-2 * t45 - 0.22023100661753209375000000000000000000000000000000e-1
  t330 = -0.79033878970439743350000000000000000000000000000000e-2 * t258 + 0.12767011218301804695000000000000000000000000000000e-1 * t212 - 0.58031869174099112250000000000000000000000000000000e-2 * t101 + 0.53733212198239918750000000000000000000000000000000e-4 * t45 - 0.64479854637887902500000000000000000000000000000000e-3
  t343 = 0.13669196781387441795125000000000000000000000000000e1 + t312 * t140 + t318 * t99 + t324 * t92 + t330 * t119 - 0.40204197854033482912500000000000000000000000000000e-1 * t258 + 0.50197247070683313037500000000000000000000000000000e-1 * t212 - 0.8047507298914579187500000000000000000000000000000e-2 * t101 + 0.63559222793315408625000000000000000000000000000000e-2 * t90 - 0.54303814303104071062500000000000000000000000000000e-1 * t113 + 0.44142553981357691475000000000000000000000000000000e-2 * t123 - 0.12287293765057329462500000000000000000000000000000e-1 * t112 - 0.11145877912279910869791666666666666666666666666667e-1 * t45 + 0.19451907596748125343750000000000000000000000000000e0 * t89 + 0.52279783829707640062500000000000000000000000000000e-1 * t115 - 0.5923137049970073437500000000000000000000000000000e-2 * t96
  t345 = t157 + t223 + t307 + t343
  t349 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t345)
  t350 = r1 <= f.p.dens_threshold
  t351 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t352 = 0.1e1 + t351
  t353 = t352 <= f.p.zeta_threshold
  t354 = t352 ** (0.1e1 / 0.3e1)
  t356 = f.my_piecewise3(t353, t22, t354 * t352)
  t357 = t356 * t26
  t358 = r1 ** (0.1e1 / 0.3e1)
  t359 = t358 ** 2
  t361 = 0.1e1 / t359 / r1
  t363 = r1 ** 2
  t365 = 0.1e1 / t359 / t363
  t366 = s2 * t365
  t371 = 0.5e1 / 0.9e1 * (tau1 * t361 - t366 / 0.8e1) * t28 * t32
  t372 = 0.1e5 <= t371
  t373 = 0.1e5 < t371
  t374 = f.my_piecewise3(t373, t371, 0.1e5)
  t375 = t374 ** 2
  t379 = 0.1e1 / t375 / t374
  t381 = t375 ** 2
  t382 = 0.1e1 / t381
  t385 = f.my_piecewise3(t373, 0.1e5, t371)
  t386 = t385 ** 2
  t387 = 0.1e1 - t386
  t388 = t387 ** 2
  t389 = t388 * t387
  t390 = t386 * t385
  t392 = 0.1e1 + 0.4e1 * t390
  t394 = t390 * t392 + 0.1e1
  t395 = 0.1e1 / t394
  t397 = f.my_piecewise3(t372, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t375 + t379 / 0.16e2 - 0.3e1 / 0.4e1 * t382, t389 * t395)
  t398 = t397 ** 2
  t399 = t398 ** 2
  t400 = t399 * t398
  t406 = 0.65124e1 + t33 * t366 / 0.24e2
  t407 = 0.1e1 / t406
  t409 = t33 * t366 * t407
  t411 = 0.19300013471975028333333333333333333333333333333333e-3 * t409 - 0.23160016166370034e-2
  t412 = t398 * t397
  t413 = t399 * t412
  t415 = t399 * t397
  t419 = 0.429e3 / 0.16e2 * t413 - 0.693e3 / 0.16e2 * t415 + 0.315e3 / 0.16e2 * t412 - 0.35e2 / 0.16e2 * t397
  t422 = 0.49752384692289725000000000000000000000000000000000e-4 * t409 - 0.5970286163074767e-3
  t426 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t400 - 0.315e3 / 0.16e2 * t399 + 0.105e3 / 0.16e2 * t398
  t429 = 0.13698102009618642500000000000000000000000000000000e-3 * t409 - 0.16437722411542371e-2
  t433 = 0.63e2 / 0.8e1 * t415 - 0.35e2 / 0.4e1 * t412 + 0.15e2 / 0.8e1 * t397
  t436 = 0.42496589149630555000000000000000000000000000000000e-3 * t409 - 0.50995906979556666e-2
  t439 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t399 - 0.15e2 / 0.4e1 * t398
  t442 = 0.20814425935415427500000000000000000000000000000000e-3 * t409 - 0.24977311122498513e-2
  t445 = 0.5e1 / 0.2e1 * t412 - 0.3e1 / 0.2e1 * t397
  t448 = 0.10284428865871160000000000000000000000000000000000e-3 * t409 - 0.12341314639045392e-2
  t450 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t398
  t453 = 0.10109690061618578333333333333333333333333333333333e-1 * t409 - 0.12131628073942294e0
  t456 = t409 / 0.12e2 - 0.1e1
  t457 = t456 ** 2
  t458 = t457 * t456
  t461 = -0.17242384856099025000000000000000000000000000000000e-2 * t458 + 0.86211924280495125000000000000000000000000000000000e-4 * t409 - 0.10345430913659415000000000000000000000000000000000e-2
  t465 = -0.48439703247365670000000000000000000000000000000000e-3 * t458 + 0.24219851623682835000000000000000000000000000000000e-4 * t409 - 0.29063821948419402000000000000000000000000000000000e-3
  t469 = -0.11761090830702190000000000000000000000000000000000e-1 * t458 + 0.58805454153510950000000000000000000000000000000000e-3 * t409 - 0.70566544984213140000000000000000000000000000000000e-2
  t473 = 0.69555160798906965000000000000000000000000000000000e-2 * t458 - 0.34777580399453482500000000000000000000000000000000e-3 * t409 + 0.41733096479344179000000000000000000000000000000000e-2
  t477 = -0.19558970347539547500000000000000000000000000000000e-3 * t458 + 0.97794851737697737500000000000000000000000000000000e-5 * t409 - 0.11735382208523728500000000000000000000000000000000e-3
  t481 = -0.42058573865030737500000000000000000000000000000000e-1 * t458 + 0.21029286932515368750000000000000000000000000000000e-2 * t409 - 0.25235144319018442500000000000000000000000000000000e-1
  t483 = 0.44142553981357691475000000000000000000000000000000e-2 * t400 - 0.12287293765057329462500000000000000000000000000000e-1 * t399 + 0.63559222793315408625000000000000000000000000000000e-2 * t398 + t411 * t419 + t422 * t426 + t429 * t433 + t436 * t439 + t442 * t445 + t448 * t450 + t453 * t397 + t461 * t426 + t465 * t433 + t469 * t439 + t473 * t445 + t477 * t450 + t481 * t397
  t485 = -0.94695108716215395000000000000000000000000000000000e-4 + 0.28408532614864618500000000000000000000000000000000e-3 * t457
  t488 = 0.45244269548213710000000000000000000000000000000000e-3 - 0.13573280864464113000000000000000000000000000000000e-2 * t457
  t491 = -0.42413835742625970000000000000000000000000000000000e-4 + 0.12724150722787791000000000000000000000000000000000e-3 * t457
  t494 = -0.15902466179708655000000000000000000000000000000000e-3 + 0.47707398539125965000000000000000000000000000000000e-3 * t457
  t497 = 0.43352678527397305000000000000000000000000000000000e-3 - 0.13005803558219191500000000000000000000000000000000e-2 * t457
  t500 = 0.41766563158501800000000000000000000000000000000000e-3 - 0.12529968947550540000000000000000000000000000000000e-2 * t457
  t503 = 0.65678021259147985000000000000000000000000000000000e-2 - 0.19703406377744395500000000000000000000000000000000e-1 * t457
  t505 = t457 ** 2
  t506 = t505 * t456
  t510 = -0.13079789489679595987500000000000000000000000000000e-1 * t506 + 0.14533099432977328875000000000000000000000000000000e-1 * t458 - 0.25951963273173801562500000000000000000000000000000e-3 * t409 + 0.31142355927808561875000000000000000000000000000000e-2
  t514 = -0.67226148916077450000000000000000000000000000000000e-5 - 0.78430507068757025000000000000000000000000000000000e-4 * t505 + 0.67226148916077450000000000000000000000000000000000e-4 * t457
  t518 = 0.49942400989450275000000000000000000000000000000000e-4 + 0.58266134487691987500000000000000000000000000000000e-3 * t505 - 0.49942400989450275000000000000000000000000000000000e-3 * t457
  t522 = -0.27229148830605108750000000000000000000000000000000e-4 - 0.31767340302372626875000000000000000000000000000000e-3 * t505 + 0.27229148830605108750000000000000000000000000000000e-3 * t457
  t526 = 0.37092583991169622500000000000000000000000000000000e-3 + 0.43274681323031226250000000000000000000000000000000e-2 * t505 - 0.37092583991169622500000000000000000000000000000000e-2 * t457
  t530 = -0.96423059828501737500000000000000000000000000000000e-4 - 0.11249356979991869375000000000000000000000000000000e-2 * t505 + 0.96423059828501737500000000000000000000000000000000e-3 * t457
  t534 = -0.55795050644137211250000000000000000000000000000000e-3 - 0.65094225751493413125000000000000000000000000000000e-2 * t505 + 0.55795050644137211250000000000000000000000000000000e-2 * t457
  t538 = -0.79128338448365422500000000000000000000000000000000e-3 - 0.92316394856426326250000000000000000000000000000000e-2 * t505 + 0.79128338448365422500000000000000000000000000000000e-2 * t457
  t542 = 0.10771414834022212500000000000000000000000000000000e-2 * t458 - 0.53857074170111062500000000000000000000000000000000e-4 * t409 + 0.64628489004133275000000000000000000000000000000000e-3
  t544 = t503 * t397 + t510 * t397 + t538 * t397 + t485 * t419 + t514 * t419 + t542 * t419 + t488 * t426 + t518 * t426 + t491 * t433 + t522 * t433 + t494 * t439 + t526 * t439 + t497 * t445 + t530 * t445 + t500 * t450 + t534 * t450
  t546 = t505 * t457
  t550 = 0.28736611494724768750000000000000000000000000000000e-2 - 0.13276314510562843162500000000000000000000000000000e0 * t546 + 0.18104065241676604312500000000000000000000000000000e0 * t505 - 0.60346884138922014375000000000000000000000000000000e-1 * t457
  t555 = 0.23848767573893821875000000000000000000000000000000e-2 - 0.11018130619138945706250000000000000000000000000000e0 * t546 + 0.15024723571553107781250000000000000000000000000000e0 * t505 - 0.50082411905177025937500000000000000000000000000000e-1 * t457
  t560 = -0.88146371311965678125000000000000000000000000000000e-3 + 0.40723623546128143293750000000000000000000000000000e-1 * t546 - 0.55532213926538377218750000000000000000000000000000e-1 * t505 + 0.18510737975512792406250000000000000000000000000000e-1 * t457
  t565 = -0.40903212019861059750000000000000000000000000000000e-2 * t506 + 0.45448013355401177500000000000000000000000000000000e-2 * t458 - 0.81157166706073531250000000000000000000000000000000e-4 * t409 + 0.97388600047288237500000000000000000000000000000000e-3
  t570 = -0.59499219831960998250000000000000000000000000000000e-1 * t506 + 0.66110244257734442500000000000000000000000000000000e-1 * t458 - 0.11805400760309721875000000000000000000000000000000e-2 * t409 + 0.14166480912371666250000000000000000000000000000000e-1
  t575 = -0.30351429877033182487500000000000000000000000000000e-1 * t506 + 0.33723810974481313875000000000000000000000000000000e-1 * t458 - 0.60221091025859489062500000000000000000000000000000e-3 * t409 + 0.72265309231031386875000000000000000000000000000000e-2
  t580 = -0.80712151731039890250000000000000000000000000000000e-2 * t506 + 0.89680168590044322500000000000000000000000000000000e-2 * t458 - 0.16014315819650771875000000000000000000000000000000e-3 * t409 + 0.19217178983580926250000000000000000000000000000000e-2
  t585 = -0.28791095163063534000000000000000000000000000000000e-3 * t506 + 0.31990105736737260000000000000000000000000000000000e-3 * t458 - 0.57125188815602250000000000000000000000000000000000e-5 * t409 + 0.68550226578722700000000000000000000000000000000000e-4
  t590 = 0.39862659777402616875000000000000000000000000000000e-1 * t506 - 0.44291844197114018750000000000000000000000000000000e-1 * t458 + 0.79092578923417890625000000000000000000000000000000e-3 * t409 - 0.94911094708101468750000000000000000000000000000000e-2
  t592 = t505 * t458
  t597 = 0.28759837101854633775000000000000000000000000000000e0 * t592 - 0.46458198395303639175000000000000000000000000000000e0 * t506 + 0.21117362906956199625000000000000000000000000000000e0 * t458 - 0.19553113802737221875000000000000000000000000000000e-2 * t409 + 0.23463736563284666250000000000000000000000000000000e-1
  t603 = -0.26994029096834648062500000000000000000000000000000e0 * t592 + 0.43605739310271354562500000000000000000000000000000e0 * t506 - 0.19820790595577888437500000000000000000000000000000e0 * t458 + 0.18352583884794341145833333333333333333333333333333e-2 * t409 - 0.22023100661753209375000000000000000000000000000000e-1
  t609 = 0.46411448094255891075000000000000000000000000000000e-2 * t592 - 0.74972339229182593275000000000000000000000000000000e-2 * t506 + 0.34078336013264815125000000000000000000000000000000e-2 * t458 - 0.31554014827097051041666666666666666666666666666667e-4 * t409 + 0.37864817792516461250000000000000000000000000000000e-3
  t614 = 0.56738957533354768750000000000000000000000000000000e-4 - 0.26213398380409903162500000000000000000000000000000e-2 * t546 + 0.35745543246013504312500000000000000000000000000000e-2 * t505 - 0.11915181082004501437500000000000000000000000000000e-2 * t457
  t619 = -0.58259907086030593750000000000000000000000000000000e-3 + 0.26916077073746134312500000000000000000000000000000e-1 * t546 - 0.36703741464199274062500000000000000000000000000000e-1 * t505 + 0.12234580488066424687500000000000000000000000000000e-1 * t457
  t624 = 0.97801677856368075000000000000000000000000000000000e-3 - 0.45184375169642050650000000000000000000000000000000e-1 * t546 + 0.61615057049511887250000000000000000000000000000000e-1 * t505 - 0.20538352349837295750000000000000000000000000000000e-1 * t457
  t629 = -0.26147104676509450000000000000000000000000000000000e-3 + 0.12079962360547365900000000000000000000000000000000e-1 * t546 - 0.16472675946200953500000000000000000000000000000000e-1 * t505 + 0.54908919820669845000000000000000000000000000000000e-2 * t457
  t631 = t560 * t397 + t609 * t397 + t565 * t419 + t614 * t419 + t570 * t426 + t619 * t426 + t575 * t433 + t624 * t433 + t580 * t439 + t629 * t439 + t550 * t445 + t585 * t445 + t597 * t445 + t555 * t450 + t590 * t450 + t603 * t450
  t636 = -0.79033878970439743350000000000000000000000000000000e-2 * t592 + 0.12767011218301804695000000000000000000000000000000e-1 * t506 - 0.58031869174099112250000000000000000000000000000000e-2 * t458 + 0.53733212198239918750000000000000000000000000000000e-4 * t409 - 0.64479854637887902500000000000000000000000000000000e-3
  t642 = -0.51198844054388814712500000000000000000000000000000e-2 * t592 + 0.82705825010935777612500000000000000000000000000000e-2 * t506 - 0.37593556823152626187500000000000000000000000000000e-2 * t458 + 0.34808848910326505729166666666666666666666666666667e-4 * t409 - 0.41770618692391806875000000000000000000000000000000e-3
  t648 = 0.10392238055870059228125000000000000000000000000000e0 * t592 - 0.16787461474867018753125000000000000000000000000000e0 * t506 + 0.76306643067577357968750000000000000000000000000000e-1 * t458 - 0.70654299136645701822916666666666666666666666666667e-3 * t409 + 0.84785158963974842187500000000000000000000000000000e-2
  t654 = -0.84161970103698270712500000000000000000000000000000e-2 * t592 + 0.13595395170597412961250000000000000000000000000000e-1 * t506 - 0.61797250775442786187500000000000000000000000000000e-2 * t458 + 0.57219676643928505729166666666666666666666666666667e-4 * t409 - 0.68663611972714206875000000000000000000000000000000e-3
  t667 = 0.13669196781387441795125000000000000000000000000000e1 + t636 * t419 + t642 * t426 + t648 * t433 + t654 * t439 - 0.11145877912279910869791666666666666666666666666667e-1 * t409 - 0.57084476241712602812500000000000000000000000000000e-1 * t505 - 0.38230940935406268093750000000000000000000000000000e0 * t457 - 0.40204197854033482912500000000000000000000000000000e-1 * t592 + 0.50197247070683313037500000000000000000000000000000e-1 * t506 - 0.8047507298914579187500000000000000000000000000000e-2 * t458 - 0.54303814303104071062500000000000000000000000000000e-1 * t413 + 0.19451907596748125343750000000000000000000000000000e0 * t397 + 0.52279783829707640062500000000000000000000000000000e-1 * t415 - 0.5923137049970073437500000000000000000000000000000e-2 * t412 + 0.73000610738035552687500000000000000000000000000000e-1 * t546
  t669 = t483 + t544 + t631 + t667
  t673 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t357 * t669)
  t674 = t6 ** 2
  t676 = t16 / t674
  t677 = t7 - t676
  t678 = f.my_piecewise5(t10, 0, t14, 0, t677)
  t681 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t678)
  t686 = t26 ** 2
  t687 = 0.1e1 / t686
  t691 = t5 * t25 * t687 * t345 / 0.8e1
  t695 = s0 / t36 / t34 / r0
  t697 = t33 * t695 * t43
  t699 = t28 ** 2
  t702 = t699 / t30 / t29
  t703 = s0 ** 2
  t704 = t34 ** 2
  t709 = t42 ** 2
  t710 = 0.1e1 / t709
  t712 = t702 * t703 / t35 / t704 / t34 * t710
  t716 = -0.2e1 / 0.9e1 * t697 + t712 / 0.108e3
  t717 = t50 * t716
  t719 = t49 * t716
  t721 = t48 * t716
  t740 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t38 + t695 / 0.3e1) * t28 * t32
  t741 = f.my_piecewise3(t65, t740, 0)
  t747 = 0.1e1 / t73 / t66
  t751 = t80 * t87
  t752 = f.my_piecewise3(t65, 0, t740)
  t756 = t86 ** 2
  t758 = t81 / t756
  t759 = t78 * t84
  t762 = t78 ** 2
  t763 = t762 * t77
  t769 = f.my_piecewise3(t64, -0.3e1 / 0.2e1 * t71 * t741 - 0.3e1 / 0.16e2 * t74 * t741 + 0.3e1 * t747 * t741, -0.6e1 * t751 * t77 * t752 - t758 * (0.3e1 * t759 * t752 + 0.12e2 * t763 * t752))
  t770 = t112 * t769
  t772 = t90 * t769
  t775 = 0.315e3 / 0.8e1 * t770 - 0.105e3 / 0.4e1 * t772 + 0.15e2 / 0.8e1 * t769
  t777 = t123 * t769
  t782 = 0.3003e4 / 0.16e2 * t777 - 0.3465e4 / 0.16e2 * t770 + 0.945e3 / 0.16e2 * t772 - 0.35e2 / 0.16e2 * t769
  t791 = t115 * t769
  t793 = t96 * t769
  t795 = t89 * t769
  t797 = 0.693e3 / 0.8e1 * t791 - 0.315e3 / 0.4e1 * t793 + 0.105e3 / 0.8e1 * t795
  t816 = 0.35e2 / 0.2e1 * t793 - 0.15e2 / 0.2e1 * t795
  t826 = 0.29722341099413095652777777777777777777777777777779e-1 * t697 - 0.12384308791422123188657407407407407407407407407408e-2 * t712 + (-0.55323715279307820345000000000000000000000000000000e-1 * t717 + 0.63835056091509023475000000000000000000000000000000e-1 * t719 - 0.17409560752229733675000000000000000000000000000000e-1 * t721 - 0.14328856586197311666666666666666666666666666666667e-3 * t697 + 0.59703569109155465277777777777777777777777777777778e-5 * t712) * t119 + (0.72745666391090414596875000000000000000000000000000e0 * t717 - 0.83937307374335093765625000000000000000000000000000e0 * t719 + 0.22891992920273207390625000000000000000000000000000e0 * t721 + 0.18841146436438853819444444444444444444444444444445e-2 * t697 - 0.78504776818495224247685185185185185185185185185186e-4 * t712) * t134 + t305 * t775 + t330 * t782 + (-0.35839190838072170298750000000000000000000000000000e-1 * t717 + 0.41352912505467888806250000000000000000000000000000e-1 * t719 - 0.11278067046945787856250000000000000000000000000000e-1 * t721 - 0.92823597094204015277777777777777777777777777777779e-4 * t697 + 0.38676498789251673032407407407407407407407407407408e-5 * t712) * t127 + t299 * t797 + (0.32488013665979123752500000000000000000000000000000e-1 * t717 - 0.37486169614591296637500000000000000000000000000000e-1 * t719 + 0.10223500803979444537500000000000000000000000000000e-1 * t721 + 0.84144039538925469444444444444444444444444444444445e-4 * t697 - 0.35060016474552278935185185185185185185185185185186e-5 * t712) * t89 + t263 * t769 + (-0.58913379072588789498750000000000000000000000000000e-1 * t717 + 0.67976975852987064806250000000000000000000000000000e-1 * t719 - 0.18539175232632835856250000000000000000000000000000e-1 * t721 - 0.15258580438380934861111111111111111111111111111111e-3 * t697 + 0.63577418493253895254629629629629629629629629629630e-5 * t712) * t140 + t312 * t816 + (0.20131885971298243642500000000000000000000000000000e1 * t717 - 0.23229099197651819587500000000000000000000000000000e1 * t719 + 0.63352088720868598875000000000000000000000000000000e0 * t721 + 0.52141636807299258333333333333333333333333333333333e-2 * t697 - 0.21725682003041357638888888888888888888888888888889e-3 * t712) * t99 + t278 * t775
  t827 = t212 * t716
  t829 = t101 * t716
  t831 = t47 * t716
  t838 = 0.15e2 / 0.2e1 * t772 - 0.3e1 / 0.2e1 * t769
  t874 = (-0.15728039028245941897500000000000000000000000000000e-1 * t827 + 0.14298217298405401725000000000000000000000000000000e-1 * t829 - 0.23830362164009002875000000000000000000000000000000e-2 * t831) * t119 + t268 * t782 + t318 * t838 + (-0.18895820367784253643750000000000000000000000000000e1 * t717 + 0.21802869655135677281250000000000000000000000000000e1 * t719 - 0.59462371786733665312500000000000000000000000000000e0 * t721 - 0.48940223692784909722222222222222222222222222222221e-2 * t697 + 0.20391759871993712384259259259259259259259259259259e-3 * t712) * t92 - 0.28142938497823438038750000000000000000000000000000e0 * t717 + (0.72479774163284195400000000000000000000000000000000e-1 * t827 - 0.65890703784803814000000000000000000000000000000000e-1 * t829 + 0.10981783964133969000000000000000000000000000000000e-1 * t831) * t140 + t283 * t816 + (0.16149646244247680587500000000000000000000000000000e0 * t827 - 0.14681496585679709625000000000000000000000000000000e0 * t829 + 0.24469160976132849375000000000000000000000000000000e-1 * t831) * t127 + t273 * t797 + (-0.27110625101785230390000000000000000000000000000000e0 * t827 + 0.24646022819804754900000000000000000000000000000000e0 * t829 - 0.41076704699674591500000000000000000000000000000000e-1 * t831) * t134 + 0.43800366442821331612500000000000000000000000000000e0 * t827 + t210 * t769 + (-0.20451606009930529875000000000000000000000000000000e-1 * t719 + 0.13634404006620353250000000000000000000000000000000e-1 * t721 + 0.21641911121619608333333333333333333333333333333333e-3 * t697 - 0.90174629673415034722222222222222222222222222222222e-5 * t712) * t119 + t216 * t782
  t895 = t146 * t89
  t898 = t104 * t89
  t901 = t181 * t89
  t904 = t243 * t89
  t907 = t293 * t89
  t910 = t324 * t89
  t913 = t55 * t89
  t916 = (-0.79657887063377058975000000000000000000000000000000e0 * t827 + 0.72416260966706417250000000000000000000000000000000e0 * t829 - 0.12069376827784402875000000000000000000000000000000e0 * t831) * t99 + t288 * t838 + (-0.66108783714833674237500000000000000000000000000000e0 * t827 + 0.60098894286212431125000000000000000000000000000000e0 * t829 - 0.10016482381035405187500000000000000000000000000000e0 * t831) * t92 + 0.25448301445575582000000000000000000000000000000000e-3 * t831 * t134 + 0.95414797078251930000000000000000000000000000000000e-3 * t831 * t140 - 0.26011607116438383000000000000000000000000000000000e-2 * t831 * t99 - 0.25059937895101080000000000000000000000000000000000e-2 * t831 * t92 + 0.3e1 * t895 * t769 + 0.3e1 * t898 * t769 + 0.3e1 * t901 * t769 + 0.3e1 * t904 * t769 + 0.3e1 * t907 * t769 + 0.3e1 * t910 * t769 + 0.3e1 * t913 * t769
  t961 = -0.39406812755488791000000000000000000000000000000000e-1 * t831 * t89 + 0.56817065229729237000000000000000000000000000000000e-3 * t831 * t119 - 0.27146561728928226000000000000000000000000000000000e-2 * t831 * t127 + 0.19451907596748125343750000000000000000000000000000e0 * t769 + (-0.55505135827774473333333333333333333333333333333333e-3 * t697 + 0.23127139928239363888888888888888888888888888888889e-4 * t712) * t99 + t95 * t838 + (0.24434174127676885976250000000000000000000000000000e0 * t827 - 0.22212885570615350887500000000000000000000000000000e0 * t829 + 0.37021475951025584812500000000000000000000000000000e-1 * t831) * t89 + t228 * t775 + (-0.40356075865519945125000000000000000000000000000000e-1 * t719 + 0.26904050577013296750000000000000000000000000000000e-1 * t721 + 0.42704842185735391666666666666666666666666666666667e-3 * t697 - 0.17793684244056413194444444444444444444444444444444e-4 * t712) * t140 + t233 * t816 + (-0.29749609915980499125000000000000000000000000000000e0 * t719 + 0.19833073277320332750000000000000000000000000000000e0 * t721 + 0.31481068694159258333333333333333333333333333333333e-2 * t697 - 0.13117111955899690972222222222222222222222222222222e-3 * t712) * t127 + t221 * t797 + (-0.15175714938516591243750000000000000000000000000000e0 * t719 + 0.10117143292344394162500000000000000000000000000000e0 * t721 + 0.16058957606895863750000000000000000000000000000000e-2 * t697 - 0.66912323362066098958333333333333333333333333333333e-4 * t712) * t134 + (-0.65398947448397979937500000000000000000000000000000e-1 * t719 + 0.43599298298931986625000000000000000000000000000000e-1 * t721 + 0.69205235395130137500000000000000000000000000000000e-3 * t697 - 0.28835514747970890625000000000000000000000000000000e-4 * t712) * t89
  t1003 = 0.25098623535341656518750000000000000000000000000000e0 * t719 + t248 * t769 + (-0.31372202827502810000000000000000000000000000000000e-3 * t829 + 0.13445229783215490000000000000000000000000000000000e-3 * t831) * t119 + t252 * t782 + (-0.14395547581531767000000000000000000000000000000000e-2 * t719 + 0.95970317210211780000000000000000000000000000000000e-3 * t721 + 0.15233383684160600000000000000000000000000000000000e-4 * t697 - 0.63472432017335833333333333333333333333333333333333e-6 * t712) * t99 + t238 * t838 + (0.19931329888701308437500000000000000000000000000000e0 * t719 - 0.13287553259134205625000000000000000000000000000000e0 * t721 - 0.21091354379578104166666666666666666666666666666667e-2 * t697 + 0.87880643248242100694444444444444444444444444444444e-4 * t712) * t92 + (-0.36926557942570530500000000000000000000000000000000e-1 * t829 + 0.15825667689673084500000000000000000000000000000000e-1 * t831) * t89 + t169 * t775 + (0.17309872529212490500000000000000000000000000000000e-1 * t829 - 0.74185167982339245000000000000000000000000000000000e-2 * t831) * t140 + t173 * t816 + (0.23306453795076795000000000000000000000000000000000e-2 * t829 - 0.99884801978900550000000000000000000000000000000000e-3 * t831) * t127 + t256 * t797 + (-0.12706936120949050750000000000000000000000000000000e-2 * t829 + 0.54458297661210217500000000000000000000000000000000e-3 * t831) * t134
  t1036 = t193 * t797 + (-0.14531910974209701000000000000000000000000000000000e-2 * t721 - 0.64586270996487560000000000000000000000000000000000e-4 * t697 + 0.26910946248536483333333333333333333333333333333333e-5 * t712) * t134 + t197 * t775 + t185 * t769 + (0.32314244502066637500000000000000000000000000000000e-2 * t721 + 0.14361886445362950000000000000000000000000000000000e-3 * t697 - 0.59841193522345625000000000000000000000000000000000e-5 * t712) * t119 + t189 * t782 + (-0.44997427919967477500000000000000000000000000000000e-2 * t829 + 0.19284611965700347500000000000000000000000000000000e-2 * t831) * t99 - 0.22833790496685041125000000000000000000000000000000e0 * t829 - 0.76461881870812536187500000000000000000000000000000e0 * t831 + t177 * t838 + (-0.26037690300597365250000000000000000000000000000000e-1 * t829 + 0.11159010128827442250000000000000000000000000000000e-1 * t831) * t92 + t111 * t782 + t122 * t797 + (-0.58676911042618642500000000000000000000000000000000e-3 * t721 - 0.26078627130052730000000000000000000000000000000000e-4 * t697 + 0.10866094637521970833333333333333333333333333333333e-5 * t712) * t92
  t1077 = -0.24142521896743737562500000000000000000000000000000e-1 * t721 + (-0.12617572159509221250000000000000000000000000000000e0 * t721 - 0.56078098486707650000000000000000000000000000000000e-2 * t697 + 0.23365874369461520833333333333333333333333333333333e-3 * t712) * t89 + t108 * t769 + (-0.35283272492106570000000000000000000000000000000000e-1 * t721 - 0.15681454440936253333333333333333333333333333333333e-2 * t697 + 0.65339393503901055555555555555555555555555555555556e-4 * t712) * t140 + t201 * t816 + (0.20866548239672089500000000000000000000000000000000e-1 * t721 + 0.92740214398542620000000000000000000000000000000000e-3 * t697 - 0.38641755999392758333333333333333333333333333333333e-4 * t712) * t99 + t205 * t838 + (-0.51727154568297075000000000000000000000000000000000e-2 * t721 - 0.22989846474798700000000000000000000000000000000000e-3 * t697 + 0.95791026978327916666666666666666666666666666666667e-5 * t712) * t127 - 0.17769411149910220312500000000000000000000000000000e-1 * t772 + (-0.26959173497649542222222222222222222222222222222221e-1 * t697 + 0.11232988957353975925925925925925925925925925925926e-2 * t712) * t89 + t165 * t769 + (-0.27425143642323093333333333333333333333333333333333e-3 * t697 + 0.11427143184301288888888888888888888888888888888889e-4 * t712) * t92 + (-0.36528272025649713333333333333333333333333333333333e-3 * t697 + 0.15220113344020713888888888888888888888888888888889e-4 * t712) * t134 + t159 * t775
  t1102 = 0.26139891914853820031250000000000000000000000000000e0 * t770 + (-0.11332423773234814666666666666666666666666666666667e-2 * t697 + 0.47218432388478394444444444444444444444444444444444e-4 * t712) * t140 + t162 * t816 - 0.49149175060229317850000000000000000000000000000000e-1 * t793 + 0.12711844558663081725000000000000000000000000000000e-1 * t795 + (-0.13267302584610593333333333333333333333333333333333e-3 * t697 + 0.55280427435877472222222222222222222222222222222222e-5 * t712) * t127 + t155 * t797 + 0.26485532388814614885000000000000000000000000000000e-1 * t791 + t149 * t769 + (-0.51466702591933408888888888888888888888888888888888e-3 * t697 + 0.21444459413305587037037037037037037037037037037037e-4 * t712) * t119 + t152 * t782 - 0.38012670012172849743750000000000000000000000000000e0 * t777 + t137 * t816 + t143 * t838 + t130 * t775
  t1110 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t681 * t26 * t345 - t691 - 0.3e1 / 0.8e1 * t5 * t27 * (t826 + t874 + t916 + t961 + t1003 + t1036 + t1077 + t1102))
  t1112 = f.my_piecewise5(t14, 0, t10, 0, -t677)
  t1115 = f.my_piecewise3(t353, 0, 0.4e1 / 0.3e1 * t354 * t1112)
  t1123 = t5 * t356 * t687 * t669 / 0.8e1
  t1125 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t1115 * t26 * t669 - t1123)
  vrho_0_ = t349 + t673 + t6 * (t1110 + t1125)
  t1128 = -t7 - t676
  t1129 = f.my_piecewise5(t10, 0, t14, 0, t1128)
  t1132 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t1129)
  t1138 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1132 * t26 * t345 - t691)
  t1140 = f.my_piecewise5(t14, 0, t10, 0, -t1128)
  t1143 = f.my_piecewise3(t353, 0, 0.4e1 / 0.3e1 * t354 * t1140)
  t1151 = s2 / t359 / t363 / r1
  t1153 = t33 * t1151 * t407
  t1155 = s2 ** 2
  t1156 = t363 ** 2
  t1161 = t406 ** 2
  t1162 = 0.1e1 / t1161
  t1164 = t702 * t1155 / t358 / t1156 / t363 * t1162
  t1178 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau1 * t365 + t1151 / 0.3e1) * t28 * t32
  t1179 = f.my_piecewise3(t373, t1178, 0)
  t1185 = 0.1e1 / t381 / t374
  t1189 = t388 * t395
  t1190 = f.my_piecewise3(t373, 0, t1178)
  t1194 = t394 ** 2
  t1196 = t389 / t1194
  t1197 = t386 * t392
  t1200 = t386 ** 2
  t1201 = t1200 * t385
  t1207 = f.my_piecewise3(t372, -0.3e1 / 0.2e1 * t379 * t1179 - 0.3e1 / 0.16e2 * t382 * t1179 + 0.3e1 * t1185 * t1179, -0.6e1 * t1189 * t385 * t1190 - t1196 * (0.3e1 * t1197 * t1190 + 0.12e2 * t1201 * t1190))
  t1213 = t412 * t1207
  t1215 = t397 * t1207
  t1217 = 0.35e2 / 0.2e1 * t1213 - 0.15e2 / 0.2e1 * t1215
  t1225 = t398 * t1207
  t1228 = 0.15e2 / 0.2e1 * t1225 - 0.3e1 / 0.2e1 * t1207
  t1235 = t415 * t1207
  t1239 = 0.693e3 / 0.8e1 * t1235 - 0.315e3 / 0.4e1 * t1213 + 0.105e3 / 0.8e1 * t1215
  t1246 = (-0.27425143642323093333333333333333333333333333333333e-3 * t1153 + 0.11427143184301288888888888888888888888888888888889e-4 * t1164) * t450 + (-0.26959173497649542222222222222222222222222222222221e-1 * t1153 + 0.11232988957353975925925925925925925925925925925926e-2 * t1164) * t397 + t453 * t1207 + (-0.11332423773234814666666666666666666666666666666667e-2 * t1153 + 0.47218432388478394444444444444444444444444444444444e-4 * t1164) * t439 + t436 * t1217 - 0.49149175060229317850000000000000000000000000000000e-1 * t1213 + 0.12711844558663081725000000000000000000000000000000e-1 * t1215 + (-0.55505135827774473333333333333333333333333333333333e-3 * t1153 + 0.23127139928239363888888888888888888888888888888889e-4 * t1164) * t445 + t442 * t1228 - 0.17769411149910220312500000000000000000000000000000e-1 * t1225 + (-0.13267302584610593333333333333333333333333333333333e-3 * t1153 + 0.55280427435877472222222222222222222222222222222222e-5 * t1164) * t426 + t422 * t1239 + 0.26485532388814614885000000000000000000000000000000e-1 * t1235 + (-0.36528272025649713333333333333333333333333333333333e-3 * t1153 + 0.15220113344020713888888888888888888888888888888889e-4 * t1164) * t433
  t1247 = t399 * t1207
  t1251 = 0.315e3 / 0.8e1 * t1247 - 0.105e3 / 0.4e1 * t1225 + 0.15e2 / 0.8e1 * t1207
  t1258 = t400 * t1207
  t1263 = 0.3003e4 / 0.16e2 * t1258 - 0.3465e4 / 0.16e2 * t1247 + 0.945e3 / 0.16e2 * t1225 - 0.35e2 / 0.16e2 * t1207
  t1273 = -0.2e1 / 0.9e1 * t1153 + t1164 / 0.108e3
  t1274 = t457 * t1273
  t1283 = t429 * t1251 + 0.26139891914853820031250000000000000000000000000000e0 * t1247 + (-0.51466702591933408888888888888888888888888888888888e-3 * t1153 + 0.21444459413305587037037037037037037037037037037037e-4 * t1164) * t419 + t411 * t1263 - 0.38012670012172849743750000000000000000000000000000e0 * t1258 + t497 * t1228 + t503 * t1207 + t494 * t1217 + t488 * t1239 + t491 * t1251 + (-0.12617572159509221250000000000000000000000000000000e0 * t1274 - 0.56078098486707650000000000000000000000000000000000e-2 * t1153 + 0.23365874369461520833333333333333333333333333333333e-3 * t1164) * t397 - 0.24142521896743737562500000000000000000000000000000e-1 * t1274 + t481 * t1207 + t485 * t1263
  t1314 = t458 * t1273
  t1316 = t456 * t1273
  t1328 = (0.20866548239672089500000000000000000000000000000000e-1 * t1274 + 0.92740214398542620000000000000000000000000000000000e-3 * t1153 - 0.38641755999392758333333333333333333333333333333333e-4 * t1164) * t445 + t473 * t1228 + (-0.58676911042618642500000000000000000000000000000000e-3 * t1274 - 0.26078627130052730000000000000000000000000000000000e-4 * t1153 + 0.10866094637521970833333333333333333333333333333333e-5 * t1164) * t450 + (-0.14531910974209701000000000000000000000000000000000e-2 * t1274 - 0.64586270996487560000000000000000000000000000000000e-4 * t1153 + 0.26910946248536483333333333333333333333333333333333e-5 * t1164) * t433 + t465 * t1251 + (-0.35283272492106570000000000000000000000000000000000e-1 * t1274 - 0.15681454440936253333333333333333333333333333333333e-2 * t1153 + 0.65339393503901055555555555555555555555555555555556e-4 * t1164) * t439 + t469 * t1217 + (-0.51727154568297075000000000000000000000000000000000e-2 * t1274 - 0.22989846474798700000000000000000000000000000000000e-3 * t1153 + 0.95791026978327916666666666666666666666666666666667e-5 * t1164) * t426 + t461 * t1239 + (-0.36926557942570530500000000000000000000000000000000e-1 * t1314 + 0.15825667689673084500000000000000000000000000000000e-1 * t1316) * t397 - 0.22833790496685041125000000000000000000000000000000e0 * t1314 - 0.76461881870812536187500000000000000000000000000000e0 * t1316 + t538 * t1207 + (0.32314244502066637500000000000000000000000000000000e-2 * t1274 + 0.14361886445362950000000000000000000000000000000000e-3 * t1153 - 0.59841193522345625000000000000000000000000000000000e-5 * t1164) * t419
  t1354 = t505 * t1273
  t1367 = t542 * t1263 + t526 * t1217 + (-0.44997427919967477500000000000000000000000000000000e-2 * t1314 + 0.19284611965700347500000000000000000000000000000000e-2 * t1316) * t445 + t530 * t1228 + (-0.26037690300597365250000000000000000000000000000000e-1 * t1314 + 0.11159010128827442250000000000000000000000000000000e-1 * t1316) * t450 + (-0.12706936120949050750000000000000000000000000000000e-2 * t1314 + 0.54458297661210217500000000000000000000000000000000e-3 * t1316) * t433 + t522 * t1251 + (0.17309872529212490500000000000000000000000000000000e-1 * t1314 - 0.74185167982339245000000000000000000000000000000000e-2 * t1316) * t439 + (0.23306453795076795000000000000000000000000000000000e-2 * t1314 - 0.99884801978900550000000000000000000000000000000000e-3 * t1316) * t426 + t518 * t1239 + (-0.65398947448397979937500000000000000000000000000000e-1 * t1354 + 0.43599298298931986625000000000000000000000000000000e-1 * t1274 + 0.69205235395130137500000000000000000000000000000000e-3 * t1153 - 0.28835514747970890625000000000000000000000000000000e-4 * t1164) * t397 + 0.25098623535341656518750000000000000000000000000000e0 * t1354 + t510 * t1207 + (-0.31372202827502810000000000000000000000000000000000e-3 * t1314 + 0.13445229783215490000000000000000000000000000000000e-3 * t1316) * t419
  t1405 = t506 * t1273
  t1419 = t514 * t1263 + t580 * t1217 + (-0.14395547581531767000000000000000000000000000000000e-2 * t1354 + 0.95970317210211780000000000000000000000000000000000e-3 * t1274 + 0.15233383684160600000000000000000000000000000000000e-4 * t1153 - 0.63472432017335833333333333333333333333333333333333e-6 * t1164) * t445 + t585 * t1228 + (0.19931329888701308437500000000000000000000000000000e0 * t1354 - 0.13287553259134205625000000000000000000000000000000e0 * t1274 - 0.21091354379578104166666666666666666666666666666667e-2 * t1153 + 0.87880643248242100694444444444444444444444444444444e-4 * t1164) * t450 + (-0.15175714938516591243750000000000000000000000000000e0 * t1354 + 0.10117143292344394162500000000000000000000000000000e0 * t1274 + 0.16058957606895863750000000000000000000000000000000e-2 * t1153 - 0.66912323362066098958333333333333333333333333333333e-4 * t1164) * t433 + t575 * t1251 + (-0.40356075865519945125000000000000000000000000000000e-1 * t1354 + 0.26904050577013296750000000000000000000000000000000e-1 * t1274 + 0.42704842185735391666666666666666666666666666666667e-3 * t1153 - 0.17793684244056413194444444444444444444444444444444e-4 * t1164) * t439 + (-0.29749609915980499125000000000000000000000000000000e0 * t1354 + 0.19833073277320332750000000000000000000000000000000e0 * t1274 + 0.31481068694159258333333333333333333333333333333333e-2 * t1153 - 0.13117111955899690972222222222222222222222222222222e-3 * t1164) * t426 + t570 * t1239 + (0.24434174127676885976250000000000000000000000000000e0 * t1405 - 0.22212885570615350887500000000000000000000000000000e0 * t1314 + 0.37021475951025584812500000000000000000000000000000e-1 * t1316) * t397 + 0.43800366442821331612500000000000000000000000000000e0 * t1405 + t560 * t1207 + (-0.20451606009930529875000000000000000000000000000000e-1 * t1354 + 0.13634404006620353250000000000000000000000000000000e-1 * t1274 + 0.21641911121619608333333333333333333333333333333333e-3 * t1153 - 0.90174629673415034722222222222222222222222222222222e-5 * t1164) * t419
  t1450 = t546 * t1273
  t1465 = t565 * t1263 + (-0.79657887063377058975000000000000000000000000000000e0 * t1405 + 0.72416260966706417250000000000000000000000000000000e0 * t1314 - 0.12069376827784402875000000000000000000000000000000e0 * t1316) * t445 + t550 * t1228 + (-0.66108783714833674237500000000000000000000000000000e0 * t1405 + 0.60098894286212431125000000000000000000000000000000e0 * t1314 - 0.10016482381035405187500000000000000000000000000000e0 * t1316) * t450 + (-0.27110625101785230390000000000000000000000000000000e0 * t1405 + 0.24646022819804754900000000000000000000000000000000e0 * t1314 - 0.41076704699674591500000000000000000000000000000000e-1 * t1316) * t433 + t624 * t1251 + (0.72479774163284195400000000000000000000000000000000e-1 * t1405 - 0.65890703784803814000000000000000000000000000000000e-1 * t1314 + 0.10981783964133969000000000000000000000000000000000e-1 * t1316) * t439 + t629 * t1217 + (0.16149646244247680587500000000000000000000000000000e0 * t1405 - 0.14681496585679709625000000000000000000000000000000e0 * t1314 + 0.24469160976132849375000000000000000000000000000000e-1 * t1316) * t426 + t619 * t1239 + (0.32488013665979123752500000000000000000000000000000e-1 * t1450 - 0.37486169614591296637500000000000000000000000000000e-1 * t1354 + 0.10223500803979444537500000000000000000000000000000e-1 * t1274 + 0.84144039538925469444444444444444444444444444444445e-4 * t1153 - 0.35060016474552278935185185185185185185185185185186e-5 * t1164) * t397 - 0.28142938497823438038750000000000000000000000000000e0 * t1450 + t609 * t1207 + (-0.15728039028245941897500000000000000000000000000000e-1 * t1405 + 0.14298217298405401725000000000000000000000000000000e-1 * t1314 - 0.23830362164009002875000000000000000000000000000000e-2 * t1316) * t419
  t1515 = t448 * t397
  t1520 = t614 * t1263 + (0.20131885971298243642500000000000000000000000000000e1 * t1450 - 0.23229099197651819587500000000000000000000000000000e1 * t1354 + 0.63352088720868598875000000000000000000000000000000e0 * t1274 + 0.52141636807299258333333333333333333333333333333333e-2 * t1153 - 0.21725682003041357638888888888888888888888888888889e-3 * t1164) * t445 + t597 * t1228 + (-0.18895820367784253643750000000000000000000000000000e1 * t1450 + 0.21802869655135677281250000000000000000000000000000e1 * t1354 - 0.59462371786733665312500000000000000000000000000000e0 * t1274 - 0.48940223692784909722222222222222222222222222222221e-2 * t1153 + 0.20391759871993712384259259259259259259259259259259e-3 * t1164) * t450 + (-0.58913379072588789498750000000000000000000000000000e-1 * t1450 + 0.67976975852987064806250000000000000000000000000000e-1 * t1354 - 0.18539175232632835856250000000000000000000000000000e-1 * t1274 - 0.15258580438380934861111111111111111111111111111111e-3 * t1153 + 0.63577418493253895254629629629629629629629629629630e-5 * t1164) * t439 + t654 * t1217 + (-0.35839190838072170298750000000000000000000000000000e-1 * t1450 + 0.41352912505467888806250000000000000000000000000000e-1 * t1354 - 0.11278067046945787856250000000000000000000000000000e-1 * t1274 - 0.92823597094204015277777777777777777777777777777779e-4 * t1153 + 0.38676498789251673032407407407407407407407407407408e-5 * t1164) * t426 + t642 * t1239 + (0.72745666391090414596875000000000000000000000000000e0 * t1450 - 0.83937307374335093765625000000000000000000000000000e0 * t1354 + 0.22891992920273207390625000000000000000000000000000e0 * t1274 + 0.18841146436438853819444444444444444444444444444445e-2 * t1153 - 0.78504776818495224247685185185185185185185185185186e-4 * t1164) * t433 + t648 * t1251 + (-0.55323715279307820345000000000000000000000000000000e-1 * t1450 + 0.63835056091509023475000000000000000000000000000000e-1 * t1354 - 0.17409560752229733675000000000000000000000000000000e-1 * t1274 - 0.14328856586197311666666666666666666666666666666667e-3 * t1153 + 0.59703569109155465277777777777777777777777777777778e-5 * t1164) * t419 + t636 * t1263 + 0.3e1 * t1515 * t1207 - 0.26011607116438383000000000000000000000000000000000e-2 * t1316 * t445
  t1523 = t500 * t397
  t1536 = t477 * t397
  t1539 = t534 * t397
  t1542 = t590 * t397
  t1545 = t555 * t397
  t1548 = t603 * t397
  t1554 = -0.25059937895101080000000000000000000000000000000000e-2 * t1316 * t450 + 0.3e1 * t1523 * t1207 - 0.39406812755488791000000000000000000000000000000000e-1 * t1316 * t397 + 0.56817065229729237000000000000000000000000000000000e-3 * t1316 * t419 - 0.27146561728928226000000000000000000000000000000000e-2 * t1316 * t426 + 0.25448301445575582000000000000000000000000000000000e-3 * t1316 * t433 + 0.95414797078251930000000000000000000000000000000000e-3 * t1316 * t439 + 0.3e1 * t1536 * t1207 + 0.3e1 * t1539 * t1207 + 0.3e1 * t1542 * t1207 + 0.3e1 * t1545 * t1207 + 0.3e1 * t1548 * t1207 + 0.29722341099413095652777777777777777777777777777779e-1 * t1153 - 0.12384308791422123188657407407407407407407407407408e-2 * t1164 + 0.19451907596748125343750000000000000000000000000000e0 * t1207
  t1562 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t1143 * t26 * t669 - t1123 - 0.3e1 / 0.8e1 * t5 * t357 * (t1246 + t1283 + t1328 + t1367 + t1419 + t1465 + t1520 + t1554))
  vrho_1_ = t349 + t673 + t6 * (t1138 + t1562)
  t1566 = 0.5e1 / 0.72e2 * t33 * t38
  t1567 = f.my_piecewise3(t65, -t1566, 0)
  t1575 = f.my_piecewise3(t65, 0, -t1566)
  t1586 = f.my_piecewise3(t64, -0.3e1 / 0.2e1 * t71 * t1567 - 0.3e1 / 0.16e2 * t74 * t1567 + 0.3e1 * t747 * t1567, -0.6e1 * t751 * t77 * t1575 - t758 * (0.3e1 * t759 * t1575 + 0.12e2 * t763 * t1575))
  t1588 = t115 * t1586
  t1590 = t96 * t1586
  t1592 = t89 * t1586
  t1594 = 0.693e3 / 0.8e1 * t1588 - 0.315e3 / 0.4e1 * t1590 + 0.105e3 / 0.8e1 * t1592
  t1600 = t33 * t38 * t43
  t1607 = t702 * s0 / t35 / t704 / r0 * t710
  t1609 = t1600 / 0.12e2 - t1607 / 0.288e3
  t1610 = t48 * t1609
  t1616 = t123 * t1586
  t1618 = t112 * t1586
  t1620 = t90 * t1586
  t1623 = 0.3003e4 / 0.16e2 * t1616 - 0.3465e4 / 0.16e2 * t1618 + 0.945e3 / 0.16e2 * t1620 - 0.35e2 / 0.16e2 * t1586
  t1625 = t49 * t1609
  t1635 = 0.15e2 / 0.2e1 * t1620 - 0.3e1 / 0.2e1 * t1586
  t1655 = t50 * t1609
  t1663 = 0.19451907596748125343750000000000000000000000000000e0 * t1586 + t122 * t1594 + 0.26485532388814614885000000000000000000000000000000e-1 * t1588 - 0.49149175060229317850000000000000000000000000000000e-1 * t1590 + 0.12711844558663081725000000000000000000000000000000e-1 * t1592 + (-0.58676911042618642500000000000000000000000000000000e-3 * t1610 + 0.97794851737697737500000000000000000000000000000000e-5 * t1600 - 0.40747854890707390625000000000000000000000000000000e-6 * t1607) * t92 + t252 * t1623 + (-0.14395547581531767000000000000000000000000000000000e-2 * t1625 + 0.95970317210211780000000000000000000000000000000000e-3 * t1610 - 0.57125188815602250000000000000000000000000000000000e-5 * t1600 + 0.23802162006500937500000000000000000000000000000000e-6 * t1607) * t99 + 0.25098623535341656518750000000000000000000000000000e0 * t1625 + t238 * t1635 + (0.19931329888701308437500000000000000000000000000000e0 * t1625 - 0.13287553259134205625000000000000000000000000000000e0 * t1610 + 0.79092578923417890625000000000000000000000000000000e-3 * t1600 - 0.32955241218090787760416666666666666666666666666667e-4 * t1607) * t92 + (-0.65398947448397979937500000000000000000000000000000e-1 * t1625 + 0.43599298298931986625000000000000000000000000000000e-1 * t1610 - 0.25951963273173801562500000000000000000000000000000e-3 * t1600 + 0.10813318030489083984375000000000000000000000000000e-4 * t1607) * t89 + (-0.40356075865519945125000000000000000000000000000000e-1 * t1625 + 0.26904050577013296750000000000000000000000000000000e-1 * t1610 - 0.16014315819650771875000000000000000000000000000000e-3 * t1600 + 0.66726315915211549479166666666666666666666666666667e-5 * t1607) * t140 + (-0.58913379072588789498750000000000000000000000000000e-1 * t1655 + 0.67976975852987064806250000000000000000000000000000e-1 * t1625 - 0.18539175232632835856250000000000000000000000000000e-1 * t1610 + 0.57219676643928505729166666666666666666666666666667e-4 * t1600 - 0.23841531934970210720486111111111111111111111111111e-5 * t1607) * t140
  t1666 = 0.35e2 / 0.2e1 * t1590 - 0.15e2 / 0.2e1 * t1592
  t1684 = t212 * t1609
  t1686 = t101 * t1609
  t1688 = t47 * t1609
  t1716 = t312 * t1666 + (0.20131885971298243642500000000000000000000000000000e1 * t1655 - 0.23229099197651819587500000000000000000000000000000e1 * t1625 + 0.63352088720868598875000000000000000000000000000000e0 * t1610 - 0.19553113802737221875000000000000000000000000000000e-2 * t1600 + 0.81471307511405091145833333333333333333333333333333e-4 * t1607) * t99 + t318 * t1635 + (0.72745666391090414596875000000000000000000000000000e0 * t1655 - 0.83937307374335093765625000000000000000000000000000e0 * t1625 + 0.22891992920273207390625000000000000000000000000000e0 * t1610 - 0.70654299136645701822916666666666666666666666666667e-3 * t1600 + 0.29439291306935709092881944444444444444444444444445e-4 * t1607) * t134 + t268 * t1623 + (0.16149646244247680587500000000000000000000000000000e0 * t1684 - 0.14681496585679709625000000000000000000000000000000e0 * t1686 + 0.24469160976132849375000000000000000000000000000000e-1 * t1688) * t127 + (-0.18895820367784253643750000000000000000000000000000e1 * t1655 + 0.21802869655135677281250000000000000000000000000000e1 * t1625 - 0.59462371786733665312500000000000000000000000000000e0 * t1610 + 0.18352583884794341145833333333333333333333333333333e-2 * t1600 - 0.76469099519976421440972222222222222222222222222221e-4 * t1607) * t92 - 0.28142938497823438038750000000000000000000000000000e0 * t1655 + (0.32488013665979123752500000000000000000000000000000e-1 * t1655 - 0.37486169614591296637500000000000000000000000000000e-1 * t1625 + 0.10223500803979444537500000000000000000000000000000e-1 * t1610 - 0.31554014827097051041666666666666666666666666666667e-4 * t1600 + 0.13147506177957104600694444444444444444444444444445e-5 * t1607) * t89 + t263 * t1586 + (-0.15728039028245941897500000000000000000000000000000e-1 * t1684 + 0.14298217298405401725000000000000000000000000000000e-1 * t1686 - 0.23830362164009002875000000000000000000000000000000e-2 * t1688) * t119 + 0.46441157967832961957465277777777777777777777777779e-3 * t1607 + t152 * t1623 + t137 * t1666
  t1722 = 0.315e3 / 0.8e1 * t1618 - 0.105e3 / 0.4e1 * t1620 + 0.15e2 / 0.8e1 * t1586
  t1754 = t143 * t1635 + t130 * t1722 + t330 * t1623 + t95 * t1635 + (0.10109690061618578333333333333333333333333333333333e-1 * t1600 - 0.42123708590077409722222222222222222222222222222221e-3 * t1607) * t89 + t165 * t1586 + (0.10284428865871160000000000000000000000000000000000e-3 * t1600 - 0.42851786941129833333333333333333333333333333333333e-5 * t1607) * t92 + (0.20814425935415427500000000000000000000000000000000e-3 * t1600 - 0.86726774730897614583333333333333333333333333333333e-5 * t1607) * t99 + (0.13698102009618642500000000000000000000000000000000e-3 * t1600 - 0.57075425040077677083333333333333333333333333333333e-5 * t1607) * t134 + t159 * t1722 + (0.42496589149630555000000000000000000000000000000000e-3 * t1600 - 0.17706912145679397916666666666666666666666666666667e-4 * t1607) * t140 + t162 * t1666 + (0.49752384692289725000000000000000000000000000000000e-4 * t1600 - 0.20730160288454052083333333333333333333333333333333e-5 * t1607) * t127 + t155 * t1594
  t1799 = t149 * t1586 + (0.19300013471975028333333333333333333333333333333333e-3 * t1600 - 0.80416722799895951388888888888888888888888888888888e-5 * t1607) * t119 + t305 * t1722 + (-0.35839190838072170298750000000000000000000000000000e-1 * t1655 + 0.41352912505467888806250000000000000000000000000000e-1 * t1625 - 0.11278067046945787856250000000000000000000000000000e-1 * t1610 + 0.34808848910326505729166666666666666666666666666667e-4 * t1600 - 0.14503687045969377387152777777777777777777777777778e-5 * t1607) * t127 + t299 * t1594 + (-0.55323715279307820345000000000000000000000000000000e-1 * t1655 + 0.63835056091509023475000000000000000000000000000000e-1 * t1625 - 0.17409560752229733675000000000000000000000000000000e-1 * t1610 + 0.53733212198239918750000000000000000000000000000000e-4 * t1600 - 0.22388838415933299479166666666666666666666666666667e-5 * t1607) * t119 - 0.11145877912279910869791666666666666666666666666667e-1 * t1600 + t233 * t1666 + (-0.29749609915980499125000000000000000000000000000000e0 * t1625 + 0.19833073277320332750000000000000000000000000000000e0 * t1610 - 0.11805400760309721875000000000000000000000000000000e-2 * t1600 + 0.49189169834623841145833333333333333333333333333333e-4 * t1607) * t127 + t221 * t1594 + (-0.15175714938516591243750000000000000000000000000000e0 * t1625 + 0.10117143292344394162500000000000000000000000000000e0 * t1610 - 0.60221091025859489062500000000000000000000000000000e-3 * t1600 + 0.25092121260774787109375000000000000000000000000000e-4 * t1607) * t134 + t228 * t1722 + t210 * t1586 + (-0.20451606009930529875000000000000000000000000000000e-1 * t1625 + 0.13634404006620353250000000000000000000000000000000e-1 * t1610 - 0.81157166706073531250000000000000000000000000000000e-4 * t1600 + 0.33815486127530638020833333333333333333333333333333e-5 * t1607) * t119
  t1839 = t216 * t1623 + (-0.79657887063377058975000000000000000000000000000000e0 * t1684 + 0.72416260966706417250000000000000000000000000000000e0 * t1686 - 0.12069376827784402875000000000000000000000000000000e0 * t1688) * t99 + 0.43800366442821331612500000000000000000000000000000e0 * t1684 + t288 * t1635 + (-0.66108783714833674237500000000000000000000000000000e0 * t1684 + 0.60098894286212431125000000000000000000000000000000e0 * t1686 - 0.10016482381035405187500000000000000000000000000000e0 * t1688) * t92 + (0.24434174127676885976250000000000000000000000000000e0 * t1684 - 0.22212885570615350887500000000000000000000000000000e0 * t1686 + 0.37021475951025584812500000000000000000000000000000e-1 * t1688) * t89 + (0.72479774163284195400000000000000000000000000000000e-1 * t1684 - 0.65890703784803814000000000000000000000000000000000e-1 * t1686 + 0.10981783964133969000000000000000000000000000000000e-1 * t1688) * t140 + t283 * t1666 + t273 * t1594 + (-0.27110625101785230390000000000000000000000000000000e0 * t1684 + 0.24646022819804754900000000000000000000000000000000e0 * t1686 - 0.41076704699674591500000000000000000000000000000000e-1 * t1688) * t134 + t278 * t1722 + 0.3e1 * t913 * t1586 + 0.25448301445575582000000000000000000000000000000000e-3 * t1688 * t134 + 0.95414797078251930000000000000000000000000000000000e-3 * t1688 * t140
  t1871 = -0.26011607116438383000000000000000000000000000000000e-2 * t1688 * t99 - 0.25059937895101080000000000000000000000000000000000e-2 * t1688 * t92 + 0.3e1 * t895 * t1586 - 0.39406812755488791000000000000000000000000000000000e-1 * t1688 * t89 + 0.3e1 * t898 * t1586 + 0.56817065229729237000000000000000000000000000000000e-3 * t1688 * t119 - 0.27146561728928226000000000000000000000000000000000e-2 * t1688 * t127 + 0.3e1 * t901 * t1586 + 0.3e1 * t904 * t1586 + 0.3e1 * t907 * t1586 + 0.3e1 * t910 * t1586 + (-0.44997427919967477500000000000000000000000000000000e-2 * t1686 + 0.19284611965700347500000000000000000000000000000000e-2 * t1688) * t99 + (0.23306453795076795000000000000000000000000000000000e-2 * t1686 - 0.99884801978900550000000000000000000000000000000000e-3 * t1688) * t127 + t256 * t1594
  t1906 = (-0.12706936120949050750000000000000000000000000000000e-2 * t1686 + 0.54458297661210217500000000000000000000000000000000e-3 * t1688) * t134 + t169 * t1722 + t248 * t1586 + (-0.31372202827502810000000000000000000000000000000000e-3 * t1686 + 0.13445229783215490000000000000000000000000000000000e-3 * t1688) * t119 + t197 * t1722 + (0.32314244502066637500000000000000000000000000000000e-2 * t1610 - 0.53857074170111062500000000000000000000000000000000e-4 * t1600 + 0.22440447570879609375000000000000000000000000000000e-5 * t1607) * t119 + t189 * t1623 + t177 * t1635 + (-0.26037690300597365250000000000000000000000000000000e-1 * t1686 + 0.11159010128827442250000000000000000000000000000000e-1 * t1688) * t92 - 0.22833790496685041125000000000000000000000000000000e0 * t1686 - 0.76461881870812536187500000000000000000000000000000e0 * t1688 + (-0.36926557942570530500000000000000000000000000000000e-1 * t1686 + 0.15825667689673084500000000000000000000000000000000e-1 * t1688) * t89 + t185 * t1586 + (0.17309872529212490500000000000000000000000000000000e-1 * t1686 - 0.74185167982339245000000000000000000000000000000000e-2 * t1688) * t140
  t1942 = t173 * t1666 - 0.24142521896743737562500000000000000000000000000000e-1 * t1610 + (-0.12617572159509221250000000000000000000000000000000e0 * t1610 + 0.21029286932515368750000000000000000000000000000000e-2 * t1600 - 0.87622028885480703125000000000000000000000000000000e-4 * t1607) * t89 + t108 * t1586 + t111 * t1623 - 0.38012670012172849743750000000000000000000000000000e0 * t1616 + 0.26139891914853820031250000000000000000000000000000e0 * t1618 - 0.17769411149910220312500000000000000000000000000000e-1 * t1620 + (-0.35283272492106570000000000000000000000000000000000e-1 * t1610 + 0.58805454153510950000000000000000000000000000000000e-3 * t1600 - 0.24502272563962895833333333333333333333333333333333e-4 * t1607) * t140 + t201 * t1666 + (0.20866548239672089500000000000000000000000000000000e-1 * t1610 - 0.34777580399453482500000000000000000000000000000000e-3 * t1600 + 0.14490658499772284375000000000000000000000000000000e-4 * t1607) * t99 + t205 * t1635 + (-0.51727154568297075000000000000000000000000000000000e-2 * t1610 + 0.86211924280495125000000000000000000000000000000000e-4 * t1600 - 0.35921635116872968750000000000000000000000000000000e-5 * t1607) * t127 + t193 * t1594 + (-0.14531910974209701000000000000000000000000000000000e-2 * t1610 + 0.24219851623682835000000000000000000000000000000000e-4 * t1600 - 0.10091604843201181250000000000000000000000000000000e-5 * t1607) * t134
  t1949 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t1663 + t1716 + t1754 + t1799 + t1839 + t1871 + t1906 + t1942))
  vsigma_0_ = t6 * t1949
  vsigma_1_ = 0.0e0
  t1951 = t33 * t365 * t407
  t1958 = t702 * s2 / t358 / t1156 / r1 * t1162
  t1960 = t1951 / 0.12e2 - t1958 / 0.288e3
  t1961 = t546 * t1960
  t1963 = t505 * t1960
  t1965 = t457 * t1960
  t1979 = 0.5e1 / 0.72e2 * t33 * t365
  t1980 = f.my_piecewise3(t373, -t1979, 0)
  t1988 = f.my_piecewise3(t373, 0, -t1979)
  t1999 = f.my_piecewise3(t372, -0.3e1 / 0.2e1 * t379 * t1980 - 0.3e1 / 0.16e2 * t382 * t1980 + 0.3e1 * t1185 * t1980, -0.6e1 * t1189 * t385 * t1988 - t1196 * (0.3e1 * t1197 * t1988 + 0.12e2 * t1201 * t1988))
  t2001 = t506 * t1960
  t2003 = t458 * t1960
  t2005 = t456 * t1960
  t2010 = t400 * t1999
  t2012 = t399 * t1999
  t2014 = t398 * t1999
  t2017 = 0.3003e4 / 0.16e2 * t2010 - 0.3465e4 / 0.16e2 * t2012 + 0.945e3 / 0.16e2 * t2014 - 0.35e2 / 0.16e2 * t1999
  t2024 = t415 * t1999
  t2026 = t412 * t1999
  t2028 = t397 * t1999
  t2030 = 0.693e3 / 0.8e1 * t2024 - 0.315e3 / 0.4e1 * t2026 + 0.105e3 / 0.8e1 * t2028
  t2040 = 0.315e3 / 0.8e1 * t2012 - 0.105e3 / 0.4e1 * t2014 + 0.15e2 / 0.8e1 * t1999
  t2049 = 0.35e2 / 0.2e1 * t2026 - 0.15e2 / 0.2e1 * t2028
  t2058 = 0.15e2 / 0.2e1 * t2014 - 0.3e1 / 0.2e1 * t1999
  t2060 = (-0.18895820367784253643750000000000000000000000000000e1 * t1961 + 0.21802869655135677281250000000000000000000000000000e1 * t1963 - 0.59462371786733665312500000000000000000000000000000e0 * t1965 + 0.18352583884794341145833333333333333333333333333333e-2 * t1951 - 0.76469099519976421440972222222222222222222222222221e-4 * t1958) * t450 + (0.32488013665979123752500000000000000000000000000000e-1 * t1961 - 0.37486169614591296637500000000000000000000000000000e-1 * t1963 + 0.10223500803979444537500000000000000000000000000000e-1 * t1965 - 0.31554014827097051041666666666666666666666666666667e-4 * t1951 + 0.13147506177957104600694444444444444444444444444445e-5 * t1958) * t397 + t609 * t1999 + (-0.15728039028245941897500000000000000000000000000000e-1 * t2001 + 0.14298217298405401725000000000000000000000000000000e-1 * t2003 - 0.23830362164009002875000000000000000000000000000000e-2 * t2005) * t419 + 0.43800366442821331612500000000000000000000000000000e0 * t2001 + t614 * t2017 + (0.16149646244247680587500000000000000000000000000000e0 * t2001 - 0.14681496585679709625000000000000000000000000000000e0 * t2003 + 0.24469160976132849375000000000000000000000000000000e-1 * t2005) * t426 + t619 * t2030 + (-0.27110625101785230390000000000000000000000000000000e0 * t2001 + 0.24646022819804754900000000000000000000000000000000e0 * t2003 - 0.41076704699674591500000000000000000000000000000000e-1 * t2005) * t433 + t624 * t2040 + (0.72479774163284195400000000000000000000000000000000e-1 * t2001 - 0.65890703784803814000000000000000000000000000000000e-1 * t2003 + 0.10981783964133969000000000000000000000000000000000e-1 * t2005) * t439 + t629 * t2049 + (-0.79657887063377058975000000000000000000000000000000e0 * t2001 + 0.72416260966706417250000000000000000000000000000000e0 * t2003 - 0.12069376827784402875000000000000000000000000000000e0 * t2005) * t445 + t550 * t2058
  t2103 = (-0.66108783714833674237500000000000000000000000000000e0 * t2001 + 0.60098894286212431125000000000000000000000000000000e0 * t2003 - 0.10016482381035405187500000000000000000000000000000e0 * t2005) * t450 + (0.24434174127676885976250000000000000000000000000000e0 * t2001 - 0.22212885570615350887500000000000000000000000000000e0 * t2003 + 0.37021475951025584812500000000000000000000000000000e-1 * t2005) * t397 + t560 * t1999 + (-0.20451606009930529875000000000000000000000000000000e-1 * t1963 + 0.13634404006620353250000000000000000000000000000000e-1 * t1965 - 0.81157166706073531250000000000000000000000000000000e-4 * t1951 + 0.33815486127530638020833333333333333333333333333333e-5 * t1958) * t419 + t565 * t2017 + (0.10109690061618578333333333333333333333333333333333e-1 * t1951 - 0.42123708590077409722222222222222222222222222222221e-3 * t1958) * t397 + t453 * t1999 + (0.20814425935415427500000000000000000000000000000000e-3 * t1951 - 0.86726774730897614583333333333333333333333333333333e-5 * t1958) * t445 + t442 * t2058 + (0.10284428865871160000000000000000000000000000000000e-3 * t1951 - 0.42851786941129833333333333333333333333333333333333e-5 * t1958) * t450 + (0.13698102009618642500000000000000000000000000000000e-3 * t1951 - 0.57075425040077677083333333333333333333333333333333e-5 * t1958) * t433 + t429 * t2040 + (0.42496589149630555000000000000000000000000000000000e-3 * t1951 - 0.17706912145679397916666666666666666666666666666667e-4 * t1958) * t439 + t436 * t2049
  t2151 = t575 * t2040 + 0.26139891914853820031250000000000000000000000000000e0 * t2012 - 0.17769411149910220312500000000000000000000000000000e-1 * t2014 + (-0.40356075865519945125000000000000000000000000000000e-1 * t1963 + 0.26904050577013296750000000000000000000000000000000e-1 * t1965 - 0.16014315819650771875000000000000000000000000000000e-3 * t1951 + 0.66726315915211549479166666666666666666666666666667e-5 * t1958) * t439 + t580 * t2049 + (-0.14395547581531767000000000000000000000000000000000e-2 * t1963 + 0.95970317210211780000000000000000000000000000000000e-3 * t1965 - 0.57125188815602250000000000000000000000000000000000e-5 * t1951 + 0.23802162006500937500000000000000000000000000000000e-6 * t1958) * t445 + t585 * t2058 + (0.19931329888701308437500000000000000000000000000000e0 * t1963 - 0.13287553259134205625000000000000000000000000000000e0 * t1965 + 0.79092578923417890625000000000000000000000000000000e-3 * t1951 - 0.32955241218090787760416666666666666666666666666667e-4 * t1958) * t450 + (-0.65398947448397979937500000000000000000000000000000e-1 * t1963 + 0.43599298298931986625000000000000000000000000000000e-1 * t1965 - 0.25951963273173801562500000000000000000000000000000e-3 * t1951 + 0.10813318030489083984375000000000000000000000000000e-4 * t1958) * t397 + t648 * t2040 + (-0.58913379072588789498750000000000000000000000000000e-1 * t1961 + 0.67976975852987064806250000000000000000000000000000e-1 * t1963 - 0.18539175232632835856250000000000000000000000000000e-1 * t1965 + 0.57219676643928505729166666666666666666666666666667e-4 * t1951 - 0.23841531934970210720486111111111111111111111111111e-5 * t1958) * t439 + t654 * t2049 + (0.20131885971298243642500000000000000000000000000000e1 * t1961 - 0.23229099197651819587500000000000000000000000000000e1 * t1963 + 0.63352088720868598875000000000000000000000000000000e0 * t1965 - 0.19553113802737221875000000000000000000000000000000e-2 * t1951 + 0.81471307511405091145833333333333333333333333333333e-4 * t1958) * t445 + t597 * t2058
  t2185 = -0.28142938497823438038750000000000000000000000000000e0 * t1961 + t636 * t2017 + (-0.35839190838072170298750000000000000000000000000000e-1 * t1961 + 0.41352912505467888806250000000000000000000000000000e-1 * t1963 - 0.11278067046945787856250000000000000000000000000000e-1 * t1965 + 0.34808848910326505729166666666666666666666666666667e-4 * t1951 - 0.14503687045969377387152777777777777777777777777778e-5 * t1958) * t426 + t642 * t2030 + (0.72745666391090414596875000000000000000000000000000e0 * t1961 - 0.83937307374335093765625000000000000000000000000000e0 * t1963 + 0.22891992920273207390625000000000000000000000000000e0 * t1965 - 0.70654299136645701822916666666666666666666666666667e-3 * t1951 + 0.29439291306935709092881944444444444444444444444445e-4 * t1958) * t433 + (-0.12617572159509221250000000000000000000000000000000e0 * t1965 + 0.21029286932515368750000000000000000000000000000000e-2 * t1951 - 0.87622028885480703125000000000000000000000000000000e-4 * t1958) * t397 + t481 * t1999 + t485 * t2017 + t488 * t2030 + t491 * t2040 + t494 * t2049 + t497 * t2058 + t503 * t1999 + (0.19300013471975028333333333333333333333333333333333e-3 * t1951 - 0.80416722799895951388888888888888888888888888888888e-5 * t1958) * t419
  t2231 = t411 * t2017 + (0.49752384692289725000000000000000000000000000000000e-4 * t1951 - 0.20730160288454052083333333333333333333333333333333e-5 * t1958) * t426 + t422 * t2030 + (-0.55323715279307820345000000000000000000000000000000e-1 * t1961 + 0.63835056091509023475000000000000000000000000000000e-1 * t1963 - 0.17409560752229733675000000000000000000000000000000e-1 * t1965 + 0.53733212198239918750000000000000000000000000000000e-4 * t1951 - 0.22388838415933299479166666666666666666666666666667e-5 * t1958) * t419 + t542 * t2017 + (-0.51727154568297075000000000000000000000000000000000e-2 * t1965 + 0.86211924280495125000000000000000000000000000000000e-4 * t1951 - 0.35921635116872968750000000000000000000000000000000e-5 * t1958) * t426 + t461 * t2030 + (-0.14531910974209701000000000000000000000000000000000e-2 * t1965 + 0.24219851623682835000000000000000000000000000000000e-4 * t1951 - 0.10091604843201181250000000000000000000000000000000e-5 * t1958) * t433 + t465 * t2040 + (-0.35283272492106570000000000000000000000000000000000e-1 * t1965 + 0.58805454153510950000000000000000000000000000000000e-3 * t1951 - 0.24502272563962895833333333333333333333333333333333e-4 * t1958) * t439 + t469 * t2049 + (0.20866548239672089500000000000000000000000000000000e-1 * t1965 - 0.34777580399453482500000000000000000000000000000000e-3 * t1951 + 0.14490658499772284375000000000000000000000000000000e-4 * t1958) * t445 + t473 * t2058 + (-0.58676911042618642500000000000000000000000000000000e-3 * t1965 + 0.97794851737697737500000000000000000000000000000000e-5 * t1951 - 0.40747854890707390625000000000000000000000000000000e-6 * t1958) * t450
  t2267 = (0.17309872529212490500000000000000000000000000000000e-1 * t2003 - 0.74185167982339245000000000000000000000000000000000e-2 * t2005) * t439 + t526 * t2049 + (-0.44997427919967477500000000000000000000000000000000e-2 * t2003 + 0.19284611965700347500000000000000000000000000000000e-2 * t2005) * t445 + t530 * t2058 + (-0.26037690300597365250000000000000000000000000000000e-1 * t2003 + 0.11159010128827442250000000000000000000000000000000e-1 * t2005) * t450 + (-0.36926557942570530500000000000000000000000000000000e-1 * t2003 + 0.15825667689673084500000000000000000000000000000000e-1 * t2005) * t397 + t538 * t1999 + (0.32314244502066637500000000000000000000000000000000e-2 * t1965 - 0.53857074170111062500000000000000000000000000000000e-4 * t1951 + 0.22440447570879609375000000000000000000000000000000e-5 * t1958) * t419 + (-0.29749609915980499125000000000000000000000000000000e0 * t1963 + 0.19833073277320332750000000000000000000000000000000e0 * t1965 - 0.11805400760309721875000000000000000000000000000000e-2 * t1951 + 0.49189169834623841145833333333333333333333333333333e-4 * t1958) * t426 + 0.25098623535341656518750000000000000000000000000000e0 * t1963 - 0.24142521896743737562500000000000000000000000000000e-1 * t1965 + t570 * t2030 + 0.26485532388814614885000000000000000000000000000000e-1 * t2024 - 0.49149175060229317850000000000000000000000000000000e-1 * t2026
  t2297 = 0.12711844558663081725000000000000000000000000000000e-1 * t2028 + (-0.15175714938516591243750000000000000000000000000000e0 * t1963 + 0.10117143292344394162500000000000000000000000000000e0 * t1965 - 0.60221091025859489062500000000000000000000000000000e-3 * t1951 + 0.25092121260774787109375000000000000000000000000000e-4 * t1958) * t433 + t510 * t1999 + (-0.31372202827502810000000000000000000000000000000000e-3 * t2003 + 0.13445229783215490000000000000000000000000000000000e-3 * t2005) * t419 - 0.22833790496685041125000000000000000000000000000000e0 * t2003 - 0.76461881870812536187500000000000000000000000000000e0 * t2005 + t514 * t2017 - 0.38012670012172849743750000000000000000000000000000e0 * t2010 + (0.23306453795076795000000000000000000000000000000000e-2 * t2003 - 0.99884801978900550000000000000000000000000000000000e-3 * t2005) * t426 + t518 * t2030 + (-0.12706936120949050750000000000000000000000000000000e-2 * t2003 + 0.54458297661210217500000000000000000000000000000000e-3 * t2005) * t433 + t522 * t2040 - 0.11145877912279910869791666666666666666666666666667e-1 * t1951 + 0.19451907596748125343750000000000000000000000000000e0 * t1999
  t2327 = 0.46441157967832961957465277777777777777777777777779e-3 * t1958 + 0.3e1 * t1548 * t1999 + 0.3e1 * t1545 * t1999 + 0.3e1 * t1542 * t1999 + 0.3e1 * t1539 * t1999 + 0.3e1 * t1536 * t1999 + 0.56817065229729237000000000000000000000000000000000e-3 * t2005 * t419 - 0.27146561728928226000000000000000000000000000000000e-2 * t2005 * t426 + 0.25448301445575582000000000000000000000000000000000e-3 * t2005 * t433 + 0.95414797078251930000000000000000000000000000000000e-3 * t2005 * t439 - 0.26011607116438383000000000000000000000000000000000e-2 * t2005 * t445 - 0.25059937895101080000000000000000000000000000000000e-2 * t2005 * t450 + 0.3e1 * t1523 * t1999 - 0.39406812755488791000000000000000000000000000000000e-1 * t2005 * t397 + 0.3e1 * t1515 * t1999
  t2334 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t357 * (t2060 + t2103 + t2151 + t2185 + t2231 + t2267 + t2297 + t2327))
  vsigma_2_ = t6 * t2334
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t2337 = 0.5e1 / 0.9e1 * t57 * t28 * t32
  t2338 = f.my_piecewise3(t65, t2337, 0)
  t2346 = f.my_piecewise3(t65, 0, t2337)
  t2357 = f.my_piecewise3(t64, -0.3e1 / 0.2e1 * t71 * t2338 - 0.3e1 / 0.16e2 * t74 * t2338 + 0.3e1 * t747 * t2338, -0.6e1 * t751 * t77 * t2346 - t758 * (0.3e1 * t759 * t2346 + 0.12e2 * t763 * t2346))
  t2358 = t90 * t2357
  t2361 = 0.15e2 / 0.2e1 * t2358 - 0.3e1 / 0.2e1 * t2357
  t2365 = t123 * t2357
  t2367 = t112 * t2357
  t2371 = 0.3003e4 / 0.16e2 * t2365 - 0.3465e4 / 0.16e2 * t2367 + 0.945e3 / 0.16e2 * t2358 - 0.35e2 / 0.16e2 * t2357
  t2375 = t115 * t2357
  t2377 = t96 * t2357
  t2379 = t89 * t2357
  t2381 = 0.693e3 / 0.8e1 * t2375 - 0.315e3 / 0.4e1 * t2377 + 0.105e3 / 0.8e1 * t2379
  t2389 = 0.315e3 / 0.8e1 * t2367 - 0.105e3 / 0.4e1 * t2358 + 0.15e2 / 0.8e1 * t2357
  t2393 = 0.35e2 / 0.2e1 * t2377 - 0.15e2 / 0.2e1 * t2379
  t2397 = t205 * t2361 - 0.17769411149910220312500000000000000000000000000000e-1 * t2358 + t108 * t2357 + t111 * t2371 - 0.38012670012172849743750000000000000000000000000000e0 * t2365 + 0.26139891914853820031250000000000000000000000000000e0 * t2367 + t122 * t2381 + 0.26485532388814614885000000000000000000000000000000e-1 * t2375 - 0.49149175060229317850000000000000000000000000000000e-1 * t2377 + 0.12711844558663081725000000000000000000000000000000e-1 * t2379 + t130 * t2389 + t137 * t2393 + t143 * t2361 + t149 * t2357
  t2412 = t152 * t2371 + t155 * t2381 + t159 * t2389 + t173 * t2393 + t177 * t2361 + t185 * t2357 + t189 * t2371 + t193 * t2381 + t197 * t2389 + t201 * t2393 + t233 * t2393 + t238 * t2361 + t278 * t2389 + t283 * t2393
  t2428 = t162 * t2393 + t165 * t2357 + t169 * t2389 + t210 * t2357 + t216 * t2371 + t221 * t2381 + t228 * t2389 + t248 * t2357 + t263 * t2357 + t288 * t2361 + t95 * t2361 + t268 * t2371 + t256 * t2381 + t273 * t2381
  t2450 = t252 * t2371 + t330 * t2371 + t299 * t2381 + t305 * t2389 + t312 * t2393 + t318 * t2361 + 0.19451907596748125343750000000000000000000000000000e0 * t2357 + 0.3e1 * t898 * t2357 + 0.3e1 * t895 * t2357 + 0.3e1 * t904 * t2357 + 0.3e1 * t913 * t2357 + 0.3e1 * t901 * t2357 + 0.3e1 * t910 * t2357 + 0.3e1 * t907 * t2357
  t2456 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t2397 + t2412 + t2428 + t2450))
  vtau_0_ = t6 * t2456
  t2459 = 0.5e1 / 0.9e1 * t361 * t28 * t32
  t2460 = f.my_piecewise3(t373, t2459, 0)
  t2468 = f.my_piecewise3(t373, 0, t2459)
  t2479 = f.my_piecewise3(t372, -0.3e1 / 0.2e1 * t379 * t2460 - 0.3e1 / 0.16e2 * t382 * t2460 + 0.3e1 * t1185 * t2460, -0.6e1 * t1189 * t385 * t2468 - t1196 * (0.3e1 * t1197 * t2468 + 0.12e2 * t1201 * t2468))
  t2482 = t399 * t2479
  t2484 = t398 * t2479
  t2487 = 0.315e3 / 0.8e1 * t2482 - 0.105e3 / 0.4e1 * t2484 + 0.15e2 / 0.8e1 * t2479
  t2489 = t412 * t2479
  t2491 = t397 * t2479
  t2493 = 0.35e2 / 0.2e1 * t2489 - 0.15e2 / 0.2e1 * t2491
  t2495 = t415 * t2479
  t2499 = 0.693e3 / 0.8e1 * t2495 - 0.315e3 / 0.4e1 * t2489 + 0.105e3 / 0.8e1 * t2491
  t2502 = t400 * t2479
  t2507 = 0.3003e4 / 0.16e2 * t2502 - 0.3465e4 / 0.16e2 * t2482 + 0.945e3 / 0.16e2 * t2484 - 0.35e2 / 0.16e2 * t2479
  t2512 = 0.15e2 / 0.2e1 * t2484 - 0.3e1 / 0.2e1 * t2479
  t2519 = 0.19451907596748125343750000000000000000000000000000e0 * t2479 + t481 * t2479 + t465 * t2487 + t469 * t2493 + t461 * t2499 + t538 * t2479 + t542 * t2507 + t526 * t2493 + t530 * t2512 + t518 * t2499 + t522 * t2487 + t510 * t2479 + t514 * t2507 + t580 * t2493
  t2534 = t560 * t2479 + t609 * t2479 + t575 * t2487 + t624 * t2487 + t629 * t2493 + t654 * t2493 + t570 * t2499 + t619 * t2499 + t565 * t2507 + t614 * t2507 + t442 * t2512 + t550 * t2512 + t585 * t2512 + t597 * t2512
  t2550 = -0.17769411149910220312500000000000000000000000000000e-1 * t2484 + t453 * t2479 + t429 * t2487 + 0.26139891914853820031250000000000000000000000000000e0 * t2482 + t436 * t2493 - 0.49149175060229317850000000000000000000000000000000e-1 * t2489 + 0.12711844558663081725000000000000000000000000000000e-1 * t2491 + t422 * t2499 + 0.26485532388814614885000000000000000000000000000000e-1 * t2495 + t503 * t2479 + t411 * t2507 - 0.38012670012172849743750000000000000000000000000000e0 * t2502 + t494 * t2493 + t497 * t2512
  t2572 = 0.3e1 * t1515 * t2479 + 0.3e1 * t1523 * t2479 + 0.3e1 * t1536 * t2479 + 0.3e1 * t1539 * t2479 + 0.3e1 * t1542 * t2479 + 0.3e1 * t1545 * t2479 + 0.3e1 * t1548 * t2479 + t491 * t2487 + t648 * t2487 + t488 * t2499 + t642 * t2499 + t485 * t2507 + t636 * t2507 + t473 * t2512
  t2578 = f.my_piecewise3(t350, 0, -0.3e1 / 0.8e1 * t5 * t357 * (t2519 + t2534 + t2550 + t2572))
  vtau_1_ = t6 * t2578
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: (1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + 4 * a ** 3))

  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1050362267560025, -0.1304673327239498, -0.25273044468938444, 0.0020345583050872945, 0.009705556829333915, -0.0018727613481398786, 0.005056319358478653, -0.0014994572626212954], dtype=np.float64), np.array([np.nan, 0.19526954394443446, 0.12131628073942294, -0.013135604251829597, -0.016823429546012295, -0.0021100890252897446, -0.0016609256494831233, 0.0028206838819829017, 0.00017309630990864668], dtype=np.float64), np.array([np.nan, -0.00068200282327089, 0.0012341314639045392, -0.000835331263170036, -7.823588139015819e-05, -0.0014878680171769923, 0.005061925051098745, -0.007631605623646023, -0.01006770315965861], dtype=np.float64), np.array([np.nan, -0.00217177716567727, 0.0024977311122498513, -0.0008670535705479461, 0.0027822064319562786, -0.0002571281595426713, -3.656012084198544e-05, -0.009195715678311926, 0.010726279571787276], dtype=np.float64), np.array([np.nan, -0.001432652476750007, 0.0050995906979556666, 0.0003180493235941731, -0.004704436332280876, 0.0009891355730978566, -0.0010249162124576494, 0.0008367073496483024, -0.00031389079758955066], dtype=np.float64), np.array([np.nan, -0.004500541251076788, 0.0016437722411542371, 8.482767148525194e-05, -0.00019375881298946268, -7.261106354828029e-05, -0.0038541498256550073, -0.0031296536914037784, 0.0038758929812102785], dtype=np.float64), np.array([np.nan, 0.00030574929164576756, 0.0005970286163074767, -0.0009048853909642742, -0.000689695394243961, 0.0001331797359718674, -0.007555456486598222, 0.001864317026752979, -0.00019095139973664826], dtype=np.float64), np.array([np.nan, -0.002025317083565653, 0.0023160016166370034, 0.00018939021743243079, 0.0004308565933608885, -1.792697304428732e-05, -0.0005194058669188706, -0.00018156466410673526, -0.00029476504977320184], dtype=np.float64)]

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mcml_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mcml_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = s0 * t28
  t35 = t34 * t32
  t38 = 0.65124e1 + t25 * t35 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t33 * t39
  t41 = t26 * t40
  t44 = t41 / 0.12e2 - 0.1e1
  t45 = t44 ** 2
  t46 = t45 ** 2
  t47 = t46 * t44
  t49 = t45 * t44
  t52 = -0.28791095163063534000000000000000000000000000000000e-3 * t47 + 0.31990105736737260000000000000000000000000000000000e-3 * t49 - 0.57125188815602250000000000000000000000000000000000e-5 * t41 + 0.68550226578722700000000000000000000000000000000000e-4
  t53 = tau0 * t28
  t55 = 0.1e1 / t30 / r0
  t61 = 0.5e1 / 0.9e1 * (t53 * t55 - t35 / 0.8e1) * t20 * t24
  t62 = 0.1e5 <= t61
  t63 = 0.1e5 < t61
  t64 = f.my_piecewise3(t63, t61, 0.1e5)
  t65 = t64 ** 2
  t69 = 0.1e1 / t65 / t64
  t71 = t65 ** 2
  t72 = 0.1e1 / t71
  t75 = f.my_piecewise3(t63, 0.1e5, t61)
  t76 = t75 ** 2
  t77 = 0.1e1 - t76
  t78 = t77 ** 2
  t79 = t78 * t77
  t80 = t76 * t75
  t82 = 0.1e1 + 0.4e1 * t80
  t84 = t80 * t82 + 0.1e1
  t85 = 0.1e1 / t84
  t87 = f.my_piecewise3(t62, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t65 + t69 / 0.16e2 - 0.3e1 / 0.4e1 * t72, t79 * t85)
  t88 = t87 ** 2
  t89 = t88 * t87
  t92 = 0.5e1 / 0.2e1 * t89 - 0.3e1 / 0.2e1 * t87
  t97 = 0.39862659777402616875000000000000000000000000000000e-1 * t47 - 0.44291844197114018750000000000000000000000000000000e-1 * t49 + 0.79092578923417890625000000000000000000000000000000e-3 * t41 - 0.94911094708101468750000000000000000000000000000000e-2
  t99 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t88
  t104 = -0.13079789489679595987500000000000000000000000000000e-1 * t47 + 0.14533099432977328875000000000000000000000000000000e-1 * t49 - 0.25951963273173801562500000000000000000000000000000e-3 * t41 + 0.31142355927808561875000000000000000000000000000000e-2
  t108 = -0.67226148916077450000000000000000000000000000000000e-5 - 0.78430507068757025000000000000000000000000000000000e-4 * t46 + 0.67226148916077450000000000000000000000000000000000e-4 * t45
  t109 = t88 ** 2
  t110 = t109 * t89
  t112 = t109 * t87
  t116 = 0.429e3 / 0.16e2 * t110 - 0.693e3 / 0.16e2 * t112 + 0.315e3 / 0.16e2 * t89 - 0.35e2 / 0.16e2 * t87
  t120 = 0.49942400989450275000000000000000000000000000000000e-4 + 0.58266134487691987500000000000000000000000000000000e-3 * t46 - 0.49942400989450275000000000000000000000000000000000e-3 * t45
  t121 = t109 * t88
  t125 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t121 - 0.315e3 / 0.16e2 * t109 + 0.105e3 / 0.16e2 * t88
  t129 = -0.27229148830605108750000000000000000000000000000000e-4 - 0.31767340302372626875000000000000000000000000000000e-3 * t46 + 0.27229148830605108750000000000000000000000000000000e-3 * t45
  t133 = 0.63e2 / 0.8e1 * t112 - 0.35e2 / 0.4e1 * t89 + 0.15e2 / 0.8e1 * t87
  t137 = 0.37092583991169622500000000000000000000000000000000e-3 + 0.43274681323031226250000000000000000000000000000000e-2 * t46 - 0.37092583991169622500000000000000000000000000000000e-2 * t45
  t140 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t109 - 0.15e2 / 0.4e1 * t88
  t144 = -0.96423059828501737500000000000000000000000000000000e-4 - 0.11249356979991869375000000000000000000000000000000e-2 * t46 + 0.96423059828501737500000000000000000000000000000000e-3 * t45
  t148 = -0.55795050644137211250000000000000000000000000000000e-3 - 0.65094225751493413125000000000000000000000000000000e-2 * t46 + 0.55795050644137211250000000000000000000000000000000e-2 * t45
  t152 = -0.79128338448365422500000000000000000000000000000000e-3 - 0.92316394856426326250000000000000000000000000000000e-2 * t46 + 0.79128338448365422500000000000000000000000000000000e-2 * t45
  t154 = t46 * t45
  t158 = 0.97801677856368075000000000000000000000000000000000e-3 - 0.45184375169642050650000000000000000000000000000000e-1 * t154 + 0.61615057049511887250000000000000000000000000000000e-1 * t46 - 0.20538352349837295750000000000000000000000000000000e-1 * t45
  t163 = -0.26147104676509450000000000000000000000000000000000e-3 + 0.12079962360547365900000000000000000000000000000000e-1 * t154 - 0.16472675946200953500000000000000000000000000000000e-1 * t46 + 0.54908919820669845000000000000000000000000000000000e-2 * t45
  t168 = 0.28736611494724768750000000000000000000000000000000e-2 - 0.13276314510562843162500000000000000000000000000000e0 * t154 + 0.18104065241676604312500000000000000000000000000000e0 * t46 - 0.60346884138922014375000000000000000000000000000000e-1 * t45
  t173 = 0.23848767573893821875000000000000000000000000000000e-2 - 0.11018130619138945706250000000000000000000000000000e0 * t154 + 0.15024723571553107781250000000000000000000000000000e0 * t46 - 0.50082411905177025937500000000000000000000000000000e-1 * t45
  t178 = -0.88146371311965678125000000000000000000000000000000e-3 + 0.40723623546128143293750000000000000000000000000000e-1 * t154 - 0.55532213926538377218750000000000000000000000000000e-1 * t46 + 0.18510737975512792406250000000000000000000000000000e-1 * t45
  t180 = -0.11145877912279910869791666666666666666666666666667e-1 * t41 + t52 * t92 + t97 * t99 + t104 * t87 + t108 * t116 + t120 * t125 + t129 * t133 + t137 * t140 + t144 * t92 + t148 * t99 + t152 * t87 + t158 * t133 + t163 * t140 + t168 * t92 + t173 * t99 + t178 * t87
  t184 = -0.40903212019861059750000000000000000000000000000000e-2 * t47 + 0.45448013355401177500000000000000000000000000000000e-2 * t49 - 0.81157166706073531250000000000000000000000000000000e-4 * t41 + 0.97388600047288237500000000000000000000000000000000e-3
  t189 = -0.59499219831960998250000000000000000000000000000000e-1 * t47 + 0.66110244257734442500000000000000000000000000000000e-1 * t49 - 0.11805400760309721875000000000000000000000000000000e-2 * t41 + 0.14166480912371666250000000000000000000000000000000e-1
  t194 = -0.30351429877033182487500000000000000000000000000000e-1 * t47 + 0.33723810974481313875000000000000000000000000000000e-1 * t49 - 0.60221091025859489062500000000000000000000000000000e-3 * t41 + 0.72265309231031386875000000000000000000000000000000e-2
  t199 = -0.80712151731039890250000000000000000000000000000000e-2 * t47 + 0.89680168590044322500000000000000000000000000000000e-2 * t49 - 0.16014315819650771875000000000000000000000000000000e-3 * t41 + 0.19217178983580926250000000000000000000000000000000e-2
  t201 = t46 * t49
  t206 = 0.10392238055870059228125000000000000000000000000000e0 * t201 - 0.16787461474867018753125000000000000000000000000000e0 * t47 + 0.76306643067577357968750000000000000000000000000000e-1 * t49 - 0.70654299136645701822916666666666666666666666666667e-3 * t41 + 0.84785158963974842187500000000000000000000000000000e-2
  t212 = -0.84161970103698270712500000000000000000000000000000e-2 * t201 + 0.13595395170597412961250000000000000000000000000000e-1 * t47 - 0.61797250775442786187500000000000000000000000000000e-2 * t49 + 0.57219676643928505729166666666666666666666666666667e-4 * t41 - 0.68663611972714206875000000000000000000000000000000e-3
  t218 = 0.28759837101854633775000000000000000000000000000000e0 * t201 - 0.46458198395303639175000000000000000000000000000000e0 * t47 + 0.21117362906956199625000000000000000000000000000000e0 * t49 - 0.19553113802737221875000000000000000000000000000000e-2 * t41 + 0.23463736563284666250000000000000000000000000000000e-1
  t224 = -0.26994029096834648062500000000000000000000000000000e0 * t201 + 0.43605739310271354562500000000000000000000000000000e0 * t47 - 0.19820790595577888437500000000000000000000000000000e0 * t49 + 0.18352583884794341145833333333333333333333333333333e-2 * t41 - 0.22023100661753209375000000000000000000000000000000e-1
  t230 = 0.46411448094255891075000000000000000000000000000000e-2 * t201 - 0.74972339229182593275000000000000000000000000000000e-2 * t47 + 0.34078336013264815125000000000000000000000000000000e-2 * t49 - 0.31554014827097051041666666666666666666666666666667e-4 * t41 + 0.37864817792516461250000000000000000000000000000000e-3
  t235 = 0.56738957533354768750000000000000000000000000000000e-4 - 0.26213398380409903162500000000000000000000000000000e-2 * t154 + 0.35745543246013504312500000000000000000000000000000e-2 * t46 - 0.11915181082004501437500000000000000000000000000000e-2 * t45
  t240 = -0.58259907086030593750000000000000000000000000000000e-3 + 0.26916077073746134312500000000000000000000000000000e-1 * t154 - 0.36703741464199274062500000000000000000000000000000e-1 * t46 + 0.12234580488066424687500000000000000000000000000000e-1 * t45
  t243 = 0.45244269548213710000000000000000000000000000000000e-3 - 0.13573280864464113000000000000000000000000000000000e-2 * t45
  t246 = -0.42413835742625970000000000000000000000000000000000e-4 + 0.12724150722787791000000000000000000000000000000000e-3 * t45
  t249 = -0.15902466179708655000000000000000000000000000000000e-3 + 0.47707398539125965000000000000000000000000000000000e-3 * t45
  t252 = 0.43352678527397305000000000000000000000000000000000e-3 - 0.13005803558219191500000000000000000000000000000000e-2 * t45
  t255 = 0.41766563158501800000000000000000000000000000000000e-3 - 0.12529968947550540000000000000000000000000000000000e-2 * t45
  t257 = t184 * t116 + t235 * t116 + t189 * t125 + t240 * t125 + t243 * t125 + t194 * t133 + t206 * t133 + t246 * t133 + t199 * t140 + t212 * t140 + t249 * t140 + t218 * t92 + t224 * t99 + t230 * t87 + t252 * t92 + t255 * t99
  t260 = 0.65678021259147985000000000000000000000000000000000e-2 - 0.19703406377744395500000000000000000000000000000000e-1 * t45
  t263 = 0.19300013471975028333333333333333333333333333333333e-3 * t41 - 0.23160016166370034e-2
  t266 = 0.49752384692289725000000000000000000000000000000000e-4 * t41 - 0.5970286163074767e-3
  t269 = 0.10109690061618578333333333333333333333333333333333e-1 * t41 - 0.12131628073942294e0
  t272 = 0.10284428865871160000000000000000000000000000000000e-3 * t41 - 0.12341314639045392e-2
  t275 = 0.20814425935415427500000000000000000000000000000000e-3 * t41 - 0.24977311122498513e-2
  t278 = 0.42496589149630555000000000000000000000000000000000e-3 * t41 - 0.50995906979556666e-2
  t281 = 0.13698102009618642500000000000000000000000000000000e-3 * t41 - 0.16437722411542371e-2
  t287 = -0.79033878970439743350000000000000000000000000000000e-2 * t201 + 0.12767011218301804695000000000000000000000000000000e-1 * t47 - 0.58031869174099112250000000000000000000000000000000e-2 * t49 + 0.53733212198239918750000000000000000000000000000000e-4 * t41 - 0.64479854637887902500000000000000000000000000000000e-3
  t293 = -0.51198844054388814712500000000000000000000000000000e-2 * t201 + 0.82705825010935777612500000000000000000000000000000e-2 * t47 - 0.37593556823152626187500000000000000000000000000000e-2 * t49 + 0.34808848910326505729166666666666666666666666666667e-4 * t41 - 0.41770618692391806875000000000000000000000000000000e-3
  t297 = 0.10771414834022212500000000000000000000000000000000e-2 * t49 - 0.53857074170111062500000000000000000000000000000000e-4 * t41 + 0.64628489004133275000000000000000000000000000000000e-3
  t301 = -0.17242384856099025000000000000000000000000000000000e-2 * t49 + 0.86211924280495125000000000000000000000000000000000e-4 * t41 - 0.10345430913659415000000000000000000000000000000000e-2
  t305 = -0.48439703247365670000000000000000000000000000000000e-3 * t49 + 0.24219851623682835000000000000000000000000000000000e-4 * t41 - 0.29063821948419402000000000000000000000000000000000e-3
  t309 = -0.11761090830702190000000000000000000000000000000000e-1 * t49 + 0.58805454153510950000000000000000000000000000000000e-3 * t41 - 0.70566544984213140000000000000000000000000000000000e-2
  t313 = 0.69555160798906965000000000000000000000000000000000e-2 * t49 - 0.34777580399453482500000000000000000000000000000000e-3 * t41 + 0.41733096479344179000000000000000000000000000000000e-2
  t317 = -0.19558970347539547500000000000000000000000000000000e-3 * t49 + 0.97794851737697737500000000000000000000000000000000e-5 * t41 - 0.11735382208523728500000000000000000000000000000000e-3
  t319 = t263 * t116 + t287 * t116 + t297 * t116 + t266 * t125 + t293 * t125 + t301 * t125 + t281 * t133 + t305 * t133 + t278 * t140 + t309 * t140 + t260 * t87 + t269 * t87 + t272 * t99 + t275 * t92 + t313 * t92 + t317 * t99
  t322 = -0.42058573865030737500000000000000000000000000000000e-1 * t49 + 0.21029286932515368750000000000000000000000000000000e-2 * t41 - 0.25235144319018442500000000000000000000000000000000e-1
  t325 = -0.94695108716215395000000000000000000000000000000000e-4 + 0.28408532614864618500000000000000000000000000000000e-3 * t45
  t340 = 0.13669196781387441795125000000000000000000000000000e1 + t322 * t87 + t325 * t116 + 0.19451907596748125343750000000000000000000000000000e0 * t87 - 0.54303814303104071062500000000000000000000000000000e-1 * t110 + 0.52279783829707640062500000000000000000000000000000e-1 * t112 - 0.5923137049970073437500000000000000000000000000000e-2 * t89 + 0.44142553981357691475000000000000000000000000000000e-2 * t121 - 0.12287293765057329462500000000000000000000000000000e-1 * t109 + 0.63559222793315408625000000000000000000000000000000e-2 * t88 - 0.57084476241712602812500000000000000000000000000000e-1 * t46 - 0.38230940935406268093750000000000000000000000000000e0 * t45 + 0.73000610738035552687500000000000000000000000000000e-1 * t154 + 0.50197247070683313037500000000000000000000000000000e-1 * t47 - 0.8047507298914579187500000000000000000000000000000e-2 * t49 - 0.40204197854033482912500000000000000000000000000000e-1 * t201
  t342 = t180 + t257 + t319 + t340
  t346 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t342)
  t354 = 0.1e1 / t30 / t29 / r0
  t357 = t26 * t28 * t354 * t39
  t359 = t20 ** 2
  t362 = t359 / t22 / t21
  t363 = s0 ** 2
  t365 = t29 ** 2
  t370 = t38 ** 2
  t371 = 0.1e1 / t370
  t373 = t362 * t363 * t27 / t18 / t365 / t29 * t371
  t375 = -0.2e1 / 0.9e1 * t357 + t373 / 0.54e2
  t376 = t49 * t375
  t378 = t44 * t375
  t393 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t53 * t32 + t34 * t354 / 0.3e1) * t20 * t24
  t394 = f.my_piecewise3(t63, t393, 0)
  t400 = 0.1e1 / t71 / t64
  t404 = t78 * t85
  t405 = f.my_piecewise3(t63, 0, t393)
  t409 = t84 ** 2
  t411 = t79 / t409
  t412 = t76 * t82
  t415 = t76 ** 2
  t416 = t415 * t75
  t422 = f.my_piecewise3(t62, -0.3e1 / 0.2e1 * t69 * t394 - 0.3e1 / 0.16e2 * t72 * t394 + 0.3e1 * t400 * t394, -0.6e1 * t404 * t75 * t405 - t411 * (0.3e1 * t412 * t405 + 0.12e2 * t416 * t405))
  t428 = t89 * t422
  t430 = t87 * t422
  t432 = 0.35e2 / 0.2e1 * t428 - 0.15e2 / 0.2e1 * t430
  t438 = t112 * t422
  t442 = 0.693e3 / 0.8e1 * t438 - 0.315e3 / 0.4e1 * t428 + 0.105e3 / 0.8e1 * t430
  t448 = t109 * t422
  t450 = t88 * t422
  t453 = 0.315e3 / 0.8e1 * t448 - 0.105e3 / 0.4e1 * t450 + 0.15e2 / 0.8e1 * t422
  t460 = t121 * t422
  t465 = 0.3003e4 / 0.16e2 * t460 - 0.3465e4 / 0.16e2 * t448 + 0.945e3 / 0.16e2 * t450 - 0.35e2 / 0.16e2 * t422
  t467 = t46 * t375
  t469 = t45 * t375
  t476 = (-0.26037690300597365250000000000000000000000000000000e-1 * t376 + 0.11159010128827442250000000000000000000000000000000e-1 * t378) * t99 + (-0.36926557942570530500000000000000000000000000000000e-1 * t376 + 0.15825667689673084500000000000000000000000000000000e-1 * t378) * t87 + t152 * t422 + (0.17309872529212490500000000000000000000000000000000e-1 * t376 - 0.74185167982339245000000000000000000000000000000000e-2 * t378) * t140 + t137 * t432 + (0.23306453795076795000000000000000000000000000000000e-2 * t376 - 0.99884801978900550000000000000000000000000000000000e-3 * t378) * t125 + t120 * t442 + (-0.12706936120949050750000000000000000000000000000000e-2 * t376 + 0.54458297661210217500000000000000000000000000000000e-3 * t378) * t133 + t129 * t453 + t104 * t422 + (-0.31372202827502810000000000000000000000000000000000e-3 * t376 + 0.13445229783215490000000000000000000000000000000000e-3 * t378) * t116 + t108 * t465 + (-0.14395547581531767000000000000000000000000000000000e-2 * t467 + 0.95970317210211780000000000000000000000000000000000e-3 * t469 + 0.15233383684160600000000000000000000000000000000000e-4 * t357 - 0.12694486403467166666666666666666666666666666666667e-5 * t373) * t92 + 0.25098623535341656518750000000000000000000000000000e0 * t467
  t479 = 0.15e2 / 0.2e1 * t450 - 0.3e1 / 0.2e1 * t422
  t522 = t47 * t375
  t529 = t52 * t479 + (0.19931329888701308437500000000000000000000000000000e0 * t467 - 0.13287553259134205625000000000000000000000000000000e0 * t469 - 0.21091354379578104166666666666666666666666666666667e-2 * t357 + 0.17576128649648420138888888888888888888888888888889e-3 * t373) * t99 + (-0.65398947448397979937500000000000000000000000000000e-1 * t467 + 0.43599298298931986625000000000000000000000000000000e-1 * t469 + 0.69205235395130137500000000000000000000000000000000e-3 * t357 - 0.57671029495941781250000000000000000000000000000000e-4 * t373) * t87 + (-0.40356075865519945125000000000000000000000000000000e-1 * t467 + 0.26904050577013296750000000000000000000000000000000e-1 * t469 + 0.42704842185735391666666666666666666666666666666667e-3 * t357 - 0.35587368488112826388888888888888888888888888888889e-4 * t373) * t140 + t199 * t432 + (-0.29749609915980499125000000000000000000000000000000e0 * t467 + 0.19833073277320332750000000000000000000000000000000e0 * t469 + 0.31481068694159258333333333333333333333333333333333e-2 * t357 - 0.26234223911799381944444444444444444444444444444444e-3 * t373) * t125 + t189 * t442 + (-0.15175714938516591243750000000000000000000000000000e0 * t467 + 0.10117143292344394162500000000000000000000000000000e0 * t469 + 0.16058957606895863750000000000000000000000000000000e-2 * t357 - 0.13382464672413219791666666666666666666666666666667e-3 * t373) * t133 + t194 * t453 + t178 * t422 + (-0.20451606009930529875000000000000000000000000000000e-1 * t467 + 0.13634404006620353250000000000000000000000000000000e-1 * t469 + 0.21641911121619608333333333333333333333333333333333e-3 * t357 - 0.18034925934683006944444444444444444444444444444444e-4 * t373) * t116 + t184 * t465 + (-0.79657887063377058975000000000000000000000000000000e0 * t522 + 0.72416260966706417250000000000000000000000000000000e0 * t376 - 0.12069376827784402875000000000000000000000000000000e0 * t378) * t92 + 0.43800366442821331612500000000000000000000000000000e0 * t522
  t572 = t168 * t479 + (-0.66108783714833674237500000000000000000000000000000e0 * t522 + 0.60098894286212431125000000000000000000000000000000e0 * t376 - 0.10016482381035405187500000000000000000000000000000e0 * t378) * t99 + (0.24434174127676885976250000000000000000000000000000e0 * t522 - 0.22212885570615350887500000000000000000000000000000e0 * t376 + 0.37021475951025584812500000000000000000000000000000e-1 * t378) * t87 + (0.20866548239672089500000000000000000000000000000000e-1 * t469 + 0.92740214398542620000000000000000000000000000000000e-3 * t357 - 0.77283511998785516666666666666666666666666666666667e-4 * t373) * t92 + t313 * t479 + t301 * t442 + (-0.14531910974209701000000000000000000000000000000000e-2 * t469 - 0.64586270996487560000000000000000000000000000000000e-4 * t357 + 0.53821892497072966666666666666666666666666666666667e-5 * t373) * t133 + t305 * t453 + (0.32314244502066637500000000000000000000000000000000e-2 * t469 + 0.14361886445362950000000000000000000000000000000000e-3 * t357 - 0.11968238704469125000000000000000000000000000000000e-4 * t373) * t116 + t297 * t465 + (-0.51727154568297075000000000000000000000000000000000e-2 * t469 - 0.22989846474798700000000000000000000000000000000000e-3 * t357 + 0.19158205395665583333333333333333333333333333333333e-4 * t373) * t125 + (-0.44997427919967477500000000000000000000000000000000e-2 * t376 + 0.19284611965700347500000000000000000000000000000000e-2 * t378) * t92 - 0.22833790496685041125000000000000000000000000000000e0 * t376 - 0.76461881870812536187500000000000000000000000000000e0 * t378
  t598 = t154 * t375
  t622 = t144 * t479 + (0.72479774163284195400000000000000000000000000000000e-1 * t522 - 0.65890703784803814000000000000000000000000000000000e-1 * t376 + 0.10981783964133969000000000000000000000000000000000e-1 * t378) * t140 + t163 * t432 + (0.16149646244247680587500000000000000000000000000000e0 * t522 - 0.14681496585679709625000000000000000000000000000000e0 * t376 + 0.24469160976132849375000000000000000000000000000000e-1 * t378) * t125 + t240 * t442 + (-0.27110625101785230390000000000000000000000000000000e0 * t522 + 0.24646022819804754900000000000000000000000000000000e0 * t376 - 0.41076704699674591500000000000000000000000000000000e-1 * t378) * t133 + t158 * t453 + (-0.15728039028245941897500000000000000000000000000000e-1 * t522 + 0.14298217298405401725000000000000000000000000000000e-1 * t376 - 0.23830362164009002875000000000000000000000000000000e-2 * t378) * t116 + t235 * t465 + (-0.18895820367784253643750000000000000000000000000000e1 * t598 + 0.21802869655135677281250000000000000000000000000000e1 * t467 - 0.59462371786733665312500000000000000000000000000000e0 * t469 - 0.48940223692784909722222222222222222222222222222221e-2 * t357 + 0.40783519743987424768518518518518518518518518518518e-3 * t373) * t99 - 0.28142938497823438038750000000000000000000000000000e0 * t598 + (0.32488013665979123752500000000000000000000000000000e-1 * t598 - 0.37486169614591296637500000000000000000000000000000e-1 * t467 + 0.10223500803979444537500000000000000000000000000000e-1 * t469 + 0.84144039538925469444444444444444444444444444444445e-4 * t357 - 0.70120032949104557870370370370370370370370370370371e-5 * t373) * t87 + t230 * t422 + (-0.58913379072588789498750000000000000000000000000000e-1 * t598 + 0.67976975852987064806250000000000000000000000000000e-1 * t467 - 0.18539175232632835856250000000000000000000000000000e-1 * t469 - 0.15258580438380934861111111111111111111111111111111e-3 * t357 + 0.12715483698650779050925925925925925925925925925926e-4 * t373) * t140
  t672 = t212 * t432 + (0.20131885971298243642500000000000000000000000000000e1 * t598 - 0.23229099197651819587500000000000000000000000000000e1 * t467 + 0.63352088720868598875000000000000000000000000000000e0 * t469 + 0.52141636807299258333333333333333333333333333333333e-2 * t357 - 0.43451364006082715277777777777777777777777777777778e-3 * t373) * t92 + t218 * t479 + (0.72745666391090414596875000000000000000000000000000e0 * t598 - 0.83937307374335093765625000000000000000000000000000e0 * t467 + 0.22891992920273207390625000000000000000000000000000e0 * t469 + 0.18841146436438853819444444444444444444444444444445e-2 * t357 - 0.15700955363699044849537037037037037037037037037037e-3 * t373) * t133 + t206 * t453 + (-0.35839190838072170298750000000000000000000000000000e-1 * t598 + 0.41352912505467888806250000000000000000000000000000e-1 * t467 - 0.11278067046945787856250000000000000000000000000000e-1 * t469 - 0.92823597094204015277777777777777777777777777777779e-4 * t357 + 0.77352997578503346064814814814814814814814814814815e-5 * t373) * t125 + t293 * t442 + (-0.55323715279307820345000000000000000000000000000000e-1 * t598 + 0.63835056091509023475000000000000000000000000000000e-1 * t467 - 0.17409560752229733675000000000000000000000000000000e-1 * t469 - 0.14328856586197311666666666666666666666666666666667e-3 * t357 + 0.11940713821831093055555555555555555555555555555556e-4 * t373) * t116 + t287 * t465 + (-0.36528272025649713333333333333333333333333333333333e-3 * t357 + 0.30440226688041427777777777777777777777777777777778e-4 * t373) * t133 + t281 * t453 + (-0.55505135827774473333333333333333333333333333333333e-3 * t357 + 0.46254279856478727777777777777777777777777777777778e-4 * t373) * t92 + t275 * t479 + (-0.11332423773234814666666666666666666666666666666667e-2 * t357 + 0.94436864776956788888888888888888888888888888888889e-4 * t373) * t140
  t699 = t278 * t432 + (-0.26959173497649542222222222222222222222222222222221e-1 * t357 + 0.22465977914707951851851851851851851851851851851851e-2 * t373) * t87 + t269 * t422 + (-0.27425143642323093333333333333333333333333333333333e-3 * t357 + 0.22854286368602577777777777777777777777777777777778e-4 * t373) * t99 + (-0.13267302584610593333333333333333333333333333333333e-3 * t357 + 0.11056085487175494444444444444444444444444444444444e-4 * t373) * t125 + t266 * t442 + t260 * t422 + (-0.51466702591933408888888888888888888888888888888888e-3 * t357 + 0.42888918826611174074074074074074074074074074074073e-4 * t373) * t116 + 0.29722341099413095652777777777777777777777777777779e-1 * t357 - 0.24768617582844246377314814814814814814814814814816e-2 * t373 - 0.38012670012172849743750000000000000000000000000000e0 * t460 + 0.26139891914853820031250000000000000000000000000000e0 * t448 - 0.17769411149910220312500000000000000000000000000000e-1 * t450 + t263 * t465
  t727 = -0.49149175060229317850000000000000000000000000000000e-1 * t428 + 0.12711844558663081725000000000000000000000000000000e-1 * t430 + t249 * t432 + t252 * t479 + t246 * t453 + 0.26485532388814614885000000000000000000000000000000e-1 * t438 + t243 * t442 + (-0.58676911042618642500000000000000000000000000000000e-3 * t469 - 0.26078627130052730000000000000000000000000000000000e-4 * t357 + 0.21732189275043941666666666666666666666666666666667e-5 * t373) * t99 - 0.24142521896743737562500000000000000000000000000000e-1 * t469 + (-0.12617572159509221250000000000000000000000000000000e0 * t469 - 0.56078098486707650000000000000000000000000000000000e-2 * t357 + 0.46731748738923041666666666666666666666666666666667e-3 * t373) * t87 + t322 * t422 + t325 * t465 + (-0.35283272492106570000000000000000000000000000000000e-1 * t469 - 0.15681454440936253333333333333333333333333333333333e-2 * t357 + 0.13067878700780211111111111111111111111111111111111e-3 * t373) * t140 + t309 * t432
  t728 = t272 * t87
  t741 = t255 * t87
  t746 = t317 * t87
  t751 = t148 * t87
  t754 = t97 * t87
  t757 = t173 * t87
  t760 = t224 * t87
  t764 = 0.3e1 * t728 * t422 - 0.27146561728928226000000000000000000000000000000000e-2 * t378 * t125 + 0.25448301445575582000000000000000000000000000000000e-3 * t378 * t133 + 0.95414797078251930000000000000000000000000000000000e-3 * t378 * t140 - 0.26011607116438383000000000000000000000000000000000e-2 * t378 * t92 - 0.25059937895101080000000000000000000000000000000000e-2 * t378 * t99 + 0.3e1 * t741 * t422 - 0.39406812755488791000000000000000000000000000000000e-1 * t378 * t87 + 0.3e1 * t746 * t422 + 0.56817065229729237000000000000000000000000000000000e-3 * t378 * t116 + 0.3e1 * t751 * t422 + 0.3e1 * t754 * t422 + 0.3e1 * t757 * t422 + 0.3e1 * t760 * t422 + 0.19451907596748125343750000000000000000000000000000e0 * t422
  t772 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t342 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t476 + t529 + t572 + t622 + t672 + t699 + t727 + t764))
  vrho_0_ = 0.2e1 * r0 * t772 + 0.2e1 * t346
  t775 = t25 * t40
  t783 = t362 * s0 * t27 / t18 / t365 / r0 * t371
  t785 = t775 / 0.12e2 - t783 / 0.144e3
  t786 = t47 * t785
  t788 = t49 * t785
  t790 = t44 * t785
  t798 = 0.5e1 / 0.72e2 * t25 * t33
  t799 = f.my_piecewise3(t63, -t798, 0)
  t807 = f.my_piecewise3(t63, 0, -t798)
  t818 = f.my_piecewise3(t62, -0.3e1 / 0.2e1 * t69 * t799 - 0.3e1 / 0.16e2 * t72 * t799 + 0.3e1 * t400 * t799, -0.6e1 * t404 * t75 * t807 - t411 * (0.3e1 * t412 * t807 + 0.12e2 * t416 * t807))
  t819 = t109 * t818
  t821 = t88 * t818
  t824 = 0.315e3 / 0.8e1 * t819 - 0.105e3 / 0.4e1 * t821 + 0.15e2 / 0.8e1 * t818
  t833 = t112 * t818
  t835 = t89 * t818
  t837 = t87 * t818
  t839 = 0.693e3 / 0.8e1 * t833 - 0.315e3 / 0.4e1 * t835 + 0.105e3 / 0.8e1 * t837
  t844 = t154 * t785
  t846 = t46 * t785
  t848 = t45 * t785
  t855 = (-0.27110625101785230390000000000000000000000000000000e0 * t786 + 0.24646022819804754900000000000000000000000000000000e0 * t788 - 0.41076704699674591500000000000000000000000000000000e-1 * t790) * t133 + 0.43800366442821331612500000000000000000000000000000e0 * t786 - 0.22833790496685041125000000000000000000000000000000e0 * t788 - 0.76461881870812536187500000000000000000000000000000e0 * t790 + t158 * t824 + 0.26139891914853820031250000000000000000000000000000e0 * t819 - 0.17769411149910220312500000000000000000000000000000e-1 * t821 + (0.16149646244247680587500000000000000000000000000000e0 * t786 - 0.14681496585679709625000000000000000000000000000000e0 * t788 + 0.24469160976132849375000000000000000000000000000000e-1 * t790) * t125 + t240 * t839 + 0.26485532388814614885000000000000000000000000000000e-1 * t833 - 0.49149175060229317850000000000000000000000000000000e-1 * t835 + 0.12711844558663081725000000000000000000000000000000e-1 * t837 + (0.32488013665979123752500000000000000000000000000000e-1 * t844 - 0.37486169614591296637500000000000000000000000000000e-1 * t846 + 0.10223500803979444537500000000000000000000000000000e-1 * t848 - 0.31554014827097051041666666666666666666666666666667e-4 * t775 + 0.26295012355914209201388888888888888888888888888889e-5 * t783) * t87 - 0.28142938497823438038750000000000000000000000000000e0 * t844
  t864 = t121 * t818
  t869 = 0.3003e4 / 0.16e2 * t864 - 0.3465e4 / 0.16e2 * t819 + 0.945e3 / 0.16e2 * t821 - 0.35e2 / 0.16e2 * t818
  t881 = 0.15e2 / 0.2e1 * t821 - 0.3e1 / 0.2e1 * t818
  t907 = 0.35e2 / 0.2e1 * t835 - 0.15e2 / 0.2e1 * t837
  t916 = 0.25098623535341656518750000000000000000000000000000e0 * t846 - 0.24142521896743737562500000000000000000000000000000e-1 * t848 + t230 * t818 + (-0.15728039028245941897500000000000000000000000000000e-1 * t786 + 0.14298217298405401725000000000000000000000000000000e-1 * t788 - 0.23830362164009002875000000000000000000000000000000e-2 * t790) * t116 + t235 * t869 - 0.38012670012172849743750000000000000000000000000000e0 * t864 + (0.20131885971298243642500000000000000000000000000000e1 * t844 - 0.23229099197651819587500000000000000000000000000000e1 * t846 + 0.63352088720868598875000000000000000000000000000000e0 * t848 - 0.19553113802737221875000000000000000000000000000000e-2 * t775 + 0.16294261502281018229166666666666666666666666666667e-3 * t783) * t92 + t218 * t881 + (-0.18895820367784253643750000000000000000000000000000e1 * t844 + 0.21802869655135677281250000000000000000000000000000e1 * t846 - 0.59462371786733665312500000000000000000000000000000e0 * t848 + 0.18352583884794341145833333333333333333333333333333e-2 * t775 - 0.15293819903995284288194444444444444444444444444444e-3 * t783) * t99 + (0.72745666391090414596875000000000000000000000000000e0 * t844 - 0.83937307374335093765625000000000000000000000000000e0 * t846 + 0.22891992920273207390625000000000000000000000000000e0 * t848 - 0.70654299136645701822916666666666666666666666666667e-3 * t775 + 0.58878582613871418185763888888888888888888888888889e-4 * t783) * t133 + t206 * t824 + (-0.58913379072588789498750000000000000000000000000000e-1 * t844 + 0.67976975852987064806250000000000000000000000000000e-1 * t846 - 0.18539175232632835856250000000000000000000000000000e-1 * t848 + 0.57219676643928505729166666666666666666666666666667e-4 * t775 - 0.47683063869940421440972222222222222222222222222222e-5 * t783) * t140 + t212 * t907 + (-0.35839190838072170298750000000000000000000000000000e-1 * t844 + 0.41352912505467888806250000000000000000000000000000e-1 * t846 - 0.11278067046945787856250000000000000000000000000000e-1 * t848 + 0.34808848910326505729166666666666666666666666666667e-4 * t775 - 0.29007374091938754774305555555555555555555555555556e-5 * t783) * t125
  t956 = t293 * t839 + (-0.55323715279307820345000000000000000000000000000000e-1 * t844 + 0.63835056091509023475000000000000000000000000000000e-1 * t846 - 0.17409560752229733675000000000000000000000000000000e-1 * t848 + 0.53733212198239918750000000000000000000000000000000e-4 * t775 - 0.44777676831866598958333333333333333333333333333333e-5 * t783) * t116 + t287 * t869 + (0.13698102009618642500000000000000000000000000000000e-3 * t775 - 0.11415085008015535416666666666666666666666666666667e-4 * t783) * t133 + t281 * t824 + t275 * t881 + (0.42496589149630555000000000000000000000000000000000e-3 * t775 - 0.35413824291358795833333333333333333333333333333333e-4 * t783) * t140 + t278 * t907 + (0.10109690061618578333333333333333333333333333333333e-1 * t775 - 0.84247417180154819444444444444444444444444444444442e-3 * t783) * t87 + t269 * t818 + (0.10284428865871160000000000000000000000000000000000e-3 * t775 - 0.85703573882259666666666666666666666666666666666667e-5 * t783) * t99 + t322 * t818 + (0.20814425935415427500000000000000000000000000000000e-3 * t775 - 0.17345354946179522916666666666666666666666666666667e-4 * t783) * t92 + (0.49752384692289725000000000000000000000000000000000e-4 * t775 - 0.41460320576908104166666666666666666666666666666667e-5 * t783) * t125
  t986 = t266 * t839 + t260 * t818 + (0.19300013471975028333333333333333333333333333333333e-3 * t775 - 0.16083344559979190277777777777777777777777777777777e-4 * t783) * t116 + t263 * t869 + t252 * t881 + t246 * t824 + t249 * t907 + t243 * t839 + (-0.58676911042618642500000000000000000000000000000000e-3 * t848 + 0.97794851737697737500000000000000000000000000000000e-5 * t775 - 0.81495709781414781250000000000000000000000000000000e-6 * t783) * t99 + 0.92882315935665923914930555555555555555555555555558e-3 * t783 + (-0.12617572159509221250000000000000000000000000000000e0 * t848 + 0.21029286932515368750000000000000000000000000000000e-2 * t775 - 0.17524405777096140625000000000000000000000000000000e-3 * t783) * t87 + t325 * t869 + (-0.35283272492106570000000000000000000000000000000000e-1 * t848 + 0.58805454153510950000000000000000000000000000000000e-3 * t775 - 0.49004545127925791666666666666666666666666666666667e-4 * t783) * t140 + t309 * t907
  t1031 = (0.20866548239672089500000000000000000000000000000000e-1 * t848 - 0.34777580399453482500000000000000000000000000000000e-3 * t775 + 0.28981316999544568750000000000000000000000000000000e-4 * t783) * t92 + t313 * t881 + (-0.14531910974209701000000000000000000000000000000000e-2 * t848 + 0.24219851623682835000000000000000000000000000000000e-4 * t775 - 0.20183209686402362500000000000000000000000000000000e-5 * t783) * t133 + t305 * t824 + (-0.51727154568297075000000000000000000000000000000000e-2 * t848 + 0.86211924280495125000000000000000000000000000000000e-4 * t775 - 0.71843270233745937500000000000000000000000000000000e-5 * t783) * t125 + t301 * t839 + (-0.26037690300597365250000000000000000000000000000000e-1 * t788 + 0.11159010128827442250000000000000000000000000000000e-1 * t790) * t99 + (-0.36926557942570530500000000000000000000000000000000e-1 * t788 + 0.15825667689673084500000000000000000000000000000000e-1 * t790) * t87 + t152 * t818 + (0.32314244502066637500000000000000000000000000000000e-2 * t848 - 0.53857074170111062500000000000000000000000000000000e-4 * t775 + 0.44880895141759218750000000000000000000000000000000e-5 * t783) * t116 + t297 * t869 + (0.17309872529212490500000000000000000000000000000000e-1 * t788 - 0.74185167982339245000000000000000000000000000000000e-2 * t790) * t140 + t137 * t907 + (-0.44997427919967477500000000000000000000000000000000e-2 * t788 + 0.19284611965700347500000000000000000000000000000000e-2 * t790) * t92
  t1075 = t144 * t881 + (-0.12706936120949050750000000000000000000000000000000e-2 * t788 + 0.54458297661210217500000000000000000000000000000000e-3 * t790) * t133 + t129 * t824 + t108 * t869 + (0.23306453795076795000000000000000000000000000000000e-2 * t788 - 0.99884801978900550000000000000000000000000000000000e-3 * t790) * t125 + t120 * t839 + (0.19931329888701308437500000000000000000000000000000e0 * t846 - 0.13287553259134205625000000000000000000000000000000e0 * t848 + 0.79092578923417890625000000000000000000000000000000e-3 * t775 - 0.65910482436181575520833333333333333333333333333333e-4 * t783) * t99 + (-0.65398947448397979937500000000000000000000000000000e-1 * t846 + 0.43599298298931986625000000000000000000000000000000e-1 * t848 - 0.25951963273173801562500000000000000000000000000000e-3 * t775 + 0.21626636060978167968750000000000000000000000000000e-4 * t783) * t87 + t104 * t818 + (-0.31372202827502810000000000000000000000000000000000e-3 * t788 + 0.13445229783215490000000000000000000000000000000000e-3 * t790) * t116 + (-0.40356075865519945125000000000000000000000000000000e-1 * t846 + 0.26904050577013296750000000000000000000000000000000e-1 * t848 - 0.16014315819650771875000000000000000000000000000000e-3 * t775 + 0.13345263183042309895833333333333333333333333333333e-4 * t783) * t140 + t199 * t907 + (-0.14395547581531767000000000000000000000000000000000e-2 * t846 + 0.95970317210211780000000000000000000000000000000000e-3 * t848 - 0.57125188815602250000000000000000000000000000000000e-5 * t775 + 0.47604324013001875000000000000000000000000000000000e-6 * t783) * t92 + t52 * t881
  t1122 = (-0.15175714938516591243750000000000000000000000000000e0 * t846 + 0.10117143292344394162500000000000000000000000000000e0 * t848 - 0.60221091025859489062500000000000000000000000000000e-3 * t775 + 0.50184242521549574218750000000000000000000000000000e-4 * t783) * t133 + t194 * t824 + t184 * t869 + (-0.29749609915980499125000000000000000000000000000000e0 * t846 + 0.19833073277320332750000000000000000000000000000000e0 * t848 - 0.11805400760309721875000000000000000000000000000000e-2 * t775 + 0.98378339669247682291666666666666666666666666666667e-4 * t783) * t125 + t189 * t839 + (-0.66108783714833674237500000000000000000000000000000e0 * t786 + 0.60098894286212431125000000000000000000000000000000e0 * t788 - 0.10016482381035405187500000000000000000000000000000e0 * t790) * t99 + (0.24434174127676885976250000000000000000000000000000e0 * t786 - 0.22212885570615350887500000000000000000000000000000e0 * t788 + 0.37021475951025584812500000000000000000000000000000e-1 * t790) * t87 + t178 * t818 + (-0.20451606009930529875000000000000000000000000000000e-1 * t846 + 0.13634404006620353250000000000000000000000000000000e-1 * t848 - 0.81157166706073531250000000000000000000000000000000e-4 * t775 + 0.67630972255061276041666666666666666666666666666667e-5 * t783) * t116 + (0.72479774163284195400000000000000000000000000000000e-1 * t786 - 0.65890703784803814000000000000000000000000000000000e-1 * t788 + 0.10981783964133969000000000000000000000000000000000e-1 * t790) * t140 + t163 * t907 + (-0.79657887063377058975000000000000000000000000000000e0 * t786 + 0.72416260966706417250000000000000000000000000000000e0 * t788 - 0.12069376827784402875000000000000000000000000000000e0 * t790) * t92 + t168 * t881 - 0.11145877912279910869791666666666666666666666666667e-1 * t775
  t1152 = -0.39406812755488791000000000000000000000000000000000e-1 * t790 * t87 + 0.3e1 * t746 * t818 + 0.56817065229729237000000000000000000000000000000000e-3 * t790 * t116 - 0.27146561728928226000000000000000000000000000000000e-2 * t790 * t125 + 0.3e1 * t751 * t818 + 0.3e1 * t754 * t818 + 0.3e1 * t757 * t818 + 0.3e1 * t760 * t818 + 0.3e1 * t728 * t818 + 0.25448301445575582000000000000000000000000000000000e-3 * t790 * t133 + 0.95414797078251930000000000000000000000000000000000e-3 * t790 * t140 - 0.26011607116438383000000000000000000000000000000000e-2 * t790 * t92 - 0.25059937895101080000000000000000000000000000000000e-2 * t790 * t99 + 0.3e1 * t741 * t818 + 0.19451907596748125343750000000000000000000000000000e0 * t818
  t1159 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t855 + t916 + t956 + t986 + t1031 + t1075 + t1122 + t1152))
  vsigma_0_ = 0.2e1 * r0 * t1159
  vlapl_0_ = 0.0e0
  t1163 = 0.5e1 / 0.9e1 * t28 * t55 * t25
  t1164 = f.my_piecewise3(t63, t1163, 0)
  t1172 = f.my_piecewise3(t63, 0, t1163)
  t1183 = f.my_piecewise3(t62, -0.3e1 / 0.2e1 * t69 * t1164 - 0.3e1 / 0.16e2 * t72 * t1164 + 0.3e1 * t400 * t1164, -0.6e1 * t404 * t75 * t1172 - t411 * (0.3e1 * t412 * t1172 + 0.12e2 * t416 * t1172))
  t1184 = t89 * t1183
  t1186 = t87 * t1183
  t1190 = 0.35e2 / 0.2e1 * t1184 - 0.15e2 / 0.2e1 * t1186
  t1192 = t88 * t1183
  t1196 = 0.15e2 / 0.2e1 * t1192 - 0.3e1 / 0.2e1 * t1183
  t1198 = t109 * t1183
  t1203 = 0.315e3 / 0.8e1 * t1198 - 0.105e3 / 0.4e1 * t1192 + 0.15e2 / 0.8e1 * t1183
  t1209 = t121 * t1183
  t1215 = 0.3003e4 / 0.16e2 * t1209 - 0.3465e4 / 0.16e2 * t1198 + 0.945e3 / 0.16e2 * t1192 - 0.35e2 / 0.16e2 * t1183
  t1217 = t112 * t1183
  t1219 = -0.49149175060229317850000000000000000000000000000000e-1 * t1184 + 0.12711844558663081725000000000000000000000000000000e-1 * t1186 + t212 * t1190 - 0.17769411149910220312500000000000000000000000000000e-1 * t1192 + t218 * t1196 + 0.26139891914853820031250000000000000000000000000000e0 * t1198 + t206 * t1203 + t281 * t1203 + t269 * t1183 + t275 * t1196 + t278 * t1190 - 0.38012670012172849743750000000000000000000000000000e0 * t1209 + t263 * t1215 + 0.26485532388814614885000000000000000000000000000000e-1 * t1217
  t1223 = 0.693e3 / 0.8e1 * t1217 - 0.315e3 / 0.4e1 * t1184 + 0.105e3 / 0.8e1 * t1186
  t1238 = t260 * t1183 + t322 * t1183 + t249 * t1190 + t309 * t1190 + t252 * t1196 + t313 * t1196 + t246 * t1203 + t305 * t1203 + t287 * t1215 + t325 * t1215 + t243 * t1223 + t266 * t1223 + t293 * t1223 + t301 * t1223
  t1261 = t108 * t1215 + t152 * t1183 + 0.3e1 * t728 * t1183 + 0.3e1 * t741 * t1183 + 0.3e1 * t746 * t1183 + 0.3e1 * t751 * t1183 + 0.3e1 * t754 * t1183 + 0.3e1 * t757 * t1183 + 0.3e1 * t760 * t1183 + t137 * t1190 + t144 * t1196 + t120 * t1223 + t129 * t1203 + t297 * t1215
  t1276 = t52 * t1196 + t104 * t1183 + t194 * t1203 + t199 * t1190 + t189 * t1223 + t178 * t1183 + t184 * t1215 + t163 * t1190 + t168 * t1196 + t240 * t1223 + t158 * t1203 + t230 * t1183 + t235 * t1215 + 0.19451907596748125343750000000000000000000000000000e0 * t1183
  t1282 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t1219 + t1238 + t1261 + t1276))
  vtau_0_ = 0.2e1 * r0 * t1282
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = s0 * t28
  t35 = t34 * t32
  t38 = 0.65124e1 + t25 * t35 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t33 * t39
  t41 = t26 * t40
  t43 = 0.19300013471975028333333333333333333333333333333333e-3 * t41 - 0.23160016166370034e-2
  t44 = tau0 * t28
  t46 = 0.1e1 / t30 / r0
  t52 = 0.5e1 / 0.9e1 * (t44 * t46 - t35 / 0.8e1) * t20 * t24
  t53 = 0.1e5 <= t52
  t54 = 0.1e5 < t52
  t55 = f.my_piecewise3(t54, t52, 0.1e5)
  t56 = t55 ** 2
  t60 = 0.1e1 / t56 / t55
  t62 = t56 ** 2
  t63 = 0.1e1 / t62
  t66 = f.my_piecewise3(t54, 0.1e5, t52)
  t67 = t66 ** 2
  t68 = 0.1e1 - t67
  t69 = t68 ** 2
  t70 = t69 * t68
  t71 = t67 * t66
  t73 = 0.1e1 + 0.4e1 * t71
  t75 = t71 * t73 + 0.1e1
  t76 = 0.1e1 / t75
  t78 = f.my_piecewise3(t53, -0.1e1 / 0.4e1 + 0.3e1 / 0.4e1 / t56 + t60 / 0.16e2 - 0.3e1 / 0.4e1 * t63, t70 * t76)
  t79 = t78 ** 2
  t80 = t79 * t78
  t81 = t79 ** 2
  t82 = t81 * t80
  t84 = t81 * t78
  t88 = 0.429e3 / 0.16e2 * t82 - 0.693e3 / 0.16e2 * t84 + 0.315e3 / 0.16e2 * t80 - 0.35e2 / 0.16e2 * t78
  t91 = 0.49752384692289725000000000000000000000000000000000e-4 * t41 - 0.5970286163074767e-3
  t92 = t81 * t79
  t96 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t92 - 0.315e3 / 0.16e2 * t81 + 0.105e3 / 0.16e2 * t79
  t99 = 0.13698102009618642500000000000000000000000000000000e-3 * t41 - 0.16437722411542371e-2
  t103 = 0.63e2 / 0.8e1 * t84 - 0.35e2 / 0.4e1 * t80 + 0.15e2 / 0.8e1 * t78
  t106 = t41 / 0.12e2 - 0.1e1
  t107 = t106 ** 2
  t108 = t107 * t106
  t111 = 0.10771414834022212500000000000000000000000000000000e-2 * t108 - 0.53857074170111062500000000000000000000000000000000e-4 * t41 + 0.64628489004133275000000000000000000000000000000000e-3
  t115 = -0.17242384856099025000000000000000000000000000000000e-2 * t108 + 0.86211924280495125000000000000000000000000000000000e-4 * t41 - 0.10345430913659415000000000000000000000000000000000e-2
  t119 = -0.48439703247365670000000000000000000000000000000000e-3 * t108 + 0.24219851623682835000000000000000000000000000000000e-4 * t41 - 0.29063821948419402000000000000000000000000000000000e-3
  t123 = -0.11761090830702190000000000000000000000000000000000e-1 * t108 + 0.58805454153510950000000000000000000000000000000000e-3 * t41 - 0.70566544984213140000000000000000000000000000000000e-2
  t126 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t81 - 0.15e2 / 0.4e1 * t79
  t130 = 0.69555160798906965000000000000000000000000000000000e-2 * t108 - 0.34777580399453482500000000000000000000000000000000e-3 * t41 + 0.41733096479344179000000000000000000000000000000000e-2
  t133 = 0.5e1 / 0.2e1 * t80 - 0.3e1 / 0.2e1 * t78
  t137 = -0.19558970347539547500000000000000000000000000000000e-3 * t108 + 0.97794851737697737500000000000000000000000000000000e-5 * t41 - 0.11735382208523728500000000000000000000000000000000e-3
  t139 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t79
  t143 = -0.42058573865030737500000000000000000000000000000000e-1 * t108 + 0.21029286932515368750000000000000000000000000000000e-2 * t41 - 0.25235144319018442500000000000000000000000000000000e-1
  t146 = -0.94695108716215395000000000000000000000000000000000e-4 + 0.28408532614864618500000000000000000000000000000000e-3 * t107
  t149 = 0.45244269548213710000000000000000000000000000000000e-3 - 0.13573280864464113000000000000000000000000000000000e-2 * t107
  t152 = -0.42413835742625970000000000000000000000000000000000e-4 + 0.12724150722787791000000000000000000000000000000000e-3 * t107
  t155 = -0.15902466179708655000000000000000000000000000000000e-3 + 0.47707398539125965000000000000000000000000000000000e-3 * t107
  t158 = 0.43352678527397305000000000000000000000000000000000e-3 - 0.13005803558219191500000000000000000000000000000000e-2 * t107
  t161 = 0.41766563158501800000000000000000000000000000000000e-3 - 0.12529968947550540000000000000000000000000000000000e-2 * t107
  t163 = t119 * t103 + t152 * t103 + t99 * t103 + t111 * t88 + t115 * t96 + t123 * t126 + t155 * t126 + t130 * t133 + t158 * t133 + t137 * t139 + t161 * t139 + t143 * t78 + t146 * t88 + t149 * t96 + t43 * t88 + t91 * t96
  t165 = 0.65678021259147985000000000000000000000000000000000e-2 - 0.19703406377744395500000000000000000000000000000000e-1 * t107
  t167 = t107 ** 2
  t168 = t167 * t106
  t172 = -0.28791095163063534000000000000000000000000000000000e-3 * t168 + 0.31990105736737260000000000000000000000000000000000e-3 * t108 - 0.57125188815602250000000000000000000000000000000000e-5 * t41 + 0.68550226578722700000000000000000000000000000000000e-4
  t177 = 0.39862659777402616875000000000000000000000000000000e-1 * t168 - 0.44291844197114018750000000000000000000000000000000e-1 * t108 + 0.79092578923417890625000000000000000000000000000000e-3 * t41 - 0.94911094708101468750000000000000000000000000000000e-2
  t182 = -0.13079789489679595987500000000000000000000000000000e-1 * t168 + 0.14533099432977328875000000000000000000000000000000e-1 * t108 - 0.25951963273173801562500000000000000000000000000000e-3 * t41 + 0.31142355927808561875000000000000000000000000000000e-2
  t186 = -0.67226148916077450000000000000000000000000000000000e-5 - 0.78430507068757025000000000000000000000000000000000e-4 * t167 + 0.67226148916077450000000000000000000000000000000000e-4 * t107
  t190 = 0.49942400989450275000000000000000000000000000000000e-4 + 0.58266134487691987500000000000000000000000000000000e-3 * t167 - 0.49942400989450275000000000000000000000000000000000e-3 * t107
  t194 = -0.27229148830605108750000000000000000000000000000000e-4 - 0.31767340302372626875000000000000000000000000000000e-3 * t167 + 0.27229148830605108750000000000000000000000000000000e-3 * t107
  t198 = 0.37092583991169622500000000000000000000000000000000e-3 + 0.43274681323031226250000000000000000000000000000000e-2 * t167 - 0.37092583991169622500000000000000000000000000000000e-2 * t107
  t202 = -0.96423059828501737500000000000000000000000000000000e-4 - 0.11249356979991869375000000000000000000000000000000e-2 * t167 + 0.96423059828501737500000000000000000000000000000000e-3 * t107
  t206 = -0.55795050644137211250000000000000000000000000000000e-3 - 0.65094225751493413125000000000000000000000000000000e-2 * t167 + 0.55795050644137211250000000000000000000000000000000e-2 * t107
  t210 = -0.79128338448365422500000000000000000000000000000000e-3 - 0.92316394856426326250000000000000000000000000000000e-2 * t167 + 0.79128338448365422500000000000000000000000000000000e-2 * t107
  t212 = t167 * t107
  t216 = 0.97801677856368075000000000000000000000000000000000e-3 - 0.45184375169642050650000000000000000000000000000000e-1 * t212 + 0.61615057049511887250000000000000000000000000000000e-1 * t167 - 0.20538352349837295750000000000000000000000000000000e-1 * t107
  t221 = -0.26147104676509450000000000000000000000000000000000e-3 + 0.12079962360547365900000000000000000000000000000000e-1 * t212 - 0.16472675946200953500000000000000000000000000000000e-1 * t167 + 0.54908919820669845000000000000000000000000000000000e-2 * t107
  t226 = 0.28736611494724768750000000000000000000000000000000e-2 - 0.13276314510562843162500000000000000000000000000000e0 * t212 + 0.18104065241676604312500000000000000000000000000000e0 * t167 - 0.60346884138922014375000000000000000000000000000000e-1 * t107
  t231 = 0.23848767573893821875000000000000000000000000000000e-2 - 0.11018130619138945706250000000000000000000000000000e0 * t212 + 0.15024723571553107781250000000000000000000000000000e0 * t167 - 0.50082411905177025937500000000000000000000000000000e-1 * t107
  t236 = -0.88146371311965678125000000000000000000000000000000e-3 + 0.40723623546128143293750000000000000000000000000000e-1 * t212 - 0.55532213926538377218750000000000000000000000000000e-1 * t167 + 0.18510737975512792406250000000000000000000000000000e-1 * t107
  t238 = t194 * t103 + t216 * t103 + t198 * t126 + t221 * t126 + t172 * t133 + t202 * t133 + t226 * t133 + t177 * t139 + t206 * t139 + t231 * t139 + t165 * t78 + t182 * t78 + t186 * t88 + t190 * t96 + t210 * t78 + t236 * t78
  t243 = -0.40903212019861059750000000000000000000000000000000e-2 * t168 + 0.45448013355401177500000000000000000000000000000000e-2 * t108 - 0.81157166706073531250000000000000000000000000000000e-4 * t41 + 0.97388600047288237500000000000000000000000000000000e-3
  t248 = -0.59499219831960998250000000000000000000000000000000e-1 * t168 + 0.66110244257734442500000000000000000000000000000000e-1 * t108 - 0.11805400760309721875000000000000000000000000000000e-2 * t41 + 0.14166480912371666250000000000000000000000000000000e-1
  t253 = -0.30351429877033182487500000000000000000000000000000e-1 * t168 + 0.33723810974481313875000000000000000000000000000000e-1 * t108 - 0.60221091025859489062500000000000000000000000000000e-3 * t41 + 0.72265309231031386875000000000000000000000000000000e-2
  t258 = -0.80712151731039890250000000000000000000000000000000e-2 * t168 + 0.89680168590044322500000000000000000000000000000000e-2 * t108 - 0.16014315819650771875000000000000000000000000000000e-3 * t41 + 0.19217178983580926250000000000000000000000000000000e-2
  t260 = t167 * t108
  t265 = -0.51198844054388814712500000000000000000000000000000e-2 * t260 + 0.82705825010935777612500000000000000000000000000000e-2 * t168 - 0.37593556823152626187500000000000000000000000000000e-2 * t108 + 0.34808848910326505729166666666666666666666666666667e-4 * t41 - 0.41770618692391806875000000000000000000000000000000e-3
  t271 = 0.10392238055870059228125000000000000000000000000000e0 * t260 - 0.16787461474867018753125000000000000000000000000000e0 * t168 + 0.76306643067577357968750000000000000000000000000000e-1 * t108 - 0.70654299136645701822916666666666666666666666666667e-3 * t41 + 0.84785158963974842187500000000000000000000000000000e-2
  t277 = -0.84161970103698270712500000000000000000000000000000e-2 * t260 + 0.13595395170597412961250000000000000000000000000000e-1 * t168 - 0.61797250775442786187500000000000000000000000000000e-2 * t108 + 0.57219676643928505729166666666666666666666666666667e-4 * t41 - 0.68663611972714206875000000000000000000000000000000e-3
  t283 = 0.28759837101854633775000000000000000000000000000000e0 * t260 - 0.46458198395303639175000000000000000000000000000000e0 * t168 + 0.21117362906956199625000000000000000000000000000000e0 * t108 - 0.19553113802737221875000000000000000000000000000000e-2 * t41 + 0.23463736563284666250000000000000000000000000000000e-1
  t289 = -0.26994029096834648062500000000000000000000000000000e0 * t260 + 0.43605739310271354562500000000000000000000000000000e0 * t168 - 0.19820790595577888437500000000000000000000000000000e0 * t108 + 0.18352583884794341145833333333333333333333333333333e-2 * t41 - 0.22023100661753209375000000000000000000000000000000e-1
  t295 = 0.46411448094255891075000000000000000000000000000000e-2 * t260 - 0.74972339229182593275000000000000000000000000000000e-2 * t168 + 0.34078336013264815125000000000000000000000000000000e-2 * t108 - 0.31554014827097051041666666666666666666666666666667e-4 * t41 + 0.37864817792516461250000000000000000000000000000000e-3
  t300 = 0.56738957533354768750000000000000000000000000000000e-4 - 0.26213398380409903162500000000000000000000000000000e-2 * t212 + 0.35745543246013504312500000000000000000000000000000e-2 * t167 - 0.11915181082004501437500000000000000000000000000000e-2 * t107
  t305 = -0.58259907086030593750000000000000000000000000000000e-3 + 0.26916077073746134312500000000000000000000000000000e-1 * t212 - 0.36703741464199274062500000000000000000000000000000e-1 * t167 + 0.12234580488066424687500000000000000000000000000000e-1 * t107
  t308 = 0.42496589149630555000000000000000000000000000000000e-3 * t41 - 0.50995906979556666e-2
  t311 = 0.20814425935415427500000000000000000000000000000000e-3 * t41 - 0.24977311122498513e-2
  t314 = 0.10284428865871160000000000000000000000000000000000e-3 * t41 - 0.12341314639045392e-2
  t317 = 0.10109690061618578333333333333333333333333333333333e-1 * t41 - 0.12131628073942294e0
  t319 = t253 * t103 + t271 * t103 + t258 * t126 + t277 * t126 + t308 * t126 + t283 * t133 + t311 * t133 + t289 * t139 + t314 * t139 + t243 * t88 + t248 * t96 + t265 * t96 + t295 * t78 + t300 * t88 + t305 * t96 + t317 * t78
  t324 = -0.79033878970439743350000000000000000000000000000000e-2 * t260 + 0.12767011218301804695000000000000000000000000000000e-1 * t168 - 0.58031869174099112250000000000000000000000000000000e-2 * t108 + 0.53733212198239918750000000000000000000000000000000e-4 * t41 - 0.64479854637887902500000000000000000000000000000000e-3
  t340 = 0.13669196781387441795125000000000000000000000000000e1 + t324 * t88 + 0.44142553981357691475000000000000000000000000000000e-2 * t92 - 0.12287293765057329462500000000000000000000000000000e-1 * t81 + 0.63559222793315408625000000000000000000000000000000e-2 * t79 + 0.19451907596748125343750000000000000000000000000000e0 * t78 - 0.54303814303104071062500000000000000000000000000000e-1 * t82 + 0.52279783829707640062500000000000000000000000000000e-1 * t84 - 0.5923137049970073437500000000000000000000000000000e-2 * t80 - 0.8047507298914579187500000000000000000000000000000e-2 * t108 + 0.50197247070683313037500000000000000000000000000000e-1 * t168 - 0.38230940935406268093750000000000000000000000000000e0 * t107 - 0.40204197854033482912500000000000000000000000000000e-1 * t260 - 0.57084476241712602812500000000000000000000000000000e-1 * t167 + 0.73000610738035552687500000000000000000000000000000e-1 * t212 - 0.11145877912279910869791666666666666666666666666667e-1 * t41
  t342 = t163 + t238 + t319 + t340
  t346 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t342)
  t354 = 0.1e1 / t30 / t29 / r0
  t357 = t26 * t28 * t354 * t39
  t359 = t20 ** 2
  t362 = t359 / t22 / t21
  t363 = s0 ** 2
  t365 = t29 ** 2
  t370 = t38 ** 2
  t371 = 0.1e1 / t370
  t373 = t362 * t363 * t27 / t18 / t365 / t29 * t371
  t375 = t161 * t78
  t383 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t44 * t32 + t34 * t354 / 0.3e1) * t20 * t24
  t384 = f.my_piecewise3(t54, t383, 0)
  t390 = 0.1e1 / t62 / t55
  t394 = t69 * t76
  t395 = f.my_piecewise3(t54, 0, t383)
  t399 = t75 ** 2
  t401 = t70 / t399
  t402 = t67 * t73
  t405 = t67 ** 2
  t406 = t405 * t66
  t412 = f.my_piecewise3(t53, -0.3e1 / 0.2e1 * t60 * t384 - 0.3e1 / 0.16e2 * t63 * t384 + 0.3e1 * t390 * t384, -0.6e1 * t394 * t66 * t395 - t401 * (0.3e1 * t402 * t395 + 0.12e2 * t406 * t395))
  t417 = -0.2e1 / 0.9e1 * t357 + t373 / 0.54e2
  t418 = t106 * t417
  t421 = t137 * t78
  t430 = t206 * t78
  t433 = t177 * t78
  t436 = t231 * t78
  t439 = t289 * t78
  t442 = t314 * t78
  t447 = 0.29722341099413095652777777777777777777777777777779e-1 * t357 - 0.24768617582844246377314814814814814814814814814816e-2 * t373 + 0.3e1 * t375 * t412 - 0.39406812755488791000000000000000000000000000000000e-1 * t418 * t78 + 0.3e1 * t421 * t412 + 0.56817065229729237000000000000000000000000000000000e-3 * t418 * t88 - 0.27146561728928226000000000000000000000000000000000e-2 * t418 * t96 + 0.25448301445575582000000000000000000000000000000000e-3 * t418 * t103 + 0.3e1 * t430 * t412 + 0.3e1 * t433 * t412 + 0.3e1 * t436 * t412 + 0.3e1 * t439 * t412 + 0.3e1 * t442 * t412 + 0.95414797078251930000000000000000000000000000000000e-3 * t418 * t126
  t452 = t108 * t417
  t457 = t79 * t412
  t460 = 0.15e2 / 0.2e1 * t457 - 0.3e1 / 0.2e1 * t412
  t462 = t167 * t417
  t464 = t107 * t417
  t488 = t84 * t412
  t490 = t80 * t412
  t492 = t78 * t412
  t494 = 0.693e3 / 0.8e1 * t488 - 0.315e3 / 0.4e1 * t490 + 0.105e3 / 0.8e1 * t492
  t500 = t81 * t412
  t504 = 0.315e3 / 0.8e1 * t500 - 0.105e3 / 0.4e1 * t457 + 0.15e2 / 0.8e1 * t412
  t510 = -0.26011607116438383000000000000000000000000000000000e-2 * t418 * t133 - 0.25059937895101080000000000000000000000000000000000e-2 * t418 * t139 + (0.23306453795076795000000000000000000000000000000000e-2 * t452 - 0.99884801978900550000000000000000000000000000000000e-3 * t418) * t96 + t172 * t460 + (0.19931329888701308437500000000000000000000000000000e0 * t462 - 0.13287553259134205625000000000000000000000000000000e0 * t464 - 0.21091354379578104166666666666666666666666666666667e-2 * t357 + 0.17576128649648420138888888888888888888888888888889e-3 * t373) * t139 + (-0.65398947448397979937500000000000000000000000000000e-1 * t462 + 0.43599298298931986625000000000000000000000000000000e-1 * t464 + 0.69205235395130137500000000000000000000000000000000e-3 * t357 - 0.57671029495941781250000000000000000000000000000000e-4 * t373) * t78 + t182 * t412 + (-0.40356075865519945125000000000000000000000000000000e-1 * t462 + 0.26904050577013296750000000000000000000000000000000e-1 * t464 + 0.42704842185735391666666666666666666666666666666667e-3 * t357 - 0.35587368488112826388888888888888888888888888888889e-4 * t373) * t126 + (-0.44997427919967477500000000000000000000000000000000e-2 * t452 + 0.19284611965700347500000000000000000000000000000000e-2 * t418) * t133 + t202 * t460 + t190 * t494 + (-0.12706936120949050750000000000000000000000000000000e-2 * t452 + 0.54458297661210217500000000000000000000000000000000e-3 * t418) * t103 + t194 * t504 + (-0.31372202827502810000000000000000000000000000000000e-3 * t452 + 0.13445229783215490000000000000000000000000000000000e-3 * t418) * t88
  t512 = t92 * t412
  t517 = 0.3003e4 / 0.16e2 * t512 - 0.3465e4 / 0.16e2 * t500 + 0.945e3 / 0.16e2 * t457 - 0.35e2 / 0.16e2 * t412
  t546 = 0.35e2 / 0.2e1 * t490 - 0.15e2 / 0.2e1 * t492
  t560 = t186 * t517 + (0.32314244502066637500000000000000000000000000000000e-2 * t464 + 0.14361886445362950000000000000000000000000000000000e-3 * t357 - 0.11968238704469125000000000000000000000000000000000e-4 * t373) * t88 + t111 * t517 + (-0.51727154568297075000000000000000000000000000000000e-2 * t464 - 0.22989846474798700000000000000000000000000000000000e-3 * t357 + 0.19158205395665583333333333333333333333333333333333e-4 * t373) * t96 + t115 * t494 + (-0.26037690300597365250000000000000000000000000000000e-1 * t452 + 0.11159010128827442250000000000000000000000000000000e-1 * t418) * t139 + (-0.36926557942570530500000000000000000000000000000000e-1 * t452 + 0.15825667689673084500000000000000000000000000000000e-1 * t418) * t78 + t210 * t412 + (0.17309872529212490500000000000000000000000000000000e-1 * t452 - 0.74185167982339245000000000000000000000000000000000e-2 * t418) * t126 + t198 * t546 + t149 * t494 + (-0.58676911042618642500000000000000000000000000000000e-3 * t464 - 0.26078627130052730000000000000000000000000000000000e-4 * t357 + 0.21732189275043941666666666666666666666666666666667e-5 * t373) * t139 + (-0.12617572159509221250000000000000000000000000000000e0 * t464 - 0.56078098486707650000000000000000000000000000000000e-2 * t357 + 0.46731748738923041666666666666666666666666666666667e-3 * t373) * t78 + t143 * t412
  t599 = t146 * t517 + (-0.35283272492106570000000000000000000000000000000000e-1 * t464 - 0.15681454440936253333333333333333333333333333333333e-2 * t357 + 0.13067878700780211111111111111111111111111111111111e-3 * t373) * t126 + t123 * t546 + (0.20866548239672089500000000000000000000000000000000e-1 * t464 + 0.92740214398542620000000000000000000000000000000000e-3 * t357 - 0.77283511998785516666666666666666666666666666666667e-4 * t373) * t133 + t130 * t460 + (-0.14531910974209701000000000000000000000000000000000e-2 * t464 - 0.64586270996487560000000000000000000000000000000000e-4 * t357 + 0.53821892497072966666666666666666666666666666666667e-5 * t373) * t103 + t119 * t504 + (-0.27425143642323093333333333333333333333333333333333e-3 * t357 + 0.22854286368602577777777777777777777777777777777778e-4 * t373) * t139 + (-0.26959173497649542222222222222222222222222222222221e-1 * t357 + 0.22465977914707951851851851851851851851851851851851e-2 * t373) * t78 + t317 * t412 + (-0.11332423773234814666666666666666666666666666666667e-2 * t357 + 0.94436864776956788888888888888888888888888888888889e-4 * t373) * t126 + t308 * t546 + (-0.55505135827774473333333333333333333333333333333333e-3 * t357 + 0.46254279856478727777777777777777777777777777777778e-4 * t373) * t133 + t311 * t460
  t622 = t212 * t417
  t638 = (-0.13267302584610593333333333333333333333333333333333e-3 * t357 + 0.11056085487175494444444444444444444444444444444444e-4 * t373) * t96 + t91 * t494 + (-0.36528272025649713333333333333333333333333333333333e-3 * t357 + 0.30440226688041427777777777777777777777777777777778e-4 * t373) * t103 + t99 * t504 + t165 * t412 + (-0.51466702591933408888888888888888888888888888888888e-3 * t357 + 0.42888918826611174074074074074074074074074074074073e-4 * t373) * t88 + t43 * t517 + t158 * t460 + t152 * t504 + t155 * t546 + t271 * t504 + (-0.35839190838072170298750000000000000000000000000000e-1 * t622 + 0.41352912505467888806250000000000000000000000000000e-1 * t462 - 0.11278067046945787856250000000000000000000000000000e-1 * t464 - 0.92823597094204015277777777777777777777777777777779e-4 * t357 + 0.77352997578503346064814814814814814814814814814815e-5 * t373) * t96 + t265 * t494 + (-0.55323715279307820345000000000000000000000000000000e-1 * t622 + 0.63835056091509023475000000000000000000000000000000e-1 * t462 - 0.17409560752229733675000000000000000000000000000000e-1 * t464 - 0.14328856586197311666666666666666666666666666666667e-3 * t357 + 0.11940713821831093055555555555555555555555555555556e-4 * t373) * t88
  t664 = t168 * t417
  t692 = t324 * t517 + 0.19451907596748125343750000000000000000000000000000e0 * t412 + (-0.58913379072588789498750000000000000000000000000000e-1 * t622 + 0.67976975852987064806250000000000000000000000000000e-1 * t462 - 0.18539175232632835856250000000000000000000000000000e-1 * t464 - 0.15258580438380934861111111111111111111111111111111e-3 * t357 + 0.12715483698650779050925925925925925925925925925926e-4 * t373) * t126 + t277 * t546 + (0.20131885971298243642500000000000000000000000000000e1 * t622 - 0.23229099197651819587500000000000000000000000000000e1 * t462 + 0.63352088720868598875000000000000000000000000000000e0 * t464 + 0.52141636807299258333333333333333333333333333333333e-2 * t357 - 0.43451364006082715277777777777777777777777777777778e-3 * t373) * t133 + t283 * t460 + (0.72745666391090414596875000000000000000000000000000e0 * t622 - 0.83937307374335093765625000000000000000000000000000e0 * t462 + 0.22891992920273207390625000000000000000000000000000e0 * t464 + 0.18841146436438853819444444444444444444444444444445e-2 * t357 - 0.15700955363699044849537037037037037037037037037037e-3 * t373) * t103 + (0.16149646244247680587500000000000000000000000000000e0 * t664 - 0.14681496585679709625000000000000000000000000000000e0 * t452 + 0.24469160976132849375000000000000000000000000000000e-1 * t418) * t96 + t305 * t494 + (-0.18895820367784253643750000000000000000000000000000e1 * t622 + 0.21802869655135677281250000000000000000000000000000e1 * t462 - 0.59462371786733665312500000000000000000000000000000e0 * t464 - 0.48940223692784909722222222222222222222222222222221e-2 * t357 + 0.40783519743987424768518518518518518518518518518518e-3 * t373) * t139 - 0.28142938497823438038750000000000000000000000000000e0 * t622 + (0.32488013665979123752500000000000000000000000000000e-1 * t622 - 0.37486169614591296637500000000000000000000000000000e-1 * t462 + 0.10223500803979444537500000000000000000000000000000e-1 * t464 + 0.84144039538925469444444444444444444444444444444445e-4 * t357 - 0.70120032949104557870370370370370370370370370370371e-5 * t373) * t78 + t295 * t412 + (-0.15728039028245941897500000000000000000000000000000e-1 * t664 + 0.14298217298405401725000000000000000000000000000000e-1 * t452 - 0.23830362164009002875000000000000000000000000000000e-2 * t418) * t88
  t725 = t221 * t546 + (-0.79657887063377058975000000000000000000000000000000e0 * t664 + 0.72416260966706417250000000000000000000000000000000e0 * t452 - 0.12069376827784402875000000000000000000000000000000e0 * t418) * t133 + t226 * t460 + (-0.27110625101785230390000000000000000000000000000000e0 * t664 + 0.24646022819804754900000000000000000000000000000000e0 * t452 - 0.41076704699674591500000000000000000000000000000000e-1 * t418) * t103 + t216 * t504 + t300 * t517 + 0.26139891914853820031250000000000000000000000000000e0 * t500 - 0.17769411149910220312500000000000000000000000000000e-1 * t457 + (-0.20451606009930529875000000000000000000000000000000e-1 * t462 + 0.13634404006620353250000000000000000000000000000000e-1 * t464 + 0.21641911121619608333333333333333333333333333333333e-3 * t357 - 0.18034925934683006944444444444444444444444444444444e-4 * t373) * t88 + t243 * t517 - 0.38012670012172849743750000000000000000000000000000e0 * t512 + (-0.66108783714833674237500000000000000000000000000000e0 * t664 + 0.60098894286212431125000000000000000000000000000000e0 * t452 - 0.10016482381035405187500000000000000000000000000000e0 * t418) * t139 + 0.43800366442821331612500000000000000000000000000000e0 * t664 - 0.22833790496685041125000000000000000000000000000000e0 * t452
  t764 = -0.76461881870812536187500000000000000000000000000000e0 * t418 + (0.24434174127676885976250000000000000000000000000000e0 * t664 - 0.22212885570615350887500000000000000000000000000000e0 * t452 + 0.37021475951025584812500000000000000000000000000000e-1 * t418) * t78 + t236 * t412 + (0.72479774163284195400000000000000000000000000000000e-1 * t664 - 0.65890703784803814000000000000000000000000000000000e-1 * t452 + 0.10981783964133969000000000000000000000000000000000e-1 * t418) * t126 - 0.49149175060229317850000000000000000000000000000000e-1 * t490 + 0.12711844558663081725000000000000000000000000000000e-1 * t492 + t258 * t546 + (-0.14395547581531767000000000000000000000000000000000e-2 * t462 + 0.95970317210211780000000000000000000000000000000000e-3 * t464 + 0.15233383684160600000000000000000000000000000000000e-4 * t357 - 0.12694486403467166666666666666666666666666666666667e-5 * t373) * t133 + 0.25098623535341656518750000000000000000000000000000e0 * t462 - 0.24142521896743737562500000000000000000000000000000e-1 * t464 + (-0.29749609915980499125000000000000000000000000000000e0 * t462 + 0.19833073277320332750000000000000000000000000000000e0 * t464 + 0.31481068694159258333333333333333333333333333333333e-2 * t357 - 0.26234223911799381944444444444444444444444444444444e-3 * t373) * t96 + 0.26485532388814614885000000000000000000000000000000e-1 * t488 + t248 * t494 + (-0.15175714938516591243750000000000000000000000000000e0 * t462 + 0.10117143292344394162500000000000000000000000000000e0 * t464 + 0.16058957606895863750000000000000000000000000000000e-2 * t357 - 0.13382464672413219791666666666666666666666666666667e-3 * t373) * t103 + t253 * t504
  t772 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t342 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t447 + t510 + t560 + t599 + t638 + t692 + t725 + t764))
  vrho_0_ = 0.2e1 * r0 * t772 + 0.2e1 * t346
  t781 = t362 * s0 * t27 / t18 / t365 / r0 * t371
  t784 = 0.5e1 / 0.72e2 * t25 * t33
  t785 = f.my_piecewise3(t54, -t784, 0)
  t793 = f.my_piecewise3(t54, 0, -t784)
  t804 = f.my_piecewise3(t53, -0.3e1 / 0.2e1 * t60 * t785 - 0.3e1 / 0.16e2 * t63 * t785 + 0.3e1 * t390 * t785, -0.6e1 * t394 * t66 * t793 - t401 * (0.3e1 * t402 * t793 + 0.12e2 * t406 * t793))
  t809 = t25 * t40
  t812 = t809 / 0.12e2 - t781 / 0.144e3
  t813 = t106 * t812
  t836 = 0.92882315935665923914930555555555555555555555555558e-3 * t781 + 0.3e1 * t439 * t804 + 0.3e1 * t442 * t804 + 0.25448301445575582000000000000000000000000000000000e-3 * t813 * t103 + 0.95414797078251930000000000000000000000000000000000e-3 * t813 * t126 - 0.26011607116438383000000000000000000000000000000000e-2 * t813 * t133 - 0.25059937895101080000000000000000000000000000000000e-2 * t813 * t139 + 0.3e1 * t375 * t804 - 0.39406812755488791000000000000000000000000000000000e-1 * t813 * t78 - 0.27146561728928226000000000000000000000000000000000e-2 * t813 * t96 + 0.3e1 * t421 * t804 + 0.56817065229729237000000000000000000000000000000000e-3 * t813 * t88 + 0.3e1 * t430 * t804 + 0.3e1 * t433 * t804
  t839 = t212 * t812
  t841 = t167 * t812
  t843 = t107 * t812
  t849 = t81 * t804
  t851 = t79 * t804
  t854 = 0.315e3 / 0.8e1 * t849 - 0.105e3 / 0.4e1 * t851 + 0.15e2 / 0.8e1 * t804
  t863 = t80 * t804
  t865 = t78 * t804
  t867 = 0.35e2 / 0.2e1 * t863 - 0.15e2 / 0.2e1 * t865
  t876 = t84 * t804
  t880 = 0.693e3 / 0.8e1 * t876 - 0.315e3 / 0.4e1 * t863 + 0.105e3 / 0.8e1 * t865
  t889 = t92 * t804
  t894 = 0.3003e4 / 0.16e2 * t889 - 0.3465e4 / 0.16e2 * t849 + 0.945e3 / 0.16e2 * t851 - 0.35e2 / 0.16e2 * t804
  t910 = 0.3e1 * t436 * t804 + (0.72745666391090414596875000000000000000000000000000e0 * t839 - 0.83937307374335093765625000000000000000000000000000e0 * t841 + 0.22891992920273207390625000000000000000000000000000e0 * t843 - 0.70654299136645701822916666666666666666666666666667e-3 * t809 + 0.58878582613871418185763888888888888888888888888889e-4 * t781) * t103 + t271 * t854 + (-0.58913379072588789498750000000000000000000000000000e-1 * t839 + 0.67976975852987064806250000000000000000000000000000e-1 * t841 - 0.18539175232632835856250000000000000000000000000000e-1 * t843 + 0.57219676643928505729166666666666666666666666666667e-4 * t809 - 0.47683063869940421440972222222222222222222222222222e-5 * t781) * t126 + t277 * t867 + (-0.35839190838072170298750000000000000000000000000000e-1 * t839 + 0.41352912505467888806250000000000000000000000000000e-1 * t841 - 0.11278067046945787856250000000000000000000000000000e-1 * t843 + 0.34808848910326505729166666666666666666666666666667e-4 * t809 - 0.29007374091938754774305555555555555555555555555556e-5 * t781) * t96 + t265 * t880 + (-0.55323715279307820345000000000000000000000000000000e-1 * t839 + 0.63835056091509023475000000000000000000000000000000e-1 * t841 - 0.17409560752229733675000000000000000000000000000000e-1 * t843 + 0.53733212198239918750000000000000000000000000000000e-4 * t809 - 0.44777676831866598958333333333333333333333333333333e-5 * t781) * t88 + t324 * t894 + (0.10284428865871160000000000000000000000000000000000e-3 * t809 - 0.85703573882259666666666666666666666666666666666667e-5 * t781) * t139 + (0.10109690061618578333333333333333333333333333333333e-1 * t809 - 0.84247417180154819444444444444444444444444444444442e-3 * t781) * t78 + t317 * t804 + (0.42496589149630555000000000000000000000000000000000e-3 * t809 - 0.35413824291358795833333333333333333333333333333333e-4 * t781) * t126 + t308 * t867
  t918 = 0.15e2 / 0.2e1 * t851 - 0.3e1 / 0.2e1 * t804
  t926 = t168 * t812
  t928 = t108 * t812
  t961 = (0.20814425935415427500000000000000000000000000000000e-3 * t809 - 0.17345354946179522916666666666666666666666666666667e-4 * t781) * t133 + t311 * t918 + (0.13698102009618642500000000000000000000000000000000e-3 * t809 - 0.11415085008015535416666666666666666666666666666667e-4 * t781) * t103 + t99 * t854 + t295 * t804 + (-0.15728039028245941897500000000000000000000000000000e-1 * t926 + 0.14298217298405401725000000000000000000000000000000e-1 * t928 - 0.23830362164009002875000000000000000000000000000000e-2 * t813) * t88 + t300 * t894 + (0.20131885971298243642500000000000000000000000000000e1 * t839 - 0.23229099197651819587500000000000000000000000000000e1 * t841 + 0.63352088720868598875000000000000000000000000000000e0 * t843 - 0.19553113802737221875000000000000000000000000000000e-2 * t809 + 0.16294261502281018229166666666666666666666666666667e-3 * t781) * t133 + t283 * t918 + (-0.18895820367784253643750000000000000000000000000000e1 * t839 + 0.21802869655135677281250000000000000000000000000000e1 * t841 - 0.59462371786733665312500000000000000000000000000000e0 * t843 + 0.18352583884794341145833333333333333333333333333333e-2 * t809 - 0.15293819903995284288194444444444444444444444444444e-3 * t781) * t139 + t226 * t918 + (-0.27110625101785230390000000000000000000000000000000e0 * t926 + 0.24646022819804754900000000000000000000000000000000e0 * t928 - 0.41076704699674591500000000000000000000000000000000e-1 * t813) * t103 + t216 * t854 + (0.16149646244247680587500000000000000000000000000000e0 * t926 - 0.14681496585679709625000000000000000000000000000000e0 * t928 + 0.24469160976132849375000000000000000000000000000000e-1 * t813) * t96
  t1005 = t305 * t880 + (0.32488013665979123752500000000000000000000000000000e-1 * t839 - 0.37486169614591296637500000000000000000000000000000e-1 * t841 + 0.10223500803979444537500000000000000000000000000000e-1 * t843 - 0.31554014827097051041666666666666666666666666666667e-4 * t809 + 0.26295012355914209201388888888888888888888888888889e-5 * t781) * t78 - 0.28142938497823438038750000000000000000000000000000e0 * t839 + t236 * t804 + (-0.20451606009930529875000000000000000000000000000000e-1 * t841 + 0.13634404006620353250000000000000000000000000000000e-1 * t843 - 0.81157166706073531250000000000000000000000000000000e-4 * t809 + 0.67630972255061276041666666666666666666666666666667e-5 * t781) * t88 + t243 * t894 + (0.72479774163284195400000000000000000000000000000000e-1 * t926 - 0.65890703784803814000000000000000000000000000000000e-1 * t928 + 0.10981783964133969000000000000000000000000000000000e-1 * t813) * t126 + t221 * t867 + (-0.79657887063377058975000000000000000000000000000000e0 * t926 + 0.72416260966706417250000000000000000000000000000000e0 * t928 - 0.12069376827784402875000000000000000000000000000000e0 * t813) * t133 + t172 * t918 + (-0.15175714938516591243750000000000000000000000000000e0 * t841 + 0.10117143292344394162500000000000000000000000000000e0 * t843 - 0.60221091025859489062500000000000000000000000000000e-3 * t809 + 0.50184242521549574218750000000000000000000000000000e-4 * t781) * t103 + t253 * t854 + (-0.29749609915980499125000000000000000000000000000000e0 * t841 + 0.19833073277320332750000000000000000000000000000000e0 * t843 - 0.11805400760309721875000000000000000000000000000000e-2 * t809 + 0.98378339669247682291666666666666666666666666666667e-4 * t781) * t96 + t248 * t880
  t1054 = (-0.66108783714833674237500000000000000000000000000000e0 * t926 + 0.60098894286212431125000000000000000000000000000000e0 * t928 - 0.10016482381035405187500000000000000000000000000000e0 * t813) * t139 + 0.43800366442821331612500000000000000000000000000000e0 * t926 + (0.24434174127676885976250000000000000000000000000000e0 * t926 - 0.22212885570615350887500000000000000000000000000000e0 * t928 + 0.37021475951025584812500000000000000000000000000000e-1 * t813) * t78 + (-0.65398947448397979937500000000000000000000000000000e-1 * t841 + 0.43599298298931986625000000000000000000000000000000e-1 * t843 - 0.25951963273173801562500000000000000000000000000000e-3 * t809 + 0.21626636060978167968750000000000000000000000000000e-4 * t781) * t78 + t182 * t804 + (-0.31372202827502810000000000000000000000000000000000e-3 * t928 + 0.13445229783215490000000000000000000000000000000000e-3 * t813) * t88 + t186 * t894 + (-0.40356075865519945125000000000000000000000000000000e-1 * t841 + 0.26904050577013296750000000000000000000000000000000e-1 * t843 - 0.16014315819650771875000000000000000000000000000000e-3 * t809 + 0.13345263183042309895833333333333333333333333333333e-4 * t781) * t126 + t258 * t867 + (-0.14395547581531767000000000000000000000000000000000e-2 * t841 + 0.95970317210211780000000000000000000000000000000000e-3 * t843 - 0.57125188815602250000000000000000000000000000000000e-5 * t809 + 0.47604324013001875000000000000000000000000000000000e-6 * t781) * t133 + (-0.44997427919967477500000000000000000000000000000000e-2 * t928 + 0.19284611965700347500000000000000000000000000000000e-2 * t813) * t133 + t202 * t918 + (-0.12706936120949050750000000000000000000000000000000e-2 * t928 + 0.54458297661210217500000000000000000000000000000000e-3 * t813) * t103 + t194 * t854
  t1096 = (0.23306453795076795000000000000000000000000000000000e-2 * t928 - 0.99884801978900550000000000000000000000000000000000e-3 * t813) * t96 + t190 * t880 + (0.19931329888701308437500000000000000000000000000000e0 * t841 - 0.13287553259134205625000000000000000000000000000000e0 * t843 + 0.79092578923417890625000000000000000000000000000000e-3 * t809 - 0.65910482436181575520833333333333333333333333333333e-4 * t781) * t139 + 0.25098623535341656518750000000000000000000000000000e0 * t841 + t123 * t867 + (0.20866548239672089500000000000000000000000000000000e-1 * t843 - 0.34777580399453482500000000000000000000000000000000e-3 * t809 + 0.28981316999544568750000000000000000000000000000000e-4 * t781) * t133 + t130 * t918 + (-0.58676911042618642500000000000000000000000000000000e-3 * t843 + 0.97794851737697737500000000000000000000000000000000e-5 * t809 - 0.81495709781414781250000000000000000000000000000000e-6 * t781) * t139 + (-0.14531910974209701000000000000000000000000000000000e-2 * t843 + 0.24219851623682835000000000000000000000000000000000e-4 * t809 - 0.20183209686402362500000000000000000000000000000000e-5 * t781) * t103 + t119 * t854 + (-0.51727154568297075000000000000000000000000000000000e-2 * t843 + 0.86211924280495125000000000000000000000000000000000e-4 * t809 - 0.71843270233745937500000000000000000000000000000000e-5 * t781) * t96 + t115 * t880 + (0.17309872529212490500000000000000000000000000000000e-1 * t928 - 0.74185167982339245000000000000000000000000000000000e-2 * t813) * t126 + t198 * t867
  t1133 = t149 * t880 + (-0.12617572159509221250000000000000000000000000000000e0 * t843 + 0.21029286932515368750000000000000000000000000000000e-2 * t809 - 0.17524405777096140625000000000000000000000000000000e-3 * t781) * t78 - 0.24142521896743737562500000000000000000000000000000e-1 * t843 + t143 * t804 + (-0.26037690300597365250000000000000000000000000000000e-1 * t928 + 0.11159010128827442250000000000000000000000000000000e-1 * t813) * t139 - 0.22833790496685041125000000000000000000000000000000e0 * t928 - 0.76461881870812536187500000000000000000000000000000e0 * t813 + (-0.36926557942570530500000000000000000000000000000000e-1 * t928 + 0.15825667689673084500000000000000000000000000000000e-1 * t813) * t78 + t210 * t804 + (0.32314244502066637500000000000000000000000000000000e-2 * t843 - 0.53857074170111062500000000000000000000000000000000e-4 * t809 + 0.44880895141759218750000000000000000000000000000000e-5 * t781) * t88 + t111 * t894 + t146 * t894 + (-0.35283272492106570000000000000000000000000000000000e-1 * t843 + 0.58805454153510950000000000000000000000000000000000e-3 * t809 - 0.49004545127925791666666666666666666666666666666667e-4 * t781) * t126 + (0.49752384692289725000000000000000000000000000000000e-4 * t809 - 0.41460320576908104166666666666666666666666666666667e-5 * t781) * t96
  t1152 = t91 * t880 + 0.26485532388814614885000000000000000000000000000000e-1 * t876 - 0.49149175060229317850000000000000000000000000000000e-1 * t863 + 0.12711844558663081725000000000000000000000000000000e-1 * t865 + t165 * t804 + (0.19300013471975028333333333333333333333333333333333e-3 * t809 - 0.16083344559979190277777777777777777777777777777777e-4 * t781) * t88 + t43 * t894 - 0.38012670012172849743750000000000000000000000000000e0 * t889 + 0.26139891914853820031250000000000000000000000000000e0 * t849 - 0.17769411149910220312500000000000000000000000000000e-1 * t851 + t158 * t918 + t152 * t854 + t155 * t867 - 0.11145877912279910869791666666666666666666666666667e-1 * t809 + 0.19451907596748125343750000000000000000000000000000e0 * t804
  t1159 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t836 + t910 + t961 + t1005 + t1054 + t1096 + t1133 + t1152))
  vsigma_0_ = 0.2e1 * r0 * t1159
  vlapl_0_ = 0.0e0
  t1163 = 0.5e1 / 0.9e1 * t28 * t46 * t25
  t1164 = f.my_piecewise3(t54, t1163, 0)
  t1172 = f.my_piecewise3(t54, 0, t1163)
  t1183 = f.my_piecewise3(t53, -0.3e1 / 0.2e1 * t60 * t1164 - 0.3e1 / 0.16e2 * t63 * t1164 + 0.3e1 * t390 * t1164, -0.6e1 * t394 * t66 * t1172 - t401 * (0.3e1 * t402 * t1172 + 0.12e2 * t406 * t1172))
  t1185 = t81 * t1183
  t1187 = t79 * t1183
  t1192 = 0.315e3 / 0.8e1 * t1185 - 0.105e3 / 0.4e1 * t1187 + 0.15e2 / 0.8e1 * t1183
  t1194 = t80 * t1183
  t1196 = t78 * t1183
  t1200 = 0.35e2 / 0.2e1 * t1194 - 0.15e2 / 0.2e1 * t1196
  t1204 = 0.15e2 / 0.2e1 * t1187 - 0.3e1 / 0.2e1 * t1183
  t1207 = t92 * t1183
  t1213 = 0.3003e4 / 0.16e2 * t1207 - 0.3465e4 / 0.16e2 * t1185 + 0.945e3 / 0.16e2 * t1187 - 0.35e2 / 0.16e2 * t1183
  t1215 = t84 * t1183
  t1220 = 0.693e3 / 0.8e1 * t1215 - 0.315e3 / 0.4e1 * t1194 + 0.105e3 / 0.8e1 * t1196
  t1223 = 0.19451907596748125343750000000000000000000000000000e0 * t1183 + 0.26139891914853820031250000000000000000000000000000e0 * t1185 - 0.17769411149910220312500000000000000000000000000000e-1 * t1187 + t216 * t1192 - 0.49149175060229317850000000000000000000000000000000e-1 * t1194 + 0.12711844558663081725000000000000000000000000000000e-1 * t1196 + t221 * t1200 + t226 * t1204 + t236 * t1183 - 0.38012670012172849743750000000000000000000000000000e0 * t1207 + t243 * t1213 + 0.26485532388814614885000000000000000000000000000000e-1 * t1215 + t248 * t1220 + t253 * t1192
  t1238 = t111 * t1213 + t115 * t1220 + t182 * t1183 + t210 * t1183 + t119 * t1192 + t194 * t1192 + t123 * t1200 + t198 * t1200 + t258 * t1200 + t130 * t1204 + t172 * t1204 + t202 * t1204 + t186 * t1213 + t190 * t1220
  t1254 = t143 * t1183 + t165 * t1183 + t295 * t1183 + t152 * t1192 + t155 * t1200 + t277 * t1200 + t158 * t1204 + t283 * t1204 + t146 * t1213 + t300 * t1213 + t43 * t1213 + t149 * t1220 + t265 * t1220 + t305 * t1220
  t1276 = t317 * t1183 + 0.3e1 * t375 * t1183 + 0.3e1 * t421 * t1183 + 0.3e1 * t430 * t1183 + 0.3e1 * t433 * t1183 + 0.3e1 * t436 * t1183 + 0.3e1 * t439 * t1183 + 0.3e1 * t442 * t1183 + t271 * t1192 + t99 * t1192 + t308 * t1200 + t311 * t1204 + t324 * t1213 + t91 * t1220
  t1282 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t1223 + t1238 + t1254 + t1276))
  vtau_0_ = 0.2e1 * r0 * t1282
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

