# Generated by Django 5.2.6 on 2025-10-15 08:39

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="BiddingRound",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, max_length=200, null=True, verbose_name="Name"
                    ),
                ),
                (
                    "season",
                    models.CharField(
                        blank=True, max_length=200, null=True, verbose_name="Season"
                    ),
                ),
                ("start_time", models.DateTimeField(verbose_name="Start")),
                ("end_time", models.DateTimeField(verbose_name="End time")),
                (
                    "guiding_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Guiding value",
                    ),
                ),
                (
                    "comment",
                    models.TextField(blank=True, null=True, verbose_name="Comment"),
                ),
            ],
            options={
                "ordering": ["-start_time"],
            },
        ),
        migrations.CreateModel(
            name="BiddingRoundTarget",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveBigIntegerField(verbose_name="Object ID")),
                (
                    "biddinground",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="targets",
                        to="biddingrounds.biddinground",
                        verbose_name="Bidding round",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                        verbose_name="Content type",
                    ),
                ),
            ],
            options={
                "unique_together": {("biddinground", "content_type", "object_id")},
            },
        ),
        migrations.CreateModel(
            name="Bid",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "green_contribution_amount",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=6,
                        verbose_name="Green bid (comfort zone)",
                    ),
                ),
                (
                    "yellow_contribution_amount",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=6,
                        verbose_name="Yellow bid (feasible)",
                    ),
                ),
                (
                    "red_contribution_amount",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=6,
                        verbose_name="Red bid (pain threshold)",
                    ),
                ),
                (
                    "bidder",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Bidder",
                    ),
                ),
                (
                    "biddinground_target",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="bids",
                        to="biddingrounds.biddingroundtarget",
                        verbose_name="Bidding target",
                    ),
                ),
            ],
            options={
                "constraints": [
                    models.UniqueConstraint(
                        fields=("biddinground_target", "bidder"),
                        name="unique_bid_per_target_per_bidder",
                    )
                ],
            },
        ),
    ]
