# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 ip_range: pulumi.Input[builtins.str],
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expose_routes_to_vswitch: Optional[pulumi.Input[builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[builtins.str] ip_range: IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        :param pulumi.Input[builtins.bool] delete_protection: Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[builtins.bool] expose_routes_to_vswitch: Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[builtins.str] name: Name of the Network to create (must be unique per project).
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if expose_routes_to_vswitch is not None:
            pulumi.set(__self__, "expose_routes_to_vswitch", expose_routes_to_vswitch)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[builtins.str]:
        """
        IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter(name="exposeRoutesToVswitch")
    def expose_routes_to_vswitch(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        return pulumi.get(self, "expose_routes_to_vswitch")

    @expose_routes_to_vswitch.setter
    def expose_routes_to_vswitch(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "expose_routes_to_vswitch", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels (key-value pairs) should be created with.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Network to create (must be unique per project).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expose_routes_to_vswitch: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[builtins.bool] delete_protection: Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[builtins.bool] expose_routes_to_vswitch: Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        :param pulumi.Input[builtins.str] ip_range: IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[builtins.str] name: Name of the Network to create (must be unique per project).
        """
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if expose_routes_to_vswitch is not None:
            pulumi.set(__self__, "expose_routes_to_vswitch", expose_routes_to_vswitch)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter(name="exposeRoutesToVswitch")
    def expose_routes_to_vswitch(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        return pulumi.get(self, "expose_routes_to_vswitch")

    @expose_routes_to_vswitch.setter
    def expose_routes_to_vswitch(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "expose_routes_to_vswitch", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels (key-value pairs) should be created with.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Network to create (must be unique per project).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("hcloud:index/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expose_routes_to_vswitch: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Hetzner Cloud Network to represent a Network in the Hetzner Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        priv_net = hcloud.Network("privNet",
            name="my-net",
            ip_range="10.0.1.0/24")
        ```

        ## Import

        Networks can be imported using its `id`:

        ```sh
        $ pulumi import hcloud:index/network:Network example "$NETWORK_ID"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] delete_protection: Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[builtins.bool] expose_routes_to_vswitch: Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        :param pulumi.Input[builtins.str] ip_range: IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[builtins.str] name: Name of the Network to create (must be unique per project).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Hetzner Cloud Network to represent a Network in the Hetzner Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        priv_net = hcloud.Network("privNet",
            name="my-net",
            ip_range="10.0.1.0/24")
        ```

        ## Import

        Networks can be imported using its `id`:

        ```sh
        $ pulumi import hcloud:index/network:Network example "$NETWORK_ID"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 expose_routes_to_vswitch: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_range: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["expose_routes_to_vswitch"] = expose_routes_to_vswitch
            if ip_range is None and not opts.urn:
                raise TypeError("Missing required property 'ip_range'")
            __props__.__dict__["ip_range"] = ip_range
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
        super(Network, __self__).__init__(
            'hcloud:index/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delete_protection: Optional[pulumi.Input[builtins.bool]] = None,
            expose_routes_to_vswitch: Optional[pulumi.Input[builtins.bool]] = None,
            ip_range: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] delete_protection: Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        :param pulumi.Input[builtins.bool] expose_routes_to_vswitch: Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        :param pulumi.Input[builtins.str] ip_range: IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels (key-value pairs) should be created with.
        :param pulumi.Input[builtins.str] name: Name of the Network to create (must be unique per project).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["expose_routes_to_vswitch"] = expose_routes_to_vswitch
        __props__.__dict__["ip_range"] = ip_range
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable delete protection. See "Delete Protection" in the Provider Docs for details.
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="exposeRoutesToVswitch")
    def expose_routes_to_vswitch(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable exposing the routes to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        return pulumi.get(self, "expose_routes_to_vswitch")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Output[builtins.str]:
        """
        IP Range of the whole Network which must span all included subnets and route destinations. Must be one of the private ipv4 ranges of RFC1918.
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels (key-value pairs) should be created with.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Network to create (must be unique per project).
        """
        return pulumi.get(self, "name")

