"""
Copyright (c) 2010-present by Jaxl Innovations Private Limited.

All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, is strictly prohibited.
"""

from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.call_usage_by_currency_response import CallUsageByCurrencyResponse


T = TypeVar("T", bound="CallUsageResponse")


@attr.s(auto_attribs=True)
class CallUsageResponse:
    """
    Attributes:
        results (List['CallUsageByCurrencyResponse']):
        is_finalized (Union[Unset, None, bool]):
    """

    results: List["CallUsageByCurrencyResponse"]
    is_finalized: Union[Unset, None, bool] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        results = []
        for results_item_data in self.results:
            results_item = results_item_data.to_dict()

            results.append(results_item)

        is_finalized = self.is_finalized

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "results": results,
            }
        )
        if is_finalized is not UNSET:
            field_dict["is_finalized"] = is_finalized

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.call_usage_by_currency_response import CallUsageByCurrencyResponse

        d = src_dict.copy()
        results = []
        _results = d.pop("results")
        for results_item_data in _results:
            results_item = CallUsageByCurrencyResponse.from_dict(results_item_data)

            results.append(results_item)

        is_finalized = d.pop("is_finalized", UNSET)

        call_usage_response = cls(
            results=results,
            is_finalized=is_finalized,
        )

        call_usage_response.additional_properties = d
        return call_usage_response

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
