These variables take precedence over the settings in `config.yaml`. Variables marked as required can instead be set in the global config.

|                       Name                       |             Default Value              |Required|                                   Description                                    |               Setting name                |
|--------------------------------------------------|----------------------------------------|--------|----------------------------------------------------------------------------------|-------------------------------------------|
|KPOPS_PIPELINE_BASE_DIR                           |.                                       |False   |Base directory to the pipelines (default is current working directory)            |pipeline_base_dir                          |
|KPOPS_KAFKA_BROKERS                               |                                        |True    |The comma separated Kafka brokers address.                                        |kafka_brokers                              |
|KPOPS_TOPIC_NAME_CONFIG__DEFAULT_OUTPUT_TOPIC_NAME|${pipeline.name}-${component.name}      |False   |Configures the value for the variable ${output_topic_name}                        |topic_name_config.default_output_topic_name|
|KPOPS_TOPIC_NAME_CONFIG__DEFAULT_ERROR_TOPIC_NAME |${pipeline.name}-${component.name}-error|False   |Configures the value for the variable ${error_topic_name}                         |topic_name_config.default_error_topic_name |
|KPOPS_SCHEMA_REGISTRY__ENABLED                    |False                                   |False   |Whether the Schema Registry handler should be initialized.                        |schema_registry.enabled                    |
|KPOPS_SCHEMA_REGISTRY__URL                        |http://localhost:8081/                  |False   |Address of the Schema Registry.                                                   |schema_registry.url                        |
|KPOPS_SCHEMA_REGISTRY__TIMEOUT                    |30                                      |False   |Operation timeout in seconds.                                                     |schema_registry.timeout                    |
|KPOPS_KAFKA_REST__URL                             |http://localhost:8082/                  |False   |Address of the Kafka REST Proxy.                                                  |kafka_rest.url                             |
|KPOPS_KAFKA_REST__TIMEOUT                         |30                                      |False   |Operation timeout in seconds.                                                     |kafka_rest.timeout                         |
|KPOPS_KAFKA_CONNECT__URL                          |http://localhost:8083/                  |False   |Address of Kafka Connect.                                                         |kafka_connect.url                          |
|KPOPS_KAFKA_CONNECT__TIMEOUT                      |30                                      |False   |Operation timeout in seconds.                                                     |kafka_connect.timeout                      |
|KPOPS_CREATE_NAMESPACE                            |False                                   |False   |Flag for `helm upgrade --install`. Create the release namespace if not present.   |create_namespace                           |
|KPOPS_HELM_CONFIG__CONTEXT                        |                                        |False   |Name of kubeconfig context (`--kube-context`)                                     |helm_config.context                        |
|KPOPS_HELM_CONFIG__DEBUG                          |False                                   |False   |Run Helm in Debug mode                                                            |helm_config.debug                          |
|KPOPS_HELM_CONFIG__API_VERSION                    |                                        |False   |Kubernetes API version used for `Capabilities.APIVersions`                        |helm_config.api_version                    |
|KPOPS_HELM_DIFF_CONFIG__IGNORE                    |                                        |True    |Set of keys that should not be checked.                                           |helm_diff_config.ignore                    |
|KPOPS_RETAIN_CLEAN_JOBS                           |False                                   |False   |Whether to retain clean up jobs in the cluster or uninstall the, after completion.|retain_clean_jobs                          |
|KPOPS_STRIMZI_TOPIC                               |                                        |False   |Configuration for Strimzi Kafka Topics.                                           |strimzi_topic                              |
|KPOPS_OPERATION_MODE                              |managed                                 |False   |The operation mode of KPOps (managed, manifest, argo).                            |operation_mode                             |
