# Migrate from V2 to V3

[**Jump to the summary**](#summary)

## [Use hash and trim long Helm release names instead of only trimming](https://github.com/bakdata/kpops/pull/390)

KPOps handles long (more than 53 characters) Helm releases names differently. Helm will not find your (long) old release names anymore. Therefore, it is recommended that you should once destroy your pipeline with KPOps v2 to remove old Helm release names. After a clean destroy, re-deploy your pipeline with the KPOps v3.

For example if you have a component with the Helm release name `example-component-name-too-long-fake-fakefakefakefakefake`. The new release name will shorten the original name to 53 characters and then replace the last 6 characters of the trimmed name with the first 5 characters of the result of SHA-1(helm_release_name).

<!-- dprint-ignore-start -->

```console
example-component-name-too-long-fake-fakefakef-0a7fc ----> 53 chars
---------------------------------------------- -----
  ^Shortened helm_release_name                 ^first 5 characters of SHA1(helm_release_name)
```

<!-- dprint-ignore-end -->

## [Create HelmApp component](https://github.com/bakdata/kpops/pull/370)

All Helm-specific parts of the built-in [`KubernetesApp`](../core-concepts/components/kubernetes-app.md) have been extracted to a new child component that is more appropriately named [`HelmApp`](../core-concepts/components/helm-app.md). It has to be renamed in your existing pipeline defintions and custom components module.

#### pipeline.yaml

```diff
-- type: kubernetes-app
+- type: helm-app
   name: foo
```

#### custom_module.py

```diff
- from kpops.components import KubernetesApp
+ from kpops.components import HelmApp


- class CustomHelmApp(KubernetesApp):
+ class CustomHelmApp(HelmApp):
      ...
```

## [Create StreamsBootstrap component & refactor cleanup jobs as individual HelmApp](https://github.com/bakdata/kpops/pull/398)

Previously the default `KafkaApp` component configured the [streams-bootstrap](https://bakdata.github.io/streams-bootstrap/) Helm Charts. Now, this component is no longer tied to Helm (or Kubernetes). Instead, there is a new `StreamsBootstrap` component that configures the Helm Chart repository for the components that use it, e.g. `StreamsApp` and `ProducerApp`. If you are using non-default values for the Helm Chart repository or version, it has to be updated as shown below.

#### defaults.yaml

```diff
  kafka-app:
    app:
      streams: ...

+ streams-bootstrap:
    repo_config: ...
    version: ...
```

## [Refactor Kafka Connector resetter as individual HelmApp](https://github.com/bakdata/kpops/pull/400)

Internally, the [Kafka Connector resetter](bakdata-kafka-connect-resetter/kafka-connect-resetter) is now its own standard `HelmApp`, removing a lot of the shared code.
It is configured using the `resetter_namespace` (formerly `namespace`) and `resetter_values` attributes.

#### defaults.yaml

```diff
  kafka-connector:
-   namespace: my-namespace
+   resetter_namespace: my-namespace
```

## [Make Kafka REST Proxy & Kafka Connect hosts default and improve Schema Registry config](https://github.com/bakdata/kpops/pull/354)

The breaking changes target the `config.yaml` file:

- The `schema_registry_url` is replaced with `schema_registry.url` (default `http://localhost:8081`) and `schema_registry.enabled` (default `false`).

- `kafka_rest_host` is renamed to `kafka_rest.url` (default `http://localhost:8082`).

- `kafka_connect_host` is replaced with `kafka_connect.url` (default `http://localhost:8083`).

- `brokers` is renamed to `kafka_brokers`.

The environment variable names of these config fields changed respectively. Please refer to the [environment variables documentation page](../core-concepts/variables/environment_variables.md) to see the newest changes.

#### config.yaml

```diff
  environment: development
- brokers: "http://k8kafka-cp-kafka-headless.kpops.svc.cluster.local:9092"
- kafka_rest_host: "http://my-custom-rest.url:8082"
- kafka_connect_host: "http://my-custom-connect.url:8083"
- schema_registry_url: "http://my-custom-sr.url:8081"
+ kafka_brokers: "http://k8kafka-cp-kafka-headless.kpops.svc.cluster.local:9092"
+ kafka_rest:
+   url: "http://my-custom-rest.url:8082"
+ kafka_connect:
+   url: "http://my-custom-connect.url:8083"
+ schema_registry:
+   enabled: true
+   url: "http://my-custom-sr.url:8081"
```

#### pipeline.yaml and default.yaml

The variable is now called `kafka_brokers`.

```diff
...
  app:
    streams:
-     brokers: ${brokers}
+     brokers: ${kafka_brokers}
      schemaRegistryUrl: ${schema_registry_url}
    nameOverride: override-with-this-name
    imageTag: "1.0.0"
...
```

## [Define custom components module & pipeline base dir globally](https://github.com/bakdata/kpops/pull/387)

<!-- dprint-ignore-start -->

!!! warning inline end
    **The previous CLI parameters have been removed.**

<!-- dprint-ignore-end -->

The options for a custom `components_module` and `pipeline_base_dir` are now global settings, defined in `config.yaml`.

#### config.yaml

```diff
  kafka_brokers: "http://k8kafka-cp-kafka-headless.kpops.svc.cluster.local:9092"
  environment: development
+ components_module: components
+ pipeline_base_dir: pipelines
```

## [Move GitHub action to repsitory root](https://github.com/bakdata/kpops/pull/356)

The location of the GitHub action has changed, and it's now available directly as `bakdata/kpops`.

You'll need to change it in your GitHub CI workflows.

```diff
steps:
  - name: kpops deploy
-   uses: bakdata/kpops/actions/kpops-runner@main
+   uses: bakdata/kpops@main
    with:
      command: deploy --execute
      # ...
```

## [Allow overriding config files](https://github.com/bakdata/kpops/pull/391)

Specifying the environment is no longer mandatory. If not defined, only the global files will be used.

`environment` is no longer specified in `config.yaml`. Instead, it can be either set via the CLI flag `--environment` or with the environment variable `KPOPS_ENVIRONMENT`.

The `--config` flag in the CLI now points to the directory that contains `config*.yaml` files. The files to be used are resolved based on the provided (or not) `environment`.

#### config.yaml

```diff
- environment: development
  kafka_brokers: "http://k8kafka-cp-kafka-headless.kpops.svc.cluster.local:9092"
  schema_registry:
    enabled: true
    url: "http://my-custom-sr.url:8081"
```

## [Change substitution variables separator to `.`](https://github.com/bakdata/kpops/pull/388)

The delimiter in the substitution variables is changed to `.`.

#### pipeline.yaml and default.yaml

```diff
steps:
  - type: scheduled-producer
    app:
      labels:
-       app_type: "${component_type}"
-       app_name: "${component_name}"
-       app_schedule: "${component_app_schedule}"
+       app_type: "${component.type}"
+       app_name: "${component.name}"
+       app_schedule: "${component.app.schedule}"
```

#### config.yaml

```diff
topic_name_config:
- default_error_topic_name: "${pipeline_name}-${component_name}-dead-letter-topic"
- default_output_topic_name: "${pipeline_name}-${component_name}-topic"
+ default_error_topic_name: "${pipeline_name}-${component.name}-dead-letter-topic"
+ default_output_topic_name: "${pipeline_name}-${component.name}-topic"
```

## [Refactor generate template for Python API usage](https://github.com/bakdata/kpops/pull/380)

The `template` method of every pipeline component has been renamed to `manifest` as it is no longer strictly tied to Helm template. Instead, it can be used to render the final resources of a component, such as Kubernetes manifests.

There is also a new `kpops manifest` command replacing the existing `kpops generate --template` flag.

If you're using this functionality in your custom components, it needs to be updated.

```diff
  from kpops.components.base_components.models.resource import Resource

  @override
- def template(self) -> None:
+ def manifest(self) -> Resource:
  """Render final component resources, e.g. Kubernetes manifests."""
      return []  # list of manifests
```

## [Namespace substitution vars](https://github.com/bakdata/kpops/pull/408)

The global configuration variables are now namespaced under the config key, such as `${config.kafka_brokers}`, `${config.schema_registry.url}`. Same with pipeline variables, e.g. `${pipeline_name} → ${pipeline.name}`.
This would make it more uniform with the existing `${component.<key>}` variables.

#### pipeline.yaml

```diff
  name: kafka-app
- prefix: ${pipeline_name}-
+ prefix: ${pipeline.name}-
  app:
    streams:
-     brokers: ${kafka_brokers}
-     schemaRegistryUrl: ${schema_registry.url}
+     brokers: ${config.kafka_brokers}
+     schemaRegistryUrl: ${config.schema_registry.url}
```

## Summary

<!-- dprint-ignore-start -->

!!! warning

    [**Helm will not find your (long) old release names anymore.**](#use-hash-and-trim-long-helm-release-names-instead-of-only-trimming)

??? example "defaults.yaml"

    ```diff
      kafka-app:
        app:
          streams: ...

    + streams-bootstrap:
        repo_config: ...
        version: ...
    ```

??? example "pipeline.yaml"

    ```diff
    - - type: kubernetes-app
    + - type: helm-app
      ...
      - type: kafka-app
        app:
    -     brokers: ${brokers}
    +     brokers: ${config.kafka_brokers}
          labels:
    -       app_schedule: "${component_app_schedule}"
    +       app_schedule: "${component.app.schedule}"
      ...
      - type: kafka-connector
    -   namespace: my-namespace
    +   resetter_namespace: my-namespace
      ...
    ```

??? example "config.yaml"

    ```diff
    - environment: development

    + components_module: components

    + pipeline_base_dir: pipelines

    - brokers: "http://k8kafka-cp-kafka-headless.kpops.svc.cluster.local:9092"
    + kafka_brokers: "http://k8kafka-cp-kafka-headless.kpops.svc.cluster.local:9092"

    - kafka_rest_host: "http://my-custom-rest.url:8082"
    + kafka_rest:
    +   url: "http://my-custom-rest.url:8082"

    - kafka_connect_host: "http://my-custom-connect.url:8083"
    + kafka_connect:
    +   url: "http://my-custom-connect.url:8083"

    - schema_registry_url: "http://my-custom-sr.url:8081"
    + schema_registry:
    +   enabled: true
    +   url: "http://my-custom-sr.url:8081"

      topic_name_config:
    - default_error_topic_name: "${pipeline_name}-${component_name}-dead-letter-topic"
    + default_error_topic_name: "${pipeline.name}-${component.name}-dead-letter-topic"
      ...
    ```

??? example "custom_module.py"

    ```diff
    - from kpops.components import KubernetesApp
    + from kpops.components import HelmApp
    + from kpops.components.base_components.models.resource import Resource

    - class CustomHelmApp(KubernetesApp):
    + class CustomHelmApp(HelmApp):

      @override
    - def template(self) -> None:
    + def manifest(self) -> Resource:
      """Render final component resources, e.g. Kubernetes manifests."""
          return []  # list of manifests
      ...
    ```

??? example "github_ci_workflow.yaml"

    ```diff
      steps:
        - name: ...
    -     uses: bakdata/kpops/actions/kpops-runner@main
    +     uses: bakdata/kpops@main
      ...
    ```

<!-- dprint-ignore-end -->
