# Migrate from V3 to V4

## [Distribute defaults across multiple files](https://github.com/bakdata/kpops/pull/438/)

<!-- dprint-ignore-start -->

!!! warning inline end
    **The `--defaults` flag is removed**

<!-- dprint-ignore-end -->

It is possible now to use multiple default values. The `defaults.yaml` (or `defaults_<env>.yaml`) files can be distributed across multiple files. These will be picked up by KPOps and get merged into a single `pipeline.yaml` file.
KPOps starts from reading the default files from where the pipeline path is defined and picks up every defaults file on its way to where the `pipeline_base_dir` is defined.

For example, imagine the following folder structure:

```
└─ pipelines
   └── distributed-defaults
       ├── defaults.yaml
       ├── defaults_dev.yaml
       └── pipeline-deep
           ├── defaults.yaml
           └── pipeline.yaml
```

The `pipeline_base_dir` is configured to `pipelines`. Now if we generate this pipeline with the following command:

```bash
kpops generate \
      --environment dev
      ./pipelines/distributed-defaults/pipeline-deep/pipeline.yaml
```

The defaults would be picked in the following order (high to low priority):

- `./pipelines/distributed-defaults/pipeline-deep/defaults.yaml`
- `./pipelines/distributed-defaults/defaults_dev.yaml`
- `./pipelines/distributed-defaults/defaults.yaml`

The deepest `defaults.yaml` file in the folder hierarchy (i.e., the closest one to the `pipeline.yaml`) overwrites the higher-level defaults' values.
