# Migrate from V6 to V7

## [Automatic loading of namespaced custom components](https://github.com/bakdata/kpops/pull/500)

KPOps is now distributed as a Python namespace package (as defined by [PEP 420](https://peps.python.org/pep-0420/)). This allows us to standardize the namespace `kpops.components` for both builtin and custom pipeline components.

As a result of the restructure, some imports need to be adjusted:

**KPOps Python API**

```diff
- import kpops
+ import kpops.api as kpops
```

**builtin KPOps components**

```diff
- from kpops.components import (
-     HelmApp,
-     KafkaApp,
-     KafkaConnector,
-     KafkaSinkConnector,
-     KafkaSourceConnector,
-     KubernetesApp,
-     StreamsBootstrap,
-     ProducerApp,
-     StreamsApp,
-     PipelineComponent,
-     StreamsApp,
-     ProducerApp,
- )
+ from kpops.components.base_components import (
+     HelmApp,
+     KafkaApp,
+     KafkaConnector,
+     KafkaSinkConnector,
+     KafkaSourceConnector,
+     KubernetesApp,
+     PipelineComponent,
+ )
+ from kpops.components.streams_bootstrap import (
+     StreamsBootstrap,
+     StreamsApp,
+     ProducerApp,
+ )
```

### your custom KPOps components

#### config.yaml

```diff
- components_module: components
```

#### Python module

```diff
- components/__init__.py
+ kpops/components/custom/__init__.py
```

## [Rename app field](https://github.com/bakdata/kpops/pull/506)

The `app` attribute of the builtin KPOps components has been renamed to better differentiate them. Both your `pipeline.yaml` and `defaults.yaml` files have to be updated, e.g.:

#### defaults.yaml

```diff
  kubernetes-app:
-   app: {}
+   values: {}

  helm-app:
-   app: {}
+   values: {}

  kafka-app:
-   app: {}
+   values: {}

  streams-app:
-   app: {}
+   values: {}

  producer-app:
-   app: {}
+   values: {}

  kafka-connector:
-   app: {}
+   config: {}

  kafka-source-connector:
-   app: {}
+   config: {}

  kafka-sink-connector:
-   app: {}
+   config: {}
```

## [Call destroy from inside of reset or clean](https://github.com/bakdata/kpops/pull/501)

Before v7, the KPOps CLI executed `destroy` before running `reset/clean` to ensure the component was destroyed.

This logic has changed. The `destroy` method is now called within the `PipelineComponent`'s `reset`/`clean`.

During migrating to v7, you should check your custom components and see if they override the `reset`/`clean` methods. If so, you need to call the supermethod `reset`/`clean` to trigger the `destroy` inside the parent class. Alternatively, if you are implementing the `PipelineComponent` class, you need to call the `destroy` method at the beginning of the method.

#### components.py

For example, when creating a custom `StreamsApp` or `ProducerApp` (or any other custom component), you **must** call the supermethod `reset`/`clean` to execute the `destroy` in the parent class. **Otherwise, the logic of destroy will not be executed!**

````diff
class MyStreamsApp(StreamsApp):

    @override
    async def clean(self, dry_run: bool) -> None:
+       await super().clean(dry_run)
        # Some custom clean logic
        # ...
        ```diff
        
 
class MyCustomComponent(PipelineComponent):
    
    @override
    async def destroy(self, dry_run: bool) -> None:
        # Some custom destroy logic
        # ...

    @override
    async def clean(self, dry_run: bool) -> None:
+       await super().clean(dry_run)
        # Some custom clean logic
        # ...
````
