# Migrate from V7 to V8

## [Add support for streams-bootstrap v3](https://github.com/bakdata/kpops/pull/519)

From now on KPOps supports [streams-bootstrap v3](https://github.com/bakdata/streams-bootstrap/releases/tag/3.0.1) as its default component. The previous streams-bootstrap version (below 3.x.x) is marked as deprecated and will be removed in a future version of KPOps. If you don't want to migrate your producer or streams app to v3, you should suffix your components with `-v2`. Here is an example of a `pipeline.yaml` file.

#### pipeline.yaml

```diff
- - type: producer-app
+ - type: producer-app-v2

- - type: streams-app
+ - type: streams-app-v2

# rest of your pipeline
```

#### my-components.py

```diff
- class MyStreamsApp(StreamsApp):
+ class MyStreamsApp(StreamsAppV2):
    ...
```

<!-- dprint-ignore-start -->

!!! info The default components
    The `streams-boostrap`, `streams-app`, and `producer-app` now all take the Helm values of streams-bootstrap version 3. You can find these values under the [Helm charts documentation](https://github.com/bakdata/streams-bootstrap/tree/master/charts) or by [referring to the Base model definitions](https://github.com/bakdata/kpops/tree/v8/kpops/components/streams_bootstrap).

<!-- dprint-ignore-end -->

## [Rename role to label](https://github.com/bakdata/kpops/pull/525)

The keyword `role` is renamed to `label`. You need to replace it in your `pipeline.yaml`, `defaults.yaml`, and the Python components definition files. Here is a simple example of the `defaults.yaml`.

#### defaults.yaml

```diff
streams-app-v2:
  values:
    streams:
      brokers: localhost:9092
  from:
    topics:
      my-labeled-input-topic:
-       role: my-input-topic-label
+       label: my-input-topic-label
      my-labeled-input-pattern:
        type: pattern
-       role: my-input-topic-labeled-pattern
+       label: my-input-topic-labeled-pattern

  to:
    topics:
      my-labeled-topic-output:
-       role: my-output-topic-label
+       label: my-output-topic-label

# rest of your pipeline
```

## [Make KafkaApp responsible for deploying/cleaning streams bootstrap components](https://github.com/bakdata/kpops/pull/522)

The `KafkaApp` component now only contains the deployment logic of the stream-bootstrap applications (streams-app, producer-app). It should not be used in the `defaults.yaml` nor the `pipeline.yaml`. If you are using it, it should be replaced by `streams-bootstrap`.

#### defaults.yaml

```diff
- kafka-app:
+ streams-bootstrap-v2:
    values:
      streams:
        brokers: 127.0.0.1:9092
        schemaRegistryUrl: 127.0.0.1:8081
```
