# Migrate from V8 to V9

## [Introduce KPOps operation and manifest resources for deployment](https://github.com/bakdata/kpops/pull/541)

The `kpops manifest` command and `kpops.manifest()` API have been **removed**.

Resource manifesting is now integrated into the _operation_ commands (`deploy`, `destroy`, `reset`, `clean`) through the new **operation mode** feature.

To manifest resources, you can:

- Pass `--operation-mode manifest` when executing `kpops` commands.
- Set the operation mode by defining the `KPOPS_OPERATION_MODE` environment variable.

## [Manifest toSection with Strimzi KafkaTopic](https://github.com/bakdata/kpops/pull/545)

KPOps now supports generating valid Kubernetes KafkaTopic resources compatible with [Strimzi](https://github.com/strimzi/strimzi-kafka-operator/blob/main/examples/topic/kafka-topic.yaml). When using manifest or argo as the operation_mode, you must specify the Strimzi cluster label to ensure the topics are recognized by the deployed Strimzi Topic Operator.

```diff
operation_mode: manifest

+ strimzi_topic:
+  label:
+     strimzi.io/cluster: my-cluster

# rest of your config
```

<!-- dprint-ignore-start -->

!!! info Standalone topic operator deployment
     Refer to the [Strimzi documentation on deploying a standalone topic operator](https://strimzi.io/docs/operators/latest/deploying#deploying-the-topic-operator-standalone-str) for more details.

<!-- dprint-ignore-end -->

## [Drop support for Python 3.10](https://github.com/bakdata/kpops/pull/561)

KPOps V9 no longer supports Python 3.10. Ensure your environment is running Python 3.11 to 3.12.

#### Action Required:

Upgrade your Python version to a supported version (3.11 or 3.12).
Update your virtual environments and CI pipelines to reflect this change.
