use crate::bindings::init_logger_once;
use crate::core::lazy_data_resolve_entrypoint;
use log::error;

/// Running the CLI directly.
pub fn main() -> anyhow::Result<()> {
    init_logger_once();

    // Pass the first CLI argument as the download directory, if provided.
    let download_dir = std::env::args().nth(1);
    if let Err(e) = lazy_data_resolve_entrypoint(download_dir, None, "".to_string()) {
        error!("Error during execution: {}", e);
        std::process::exit(1);
    }
    Ok(())
}
