# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogConfigArgs', 'LogConfig']

@pulumi.input_type
class LogConfigArgs:
    def __init__(__self__, *,
                 data_source_uid: pulumi.Input[_builtins.str],
                 default_config: pulumi.Input[_builtins.bool],
                 priority: pulumi.Input[_builtins.int],
                 entity_property_to_log_label_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_label: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_by_span_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_by_trace_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogConfig resource.
        :param pulumi.Input[_builtins.str] data_source_uid: DataSource to be queried (e.g., a Loki instance).
        :param pulumi.Input[_builtins.bool] default_config: Is it the default config, therefore undeletable?
        :param pulumi.Input[_builtins.int] priority: Priority of the log configuration. A lower number means a higher priority.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity_property_to_log_label_mapping: Mapping of entity properties to log labels.
        :param pulumi.Input[_builtins.str] error_label: Error label to filter logs.
        :param pulumi.Input[_builtins.bool] filter_by_span_id: Filter logs by span ID.
        :param pulumi.Input[_builtins.bool] filter_by_trace_id: Filter logs by trace ID.
        :param pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]] matches: List of match rules for entity properties.
        :param pulumi.Input[_builtins.str] name: The name of the log configuration.
        """
        pulumi.set(__self__, "data_source_uid", data_source_uid)
        pulumi.set(__self__, "default_config", default_config)
        pulumi.set(__self__, "priority", priority)
        if entity_property_to_log_label_mapping is not None:
            pulumi.set(__self__, "entity_property_to_log_label_mapping", entity_property_to_log_label_mapping)
        if error_label is not None:
            pulumi.set(__self__, "error_label", error_label)
        if filter_by_span_id is not None:
            pulumi.set(__self__, "filter_by_span_id", filter_by_span_id)
        if filter_by_trace_id is not None:
            pulumi.set(__self__, "filter_by_trace_id", filter_by_trace_id)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dataSourceUid")
    def data_source_uid(self) -> pulumi.Input[_builtins.str]:
        """
        DataSource to be queried (e.g., a Loki instance).
        """
        return pulumi.get(self, "data_source_uid")

    @data_source_uid.setter
    def data_source_uid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_uid", value)

    @_builtins.property
    @pulumi.getter(name="defaultConfig")
    def default_config(self) -> pulumi.Input[_builtins.bool]:
        """
        Is it the default config, therefore undeletable?
        """
        return pulumi.get(self, "default_config")

    @default_config.setter
    def default_config(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "default_config", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Priority of the log configuration. A lower number means a higher priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="entityPropertyToLogLabelMapping")
    def entity_property_to_log_label_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Mapping of entity properties to log labels.
        """
        return pulumi.get(self, "entity_property_to_log_label_mapping")

    @entity_property_to_log_label_mapping.setter
    def entity_property_to_log_label_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entity_property_to_log_label_mapping", value)

    @_builtins.property
    @pulumi.getter(name="errorLabel")
    def error_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error label to filter logs.
        """
        return pulumi.get(self, "error_label")

    @error_label.setter
    def error_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_label", value)

    @_builtins.property
    @pulumi.getter(name="filterBySpanId")
    def filter_by_span_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Filter logs by span ID.
        """
        return pulumi.get(self, "filter_by_span_id")

    @filter_by_span_id.setter
    def filter_by_span_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "filter_by_span_id", value)

    @_builtins.property
    @pulumi.getter(name="filterByTraceId")
    def filter_by_trace_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Filter logs by trace ID.
        """
        return pulumi.get(self, "filter_by_trace_id")

    @filter_by_trace_id.setter
    def filter_by_trace_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "filter_by_trace_id", value)

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]]]:
        """
        List of match rules for entity properties.
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]]]):
        pulumi.set(self, "matches", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LogConfigState:
    def __init__(__self__, *,
                 data_source_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_property_to_log_label_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_label: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_by_span_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_by_trace_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering LogConfig resources.
        :param pulumi.Input[_builtins.str] data_source_uid: DataSource to be queried (e.g., a Loki instance).
        :param pulumi.Input[_builtins.bool] default_config: Is it the default config, therefore undeletable?
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity_property_to_log_label_mapping: Mapping of entity properties to log labels.
        :param pulumi.Input[_builtins.str] error_label: Error label to filter logs.
        :param pulumi.Input[_builtins.bool] filter_by_span_id: Filter logs by span ID.
        :param pulumi.Input[_builtins.bool] filter_by_trace_id: Filter logs by trace ID.
        :param pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]] matches: List of match rules for entity properties.
        :param pulumi.Input[_builtins.str] name: The name of the log configuration.
        :param pulumi.Input[_builtins.int] priority: Priority of the log configuration. A lower number means a higher priority.
        """
        if data_source_uid is not None:
            pulumi.set(__self__, "data_source_uid", data_source_uid)
        if default_config is not None:
            pulumi.set(__self__, "default_config", default_config)
        if entity_property_to_log_label_mapping is not None:
            pulumi.set(__self__, "entity_property_to_log_label_mapping", entity_property_to_log_label_mapping)
        if error_label is not None:
            pulumi.set(__self__, "error_label", error_label)
        if filter_by_span_id is not None:
            pulumi.set(__self__, "filter_by_span_id", filter_by_span_id)
        if filter_by_trace_id is not None:
            pulumi.set(__self__, "filter_by_trace_id", filter_by_trace_id)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="dataSourceUid")
    def data_source_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DataSource to be queried (e.g., a Loki instance).
        """
        return pulumi.get(self, "data_source_uid")

    @data_source_uid.setter
    def data_source_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_uid", value)

    @_builtins.property
    @pulumi.getter(name="defaultConfig")
    def default_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is it the default config, therefore undeletable?
        """
        return pulumi.get(self, "default_config")

    @default_config.setter
    def default_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_config", value)

    @_builtins.property
    @pulumi.getter(name="entityPropertyToLogLabelMapping")
    def entity_property_to_log_label_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Mapping of entity properties to log labels.
        """
        return pulumi.get(self, "entity_property_to_log_label_mapping")

    @entity_property_to_log_label_mapping.setter
    def entity_property_to_log_label_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entity_property_to_log_label_mapping", value)

    @_builtins.property
    @pulumi.getter(name="errorLabel")
    def error_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error label to filter logs.
        """
        return pulumi.get(self, "error_label")

    @error_label.setter
    def error_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_label", value)

    @_builtins.property
    @pulumi.getter(name="filterBySpanId")
    def filter_by_span_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Filter logs by span ID.
        """
        return pulumi.get(self, "filter_by_span_id")

    @filter_by_span_id.setter
    def filter_by_span_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "filter_by_span_id", value)

    @_builtins.property
    @pulumi.getter(name="filterByTraceId")
    def filter_by_trace_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Filter logs by trace ID.
        """
        return pulumi.get(self, "filter_by_trace_id")

    @filter_by_trace_id.setter
    def filter_by_trace_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "filter_by_trace_id", value)

    @_builtins.property
    @pulumi.getter
    def matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]]]:
        """
        List of match rules for entity properties.
        """
        return pulumi.get(self, "matches")

    @matches.setter
    def matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigMatchArgs']]]]):
        pulumi.set(self, "matches", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of the log configuration. A lower number means a higher priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)


@pulumi.type_token("grafana:assert/logConfig:LogConfig")
class LogConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_property_to_log_label_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_label: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_by_span_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_by_trace_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogConfigMatchArgs', 'LogConfigMatchArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages Asserts Log Configuration through Grafana API.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        production = grafana.assert_.LogConfig("production",
            name="production",
            priority=1000,
            default_config=False,
            data_source_uid="grafanacloud-logs",
            error_label="error",
            matches=[
                {
                    "property": "asserts_entity_type",
                    "op": "EQUALS",
                    "values": ["Service"],
                },
                {
                    "property": "environment",
                    "op": "EQUALS",
                    "values": [
                        "production",
                        "staging",
                    ],
                },
                {
                    "property": "site",
                    "op": "EQUALS",
                    "values": [
                        "us-east-1",
                        "us-west-2",
                    ],
                },
            ],
            entity_property_to_log_label_mapping={
                "otel_namespace": "service_namespace",
                "otel_service": "service_name",
                "environment": "env",
                "site": "region",
            },
            filter_by_span_id=True,
            filter_by_trace_id=True)
        development = grafana.assert_.LogConfig("development",
            name="development",
            priority=2000,
            default_config=True,
            data_source_uid="elasticsearch-dev",
            error_label="error",
            matches=[
                {
                    "property": "asserts_entity_type",
                    "op": "EQUALS",
                    "values": ["Service"],
                },
                {
                    "property": "environment",
                    "op": "EQUALS",
                    "values": [
                        "development",
                        "testing",
                    ],
                },
                {
                    "property": "site",
                    "op": "EQUALS",
                    "values": ["us-east-1"],
                },
                {
                    "property": "service",
                    "op": "EQUALS",
                    "values": ["api"],
                },
            ],
            entity_property_to_log_label_mapping={
                "otel_namespace": "service_namespace",
                "otel_service": "service_name",
                "environment": "env",
                "site": "region",
                "service": "app",
            },
            filter_by_span_id=True,
            filter_by_trace_id=True)
        minimal = grafana.assert_.LogConfig("minimal",
            name="minimal",
            priority=3000,
            default_config=False,
            data_source_uid="loki-minimal",
            matches=[{
                "property": "asserts_entity_type",
                "op": "IS_NOT_NULL",
                "values": [],
            }])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:assert/logConfig:LogConfig name "{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_uid: DataSource to be queried (e.g., a Loki instance).
        :param pulumi.Input[_builtins.bool] default_config: Is it the default config, therefore undeletable?
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity_property_to_log_label_mapping: Mapping of entity properties to log labels.
        :param pulumi.Input[_builtins.str] error_label: Error label to filter logs.
        :param pulumi.Input[_builtins.bool] filter_by_span_id: Filter logs by span ID.
        :param pulumi.Input[_builtins.bool] filter_by_trace_id: Filter logs by trace ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogConfigMatchArgs', 'LogConfigMatchArgsDict']]]] matches: List of match rules for entity properties.
        :param pulumi.Input[_builtins.str] name: The name of the log configuration.
        :param pulumi.Input[_builtins.int] priority: Priority of the log configuration. A lower number means a higher priority.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Asserts Log Configuration through Grafana API.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        production = grafana.assert_.LogConfig("production",
            name="production",
            priority=1000,
            default_config=False,
            data_source_uid="grafanacloud-logs",
            error_label="error",
            matches=[
                {
                    "property": "asserts_entity_type",
                    "op": "EQUALS",
                    "values": ["Service"],
                },
                {
                    "property": "environment",
                    "op": "EQUALS",
                    "values": [
                        "production",
                        "staging",
                    ],
                },
                {
                    "property": "site",
                    "op": "EQUALS",
                    "values": [
                        "us-east-1",
                        "us-west-2",
                    ],
                },
            ],
            entity_property_to_log_label_mapping={
                "otel_namespace": "service_namespace",
                "otel_service": "service_name",
                "environment": "env",
                "site": "region",
            },
            filter_by_span_id=True,
            filter_by_trace_id=True)
        development = grafana.assert_.LogConfig("development",
            name="development",
            priority=2000,
            default_config=True,
            data_source_uid="elasticsearch-dev",
            error_label="error",
            matches=[
                {
                    "property": "asserts_entity_type",
                    "op": "EQUALS",
                    "values": ["Service"],
                },
                {
                    "property": "environment",
                    "op": "EQUALS",
                    "values": [
                        "development",
                        "testing",
                    ],
                },
                {
                    "property": "site",
                    "op": "EQUALS",
                    "values": ["us-east-1"],
                },
                {
                    "property": "service",
                    "op": "EQUALS",
                    "values": ["api"],
                },
            ],
            entity_property_to_log_label_mapping={
                "otel_namespace": "service_namespace",
                "otel_service": "service_name",
                "environment": "env",
                "site": "region",
                "service": "app",
            },
            filter_by_span_id=True,
            filter_by_trace_id=True)
        minimal = grafana.assert_.LogConfig("minimal",
            name="minimal",
            priority=3000,
            default_config=False,
            data_source_uid="loki-minimal",
            matches=[{
                "property": "asserts_entity_type",
                "op": "IS_NOT_NULL",
                "values": [],
            }])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:assert/logConfig:LogConfig name "{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param LogConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 default_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_property_to_log_label_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 error_label: Optional[pulumi.Input[_builtins.str]] = None,
                 filter_by_span_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter_by_trace_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 matches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogConfigMatchArgs', 'LogConfigMatchArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogConfigArgs.__new__(LogConfigArgs)

            if data_source_uid is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_uid'")
            __props__.__dict__["data_source_uid"] = data_source_uid
            if default_config is None and not opts.urn:
                raise TypeError("Missing required property 'default_config'")
            __props__.__dict__["default_config"] = default_config
            __props__.__dict__["entity_property_to_log_label_mapping"] = entity_property_to_log_label_mapping
            __props__.__dict__["error_label"] = error_label
            __props__.__dict__["filter_by_span_id"] = filter_by_span_id
            __props__.__dict__["filter_by_trace_id"] = filter_by_trace_id
            __props__.__dict__["matches"] = matches
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
        super(LogConfig, __self__).__init__(
            'grafana:assert/logConfig:LogConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_source_uid: Optional[pulumi.Input[_builtins.str]] = None,
            default_config: Optional[pulumi.Input[_builtins.bool]] = None,
            entity_property_to_log_label_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            error_label: Optional[pulumi.Input[_builtins.str]] = None,
            filter_by_span_id: Optional[pulumi.Input[_builtins.bool]] = None,
            filter_by_trace_id: Optional[pulumi.Input[_builtins.bool]] = None,
            matches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogConfigMatchArgs', 'LogConfigMatchArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None) -> 'LogConfig':
        """
        Get an existing LogConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_uid: DataSource to be queried (e.g., a Loki instance).
        :param pulumi.Input[_builtins.bool] default_config: Is it the default config, therefore undeletable?
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity_property_to_log_label_mapping: Mapping of entity properties to log labels.
        :param pulumi.Input[_builtins.str] error_label: Error label to filter logs.
        :param pulumi.Input[_builtins.bool] filter_by_span_id: Filter logs by span ID.
        :param pulumi.Input[_builtins.bool] filter_by_trace_id: Filter logs by trace ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogConfigMatchArgs', 'LogConfigMatchArgsDict']]]] matches: List of match rules for entity properties.
        :param pulumi.Input[_builtins.str] name: The name of the log configuration.
        :param pulumi.Input[_builtins.int] priority: Priority of the log configuration. A lower number means a higher priority.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogConfigState.__new__(_LogConfigState)

        __props__.__dict__["data_source_uid"] = data_source_uid
        __props__.__dict__["default_config"] = default_config
        __props__.__dict__["entity_property_to_log_label_mapping"] = entity_property_to_log_label_mapping
        __props__.__dict__["error_label"] = error_label
        __props__.__dict__["filter_by_span_id"] = filter_by_span_id
        __props__.__dict__["filter_by_trace_id"] = filter_by_trace_id
        __props__.__dict__["matches"] = matches
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        return LogConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataSourceUid")
    def data_source_uid(self) -> pulumi.Output[_builtins.str]:
        """
        DataSource to be queried (e.g., a Loki instance).
        """
        return pulumi.get(self, "data_source_uid")

    @_builtins.property
    @pulumi.getter(name="defaultConfig")
    def default_config(self) -> pulumi.Output[_builtins.bool]:
        """
        Is it the default config, therefore undeletable?
        """
        return pulumi.get(self, "default_config")

    @_builtins.property
    @pulumi.getter(name="entityPropertyToLogLabelMapping")
    def entity_property_to_log_label_mapping(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Mapping of entity properties to log labels.
        """
        return pulumi.get(self, "entity_property_to_log_label_mapping")

    @_builtins.property
    @pulumi.getter(name="errorLabel")
    def error_label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Error label to filter logs.
        """
        return pulumi.get(self, "error_label")

    @_builtins.property
    @pulumi.getter(name="filterBySpanId")
    def filter_by_span_id(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Filter logs by span ID.
        """
        return pulumi.get(self, "filter_by_span_id")

    @_builtins.property
    @pulumi.getter(name="filterByTraceId")
    def filter_by_trace_id(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Filter logs by trace ID.
        """
        return pulumi.get(self, "filter_by_trace_id")

    @_builtins.property
    @pulumi.getter
    def matches(self) -> pulumi.Output[Optional[Sequence['outputs.LogConfigMatch']]]:
        """
        List of match rules for entity properties.
        """
        return pulumi.get(self, "matches")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the log configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Priority of the log configuration. A lower number means a higher priority.
        """
        return pulumi.get(self, "priority")

