# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CustomModelRulesRules',
    'CustomModelRulesRulesEntity',
    'CustomModelRulesRulesEntityDefinedBy',
    'LogConfigMatch',
]

@pulumi.output_type
class CustomModelRulesRules(dict):
    def __init__(__self__, *,
                 entities: Sequence['outputs.CustomModelRulesRulesEntity']):
        """
        :param Sequence['CustomModelRulesRulesEntityArgs'] entities: List of entities to define in the custom model rules.
        """
        pulumi.set(__self__, "entities", entities)

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.CustomModelRulesRulesEntity']:
        """
        List of entities to define in the custom model rules.
        """
        return pulumi.get(self, "entities")


@pulumi.output_type
class CustomModelRulesRulesEntity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedBies":
            suggest = "defined_bies"
        elif key == "enrichedBies":
            suggest = "enriched_bies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelRulesRulesEntity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelRulesRulesEntity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelRulesRulesEntity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_bies: Sequence['outputs.CustomModelRulesRulesEntityDefinedBy'],
                 name: _builtins.str,
                 type: _builtins.str,
                 disabled: Optional[_builtins.bool] = None,
                 enriched_bies: Optional[Sequence[_builtins.str]] = None,
                 lookup: Optional[Mapping[str, _builtins.str]] = None,
                 scope: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence['CustomModelRulesRulesEntityDefinedByArgs'] defined_bies: List of queries that define this entity.
        :param _builtins.str name: The name of the entity.
        :param _builtins.str type: The type of the entity (e.g., Service, Pod, Namespace).
        :param _builtins.bool disabled: Whether this entity is disabled.
        :param Sequence[_builtins.str] enriched_bies: List of enrichment sources for the entity.
        :param Mapping[str, _builtins.str] lookup: Lookup mappings for the entity.
        :param Mapping[str, _builtins.str] scope: Scope labels for the entity.
        """
        pulumi.set(__self__, "defined_bies", defined_bies)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enriched_bies is not None:
            pulumi.set(__self__, "enriched_bies", enriched_bies)
        if lookup is not None:
            pulumi.set(__self__, "lookup", lookup)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="definedBies")
    def defined_bies(self) -> Sequence['outputs.CustomModelRulesRulesEntityDefinedBy']:
        """
        List of queries that define this entity.
        """
        return pulumi.get(self, "defined_bies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the entity.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the entity (e.g., Service, Pod, Namespace).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Whether this entity is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="enrichedBies")
    def enriched_bies(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of enrichment sources for the entity.
        """
        return pulumi.get(self, "enriched_bies")

    @_builtins.property
    @pulumi.getter
    def lookup(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Lookup mappings for the entity.
        """
        return pulumi.get(self, "lookup")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Scope labels for the entity.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class CustomModelRulesRulesEntityDefinedBy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelValues":
            suggest = "label_values"
        elif key == "metricValue":
            suggest = "metric_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomModelRulesRulesEntityDefinedBy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomModelRulesRulesEntityDefinedBy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomModelRulesRulesEntityDefinedBy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: _builtins.str,
                 disabled: Optional[_builtins.bool] = None,
                 label_values: Optional[Mapping[str, _builtins.str]] = None,
                 literals: Optional[Mapping[str, _builtins.str]] = None,
                 metric_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str query: The Prometheus query that defines this entity.
        :param _builtins.bool disabled: Whether this rule is disabled. When true, only the 'query' field is used to match an existing rule to disable; other fields are ignored.
        :param Mapping[str, _builtins.str] label_values: Label value mappings for the query.
        :param Mapping[str, _builtins.str] literals: Literal value mappings for the query.
        :param _builtins.str metric_value: Metric value for the query.
        """
        pulumi.set(__self__, "query", query)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if label_values is not None:
            pulumi.set(__self__, "label_values", label_values)
        if literals is not None:
            pulumi.set(__self__, "literals", literals)
        if metric_value is not None:
            pulumi.set(__self__, "metric_value", metric_value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The Prometheus query that defines this entity.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Whether this rule is disabled. When true, only the 'query' field is used to match an existing rule to disable; other fields are ignored.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="labelValues")
    def label_values(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Label value mappings for the query.
        """
        return pulumi.get(self, "label_values")

    @_builtins.property
    @pulumi.getter
    def literals(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Literal value mappings for the query.
        """
        return pulumi.get(self, "literals")

    @_builtins.property
    @pulumi.getter(name="metricValue")
    def metric_value(self) -> Optional[_builtins.str]:
        """
        Metric value for the query.
        """
        return pulumi.get(self, "metric_value")


@pulumi.output_type
class LogConfigMatch(dict):
    def __init__(__self__, *,
                 op: _builtins.str,
                 property: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str op: Operation to use for matching. One of: EQUALS, NOT*EQUALS, CONTAINS, DOES*NOT*CONTAIN, IS*NULL, IS*NOT*NULL.
        :param _builtins.str property: Entity property to match.
        :param Sequence[_builtins.str] values: Values to match against.
        """
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def op(self) -> _builtins.str:
        """
        Operation to use for matching. One of: EQUALS, NOT*EQUALS, CONTAINS, DOES*NOT*CONTAIN, IS*NULL, IS*NOT*NULL.
        """
        return pulumi.get(self, "op")

    @_builtins.property
    @pulumi.getter
    def property(self) -> _builtins.str:
        """
        Entity property to match.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Values to match against.
        """
        return pulumi.get(self, "values")


