# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SuppressedAssertionsConfigArgs', 'SuppressedAssertionsConfig']

@pulumi.input_type
class SuppressedAssertionsConfigArgs:
    def __init__(__self__, *,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SuppressedAssertionsConfig resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this disabled alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the disabled alert configuration.
        """
        if match_labels is not None:
            pulumi.set(__self__, "match_labels", match_labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to match for this disabled alert configuration.
        """
        return pulumi.get(self, "match_labels")

    @match_labels.setter
    def match_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the disabled alert configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SuppressedAssertionsConfigState:
    def __init__(__self__, *,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SuppressedAssertionsConfig resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this disabled alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the disabled alert configuration.
        """
        if match_labels is not None:
            pulumi.set(__self__, "match_labels", match_labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels to match for this disabled alert configuration.
        """
        return pulumi.get(self, "match_labels")

    @match_labels.setter
    def match_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "match_labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the disabled alert configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("grafana:assert/suppressedAssertionsConfig:SuppressedAssertionsConfig")
class SuppressedAssertionsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Asserts Disabled Alert Configurations through Grafana API.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        # Basic suppressed alert configuration for maintenance
        maintenance_window = grafana.assert_.SuppressedAssertionsConfig("maintenance_window",
            name="MaintenanceWindow",
            match_labels={
                "service": "api-service",
                "maintenance": "true",
            })
        # Suppress specific alertname during deployment
        deployment_suppression = grafana.assert_.SuppressedAssertionsConfig("deployment_suppression",
            name="DeploymentSuppression",
            match_labels={
                "alertname": "HighLatency",
                "job": "web-service",
                "env": "staging",
            })
        # Suppress alerts for specific test environment
        test_environment_suppression = grafana.assert_.SuppressedAssertionsConfig("test_environment_suppression",
            name="TestEnvironmentSuppression",
            match_labels={
                "alertgroup": "test.alerts",
                "environment": "test",
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:assert/suppressedAssertionsConfig:SuppressedAssertionsConfig name "{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this disabled alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the disabled alert configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SuppressedAssertionsConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Asserts Disabled Alert Configurations through Grafana API.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        # Basic suppressed alert configuration for maintenance
        maintenance_window = grafana.assert_.SuppressedAssertionsConfig("maintenance_window",
            name="MaintenanceWindow",
            match_labels={
                "service": "api-service",
                "maintenance": "true",
            })
        # Suppress specific alertname during deployment
        deployment_suppression = grafana.assert_.SuppressedAssertionsConfig("deployment_suppression",
            name="DeploymentSuppression",
            match_labels={
                "alertname": "HighLatency",
                "job": "web-service",
                "env": "staging",
            })
        # Suppress alerts for specific test environment
        test_environment_suppression = grafana.assert_.SuppressedAssertionsConfig("test_environment_suppression",
            name="TestEnvironmentSuppression",
            match_labels={
                "alertgroup": "test.alerts",
                "environment": "test",
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:assert/suppressedAssertionsConfig:SuppressedAssertionsConfig name "{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param SuppressedAssertionsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SuppressedAssertionsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SuppressedAssertionsConfigArgs.__new__(SuppressedAssertionsConfigArgs)

            __props__.__dict__["match_labels"] = match_labels
            __props__.__dict__["name"] = name
        super(SuppressedAssertionsConfig, __self__).__init__(
            'grafana:assert/suppressedAssertionsConfig:SuppressedAssertionsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            match_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SuppressedAssertionsConfig':
        """
        Get an existing SuppressedAssertionsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] match_labels: Labels to match for this disabled alert configuration.
        :param pulumi.Input[_builtins.str] name: The name of the disabled alert configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SuppressedAssertionsConfigState.__new__(_SuppressedAssertionsConfigState)

        __props__.__dict__["match_labels"] = match_labels
        __props__.__dict__["name"] = name
        return SuppressedAssertionsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="matchLabels")
    def match_labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels to match for this disabled alert configuration.
        """
        return pulumi.get(self, "match_labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the disabled alert configuration.
        """
        return pulumi.get(self, "name")

