# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateDataSourceConnectNetworkArgs', 'PrivateDataSourceConnectNetwork']

@pulumi.input_type
class PrivateDataSourceConnectNetworkArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 stack_identifier: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateDataSourceConnectNetwork resource.
        :param pulumi.Input[_builtins.str] region: The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        :param pulumi.Input[_builtins.str] stack_identifier: The identifier of the stack.
        :param pulumi.Input[_builtins.str] display_name: Display name of the PDC network. Defaults to the name.
        :param pulumi.Input[_builtins.str] name: Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "stack_identifier", stack_identifier)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="stackIdentifier")
    def stack_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the stack.
        """
        return pulumi.get(self, "stack_identifier")

    @stack_identifier.setter
    def stack_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_identifier", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the PDC network. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PrivateDataSourceConnectNetworkState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pdc_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateDataSourceConnectNetwork resources.
        :param pulumi.Input[_builtins.str] created_at: Creation date of the private data source connect network.
        :param pulumi.Input[_builtins.str] display_name: Display name of the PDC network. Defaults to the name.
        :param pulumi.Input[_builtins.str] name: Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        :param pulumi.Input[_builtins.str] pdc_network_id: ID of the private data source connect network.
        :param pulumi.Input[_builtins.str] region: The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        :param pulumi.Input[_builtins.str] stack_identifier: The identifier of the stack.
        :param pulumi.Input[_builtins.str] updated_at: Last update date of the private data source connect network.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pdc_network_id is not None:
            pulumi.set(__self__, "pdc_network_id", pdc_network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stack_identifier is not None:
            pulumi.set(__self__, "stack_identifier", stack_identifier)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation date of the private data source connect network.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the PDC network. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pdcNetworkId")
    def pdc_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the private data source connect network.
        """
        return pulumi.get(self, "pdc_network_id")

    @pdc_network_id.setter
    def pdc_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pdc_network_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="stackIdentifier")
    def stack_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the stack.
        """
        return pulumi.get(self, "stack_identifier")

    @stack_identifier.setter
    def stack_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_identifier", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last update date of the private data source connect network.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("grafana:cloud/privateDataSourceConnectNetwork:PrivateDataSourceConnectNetwork")
class PrivateDataSourceConnectNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/connect-externally-hosted/private-data-source-connect/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#create-an-access-policy)

        Required access policy scopes:

        * accesspolicies:read
        * accesspolicies:write
        * accesspolicies:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        current = grafana.cloud.get_stack(slug="<your slug>")
        test = grafana.cloud.PrivateDataSourceConnectNetwork("test",
            region="prod-us-east-0",
            name="my-pdc",
            display_name="My PDC",
            stack_identifier=current.id)
        test_private_data_source_connect_network_token = grafana.cloud.PrivateDataSourceConnectNetworkToken("test",
            pdc_network_id=test.pdc_network_id,
            region=test.region,
            name="my-pdc-token",
            display_name="My PDC Token")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/privateDataSourceConnectNetwork:PrivateDataSourceConnectNetwork name "{{ region }}:{{ policyId }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Display name of the PDC network. Defaults to the name.
        :param pulumi.Input[_builtins.str] name: Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        :param pulumi.Input[_builtins.str] region: The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        :param pulumi.Input[_builtins.str] stack_identifier: The identifier of the stack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateDataSourceConnectNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana-cloud/connect-externally-hosted/private-data-source-connect/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#create-an-access-policy)

        Required access policy scopes:

        * accesspolicies:read
        * accesspolicies:write
        * accesspolicies:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        current = grafana.cloud.get_stack(slug="<your slug>")
        test = grafana.cloud.PrivateDataSourceConnectNetwork("test",
            region="prod-us-east-0",
            name="my-pdc",
            display_name="My PDC",
            stack_identifier=current.id)
        test_private_data_source_connect_network_token = grafana.cloud.PrivateDataSourceConnectNetworkToken("test",
            pdc_network_id=test.pdc_network_id,
            region=test.region,
            name="my-pdc-token",
            display_name="My PDC Token")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/privateDataSourceConnectNetwork:PrivateDataSourceConnectNetwork name "{{ region }}:{{ policyId }}"
        ```

        :param str resource_name: The name of the resource.
        :param PrivateDataSourceConnectNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateDataSourceConnectNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateDataSourceConnectNetworkArgs.__new__(PrivateDataSourceConnectNetworkArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if stack_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'stack_identifier'")
            __props__.__dict__["stack_identifier"] = stack_identifier
            __props__.__dict__["created_at"] = None
            __props__.__dict__["pdc_network_id"] = None
            __props__.__dict__["updated_at"] = None
        super(PrivateDataSourceConnectNetwork, __self__).__init__(
            'grafana:cloud/privateDataSourceConnectNetwork:PrivateDataSourceConnectNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pdc_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            stack_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateDataSourceConnectNetwork':
        """
        Get an existing PrivateDataSourceConnectNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Creation date of the private data source connect network.
        :param pulumi.Input[_builtins.str] display_name: Display name of the PDC network. Defaults to the name.
        :param pulumi.Input[_builtins.str] name: Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        :param pulumi.Input[_builtins.str] pdc_network_id: ID of the private data source connect network.
        :param pulumi.Input[_builtins.str] region: The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        :param pulumi.Input[_builtins.str] stack_identifier: The identifier of the stack.
        :param pulumi.Input[_builtins.str] updated_at: Last update date of the private data source connect network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateDataSourceConnectNetworkState.__new__(_PrivateDataSourceConnectNetworkState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["pdc_network_id"] = pdc_network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["stack_identifier"] = stack_identifier
        __props__.__dict__["updated_at"] = updated_at
        return PrivateDataSourceConnectNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation date of the private data source connect network.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Display name of the PDC network. Defaults to the name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the PDC network.**Note:** The name must be lowercase and can contain hyphens or underscores. See full requirements here: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#request-body
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pdcNetworkId")
    def pdc_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the private data source connect network.
        """
        return pulumi.get(self, "pdc_network_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where your stack is deployed. Use the instances list API to get the region for your instance - use the regionSlug property: https://grafana.com/docs/grafana-cloud/developer-resources/api-reference/cloud-api/#list-stacks
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="stackIdentifier")
    def stack_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the stack.
        """
        return pulumi.get(self, "stack_identifier")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Last update date of the private data source connect network.
        """
        return pulumi.get(self, "updated_at")

