# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureCredentialArgs', 'AzureCredential']

@pulumi.input_type
class AzureCredentialArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 client_secret: pulumi.Input[_builtins.str],
                 stack_id: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 auto_discovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_discovery_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]]] = None,
                 resource_tags_to_add_to_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AzureCredential resource.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Credential.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Credential.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Credential.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]] auto_discovery_configurations: The list of auto discovery configurations.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Credential.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]] resource_discovery_tag_filters: The list of tag filters to apply to resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_tags_to_add_to_metrics: The list of resource tags to add to metrics.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if auto_discovery_configurations is not None:
            pulumi.set(__self__, "auto_discovery_configurations", auto_discovery_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if resource_tags_to_add_to_metrics is not None:
            pulumi.set(__self__, "resource_tags_to_add_to_metrics", resource_tags_to_add_to_metrics)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client ID of the Azure Credential.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[_builtins.str]:
        """
        The client secret of the Azure Credential.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenant ID of the Azure Credential.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="autoDiscoveryConfigurations")
    def auto_discovery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]]]:
        """
        The list of auto discovery configurations.
        """
        return pulumi.get(self, "auto_discovery_configurations")

    @auto_discovery_configurations.setter
    def auto_discovery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]]]):
        pulumi.set(self, "auto_discovery_configurations", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Credential.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]]]:
        """
        The list of tag filters to apply to resources.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @resource_discovery_tag_filters.setter
    def resource_discovery_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]]]):
        pulumi.set(self, "resource_discovery_tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="resourceTagsToAddToMetrics")
    def resource_tags_to_add_to_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of resource tags to add to metrics.
        """
        return pulumi.get(self, "resource_tags_to_add_to_metrics")

    @resource_tags_to_add_to_metrics.setter
    def resource_tags_to_add_to_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags_to_add_to_metrics", value)


@pulumi.input_type
class _AzureCredentialState:
    def __init__(__self__, *,
                 auto_discovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_discovery_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags_to_add_to_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzureCredential resources.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]] auto_discovery_configurations: The list of auto discovery configurations.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Credential.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Credential.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Credential.
        :param pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]] resource_discovery_tag_filters: The list of tag filters to apply to resources.
        :param pulumi.Input[_builtins.str] resource_id: The ID given by the Grafana Cloud Provider API to this Azure Credential resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_tags_to_add_to_metrics: The list of resource tags to add to metrics.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Credential.
        """
        if auto_discovery_configurations is not None:
            pulumi.set(__self__, "auto_discovery_configurations", auto_discovery_configurations)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_tags_to_add_to_metrics is not None:
            pulumi.set(__self__, "resource_tags_to_add_to_metrics", resource_tags_to_add_to_metrics)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="autoDiscoveryConfigurations")
    def auto_discovery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]]]:
        """
        The list of auto discovery configurations.
        """
        return pulumi.get(self, "auto_discovery_configurations")

    @auto_discovery_configurations.setter
    def auto_discovery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialAutoDiscoveryConfigurationArgs']]]]):
        pulumi.set(self, "auto_discovery_configurations", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the Azure Credential.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of the Azure Credential.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Credential.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]]]:
        """
        The list of tag filters to apply to resources.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @resource_discovery_tag_filters.setter
    def resource_discovery_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureCredentialResourceDiscoveryTagFilterArgs']]]]):
        pulumi.set(self, "resource_discovery_tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID given by the Grafana Cloud Provider API to this Azure Credential resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceTagsToAddToMetrics")
    def resource_tags_to_add_to_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of resource tags to add to metrics.
        """
        return pulumi.get(self, "resource_tags_to_add_to_metrics")

    @resource_tags_to_add_to_metrics.setter
    def resource_tags_to_add_to_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags_to_add_to_metrics", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant ID of the Azure Credential.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("grafana:cloudProvider/azureCredential:AzureCredential")
class AzureCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_discovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialAutoDiscoveryConfigurationArgs', 'AzureCredentialAutoDiscoveryConfigurationArgsDict']]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_discovery_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialResourceDiscoveryTagFilterArgs', 'AzureCredentialResourceDiscoveryTagFilterArgsDict']]]]] = None,
                 resource_tags_to_add_to_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import grafana:cloudProvider/azureCredential:AzureCredential name "{{ stack_id }}:{{ resource_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialAutoDiscoveryConfigurationArgs', 'AzureCredentialAutoDiscoveryConfigurationArgsDict']]]] auto_discovery_configurations: The list of auto discovery configurations.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Credential.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Credential.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Credential.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialResourceDiscoveryTagFilterArgs', 'AzureCredentialResourceDiscoveryTagFilterArgsDict']]]] resource_discovery_tag_filters: The list of tag filters to apply to resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_tags_to_add_to_metrics: The list of resource tags to add to metrics.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Credential.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import grafana:cloudProvider/azureCredential:AzureCredential name "{{ stack_id }}:{{ resource_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param AzureCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_discovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialAutoDiscoveryConfigurationArgs', 'AzureCredentialAutoDiscoveryConfigurationArgsDict']]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_discovery_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialResourceDiscoveryTagFilterArgs', 'AzureCredentialResourceDiscoveryTagFilterArgsDict']]]]] = None,
                 resource_tags_to_add_to_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureCredentialArgs.__new__(AzureCredentialArgs)

            __props__.__dict__["auto_discovery_configurations"] = auto_discovery_configurations
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_discovery_tag_filters"] = resource_discovery_tag_filters
            __props__.__dict__["resource_tags_to_add_to_metrics"] = resource_tags_to_add_to_metrics
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["resource_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AzureCredential, __self__).__init__(
            'grafana:cloudProvider/azureCredential:AzureCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_discovery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialAutoDiscoveryConfigurationArgs', 'AzureCredentialAutoDiscoveryConfigurationArgsDict']]]]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_discovery_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialResourceDiscoveryTagFilterArgs', 'AzureCredentialResourceDiscoveryTagFilterArgsDict']]]]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_tags_to_add_to_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            stack_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AzureCredential':
        """
        Get an existing AzureCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialAutoDiscoveryConfigurationArgs', 'AzureCredentialAutoDiscoveryConfigurationArgsDict']]]] auto_discovery_configurations: The list of auto discovery configurations.
        :param pulumi.Input[_builtins.str] client_id: The client ID of the Azure Credential.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of the Azure Credential.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Credential.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AzureCredentialResourceDiscoveryTagFilterArgs', 'AzureCredentialResourceDiscoveryTagFilterArgsDict']]]] resource_discovery_tag_filters: The list of tag filters to apply to resources.
        :param pulumi.Input[_builtins.str] resource_id: The ID given by the Grafana Cloud Provider API to this Azure Credential resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_tags_to_add_to_metrics: The list of resource tags to add to metrics.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant ID of the Azure Credential.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureCredentialState.__new__(_AzureCredentialState)

        __props__.__dict__["auto_discovery_configurations"] = auto_discovery_configurations
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_discovery_tag_filters"] = resource_discovery_tag_filters
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_tags_to_add_to_metrics"] = resource_tags_to_add_to_metrics
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["tenant_id"] = tenant_id
        return AzureCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoDiscoveryConfigurations")
    def auto_discovery_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.AzureCredentialAutoDiscoveryConfiguration']]]:
        """
        The list of auto discovery configurations.
        """
        return pulumi.get(self, "auto_discovery_configurations")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client ID of the Azure Credential.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        The client secret of the Azure Credential.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Credential.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> pulumi.Output[Optional[Sequence['outputs.AzureCredentialResourceDiscoveryTagFilter']]]:
        """
        The list of tag filters to apply to resources.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID given by the Grafana Cloud Provider API to this Azure Credential resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceTagsToAddToMetrics")
    def resource_tags_to_add_to_metrics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of resource tags to add to metrics.
        """
        return pulumi.get(self, "resource_tags_to_add_to_metrics")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant ID of the Azure Credential.
        """
        return pulumi.get(self, "tenant_id")

