# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AwsCloudwatchScrapeJobCustomNamespace',
    'AwsCloudwatchScrapeJobCustomNamespaceMetric',
    'AwsCloudwatchScrapeJobService',
    'AwsCloudwatchScrapeJobServiceMetric',
    'AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter',
    'AwsResourceMetadataScrapeJobService',
    'AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter',
    'AzureCredentialAutoDiscoveryConfiguration',
    'AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration',
    'AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration',
    'AzureCredentialResourceDiscoveryTagFilter',
    'GetAwsCloudwatchScrapeJobCustomNamespaceResult',
    'GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult',
    'GetAwsCloudwatchScrapeJobServiceResult',
    'GetAwsCloudwatchScrapeJobServiceMetricResult',
    'GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobServiceResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult',
    'GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult',
    'GetAzureCredentialAutoDiscoveryConfigurationResult',
    'GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult',
    'GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult',
    'GetAzureCredentialResourceDiscoveryTagFilterResult',
]

@pulumi.output_type
class AwsCloudwatchScrapeJobCustomNamespace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCloudwatchScrapeJobCustomNamespace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCloudwatchScrapeJobCustomNamespace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCloudwatchScrapeJobCustomNamespace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 metrics: Optional[Sequence['outputs.AwsCloudwatchScrapeJobCustomNamespaceMetric']] = None,
                 scrape_interval_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: The name of the custom namespace to scrape.
        :param Sequence['AwsCloudwatchScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace. Defaults to `300`.
        """
        pulumi.set(__self__, "name", name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.AwsCloudwatchScrapeJobCustomNamespaceMetric']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[_builtins.int]:
        """
        The interval in seconds to scrape the custom namespace. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")


@pulumi.output_type
class AwsCloudwatchScrapeJobCustomNamespaceMetric(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistics: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the metric to scrape.
        :param Sequence[_builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Sequence[_builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class AwsCloudwatchScrapeJobService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceDiscoveryTagFilters":
            suggest = "resource_discovery_tag_filters"
        elif key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"
        elif key == "tagsToAddToMetrics":
            suggest = "tags_to_add_to_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsCloudwatchScrapeJobService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsCloudwatchScrapeJobService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsCloudwatchScrapeJobService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 metrics: Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceMetric']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter']] = None,
                 scrape_interval_seconds: Optional[_builtins.int] = None,
                 tags_to_add_to_metrics: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        :param Sequence['AwsCloudwatchScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Please note that AWS metric names must be supplied, and not their PromQL counterparts. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        :param Sequence[_builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        pulumi.set(__self__, "name", name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if tags_to_add_to_metrics is not None:
            pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceMetric']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Please note that AWS metric names must be supplied, and not their PromQL counterparts. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[_builtins.int]:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")


@pulumi.output_type
class AwsCloudwatchScrapeJobServiceMetric(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistics: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the metric to scrape.
        :param Sequence[_builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Sequence[_builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class AwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag filter.
        :param _builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AwsResourceMetadataScrapeJobService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceDiscoveryTagFilters":
            suggest = "resource_discovery_tag_filters"
        elif key == "scrapeIntervalSeconds":
            suggest = "scrape_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsResourceMetadataScrapeJobService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsResourceMetadataScrapeJobService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsResourceMetadataScrapeJobService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter']] = None,
                 scrape_interval_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        :param Sequence['AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        pulumi.set(__self__, "name", name)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[_builtins.int]:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals. Defaults to `300`.
        """
        return pulumi.get(self, "scrape_interval_seconds")


@pulumi.output_type
class AwsResourceMetadataScrapeJobServiceResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag filter.
        :param _builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AzureCredentialAutoDiscoveryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTypeConfigurations":
            suggest = "resource_type_configurations"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialAutoDiscoveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialAutoDiscoveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialAutoDiscoveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type_configurations: Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration'],
                 subscription_id: _builtins.str):
        """
        :param Sequence['AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationArgs'] resource_type_configurations: The list of resource type configurations.
        :param _builtins.str subscription_id: The subscription ID of the Azure account.
        """
        pulumi.set(__self__, "resource_type_configurations", resource_type_configurations)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="resourceTypeConfigurations")
    def resource_type_configurations(self) -> Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration']:
        """
        The list of resource type configurations.
        """
        return pulumi.get(self, "resource_type_configurations")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID of the Azure account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricConfigurations":
            suggest = "metric_configurations"
        elif key == "resourceTypeName":
            suggest = "resource_type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialAutoDiscoveryConfigurationResourceTypeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_configurations: Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration'],
                 resource_type_name: _builtins.str):
        pulumi.set(__self__, "metric_configurations", metric_configurations)
        pulumi.set(__self__, "resource_type_name", resource_type_name)

    @_builtins.property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration']:
        return pulumi.get(self, "metric_configurations")

    @_builtins.property
    @pulumi.getter(name="resourceTypeName")
    def resource_type_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_type_name")


@pulumi.output_type
class AzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfiguration(dict):
    def __init__(__self__, *,
                 aggregations: Sequence[_builtins.str],
                 dimensions: Sequence[_builtins.str],
                 name: _builtins.str):
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "aggregations")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureCredentialResourceDiscoveryTagFilter(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag filter.
        :param _builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobCustomNamespaceResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 scrape_interval_seconds: _builtins.int,
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult']] = None):
        """
        :param _builtins.str name: The name of the custom namespace to scrape.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace.
        :param Sequence['GetAwsCloudwatchScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> _builtins.int:
        """
        The interval in seconds to scrape the custom namespace.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobCustomNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistics: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the metric to scrape.
        :param Sequence[_builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Sequence[_builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobServiceResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 scrape_interval_seconds: _builtins.int,
                 tags_to_add_to_metrics: Sequence[_builtins.str],
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceMetricResult']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult']] = None):
        """
        :param _builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        :param Sequence[_builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        :param Sequence['GetAwsCloudwatchScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> _builtins.int:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Sequence[_builtins.str]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobServiceMetricResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistics: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the metric to scrape.
        :param Sequence[_builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Sequence[_builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobServiceResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag filter.
        :param _builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobResult(dict):
    def __init__(__self__, *,
                 aws_account_resource_id: _builtins.str,
                 disabled_reason: _builtins.str,
                 enabled: _builtins.bool,
                 export_tags: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 regions: Sequence[_builtins.str],
                 regions_subset_override_used: _builtins.bool,
                 role_arn: _builtins.str,
                 stack_id: _builtins.str,
                 static_labels: Mapping[str, _builtins.str],
                 custom_namespaces: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult']] = None,
                 services: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResult']] = None):
        """
        :param _builtins.str aws_account_resource_id: The ID assigned by the Grafana Cloud Provider API to an AWS Account resource that should be associated with this AWS CloudWatch Scrape Job. This can be provided by the `resource_id` attribute of the `cloudProvider.AwsAccount` resource.
        :param _builtins.str disabled_reason: When the AWS CloudWatch Scrape Job is disabled, this will show the reason that it is in that state.
        :param _builtins.bool enabled: Whether the AWS CloudWatch Scrape Job is enabled or not.
        :param _builtins.bool export_tags: When enabled, AWS resource tags are exported as Prometheus labels to metrics formatted as `aws_<service_name>_info`.
        :param Sequence[_builtins.str] regions: The set of AWS region names that this AWS CloudWatch Scrape Job is configured to scrape.
        :param _builtins.bool regions_subset_override_used: When true, the `regions` attribute will be the set of regions configured in the override. When false, the `regions` attribute will be the set of regions belonging to the AWS Account resource that is associated with this AWS CloudWatch Scrape Job.
        :param _builtins.str role_arn: The AWS ARN of the IAM role associated with the AWS Account resource that is being used by this AWS CloudWatch Scrape Job.
        :param Mapping[str, _builtins.str] static_labels: A set of static labels to add to all metrics exported by this scrape job.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceArgs'] custom_namespaces: Zero or more configuration blocks to configure custom namespaces for the AWS CloudWatch Scrape Job to scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobServiceArgs'] services: One or more configuration blocks to dictate what this AWS CloudWatch Scrape Job should scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "aws_account_resource_id", aws_account_resource_id)
        pulumi.set(__self__, "disabled_reason", disabled_reason)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "export_tags", export_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "regions_subset_override_used", regions_subset_override_used)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "static_labels", static_labels)
        if custom_namespaces is not None:
            pulumi.set(__self__, "custom_namespaces", custom_namespaces)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @_builtins.property
    @pulumi.getter(name="awsAccountResourceId")
    def aws_account_resource_id(self) -> _builtins.str:
        """
        The ID assigned by the Grafana Cloud Provider API to an AWS Account resource that should be associated with this AWS CloudWatch Scrape Job. This can be provided by the `resource_id` attribute of the `cloudProvider.AwsAccount` resource.
        """
        return pulumi.get(self, "aws_account_resource_id")

    @_builtins.property
    @pulumi.getter(name="disabledReason")
    def disabled_reason(self) -> _builtins.str:
        """
        When the AWS CloudWatch Scrape Job is disabled, this will show the reason that it is in that state.
        """
        return pulumi.get(self, "disabled_reason")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the AWS CloudWatch Scrape Job is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="exportTags")
    def export_tags(self) -> _builtins.bool:
        """
        When enabled, AWS resource tags are exported as Prometheus labels to metrics formatted as `aws_<service_name>_info`.
        """
        return pulumi.get(self, "export_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence[_builtins.str]:
        """
        The set of AWS region names that this AWS CloudWatch Scrape Job is configured to scrape.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="regionsSubsetOverrideUsed")
    def regions_subset_override_used(self) -> _builtins.bool:
        """
        When true, the `regions` attribute will be the set of regions configured in the override. When false, the `regions` attribute will be the set of regions belonging to the AWS Account resource that is associated with this AWS CloudWatch Scrape Job.
        """
        return pulumi.get(self, "regions_subset_override_used")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        The AWS ARN of the IAM role associated with the AWS Account resource that is being used by this AWS CloudWatch Scrape Job.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> _builtins.str:
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="staticLabels")
    def static_labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of static labels to add to all metrics exported by this scrape job.
        """
        return pulumi.get(self, "static_labels")

    @_builtins.property
    @pulumi.getter(name="customNamespaces")
    def custom_namespaces(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult']]:
        """
        Zero or more configuration blocks to configure custom namespaces for the AWS CloudWatch Scrape Job to scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "custom_namespaces")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResult']]:
        """
        One or more configuration blocks to dictate what this AWS CloudWatch Scrape Job should scrape. Each block must have a distinct `name` attribute. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 scrape_interval_seconds: _builtins.int,
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult']] = None):
        """
        :param _builtins.str name: The name of the custom namespace to scrape.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the custom namespace.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the custom namespace to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> _builtins.int:
        """
        The interval in seconds to scrape the custom namespace.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobCustomNamespaceMetricResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistics: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the metric to scrape.
        :param Sequence[_builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Sequence[_builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobServiceResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 scrape_interval_seconds: _builtins.int,
                 tags_to_add_to_metrics: Sequence[_builtins.str],
                 metrics: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult']] = None,
                 resource_discovery_tag_filters: Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult']] = None):
        """
        :param _builtins.str name: The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        :param _builtins.int scrape_interval_seconds: The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        :param Sequence[_builtins.str] tags_to_add_to_metrics: A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricArgs'] metrics: One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        :param Sequence['GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterArgs'] resource_discovery_tag_filters: One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        pulumi.set(__self__, "tags_to_add_to_metrics", tags_to_add_to_metrics)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if resource_discovery_tag_filters is not None:
            pulumi.set(__self__, "resource_discovery_tag_filters", resource_discovery_tag_filters)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service to scrape. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported services, metrics, and their statistics.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> _builtins.int:
        """
        The interval in seconds to scrape the service. See https://grafana.com/docs/grafana-cloud/monitor-infrastructure/monitor-cloud-provider/aws/cloudwatch-metrics/services/ for supported scrape intervals.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="tagsToAddToMetrics")
    def tags_to_add_to_metrics(self) -> Sequence[_builtins.str]:
        """
        A set of tags to add to all metrics exported by this scrape job, for use in PromQL queries.
        """
        return pulumi.get(self, "tags_to_add_to_metrics")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult']]:
        """
        One or more configuration blocks to configure metrics and their statistics to scrape. Each block must represent a distinct metric name. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryTagFilters")
    def resource_discovery_tag_filters(self) -> Optional[Sequence['outputs.GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult']]:
        """
        One or more configuration blocks to configure tag filters applied to discovery of resource entities in the associated AWS account. When accessing this as an attribute reference, it is a list of objects.
        """
        return pulumi.get(self, "resource_discovery_tag_filters")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobServiceMetricResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 statistics: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the metric to scrape.
        :param Sequence[_builtins.str] statistics: A set of statistics to scrape.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the metric to scrape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Sequence[_builtins.str]:
        """
        A set of statistics to scrape.
        """
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetAwsCloudwatchScrapeJobsScrapeJobServiceResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag filter.
        :param _builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAzureCredentialAutoDiscoveryConfigurationResult(dict):
    def __init__(__self__, *,
                 resource_type_configurations: Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult'],
                 subscription_id: _builtins.str):
        """
        :param Sequence['GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationArgs'] resource_type_configurations: The list of resource type configurations.
        :param _builtins.str subscription_id: The subscription ID of the Azure account.
        """
        pulumi.set(__self__, "resource_type_configurations", resource_type_configurations)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="resourceTypeConfigurations")
    def resource_type_configurations(self) -> Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult']:
        """
        The list of resource type configurations.
        """
        return pulumi.get(self, "resource_type_configurations")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        """
        The subscription ID of the Azure account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationResult(dict):
    def __init__(__self__, *,
                 metric_configurations: Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult'],
                 resource_type_name: _builtins.str):
        pulumi.set(__self__, "metric_configurations", metric_configurations)
        pulumi.set(__self__, "resource_type_name", resource_type_name)

    @_builtins.property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult']:
        return pulumi.get(self, "metric_configurations")

    @_builtins.property
    @pulumi.getter(name="resourceTypeName")
    def resource_type_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_type_name")


@pulumi.output_type
class GetAzureCredentialAutoDiscoveryConfigurationResourceTypeConfigurationMetricConfigurationResult(dict):
    def __init__(__self__, *,
                 aggregations: Sequence[_builtins.str],
                 dimensions: Sequence[_builtins.str],
                 name: _builtins.str):
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def aggregations(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "aggregations")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAzureCredentialResourceDiscoveryTagFilterResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag filter.
        :param _builtins.str value: The value of the tag filter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag filter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag filter.
        """
        return pulumi.get(self, "value")


