# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('grafana')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def auth(self) -> Optional[str]:
        """
        API token, basic auth in the `username:password` format or `anonymous` (string literal). May alternatively be set via the `GRAFANA_AUTH` environment variable.
        """
        return __config__.get('auth') or _utilities.get_env('GRAFANA_AUTH')

    @_builtins.property
    def ca_cert(self) -> Optional[str]:
        """
        Certificate CA bundle (file path or literal value) to use to verify the Grafana server's certificate. May alternatively be set via the `GRAFANA_CA_CERT` environment variable.
        """
        return __config__.get('caCert') or _utilities.get_env('GRAFANA_CA_CERT')

    @_builtins.property
    def cloud_access_policy_token(self) -> Optional[str]:
        """
        Access Policy Token for Grafana Cloud. May alternatively be set via the `GRAFANA_CLOUD_ACCESS_POLICY_TOKEN` environment variable.
        """
        return __config__.get('cloudAccessPolicyToken') or _utilities.get_env('GRAFANA_CLOUD_ACCESS_POLICY_TOKEN')

    @_builtins.property
    def cloud_api_url(self) -> Optional[str]:
        """
        Grafana Cloud's API URL. May alternatively be set via the `GRAFANA_CLOUD_API_URL` environment variable.
        """
        return __config__.get('cloudApiUrl') or _utilities.get_env('GRAFANA_CLOUD_API_URL')

    @_builtins.property
    def cloud_provider_access_token(self) -> Optional[str]:
        """
        A Grafana Cloud Provider access token. May alternatively be set via the `GRAFANA_CLOUD_PROVIDER_ACCESS_TOKEN` environment variable.
        """
        return __config__.get('cloudProviderAccessToken')

    @_builtins.property
    def cloud_provider_url(self) -> Optional[str]:
        """
        A Grafana Cloud Provider backend address. May alternatively be set via the `GRAFANA_CLOUD_PROVIDER_URL` environment variable.
        """
        return __config__.get('cloudProviderUrl')

    @_builtins.property
    def connections_api_access_token(self) -> Optional[str]:
        """
        A Grafana Connections API access token. May alternatively be set via the `GRAFANA_CONNECTIONS_API_ACCESS_TOKEN` environment variable.
        """
        return __config__.get('connectionsApiAccessToken')

    @_builtins.property
    def connections_api_url(self) -> Optional[str]:
        """
        A Grafana Connections API address. May alternatively be set via the `GRAFANA_CONNECTIONS_API_URL` environment variable.
        """
        return __config__.get('connectionsApiUrl')

    @_builtins.property
    def fleet_management_auth(self) -> Optional[str]:
        """
        A Grafana Fleet Management basic auth in the `username:password` format. May alternatively be set via the `GRAFANA_FLEET_MANAGEMENT_AUTH` environment variable.
        """
        return __config__.get('fleetManagementAuth')

    @_builtins.property
    def fleet_management_url(self) -> Optional[str]:
        """
        A Grafana Fleet Management API address. May alternatively be set via the `GRAFANA_FLEET_MANAGEMENT_URL` environment variable.
        """
        return __config__.get('fleetManagementUrl')

    @_builtins.property
    def frontend_o11y_api_access_token(self) -> Optional[str]:
        """
        A Grafana Frontend Observability API access token. May alternatively be set via the `GRAFANA_FRONTEND_O11Y_API_ACCESS_TOKEN` environment variable.
        """
        return __config__.get('frontendO11yApiAccessToken')

    @_builtins.property
    def http_headers(self) -> Optional[str]:
        """
        Optional. HTTP headers mapping keys to values used for accessing the Grafana and Grafana Cloud APIs. May alternatively be set via the `GRAFANA_HTTP_HEADERS` environment variable in JSON format.
        """
        return __config__.get('httpHeaders')

    @_builtins.property
    def insecure_skip_verify(self) -> Optional[bool]:
        """
        Skip TLS certificate verification. May alternatively be set via the `GRAFANA_INSECURE_SKIP_VERIFY` environment variable.
        """
        return __config__.get_bool('insecureSkipVerify') or _utilities.get_env_bool('GRAFANA_INSECURE_SKIP_VERIFY')

    @_builtins.property
    def k6_access_token(self) -> Optional[str]:
        """
        The k6 Cloud API token. May alternatively be set via the `GRAFANA_K6_ACCESS_TOKEN` environment variable.
        """
        return __config__.get('k6AccessToken')

    @_builtins.property
    def k6_url(self) -> Optional[str]:
        """
        The k6 Cloud API url. May alternatively be set via the `GRAFANA_K6_URL` environment variable.
        """
        return __config__.get('k6Url')

    @_builtins.property
    def oncall_access_token(self) -> Optional[str]:
        """
        A Grafana OnCall access token. May alternatively be set via the `GRAFANA_ONCALL_ACCESS_TOKEN` environment variable.
        """
        return __config__.get('oncallAccessToken') or _utilities.get_env('GRAFANA_ONCALL_ACCESS_TOKEN')

    @_builtins.property
    def oncall_url(self) -> Optional[str]:
        """
        An Grafana OnCall backend address. May alternatively be set via the `GRAFANA_ONCALL_URL` environment variable.
        """
        return __config__.get('oncallUrl') or _utilities.get_env('GRAFANA_ONCALL_URL')

    @_builtins.property
    def org_id(self) -> Optional[int]:
        """
        The Grafana org ID, if you are using a self-hosted OSS or enterprise Grafana instance. May alternatively be set via the `GRAFANA_ORG_ID` environment variable.
        """
        return __config__.get_int('orgId')

    @_builtins.property
    def retries(self) -> Optional[int]:
        """
        The amount of retries to use for Grafana API and Grafana Cloud API calls. May alternatively be set via the `GRAFANA_RETRIES` environment variable.
        """
        return __config__.get_int('retries') or _utilities.get_env_int('GRAFANA_RETRIES')

    @_builtins.property
    def retry_status_codes(self) -> Optional[str]:
        """
        The status codes to retry on for Grafana API and Grafana Cloud API calls. Use `x` as a digit wildcard. Defaults to 429 and 5xx. May alternatively be set via the `GRAFANA_RETRY_STATUS_CODES` environment variable.
        """
        return __config__.get('retryStatusCodes')

    @_builtins.property
    def retry_wait(self) -> Optional[int]:
        """
        The amount of time in seconds to wait between retries for Grafana API and Grafana Cloud API calls. May alternatively be set via the `GRAFANA_RETRY_WAIT` environment variable.
        """
        return __config__.get_int('retryWait') or _utilities.get_env_int('GRAFANA_RETRY_WAIT')

    @_builtins.property
    def sm_access_token(self) -> Optional[str]:
        """
        A Synthetic Monitoring access token. May alternatively be set via the `GRAFANA_SM_ACCESS_TOKEN` environment variable.
        """
        return __config__.get('smAccessToken') or _utilities.get_env('GRAFANA_SM_ACCESS_TOKEN')

    @_builtins.property
    def sm_url(self) -> Optional[str]:
        return __config__.get('smUrl') or _utilities.get_env('GRAFANA_SM_URL')

    @_builtins.property
    def stack_id(self) -> Optional[int]:
        """
        The Grafana stack ID, if you are using a Grafana Cloud stack. May alternatively be set via the `GRAFANA_STACK_ID` environment variable.
        """
        return __config__.get_int('stackId')

    @_builtins.property
    def store_dashboard_sha256(self) -> Optional[bool]:
        """
        Set to true if you want to save only the sha256sum instead of complete dashboard model JSON in the tfstate.
        """
        return __config__.get_bool('storeDashboardSha256') or _utilities.get_env_bool('GRAFANA_STORE_DASHBOARD_SHA256')

    @_builtins.property
    def tls_cert(self) -> Optional[str]:
        """
        Client TLS certificate (file path or literal value) to use to authenticate to the Grafana server. May alternatively be set via the `GRAFANA_TLS_CERT` environment variable.
        """
        return __config__.get('tlsCert') or _utilities.get_env('GRAFANA_TLS_CERT')

    @_builtins.property
    def tls_key(self) -> Optional[str]:
        """
        Client TLS key (file path or literal value) to use to authenticate to the Grafana server. May alternatively be set via the `GRAFANA_TLS_KEY` environment variable.
        """
        return __config__.get('tlsKey') or _utilities.get_env('GRAFANA_TLS_KEY')

    @_builtins.property
    def url(self) -> Optional[str]:
        """
        The root URL of a Grafana server. May alternatively be set via the `GRAFANA_URL` environment variable.
        """
        return __config__.get('url') or _utilities.get_env('GRAFANA_URL')

