# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MetricsEndpointScrapeJobArgs', 'MetricsEndpointScrapeJob']

@pulumi.input_type
class MetricsEndpointScrapeJobArgs:
    def __init__(__self__, *,
                 authentication_method: pulumi.Input[_builtins.str],
                 stack_id: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 authentication_basic_password: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_basic_username: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_bearer_token: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MetricsEndpointScrapeJob resource.
        :param pulumi.Input[_builtins.str] authentication_method: Method to pass authentication credentials: basic or bearer.
        :param pulumi.Input[_builtins.str] url: The url to scrape metrics from; a valid HTTPs URL is required.
        :param pulumi.Input[_builtins.str] authentication_basic_password: Password for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_basic_username: Username for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_bearer_token: Bearer token used for authentication, use if scrape job is using bearer authentication method
        :param pulumi.Input[_builtins.bool] enabled: Whether the metrics endpoint scrape job is enabled or not.
        :param pulumi.Input[_builtins.int] scrape_interval_seconds: Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        """
        pulumi.set(__self__, "authentication_method", authentication_method)
        pulumi.set(__self__, "stack_id", stack_id)
        pulumi.set(__self__, "url", url)
        if authentication_basic_password is not None:
            pulumi.set(__self__, "authentication_basic_password", authentication_basic_password)
        if authentication_basic_username is not None:
            pulumi.set(__self__, "authentication_basic_username", authentication_basic_username)
        if authentication_bearer_token is not None:
            pulumi.set(__self__, "authentication_bearer_token", authentication_bearer_token)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Input[_builtins.str]:
        """
        Method to pass authentication credentials: basic or bearer.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The url to scrape metrics from; a valid HTTPs URL is required.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="authenticationBasicPassword")
    def authentication_basic_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for basic authentication, use if scrape job is using basic authentication method
        """
        return pulumi.get(self, "authentication_basic_password")

    @authentication_basic_password.setter
    def authentication_basic_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_basic_password", value)

    @_builtins.property
    @pulumi.getter(name="authenticationBasicUsername")
    def authentication_basic_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for basic authentication, use if scrape job is using basic authentication method
        """
        return pulumi.get(self, "authentication_basic_username")

    @authentication_basic_username.setter
    def authentication_basic_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_basic_username", value)

    @_builtins.property
    @pulumi.getter(name="authenticationBearerToken")
    def authentication_bearer_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bearer token used for authentication, use if scrape job is using bearer authentication method
        """
        return pulumi.get(self, "authentication_bearer_token")

    @authentication_bearer_token.setter
    def authentication_bearer_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_bearer_token", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the metrics endpoint scrape job is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @scrape_interval_seconds.setter
    def scrape_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scrape_interval_seconds", value)


@pulumi.input_type
class _MetricsEndpointScrapeJobState:
    def __init__(__self__, *,
                 authentication_basic_password: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_basic_username: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_bearer_token: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetricsEndpointScrapeJob resources.
        :param pulumi.Input[_builtins.str] authentication_basic_password: Password for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_basic_username: Username for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_bearer_token: Bearer token used for authentication, use if scrape job is using bearer authentication method
        :param pulumi.Input[_builtins.str] authentication_method: Method to pass authentication credentials: basic or bearer.
        :param pulumi.Input[_builtins.bool] enabled: Whether the metrics endpoint scrape job is enabled or not.
        :param pulumi.Input[_builtins.int] scrape_interval_seconds: Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        :param pulumi.Input[_builtins.str] url: The url to scrape metrics from; a valid HTTPs URL is required.
        """
        if authentication_basic_password is not None:
            pulumi.set(__self__, "authentication_basic_password", authentication_basic_password)
        if authentication_basic_username is not None:
            pulumi.set(__self__, "authentication_basic_username", authentication_basic_username)
        if authentication_bearer_token is not None:
            pulumi.set(__self__, "authentication_bearer_token", authentication_bearer_token)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scrape_interval_seconds is not None:
            pulumi.set(__self__, "scrape_interval_seconds", scrape_interval_seconds)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="authenticationBasicPassword")
    def authentication_basic_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for basic authentication, use if scrape job is using basic authentication method
        """
        return pulumi.get(self, "authentication_basic_password")

    @authentication_basic_password.setter
    def authentication_basic_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_basic_password", value)

    @_builtins.property
    @pulumi.getter(name="authenticationBasicUsername")
    def authentication_basic_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username for basic authentication, use if scrape job is using basic authentication method
        """
        return pulumi.get(self, "authentication_basic_username")

    @authentication_basic_username.setter
    def authentication_basic_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_basic_username", value)

    @_builtins.property
    @pulumi.getter(name="authenticationBearerToken")
    def authentication_bearer_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bearer token used for authentication, use if scrape job is using bearer authentication method
        """
        return pulumi.get(self, "authentication_bearer_token")

    @authentication_bearer_token.setter
    def authentication_bearer_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_bearer_token", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Method to pass authentication credentials: basic or bearer.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the metrics endpoint scrape job is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @scrape_interval_seconds.setter
    def scrape_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scrape_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url to scrape metrics from; a valid HTTPs URL is required.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("grafana:connections/metricsEndpointScrapeJob:MetricsEndpointScrapeJob")
class MetricsEndpointScrapeJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_basic_password: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_basic_username: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_bearer_token: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.connections.MetricsEndpointScrapeJob("test",
            stack_id="1",
            name="my-scrape-job",
            enabled=True,
            authentication_method="basic",
            authentication_basic_username="my-username",
            authentication_basic_password="my-password",
            url="https://grafana.com/metrics",
            scrape_interval_seconds=120)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:connections/metricsEndpointScrapeJob:MetricsEndpointScrapeJob name "{{ stack_id }}:{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_basic_password: Password for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_basic_username: Username for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_bearer_token: Bearer token used for authentication, use if scrape job is using bearer authentication method
        :param pulumi.Input[_builtins.str] authentication_method: Method to pass authentication credentials: basic or bearer.
        :param pulumi.Input[_builtins.bool] enabled: Whether the metrics endpoint scrape job is enabled or not.
        :param pulumi.Input[_builtins.int] scrape_interval_seconds: Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        :param pulumi.Input[_builtins.str] url: The url to scrape metrics from; a valid HTTPs URL is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricsEndpointScrapeJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.connections.MetricsEndpointScrapeJob("test",
            stack_id="1",
            name="my-scrape-job",
            enabled=True,
            authentication_method="basic",
            authentication_basic_username="my-username",
            authentication_basic_password="my-password",
            url="https://grafana.com/metrics",
            scrape_interval_seconds=120)
        ```

        ## Import

        ```sh
        $ pulumi import grafana:connections/metricsEndpointScrapeJob:MetricsEndpointScrapeJob name "{{ stack_id }}:{{ name }}"
        ```

        :param str resource_name: The name of the resource.
        :param MetricsEndpointScrapeJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricsEndpointScrapeJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_basic_password: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_basic_username: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_bearer_token: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scrape_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricsEndpointScrapeJobArgs.__new__(MetricsEndpointScrapeJobArgs)

            __props__.__dict__["authentication_basic_password"] = None if authentication_basic_password is None else pulumi.Output.secret(authentication_basic_password)
            __props__.__dict__["authentication_basic_username"] = authentication_basic_username
            __props__.__dict__["authentication_bearer_token"] = None if authentication_bearer_token is None else pulumi.Output.secret(authentication_bearer_token)
            if authentication_method is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_method'")
            __props__.__dict__["authentication_method"] = authentication_method
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["scrape_interval_seconds"] = scrape_interval_seconds
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authenticationBasicPassword", "authenticationBearerToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MetricsEndpointScrapeJob, __self__).__init__(
            'grafana:connections/metricsEndpointScrapeJob:MetricsEndpointScrapeJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_basic_password: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_basic_username: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_bearer_token: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scrape_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            stack_id: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'MetricsEndpointScrapeJob':
        """
        Get an existing MetricsEndpointScrapeJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_basic_password: Password for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_basic_username: Username for basic authentication, use if scrape job is using basic authentication method
        :param pulumi.Input[_builtins.str] authentication_bearer_token: Bearer token used for authentication, use if scrape job is using bearer authentication method
        :param pulumi.Input[_builtins.str] authentication_method: Method to pass authentication credentials: basic or bearer.
        :param pulumi.Input[_builtins.bool] enabled: Whether the metrics endpoint scrape job is enabled or not.
        :param pulumi.Input[_builtins.int] scrape_interval_seconds: Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        :param pulumi.Input[_builtins.str] url: The url to scrape metrics from; a valid HTTPs URL is required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricsEndpointScrapeJobState.__new__(_MetricsEndpointScrapeJobState)

        __props__.__dict__["authentication_basic_password"] = authentication_basic_password
        __props__.__dict__["authentication_basic_username"] = authentication_basic_username
        __props__.__dict__["authentication_bearer_token"] = authentication_bearer_token
        __props__.__dict__["authentication_method"] = authentication_method
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["scrape_interval_seconds"] = scrape_interval_seconds
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["url"] = url
        return MetricsEndpointScrapeJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationBasicPassword")
    def authentication_basic_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for basic authentication, use if scrape job is using basic authentication method
        """
        return pulumi.get(self, "authentication_basic_password")

    @_builtins.property
    @pulumi.getter(name="authenticationBasicUsername")
    def authentication_basic_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username for basic authentication, use if scrape job is using basic authentication method
        """
        return pulumi.get(self, "authentication_basic_username")

    @_builtins.property
    @pulumi.getter(name="authenticationBearerToken")
    def authentication_bearer_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Bearer token used for authentication, use if scrape job is using bearer authentication method
        """
        return pulumi.get(self, "authentication_bearer_token")

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Output[_builtins.str]:
        """
        Method to pass authentication credentials: basic or bearer.
        """
        return pulumi.get(self, "authentication_method")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the metrics endpoint scrape job is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scrapeIntervalSeconds")
    def scrape_interval_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Frequency for scraping the metrics endpoint: 30, 60, or 120 seconds.
        """
        return pulumi.get(self, "scrape_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The url to scrape metrics from; a valid HTTPs URL is required.
        """
        return pulumi.get(self, "url")

