# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataSourceConfigLbacRulesArgs', 'DataSourceConfigLbacRules']

@pulumi.input_type
class DataSourceConfigLbacRulesArgs:
    def __init__(__self__, *,
                 datasource_uid: pulumi.Input[_builtins.str],
                 rules: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DataSourceConfigLbacRules resource.
        :param pulumi.Input[_builtins.str] datasource_uid: The UID of the datasource.
        :param pulumi.Input[_builtins.str] rules: JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        pulumi.set(__self__, "datasource_uid", datasource_uid)
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> pulumi.Input[_builtins.str]:
        """
        The UID of the datasource.
        """
        return pulumi.get(self, "datasource_uid")

    @datasource_uid.setter
    def datasource_uid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "datasource_uid", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[_builtins.str]:
        """
        JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _DataSourceConfigLbacRulesState:
    def __init__(__self__, *,
                 datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataSourceConfigLbacRules resources.
        :param pulumi.Input[_builtins.str] datasource_uid: The UID of the datasource.
        :param pulumi.Input[_builtins.str] rules: JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        if datasource_uid is not None:
            pulumi.set(__self__, "datasource_uid", datasource_uid)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the datasource.
        """
        return pulumi.get(self, "datasource_uid")

    @datasource_uid.setter
    def datasource_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datasource_uid", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("grafana:enterprise/dataSourceConfigLbacRules:DataSourceConfigLbacRules")
class DataSourceConfigLbacRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages LBAC rules for a data source.

        !> Warning: The resource is experimental and will be subject to change. This resource manages the entire LBAC rules tree, and will overwrite any existing rules.

        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/data-source-management/teamlbac/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/datasource_lbac_rules/)

        This resource requires Grafana >=11.5.0.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_grafana as grafana

        team = grafana.oss.Team("team", name="Team Name")
        test = grafana.oss.DataSource("test",
            type="loki",
            name="loki-from-terraform",
            url="https://mylokiurl.net",
            basic_auth_enabled=True,
            basic_auth_username="username",
            json_data_encoded=json.dumps({
                "authType": "default",
                "basicAuthPassword": "password",
            }))
        test_rule = grafana.enterprise.DataSourceConfigLbacRules("test_rule",
            datasource_uid=test.uid,
            rules=pulumi.Output.json_dumps(team.team_uid.apply(lambda team_uid: {
                team_uid: [
                    "{ cluster = \\"dev-us-central-0\\", namespace = \\"hosted-grafana\\" }",
                    "{ foo = \\"qux\\" }",
                ],
            })),
            opts = pulumi.ResourceOptions(depends_on=[
                    team,
                    test,
                ]))
        ```

        ## Import

        ```sh
        $ pulumi import grafana:enterprise/dataSourceConfigLbacRules:DataSourceConfigLbacRules name "{{ datasource_uid }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] datasource_uid: The UID of the datasource.
        :param pulumi.Input[_builtins.str] rules: JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceConfigLbacRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages LBAC rules for a data source.

        !> Warning: The resource is experimental and will be subject to change. This resource manages the entire LBAC rules tree, and will overwrite any existing rules.

        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/data-source-management/teamlbac/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/datasource_lbac_rules/)

        This resource requires Grafana >=11.5.0.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumiverse_grafana as grafana

        team = grafana.oss.Team("team", name="Team Name")
        test = grafana.oss.DataSource("test",
            type="loki",
            name="loki-from-terraform",
            url="https://mylokiurl.net",
            basic_auth_enabled=True,
            basic_auth_username="username",
            json_data_encoded=json.dumps({
                "authType": "default",
                "basicAuthPassword": "password",
            }))
        test_rule = grafana.enterprise.DataSourceConfigLbacRules("test_rule",
            datasource_uid=test.uid,
            rules=pulumi.Output.json_dumps(team.team_uid.apply(lambda team_uid: {
                team_uid: [
                    "{ cluster = \\"dev-us-central-0\\", namespace = \\"hosted-grafana\\" }",
                    "{ foo = \\"qux\\" }",
                ],
            })),
            opts = pulumi.ResourceOptions(depends_on=[
                    team,
                    test,
                ]))
        ```

        ## Import

        ```sh
        $ pulumi import grafana:enterprise/dataSourceConfigLbacRules:DataSourceConfigLbacRules name "{{ datasource_uid }}"
        ```

        :param str resource_name: The name of the resource.
        :param DataSourceConfigLbacRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceConfigLbacRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceConfigLbacRulesArgs.__new__(DataSourceConfigLbacRulesArgs)

            if datasource_uid is None and not opts.urn:
                raise TypeError("Missing required property 'datasource_uid'")
            __props__.__dict__["datasource_uid"] = datasource_uid
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
        super(DataSourceConfigLbacRules, __self__).__init__(
            'grafana:enterprise/dataSourceConfigLbacRules:DataSourceConfigLbacRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataSourceConfigLbacRules':
        """
        Get an existing DataSourceConfigLbacRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] datasource_uid: The UID of the datasource.
        :param pulumi.Input[_builtins.str] rules: JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourceConfigLbacRulesState.__new__(_DataSourceConfigLbacRulesState)

        __props__.__dict__["datasource_uid"] = datasource_uid
        __props__.__dict__["rules"] = rules
        return DataSourceConfigLbacRules(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> pulumi.Output[_builtins.str]:
        """
        The UID of the datasource.
        """
        return pulumi.get(self, "datasource_uid")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[_builtins.str]:
        """
        JSON-encoded LBAC rules for the data source. Map of team UIDs to lists of rule strings.
        """
        return pulumi.get(self, "rules")

