# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataSourcePermissionPermission',
    'ReportDashboard',
    'ReportDashboardTimeRange',
    'ReportSchedule',
    'RolePermission',
    'GetRolePermissionResult',
]

@pulumi.output_type
class DataSourcePermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builtInRole":
            suggest = "built_in_role"
        elif key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourcePermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourcePermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourcePermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: _builtins.str,
                 built_in_role: Optional[_builtins.str] = None,
                 team_id: Optional[_builtins.str] = None,
                 user_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str permission: Permission to associate with item. Options: `Query`, `Edit` or `Admin` (`Admin` can only be used with Grafana v10.3.0+).
        :param _builtins.str built_in_role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param _builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param _builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if built_in_role is not None:
            pulumi.set(__self__, "built_in_role", built_in_role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission to associate with item. Options: `Query`, `Edit` or `Admin` (`Admin` can only be used with Grafana v10.3.0+).
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter(name="builtInRole")
    def built_in_role(self) -> Optional[_builtins.str]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "built_in_role")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[_builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class ReportDashboard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportVariables":
            suggest = "report_variables"
        elif key == "timeRange":
            suggest = "time_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDashboard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDashboard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDashboard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uid: _builtins.str,
                 report_variables: Optional[Mapping[str, _builtins.str]] = None,
                 time_range: Optional['outputs.ReportDashboardTimeRange'] = None):
        """
        :param _builtins.str uid: Dashboard uid.
        :param Mapping[str, _builtins.str] report_variables: Add report variables to the dashboard. Values should be separated by commas.
        :param 'ReportDashboardTimeRangeArgs' time_range: Time range of the report.
        """
        pulumi.set(__self__, "uid", uid)
        if report_variables is not None:
            pulumi.set(__self__, "report_variables", report_variables)
        if time_range is not None:
            pulumi.set(__self__, "time_range", time_range)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        Dashboard uid.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="reportVariables")
    def report_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Add report variables to the dashboard. Values should be separated by commas.
        """
        return pulumi.get(self, "report_variables")

    @_builtins.property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional['outputs.ReportDashboardTimeRange']:
        """
        Time range of the report.
        """
        return pulumi.get(self, "time_range")


@pulumi.output_type
class ReportDashboardTimeRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDashboardTimeRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDashboardTimeRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDashboardTimeRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[_builtins.str] = None,
                 to: Optional[_builtins.str] = None):
        """
        :param _builtins.str from_: Start of the time range.
        :param _builtins.str to: End of the time range.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[_builtins.str]:
        """
        Start of the time range.
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[_builtins.str]:
        """
        End of the time range.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ReportSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customInterval":
            suggest = "custom_interval"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "lastDayOfMonth":
            suggest = "last_day_of_month"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "workdaysOnly":
            suggest = "workdays_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: _builtins.str,
                 custom_interval: Optional[_builtins.str] = None,
                 end_time: Optional[_builtins.str] = None,
                 last_day_of_month: Optional[_builtins.bool] = None,
                 start_time: Optional[_builtins.str] = None,
                 timezone: Optional[_builtins.str] = None,
                 workdays_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str frequency: Frequency of the report. Allowed values: `never`, `once`, `hourly`, `daily`, `weekly`, `monthly`, `custom`.
        :param _builtins.str custom_interval: Custom interval of the report.
               **Note:** This field is only available when frequency is set to `custom`.
        :param _builtins.str end_time: End time of the report. If empty, the report will be sent indefinitely (according to frequency). Note that times will be saved as UTC in Grafana. Use 2006-01-02T15:04:05 format if you want to set a custom timezone
        :param _builtins.bool last_day_of_month: Send the report on the last day of the month Defaults to `false`.
        :param _builtins.str start_time: Start time of the report. If empty, the start date will be set to the creation time. Note that times will be saved as UTC in Grafana. Use 2006-01-02T15:04:05 format if you want to set a custom timezone
        :param _builtins.str timezone: Set the report time zone. Defaults to `GMT`.
        :param _builtins.bool workdays_only: Whether to send the report only on work days. Defaults to `false`.
        """
        pulumi.set(__self__, "frequency", frequency)
        if custom_interval is not None:
            pulumi.set(__self__, "custom_interval", custom_interval)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if last_day_of_month is not None:
            pulumi.set(__self__, "last_day_of_month", last_day_of_month)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if workdays_only is not None:
            pulumi.set(__self__, "workdays_only", workdays_only)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.str:
        """
        Frequency of the report. Allowed values: `never`, `once`, `hourly`, `daily`, `weekly`, `monthly`, `custom`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="customInterval")
    def custom_interval(self) -> Optional[_builtins.str]:
        """
        Custom interval of the report.
        **Note:** This field is only available when frequency is set to `custom`.
        """
        return pulumi.get(self, "custom_interval")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        End time of the report. If empty, the report will be sent indefinitely (according to frequency). Note that times will be saved as UTC in Grafana. Use 2006-01-02T15:04:05 format if you want to set a custom timezone
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="lastDayOfMonth")
    def last_day_of_month(self) -> Optional[_builtins.bool]:
        """
        Send the report on the last day of the month Defaults to `false`.
        """
        return pulumi.get(self, "last_day_of_month")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Start time of the report. If empty, the start date will be set to the creation time. Note that times will be saved as UTC in Grafana. Use 2006-01-02T15:04:05 format if you want to set a custom timezone
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        Set the report time zone. Defaults to `GMT`.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="workdaysOnly")
    def workdays_only(self) -> Optional[_builtins.bool]:
        """
        Whether to send the report only on work days. Defaults to `false`.
        """
        return pulumi.get(self, "workdays_only")


@pulumi.output_type
class RolePermission(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 scope: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Specific action users granted with the role will be allowed to perform (for example: `users:read`)
        :param _builtins.str scope: Scope to restrict the action to a set of resources (for example: `users:*` or `roles:customrole1`) Defaults to ``.
        """
        pulumi.set(__self__, "action", action)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Specific action users granted with the role will be allowed to perform (for example: `users:read`)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Scope to restrict the action to a set of resources (for example: `users:*` or `roles:customrole1`) Defaults to ``.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class GetRolePermissionResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 scope: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Specific action users granted with the role will be allowed to perform (for example: `users:read`)
        :param _builtins.str scope: Scope to restrict the action to a set of resources (for example: `users:*` or `roles:customrole1`)
        """
        pulumi.set(__self__, "action", action)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Specific action users granted with the role will be allowed to perform (for example: `users:read`)
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Scope to restrict the action to a set of resources (for example: `users:*` or `roles:customrole1`)
        """
        return pulumi.get(self, "scope")


