# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CollectorArgs', 'Collector']

@pulumi.input_type
class CollectorArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Collector resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] remote_attributes: Remote attributes for the collector
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if remote_attributes is not None:
            pulumi.set(__self__, "remote_attributes", remote_attributes)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="remoteAttributes")
    def remote_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Remote attributes for the collector
        """
        return pulumi.get(self, "remote_attributes")

    @remote_attributes.setter
    def remote_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "remote_attributes", value)


@pulumi.input_type
class _CollectorState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Collector resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] remote_attributes: Remote attributes for the collector
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if remote_attributes is not None:
            pulumi.set(__self__, "remote_attributes", remote_attributes)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="remoteAttributes")
    def remote_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Remote attributes for the collector
        """
        return pulumi.get(self, "remote_attributes")

    @remote_attributes.setter
    def remote_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "remote_attributes", value)


@pulumi.type_token("grafana:fleetManagement/collector:Collector")
class Collector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages Grafana Fleet Management collectors.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/api-reference/collector-api/)

        Required access policy scopes:

        * fleet-management:read
        * fleet-management:write

        ## Import

        ```sh
        $ pulumi import grafana:fleetManagement/collector:Collector name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] remote_attributes: Remote attributes for the collector
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CollectorArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Grafana Fleet Management collectors.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/)
        * [API documentation](https://grafana.com/docs/grafana-cloud/send-data/fleet-management/api-reference/collector-api/)

        Required access policy scopes:

        * fleet-management:read
        * fleet-management:write

        ## Import

        ```sh
        $ pulumi import grafana:fleetManagement/collector:Collector name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param CollectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CollectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 remote_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CollectorArgs.__new__(CollectorArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["remote_attributes"] = remote_attributes
        super(Collector, __self__).__init__(
            'grafana:fleetManagement/collector:Collector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            remote_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Collector':
        """
        Get an existing Collector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] remote_attributes: Remote attributes for the collector
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CollectorState.__new__(_CollectorState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["remote_attributes"] = remote_attributes
        return Collector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether remote configuration for the collector is enabled or not. If the collector is disabled, it will receive empty configurations from the Fleet Management service
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="remoteAttributes")
    def remote_attributes(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Remote attributes for the collector
        """
        return pulumi.get(self, "remote_attributes")

