# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLoadTestResult',
    'AwaitableGetLoadTestResult',
    'get_load_test',
    'get_load_test_output',
]

@pulumi.output_type
class GetLoadTestResult:
    """
    A collection of values returned by getLoadTest.
    """
    def __init__(__self__, baseline_test_run_id=None, created=None, id=None, name=None, project_id=None, script=None, updated=None):
        if baseline_test_run_id and not isinstance(baseline_test_run_id, str):
            raise TypeError("Expected argument 'baseline_test_run_id' to be a str")
        pulumi.set(__self__, "baseline_test_run_id", baseline_test_run_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if script and not isinstance(script, str):
            raise TypeError("Expected argument 'script' to be a str")
        pulumi.set(__self__, "script", script)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)

    @_builtins.property
    @pulumi.getter(name="baselineTestRunId")
    def baseline_test_run_id(self) -> _builtins.str:
        """
        Identifier of a baseline test run used for results comparison.
        """
        return pulumi.get(self, "baseline_test_run_id")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        The date when the load test was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Numeric identifier of the load test.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Human-friendly identifier of the load test.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The identifier of the project this load test belongs to.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        The k6 test script content.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> _builtins.str:
        """
        The date when the load test was last updated.
        """
        return pulumi.get(self, "updated")


class AwaitableGetLoadTestResult(GetLoadTestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadTestResult(
            baseline_test_run_id=self.baseline_test_run_id,
            created=self.created,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            script=self.script,
            updated=self.updated)


def get_load_test(id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadTestResult:
    """
    Retrieves a k6 load test.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    load_test_project = grafana.k6.Project("load_test_project", name="Terraform Load Test Project")
    test_load_test = grafana.k6.LoadTest("test_load_test",
        project_id=load_test_project.id,
        name="Terraform Test Load Test",
        script=\"\"\"export default function() {
      console.log('Hello from k6!');
    }
    \"\"\")
    from_id = grafana.k6.get_load_test_output(id=test_load_test.id)
    ```


    :param _builtins.str id: Numeric identifier of the load test.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:k6/getLoadTest:getLoadTest', __args__, opts=opts, typ=GetLoadTestResult).value

    return AwaitableGetLoadTestResult(
        baseline_test_run_id=pulumi.get(__ret__, 'baseline_test_run_id'),
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        script=pulumi.get(__ret__, 'script'),
        updated=pulumi.get(__ret__, 'updated'))
def get_load_test_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadTestResult]:
    """
    Retrieves a k6 load test.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    load_test_project = grafana.k6.Project("load_test_project", name="Terraform Load Test Project")
    test_load_test = grafana.k6.LoadTest("test_load_test",
        project_id=load_test_project.id,
        name="Terraform Test Load Test",
        script=\"\"\"export default function() {
      console.log('Hello from k6!');
    }
    \"\"\")
    from_id = grafana.k6.get_load_test_output(id=test_load_test.id)
    ```


    :param _builtins.str id: Numeric identifier of the load test.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:k6/getLoadTest:getLoadTest', __args__, opts=opts, typ=GetLoadTestResult)
    return __ret__.apply(lambda __response__: GetLoadTestResult(
        baseline_test_run_id=pulumi.get(__response__, 'baseline_test_run_id'),
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        script=pulumi.get(__response__, 'script'),
        updated=pulumi.get(__response__, 'updated')))
