# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLoadTestsResult',
    'AwaitableGetLoadTestsResult',
    'get_load_tests',
    'get_load_tests_output',
]

@pulumi.output_type
class GetLoadTestsResult:
    """
    A collection of values returned by getLoadTests.
    """
    def __init__(__self__, id=None, load_tests=None, name=None, project_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_tests and not isinstance(load_tests, list):
            raise TypeError("Expected argument 'load_tests' to be a list")
        pulumi.set(__self__, "load_tests", load_tests)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The identifier of the project the load tests belong to. This is set to the same as the project_id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="loadTests")
    def load_tests(self) -> Sequence['outputs.GetLoadTestsLoadTestResult']:
        return pulumi.get(self, "load_tests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Human-friendly identifier of the load test.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The identifier of the project the load tests belong to.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetLoadTestsResult(GetLoadTestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadTestsResult(
            id=self.id,
            load_tests=self.load_tests,
            name=self.name,
            project_id=self.project_id)


def get_load_tests(name: Optional[_builtins.str] = None,
                   project_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadTestsResult:
    """
    Retrieves all k6 load tests that belong to a project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    load_test_project = grafana.k6.Project("load_test_project", name="Terraform Load Test Project")
    test_load_test = grafana.k6.LoadTest("test_load_test",
        project_id=load_test_project.id,
        name="Terraform Test Load Test",
        script=\"\"\"export default function() {
      console.log('Hello from k6!');
    }
    \"\"\",
        opts = pulumi.ResourceOptions(depends_on=[load_test_project]))
    test_load_test2 = grafana.k6.LoadTest("test_load_test_2",
        project_id=load_test_project.id,
        name="Terraform Test Load Test (2)",
        script=\"\"\"export default function() {
      console.log('Hello from k6!');
    }
    \"\"\",
        opts = pulumi.ResourceOptions(depends_on=[test_load_test]))
    from_project_id = grafana.k6.get_load_tests_output(project_id=load_test_project.id)
    filter_by_name = grafana.k6.get_load_tests_output(name="Terraform Test Load Test (2)",
        project_id=load_test_project.id)
    ```


    :param _builtins.str name: Human-friendly identifier of the load test.
    :param _builtins.str project_id: The identifier of the project the load tests belong to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:k6/getLoadTests:getLoadTests', __args__, opts=opts, typ=GetLoadTestsResult).value

    return AwaitableGetLoadTestsResult(
        id=pulumi.get(__ret__, 'id'),
        load_tests=pulumi.get(__ret__, 'load_tests'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_load_tests_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          project_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadTestsResult]:
    """
    Retrieves all k6 load tests that belong to a project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    load_test_project = grafana.k6.Project("load_test_project", name="Terraform Load Test Project")
    test_load_test = grafana.k6.LoadTest("test_load_test",
        project_id=load_test_project.id,
        name="Terraform Test Load Test",
        script=\"\"\"export default function() {
      console.log('Hello from k6!');
    }
    \"\"\",
        opts = pulumi.ResourceOptions(depends_on=[load_test_project]))
    test_load_test2 = grafana.k6.LoadTest("test_load_test_2",
        project_id=load_test_project.id,
        name="Terraform Test Load Test (2)",
        script=\"\"\"export default function() {
      console.log('Hello from k6!');
    }
    \"\"\",
        opts = pulumi.ResourceOptions(depends_on=[test_load_test]))
    from_project_id = grafana.k6.get_load_tests_output(project_id=load_test_project.id)
    filter_by_name = grafana.k6.get_load_tests_output(name="Terraform Test Load Test (2)",
        project_id=load_test_project.id)
    ```


    :param _builtins.str name: Human-friendly identifier of the load test.
    :param _builtins.str project_id: The identifier of the project the load tests belong to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:k6/getLoadTests:getLoadTests', __args__, opts=opts, typ=GetLoadTestsResult)
    return __ret__.apply(lambda __response__: GetLoadTestsResult(
        id=pulumi.get(__response__, 'id'),
        load_tests=pulumi.get(__response__, 'load_tests'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id')))
