# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectAllowedLoadZonesArgs', 'ProjectAllowedLoadZones']

@pulumi.input_type
class ProjectAllowedLoadZonesArgs:
    def __init__(__self__, *,
                 allowed_load_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 project_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ProjectAllowedLoadZones resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_load_zones: List of allowed private k6 load zone IDs for this project.
        :param pulumi.Input[_builtins.str] project_id: The identifier of the project to manage private allowed load zones for.
        """
        pulumi.set(__self__, "allowed_load_zones", allowed_load_zones)
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="allowedLoadZones")
    def allowed_load_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of allowed private k6 load zone IDs for this project.
        """
        return pulumi.get(self, "allowed_load_zones")

    @allowed_load_zones.setter
    def allowed_load_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_load_zones", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the project to manage private allowed load zones for.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _ProjectAllowedLoadZonesState:
    def __init__(__self__, *,
                 allowed_load_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectAllowedLoadZones resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_load_zones: List of allowed private k6 load zone IDs for this project.
        :param pulumi.Input[_builtins.str] project_id: The identifier of the project to manage private allowed load zones for.
        """
        if allowed_load_zones is not None:
            pulumi.set(__self__, "allowed_load_zones", allowed_load_zones)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="allowedLoadZones")
    def allowed_load_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed private k6 load zone IDs for this project.
        """
        return pulumi.get(self, "allowed_load_zones")

    @allowed_load_zones.setter
    def allowed_load_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_load_zones", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the project to manage private allowed load zones for.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("grafana:k6/projectAllowedLoadZones:ProjectAllowedLoadZones")
class ProjectAllowedLoadZones(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_load_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages allowed private load zones for a k6 project.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_project_allowed_load_zones = grafana.k6.Project("test_project_allowed_load_zones", name="Terraform Project Test Allowed Load Zones")
        test_allowed_zones = grafana.k6.ProjectAllowedLoadZones("test_allowed_zones",
            project_id=test_project_allowed_load_zones.id,
            allowed_load_zones=[
                "my-load-zone-1",
                "other-load-zone",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:k6/projectAllowedLoadZones:ProjectAllowedLoadZones name "{{ project_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_load_zones: List of allowed private k6 load zone IDs for this project.
        :param pulumi.Input[_builtins.str] project_id: The identifier of the project to manage private allowed load zones for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectAllowedLoadZonesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages allowed private load zones for a k6 project.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test_project_allowed_load_zones = grafana.k6.Project("test_project_allowed_load_zones", name="Terraform Project Test Allowed Load Zones")
        test_allowed_zones = grafana.k6.ProjectAllowedLoadZones("test_allowed_zones",
            project_id=test_project_allowed_load_zones.id,
            allowed_load_zones=[
                "my-load-zone-1",
                "other-load-zone",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:k6/projectAllowedLoadZones:ProjectAllowedLoadZones name "{{ project_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectAllowedLoadZonesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectAllowedLoadZonesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_load_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectAllowedLoadZonesArgs.__new__(ProjectAllowedLoadZonesArgs)

            if allowed_load_zones is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_load_zones'")
            __props__.__dict__["allowed_load_zones"] = allowed_load_zones
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
        super(ProjectAllowedLoadZones, __self__).__init__(
            'grafana:k6/projectAllowedLoadZones:ProjectAllowedLoadZones',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_load_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProjectAllowedLoadZones':
        """
        Get an existing ProjectAllowedLoadZones resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_load_zones: List of allowed private k6 load zone IDs for this project.
        :param pulumi.Input[_builtins.str] project_id: The identifier of the project to manage private allowed load zones for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectAllowedLoadZonesState.__new__(_ProjectAllowedLoadZonesState)

        __props__.__dict__["allowed_load_zones"] = allowed_load_zones
        __props__.__dict__["project_id"] = project_id
        return ProjectAllowedLoadZones(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedLoadZones")
    def allowed_load_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of allowed private k6 load zone IDs for this project.
        """
        return pulumi.get(self, "allowed_load_zones")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the project to manage private allowed load zones for.
        """
        return pulumi.get(self, "project_id")

