# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HolidayArgs', 'Holiday']

@pulumi.input_type
class HolidayArgs:
    def __init__(__self__, *,
                 custom_periods: Optional[pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Holiday resource.
        :param pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]] custom_periods: A list of custom periods for the holiday.
        :param pulumi.Input[_builtins.str] description: A description of the holiday.
        :param pulumi.Input[_builtins.str] ical_timezone: The timezone to use for events in the iCal file pointed to by ical_url.
        :param pulumi.Input[_builtins.str] ical_url: A URL to an iCal file containing all occurrences of the holiday.
        :param pulumi.Input[_builtins.str] name: The name of the holiday.
        """
        if custom_periods is not None:
            pulumi.set(__self__, "custom_periods", custom_periods)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ical_timezone is not None:
            pulumi.set(__self__, "ical_timezone", ical_timezone)
        if ical_url is not None:
            pulumi.set(__self__, "ical_url", ical_url)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="customPeriods")
    def custom_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]]]:
        """
        A list of custom periods for the holiday.
        """
        return pulumi.get(self, "custom_periods")

    @custom_periods.setter
    def custom_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]]]):
        pulumi.set(self, "custom_periods", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the holiday.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="icalTimezone")
    def ical_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone to use for events in the iCal file pointed to by ical_url.
        """
        return pulumi.get(self, "ical_timezone")

    @ical_timezone.setter
    def ical_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_timezone", value)

    @_builtins.property
    @pulumi.getter(name="icalUrl")
    def ical_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A URL to an iCal file containing all occurrences of the holiday.
        """
        return pulumi.get(self, "ical_url")

    @ical_url.setter
    def ical_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the holiday.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _HolidayState:
    def __init__(__self__, *,
                 custom_periods: Optional[pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Holiday resources.
        :param pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]] custom_periods: A list of custom periods for the holiday.
        :param pulumi.Input[_builtins.str] description: A description of the holiday.
        :param pulumi.Input[_builtins.str] ical_timezone: The timezone to use for events in the iCal file pointed to by ical_url.
        :param pulumi.Input[_builtins.str] ical_url: A URL to an iCal file containing all occurrences of the holiday.
        :param pulumi.Input[_builtins.str] name: The name of the holiday.
        """
        if custom_periods is not None:
            pulumi.set(__self__, "custom_periods", custom_periods)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ical_timezone is not None:
            pulumi.set(__self__, "ical_timezone", ical_timezone)
        if ical_url is not None:
            pulumi.set(__self__, "ical_url", ical_url)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="customPeriods")
    def custom_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]]]:
        """
        A list of custom periods for the holiday.
        """
        return pulumi.get(self, "custom_periods")

    @custom_periods.setter
    def custom_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HolidayCustomPeriodArgs']]]]):
        pulumi.set(self, "custom_periods", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the holiday.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="icalTimezone")
    def ical_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone to use for events in the iCal file pointed to by ical_url.
        """
        return pulumi.get(self, "ical_timezone")

    @ical_timezone.setter
    def ical_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_timezone", value)

    @_builtins.property
    @pulumi.getter(name="icalUrl")
    def ical_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A URL to an iCal file containing all occurrences of the holiday.
        """
        return pulumi.get(self, "ical_url")

    @ical_url.setter
    def ical_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the holiday.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("grafana:machineLearning/holiday:Holiday")
class Holiday(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_periods: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HolidayCustomPeriodArgs', 'HolidayCustomPeriodArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A holiday describes time periods where a time series is expected to behave differently to normal.

        To use a holiday in a job, use its id in the `holidays` attribute of a `machineLearning.Job`:

        ### iCal Holiday

        This holiday uses an iCal file to define the holidays.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        ical = grafana.machinelearning.Holiday("ical",
            name="My iCal holiday",
            description="My Holiday",
            ical_url="https://calendar.google.com/calendar/ical/en.uk%23holiday%40group.v.calendar.google.com/public/basic.ics",
            ical_timezone="Europe/London")
        ```

        ### Custom Periods Holiday

        This holiday uses custom periods to define the holidays.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        custom_periods = grafana.machinelearning.Holiday("custom_periods",
            name="My custom periods holiday",
            description="My Holiday",
            custom_periods=[
                {
                    "name": "First of January",
                    "start_time": "2023-01-01T00:00:00Z",
                    "end_time": "2023-01-02T00:00:00Z",
                },
                {
                    "name": "First of Feburary",
                    "start_time": "2023-02-01T00:00:00Z",
                    "end_time": "2023-02-02T00:00:00Z",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:machineLearning/holiday:Holiday name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HolidayCustomPeriodArgs', 'HolidayCustomPeriodArgsDict']]]] custom_periods: A list of custom periods for the holiday.
        :param pulumi.Input[_builtins.str] description: A description of the holiday.
        :param pulumi.Input[_builtins.str] ical_timezone: The timezone to use for events in the iCal file pointed to by ical_url.
        :param pulumi.Input[_builtins.str] ical_url: A URL to an iCal file containing all occurrences of the holiday.
        :param pulumi.Input[_builtins.str] name: The name of the holiday.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[HolidayArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A holiday describes time periods where a time series is expected to behave differently to normal.

        To use a holiday in a job, use its id in the `holidays` attribute of a `machineLearning.Job`:

        ### iCal Holiday

        This holiday uses an iCal file to define the holidays.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        ical = grafana.machinelearning.Holiday("ical",
            name="My iCal holiday",
            description="My Holiday",
            ical_url="https://calendar.google.com/calendar/ical/en.uk%23holiday%40group.v.calendar.google.com/public/basic.ics",
            ical_timezone="Europe/London")
        ```

        ### Custom Periods Holiday

        This holiday uses custom periods to define the holidays.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        custom_periods = grafana.machinelearning.Holiday("custom_periods",
            name="My custom periods holiday",
            description="My Holiday",
            custom_periods=[
                {
                    "name": "First of January",
                    "start_time": "2023-01-01T00:00:00Z",
                    "end_time": "2023-01-02T00:00:00Z",
                },
                {
                    "name": "First of Feburary",
                    "start_time": "2023-02-01T00:00:00Z",
                    "end_time": "2023-02-02T00:00:00Z",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:machineLearning/holiday:Holiday name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param HolidayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HolidayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_periods: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HolidayCustomPeriodArgs', 'HolidayCustomPeriodArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HolidayArgs.__new__(HolidayArgs)

            __props__.__dict__["custom_periods"] = custom_periods
            __props__.__dict__["description"] = description
            __props__.__dict__["ical_timezone"] = ical_timezone
            __props__.__dict__["ical_url"] = ical_url
            __props__.__dict__["name"] = name
        super(Holiday, __self__).__init__(
            'grafana:machineLearning/holiday:Holiday',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_periods: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HolidayCustomPeriodArgs', 'HolidayCustomPeriodArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ical_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            ical_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Holiday':
        """
        Get an existing Holiday resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HolidayCustomPeriodArgs', 'HolidayCustomPeriodArgsDict']]]] custom_periods: A list of custom periods for the holiday.
        :param pulumi.Input[_builtins.str] description: A description of the holiday.
        :param pulumi.Input[_builtins.str] ical_timezone: The timezone to use for events in the iCal file pointed to by ical_url.
        :param pulumi.Input[_builtins.str] ical_url: A URL to an iCal file containing all occurrences of the holiday.
        :param pulumi.Input[_builtins.str] name: The name of the holiday.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HolidayState.__new__(_HolidayState)

        __props__.__dict__["custom_periods"] = custom_periods
        __props__.__dict__["description"] = description
        __props__.__dict__["ical_timezone"] = ical_timezone
        __props__.__dict__["ical_url"] = ical_url
        __props__.__dict__["name"] = name
        return Holiday(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customPeriods")
    def custom_periods(self) -> pulumi.Output[Optional[Sequence['outputs.HolidayCustomPeriod']]]:
        """
        A list of custom periods for the holiday.
        """
        return pulumi.get(self, "custom_periods")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the holiday.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="icalTimezone")
    def ical_timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The timezone to use for events in the iCal file pointed to by ical_url.
        """
        return pulumi.get(self, "ical_timezone")

    @_builtins.property
    @pulumi.getter(name="icalUrl")
    def ical_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A URL to an iCal file containing all occurrences of the holiday.
        """
        return pulumi.get(self, "ical_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the holiday.
        """
        return pulumi.get(self, "name")

