# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OutlierDetectorArgs', 'OutlierDetector']

@pulumi.input_type
class OutlierDetectorArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['OutlierDetectorAlgorithmArgs'],
                 datasource_type: pulumi.Input[_builtins.str],
                 datasource_uid: pulumi.Input[_builtins.str],
                 metric: pulumi.Input[_builtins.str],
                 query_params: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OutlierDetector resource.
        :param pulumi.Input['OutlierDetectorAlgorithmArgs'] algorithm: The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        :param pulumi.Input[_builtins.str] datasource_type: The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        :param pulumi.Input[_builtins.str] datasource_uid: The uid of the datasource to query.
        :param pulumi.Input[_builtins.str] metric: The metric used to query the outlier detector results.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] query_params: An object representing the query params to query Grafana with.
        :param pulumi.Input[_builtins.str] description: A description of the outlier detector.
        :param pulumi.Input[_builtins.int] interval: The data interval in seconds to monitor.
        :param pulumi.Input[_builtins.str] name: The name of the outlier detector.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "datasource_type", datasource_type)
        pulumi.set(__self__, "datasource_uid", datasource_uid)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "query_params", query_params)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['OutlierDetectorAlgorithmArgs']:
        """
        The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['OutlierDetectorAlgorithmArgs']):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="datasourceType")
    def datasource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        """
        return pulumi.get(self, "datasource_type")

    @datasource_type.setter
    def datasource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "datasource_type", value)

    @_builtins.property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> pulumi.Input[_builtins.str]:
        """
        The uid of the datasource to query.
        """
        return pulumi.get(self, "datasource_uid")

    @datasource_uid.setter
    def datasource_uid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "datasource_uid", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Input[_builtins.str]:
        """
        The metric used to query the outlier detector results.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        An object representing the query params to query Grafana with.
        """
        return pulumi.get(self, "query_params")

    @query_params.setter
    def query_params(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "query_params", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the outlier detector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The data interval in seconds to monitor.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the outlier detector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OutlierDetectorState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input['OutlierDetectorAlgorithmArgs']] = None,
                 datasource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OutlierDetector resources.
        :param pulumi.Input['OutlierDetectorAlgorithmArgs'] algorithm: The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        :param pulumi.Input[_builtins.str] datasource_type: The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        :param pulumi.Input[_builtins.str] datasource_uid: The uid of the datasource to query.
        :param pulumi.Input[_builtins.str] description: A description of the outlier detector.
        :param pulumi.Input[_builtins.int] interval: The data interval in seconds to monitor.
        :param pulumi.Input[_builtins.str] metric: The metric used to query the outlier detector results.
        :param pulumi.Input[_builtins.str] name: The name of the outlier detector.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] query_params: An object representing the query params to query Grafana with.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if datasource_type is not None:
            pulumi.set(__self__, "datasource_type", datasource_type)
        if datasource_uid is not None:
            pulumi.set(__self__, "datasource_uid", datasource_uid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['OutlierDetectorAlgorithmArgs']]:
        """
        The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['OutlierDetectorAlgorithmArgs']]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="datasourceType")
    def datasource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        """
        return pulumi.get(self, "datasource_type")

    @datasource_type.setter
    def datasource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datasource_type", value)

    @_builtins.property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uid of the datasource to query.
        """
        return pulumi.get(self, "datasource_uid")

    @datasource_uid.setter
    def datasource_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datasource_uid", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the outlier detector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The data interval in seconds to monitor.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metric used to query the outlier detector results.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the outlier detector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An object representing the query params to query Grafana with.
        """
        return pulumi.get(self, "query_params")

    @query_params.setter
    def query_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "query_params", value)


@pulumi.type_token("grafana:machineLearning/outlierDetector:OutlierDetector")
class OutlierDetector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union['OutlierDetectorAlgorithmArgs', 'OutlierDetectorAlgorithmArgsDict']]] = None,
                 datasource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        An outlier detector monitors the results of a query and reports when its values are outside normal bands.

        The normal band is configured by choice of algorithm, its sensitivity and other configuration.

        Visit https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for more details.

        ## Example Usage

        ### DBSCAN Outlier Detector

        This outlier detector uses the DBSCAN algorithm to detect outliers.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        my_dbscan_outlier_detector = grafana.machinelearning.OutlierDetector("my_dbscan_outlier_detector",
            name="My DBSCAN outlier detector",
            description="My DBSCAN Outlier Detector",
            metric="tf_test_dbscan_job",
            datasource_type="prometheus",
            datasource_uid="AbCd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            },
            interval=300,
            algorithm={
                "name": "dbscan",
                "sensitivity": 0.5,
                "config": {
                    "epsilon": 1,
                },
            })
        ```

        ### MAD Outlier Detector

        This outlier detector uses the Median Absolute Deviation (MAD) algorithm to detect outliers.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        my_mad_outlier_detector = grafana.machinelearning.OutlierDetector("my_mad_outlier_detector",
            name="My MAD outlier detector",
            description="My MAD Outlier Detector",
            metric="tf_test_mad_job",
            datasource_type="prometheus",
            datasource_uid="AbCd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            },
            interval=300,
            algorithm={
                "name": "mad",
                "sensitivity": 0.7,
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:machineLearning/outlierDetector:OutlierDetector name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OutlierDetectorAlgorithmArgs', 'OutlierDetectorAlgorithmArgsDict']] algorithm: The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        :param pulumi.Input[_builtins.str] datasource_type: The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        :param pulumi.Input[_builtins.str] datasource_uid: The uid of the datasource to query.
        :param pulumi.Input[_builtins.str] description: A description of the outlier detector.
        :param pulumi.Input[_builtins.int] interval: The data interval in seconds to monitor.
        :param pulumi.Input[_builtins.str] metric: The metric used to query the outlier detector results.
        :param pulumi.Input[_builtins.str] name: The name of the outlier detector.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] query_params: An object representing the query params to query Grafana with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutlierDetectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An outlier detector monitors the results of a query and reports when its values are outside normal bands.

        The normal band is configured by choice of algorithm, its sensitivity and other configuration.

        Visit https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for more details.

        ## Example Usage

        ### DBSCAN Outlier Detector

        This outlier detector uses the DBSCAN algorithm to detect outliers.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        my_dbscan_outlier_detector = grafana.machinelearning.OutlierDetector("my_dbscan_outlier_detector",
            name="My DBSCAN outlier detector",
            description="My DBSCAN Outlier Detector",
            metric="tf_test_dbscan_job",
            datasource_type="prometheus",
            datasource_uid="AbCd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            },
            interval=300,
            algorithm={
                "name": "dbscan",
                "sensitivity": 0.5,
                "config": {
                    "epsilon": 1,
                },
            })
        ```

        ### MAD Outlier Detector

        This outlier detector uses the Median Absolute Deviation (MAD) algorithm to detect outliers.

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        my_mad_outlier_detector = grafana.machinelearning.OutlierDetector("my_mad_outlier_detector",
            name="My MAD outlier detector",
            description="My MAD Outlier Detector",
            metric="tf_test_mad_job",
            datasource_type="prometheus",
            datasource_uid="AbCd12345",
            query_params={
                "expr": "grafanacloud_grafana_instance_active_user_count",
            },
            interval=300,
            algorithm={
                "name": "mad",
                "sensitivity": 0.7,
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:machineLearning/outlierDetector:OutlierDetector name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param OutlierDetectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutlierDetectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[Union['OutlierDetectorAlgorithmArgs', 'OutlierDetectorAlgorithmArgsDict']]] = None,
                 datasource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None,
                 metric: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutlierDetectorArgs.__new__(OutlierDetectorArgs)

            if algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'algorithm'")
            __props__.__dict__["algorithm"] = algorithm
            if datasource_type is None and not opts.urn:
                raise TypeError("Missing required property 'datasource_type'")
            __props__.__dict__["datasource_type"] = datasource_type
            if datasource_uid is None and not opts.urn:
                raise TypeError("Missing required property 'datasource_uid'")
            __props__.__dict__["datasource_uid"] = datasource_uid
            __props__.__dict__["description"] = description
            __props__.__dict__["interval"] = interval
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["name"] = name
            if query_params is None and not opts.urn:
                raise TypeError("Missing required property 'query_params'")
            __props__.__dict__["query_params"] = query_params
        super(OutlierDetector, __self__).__init__(
            'grafana:machineLearning/outlierDetector:OutlierDetector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[Union['OutlierDetectorAlgorithmArgs', 'OutlierDetectorAlgorithmArgsDict']]] = None,
            datasource_type: Optional[pulumi.Input[_builtins.str]] = None,
            datasource_uid: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.int]] = None,
            metric: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'OutlierDetector':
        """
        Get an existing OutlierDetector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OutlierDetectorAlgorithmArgs', 'OutlierDetectorAlgorithmArgsDict']] algorithm: The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        :param pulumi.Input[_builtins.str] datasource_type: The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        :param pulumi.Input[_builtins.str] datasource_uid: The uid of the datasource to query.
        :param pulumi.Input[_builtins.str] description: A description of the outlier detector.
        :param pulumi.Input[_builtins.int] interval: The data interval in seconds to monitor.
        :param pulumi.Input[_builtins.str] metric: The metric used to query the outlier detector results.
        :param pulumi.Input[_builtins.str] name: The name of the outlier detector.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] query_params: An object representing the query params to query Grafana with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutlierDetectorState.__new__(_OutlierDetectorState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["datasource_type"] = datasource_type
        __props__.__dict__["datasource_uid"] = datasource_uid
        __props__.__dict__["description"] = description
        __props__.__dict__["interval"] = interval
        __props__.__dict__["metric"] = metric
        __props__.__dict__["name"] = name
        __props__.__dict__["query_params"] = query_params
        return OutlierDetector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output['outputs.OutlierDetectorAlgorithm']:
        """
        The algorithm to use and its configuration. See https://grafana.com/docs/grafana-cloud/machine-learning/outlier-detection/ for details.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="datasourceType")
    def datasource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of datasource being queried. Currently allowed values are prometheus, grafana-prometheus-datasource, grafana-amazonprometheus-datasource, loki, grafana-loki-datasource, graphite, grafana-graphite-datasource, grafana-datadog-datasource, postgres, grafana-postgresql-datasource, doitintl-bigquery-datasource, grafana-bigquery-datasource, grafana-snowflake-datasource, influxdb, grafana-influxdb-datasource, grafana-splunk-datasource, elasticsearch, grafana-elasticsearch-datasource, and grafana-mongodb-datasource.
        """
        return pulumi.get(self, "datasource_type")

    @_builtins.property
    @pulumi.getter(name="datasourceUid")
    def datasource_uid(self) -> pulumi.Output[_builtins.str]:
        """
        The uid of the datasource to query.
        """
        return pulumi.get(self, "datasource_uid")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the outlier detector.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The data interval in seconds to monitor.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> pulumi.Output[_builtins.str]:
        """
        The metric used to query the outlier detector results.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the outlier detector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        An object representing the query params to query Grafana with.
        """
        return pulumi.get(self, "query_params")

