# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOrganizationUserResult',
    'AwaitableGetOrganizationUserResult',
    'get_organization_user',
    'get_organization_user_output',
]

@pulumi.output_type
class GetOrganizationUserResult:
    """
    A collection of values returned by getOrganizationUser.
    """
    def __init__(__self__, email=None, id=None, login=None, org_id=None, user_id=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if user_id and not isinstance(user_id, int):
            raise TypeError("Expected argument 'user_id' to be a int")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        The email address of the Grafana user. Defaults to ``.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[_builtins.str]:
        """
        The username of the Grafana user. Defaults to ``.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.str]:
        """
        The Organization ID. If not set, the Org ID defined in the provider block will be used.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.int:
        """
        The numerical ID of the Grafana user.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetOrganizationUserResult(GetOrganizationUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationUserResult(
            email=self.email,
            id=self.id,
            login=self.login,
            org_id=self.org_id,
            user_id=self.user_id)


def get_organization_user(email: Optional[_builtins.str] = None,
                          login: Optional[_builtins.str] = None,
                          org_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationUserResult:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/administration/user-management/server-user-management/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/org/#get-all-users-within-the-current-organization-lookup)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.oss.User("test",
        email="test.datasource@example.com",
        name="Testing Datasource",
        login="test-datasource",
        password="my-password")
    from_email = grafana.oss.get_organization_user_output(email=test.email)
    from_login = test.login.apply(lambda login: grafana.oss.get_organization_user_output(login=login))
    ```


    :param _builtins.str email: The email address of the Grafana user. Defaults to ``.
    :param _builtins.str login: The username of the Grafana user. Defaults to ``.
    :param _builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['login'] = login
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:oss/getOrganizationUser:getOrganizationUser', __args__, opts=opts, typ=GetOrganizationUserResult).value

    return AwaitableGetOrganizationUserResult(
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        login=pulumi.get(__ret__, 'login'),
        org_id=pulumi.get(__ret__, 'org_id'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_organization_user_output(email: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 login: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 org_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationUserResult]:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/administration/user-management/server-user-management/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/org/#get-all-users-within-the-current-organization-lookup)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.oss.User("test",
        email="test.datasource@example.com",
        name="Testing Datasource",
        login="test-datasource",
        password="my-password")
    from_email = grafana.oss.get_organization_user_output(email=test.email)
    from_login = test.login.apply(lambda login: grafana.oss.get_organization_user_output(login=login))
    ```


    :param _builtins.str email: The email address of the Grafana user. Defaults to ``.
    :param _builtins.str login: The username of the Grafana user. Defaults to ``.
    :param _builtins.str org_id: The Organization ID. If not set, the Org ID defined in the provider block will be used.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['login'] = login
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:oss/getOrganizationUser:getOrganizationUser', __args__, opts=opts, typ=GetOrganizationUserResult)
    return __ret__.apply(lambda __response__: GetOrganizationUserResult(
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        login=pulumi.get(__response__, 'login'),
        org_id=pulumi.get(__response__, 'org_id'),
        user_id=pulumi.get(__response__, 'user_id')))
