# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, email=None, id=None, is_admin=None, login=None, name=None, user_id=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_admin and not isinstance(is_admin, bool):
            raise TypeError("Expected argument 'is_admin' to be a bool")
        pulumi.set(__self__, "is_admin", is_admin)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if user_id and not isinstance(user_id, int):
            raise TypeError("Expected argument 'user_id' to be a int")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        The email address of the Grafana user. Defaults to ``.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> _builtins.bool:
        """
        Whether the user is an admin.
        """
        return pulumi.get(self, "is_admin")

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[_builtins.str]:
        """
        The username for the Grafana user. Defaults to ``.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The display name for the Grafana user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.int]:
        """
        The numerical ID of the Grafana user. Defaults to `-1`.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            email=self.email,
            id=self.id,
            is_admin=self.is_admin,
            login=self.login,
            name=self.name,
            user_id=self.user_id)


def get_user(email: Optional[_builtins.str] = None,
             login: Optional[_builtins.str] = None,
             user_id: Optional[_builtins.int] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/administration/user-management/server-user-management/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/user/)

    This data source uses Grafana's admin APIs for reading users which
    does not currently work with API Tokens. You must use basic auth.
    This data source is also not compatible with Grafana Cloud, as it does not allow basic auth.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.oss.User("test",
        email="test.datasource@example.com",
        name="Testing Datasource",
        login="test-datasource",
        password="my-password",
        is_admin=True)
    from_id = grafana.oss.get_user_output(user_id=test.user_id)
    from_email = grafana.oss.get_user_output(email=test.email)
    from_login = test.login.apply(lambda login: grafana.oss.get_user_output(login=login))
    ```


    :param _builtins.str email: The email address of the Grafana user. Defaults to ``.
    :param _builtins.str login: The username for the Grafana user. Defaults to ``.
    :param _builtins.int user_id: The numerical ID of the Grafana user. Defaults to `-1`.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:oss/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        is_admin=pulumi.get(__ret__, 'is_admin'),
        login=pulumi.get(__ret__, 'login'),
        name=pulumi.get(__ret__, 'name'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_user_output(email: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    login: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    user_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    * [Official documentation](https://grafana.com/docs/grafana/latest/administration/user-management/server-user-management/)
    * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/user/)

    This data source uses Grafana's admin APIs for reading users which
    does not currently work with API Tokens. You must use basic auth.
    This data source is also not compatible with Grafana Cloud, as it does not allow basic auth.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.oss.User("test",
        email="test.datasource@example.com",
        name="Testing Datasource",
        login="test-datasource",
        password="my-password",
        is_admin=True)
    from_id = grafana.oss.get_user_output(user_id=test.user_id)
    from_email = grafana.oss.get_user_output(email=test.email)
    from_login = test.login.apply(lambda login: grafana.oss.get_user_output(login=login))
    ```


    :param _builtins.str email: The email address of the Grafana user. Defaults to ``.
    :param _builtins.str login: The username for the Grafana user. Defaults to ``.
    :param _builtins.int user_id: The numerical ID of the Grafana user. Defaults to `-1`.
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['login'] = login
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:oss/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        is_admin=pulumi.get(__response__, 'is_admin'),
        login=pulumi.get(__response__, 'login'),
        name=pulumi.get(__response__, 'name'),
        user_id=pulumi.get(__response__, 'user_id')))
