# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CheckAlertsAlertArgs',
    'CheckAlertsAlertArgsDict',
    'CheckSettingsArgs',
    'CheckSettingsArgsDict',
    'CheckSettingsBrowserArgs',
    'CheckSettingsBrowserArgsDict',
    'CheckSettingsDnsArgs',
    'CheckSettingsDnsArgsDict',
    'CheckSettingsDnsValidateAdditionalRrArgs',
    'CheckSettingsDnsValidateAdditionalRrArgsDict',
    'CheckSettingsDnsValidateAnswerRrsArgs',
    'CheckSettingsDnsValidateAnswerRrsArgsDict',
    'CheckSettingsDnsValidateAuthorityRrsArgs',
    'CheckSettingsDnsValidateAuthorityRrsArgsDict',
    'CheckSettingsGrpcArgs',
    'CheckSettingsGrpcArgsDict',
    'CheckSettingsGrpcTlsConfigArgs',
    'CheckSettingsGrpcTlsConfigArgsDict',
    'CheckSettingsHttpArgs',
    'CheckSettingsHttpArgsDict',
    'CheckSettingsHttpBasicAuthArgs',
    'CheckSettingsHttpBasicAuthArgsDict',
    'CheckSettingsHttpFailIfHeaderMatchesRegexpArgs',
    'CheckSettingsHttpFailIfHeaderMatchesRegexpArgsDict',
    'CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs',
    'CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgsDict',
    'CheckSettingsHttpTlsConfigArgs',
    'CheckSettingsHttpTlsConfigArgsDict',
    'CheckSettingsMultihttpArgs',
    'CheckSettingsMultihttpArgsDict',
    'CheckSettingsMultihttpEntryArgs',
    'CheckSettingsMultihttpEntryArgsDict',
    'CheckSettingsMultihttpEntryAssertionArgs',
    'CheckSettingsMultihttpEntryAssertionArgsDict',
    'CheckSettingsMultihttpEntryRequestArgs',
    'CheckSettingsMultihttpEntryRequestArgsDict',
    'CheckSettingsMultihttpEntryRequestBodyArgs',
    'CheckSettingsMultihttpEntryRequestBodyArgsDict',
    'CheckSettingsMultihttpEntryRequestHeaderArgs',
    'CheckSettingsMultihttpEntryRequestHeaderArgsDict',
    'CheckSettingsMultihttpEntryRequestQueryFieldArgs',
    'CheckSettingsMultihttpEntryRequestQueryFieldArgsDict',
    'CheckSettingsMultihttpEntryVariableArgs',
    'CheckSettingsMultihttpEntryVariableArgsDict',
    'CheckSettingsPingArgs',
    'CheckSettingsPingArgsDict',
    'CheckSettingsScriptedArgs',
    'CheckSettingsScriptedArgsDict',
    'CheckSettingsTcpArgs',
    'CheckSettingsTcpArgsDict',
    'CheckSettingsTcpQueryResponseArgs',
    'CheckSettingsTcpQueryResponseArgsDict',
    'CheckSettingsTcpTlsConfigArgs',
    'CheckSettingsTcpTlsConfigArgsDict',
    'CheckSettingsTracerouteArgs',
    'CheckSettingsTracerouteArgsDict',
]

MYPY = False

if not MYPY:
    class CheckAlertsAlertArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the alert. Required.
        """
        threshold: pulumi.Input[_builtins.float]
        """
        Threshold value for the alert.
        """
        period: NotRequired[pulumi.Input[_builtins.str]]
        """
        Period for the alert. Required and must be one of: `5m`, `10m`, `15m`, `20m`, `30m`, `1h`.
        """
        runbook_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        URL to runbook documentation for this alert.
        """
elif False:
    CheckAlertsAlertArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckAlertsAlertArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 threshold: pulumi.Input[_builtins.float],
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Name of the alert. Required.
        :param pulumi.Input[_builtins.float] threshold: Threshold value for the alert.
        :param pulumi.Input[_builtins.str] period: Period for the alert. Required and must be one of: `5m`, `10m`, `15m`, `20m`, `30m`, `1h`.
        :param pulumi.Input[_builtins.str] runbook_url: URL to runbook documentation for this alert.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "threshold", threshold)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the alert. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[_builtins.float]:
        """
        Threshold value for the alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Period for the alert. Required and must be one of: `5m`, `10m`, `15m`, `20m`, `30m`, `1h`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL to runbook documentation for this alert.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_url", value)


if not MYPY:
    class CheckSettingsArgsDict(TypedDict):
        browser: NotRequired[pulumi.Input['CheckSettingsBrowserArgsDict']]
        """
        Settings for browser check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6-browser/.
        """
        dns: NotRequired[pulumi.Input['CheckSettingsDnsArgsDict']]
        """
        Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        """
        grpc: NotRequired[pulumi.Input['CheckSettingsGrpcArgsDict']]
        """
        Settings for gRPC Health check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        http: NotRequired[pulumi.Input['CheckSettingsHttpArgsDict']]
        """
        Settings for HTTP check. The target must be a URL (http or https).
        """
        multihttp: NotRequired[pulumi.Input['CheckSettingsMultihttpArgsDict']]
        """
        Settings for MultiHTTP check. The target must be a URL (http or https)
        """
        ping: NotRequired[pulumi.Input['CheckSettingsPingArgsDict']]
        """
        Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        """
        scripted: NotRequired[pulumi.Input['CheckSettingsScriptedArgsDict']]
        """
        Settings for scripted check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6/.
        """
        tcp: NotRequired[pulumi.Input['CheckSettingsTcpArgsDict']]
        """
        Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        traceroute: NotRequired[pulumi.Input['CheckSettingsTracerouteArgsDict']]
        """
        Settings for traceroute check. The target must be a valid hostname or IP address
        """
elif False:
    CheckSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsArgs:
    def __init__(__self__, *,
                 browser: Optional[pulumi.Input['CheckSettingsBrowserArgs']] = None,
                 dns: Optional[pulumi.Input['CheckSettingsDnsArgs']] = None,
                 grpc: Optional[pulumi.Input['CheckSettingsGrpcArgs']] = None,
                 http: Optional[pulumi.Input['CheckSettingsHttpArgs']] = None,
                 multihttp: Optional[pulumi.Input['CheckSettingsMultihttpArgs']] = None,
                 ping: Optional[pulumi.Input['CheckSettingsPingArgs']] = None,
                 scripted: Optional[pulumi.Input['CheckSettingsScriptedArgs']] = None,
                 tcp: Optional[pulumi.Input['CheckSettingsTcpArgs']] = None,
                 traceroute: Optional[pulumi.Input['CheckSettingsTracerouteArgs']] = None):
        """
        :param pulumi.Input['CheckSettingsBrowserArgs'] browser: Settings for browser check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6-browser/.
        :param pulumi.Input['CheckSettingsDnsArgs'] dns: Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        :param pulumi.Input['CheckSettingsGrpcArgs'] grpc: Settings for gRPC Health check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        :param pulumi.Input['CheckSettingsHttpArgs'] http: Settings for HTTP check. The target must be a URL (http or https).
        :param pulumi.Input['CheckSettingsMultihttpArgs'] multihttp: Settings for MultiHTTP check. The target must be a URL (http or https)
        :param pulumi.Input['CheckSettingsPingArgs'] ping: Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        :param pulumi.Input['CheckSettingsScriptedArgs'] scripted: Settings for scripted check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6/.
        :param pulumi.Input['CheckSettingsTcpArgs'] tcp: Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        :param pulumi.Input['CheckSettingsTracerouteArgs'] traceroute: Settings for traceroute check. The target must be a valid hostname or IP address
        """
        if browser is not None:
            pulumi.set(__self__, "browser", browser)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if multihttp is not None:
            pulumi.set(__self__, "multihttp", multihttp)
        if ping is not None:
            pulumi.set(__self__, "ping", ping)
        if scripted is not None:
            pulumi.set(__self__, "scripted", scripted)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if traceroute is not None:
            pulumi.set(__self__, "traceroute", traceroute)

    @_builtins.property
    @pulumi.getter
    def browser(self) -> Optional[pulumi.Input['CheckSettingsBrowserArgs']]:
        """
        Settings for browser check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6-browser/.
        """
        return pulumi.get(self, "browser")

    @browser.setter
    def browser(self, value: Optional[pulumi.Input['CheckSettingsBrowserArgs']]):
        pulumi.set(self, "browser", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['CheckSettingsDnsArgs']]:
        """
        Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['CheckSettingsDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional[pulumi.Input['CheckSettingsGrpcArgs']]:
        """
        Settings for gRPC Health check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        return pulumi.get(self, "grpc")

    @grpc.setter
    def grpc(self, value: Optional[pulumi.Input['CheckSettingsGrpcArgs']]):
        pulumi.set(self, "grpc", value)

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['CheckSettingsHttpArgs']]:
        """
        Settings for HTTP check. The target must be a URL (http or https).
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['CheckSettingsHttpArgs']]):
        pulumi.set(self, "http", value)

    @_builtins.property
    @pulumi.getter
    def multihttp(self) -> Optional[pulumi.Input['CheckSettingsMultihttpArgs']]:
        """
        Settings for MultiHTTP check. The target must be a URL (http or https)
        """
        return pulumi.get(self, "multihttp")

    @multihttp.setter
    def multihttp(self, value: Optional[pulumi.Input['CheckSettingsMultihttpArgs']]):
        pulumi.set(self, "multihttp", value)

    @_builtins.property
    @pulumi.getter
    def ping(self) -> Optional[pulumi.Input['CheckSettingsPingArgs']]:
        """
        Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        """
        return pulumi.get(self, "ping")

    @ping.setter
    def ping(self, value: Optional[pulumi.Input['CheckSettingsPingArgs']]):
        pulumi.set(self, "ping", value)

    @_builtins.property
    @pulumi.getter
    def scripted(self) -> Optional[pulumi.Input['CheckSettingsScriptedArgs']]:
        """
        Settings for scripted check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6/.
        """
        return pulumi.get(self, "scripted")

    @scripted.setter
    def scripted(self, value: Optional[pulumi.Input['CheckSettingsScriptedArgs']]):
        pulumi.set(self, "scripted", value)

    @_builtins.property
    @pulumi.getter
    def tcp(self) -> Optional[pulumi.Input['CheckSettingsTcpArgs']]:
        """
        Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        return pulumi.get(self, "tcp")

    @tcp.setter
    def tcp(self, value: Optional[pulumi.Input['CheckSettingsTcpArgs']]):
        pulumi.set(self, "tcp", value)

    @_builtins.property
    @pulumi.getter
    def traceroute(self) -> Optional[pulumi.Input['CheckSettingsTracerouteArgs']]:
        """
        Settings for traceroute check. The target must be a valid hostname or IP address
        """
        return pulumi.get(self, "traceroute")

    @traceroute.setter
    def traceroute(self, value: Optional[pulumi.Input['CheckSettingsTracerouteArgs']]):
        pulumi.set(self, "traceroute", value)


if not MYPY:
    class CheckSettingsBrowserArgsDict(TypedDict):
        script: pulumi.Input[_builtins.str]
elif False:
    CheckSettingsBrowserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsBrowserArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "script", script)

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script", value)


if not MYPY:
    class CheckSettingsDnsArgsDict(TypedDict):
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port to target. Defaults to `53`.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        `TCP` or `UDP`. Defaults to `UDP`.
        """
        record_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        One of `ANY`, `A`, `AAAA`, `CNAME`, `MX`, `NS`, `PTR`, `SOA`, `SRV`, `TXT`. Defaults to `A`.
        """
        server: NotRequired[pulumi.Input[_builtins.str]]
        """
        DNS server address to target. Defaults to `8.8.8.8`.
        """
        source_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        Source IP address.
        """
        valid_r_codes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of valid response codes. Options include `NOERROR`, `BADALG`, `BADMODE`, `BADKEY`, `BADCOOKIE`, `BADNAME`, `BADSIG`, `BADTIME`, `BADTRUNC`, `BADVERS`, `FORMERR`, `NOTIMP`, `NOTAUTH`, `NOTZONE`, `NXDOMAIN`, `NXRRSET`, `REFUSED`, `SERVFAIL`, `YXDOMAIN`, `YXRRSET`.
        """
        validate_additional_rrs: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsDnsValidateAdditionalRrArgsDict']]]]
        """
        Validate additional matches.
        """
        validate_answer_rrs: NotRequired[pulumi.Input['CheckSettingsDnsValidateAnswerRrsArgsDict']]
        """
        Validate response answer.
        """
        validate_authority_rrs: NotRequired[pulumi.Input['CheckSettingsDnsValidateAuthorityRrsArgsDict']]
        """
        Validate response authority.
        """
elif False:
    CheckSettingsDnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsDnsArgs:
    def __init__(__self__, *,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 record_type: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 valid_r_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validate_additional_rrs: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsDnsValidateAdditionalRrArgs']]]] = None,
                 validate_answer_rrs: Optional[pulumi.Input['CheckSettingsDnsValidateAnswerRrsArgs']] = None,
                 validate_authority_rrs: Optional[pulumi.Input['CheckSettingsDnsValidateAuthorityRrsArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param pulumi.Input[_builtins.int] port: Port to target. Defaults to `53`.
        :param pulumi.Input[_builtins.str] protocol: `TCP` or `UDP`. Defaults to `UDP`.
        :param pulumi.Input[_builtins.str] record_type: One of `ANY`, `A`, `AAAA`, `CNAME`, `MX`, `NS`, `PTR`, `SOA`, `SRV`, `TXT`. Defaults to `A`.
        :param pulumi.Input[_builtins.str] server: DNS server address to target. Defaults to `8.8.8.8`.
        :param pulumi.Input[_builtins.str] source_ip_address: Source IP address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valid_r_codes: List of valid response codes. Options include `NOERROR`, `BADALG`, `BADMODE`, `BADKEY`, `BADCOOKIE`, `BADNAME`, `BADSIG`, `BADTIME`, `BADTRUNC`, `BADVERS`, `FORMERR`, `NOTIMP`, `NOTAUTH`, `NOTZONE`, `NXDOMAIN`, `NXRRSET`, `REFUSED`, `SERVFAIL`, `YXDOMAIN`, `YXRRSET`.
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsDnsValidateAdditionalRrArgs']]] validate_additional_rrs: Validate additional matches.
        :param pulumi.Input['CheckSettingsDnsValidateAnswerRrsArgs'] validate_answer_rrs: Validate response answer.
        :param pulumi.Input['CheckSettingsDnsValidateAuthorityRrsArgs'] validate_authority_rrs: Validate response authority.
        """
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if valid_r_codes is not None:
            pulumi.set(__self__, "valid_r_codes", valid_r_codes)
        if validate_additional_rrs is not None:
            pulumi.set(__self__, "validate_additional_rrs", validate_additional_rrs)
        if validate_answer_rrs is not None:
            pulumi.set(__self__, "validate_answer_rrs", validate_answer_rrs)
        if validate_authority_rrs is not None:
            pulumi.set(__self__, "validate_authority_rrs", validate_authority_rrs)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port to target. Defaults to `53`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `TCP` or `UDP`. Defaults to `UDP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One of `ANY`, `A`, `AAAA`, `CNAME`, `MX`, `NS`, `PTR`, `SOA`, `SRV`, `TXT`. Defaults to `A`.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_type", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS server address to target. Defaults to `8.8.8.8`.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="validRCodes")
    def valid_r_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of valid response codes. Options include `NOERROR`, `BADALG`, `BADMODE`, `BADKEY`, `BADCOOKIE`, `BADNAME`, `BADSIG`, `BADTIME`, `BADTRUNC`, `BADVERS`, `FORMERR`, `NOTIMP`, `NOTAUTH`, `NOTZONE`, `NXDOMAIN`, `NXRRSET`, `REFUSED`, `SERVFAIL`, `YXDOMAIN`, `YXRRSET`.
        """
        return pulumi.get(self, "valid_r_codes")

    @valid_r_codes.setter
    def valid_r_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valid_r_codes", value)

    @_builtins.property
    @pulumi.getter(name="validateAdditionalRrs")
    def validate_additional_rrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsDnsValidateAdditionalRrArgs']]]]:
        """
        Validate additional matches.
        """
        return pulumi.get(self, "validate_additional_rrs")

    @validate_additional_rrs.setter
    def validate_additional_rrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsDnsValidateAdditionalRrArgs']]]]):
        pulumi.set(self, "validate_additional_rrs", value)

    @_builtins.property
    @pulumi.getter(name="validateAnswerRrs")
    def validate_answer_rrs(self) -> Optional[pulumi.Input['CheckSettingsDnsValidateAnswerRrsArgs']]:
        """
        Validate response answer.
        """
        return pulumi.get(self, "validate_answer_rrs")

    @validate_answer_rrs.setter
    def validate_answer_rrs(self, value: Optional[pulumi.Input['CheckSettingsDnsValidateAnswerRrsArgs']]):
        pulumi.set(self, "validate_answer_rrs", value)

    @_builtins.property
    @pulumi.getter(name="validateAuthorityRrs")
    def validate_authority_rrs(self) -> Optional[pulumi.Input['CheckSettingsDnsValidateAuthorityRrsArgs']]:
        """
        Validate response authority.
        """
        return pulumi.get(self, "validate_authority_rrs")

    @validate_authority_rrs.setter
    def validate_authority_rrs(self, value: Optional[pulumi.Input['CheckSettingsDnsValidateAuthorityRrsArgs']]):
        pulumi.set(self, "validate_authority_rrs", value)


if not MYPY:
    class CheckSettingsDnsValidateAdditionalRrArgsDict(TypedDict):
        fail_if_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Fail if value matches regex.
        """
        fail_if_not_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Fail if value does not match regex.
        """
elif False:
    CheckSettingsDnsValidateAdditionalRrArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsDnsValidateAdditionalRrArgs:
    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fail_if_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_matches_regexps: Fail if value matches regex.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_not_matches_regexps: Fail if value does not match regex.
        """
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @_builtins.property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fail if value matches regex.
        """
        return pulumi.get(self, "fail_if_matches_regexps")

    @fail_if_matches_regexps.setter
    def fail_if_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fail if value does not match regex.
        """
        return pulumi.get(self, "fail_if_not_matches_regexps")

    @fail_if_not_matches_regexps.setter
    def fail_if_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_not_matches_regexps", value)


if not MYPY:
    class CheckSettingsDnsValidateAnswerRrsArgsDict(TypedDict):
        fail_if_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Fail if value matches regex.
        """
        fail_if_not_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Fail if value does not match regex.
        """
elif False:
    CheckSettingsDnsValidateAnswerRrsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsDnsValidateAnswerRrsArgs:
    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fail_if_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_matches_regexps: Fail if value matches regex.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_not_matches_regexps: Fail if value does not match regex.
        """
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @_builtins.property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fail if value matches regex.
        """
        return pulumi.get(self, "fail_if_matches_regexps")

    @fail_if_matches_regexps.setter
    def fail_if_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fail if value does not match regex.
        """
        return pulumi.get(self, "fail_if_not_matches_regexps")

    @fail_if_not_matches_regexps.setter
    def fail_if_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_not_matches_regexps", value)


if not MYPY:
    class CheckSettingsDnsValidateAuthorityRrsArgsDict(TypedDict):
        fail_if_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Fail if value matches regex.
        """
        fail_if_not_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Fail if value does not match regex.
        """
elif False:
    CheckSettingsDnsValidateAuthorityRrsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsDnsValidateAuthorityRrsArgs:
    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fail_if_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_matches_regexps: Fail if value matches regex.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_not_matches_regexps: Fail if value does not match regex.
        """
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @_builtins.property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fail if value matches regex.
        """
        return pulumi.get(self, "fail_if_matches_regexps")

    @fail_if_matches_regexps.setter
    def fail_if_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fail if value does not match regex.
        """
        return pulumi.get(self, "fail_if_not_matches_regexps")

    @fail_if_not_matches_regexps.setter
    def fail_if_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_not_matches_regexps", value)


if not MYPY:
    class CheckSettingsGrpcArgsDict(TypedDict):
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        service: NotRequired[pulumi.Input[_builtins.str]]
        """
        gRPC service.
        """
        tls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        """
        tls_config: NotRequired[pulumi.Input['CheckSettingsGrpcTlsConfigArgsDict']]
        """
        TLS config.
        """
elif False:
    CheckSettingsGrpcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsGrpcArgs:
    def __init__(__self__, *,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_config: Optional[pulumi.Input['CheckSettingsGrpcTlsConfigArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param pulumi.Input[_builtins.str] service: gRPC service.
        :param pulumi.Input[_builtins.bool] tls: Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        :param pulumi.Input['CheckSettingsGrpcTlsConfigArgs'] tls_config: TLS config.
        """
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        gRPC service.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['CheckSettingsGrpcTlsConfigArgs']]:
        """
        TLS config.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['CheckSettingsGrpcTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


if not MYPY:
    class CheckSettingsGrpcTlsConfigArgsDict(TypedDict):
        ca_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        CA certificate in PEM format.
        """
        client_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        Client certificate in PEM format.
        """
        client_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Client key in PEM format.
        """
        insecure_skip_verify: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Disable target certificate validation. Defaults to `false`.
        """
        server_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Used to verify the hostname for the targets.
        """
elif False:
    CheckSettingsGrpcTlsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsGrpcTlsConfigArgs:
    def __init__(__self__, *,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate in PEM format.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate in PEM format.
        :param pulumi.Input[_builtins.str] client_key: Client key in PEM format.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Disable target certificate validation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] server_name: Used to verify the hostname for the targets.
        """
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate in PEM format.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate in PEM format.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client key in PEM format.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable target certificate validation. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to verify the hostname for the targets.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)


if not MYPY:
    class CheckSettingsHttpArgsDict(TypedDict):
        basic_auth: NotRequired[pulumi.Input['CheckSettingsHttpBasicAuthArgsDict']]
        """
        Basic auth settings.
        """
        bearer_token: NotRequired[pulumi.Input[_builtins.str]]
        """
        Token for use with bearer authorization header.
        """
        body: NotRequired[pulumi.Input[_builtins.str]]
        """
        The body of the HTTP request used in probe.
        """
        cache_busting_query_param_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the query parameter used to prevent the server from using a cached response. Each probe will assign a random value to this parameter each time a request is made.
        """
        compression: NotRequired[pulumi.Input[_builtins.str]]
        """
        Check fails if the response body is not compressed using this compression algorithm. One of `none`, `identity`, `br`, `gzip`, `deflate`.
        """
        fail_if_body_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of regexes. If any match the response body, the check will fail.
        """
        fail_if_body_not_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of regexes. If any do not match the response body, the check will fail.
        """
        fail_if_header_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderMatchesRegexpArgsDict']]]]
        """
        Check fails if headers match.
        """
        fail_if_header_not_matches_regexps: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgsDict']]]]
        """
        Check fails if headers do not match.
        """
        fail_if_not_ssl: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Fail if SSL is not present. Defaults to `false`.
        """
        fail_if_ssl: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Fail if SSL is present. Defaults to `false`.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The HTTP headers set for the probe.
        """
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        method: NotRequired[pulumi.Input[_builtins.str]]
        """
        Request method. One of `GET`, `CONNECT`, `DELETE`, `HEAD`, `OPTIONS`, `POST`, `PUT`, `TRACE` Defaults to `GET`.
        """
        no_follow_redirects: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Do not follow redirects. Defaults to `false`.
        """
        proxy_connect_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The HTTP headers sent to the proxy URL
        """
        proxy_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        Proxy URL.
        """
        tls_config: NotRequired[pulumi.Input['CheckSettingsHttpTlsConfigArgsDict']]
        """
        TLS config.
        """
        valid_http_versions: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of valid HTTP versions. Options include `HTTP/1.0`, `HTTP/1.1`, `HTTP/2.0`
        """
        valid_status_codes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        Accepted status codes. If unset, defaults to 2xx.
        """
elif False:
    CheckSettingsHttpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsHttpArgs:
    def __init__(__self__, *,
                 basic_auth: Optional[pulumi.Input['CheckSettingsHttpBasicAuthArgs']] = None,
                 bearer_token: Optional[pulumi.Input[_builtins.str]] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_busting_query_param_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compression: Optional[pulumi.Input[_builtins.str]] = None,
                 fail_if_body_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fail_if_body_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fail_if_header_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]]] = None,
                 fail_if_header_not_matches_regexps: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]]] = None,
                 fail_if_not_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 fail_if_ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 no_follow_redirects: Optional[pulumi.Input[_builtins.bool]] = None,
                 proxy_connect_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 proxy_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_config: Optional[pulumi.Input['CheckSettingsHttpTlsConfigArgs']] = None,
                 valid_http_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 valid_status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None):
        """
        :param pulumi.Input['CheckSettingsHttpBasicAuthArgs'] basic_auth: Basic auth settings.
        :param pulumi.Input[_builtins.str] bearer_token: Token for use with bearer authorization header.
        :param pulumi.Input[_builtins.str] body: The body of the HTTP request used in probe.
        :param pulumi.Input[_builtins.str] cache_busting_query_param_name: The name of the query parameter used to prevent the server from using a cached response. Each probe will assign a random value to this parameter each time a request is made.
        :param pulumi.Input[_builtins.str] compression: Check fails if the response body is not compressed using this compression algorithm. One of `none`, `identity`, `br`, `gzip`, `deflate`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_body_matches_regexps: List of regexes. If any match the response body, the check will fail.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_if_body_not_matches_regexps: List of regexes. If any do not match the response body, the check will fail.
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]] fail_if_header_matches_regexps: Check fails if headers match.
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]] fail_if_header_not_matches_regexps: Check fails if headers do not match.
        :param pulumi.Input[_builtins.bool] fail_if_not_ssl: Fail if SSL is not present. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] fail_if_ssl: Fail if SSL is present. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] headers: The HTTP headers set for the probe.
        :param pulumi.Input[_builtins.str] ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param pulumi.Input[_builtins.str] method: Request method. One of `GET`, `CONNECT`, `DELETE`, `HEAD`, `OPTIONS`, `POST`, `PUT`, `TRACE` Defaults to `GET`.
        :param pulumi.Input[_builtins.bool] no_follow_redirects: Do not follow redirects. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxy_connect_headers: The HTTP headers sent to the proxy URL
        :param pulumi.Input[_builtins.str] proxy_url: Proxy URL.
        :param pulumi.Input['CheckSettingsHttpTlsConfigArgs'] tls_config: TLS config.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] valid_http_versions: List of valid HTTP versions. Options include `HTTP/1.0`, `HTTP/1.1`, `HTTP/2.0`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] valid_status_codes: Accepted status codes. If unset, defaults to 2xx.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cache_busting_query_param_name is not None:
            pulumi.set(__self__, "cache_busting_query_param_name", cache_busting_query_param_name)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if fail_if_body_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_body_matches_regexps", fail_if_body_matches_regexps)
        if fail_if_body_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_body_not_matches_regexps", fail_if_body_not_matches_regexps)
        if fail_if_header_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_header_matches_regexps", fail_if_header_matches_regexps)
        if fail_if_header_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_header_not_matches_regexps", fail_if_header_not_matches_regexps)
        if fail_if_not_ssl is not None:
            pulumi.set(__self__, "fail_if_not_ssl", fail_if_not_ssl)
        if fail_if_ssl is not None:
            pulumi.set(__self__, "fail_if_ssl", fail_if_ssl)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if no_follow_redirects is not None:
            pulumi.set(__self__, "no_follow_redirects", no_follow_redirects)
        if proxy_connect_headers is not None:
            pulumi.set(__self__, "proxy_connect_headers", proxy_connect_headers)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if valid_http_versions is not None:
            pulumi.set(__self__, "valid_http_versions", valid_http_versions)
        if valid_status_codes is not None:
            pulumi.set(__self__, "valid_status_codes", valid_status_codes)

    @_builtins.property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[pulumi.Input['CheckSettingsHttpBasicAuthArgs']]:
        """
        Basic auth settings.
        """
        return pulumi.get(self, "basic_auth")

    @basic_auth.setter
    def basic_auth(self, value: Optional[pulumi.Input['CheckSettingsHttpBasicAuthArgs']]):
        pulumi.set(self, "basic_auth", value)

    @_builtins.property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token for use with bearer authorization header.
        """
        return pulumi.get(self, "bearer_token")

    @bearer_token.setter
    def bearer_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bearer_token", value)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The body of the HTTP request used in probe.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="cacheBustingQueryParamName")
    def cache_busting_query_param_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the query parameter used to prevent the server from using a cached response. Each probe will assign a random value to this parameter each time a request is made.
        """
        return pulumi.get(self, "cache_busting_query_param_name")

    @cache_busting_query_param_name.setter
    def cache_busting_query_param_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_busting_query_param_name", value)

    @_builtins.property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Check fails if the response body is not compressed using this compression algorithm. One of `none`, `identity`, `br`, `gzip`, `deflate`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression", value)

    @_builtins.property
    @pulumi.getter(name="failIfBodyMatchesRegexps")
    def fail_if_body_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of regexes. If any match the response body, the check will fail.
        """
        return pulumi.get(self, "fail_if_body_matches_regexps")

    @fail_if_body_matches_regexps.setter
    def fail_if_body_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_body_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfBodyNotMatchesRegexps")
    def fail_if_body_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of regexes. If any do not match the response body, the check will fail.
        """
        return pulumi.get(self, "fail_if_body_not_matches_regexps")

    @fail_if_body_not_matches_regexps.setter
    def fail_if_body_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fail_if_body_not_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfHeaderMatchesRegexps")
    def fail_if_header_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]]]:
        """
        Check fails if headers match.
        """
        return pulumi.get(self, "fail_if_header_matches_regexps")

    @fail_if_header_matches_regexps.setter
    def fail_if_header_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderMatchesRegexpArgs']]]]):
        pulumi.set(self, "fail_if_header_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfHeaderNotMatchesRegexps")
    def fail_if_header_not_matches_regexps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]]]:
        """
        Check fails if headers do not match.
        """
        return pulumi.get(self, "fail_if_header_not_matches_regexps")

    @fail_if_header_not_matches_regexps.setter
    def fail_if_header_not_matches_regexps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs']]]]):
        pulumi.set(self, "fail_if_header_not_matches_regexps", value)

    @_builtins.property
    @pulumi.getter(name="failIfNotSsl")
    def fail_if_not_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Fail if SSL is not present. Defaults to `false`.
        """
        return pulumi.get(self, "fail_if_not_ssl")

    @fail_if_not_ssl.setter
    def fail_if_not_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fail_if_not_ssl", value)

    @_builtins.property
    @pulumi.getter(name="failIfSsl")
    def fail_if_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Fail if SSL is present. Defaults to `false`.
        """
        return pulumi.get(self, "fail_if_ssl")

    @fail_if_ssl.setter
    def fail_if_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fail_if_ssl", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The HTTP headers set for the probe.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request method. One of `GET`, `CONNECT`, `DELETE`, `HEAD`, `OPTIONS`, `POST`, `PUT`, `TRACE` Defaults to `GET`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter(name="noFollowRedirects")
    def no_follow_redirects(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not follow redirects. Defaults to `false`.
        """
        return pulumi.get(self, "no_follow_redirects")

    @no_follow_redirects.setter
    def no_follow_redirects(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_follow_redirects", value)

    @_builtins.property
    @pulumi.getter(name="proxyConnectHeaders")
    def proxy_connect_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The HTTP headers sent to the proxy URL
        """
        return pulumi.get(self, "proxy_connect_headers")

    @proxy_connect_headers.setter
    def proxy_connect_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "proxy_connect_headers", value)

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy URL.
        """
        return pulumi.get(self, "proxy_url")

    @proxy_url.setter
    def proxy_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_url", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['CheckSettingsHttpTlsConfigArgs']]:
        """
        TLS config.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['CheckSettingsHttpTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @_builtins.property
    @pulumi.getter(name="validHttpVersions")
    def valid_http_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of valid HTTP versions. Options include `HTTP/1.0`, `HTTP/1.1`, `HTTP/2.0`
        """
        return pulumi.get(self, "valid_http_versions")

    @valid_http_versions.setter
    def valid_http_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "valid_http_versions", value)

    @_builtins.property
    @pulumi.getter(name="validStatusCodes")
    def valid_status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Accepted status codes. If unset, defaults to 2xx.
        """
        return pulumi.get(self, "valid_status_codes")

    @valid_status_codes.setter
    def valid_status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "valid_status_codes", value)


if not MYPY:
    class CheckSettingsHttpBasicAuthArgsDict(TypedDict):
        password: pulumi.Input[_builtins.str]
        """
        Basic auth password.
        """
        username: pulumi.Input[_builtins.str]
        """
        Basic auth username.
        """
elif False:
    CheckSettingsHttpBasicAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsHttpBasicAuthArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] password: Basic auth password.
        :param pulumi.Input[_builtins.str] username: Basic auth username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Basic auth password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Basic auth username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class CheckSettingsHttpFailIfHeaderMatchesRegexpArgsDict(TypedDict):
        header: pulumi.Input[_builtins.str]
        """
        Header name.
        """
        regexp: pulumi.Input[_builtins.str]
        """
        Regex that header value should match.
        """
        allow_missing: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow header to be missing from responses. Defaults to `false`.
        """
elif False:
    CheckSettingsHttpFailIfHeaderMatchesRegexpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsHttpFailIfHeaderMatchesRegexpArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[_builtins.str],
                 regexp: pulumi.Input[_builtins.str],
                 allow_missing: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] header: Header name.
        :param pulumi.Input[_builtins.str] regexp: Regex that header value should match.
        :param pulumi.Input[_builtins.bool] allow_missing: Allow header to be missing from responses. Defaults to `false`.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "regexp", regexp)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)

    @_builtins.property
    @pulumi.getter
    def header(self) -> pulumi.Input[_builtins.str]:
        """
        Header name.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "header", value)

    @_builtins.property
    @pulumi.getter
    def regexp(self) -> pulumi.Input[_builtins.str]:
        """
        Regex that header value should match.
        """
        return pulumi.get(self, "regexp")

    @regexp.setter
    def regexp(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "regexp", value)

    @_builtins.property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow header to be missing from responses. Defaults to `false`.
        """
        return pulumi.get(self, "allow_missing")

    @allow_missing.setter
    def allow_missing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_missing", value)


if not MYPY:
    class CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgsDict(TypedDict):
        header: pulumi.Input[_builtins.str]
        """
        Header name.
        """
        regexp: pulumi.Input[_builtins.str]
        """
        Regex that header value should match.
        """
        allow_missing: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Allow header to be missing from responses. Defaults to `false`.
        """
elif False:
    CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs:
    def __init__(__self__, *,
                 header: pulumi.Input[_builtins.str],
                 regexp: pulumi.Input[_builtins.str],
                 allow_missing: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] header: Header name.
        :param pulumi.Input[_builtins.str] regexp: Regex that header value should match.
        :param pulumi.Input[_builtins.bool] allow_missing: Allow header to be missing from responses. Defaults to `false`.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "regexp", regexp)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)

    @_builtins.property
    @pulumi.getter
    def header(self) -> pulumi.Input[_builtins.str]:
        """
        Header name.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "header", value)

    @_builtins.property
    @pulumi.getter
    def regexp(self) -> pulumi.Input[_builtins.str]:
        """
        Regex that header value should match.
        """
        return pulumi.get(self, "regexp")

    @regexp.setter
    def regexp(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "regexp", value)

    @_builtins.property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow header to be missing from responses. Defaults to `false`.
        """
        return pulumi.get(self, "allow_missing")

    @allow_missing.setter
    def allow_missing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_missing", value)


if not MYPY:
    class CheckSettingsHttpTlsConfigArgsDict(TypedDict):
        ca_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        CA certificate in PEM format.
        """
        client_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        Client certificate in PEM format.
        """
        client_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Client key in PEM format.
        """
        insecure_skip_verify: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Disable target certificate validation. Defaults to `false`.
        """
        server_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Used to verify the hostname for the targets.
        """
elif False:
    CheckSettingsHttpTlsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsHttpTlsConfigArgs:
    def __init__(__self__, *,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate in PEM format.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate in PEM format.
        :param pulumi.Input[_builtins.str] client_key: Client key in PEM format.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Disable target certificate validation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] server_name: Used to verify the hostname for the targets.
        """
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate in PEM format.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate in PEM format.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client key in PEM format.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable target certificate validation. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to verify the hostname for the targets.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)


if not MYPY:
    class CheckSettingsMultihttpArgsDict(TypedDict):
        entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryArgsDict']]]]
elif False:
    CheckSettingsMultihttpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpArgs:
    def __init__(__self__, *,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryArgs']]]] = None):
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryArgs']]]]:
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryArgs']]]]):
        pulumi.set(self, "entries", value)


if not MYPY:
    class CheckSettingsMultihttpEntryArgsDict(TypedDict):
        assertions: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryAssertionArgsDict']]]]
        """
        Assertions to make on the request response
        """
        request: NotRequired[pulumi.Input['CheckSettingsMultihttpEntryRequestArgsDict']]
        """
        An individual MultiHTTP request
        """
        variables: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryVariableArgsDict']]]]
        """
        Variables to extract from the request response
        """
elif False:
    CheckSettingsMultihttpEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryArgs:
    def __init__(__self__, *,
                 assertions: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryAssertionArgs']]]] = None,
                 request: Optional[pulumi.Input['CheckSettingsMultihttpEntryRequestArgs']] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryVariableArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryAssertionArgs']]] assertions: Assertions to make on the request response
        :param pulumi.Input['CheckSettingsMultihttpEntryRequestArgs'] request: An individual MultiHTTP request
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryVariableArgs']]] variables: Variables to extract from the request response
        """
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter
    def assertions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryAssertionArgs']]]]:
        """
        Assertions to make on the request response
        """
        return pulumi.get(self, "assertions")

    @assertions.setter
    def assertions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryAssertionArgs']]]]):
        pulumi.set(self, "assertions", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['CheckSettingsMultihttpEntryRequestArgs']]:
        """
        An individual MultiHTTP request
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['CheckSettingsMultihttpEntryRequestArgs']]):
        pulumi.set(self, "request", value)

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryVariableArgs']]]]:
        """
        Variables to extract from the request response
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryVariableArgs']]]]):
        pulumi.set(self, "variables", value)


if not MYPY:
    class CheckSettingsMultihttpEntryAssertionArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The type of assertion to make: TEXT, JSON*PATH*VALUE, JSON*PATH*ASSERTION, REGEX_ASSERTION
        """
        condition: NotRequired[pulumi.Input[_builtins.str]]
        """
        The condition of the assertion: NOT*CONTAINS, EQUALS, STARTS*WITH, ENDS*WITH, TYPE*OF, CONTAINS
        """
        expression: NotRequired[pulumi.Input[_builtins.str]]
        """
        The expression of the assertion. Should start with $.
        """
        subject: NotRequired[pulumi.Input[_builtins.str]]
        """
        The subject of the assertion: RESPONSE*HEADERS, HTTP*STATUS*CODE, RESPONSE*BODY
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the assertion
        """
elif False:
    CheckSettingsMultihttpEntryAssertionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryAssertionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The type of assertion to make: TEXT, JSON*PATH*VALUE, JSON*PATH*ASSERTION, REGEX_ASSERTION
        :param pulumi.Input[_builtins.str] condition: The condition of the assertion: NOT*CONTAINS, EQUALS, STARTS*WITH, ENDS*WITH, TYPE*OF, CONTAINS
        :param pulumi.Input[_builtins.str] expression: The expression of the assertion. Should start with $.
        :param pulumi.Input[_builtins.str] subject: The subject of the assertion: RESPONSE*HEADERS, HTTP*STATUS*CODE, RESPONSE*BODY
        :param pulumi.Input[_builtins.str] value: The value of the assertion
        """
        pulumi.set(__self__, "type", type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of assertion to make: TEXT, JSON*PATH*VALUE, JSON*PATH*ASSERTION, REGEX_ASSERTION
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition of the assertion: NOT*CONTAINS, EQUALS, STARTS*WITH, ENDS*WITH, TYPE*OF, CONTAINS
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expression of the assertion. Should start with $.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subject of the assertion: RESPONSE*HEADERS, HTTP*STATUS*CODE, RESPONSE*BODY
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the assertion
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CheckSettingsMultihttpEntryRequestArgsDict(TypedDict):
        method: pulumi.Input[_builtins.str]
        """
        The HTTP method to use
        """
        url: pulumi.Input[_builtins.str]
        """
        The URL for the request
        """
        bodies: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestBodyArgsDict']]]]
        """
        The body of the HTTP request used in probe.
        """
        headers: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestHeaderArgsDict']]]]
        """
        The headers to send with the request
        """
        query_fields: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestQueryFieldArgsDict']]]]
        """
        Query fields to send with the request
        """
elif False:
    CheckSettingsMultihttpEntryRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryRequestArgs:
    def __init__(__self__, *,
                 method: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 bodies: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestBodyArgs']]]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestHeaderArgs']]]] = None,
                 query_fields: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestQueryFieldArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] method: The HTTP method to use
        :param pulumi.Input[_builtins.str] url: The URL for the request
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestBodyArgs']]] bodies: The body of the HTTP request used in probe.
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestHeaderArgs']]] headers: The headers to send with the request
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestQueryFieldArgs']]] query_fields: Query fields to send with the request
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "url", url)
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_fields is not None:
            pulumi.set(__self__, "query_fields", query_fields)

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP method to use
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL for the request
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def bodies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestBodyArgs']]]]:
        """
        The body of the HTTP request used in probe.
        """
        return pulumi.get(self, "bodies")

    @bodies.setter
    def bodies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestBodyArgs']]]]):
        pulumi.set(self, "bodies", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestHeaderArgs']]]]:
        """
        The headers to send with the request
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="queryFields")
    def query_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestQueryFieldArgs']]]]:
        """
        Query fields to send with the request
        """
        return pulumi.get(self, "query_fields")

    @query_fields.setter
    def query_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsMultihttpEntryRequestQueryFieldArgs']]]]):
        pulumi.set(self, "query_fields", value)


if not MYPY:
    class CheckSettingsMultihttpEntryRequestBodyArgsDict(TypedDict):
        content_encoding: NotRequired[pulumi.Input[_builtins.str]]
        """
        The content encoding of the body
        """
        content_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The content type of the body
        """
        payload: NotRequired[pulumi.Input[_builtins.str]]
        """
        The body payload
        """
elif False:
    CheckSettingsMultihttpEntryRequestBodyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryRequestBodyArgs:
    def __init__(__self__, *,
                 content_encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payload: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] content_encoding: The content encoding of the body
        :param pulumi.Input[_builtins.str] content_type: The content type of the body
        :param pulumi.Input[_builtins.str] payload: The body payload
        """
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content encoding of the body
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_encoding", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content type of the body
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The body payload
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class CheckSettingsMultihttpEntryRequestHeaderArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the header to send
        """
        value: pulumi.Input[_builtins.str]
        """
        Value of the header to send
        """
elif False:
    CheckSettingsMultihttpEntryRequestHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryRequestHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Name of the header to send
        :param pulumi.Input[_builtins.str] value: Value of the header to send
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the header to send
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Value of the header to send
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CheckSettingsMultihttpEntryRequestQueryFieldArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Name of the query field to send
        """
        value: pulumi.Input[_builtins.str]
        """
        Value of the query field to send
        """
elif False:
    CheckSettingsMultihttpEntryRequestQueryFieldArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryRequestQueryFieldArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Name of the query field to send
        :param pulumi.Input[_builtins.str] value: Value of the query field to send
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the query field to send
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Value of the query field to send
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class CheckSettingsMultihttpEntryVariableArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The method of finding the variable value to extract. JSON*PATH, REGEX, CSS*SELECTOR
        """
        attribute: NotRequired[pulumi.Input[_builtins.str]]
        """
        The attribute to use when finding the variable value. Only used when type is CSS_SELECTOR
        """
        expression: NotRequired[pulumi.Input[_builtins.str]]
        """
        The expression to when finding the variable. Should start with $. Only use when type is JSON_PATH or REGEX
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the variable to extract
        """
elif False:
    CheckSettingsMultihttpEntryVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsMultihttpEntryVariableArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: The method of finding the variable value to extract. JSON*PATH, REGEX, CSS*SELECTOR
        :param pulumi.Input[_builtins.str] attribute: The attribute to use when finding the variable value. Only used when type is CSS_SELECTOR
        :param pulumi.Input[_builtins.str] expression: The expression to when finding the variable. Should start with $. Only use when type is JSON_PATH or REGEX
        :param pulumi.Input[_builtins.str] name: The name of the variable to extract
        """
        pulumi.set(__self__, "type", type)
        if attribute is not None:
            pulumi.set(__self__, "attribute", attribute)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The method of finding the variable value to extract. JSON*PATH, REGEX, CSS*SELECTOR
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute to use when finding the variable value. Only used when type is CSS_SELECTOR
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attribute", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expression to when finding the variable. Should start with $. Only use when type is JSON_PATH or REGEX
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the variable to extract
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class CheckSettingsPingArgsDict(TypedDict):
        dont_fragment: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set the DF-bit in the IP-header. Only works with ipV4. Defaults to `false`.
        """
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        payload_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Payload size. Defaults to `0`.
        """
        source_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        Source IP address.
        """
elif False:
    CheckSettingsPingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsPingArgs:
    def __init__(__self__, *,
                 dont_fragment: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payload_size: Optional[pulumi.Input[_builtins.int]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] dont_fragment: Set the DF-bit in the IP-header. Only works with ipV4. Defaults to `false`.
        :param pulumi.Input[_builtins.str] ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param pulumi.Input[_builtins.int] payload_size: Payload size. Defaults to `0`.
        :param pulumi.Input[_builtins.str] source_ip_address: Source IP address.
        """
        if dont_fragment is not None:
            pulumi.set(__self__, "dont_fragment", dont_fragment)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if payload_size is not None:
            pulumi.set(__self__, "payload_size", payload_size)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)

    @_builtins.property
    @pulumi.getter(name="dontFragment")
    def dont_fragment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the DF-bit in the IP-header. Only works with ipV4. Defaults to `false`.
        """
        return pulumi.get(self, "dont_fragment")

    @dont_fragment.setter
    def dont_fragment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dont_fragment", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="payloadSize")
    def payload_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Payload size. Defaults to `0`.
        """
        return pulumi.get(self, "payload_size")

    @payload_size.setter
    def payload_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payload_size", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)


if not MYPY:
    class CheckSettingsScriptedArgsDict(TypedDict):
        script: pulumi.Input[_builtins.str]
elif False:
    CheckSettingsScriptedArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsScriptedArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "script", script)

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script", value)


if not MYPY:
    class CheckSettingsTcpArgsDict(TypedDict):
        ip_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        query_responses: NotRequired[pulumi.Input[Sequence[pulumi.Input['CheckSettingsTcpQueryResponseArgsDict']]]]
        """
        The query sent in the TCP probe and the expected associated response.
        """
        source_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        Source IP address.
        """
        tls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        """
        tls_config: NotRequired[pulumi.Input['CheckSettingsTcpTlsConfigArgsDict']]
        """
        TLS config.
        """
elif False:
    CheckSettingsTcpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsTcpArgs:
    def __init__(__self__, *,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 query_responses: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsTcpQueryResponseArgs']]]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_config: Optional[pulumi.Input['CheckSettingsTcpTlsConfigArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param pulumi.Input[Sequence[pulumi.Input['CheckSettingsTcpQueryResponseArgs']]] query_responses: The query sent in the TCP probe and the expected associated response.
        :param pulumi.Input[_builtins.str] source_ip_address: Source IP address.
        :param pulumi.Input[_builtins.bool] tls: Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        :param pulumi.Input['CheckSettingsTcpTlsConfigArgs'] tls_config: TLS config.
        """
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if query_responses is not None:
            pulumi.set(__self__, "query_responses", query_responses)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="queryResponses")
    def query_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsTcpQueryResponseArgs']]]]:
        """
        The query sent in the TCP probe and the expected associated response.
        """
        return pulumi.get(self, "query_responses")

    @query_responses.setter
    def query_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckSettingsTcpQueryResponseArgs']]]]):
        pulumi.set(self, "query_responses", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['CheckSettingsTcpTlsConfigArgs']]:
        """
        TLS config.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['CheckSettingsTcpTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


if not MYPY:
    class CheckSettingsTcpQueryResponseArgsDict(TypedDict):
        expect: pulumi.Input[_builtins.str]
        """
        Response to expect.
        """
        send: pulumi.Input[_builtins.str]
        """
        Data to send.
        """
        start_tls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Upgrade TCP connection to TLS. Defaults to `false`.
        """
elif False:
    CheckSettingsTcpQueryResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsTcpQueryResponseArgs:
    def __init__(__self__, *,
                 expect: pulumi.Input[_builtins.str],
                 send: pulumi.Input[_builtins.str],
                 start_tls: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] expect: Response to expect.
        :param pulumi.Input[_builtins.str] send: Data to send.
        :param pulumi.Input[_builtins.bool] start_tls: Upgrade TCP connection to TLS. Defaults to `false`.
        """
        pulumi.set(__self__, "expect", expect)
        pulumi.set(__self__, "send", send)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)

    @_builtins.property
    @pulumi.getter
    def expect(self) -> pulumi.Input[_builtins.str]:
        """
        Response to expect.
        """
        return pulumi.get(self, "expect")

    @expect.setter
    def expect(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expect", value)

    @_builtins.property
    @pulumi.getter
    def send(self) -> pulumi.Input[_builtins.str]:
        """
        Data to send.
        """
        return pulumi.get(self, "send")

    @send.setter
    def send(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "send", value)

    @_builtins.property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Upgrade TCP connection to TLS. Defaults to `false`.
        """
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_tls", value)


if not MYPY:
    class CheckSettingsTcpTlsConfigArgsDict(TypedDict):
        ca_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        CA certificate in PEM format.
        """
        client_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        Client certificate in PEM format.
        """
        client_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Client key in PEM format.
        """
        insecure_skip_verify: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Disable target certificate validation. Defaults to `false`.
        """
        server_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Used to verify the hostname for the targets.
        """
elif False:
    CheckSettingsTcpTlsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsTcpTlsConfigArgs:
    def __init__(__self__, *,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 server_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ca_cert: CA certificate in PEM format.
        :param pulumi.Input[_builtins.str] client_cert: Client certificate in PEM format.
        :param pulumi.Input[_builtins.str] client_key: Client key in PEM format.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: Disable target certificate validation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] server_name: Used to verify the hostname for the targets.
        """
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CA certificate in PEM format.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client certificate in PEM format.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client key in PEM format.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable target certificate validation. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to verify the hostname for the targets.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_name", value)


if not MYPY:
    class CheckSettingsTracerouteArgsDict(TypedDict):
        max_hops: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum TTL for the trace Defaults to `64`.
        """
        max_unknown_hops: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of hosts to travers that give no response Defaults to `15`.
        """
        ptr_lookup: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Reverse lookup hostnames from IP addresses Defaults to `true`.
        """
elif False:
    CheckSettingsTracerouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CheckSettingsTracerouteArgs:
    def __init__(__self__, *,
                 max_hops: Optional[pulumi.Input[_builtins.int]] = None,
                 max_unknown_hops: Optional[pulumi.Input[_builtins.int]] = None,
                 ptr_lookup: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.int] max_hops: Maximum TTL for the trace Defaults to `64`.
        :param pulumi.Input[_builtins.int] max_unknown_hops: Maximum number of hosts to travers that give no response Defaults to `15`.
        :param pulumi.Input[_builtins.bool] ptr_lookup: Reverse lookup hostnames from IP addresses Defaults to `true`.
        """
        if max_hops is not None:
            pulumi.set(__self__, "max_hops", max_hops)
        if max_unknown_hops is not None:
            pulumi.set(__self__, "max_unknown_hops", max_unknown_hops)
        if ptr_lookup is not None:
            pulumi.set(__self__, "ptr_lookup", ptr_lookup)

    @_builtins.property
    @pulumi.getter(name="maxHops")
    def max_hops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum TTL for the trace Defaults to `64`.
        """
        return pulumi.get(self, "max_hops")

    @max_hops.setter
    def max_hops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_hops", value)

    @_builtins.property
    @pulumi.getter(name="maxUnknownHops")
    def max_unknown_hops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of hosts to travers that give no response Defaults to `15`.
        """
        return pulumi.get(self, "max_unknown_hops")

    @max_unknown_hops.setter
    def max_unknown_hops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_unknown_hops", value)

    @_builtins.property
    @pulumi.getter(name="ptrLookup")
    def ptr_lookup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Reverse lookup hostnames from IP addresses Defaults to `true`.
        """
        return pulumi.get(self, "ptr_lookup")

    @ptr_lookup.setter
    def ptr_lookup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ptr_lookup", value)


