# This file was auto-generated by Fern from our API Definition.

import typing
from .environment import LettaEnvironment
import httpx
from .core.client_wrapper import SyncClientWrapper
from .tools.client import ToolsClient
from .sources.client import SourcesClient
from .agents.client import AgentsClient
from .models.client import ModelsClient
from .blocks.client import BlocksClient
from .jobs.client import JobsClient
from .health.client import HealthClient
from .providers.client import ProvidersClient
from .runs.client import RunsClient
from .steps.client import StepsClient
from .tag.client import TagClient
from .templates.client import TemplatesClient
from .core.client_wrapper import AsyncClientWrapper
from .tools.client import AsyncToolsClient
from .sources.client import AsyncSourcesClient
from .agents.client import AsyncAgentsClient
from .models.client import AsyncModelsClient
from .blocks.client import AsyncBlocksClient
from .jobs.client import AsyncJobsClient
from .health.client import AsyncHealthClient
from .providers.client import AsyncProvidersClient
from .runs.client import AsyncRunsClient
from .steps.client import AsyncStepsClient
from .tag.client import AsyncTagClient
from .templates.client import AsyncTemplatesClient


class LettaBase:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : LettaEnvironment
        The environment to use for requests from the client. from .environment import LettaEnvironment



        Defaults to LettaEnvironment.LETTA_CLOUD



    token : typing.Optional[str]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from letta_client import Letta

    client = Letta(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: LettaEnvironment = LettaEnvironment.LETTA_CLOUD,
        token: typing.Optional[str] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = timeout if timeout is not None else 60 if httpx_client is None else None
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.tools = ToolsClient(client_wrapper=self._client_wrapper)
        self.sources = SourcesClient(client_wrapper=self._client_wrapper)
        self.agents = AgentsClient(client_wrapper=self._client_wrapper)
        self.models = ModelsClient(client_wrapper=self._client_wrapper)
        self.blocks = BlocksClient(client_wrapper=self._client_wrapper)
        self.jobs = JobsClient(client_wrapper=self._client_wrapper)
        self.health = HealthClient(client_wrapper=self._client_wrapper)
        self.providers = ProvidersClient(client_wrapper=self._client_wrapper)
        self.runs = RunsClient(client_wrapper=self._client_wrapper)
        self.steps = StepsClient(client_wrapper=self._client_wrapper)
        self.tag = TagClient(client_wrapper=self._client_wrapper)
        self.templates = TemplatesClient(client_wrapper=self._client_wrapper)


class AsyncLettaBase:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : LettaEnvironment
        The environment to use for requests from the client. from .environment import LettaEnvironment



        Defaults to LettaEnvironment.LETTA_CLOUD



    token : typing.Optional[str]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from letta_client import AsyncLetta

    client = AsyncLetta(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: LettaEnvironment = LettaEnvironment.LETTA_CLOUD,
        token: typing.Optional[str] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = timeout if timeout is not None else 60 if httpx_client is None else None
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.tools = AsyncToolsClient(client_wrapper=self._client_wrapper)
        self.sources = AsyncSourcesClient(client_wrapper=self._client_wrapper)
        self.agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)
        self.models = AsyncModelsClient(client_wrapper=self._client_wrapper)
        self.blocks = AsyncBlocksClient(client_wrapper=self._client_wrapper)
        self.jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        self.health = AsyncHealthClient(client_wrapper=self._client_wrapper)
        self.providers = AsyncProvidersClient(client_wrapper=self._client_wrapper)
        self.runs = AsyncRunsClient(client_wrapper=self._client_wrapper)
        self.steps = AsyncStepsClient(client_wrapper=self._client_wrapper)
        self.tag = AsyncTagClient(client_wrapper=self._client_wrapper)
        self.templates = AsyncTemplatesClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: LettaEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
