# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from ..types.step import Step
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.jsonable_encoder import jsonable_encoder
from ..core.client_wrapper import AsyncClientWrapper


class StepsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_steps(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        start_date: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        model: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Step]:
        """
        List steps with optional pagination and date filters.
        Dates should be provided in ISO 8601 format (e.g. 2025-01-29T15:01:19-08:00)

        Parameters
        ----------
        before : typing.Optional[str]
            Return steps before this step ID

        after : typing.Optional[str]
            Return steps after this step ID

        limit : typing.Optional[int]
            Maximum number of steps to return

        order : typing.Optional[str]
            Sort order (asc or desc)

        start_date : typing.Optional[str]
            Return steps after this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        end_date : typing.Optional[str]
            Return steps before this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        model : typing.Optional[str]
            Filter by the name of the model used for the step

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Step]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            token="YOUR_TOKEN",
        )
        client.steps.list_steps()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/steps",
            method="GET",
            params={
                "before": before,
                "after": after,
                "limit": limit,
                "order": order,
                "start_date": start_date,
                "end_date": end_date,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Step],
                    construct_type(
                        type_=typing.List[Step],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def retrieve_step(self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Step:
        """
        Get a step by ID.

        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Step
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            token="YOUR_TOKEN",
        )
        client.steps.retrieve_step(
            step_id="step_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/steps/{jsonable_encoder(step_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Step,
                    construct_type(
                        type_=Step,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncStepsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_steps(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        start_date: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        model: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Step]:
        """
        List steps with optional pagination and date filters.
        Dates should be provided in ISO 8601 format (e.g. 2025-01-29T15:01:19-08:00)

        Parameters
        ----------
        before : typing.Optional[str]
            Return steps before this step ID

        after : typing.Optional[str]
            Return steps after this step ID

        limit : typing.Optional[int]
            Maximum number of steps to return

        order : typing.Optional[str]
            Sort order (asc or desc)

        start_date : typing.Optional[str]
            Return steps after this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        end_date : typing.Optional[str]
            Return steps before this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        model : typing.Optional[str]
            Filter by the name of the model used for the step

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Step]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.steps.list_steps()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/steps",
            method="GET",
            params={
                "before": before,
                "after": after,
                "limit": limit,
                "order": order,
                "start_date": start_date,
                "end_date": end_date,
                "model": model,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Step],
                    construct_type(
                        type_=typing.List[Step],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def retrieve_step(self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Step:
        """
        Get a step by ID.

        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Step
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.steps.retrieve_step(
                step_id="step_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/steps/{jsonable_encoder(step_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Step,
                    construct_type(
                        type_=Step,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
