# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from .types.templates_create_agents_from_template_response import TemplatesCreateAgentsFromTemplateResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.unchecked_base_model import construct_type
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def createagentsfromtemplate(
        self,
        project: str,
        template_version: str,
        *,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        agent_name: typing.Optional[str] = OMIT,
        memory_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        tool_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesCreateAgentsFromTemplateResponse:
        """
        Creates agents given a template

        Parameters
        ----------
        project : str
            The project slug

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        tags : typing.Optional[typing.Sequence[str]]
            The tags to assign to the agent

        agent_name : typing.Optional[str]
            The name of the agent, optional otherwise a random one will be assigned

        memory_variables : typing.Optional[typing.Dict[str, str]]
            The memory variables to assign to the agent

        tool_variables : typing.Optional[typing.Dict[str, str]]
            The tool variables to assign to the agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesCreateAgentsFromTemplateResponse
            201

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            token="YOUR_TOKEN",
        )
        client.templates.createagentsfromtemplate(
            project="project",
            template_version="template_version",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/templates/{jsonable_encoder(project)}/{jsonable_encoder(template_version)}/agents",
            method="POST",
            json={
                "tags": tags,
                "agent_name": agent_name,
                "memory_variables": memory_variables,
                "tool_variables": tool_variables,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    TemplatesCreateAgentsFromTemplateResponse,
                    construct_type(
                        type_=TemplatesCreateAgentsFromTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def createagentsfromtemplate(
        self,
        project: str,
        template_version: str,
        *,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        agent_name: typing.Optional[str] = OMIT,
        memory_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        tool_variables: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesCreateAgentsFromTemplateResponse:
        """
        Creates agents given a template

        Parameters
        ----------
        project : str
            The project slug

        template_version : str
            The template version, formatted as {template-name}:{version-number} or {template-name}:latest

        tags : typing.Optional[typing.Sequence[str]]
            The tags to assign to the agent

        agent_name : typing.Optional[str]
            The name of the agent, optional otherwise a random one will be assigned

        memory_variables : typing.Optional[typing.Dict[str, str]]
            The memory variables to assign to the agent

        tool_variables : typing.Optional[typing.Dict[str, str]]
            The tool variables to assign to the agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesCreateAgentsFromTemplateResponse
            201

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.createagentsfromtemplate(
                project="project",
                template_version="template_version",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/templates/{jsonable_encoder(project)}/{jsonable_encoder(template_version)}/agents",
            method="POST",
            json={
                "tags": tags,
                "agent_name": agent_name,
                "memory_variables": memory_variables,
                "tool_variables": tool_variables,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    TemplatesCreateAgentsFromTemplateResponse,
                    construct_type(
                        type_=TemplatesCreateAgentsFromTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
