# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
import datetime as dt
from .agent_state_tool_rules_item import AgentStateToolRulesItem
from .agent_type import AgentType
from .llm_config import LlmConfig
from .embedding_config import EmbeddingConfig
from .memory import Memory
from .tool import Tool
from .source import Source
from .agent_environment_variable import AgentEnvironmentVariable
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class AgentState(UncheckedBaseModel):
    """
    Representation of an agent's state. This is the state of the agent at a given time, and is persisted in the DB backend. The state has all the information needed to recreate a persisted agent.

    Parameters:
        id (str): The unique identifier of the agent.
        name (str): The name of the agent (must be unique to the user).
        created_at (datetime): The datetime the agent was created.
        message_ids (List[str]): The ids of the messages in the agent's in-context memory.
        memory (Memory): The in-context memory of the agent.
        tools (List[str]): The tools used by the agent. This includes any memory editing functions specified in `memory`.
        system (str): The system prompt used by the agent.
        llm_config (LLMConfig): The LLM configuration used by the agent.
        embedding_config (EmbeddingConfig): The embedding configuration used by the agent.
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    id: str = pydantic.Field()
    """
    The id of the agent. Assigned by the database.
    """

    name: str = pydantic.Field()
    """
    The name of the agent.
    """

    tool_rules: typing.Optional[typing.List[AgentStateToolRulesItem]] = pydantic.Field(default=None)
    """
    The list of tool rules.
    """

    message_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The ids of the messages in the agent's in-context memory.
    """

    system: str = pydantic.Field()
    """
    The system prompt used by the agent.
    """

    agent_type: AgentType = pydantic.Field()
    """
    The type of agent.
    """

    llm_config: LlmConfig = pydantic.Field()
    """
    The LLM configuration used by the agent.
    """

    embedding_config: EmbeddingConfig = pydantic.Field()
    """
    The embedding configuration used by the agent.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the agent.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The metadata of the agent.
    """

    memory: Memory = pydantic.Field()
    """
    The in-context memory of the agent.
    """

    tools: typing.List[Tool] = pydantic.Field()
    """
    The tools used by the agent.
    """

    sources: typing.List[Source] = pydantic.Field()
    """
    The sources used by the agent.
    """

    tags: typing.List[str] = pydantic.Field()
    """
    The tags associated with the agent.
    """

    tool_exec_environment_variables: typing.Optional[typing.List[AgentEnvironmentVariable]] = pydantic.Field(
        default=None
    )
    """
    The environment variables for tool execution specific to this agent.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the project the agent belongs to.
    """

    template_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the template the agent belongs to.
    """

    base_template_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The base template id of the agent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
