# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class BlockUpdate(UncheckedBaseModel):
    """
    Update a block
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    Value of the block.
    """

    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Character limit of the block.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the block if it is a template.
    """

    is_template: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the block is a template (e.g. saved human/persona options).
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    Label of the block (e.g. 'human', 'persona') in the context window.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the block.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata of the block.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
