# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .function_tool import FunctionTool
from .message import Message
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ContextWindowOverview(UncheckedBaseModel):
    """
    Overview of the context window, including the number of messages and tokens.
    """

    context_window_size_max: int = pydantic.Field()
    """
    The maximum amount of tokens the context window can hold.
    """

    context_window_size_current: int = pydantic.Field()
    """
    The current number of tokens in the context window.
    """

    num_messages: int = pydantic.Field()
    """
    The number of messages in the context window.
    """

    num_archival_memory: int = pydantic.Field()
    """
    The number of messages in the archival memory.
    """

    num_recall_memory: int = pydantic.Field()
    """
    The number of messages in the recall memory.
    """

    num_tokens_external_memory_summary: int = pydantic.Field()
    """
    The number of tokens in the external memory summary (archival + recall metadata).
    """

    external_memory_summary: str = pydantic.Field()
    """
    The metadata summary of the external memory sources (archival + recall metadata).
    """

    num_tokens_system: int = pydantic.Field()
    """
    The number of tokens in the system prompt.
    """

    system_prompt: str = pydantic.Field()
    """
    The content of the system prompt.
    """

    num_tokens_core_memory: int = pydantic.Field()
    """
    The number of tokens in the core memory.
    """

    core_memory: str = pydantic.Field()
    """
    The content of the core memory.
    """

    num_tokens_summary_memory: int = pydantic.Field()
    """
    The number of tokens in the summary memory.
    """

    summary_memory: typing.Optional[str] = pydantic.Field(default=None)
    """
    The content of the summary memory.
    """

    num_tokens_functions_definitions: int = pydantic.Field()
    """
    The number of tokens in the functions definitions.
    """

    functions_definitions: typing.Optional[typing.List[FunctionTool]] = pydantic.Field(default=None)
    """
    The content of the functions definitions.
    """

    num_tokens_messages: int = pydantic.Field()
    """
    The number of tokens in the messages list.
    """

    messages: typing.List[Message] = pydantic.Field()
    """
    The messages in the context window.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
