# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class LettaUsageStatistics(UncheckedBaseModel):
    """
    Usage statistics for the agent interaction.

    Attributes:
        completion_tokens (int): The number of tokens generated by the agent.
        prompt_tokens (int): The number of tokens in the prompt.
        total_tokens (int): The total number of tokens processed by the agent.
        step_count (int): The number of steps taken by the agent.
    """

    message_type: typing.Optional[typing.Literal["usage_statistics"]] = None
    completion_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of tokens generated by the agent.
    """

    prompt_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of tokens in the prompt.
    """

    total_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of tokens processed by the agent.
    """

    step_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of steps taken by the agent.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
