# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .llm_config_model_endpoint_type import LlmConfigModelEndpointType
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class LlmConfig(UncheckedBaseModel):
    """
    Configuration for a Language Model (LLM) model. This object specifies all the information necessary to access an LLM model to usage with Letta, except for secret keys.

    Attributes:
        model (str): The name of the LLM model.
        model_endpoint_type (str): The endpoint type for the model.
        model_endpoint (str): The endpoint for the model.
        model_wrapper (str): The wrapper for the model. This is used to wrap additional text around the input/output of the model. This is useful for text-to-text completions, such as the Completions API in OpenAI.
        context_window (int): The context window size for the model.
        put_inner_thoughts_in_kwargs (bool): Puts `inner_thoughts` as a kwarg in the function call if this is set to True. This helps with function calling performance and also the generation of inner thoughts.
        temperature (float): The temperature to use when generating text with the model. A higher temperature will result in more random text.
        max_tokens (int): The maximum number of tokens to generate.
    """

    model: str = pydantic.Field()
    """
    LLM model name. 
    """

    model_endpoint_type: LlmConfigModelEndpointType = pydantic.Field()
    """
    The endpoint type for the model.
    """

    model_endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    The endpoint for the model.
    """

    model_wrapper: typing.Optional[str] = pydantic.Field(default=None)
    """
    The wrapper for the model.
    """

    context_window: int = pydantic.Field()
    """
    The context window size for the model.
    """

    put_inner_thoughts_in_kwargs: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Puts 'inner_thoughts' as a kwarg in the function call if this is set to True. This helps with function calling performance and also the generation of inner thoughts.
    """

    handle: typing.Optional[str] = pydantic.Field(default=None)
    """
    The handle for this config, in the format provider/model-name.
    """

    temperature: typing.Optional[float] = pydantic.Field(default=None)
    """
    The temperature to use when generating text with the model. A higher temperature will result in more random text.
    """

    max_tokens: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of tokens to generate. If not set, the model will use its default value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
