# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
from .block import Block
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Memory(UncheckedBaseModel):
    """
    Represents the in-context memory (i.e. Core memory) of the agent. This includes both the `Block` objects (labelled by sections), as well as tools to edit the blocks.
    """

    blocks: typing.List[Block] = pydantic.Field()
    """
    Memory blocks contained in the agent's in-context memory
    """

    prompt_template: typing.Optional[str] = pydantic.Field(default=None)
    """
    Jinja2 template for compiling memory blocks into a prompt string
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
