# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
import datetime as dt
from .embedding_config import EmbeddingConfig
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Passage(UncheckedBaseModel):
    """
    Representation of a passage, which is stored in archival memory.

    Parameters:
        text (str): The text of the passage.
        embedding (List[float]): The embedding of the passage.
        embedding_config (EmbeddingConfig): The embedding configuration used by the passage.
        created_at (datetime): The creation date of the passage.
        user_id (str): The unique identifier of the user associated with the passage.
        agent_id (str): The unique identifier of the agent associated with the passage.
        source_id (str): The data source of the passage.
        file_id (str): The unique identifier of the file associated with the passage.
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The creation date of the passage.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    is_deleted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this passage is deleted or not.
    """

    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the agent associated with the passage.
    """

    source_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The data source of the passage.
    """

    file_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the file associated with the passage.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The metadata of the passage.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Passage
    """

    text: str = pydantic.Field()
    """
    The text of the passage.
    """

    embedding: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    The embedding of the passage.
    """

    embedding_config: typing.Optional[EmbeddingConfig] = pydantic.Field(default=None)
    """
    The embedding configuration used by the passage.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
