# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Provider(UncheckedBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the provider, lazily created by the database manager.
    """

    name: str = pydantic.Field()
    """
    The name of the provider
    """

    api_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    API key used for requests to the provider.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The last update timestamp of the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
