# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
import datetime as dt
from .job_status import JobStatus
from .job_type import JobType
from .letta_request_config import LettaRequestConfig
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Run(UncheckedBaseModel):
    """
    Representation of a run, which is a job with a 'run' prefix in its ID.
    Inherits all fields and behavior from Job except for the ID prefix.

    Parameters:
        id (str): The unique identifier of the run (prefixed with 'run-').
        status (JobStatus): The status of the run.
        created_at (datetime): The unix timestamp of when the run was created.
        completed_at (datetime): The unix timestamp of when the run was completed.
        user_id (str): The unique identifier of the user associated with the run.
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this object.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was last updated.
    """

    status: typing.Optional[JobStatus] = pydantic.Field(default=None)
    """
    The status of the job.
    """

    completed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The unix timestamp of when the job was completed.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The metadata of the job.
    """

    job_type: typing.Optional[JobType] = None
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Run
    """

    request_config: typing.Optional[LettaRequestConfig] = pydantic.Field(default=None)
    """
    The request configuration for the run.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
