# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import datetime as dt
import typing
from .system_message_content import SystemMessageContent
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class SystemMessage(UncheckedBaseModel):
    """
    A message generated by the system. Never streamed back on a response, only used for cursor pagination.

    Attributes:
        content (Union[str, List[MessageContentUnion]]): The message content sent by the user (can be a string or an array of content parts)
        id (str): The ID of the message
        date (datetime): The date the message was created in ISO format
    """

    id: str
    date: dt.datetime
    message_type: typing.Literal["system_message"] = "system_message"
    content: SystemMessageContent

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
