# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ToolCreate(UncheckedBaseModel):
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the tool.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Metadata tags.
    """

    source_code: str = pydantic.Field()
    """
    The source code of the function.
    """

    source_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The source type of the function.
    """

    json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The JSON schema of the function (auto-generated from source_code if not provided)
    """

    return_char_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of characters in the response.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
